from django.contrib import admin     # noqa

from main.models import SubCategory, SubCategoryLayer # noqa
from main.lib.backend import get_user_groups   # noqa

from main.models import AreaLayer


class SubCategoryLayerInline(admin.StackedInline):
    model = SubCategoryLayer
    min_num = 0
    extra = 0

    def has_change_permission(self, request, obj=None):
        return False

    def formfield_for_foreignkey(self, db_field, request, **kwargs):
        # reduce queryset to layers of the area
        if db_field.name == "layer" and 'object_id' in request.resolver_match.kwargs:
            sub_category = SubCategory.objects.get(id=request.resolver_match.kwargs['object_id'])
            kwargs["queryset"] = AreaLayer.objects.filter(area__id=sub_category.category.area.id)

        return super().formfield_for_foreignkey(db_field, request, **kwargs)


class SubCategoryAdmin(admin.ModelAdmin):
    model = SubCategory
    inlines = [SubCategoryLayerInline]
    list_display = ('name_de', 'category',)
    min_num = 0
    extra = 0

    fieldsets = [
        (None, {
            'fields': (('name_de', 'name_en'), 'category'),
        }),
    ]

    def get_readonly_fields(self, request, obj):
        if obj:
            if obj.category:
                return ['category']
        return []

    def get_queryset(self, request):
        # if not superuser, a user can see only see Categories from his areas/projects
        qs = super().get_queryset(request)

        if request.user.is_superuser:
            return qs
        return qs.filter(category__area__project__bucket__group__in=get_user_groups(request))
