from django.contrib import admin    # noqa
from django.template.response import TemplateResponse   # noqa

from main.views.download_requests import get_download_page  # noqa


class BasicAdminSite(admin.AdminSite):
    def about(self, request):
        return TemplateResponse(request, "admin/about.html", {})

    def get_download_overview(self, request, record_id, page_number: int = 0):
        return get_download_page(request, record_id, page_number)


basic_site = BasicAdminSite()
basic_site.enable_nav_sidebar = False