"""
Django settings for gdi-admin project.

Generated by 'django-admin startproject' using Django 4.0.3.

For more information on this file, see
https://docs.djangoproject.com/en/4.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/4.0/ref/settings/
"""

import os

from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/4.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = os.environ.get('DJANGO_SECRET_KEY', 'django-insecure-4q1^w=)berg)5%#o0ow_lrob^4s@_46ldgs8k57f4q#aap^l!n')

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = os.environ.get('DJANGO_DEBUG', False)

ALLOWED_HOSTS = ['localhost', 'web.app.ufz.de', 'host.docker.internal', *os.environ.get('DJANGO_ALLOWED_HOSTS', '').split(',')]

# Application definition

INSTALLED_APPS = [
    'django_static_jquery_ui',
    'django_tabbed_changeform_admin',
    'main.apps.MainConfig',
    'health_check.apps.HealthCheckConfig',
    'metadata.apps.MetadataConfig',
    'data_import.apps.DataImportConfig',
    'drawing_tool.apps.DrawingToolConfig',
    "admin_interface",
    'nested_admin',
    "colorfield",
    "corsheaders",
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]



# admin interface variables
X_FRAME_OPTIONS = "SAMEORIGIN"
SILENCED_SYSTEM_CHECKS = ["security.W019"]

MIDDLEWARE = [
    "corsheaders.middleware.CorsMiddleware",
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'gdi-admin.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'gdi-admin.wsgi.application'


# Database
# https://docs.djangoproject.com/en/4.0/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': os.environ.get('POSTGRES_DB'),
        'USER': os.environ.get('POSTGRES_USER'),
        'PASSWORD': os.environ.get('POSTGRES_PASSWORD'),
        'HOST': os.environ.get('POSTGRES_HOST'),
        'PORT': 5432,
        'OPTIONS': {'sslmode': os.environ.get('POSTGRES_SSLMODE')},
    },
    "geoserver": {
        'ENGINE': 'django.db.backends.postgresql',
        "NAME": os.environ.get('GEOSERVER_POSTGRES_DB'),
        "USER": os.environ.get('GEOSERVER_POSTGRES_USERNAME'),
        "PASSWORD": os.environ.get('GEOSERVER_POSTGRES_PASSWORD'),
        'HOST': os.environ.get('POSTGRES_HOST'),
        'PORT': 5432,
        'OPTIONS': {'sslmode': os.environ.get('POSTGRES_SSLMODE')},
    }
}


# Password validation
# https://docs.djangoproject.com/en/4.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/4.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = os.environ.get("TZ", "Europe/Berlin")

USE_I18N = True

USE_TZ = False  # use UTC-time in database (naive) and only show date with timezone in admin-frontend

USE_L10N = False

DATETIME_FORMAT = "d.m.Y H:i:s"


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/4.0/howto/static-files/

STATIC_URL = 'gdi-backend/static/'
STATIC_ROOT = '/code/static/'


STATICFILES_DIRS = [
    "main/static"
]

# Default primary key field type
# https://docs.djangoproject.com/en/4.0/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

CORS_ALLOW_ALL_ORIGINS = True
CORS_ALLOW_CREDENTIALS = True

CSRF_TRUSTED_ORIGINS = [
    'https://web.app.ufz.de',
    'http://localhost:5001',
    *map(lambda host: f"https://{host}", os.environ.get('DJANGO_ALLOWED_HOSTS', '').split(','))
]

DATA_UPLOAD_MAX_NUMBER_FIELDS = 5000