import json

from django.http import JsonResponse    # noqa
from django.views.decorators.csrf import csrf_exempt    # noqa TODO: change this

from drawing_tool.models import ObjectProperty, PropertyConstraint, ConstraintElement   # noqa


@csrf_exempt
def validate_object(request, locale, object_id: int):

    errors = {}

    data = json.loads(request.body)

    fields = dict(data)['fields']

    for prop in ObjectProperty.objects.filter(object=object_id):

        field_value = fields[prop.variable]

        if prop.property_type in ('integer', 'decimal'):
            if prop.min_value:
                if field_value < prop.min_value:
                    msg = 'Wert muss größer sein als {}.' if locale == 'de' else 'Value must be greater than {}.'
                    errors[prop.variable] = msg.format(prop.min_value)
            if prop.max_value:
                if field_value > prop.max_value:
                    msg = 'Wert muss kleiner sein als {}.' if locale == 'de' else 'Value must be less than {}.'
                    errors[prop.variable] = msg.format(prop.max_value)

            for constraint in PropertyConstraint.objects.filter(property=prop):
                equation = _get_equation(fields, constraint)

                if not _is_equation_true(equation):
                    errors[prop.variable] = constraint.message_de if locale == "de" else constraint.message_en

    if errors:
        return JsonResponse({'errors': errors}, status=400)
    else:
        return JsonResponse({'message': '', 'success': True, 'result': {}})


def _get_equation(fields, constraint: PropertyConstraint):
    result = ""
    for part in ConstraintElement.objects.filter(constraint=constraint).order_by('position'):

        if part.obj_value:
            result += str(fields[part.obj_value.variable])
        else:
            if part.num_value:
                result += str(part.num_value)
            if part.operand:
                result += str(part.operand)
            if part.bracket:
                result += str(part.bracket)

    return result


def _is_equation_true(equation: str):

    lower_than, greater_than = None, None

    lower_than = equation.find('<')
    if not lower_than:
        greater_than = equation.find('<')

    index = greater_than if greater_than else lower_than

    term1 = equation[:index]
    negative_range = -1 * (len(equation) - index - 1)

    term2 = equation[negative_range:]

    try:
        if greater_than:
            return eval(term1) > eval(term2)
        else:
            return eval(term1) < eval(term2)

    except ZeroDivisionError:
        print(f"Error - Divide by 0: {term1} {equation[index]} {term2}")
        return False
