# Generated by Django 4.2.23 on 2025-09-03 14:52

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('main', '0063_geojsonlayer_shp_file_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='DrawingTool',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=100)),
                ('name_en', models.CharField(max_length=100)),
                ('max_num_per_user', models.PositiveIntegerField(default=5)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.project')),
            ],
        ),
        migrations.CreateModel(
            name='Object',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=100)),
                ('name_en', models.CharField(max_length=100)),
                ('image', models.URLField(blank=True, max_length=4000, null=True)),
                ('max_num', models.PositiveIntegerField(default=20)),
                ('type', models.CharField(choices=[('Point', 'Point'), ('Polygon', 'Polygon')], max_length=20)),
                ('min_dist', models.DecimalField(blank=True, decimal_places=7, max_digits=12, null=True)),
                ('max_dist', models.DecimalField(blank=True, decimal_places=7, max_digits=12, null=True)),
                ('max_area', models.DecimalField(blank=True, decimal_places=7, max_digits=12, null=True)),
                ('drawing_tool', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drawing_tool.drawingtool')),
            ],
        ),
        migrations.CreateModel(
            name='ObjectProperty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('variable', models.CharField(max_length=1)),
                ('name_de', models.CharField(max_length=100)),
                ('name_en', models.CharField(max_length=100)),
                ('property_type', models.CharField(choices=[('text', 'free Text-Field'), ('integer', 'integer field'), ('decimal', 'decimal field'), ('dropdown', 'list of options')], max_length=20)),
                ('min_value', models.IntegerField(blank=True, null=True)),
                ('max_value', models.IntegerField(blank=True, null=True)),
                ('default_value', models.IntegerField(blank=True, null=True)),
                ('options', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=100), blank=True, default=list, null=True, size=None)),
                ('unit', models.CharField(blank=True, max_length=5, null=True)),
                ('object', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drawing_tool.object')),
            ],
        ),
        migrations.CreateModel(
            name='PropertyConstraint',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message_de', models.CharField(max_length=1000)),
                ('message_en', models.CharField(max_length=1000)),
                ('property', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drawing_tool.objectproperty')),
            ],
        ),
        migrations.CreateModel(
            name='ConstraintElement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveIntegerField()),
                ('num_value', models.DecimalField(blank=True, decimal_places=7, max_digits=12, null=True)),
                ('operand', models.CharField(blank=True, choices=[('+', '+'), ('-', '-'), ('*', '*'), ('/', '/'), ('<', '<'), ('>', '>')], max_length=1, null=True)),
                ('bracket', models.CharField(blank=True, choices=[('(', '('), (')', ')')], max_length=1, null=True)),
                ('constraint', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drawing_tool.propertyconstraint')),
                ('obj_value', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='drawing_tool.objectproperty')),
            ],
        ),
    ]
