from django.contrib import admin  # noqa
from django import forms # noqa

from drawing_tool.models import Object, ObjectProperty  # noqa

from main.lib.backend import get_user_groups    # noqa


class ObjectPropertyAdmin(admin.ModelAdmin):
    model = ObjectProperty
    list_display = ('__str__', 'object', 'variable')
    fieldsets = [
        (
            None,
            {
                "fields": ("object", ("name_de", "name_en"), "variable", "unit", "property_type", ("default_value", "min_value", "max_value"), "options"),
            },
        ),
    ]

    def formfield_for_foreignkey(self, db_field, request, **kwargs):

        if not request.user.is_superuser:
            # if not superuser, a user can only select his projects
            if db_field.name == "object":
                kwargs["queryset"] = Object.objects.filter(
                    drawing_tool__project__bucket__group__id__in=get_user_groups(request)
                )

        return super().formfield_for_foreignkey(db_field, request, **kwargs)
