from django.contrib import admin  # noqa
from django import forms # noqa
from django_tabbed_changeform_admin.admin import DjangoTabbedChangeformAdmin    # noqa

from drawing_tool.models import DrawingTool, Object, ObjectProcess  # noqa

from main.lib.backend import get_user_groups    # noqa


class ObjectProcessInline(admin.StackedInline):
    model = ObjectProcess
    extra = 1
    classes = ["tab-process-inline"]


class ObjectAdmin(DjangoTabbedChangeformAdmin):
    model = Object
    inlines = [ObjectProcessInline]
    list_display = ('__str__', 'drawing_tool')
    fieldsets = [
        (
            None,
            {
                "fields": (
                    "drawing_tool",
                    ("name_de", "name_en"),
                    "type",
                    "image",
                ),
                "classes": ("tab-basic",),
            },
        ),
        (
            None,
            {
                "fields": (
                    "max_num",
                    ("min_dist", "max_dist"),
                    ("min_area", "max_area")
                ),
                "classes": ("tab-limits",),
            },
        ),
    ]

    tabs = [
        ("Basic Information", ["tab-basic"]),
        ("Limits", ["tab-limits"]),
        ("Processes", ["tab-process-inline"]),
    ]

    def formfield_for_foreignkey(self, db_field, request, **kwargs):

        if not request.user.is_superuser:
            # if not superuser, a user can only select his projects
            if db_field.name == "drawing_tool":
                kwargs["queryset"] = DrawingTool.objects.filter(
                    project__bucket__group__id__in=get_user_groups(request)
                )

        return super().formfield_for_foreignkey(db_field, request, **kwargs)
