from django.contrib import admin  # noqa
from django import forms # noqa

from drawing_tool.models import DrawingTool  # noqa
from main.models import Project    # noqa
from main.lib.backend import get_user_groups    # noqa


class DrawingToolForm(forms.ModelForm):

    def clean(self):
        cleaned_data = super().clean()
        is_active = cleaned_data.get("is_active")
        project_id = cleaned_data.get("project")

        for tool in DrawingTool.objects.filter(project=project_id):
            if self.instance.pk == tool.id:
                continue
            if is_active and tool.project == project_id and tool.is_active:
                self.add_error("is_active", "There is already another active drawing tool for this project.")


class DrawingToolAdmin(admin.ModelAdmin):
    model = DrawingTool
    form = DrawingToolForm
    list_display = ('__str__', 'project', 'is_active')
    fieldsets = [
        (
            None,
            {
                "fields": (
                    "project",
                    ("name_de", "name_en"),
                    ("group_label_de", "group_label_en"),
                    ("submit_label_de", "submit_label_en"),
                    "max_num_per_user",
                    "is_active"
                ),
            },
        ),
    ]

    def formfield_for_foreignkey(self, db_field, request, **kwargs):

        if not request.user.is_superuser:
            # if not superuser, a user can only select his projects
            if db_field.name == "project":
                kwargs["queryset"] = Project.objects.filter(
                    bucket__group__id__in=get_user_groups(request)
                )

        return super().formfield_for_foreignkey(db_field, request, **kwargs)
