# Generated by Django 4.2.13 on 2024-09-30 09:25

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('main', '0034_remove_metadatarecord_bucket_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='CsvImportJob',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('s3_file', models.CharField(max_length=1000)),
                ('is_processed', models.BooleanField(default=False)),
                ('is_running', models.BooleanField(default=False)),
                ('is_success', models.BooleanField(default=False)),
                ('execution_time', models.CharField(blank=True, max_length=1000, null=True)),
                ('file_size', models.IntegerField(blank=True, null=True)),
                ('num_rows', models.IntegerField(blank=True, null=True)),
                ('validation_error', models.CharField(blank=True, max_length=4000, null=True)),
                ('data_points_created', models.IntegerField(blank=True, null=True)),
                ('data_points_failed', models.IntegerField(blank=True, null=True)),
                ('is_data_deleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('bucket', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.bucket')),
            ],
            options={
                'verbose_name': 'CSV-Import-Job',
                'verbose_name_plural': 'CSV-Import-Jobs',
            },
        ),
        migrations.CreateModel(
            name='CsvParser',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lat_col_num', models.IntegerField()),
                ('lon_col_num', models.IntegerField()),
                ('station_col_num', models.IntegerField()),
                ('property_col_num', models.IntegerField()),
                ('value_col_num', models.IntegerField()),
                ('unit_col_num', models.IntegerField()),
                ('time_col_num', models.IntegerField()),
            ],
            options={
                'verbose_name': 'CSV-Parser',
                'verbose_name_plural': 'CSV-Parser',
            },
        ),
        migrations.CreateModel(
            name='PointData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('thing_name', models.CharField(max_length=1000)),
                ('location_name', models.CharField(max_length=1000)),
                ('coord_lat', models.CharField(blank=True, max_length=1000, null=True)),
                ('coord_lon', models.CharField(blank=True, max_length=1000, null=True)),
                ('property', models.CharField(max_length=1000)),
                ('sensor', models.CharField(blank=True, max_length=1000, null=True)),
                ('result_value', models.CharField(blank=True, max_length=100, null=True)),
                ('result_unit', models.CharField(blank=True, max_length=100, null=True)),
                ('result_time', models.CharField(blank=True, max_length=100, null=True)),
                ('validation_error', models.CharField(blank=True, max_length=4000, null=True)),
                ('is_scheduled', models.BooleanField(default=False)),
                ('import_job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data_import.csvimportjob')),
            ],
            options={
                'verbose_name': 'Point-Data',
                'verbose_name_plural': 'Point-Data',
            },
        ),
        migrations.CreateModel(
            name='ExtendedPointData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('related_entity', models.CharField(choices=[('thing', 'thing'), ('property', 'property'), ('observation', 'observation')], default='thing', max_length=20)),
                ('name', models.CharField(max_length=100)),
                ('value', models.CharField(max_length=1000)),
                ('point_data', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data_import.pointdata')),
            ],
            options={
                'verbose_name': 'Additional Value',
                'verbose_name_plural': 'Additional Values',
            },
        ),
        migrations.CreateModel(
            name='CsvParserExtraColumn',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('related_entity', models.CharField(choices=[('thing', 'thing'), ('property', 'property'), ('observation', 'observation')], default='thing', max_length=20)),
                ('col_num', models.IntegerField()),
                ('col_name', models.CharField(max_length=100)),
                ('parser', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data_import.csvparser')),
            ],
        ),
        migrations.CreateModel(
            name='CsvIncludeCriteria',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('col_num', models.IntegerField()),
                ('text_value', models.CharField(max_length=100)),
                ('parser', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data_import.csvparser')),
            ],
        ),
    ]
