#!/bin/bash
# Run this script at the root of the Sui codebase, after applying the patch.
# See README.md for more instructions

git restore Cargo.lock

SIMTEST_STATIC_INIT_MOVE="$(pwd)/examples/move/basics" \
cargo nextest run test_mysticeti_liveness \
--package path+file://$(pwd)/consensus/simtests#consensus-simtests@0.1.0 \
--cargo-profile simulator \
--config 'build.rustflags = ["--cfg","msim"]' \
--config 'patch.crates-io.tokio.git = "https://github.com/MystenLabs/mysten-sim.git"' \
--config 'patch.crates-io.tokio.rev = "e06fc6fa9aeb978ffc621f8b27c06a404042279f"' \
--config 'patch.crates-io.futures-timer.git = "https://github.com/MystenLabs/mysten-sim.git"' \
--config 'patch.crates-io.futures-timer.rev = "e06fc6fa9aeb978ffc621f8b27c06a404042279f"' \
--config 'patch.crates-io.blst.git = "https://github.com/MystenLabs/mock-blst.git"' \
--config 'patch.crates-io.blst.rev = "630ca4d55de8e199e62c5b6a695c702d95fe6498"' \
--nocapture
