(* In this file we define the commands that the client can invoke *)

Section ClientCommand.
  Inductive ClientCmd : Set :=
  | Idle
  | Pull (n : nat)
  | Invoke (n : nat) (ver : nat) (data : nat)
  | Push (n : nat) (ver : nat).

  Definition cmd_time (cmd : ClientCmd) := match cmd with
  | Idle => 0
  | Pull n => n
  | Invoke n v d => n
  | Push n v => n
  end.
End ClientCommand.
