From Coq Require Import
  List
  PeanoNat
  Peano_dec
  Lia
  Compare_dec.
From advert.lib Require Import
  Maps.
Import ListNotations.

Section Label.
  Definition Label : Type := nat * nat.

  Lemma lbl_eq_dec : forall (x y : Label), {x = y} + {x <> y}.
  Proof. intros x y. destruct x as [a b]; destruct y as [c d]; destruct (eq_nat_dec a c); [subst c|]; destruct (eq_nat_dec b d); [subst d | | subst d |].
         1: left; easy. all: right; intro Heq; inversion Heq; contradiction.
  Qed.

End Label.

Section LabelMap.
  Definition LabelMap := ListMap Label.
  Definition LabelMap_add {U : Type} (x : Label) (y : U) := list_map_add x y.
  Definition LabelMap_find {U : Type} x (m : ListMap Label U) := list_map_find lbl_eq_dec x m.
  Definition LabelMap_empty (U : Type) := list_map_empty Label U.

  Lemma LabelMap_gse : forall {T : Type} nmap r r' (e : T), r = r' -> LabelMap_find r' (LabelMap_add r e nmap) = Some e.
  Proof. unfold LabelMap_find. unfold LabelMap_add. apply list_map_gse. Qed.
  Lemma LabelMap_gso : forall {T : Type} nmap r r' (e : T), r <> r' -> LabelMap_find r' (LabelMap_add r e nmap) = LabelMap_find r' nmap.
  Proof. unfold LabelMap_find. unfold LabelMap_add. apply list_map_gso. Qed.
End LabelMap.

Ltac LabelMap_rwe a b := repeat (match goal with |- context[LabelMap_find a (LabelMap_add b ?e ?nmap)] => replace (LabelMap_find a (LabelMap_add b e nmap)) with (Some e) by (rewrite LabelMap_gse; auto) end).

(*
Lemma LabelMap_rwe_test : forall x y (e : Label) nmap, x = y -> LabelMap_find x (LabelMap_add y e nmap) = Some e.
Proof. intros x y e nmap Heq. LabelMap_rwe x y. easy. Qed.
*)

Ltac LabelMap_rwo a b := repeat (match goal with |- context[LabelMap_find a (LabelMap_add b ?e ?nmap)] => replace (LabelMap_find a (LabelMap_add b e nmap)) with (LabelMap_find a nmap) by (rewrite LabelMap_gso; auto) end).

(*
Lemma LabelMap_rwo_test : forall x y (e : Label) nmap, x <> y -> LabelMap_find x (LabelMap_add y e nmap) = LabelMap_find x nmap.
Proof. intros x y e nmap Heq. LabelMap_rwo x y. easy. Qed.
*)

Ltac LabelMap_case a b := destruct (lbl_eq_dec a b); [subst a; LabelMap_rwe b b | LabelMap_rwo a b].
Ltac LabelMap_cmp a b := destruct (lbl_eq_dec a b); [LabelMap_rwe a b | LabelMap_rwo a b].

Section LabelCmp.
  Definition lbl_le (x y : Label) := (fst x < fst y) \/ (fst x = fst y /\ snd x <= snd y).

  Lemma lbl_le_trans (x y z : Label) : lbl_le x y -> lbl_le y z -> lbl_le x z.
  Proof. unfold lbl_le. lia. Qed.

  Lemma lbl_le_refl (x : Label) : lbl_le x x.
  Proof. unfold lbl_le. lia. Qed.

  Lemma lbl_le_anti (x y : Label) : ~ lbl_le x y -> lbl_le y x.
  Proof. unfold lbl_le. lia. Qed.

  Lemma lbl_le_dec (x y : Label) : {lbl_le x y} + {~ lbl_le x y}.
  Proof. unfold lbl_le. destruct (lt_eq_lt_dec (fst x) (fst y)); [destruct s|]. 1: left; left; easy. 2: right; lia. destruct (le_lt_dec (snd x) (snd y)). 1: left; lia. right; lia. Qed.

  Lemma lbl_le_anti_refl (x y : Label) : lbl_le x y -> lbl_le y x -> x = y.
  Proof. destruct x as [a b]; destruct y as [c d]. unfold lbl_le; cbn; intros Hle1 Hle2. assert (a = c) by lia; subst c. assert (b = d) by lia; subst d. easy. Qed.

  Lemma lbl_min (x : Label) : lbl_le (0, 0) x.
  Proof. unfold lbl_le. cbn. lia. Qed.

  Fixpoint max_by_lbl {T : Type} (f : T -> Label) (d : T) (l : list T) := match l with
  | [] => d
  | x :: xs => let y := max_by_lbl f d xs in if lbl_le_dec (f y) (f x) then x else y
  end.

  Lemma max_by_lbl_in {T : Type} : forall f d (l : list T), (f d) = (0, 0) -> (exists x, In x l) -> In (max_by_lbl f d l) l.
  Proof. intros f d l Hmin. revert l. induction l.
         - cbn. intro Hfalse. destruct Hfalse as (_ & Hfalse); contradiction.
         - intros _. destruct l.
           + cbn. left. rewrite Hmin. pose proof (lbl_min (f a)) as Hmin'.
             match goal with |- context[if ?p then _ else _] => destruct p end. 1: easy. contradiction.
           + specialize (IHl ltac:(eexists; left; easy)). unfold max_by_lbl. fold (max_by_lbl f d (t :: l)). remember (max_by_lbl f d (t :: l)) as u.
             match goal with |- context[if ?p then _ else _] => destruct p end. 1: left; easy. right; auto.
  Qed.

  Lemma max_by_lbl_max {T : Type} : forall f d (l : list T) x, In x l -> lbl_le (f x) (f (max_by_lbl f d l)).
  Proof. intros f d. induction l. 1: cbn; contradiction.
         cbn. intros x Hx. destruct Hx as [Hx | Hx]; [subst x|].
         - match goal with |- context[if ?p then _ else _] => destruct p end. 1: apply lbl_le_refl. apply lbl_le_anti; auto.
         - specialize (IHl _ Hx). match goal with |- context[if ?p then _ else _] => destruct p end. 2: auto. eapply lbl_le_trans. 1: apply IHl. auto.
  Qed.

  Definition lbl_lt (x y : Label) := (fst x < fst y) \/ (fst x = fst y /\ snd x < snd y).

  Lemma lbl_lt_iff_le_neq (x y : Label) : lbl_lt x y <-> lbl_le x y /\ x <> y.
  Proof. unfold lbl_lt, lbl_le. destruct x as [a b]; destruct y as [c d]; cbn.
         assert (Hneq : (a, b) <> (c, d) <-> a <> c \/ b <> d).
         { split.
           - intro. destruct (eq_nat_dec a c); destruct (eq_nat_dec b d); auto.
           - intros Hneq Heq. inversion Heq; subst; destruct Hneq; auto.
         }
         rewrite Hneq. lia.
  Qed.

  Lemma lbl_lt_dec (x y : Label) : {lbl_lt x y} + {~ lbl_lt x y}.
  Proof. destruct (lbl_le_dec x y).
         - destruct (lbl_eq_dec x y).
           + right. rewrite lbl_lt_iff_le_neq. intro Hlt; destruct Hlt; contradiction.
           + left. rewrite lbl_lt_iff_le_neq. split; auto.
         - right. rewrite lbl_lt_iff_le_neq. intro Hlt; destruct Hlt; contradiction.
  Qed.

End LabelCmp.
