From Coq Require Import
  List
  PeanoNat
  Lia
  Peano_dec.
From advert.lib Require Import
  Maps
  Semantics
  Coqlib
  FastMaps
  Decision.

Lemma proj_sumbool_eq_true : forall [P : Prop] (a : {P} + {~P}), proj_sumbool a = true <-> P.
Proof. intros P a. destruct a; split; cbn; auto; intros; discriminate. Qed.
Lemma proj_sumbool_eq_false : forall [P : Prop] (a : {P} + {~P}), proj_sumbool a = false <-> ~P.
Proof. intros P a. destruct a; split; cbn; auto; intros; try discriminate; try contradiction. Qed.
Ltac arith_simpl u := repeat (try (rewrite Bool.andb_true_iff in u); try (rewrite Bool.andb_false_iff in u); try (rewrite Nat.ltb_ge in u); try (rewrite Nat.ltb_lt in u); try (rewrite Nat.leb_le in u); try (rewrite Nat.leb_gt in u); try (rewrite Nat.eqb_eq in u); try (rewrite Nat.eqb_neq in u); try (rewrite proj_sumbool_eq_true in u); try (rewrite proj_sumbool_eq_false in u)).
Ltac cond_case_auto H := repeat (match type of H with | context[if ?p then _ else _] => let u := fresh "p" in destruct p eqn:u; cond_case_auto u; arith_simpl u | context[match ?x with _ => _ end] => let u := fresh "Ex" in destruct x eqn:u; arith_simpl H end).
Ltac natmap_auto_cmp := match goal with |- context[NatMap_find ?x (NatMap_add ?y _ _)] => NatMap_cmp x y end.
