From advert.lib Require Import
  Coqlib
  FastMaps.

Module NatIndexed.
  Definition t := nat.
  Definition index (n : nat) : positive := Pos.of_nat (S n).
  Lemma index_inj : forall (x y : nat), index x = index y -> x = y.
  Proof. unfold index; intros x y Heq; apply Nat2Pos.inj in Heq; auto. Qed.
  Definition eq := Nat.eq_dec.
End NatIndexed.

Module FastNatMap := IMap NatIndexed.

Extract Inlined Constant Pos.of_nat => "(fun n -> n)".
