# TaylorSeries.jl

A [Julia](http://julialang.org) package for Taylor expansions in one or more independent variables.

---

### Authors

- [Luis Benet](http://www.cicc.unam.mx/~benet/), Instituto de Ciencias
    Físicas, Universidad Nacional Autónoma de México (UNAM).
- [David P. Sanders](http://sistemas.fciencias.unam.mx/~dsanders/), Facultad
    de Ciencias, Universidad Nacional Autónoma de México (UNAM).

### Citing

If you find useful this package, please cite the paper:

Benet, L., & Sanders, D. P. (2019). TaylorSeries.jl: Taylor expansions in one and several variables in Julia. Journal of Open Source Software, 4(36), 1–4. https://doi.org/10.5281/zenodo.2601941

### License

TaylorSeries is licensed under the MIT "Expat" license; see
[LICENSE](https://github.com/lbenet/TaylorSeries.jl/blob/master/LICENSE.md) for
the full license text.

### Installation

TaylorSeries.jl is a [registered package](http://pkg.julialang.org), and is
simply installed by running

```julia
pkg> add("TaylorSeries")
```

### Related packages

- [Polynomials.jl](https://github.com/JuliaMath/Polynomials.jl): Polynomial manipulations
- [PowerSeries.jl](https://github.com/jwmerrill/PowerSeries.jl): Truncated power series for Julia
- [MultivariatePolynomials.jl](https://github.com/JuliaAlgebra/MultivariatePolynomials.jl): Multivariate polynomials interface
- [AbstractAlgebra.jl](https://github.com/Nemocas/AbstractAlgebra.jl): Generic abstract algebra functionality in pure Julia
- [ForwardDiff.jl](https://github.com/JuliaDiff/ForwardDiff.jl): Forward Mode Automatic Differentiation for Julia
- [ReverseDiff.jl](https://github.com/JuliaDiff/ReverseDiff.jl): Reverse Mode Automatic Differentiation for Julia
- [HyperDualNumbers.jl](https://github.com/JuliaDiff/HyperDualNumbers.jl): Julia implementation of HyperDualNumbers

### Acknowledgments

This project began (using Python) during a Masters' course in the postgraduate
programs in Physics and in Mathematics at UNAM, during the second half of 2013.
We thank the participants of the course for putting up with the half-baked
material and contributing energy and ideas.

We acknowledge financial support from DGAPA-UNAM PAPIME grants
PE-105911 and PE-107114, and DGAPA-PAPIIT grants IG-101113,
IG-100616, IG-100819 and IG-101122.
LB acknowledges support through a *Cátedra Marcos Moshinsky* (2013).
