% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellation.R
\name{resolveRegions}
\alias{resolveRegions}
\title{Combine and resolve region labels}
\usage{
resolveRegions(regions, session, space = "structural",
  parcellationConfidence = 0.5)
}
\arguments{
\item{regions}{Named parcellation labels, and/or image file paths.}

\item{session}{An \code{MriSession} object representing the session of interest.}

\item{space}{The space in which the combined parcellation is required.
Implicit co-registration will be performed and the structural space
parcellation transformed in, if necessary. Some kind of ultimate source
parcellation must exist unless all \code{regions} are file names.}

\item{parcellationConfidence}{Threshold level, ultimately passed to
\code{\link[=transformParcellation]{transformParcellation()}} if a transformation is required.}
}
\value{
A list with elements
\itemize{
\item \code{image}: an integer-valued image representing the combined parcellation;
\item \code{indices}: the index values of the requested regions of interest, which
may not match the source images if there is a label clash;
\item \code{labels}: the extracted region labels, which are based on the file name
where they don't come from a standard parcellation; and
\item \code{fromParcellation}: a logical vector indicating which \code{indices} and
\code{labels} come from a standard parcellation.
}
}
\description{
This function is a session-aware means of combining standard parcellations
with additional images to produce a hybrid labelled image for further use.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
If only matching against a specific parcellation is needed,
\code{\link[=matchRegions]{matchRegions()}} can be used instead.
}
\author{
Jon Clayden
}
