% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_registration.R
\name{registerImages}
\alias{registerImages}
\title{Register two images}
\usage{
registerImages(source, target, registration = NULL, sourceMask = NULL,
  targetMask = NULL, method = getOption("tractorRegistrationMethod"),
  types = "affine", affineDof = 12, estimateOnly = FALSE,
  interpolation = 1, ...)
}
\arguments{
\item{source}{The source (a.k.a. moving, floating) image, or a string giving
the path to it. Image pixel/voxel data is required for full registration,
so a header object or \code{MriImage} containing only metadata will not work.
May have one more dimension than the target image, if \code{method} is
\code{"niftyreg"}.}

\item{target}{The target (a.k.a. fixed, reference) image, providing the
output grid and coordinate system for the registration.}

\item{registration}{An existing \link{Registration} object to update with the
new transforms, or \code{NULL} to create a new one. If this argument is
specified then the source and target images will be taken from it, and
should not also be specified.}

\item{sourceMask, }{targetMask Images in the source and target space
weighting or masking key areas for the optimisation.}

\item{method}{A string naming the backend to use: \code{"fsl"} or \code{"niftyreg"}.
The default is determined by the \code{tractorRegistrationMethod} option,
which in turn considers the \code{TRACTOR_REG_METHOD} environment variable. If
none of these are set then the default will be \code{"niftyreg"}.}

\item{types}{A vector of transform types to calculate. Must be a subset of
\link{TransformTypes}. The default is affine-only.}

\item{affineDof}{The number of degrees of freedom for linear transforms (3D
values are used even if the images are 2D). FSL-FLIRT accepts values of 6
(rigid-body), 7 (global rescale), 9 (traditional) and 12 (affine);
NiftyReg accepts only 6 and 12.}

\item{estimateOnly}{Boolean value. If \code{TRUE}, the transform will be
estimated but the source image will not be resampled into the target
space; otherwise the transformed source image will be added to the result.}

\item{interpolation}{An integer indicating the type of interpolation to
apply when resampling. Both backends accept 0 (nearest neighbour), 1
(blinear or trilinear, the default) and 3 (cubic spline); FSL additionally
accepts 2 (sinc).}

\item{...}{Additional arguments to method-specific functions. The FSL
backend currently takes no other arguments; for NiftyReg a list named
\code{linearOptions} can be used to provide additional arguments to
\code{\link[RNiftyReg:niftyreg.linear]{RNiftyReg::niftyreg.linear()}}, and one named \code{nonlinearOptions} for
\code{\link[RNiftyReg:niftyreg.nonlinear]{RNiftyReg::niftyreg.nonlinear()}}.}
}
\value{
A registration object. If the \code{registration} argument was not \code{NULL}
then this is an updated version of it.
}
\description{
This function performs one or more fully optimised image registrations,
finding transforms that maximise the alignment between the transformed
source image and the target image with respect to a suitable similarity
measure.
}
\details{
The work of the registration is done by the \code{RNiftyReg} package, or by
FSL-FLIRT (which must be installed and on the system path). The function
serves as a unified interface to both of these backends. Which one is used
depends on the value of the \code{method} argument.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
\code{\link[=createRegistration]{createRegistration()}}, which creates unoptimised registrations
}
\author{
Jon Clayden
}
