% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_registration.R
\name{registrationFile}
\alias{registrationFile}
\alias{readRegistration}
\title{Read a registration from file}
\usage{
registrationFile(path = NULL)

readRegistration(path, validate = TRUE)
}
\arguments{
\item{path}{A string giving the path to the file or directory, with or
without the file extension. May be \code{NULL} for \code{registrationFile()}.}

\item{validate}{Boolean value. If \code{TRUE}, the default, a deserialised
object is checked to make sure it is of class \link{Registration}.}
}
\value{
For \code{readRegistration()}, a registration object. (An error is
signalled if no suitable files exist.) For \code{registrationFile()}, a
file handle object for the relevant path or (if \code{path} was \code{NULL}) a
generic \code{FileSet} object.
}
\description{
Read a complete registration from file, including all associated transforms.
These functions handle flat file and directory (.xfmb) formats used by all
recent versions of TractoR.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
