% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{plotTransform}
\alias{plotTransform}
\title{Plot a transform's deformation field}
\usage{
plotTransform(transform, ..., x = NA, y = NA, z = NA,
  sourceImage = NULL)
}
\arguments{
\item{transform}{An \code{RNiftyReg} transform (affine matrix or control point
image), or a \link{Registration} object.}

\item{...}{Additional arguments to the \code{getTransforms()} method of the
\code{Registration} class, if \code{transform} is of that class. This allows reverse
or half transforms to be applied.}

\item{x, y, z}{Coordinate elements (after standard image reordering). Exactly
one of these should be specified, identifying the plane in target space
that you want to visualise.}

\item{sourceImage}{The full source image, if it cannot be derived from the
\code{transform}. This will be used for the base layer of the plot.}
}
\description{
This function visualises a transform in terms of its deformation field in a
specified plane. It shows a slice in source space, overlaid with a field of
marks showing the locations of target voxel centres. The colours of the
marks correspond to the local Jacobian determinant, indicating whether there
is an expansion or contraction in the area. The Jacobian will be constant
for linear transforms.
}
\note{
There will generally not be a plane in source space that matches the
specified target space plane exactly. The source plane used is the slice
in the same orientation that is closest on average to the target space
points, but the overlay is an approximation only, and in some cases may
not be a very good one.
}
