% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellation.R
\name{readParcellation}
\alias{readParcellation}
\alias{writeParcellation}
\title{Read and write parcellations}
\usage{
readParcellation(imageFileName, regionFileName = NULL, ...)

writeParcellation(parcellation, ...)
}
\arguments{
\item{imageFileName}{Path to an image file.}

\item{regionFileName}{Path to the associated region metadata file. If
\code{NULL}, this will default to the same path as the image but with a \code{"lut"}
file extension.}

\item{...}{Additional arguments to \code{\link[tractor.base:readImageFile]{tractor.base::readImageFile()}} or
\code{\link[tractor.base:readImageFile]{tractor.base::writeImageFile()}}, as appropriate.}

\item{parcellation}{A list object representing a parcellation, as produced
by \code{readParcellation}.}
}
\value{
For \code{readParcellation}, a list with components
\itemize{
\item \code{image}: an \code{MriImage} object representing the image, and
\item \code{regions}: a \code{data.frame} containing the region metadata.
\code{writeParcellation} is called for its side-effect.
}
}
\description{
A parcellation is an integer-valued image in which each unique value
represents a labelled region. The image is therefore associated with some
metadata about each region, which may include a name, a tissue type and a
colour to use when visualising the image. TractoR stores this metadata in
sidecar files with a \code{"lut"} file extension, structured as a table. These
functions read and write this format alongside the associated image.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
