% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellation.R
\name{matchRegions}
\alias{matchRegions}
\title{Match regions to a parcellation}
\usage{
matchRegions(regions, parcellation, labels = FALSE)
}
\arguments{
\item{regions}{Region names and/or integer indices. Each value is matched at
only one level, but regions are included in the return value if they match
on any term.}

\item{parcellation}{A list object representing a parcellation, as produced
by \code{\link[=readParcellation]{readParcellation()}}.}

\item{labels}{Boolean value. If \code{TRUE}, the labels of the matching regions
are returned; otherwise the integer indices.}
}
\value{
Values corresponding to the matching regions: labels or indices,
depending on the value of \code{labels}.
}
\description{
This function matches region names or indices to values within a
parcellation. Integer-valued region specifications (including number
strings) are matched against region indices; other names are matched to
regions by label, lobe, tissue type and hemisphere in that order of
preference.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
