% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_registration.R
\name{createRegistration}
\alias{createRegistration}
\title{Create an unoptimised registration}
\usage{
createRegistration(source, target, method = "identity", ...)
}
\arguments{
\item{source}{The source (a.k.a. moving, floating) image, a string giving
the path to it, or a \code{\link[RNifti:niftiHeader]{RNifti::niftiHeader()}} object encapsulating its
metadata. May have one more dimension than the target image.}

\item{target}{The target (a.k.a. fixed, reference) image, providing the
output grid and coordinate system for the registration. Can be in any of
the same forms as the source image.}

\item{method}{A string naming the registration method. This is just a label,
and has no functional consequence.}

\item{...}{Additional arguments to \code{\link[RNiftyReg:buildAffine]{RNiftyReg::buildAffine()}}, allowing
for rotation angles, translations, etc., to be applied.}
}
\value{
A registration object.
}
\description{
This function creates a basic registration object representing a simple
linear mapping between the specified source and target images. By default
this is essentially an identity transform.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
\code{\link[=registerImages]{registerImages()}}, which creates optimised registrations.
}
\author{
Jon Clayden
}
