% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_registration.R
\docType{class}
\name{Registration-class}
\alias{Registration-class}
\alias{Registration}
\title{The Registration class}
\description{
This class represents a complete image registration operation, including the
two images being aligned and a set of associated transformations between
them, which may be the result of an optimisation. Transforms can be added to
the object after it is first created, allowing for an incremental refinement
of the registration, for example from linear to nonlinear.
}
\section{Fields}{

\describe{
\item{\code{source}}{The source (a.k.a. moving, floating) image, a string giving
the path to it, or a \code{\link[RNifti:niftiHeader]{RNifti::niftiHeader()}} object encapsulating its
metadata. May have one more dimension than the target image.}

\item{\code{target}}{The target (a.k.a. fixed, reference) image, providing the
output grid and coordinate system for the registration. Can be in any of
the same forms as the source image.}

\item{\code{method}}{A character vector naming the methods used to create the
transforms.}

\item{\code{n}}{An integer giving the number of transforms stored in the object.
If the source and target images have the same dimensionality this will be
1; otherwise it is the size of the highest dimension of the source image.}

\item{\code{transforms}}{A list of \link{TransformSet} objects containing the transforms
from source to target space (and potentially the reverse). When a
registration object is first initialised these sets will all be empty.}

\item{\code{transformed.}}{An optional transformed (output) image, or \code{NULL}.
This field is not serialised with the object.}
}}

\section{Methods}{

\describe{
\item{\code{getTransforms(indices = 1:n, reverse = FALSE, preferAffine = FALSE,
  half = FALSE, errorIfMissing = TRUE)}}{Extract one or more transforms, favouring nonlinear warps by default}

\item{\code{getTypes()}}{Return a named vector of counts of each type of transform stored}

\item{\code{reverse()}}{Create an inverted registration with source and target images swapped}

\item{\code{setTransformedImage(image)}}{Update the transformed source image}

\item{\code{setTransforms(objects, type, indices = NULL)}}{Add or replace some transforms of a given type, starting from the first by default}

\item{\code{summarise()}}{Summarise key aspects of the object}
}}

\note{
\code{MriImage} source and target images should not be reordered, as
usually performed by \code{\link[tractor.base:readImageFile]{tractor.base::readImageFile()}}, if the resulting
transforms need to be consistent with the original files.
}
