% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_graph.R
\docType{class}
\name{Graph-class}
\alias{Graph-class}
\alias{Graph}
\title{The Graph class}
\description{
This class represents a graph, composed of vertices and edges with optional
attributes. It can be coerced to an \code{"igraph"} object (from the package
of the same name), and to or from a standard numeric matrix.
}
\section{Fields}{

\describe{
\item{\code{vertexCount}}{The number of vertices in the graph.}

\item{\code{vertexAttributes}}{A named list of attributes which apply to the
vertices. Each component should be a vector of length equal to
\code{vertexCount}.}

\item{\code{vertexLocations}}{A numeric matrix giving the locations of each vertex
in some layout, one per row, or the \code{\link{emptyMatrix}}.}

\item{\code{locationUnit}}{A string giving the units for \code{vertexLocations}, or
the empty string.}

\item{\code{locationSpace}}{A string giving the space for \code{vertexLocations},
or the empty string. This generally only applies to graphs derived from
medical imaging.}

\item{\code{edges}}{An integer matrix listing the vertex indices linked by each
edge, one per line. There should be exactly two columns. If the graph is
undirected, it is not necessary for both directions of each edge to be
stored explicitly.}

\item{\code{edgeAttributes}}{A named list of attributes which apply to the edges.
Each component should be a vector of length equal to the number of rows in
\code{edges}.}

\item{\code{edgeWeights}}{A numeric vector of edge weights, of length equal to the
number of rows in \code{edges}.}

\item{\code{directed}}{Logical value: \code{TRUE} if the graph is directed (so that
edge direction matters); \code{FALSE} otherwise.}
}}

\section{Methods}{

\describe{
\item{\code{binarise()}}{Binarise the graph, setting all nonzero edge weights to 1.}

\item{\code{getAdjacencyMatrix()}}{Obtain the adjacency matrix of the graph, a binarised version of the association matrix whose elements indicate whether or not an edge exists between each pair of vertices.}

\item{\code{getAssociationMatrix()}}{Obtain the graph's association matrix, a representation which encapsulates connectivity and edge weights. The matrix will be symmetric for undirected graphs; otherwise rows represent the vertices at the source of each edge and columns the targets.}

\item{\code{getConnectedVertices()}}{Retrieve a vector of the indices of vertices which are connected by one or more edges.}

\item{\code{getEdgeAttributes(attributes = NULL)}}{Retrieve edge attributes. By default the full list is returned, but a subset or a single attribute vector can be selected by name.}

\item{\code{getEdges(expr)}}{Retrieve the matrix of edges, optionally limiting the result to those selected by the expression supplied.}

\item{\code{getEdgeWeights()}}{Retrieve the vector of current edge weights.}

\item{\code{getVertexAttributes(attributes = NULL)}}{Retrieve vertex attributes. By default the full list is returned, but a subset or a single attribute vector can be selected by name.}

\item{\code{getVertexLocations()}}{Retrieve the vertex locations, if available. The units and space of the location information are returned in attributes.}

\item{\code{getVertices(expr)}}{Retrieve the indices of vertices selected by the expression supplied, which is evaluated in an environment in which the vertex attributes are available by name.}

\item{\code{isSelfConnected()}}{Return TRUE if any edge connects a vertex to itself.}

\item{\code{isWeighted()}}{Return TRUE if any edge weight is neither missing nor 0 or 1.}

\item{\code{map(fun, ..., matchEdges = FALSE)}}{Modify the graph in-place, replacing the association matrix with the result of applying a function to the current one.}

\item{\code{setAssociationMatrix(newMatrix, matchEdges = FALSE)}}{Modify the graph in-place, replacing its connectivity using the supplied association matrix (which must have the appropriate dimensions). This will not change the directedness of the graph. If matchEdges is TRUE, attributes other than weight will be carried over for edges that still exist after the operation.}

\item{\code{setEdgeAttributes(...)}}{Add or replace edge attributes.}

\item{\code{setEdgeWeights(expr, vertices = c("ignore", "sum", "mean", "max", "min"))}}{Set or replace edge weights. The expression giving the new values is evaluated in an environment in which the edge attributes (and the vertex attributes, if the second argument is not 'ignore') are available by name.}

\item{\code{setVertexAttributes(...)}}{Add or replace vertex attributes.}

\item{\code{setVertexLocations(locs, unit, space)}}{Set or replace vertex locations. Attributes of the first argument will be used as fallback values for the second and third, if present.}
}}

\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{https://www.jstatsoft.org/v44/i08/}.
}
\author{
Jon Clayden
}
