#@args source image file, output file
#@desc Apply one or more previously calculated transformations (from "reg-linear" or "reg-nonlinear") to a new image. If multiple transformations are specified then they will first be composed; resampling is only performed once. The NiftyReg backend is used for this operation, but transformations generated by FSL-FLIRT can be used. If Reverse:true is given, the inverse transformation will be applied if it is available. Nonlinear transformations will take priority unless PreferAffine:true is given.
#@group Registration

library(tractor.reg)

runExperiment <- function ()
{
    transformName <- getConfigVariable("TransformName", NULL, "character")
    interpolation <- getConfigVariable("Interpolation", "trilinear", validValues=c("nearestneighbour","trilinear","spline"))
    preferAffine <- getConfigVariable("PreferAffine", FALSE)
    reverse <- getConfigVariable("Reverse", FALSE)
    half <- getConfigVariable("HalfWay", FALSE)
    
    requireArguments("source image file", "output file")
    
    transformName <- splitAndConvertString(transformName, ",", fixed=TRUE)
    if (length(transformName) > 1)
    {
        transforms <- lapply(transformName, function (name) {
            reg <- readRegistration(name)
            assert(reg$nTransforms() == 1, "")
            reg$getTransforms(preferAffine=preferAffine, reverse=reverse, half=half)
        })
        transform <- do.call(RNiftyReg::composeTransforms, transforms)
    }
    else
        transform <- readRegistration(transformName)$getTransforms(preferAffine=preferAffine, reverse=reverse, half=half)
    
    transformedImage <- transformImage(transform, RNiftyReg::readNifti(Arguments[1]), preferAffine=preferAffine, reverse=reverse, half=half, interpolation=interpolation)
    writeImageFile(transformedImage, Arguments[2])

    invisible(NULL)
}
