# Generated by Django 5.2.1 on 2025-07-23 14:34

import django.db.models.deletion
from django.db import migrations, models


def set_default_licence(apps, schema_editor):
    Organizace = apps.get_model('uzivatel', 'Organizace')
    get_default_licence = __import__('uzivatel.models', fromlist=['get_default_licence']).get_default_licence
    default_licence = get_default_licence()
    Organizace.objects.filter(licence__isnull=True).update(licence=default_licence)


class Migration(migrations.Migration):

    dependencies = [
        ('heslar', '0011_ruiankraj_email'),
        ('uzivatel', '0023_add_notifikace_typ_E-N-09'),
    ]

    operations = [
        # 1. Přidání sloupce s null=True + default
        migrations.AddField(
            model_name='organizace',
            name='licence',
            field=models.ForeignKey(
                to='heslar.heslar',
                on_delete=django.db.models.deletion.RESTRICT,
                related_name='organizace_licence',
                limit_choices_to={'nazev_heslare': 50},
                null=True,
                default=__import__('uzivatel.models', fromlist=['get_default_licence']).get_default_licence,
                db_index=True,
            ),
        ),

        # 2. Vyplnění výchozí hodnoty
        migrations.RunPython(set_default_licence, reverse_code=migrations.RunPython.noop),

        # 3. Změna na null=False (tedy povinné)
        migrations.AlterField(
            model_name='organizace',
            name='licence',
            field=models.ForeignKey(
                to='heslar.heslar',
                on_delete=django.db.models.deletion.RESTRICT,
                related_name='organizace_licence',
                limit_choices_to={'nazev_heslare': 50},
                null=False,
                default=__import__('uzivatel.models', fromlist=['get_default_licence']).get_default_licence,
                db_index=True,
            ),
        ),
    ]
