# Generated by Django 3.2.11 on 2023-02-14 19:39

import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields.ranges
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('historie', '0001_initial'),
        ('heslar', '0002_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Projekt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stav', models.SmallIntegerField(choices=[(0, 'P0 - Oznámen'), (1, 'P1 - Zapsán'), (2, 'P2 - Přihlášen'), (3, 'P3 - Zahájen v terénu'), (4, 'P4 - Ukončen v terénu'), (5, 'P5 - Uzavřen'), (6, 'P6 - Archivován'), (7, 'P7 - Navržen ke zrušení'), (8, 'P8 - Zrušen')], default=0, verbose_name='Stav')),
                ('lokalizace', models.TextField(blank=True, null=True)),
                ('kulturni_pamatka_cislo', models.TextField(blank=True, null=True)),
                ('kulturni_pamatka_popis', models.TextField(blank=True, null=True)),
                ('parcelni_cislo', models.TextField(blank=True, null=True)),
                ('podnet', models.TextField(blank=True, null=True, verbose_name='Podnět')),
                ('uzivatelske_oznaceni', models.TextField(blank=True, null=True, verbose_name='Uživatelské označení')),
                ('datum_zahajeni', models.DateField(blank=True, null=True, verbose_name='Datum zahájení')),
                ('datum_ukonceni', models.DateField(blank=True, null=True, verbose_name='Datum ukončení')),
                ('termin_odevzdani_nz', models.DateField(blank=True, null=True)),
                ('ident_cely', models.TextField(unique=True, verbose_name='Identifikátor')),
                ('geom', django.contrib.gis.db.models.fields.PointField(blank=True, null=True, srid=4326)),
                ('oznaceni_stavby', models.TextField(blank=True, null=True, verbose_name='Označení stavby')),
                ('planovane_zahajeni', django.contrib.postgres.fields.ranges.DateRangeField(blank=True, null=True, verbose_name='Plánované zahájení')),
                ('historie', models.OneToOneField(null=True, db_column='historie', on_delete=django.db.models.deletion.SET_NULL, related_name='projekt_historie', to='historie.historievazby')),
                ('hlavni_katastr', models.ForeignKey(db_column='hlavni_katastr', on_delete=django.db.models.deletion.RESTRICT, related_name='projekty_hlavnich_katastru', to='heslar.ruiankatastr', verbose_name='Hlavní katastr')),
            ],
            options={
                'verbose_name': 'projekty',
                'db_table': 'projekt',
            },
        ),
        migrations.CreateModel(
            name='ProjektKatastr',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('katastr', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='heslar.ruiankatastr')),
                ('projekt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='projekt.projekt')),
            ],
            options={
                'db_table': 'projekt_katastr',
            },
        ),
        migrations.AddField(
            model_name='projekt',
            name='katastry',
            field=models.ManyToManyField(through='projekt.ProjektKatastr', to='heslar.RuianKatastr'),
        ),
        migrations.AddField(
            model_name='projekt',
            name='kulturni_pamatka',
            field=models.ForeignKey(blank=True, db_column='kulturni_pamatka', limit_choices_to={'nazev_heslare': 10}, null=True, on_delete=django.db.models.deletion.RESTRICT, to='heslar.heslar', verbose_name='Památka'),
        ),
    ]
