# Generated by Django 4.2.7 on 2024-01-30 20:44

from django.db import migrations, models


def populate_organizace_nazev(apps, schema_editor):
    ExterniZdroj = apps.get_model('ez', 'ExterniZdroj')
    for instance in ExterniZdroj.objects.all():
        if instance.organizace:
            instance.organizace_nazev = instance.organizace.nazev
            instance.suppress_signal = True
            instance.save()


class Migration(migrations.Migration):
    dependencies = [
        ("ez", "0005_change_organizace_field_type"),
    ]

    operations = [
        migrations.RunPython(populate_organizace_nazev),
        migrations.AlterField(
            model_name="externizdroj",
            name="stav",
            field=models.SmallIntegerField(
                choices=[
                    (1, "ez.models.externiZdroj.states.zapsany.label"),
                    (2, "ez.models.externiZdroj.states.odeslany.label"),
                    (3, "ez.models.externiZdroj.states.potvrzeny.label"),
                ]
            ),
        ),
    ]
