# Generated by Django 4.2.8 on 2024-03-26 11:06

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("heslar", "0006_alter_heslar_ident_cely_alter_heslardatace_obdobi_and_more"),
        ("dokument", "0009_alter_dokumentextradata_region_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="dokumentextradata",
            name="region",
            field=models.TextField(blank=True, db_column="region", null=True),
        ),
        migrations.AlterField(
            model_name="dokument",
            name="licence",
            field=models.ForeignKey(
                limit_choices_to={"nazev_heslare": 50},
                null=True,
                on_delete=django.db.models.deletion.RESTRICT,
                related_name="dokumenty_licence",
                to="heslar.heslar",
            ),
        ),
        migrations.AlterField(
            model_name="dokument",
            name="rok_vzniku",
            field=models.PositiveIntegerField(
                blank=True,
                db_index=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1900),
                    django.core.validators.MaxValueValidator(2050),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="dokument",
            name="stav",
            field=models.SmallIntegerField(
                choices=[
                    (1, "dokument.models.dokument.states.D1"),
                    (2, "dokument.models.dokument.states.D2"),
                    (3, "dokument.models.dokument.states.D3"),
                ],
                db_index=True,
            ),
        ),
        migrations.AddIndex(
            model_name="dokument",
            index=models.Index(
                fields=["stav", "ident_cely"], name="dokument_stav_9e09ea_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dokument",
            index=models.Index(
                fields=["stav", "ident_cely", "historie"],
                name="dokument_stav_ea134c_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="dokument",
            index=models.Index(
                fields=["stav", "ident_cely", "organizace"],
                name="dokument_stav_49275f_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="dokument",
            index=models.Index(
                fields=["stav", "ident_cely", "typ_dokumentu"],
                name="dokument_stav_df8e19_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="dokument",
            index=models.Index(
                fields=["stav", "ident_cely", "typ_dokumentu", "organizace"],
                name="dokument_stav_1ec89f_idx",
            ),
        ),
    ]
