# Generated by Django 4.1.7 on 2023-05-29 10:24

from django.db import migrations, models
import django.db.models.deletion
import django_prometheus.models

from core.constants import OBLAST_CECHY, OBLAST_MORAVA


class Migration(migrations.Migration):
    dependencies = [
        ("heslar", "0003_default"),
        ("dokument", "0005_alter_dokumentautor_options"),
    ]

    operations = [
        migrations.DeleteModel(
            name="DokumentSekvence",
        ),
        migrations.CreateModel(
            name="DokumentSekvence",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "region",
                    models.CharField(
                        choices=[(OBLAST_MORAVA, "Morava"), (OBLAST_CECHY, "Cechy")], max_length=1
                    ),
                ),
                ("rok", models.IntegerField()),
                ("sekvence", models.IntegerField()),
                (
                    "rada",
                    models.ForeignKey(
                        limit_choices_to={"nazev_heslare": 26},
                        on_delete=django.db.models.deletion.RESTRICT,
                        to="heslar.heslar",
                    ),
                ),
            ],
            options={
                "db_table": "dokument_sekvence",
            },
            bases=(
                django_prometheus.models.ExportModelOperationsMixin(
                    "dokument_sekvence"
                ),
                models.Model,
            ),
        ),
        migrations.AddConstraint(
            model_name="dokumentsekvence",
            constraint=models.UniqueConstraint(
                fields=("rada", "region", "rok"), name="unique_sekvence_dokument"
            ),
        ),
    ]
