from django.db import migrations
try:
    from core.setting_models import CustomAdminSettings
except ImportError:
    from core.models import CustomAdminSettings 

def insert_customadminsettings_heslar_group(apps, schema_editor):
    CustomAdminSettings.objects.create(
        item_group='constants',
        item_id='heslar_group',
        value='''{
    "KULTURNI_PAMATKY" : [
        "KULTURNI_PAMATKA_KP",
        "KULTURNI_PAMATKA_NKP",
        "KULTURNI_PAMATKA_PZ",
        "KULTURNI_PAMATKA_PR"
    ],
    
    "ALLOWED_DOKUMENT_TYPES" : [
        "TYP_DOKUMENTU_NALEZOVA_ZPRAVA",
        "TYP_DOKUMENTU_PRILOHA_ZPRAVY_HLASENI",
        "TYP_DOKUMENTU_EXPERTNI_POSUDEK",
        "TYP_DOKUMENTU_RESTAURATORSKA_ZPRAVA",
        "TYP_DOKUMENTU_INVESTORSKA_ZPRAVA",
        "TYP_DOKUMENTU_HLASENI",
        "TYP_DOKUMENTU_JINY_TEXT",
        "TYP_DOKUMENTU_DATA_ANALYZY_EKOFAKTU",
        "TYP_DOKUMENTU_DATA_GEODETICKA",
        "TYP_DOKUMENTU_DATA_GEOFYZIKALNI",
        "TYP_DOKUMENTU_DATA_GNSS",
        "TYP_DOKUMENTU_DATA_TERENNIHO_VYZKUMU",
        "TYP_DOKUMENTU_DATA_VEKTOROVEHO_PLANU",
        "TYP_DOKUMENTU_FOTOGRAFIE_KONZERVACE",
        "TYP_DOKUMENTU_FOTOGRAFIE_KRAJINY",
        "TYP_DOKUMENTU_FOTOGRAFIE_LOKALITY",
        "TYP_DOKUMENTU_FOTOGRAFIE_OBJEKTU",
        "TYP_DOKUMENTU_FOTOGRAFIE_OSOBNI",
        "TYP_DOKUMENTU_FOTOGRAFIE_PRACOVNI",
        "TYP_DOKUMENTU_FOTOGRAFIE_PREDMETU",
        "TYP_DOKUMENTU_FOTOGRAFIE_UDALOSTI",
        "TYP_DOKUMENTU_FOTOGRAFIE_VYZKUMU_SONDY",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_KRAJINY",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_LOKALITY",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_METODY",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_VYZKUMU",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_PUDNICH_PRIZNAKU",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_SNEZNYCH_PRIZNAKU",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_STINOVYCH_PRIZNAKU",
        "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_VEGETACNICH_PRIZNAKU",
        "TYP_DOKUMENTU_MIKROFOTOGRAFIE",
        "TYP_DOKUMENTU_PLAN_REGIONU",
        "TYP_DOKUMENTU_PLAN_LOKALITY",
        "TYP_DOKUMENTU_PLAN_VYZKUMU",
        "TYP_DOKUMENTU_PLAN_SONDY",
        "TYP_DOKUMENTU_PLAN_OBJEKTU",
        "TYP_DOKUMENTU_KRESBA_PREDMETU",
        "TYP_DOKUMENTU_MAPA"
    ],
    
    "MODEL_3D_DOKUMENT_TYPES" : ["REKONSTRUKCE_3D_ID", "TEXTURA_3D_ID", "DOKUMENTACE_3D_ID"],

    "MODEL_3D_DOKUMENT_FORMATS" : [
        "DOKUMENT_FORMAT_3D_AUTOCAD",
        "DOKUMENT_FORMAT_3D_AUTODESK_EXCHANGE",
        "DOKUMENT_FORMAT_3D_BLENDER",
        "DOKUMENT_FORMAT_3D_COLLADA",
        "DOKUMENT_FORMAT_3D_LEICA",
        "DOKUMENT_FORMAT_3D_OBJ",
        "DOKUMENT_FORMAT_3D_PRINTING",
        "DOKUMENT_FORMAT_3D_REVIT",
        "DOKUMENT_FORMAT_3D_SKETCHUP",
        "DOKUMENT_FORMAT_3D_STANFORD_PLY",
        "DOKUMENT_FORMAT_3D_STEREO_LITOGRAPHY",
        "DOKUMENT_FORMAT_3D_STUDIO_MAX",
        "DOKUMENT_FORMAT_3D_UNIVERSAL",
        "DOKUMENT_FORMAT_3D_VRML",
        "DOKUMENT_FORMAT_3D_JINY"
    ]    
    
    }'''
    )

def insert_customadminsettings_heslar(apps, schema_editor):
    CustomAdminSettings.objects.create(
        item_group='constants',
        item_id='heslar',
        value='''{
    "TYP_PROJEKTU_ZACHRANNY_ID" : "HES-001136",
    "TYP_PROJEKTU_PRUZKUM_ID" : "HES-001138",
    "TYP_PROJEKTU_BADATELSKY_ID" : "HES-001137",
    "KULTURNI_PAMATKA_OP" : "HES-000176",
    "KULTURNI_PAMATKA_KP" : "HES-000177",
    "KULTURNI_PAMATKA_NKP" : "HES-000178",
    "KULTURNI_PAMATKA_PZ" : "HES-000179",
    "KULTURNI_PAMATKA_PR" : "HES-000180",
    "KULTURNI_PAMATKA_UN" : "HES-000181",
    "PRISTUPNOST_BADATEL_ID" : "HES-000866",
    "PRISTUPNOST_ARCHEOLOG_ID" : "HES-000867",
    "PRISTUPNOST_ANONYM_ID" : "HES-000865",
    "PRISTUPNOST_ARCHIVAR_ID" : "HES-000868",
    "SPECIFIKACE_DATA_PRESNE" : "HES-000887",
    "TYP_DJ_SONDA_ID" : "HES-001072",
    "TYP_DJ_KATASTR" : "HES-001073",
    "TYP_DJ_CELEK" : "HES-001070",
    "TYP_DJ_CAST" : "HES-001071",
    "TYP_DJ_LOKALITA" : "HES-001074",
    "GEOMETRY_PLOCHA" : "HES-001135",
    "GEOMETRY_LINIE" : "HES-001134",
    "GEOMETRY_BOD" : "HES-001133",
    "DOKUMENT_RADA_DATA_3D" : "HES-000870",
    "MATERIAL_DOKUMENTU_DIGITALNI_SOUBOR" : "HES-000217",
    "TYP_DOKUMENTU_NALEZOVA_ZPRAVA" : "HES-001075",
    "TYP_DOKUMENTU_PRILOHA_ZPRAVY_HLASENI" : "HES-001076",
    "TYP_DOKUMENTU_EXPERTNI_POSUDEK" : "HES-001077",
    "TYP_DOKUMENTU_RESTAURATORSKA_ZPRAVA" : "HES-001078",
    "TYP_DOKUMENTU_INVESTORSKA_ZPRAVA" : "HES-001079",
    "TYP_DOKUMENTU_HLASENI" : "HES-001080",
    "TYP_DOKUMENTU_JINY_TEXT" : "HES-001081",
    "TYP_DOKUMENTU_DATA_ANALYZY_EKOFAKTU" : "HES-001082",
    "TYP_DOKUMENTU_DATA_GEODETICKA" : "HES-001083",
    "TYP_DOKUMENTU_DATA_GEOFYZIKALNI" : "HES-001084",
    "TYP_DOKUMENTU_DATA_GNSS" : "HES-001085",
    "TYP_DOKUMENTU_DATA_TERENNIHO_VYZKUMU" : "HES-001086",
    "TYP_DOKUMENTU_DATA_VEKTOROVEHO_PLANU" : "HES-001087",
    "TYP_DOKUMENTU_FOTOGRAFIE_KONZERVACE" : "HES-001097",
    "TYP_DOKUMENTU_FOTOGRAFIE_KRAJINY" : "HES-001088",
    "TYP_DOKUMENTU_FOTOGRAFIE_LOKALITY" : "HES-001089",
    "TYP_DOKUMENTU_FOTOGRAFIE_OBJEKTU" : "HES-001094",
    "TYP_DOKUMENTU_FOTOGRAFIE_OSOBNI" : "HES-001091",
    "TYP_DOKUMENTU_FOTOGRAFIE_PRACOVNI" : "HES-001093",
    "TYP_DOKUMENTU_FOTOGRAFIE_PREDMETU" : "HES-001095",
    "TYP_DOKUMENTU_FOTOGRAFIE_UDALOSTI" : "HES-001092",
    "TYP_DOKUMENTU_FOTOGRAFIE_VYZKUMU_SONDY" : "HES-001090",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_KRAJINY" : "HES-001098",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_LOKALITY" : "HES-001099",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_METODY" : "HES-001116",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_VYZKUMU" : "HES-001100",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_PUDNICH_PRIZNAKU" : "HES-001103",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_SNEZNYCH_PRIZNAKU" : "HES-001104",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_STINOVYCH_PRIZNAKU" : "HES-001105",
    "TYP_DOKUMENTU_LETECKA_FOTOGRAFIE_VEGETACNICH_PRIZNAKU" : "HES-001102",
    "TYP_DOKUMENTU_MIKROFOTOGRAFIE" : "HES-001096",
    "TYP_DOKUMENTU_PLAN_REGIONU" : "HES-001101",
    "TYP_DOKUMENTU_PLAN_LOKALITY" : "HES-001106",
    "TYP_DOKUMENTU_PLAN_VYZKUMU" : "HES-001107",
    "TYP_DOKUMENTU_PLAN_SONDY" : "HES-001108",
    "TYP_DOKUMENTU_PLAN_OBJEKTU" : "HES-001109",
    "TYP_DOKUMENTU_KRESBA_PREDMETU" : "HES-001110",
    "TYP_DOKUMENTU_MAPA" : "HES-001111",
    
    "REKONSTRUKCE_3D_ID" : "HES-001113",
    "TEXTURA_3D_ID" : "HES-001115",
    "DOKUMENTACE_3D_ID" : "HES-001114",
    
    "DOKUMENT_FORMAT_3D_AUTOCAD" : "HES-000152",
    "DOKUMENT_FORMAT_3D_AUTODESK_EXCHANGE" : "HES-000153",
    "DOKUMENT_FORMAT_3D_BLENDER" : "HES-000154",
    "DOKUMENT_FORMAT_3D_COLLADA" : "HES-000155",
    "DOKUMENT_FORMAT_3D_LEICA" : "HES-000156",
    "DOKUMENT_FORMAT_3D_OBJ" : "HES-000157",
    "DOKUMENT_FORMAT_3D_PRINTING" : "HES-000158",
    "DOKUMENT_FORMAT_3D_REVIT" : "HES-000159",
    "DOKUMENT_FORMAT_3D_SKETCHUP" : "HES-000160",
    "DOKUMENT_FORMAT_3D_STANFORD_PLY" : "HES-000161",
    "DOKUMENT_FORMAT_3D_STEREO_LITOGRAPHY" : "HES-000163",
    "DOKUMENT_FORMAT_3D_STUDIO_MAX" : "HES-000164",
    "DOKUMENT_FORMAT_3D_UNIVERSAL" : "HES-000162",
    "DOKUMENT_FORMAT_3D_VRML" : "HES-000165",
    "DOKUMENT_FORMAT_3D_JINY" : "HES-000166",
    
    "EXTERNI_ZDROJ_TYP_KNIHA" : "HES-001117",
    "EXTERNI_ZDROJ_TYP_CAST_KNIHY" : "HES-001118",
    "EXTERNI_ZDROJ_TYP_CLANEK_V_CASOPISE" : "HES-001119",
    "EXTERNI_ZDROJ_TYP_CLANEK_V_NOVINACH" : "HES-001120",
    "EXTERNI_ZDROJ_TYP_NEPUBLIKOVANA_ZPRAVA" : "HES-001121",
    
    "PIAN_PRESNOST_KATASTR" : "HES-000864",
    "HESLAR_DATUM_SPECIFIKACE_V_LETECH_PRIBLIZNE" : "HES-000889",
    "HESLAR_DATUM_SPECIFIKACE_V_LETECH_PRESNE" : "HES-000886",
    
    "JAZYK_CS" : "HES-000167",
    "PRIMARNE_DIGITALNI" : "HES-001166"   
    
    }'''
    )

class Migration(migrations.Migration):
    dependencies = [
        ('core', '0016_alter_customadminsettings_options_and_more'),
    ]

    operations = [
        migrations.RunPython(insert_customadminsettings_heslar_group),
        migrations.RunPython(insert_customadminsettings_heslar),
    ]
