# How to Contribute

Thank you for your interest in contributing! Your contributions help improve the project for the community. These guidelines are here to ensure a smooth and collaborative experience. While they provide structure, they are not strict rules — use your best judgment and feel free to suggest improvements.

## Table of Contents

- [Important Resources](#important-resources)
- [Reporting Bugs](#reporting-bugs)
- [Suggesting Enhancements](#suggesting-enhancements)
- [Local Development](#local-development)
- [Pull Requests](#pull-requests)
- [Style Guides](#style-guides)
- [Need Help?](#need-help)

## Important Resources

Here are some quick links to essential project resources:

- **Documentation:** [Latest](https://ts4nfdi.github.io/terminology-service-suite/comp/latest/) | [All Versions](https://ts4nfdi.github.io/terminology-service-suite/)
- **Development instructions:** [Wiki](https://github.com/ts4nfdi/terminology-service-suite/wiki/Development-instructions)

## Reporting Bugs

Bugs are tracked via GitHub issues. If you encounter a bug, please create an issue in the repository and provide as much detail as possible. This helps us to reproduce and fix the issue efficiently.

### What to Include in a Bug Report (optionally):

- **A clear, descriptive title** that summarizes the problem
- **Steps to reproduce** the issue with as much detail as possible
- **Expected behavior** versus **actual behavior** and why the observed behavior is problematic
- **Screenshots or links** to Storybook examples (if applicable)
- **Environment details**, such as browser, OS, and package versions

## Suggesting Enhancements

Enhancements can include new features or minor improvements to existing functionality. If you have an idea, open an issue on GitHub and provide as much detail as possible.

### What to Include in an Enhancement Request (optionally):

- **A clear and descriptive title** summarizing the suggestion
- **A step-by-step explanation** of the suggested enhancement
- **Examples or use cases** demonstrating how it would be beneficial
- **Current behavior** and **expected behavior** after the enhancement
- **Screenshots or references** to similar implementations elsewhere
- **Why this feature would be useful** to most users

## Local Development

You can develop and test the widgets locally. For setup and development instructions, refer to the [development section in the wiki](https://github.com/ts4nfdi/terminology-service-suite/wiki/Development-instructions).

## Pull Requests

To ensure an efficient review process, please follow these guidelines:

### Guidelines for Pull Requests:

- **Provide all requested details**:
  - Link to the issue describing the bug that you're fixing
  - Description of the change
  - Screenshot of before and after the change
  - Possible drawbacks
  - Release notes (single line that explains this improvement in terms that a user can understand)
- **Adhere to style guides** and ensure the code follows best practices
- **Ensure all status checks pass** before submitting - if a status check fails but seems unrelated to your changes, leave a comment explaining why

### Style Guides

Use Eslint and prettier.

## Git Commit Messages

For commit message conventions, refer to the [wiki](https://github.com/ts4nfdi/terminology-service-suite/wiki/Commit-Message-Formatting).

---

We appreciate your contributions and look forward to support you and working with you!
