# Contributing

Thank you for your willingness to contribute to [DifferentiationInterface.jl](https://github.com/JuliaDiff/DifferentiationInterface.jl).
The maintainers of this package are Guillaume Dalle ([@gdalle](https://github.com/gdalle)) and Adrian Hill ([@adrhill](https://github.com/adrhill)).

If you have a problem to report or an improvement to suggest, please [open an issue](https://github.com/JuliaDiff/DifferentiationInterface.jl/issues/new/choose) with a precise description (and a reproducible example whenever possible).
Once your issue receives positive feedback, you can open a pull request to address it.
_Only the two maintainers are allowed to approve and merge pull requests._
Feel free to ping them if they do not answer within a week or so.

Apart from the conditions above, this repository follows the [ColPrac](https://github.com/SciML/ColPrac) best practices and [Conventional Commits](https://www.conventionalcommits.org/en/).
Its code is formatted using [JuliaFormatter.jl](https://github.com/domluna/JuliaFormatter.jl) with [BlueStyle](https://github.com/JuliaDiff/BlueStyle).
As part of continuous integration, a set of formal tests is run using [pre-commit](https://pre-commit.com/).
We invite you to install pre-commit so that these checks are performed locally before you open or update a pull request.
You can refer to the [dev guide](https://juliadiff.org/DifferentiationInterface.jl/DifferentiationInterface/dev/dev_guide/) for details on the package structure and the testing pipeline.
