## FuXi-CMIPAlign

This is the official repository for the FuXi-CMIPAlign paper.

[Generative artificial intelligence improves projections of climate extremes
](https://arxiv.org/abs/2508.16396)

by Ruian Tie, Xiaohui Zhong, Zhengyu Shi, Hao Li, Bin Chen, Jun Liu, Libo Wu


## Demo

```bash 
python inference_CMIPAlign.py --onnx_path ./onnx_model.onnx --savePath ./result_SSP126
```

## Conda environments

```bash
pip install -r requirement.txt
```

## Data preparation 

The raw EC-Earth data are accessible through the Earth System Grid Federation
(https://esgf-ui.ceda.ac.uk/cog/search/cmip6-ceda/). These data need to include the following variables, which are abbreviated as follows in CMIP6:

```plain
'tas', 'uas', 'vas', 'pr', 'psl', 'zg250', 'zg500'
```

Then, pr needs to be processed into daily accumulated precipitation (tp), and zg250 and zg500 need to be processed into z250 and z500, respectively. Finally, process these data into a Zarr file. We provide a sample file named `ec-earth-ssp126.20150101_20150131.c21.p4.h24` in Google Drive (https://drive.google.com/file/d/1j3eSUkXGm7VAcktU6Dt-y8NbEkBFj_VB/view?usp=share_link), which contains preprocessed data from the origin EC-Earth data under SSP126. The file has a shape of (31, 70, 721, 1440), where the first dimension represents date. The second dimension represents all variable and level combinations. The format reference as follows:

```plain
<matplotlib.colorbar.Colorbar at 0x7f6c61ad1950>

<xarray.Dataset> Size: 341MB
Dimensions:                        (time: 31, plev: 21, lat: 256, lon: 512)
Coordinates:
    height                         float64 8B ...
  * lat                            (lat) float64 2kB 89.46 88.77 ... -89.46
  * lon                            (lon) float64 4kB 0.0 0.7031 ... 358.6 359.3
  * plev                           (plev) object 168B 'z250' 'z500' ... 'tp'
  * time                           (time) datetime64[ns] 248B 2015-01-01T12:0...
Data variables:
    __xarray_dataarray_variable__  (time, plev, lat, lon) float32 341MB dask.array<chunksize=(1, 21, 256, 512), meta=np.ndarray>
```

**_NOTE:_**

- The variable 'Z' represents geopotential and not geopotential height.
- The variable 'TP' represents total precipitation accumulated over a period of 6 hours.