/*****************************************************************************************/
/**** 
 ****   tables.h 
 **** 
 ****   part of the fLPS package version 2.1 
 ****/ 
/****  Copyright 2017, 2021, 2025. Paul Martin Harrison. ****/ 
/****
 ****  Licensed under the 3-clause BSD license. See LICENSE.txt bundled in the fLPS package. 
 ****/ 
/****  
 ****  The latest version of this code is available at:
 ****    http://biology.mcgill.ca/faculty/harrison/flps.html 
 ****      OR 
 ****    https://github.com/pmharrison/flps 
 **** 
 ****  Citations: 
 ****    Harrison, PM. 'fLPS: fast discovery of compositional biases for the protein universe', 
 ****    (2017) BMC Bioinformatics, 18: 476. 
 ****    Harrison, PM. 'fLPS 2.0: rapid annotation of compositional biases in 
 ****    biological sequences', (2021) PeerJ, submitted. 
 ****    [ADD CITATION] 
 ****/ 
/*****************************************************************************************/ 

double logfactorial[MAXIMUM_LENGTH+1] = { /***** MAXIMUM_LENGTH currently 100000 *****/ 
	0.00000,	0.00000,	0.30103,	0.77815,	1.38021,	2.07918,	2.85733,	3.70243,	4.60552,	5.55976,	6.55976,
7.60116,	8.68034,	9.79428,	10.94041,	12.11650,	13.32062,	14.55107,	15.80634,	17.08509,	18.38612,
19.70834,	21.05077,	22.41249,	23.79271,	25.19065,	26.60562,	28.03698,	29.48414,	30.94654,	32.42366,
33.91502,	35.42017,	36.93869,	38.47016,	40.01423,	41.57054,	43.13874,	44.71852,	46.30959,	47.91165,
49.52443,	51.14768,	52.78115,	54.42460,	56.07781,	57.74057,	59.41267,	61.09391,	62.78410,	64.48307,
66.19065,	67.90665,	69.63092,	71.36332,	73.10368,	74.85187,	76.60774,	78.37117,	80.14202,	81.92017,
83.70550,	85.49790,	87.29724,	89.10342,	90.91633,	92.73587,	94.56195,	96.39446,	98.23331,	100.07841,
101.92966,	103.78700,	105.65032,	107.51955,	109.39461,	111.27543,	113.16192,	115.05401,	116.95164,	118.85473,
120.76321,	122.67703,	124.59610,	126.52038,	128.44980,	130.38430,	132.32382,	134.26830,	136.21769,	138.17194,
140.13098,	142.09477,	144.06325,	146.03638,	148.01410,	149.99637,	151.98314,	153.97437,	155.97000,	157.97000,
159.97433,	161.98293,	163.99576,	166.01280,	168.03399,	170.05929,	172.08867,	174.12210,	176.15952,	178.20092,
180.24624,	182.29546,	184.34854,	186.40544,	188.46614,	190.53060,	192.59878,	194.67067,	196.74621,	198.82539,
200.90818,	202.99454,	205.08444,	207.17787,	209.27478,	211.37515,	213.47895,	215.58616,	217.69675,	219.81069,
221.92796,	224.04854,	226.17239,	228.29949,	230.42983,	232.56337,	234.70009,	236.83997,	238.98298,	241.12911,
243.27833,	245.43062,	247.58595,	249.74432,	251.90568,	254.07004,	256.23735,	258.40762,	260.58080,	262.75689,
264.93587,	267.11771,	269.30241,	271.48993,	273.68026,	275.87338,	278.06928,	280.26794,	282.46934,	284.67346,
286.88028,	289.08980,	291.30198,	293.51683,	295.73431,	297.95442,	300.17714,	302.40245,	304.63033,	306.86078,
309.09378,	311.32931,	313.56735,	315.80790,	318.05094,	320.29645,	322.54443,	324.79485,	327.04770,	329.30297,
331.56065,	333.82072,	336.08317,	338.34799,	340.61516,	342.88467,	345.15652,	347.43067,	349.70714,	351.98589,
354.26692,	356.55022,	358.83578,	361.12358,	363.41362,	365.70587,	368.00034,	370.29701,	372.59586,	374.89689,
377.20008,	379.50544,	381.81293,	384.12256,	386.43432,	388.74818,	391.06415,	393.38222,	395.70236,	398.02458,
400.34887,	402.67520,	405.00358,	407.33399,	409.66643,	412.00089,	414.33735,	416.67580,	419.01625,	421.35867,
423.70306,	426.04941,	428.39772,	430.74797,	433.10015,	435.45426,	437.81028,	440.16822,	442.52805,	444.88978,
447.25339,	449.61888,	451.98624,	454.35545,	456.72652,	459.09943,	461.47418,	463.85076,	466.22916,	468.60937,
470.99139,	473.37520,	475.76081,	478.14820,	480.53736,	482.92830,	485.32100,	487.71545,	490.11165,	492.50959,
494.90926,	497.31066,	499.71378,	502.11861,	504.52516,	506.93340,	509.34333,	511.75495,	514.16825,	516.58322,
518.99986,	521.41816,	523.83812,	526.25972,	528.68297,	531.10785,	533.53436,	535.96250,	538.39225,	540.82361,
543.25658,	545.69115,	548.12731,	550.56506,	553.00440,	555.44531,	557.88779,	560.33183,	562.77743,	565.22459,
567.67330,	570.12355,	572.57533,	575.02865,	577.48350,	579.93986,	582.39775,	584.85714,	587.31804,	589.78043,
592.24433,	594.70971,	597.17658,	599.64492,	602.11475,	604.58604,	607.05879,	609.53301,	612.00868,	614.48580,
616.96437,	619.44438,	621.92582,	624.40869,	626.89299,	629.37871,	631.86585,	634.35440,	636.84436,	639.33572,
641.82848,	644.32264,	646.81818,	649.31511,	651.81342,	654.31311,	656.81417,	659.31660,	661.82039,	664.32554,
666.83204,	669.33990,	671.84910,	674.35965,	676.87153,	679.38475,	681.89929,	684.41517,	686.93236,	689.45088,
691.97071,	694.49184,	697.01429,	699.53803,	702.06308,	704.58942,	707.11705,	709.64597,	712.17616,	714.70764,
717.24040,	719.77442,	722.30972,	724.84628,	727.38410,	729.92317,	732.46350,	735.00508,	737.54791,	740.09197,
742.63728,	745.18382,	747.73160,	750.28060,	752.83083,	755.38228,	757.93495,	760.48883,	763.04393,	765.60023,
768.15774,	770.71644,	773.27635,	775.83745,	778.39975,	780.96323,	783.52789,	786.09374,	788.66077,	791.22897,
793.79834,	796.36889,	798.94059,	801.51347,	804.08750,	806.66268,	809.23903,	811.81652,	814.39516,	816.97494,
819.55587,	822.13793,	824.72113,	827.30546,	829.89092,	832.47751,	835.06522,	837.65405,	840.24400,	842.83506,
845.42724,	848.02053,	850.61492,	853.21042,	855.80701,	858.40471,	861.00350,	863.60338,	866.20435,	868.80641,
871.40956,	874.01378,	876.61909,	879.22547,	881.83293,	884.44145,	887.05105,	889.66171,	892.27343,	894.88621,
897.50006,	900.11495,	902.73090,	905.34790,	907.96595,	910.58504,	913.20518,	915.82636,	918.44857,	921.07182,
923.69610,	926.32141,	928.94776,	931.57512,	934.20351,	936.83292,	939.46335,	942.09479,	944.72725,	947.36072,
949.99519,	952.63068,	955.26717,	957.90466,	960.54314,	963.18263,	965.82311,	968.46459,	971.10705,	973.75050,
976.39494,	979.04037,	981.68677,	984.33415,	986.98251,	989.63185,	992.28215,	994.93343,	997.58568,	1000.23889,
1002.89307,	1005.54821,	1008.20430,	1010.86136,	1013.51937,	1016.17834,	1018.83825,	1021.49912,	1024.16093,	1026.82369,
1029.48739,	1032.15203,	1034.81761,	1037.48413,	1040.15158,	1042.81997,	1045.48929,	1048.15953,	1050.83070,	1053.50280,
1056.17582,	1058.84977,	1061.52463,	1064.20040,	1066.87710,	1069.55471,	1072.23322,	1074.91265,	1077.59299,	1080.27423,
1082.95637,	1085.63942,	1088.32337,	1091.00821,	1093.69395,	1096.38059,	1099.06812,	1101.75654,	1104.44585,	1107.13604,
1109.82713,	1112.51909,	1115.21194,	1117.90567,	1120.60027,	1123.29575,	1125.99211,	1128.68934,	1131.38744,	1134.08641,
1136.78625,	1139.48695,	1142.18852,	1144.89095,	1147.59424,	1150.29839,	1153.00340,	1155.70926,	1158.41598,	1161.12355,
1163.83197,	1166.54124,	1169.25136,	1171.96232,	1174.67413,	1177.38678,	1180.10027,	1182.81460,	1185.52977,	1188.24577,
1190.96261,	1193.68028,	1196.39878,	1199.11811,	1201.83827,	1204.55926,	1207.28107,	1210.00370,	1212.72716,	1215.45143,
1218.17653,	1220.90244,	1223.62916,	1226.35671,	1229.08506,	1231.81422,	1234.54420,	1237.27498,	1240.00657,	1242.73896,
1245.47216,	1248.20616,	1250.94096,	1253.67656,	1256.41296,	1259.15015,	1261.88814,	1264.62692,	1267.36649,	1270.10685,
1272.84800,	1275.58994,	1278.33267,	1281.07618,	1283.82047,	1286.56554,	1289.31140,	1292.05803,	1294.80545,	1297.55363,
1300.30260,	1303.05233,	1305.80284,	1308.55412,	1311.30617,	1314.05899,	1316.81257,	1319.56692,	1322.32203,	1325.07790,
1327.83454,	1330.59194,	1333.35009,	1336.10900,	1338.86867,	1341.62909,	1344.39027,	1347.15220,	1349.91488,	1352.67830,
1355.44248,	1358.20740,	1360.97307,	1363.73948,	1366.50664,	1369.27454,	1372.04318,	1374.81255,	1377.58267,	1380.35352,
1383.12511,	1385.89743,	1388.67048,	1391.44427,	1394.21879,	1396.99403,	1399.77001,	1402.54671,	1405.32414,	1408.10229,
1410.88116,	1413.66076,	1416.44108,	1419.22211,	1422.00387,	1424.78634,	1427.56953,	1430.35343,	1433.13805,	1435.92338,
1438.70942,	1441.49617,	1444.28363,	1447.07180,	1449.86068,	1452.65026,	1455.44054,	1458.23153,	1461.02322,	1463.81561,
1466.60870,	1469.40249,	1472.19698,	1474.99217,	1477.78805,	1480.58462,	1483.38189,	1486.17985,	1488.97850,	1491.77784,
1494.57787,	1497.37859,	1500.17999,	1502.98208,	1505.78485,	1508.58831,	1511.39245,	1514.19727,	1517.00277,	1519.80895,
1522.61581,	1525.42334,	1528.23156,	1531.04044,	1533.85000,	1536.66023,	1539.47114,	1542.28271,	1545.09496,	1547.90787,
1550.72145,	1553.53570,	1556.35061,	1559.16619,	1561.98243,	1564.79934,	1567.61690,	1570.43513,	1573.25401,	1576.07356,
1578.89376,	1581.71462,	1584.53613,	1587.35830,	1590.18112,	1593.00459,	1595.82872,	1598.65350,	1601.47892,	1604.30500,
1607.13172,	1609.95909,	1612.78710,	1615.61576,	1618.44507,	1621.27501,	1624.10560,	1626.93683,	1629.76870,	1632.60121,
1635.43436,	1638.26814,	1641.10256,	1643.93762,	1646.77331,	1649.60963,	1652.44659,	1655.28418,	1658.12240,	1660.96125,
1663.80073,	1666.64083,	1669.48156,	1672.32292,	1675.16491,	1678.00752,	1680.85075,	1683.69461,	1686.53908,	1689.38418,
1692.22990,	1695.07624,	1697.92319,	1700.77076,	1703.61895,	1706.46776,	1709.31718,	1712.16721,	1715.01786,	1717.86912,
1720.72099,	1723.57347,	1726.42655,	1729.28025,	1732.13456,	1734.98947,	1737.84499,	1740.70112,	1743.55784,	1746.41518,
1749.27311,	1752.13165,	1754.99079,	1757.85053,	1760.71086,	1763.57180,	1766.43334,	1769.29547,	1772.15819,	1775.02152,
1777.88543,	1780.74995,	1783.61505,	1786.48075,	1789.34703,	1792.21391,	1795.08138,	1797.94943,	1800.81808,	1803.68731,
1806.55713,	1809.42753,	1812.29852,	1815.17009,	1818.04225,	1820.91499,	1823.78831,	1826.66221,	1829.53669,	1832.41175,
1835.28739,	1838.16361,	1841.04041,	1843.91778,	1846.79573,	1849.67425,	1852.55334,	1855.43301,	1858.31325,	1861.19407,
1864.07545,	1866.95741,	1869.83993,	1872.72303,	1875.60669,	1878.49092,	1881.37571,	1884.26107,	1887.14700,	1890.03349,
1892.92054,	1895.80816,	1898.69634,	1901.58508,	1904.47438,	1907.36425,	1910.25467,	1913.14565,	1916.03718,	1918.92928,
1921.82193,	1924.71514,	1927.60890,	1930.50321,	1933.39808,	1936.29351,	1939.18948,	1942.08601,	1944.98308,	1947.88071,
1950.77889,	1953.67761,	1956.57689,	1959.47671,	1962.37707,	1965.27799,	1968.17944,	1971.08145,	1973.98399,	1976.88708,
1979.79072,	1982.69489,	1985.59961,	1988.50486,	1991.41066,	1994.31699,	1997.22387,	2000.13128,	2003.03923,	2005.94771,
2008.85673,	2011.76629,	2014.67638,	2017.58700,	2020.49816,	2023.40985,	2026.32207,	2029.23483,	2032.14811,	2035.06192,
2037.97627,	2040.89114,	2043.80654,	2046.72247,	2049.63892,	2052.55590,	2055.47341,	2058.39144,	2061.30999,	2064.22907,
2067.14867,	2070.06879,	2072.98944,	2075.91060,	2078.83229,	2081.75450,	2084.67722,	2087.60047,	2090.52423,	2093.44851,
2096.37330,	2099.29862,	2102.22444,	2105.15079,	2108.07764,	2111.00501,	2113.93290,	2116.86129,	2119.79020,	2122.71962,
2125.64955,	2128.57999,	2131.51094,	2134.44240,	2137.37436,	2140.30684,	2143.23982,	2146.17330,	2149.10730,	2152.04179,
2154.97680,	2157.91231,	2160.84832,	2163.78483,	2166.72185,	2169.65936,	2172.59738,	2175.53590,	2178.47492,	2181.41444,
2184.35446,	2187.29498,	2190.23599,	2193.17750,	2196.11951,	2199.06201,	2202.00501,	2204.94851,	2207.89250,	2210.83698,
2213.78196,	2216.72742,	2219.67339,	2222.61984,	2225.56678,	2228.51421,	2231.46214,	2234.41055,	2237.35945,	2240.30884,
2243.25872,	2246.20909,	2249.15994,	2252.11127,	2255.06310,	2258.01541,	2260.96820,	2263.92147,	2266.87523,	2269.82948,
2272.78420,	2275.73941,	2278.69510,	2281.65126,	2284.60791,	2287.56504,	2290.52265,	2293.48073,	2296.43930,	2299.39834,
2302.35786,	2305.31785,	2308.27832,	2311.23927,	2314.20069,	2317.16259,	2320.12495,	2323.08780,	2326.05111,	2329.01490,
2331.97916,	2334.94389,	2337.90909,	2340.87477,	2343.84091,	2346.80752,	2349.77460,	2352.74215,	2355.71016,	2358.67864,
2361.64759,	2364.61701,	2367.58689,	2370.55724,	2373.52805,	2376.49933,	2379.47107,	2382.44327,	2385.41593,	2388.38906,
2391.36265,	2394.33670,	2397.31121,	2400.28619,	2403.26162,	2406.23751,	2409.21386,	2412.19067,	2415.16793,	2418.14566,
2421.12384,	2424.10247,	2427.08157,	2430.06112,	2433.04112,	2436.02158,	2439.00249,	2441.98385,	2444.96567,	2447.94794,
2450.93067,	2453.91384,	2456.89747,	2459.88155,	2462.86607,	2465.85105,	2468.83648,	2471.82235,	2474.80868,	2477.79545,
2480.78267,	2483.77033,	2486.75845,	2489.74701,	2492.73601,	2495.72546,	2498.71535,	2501.70569,	2504.69648,	2507.68770,
2510.67937,	2513.67148,	2516.66404,	2519.65703,	2522.65047,	2525.64434,	2528.63866,	2531.63342,	2534.62861,	2537.62425,
2540.62032,	2543.61683,	2546.61378,	2549.61117,	2552.60899,	2555.60725,	2558.60595,	2561.60508,	2564.60464,	2567.60464,
2570.60508,	2573.60595,	2576.60725,	2579.60898,	2582.61115,	2585.61374,	2588.61677,	2591.62023,	2594.62413,	2597.62845,
2600.63320,	2603.63838,	2606.64399,	2609.65003,	2612.65649,	2615.66339,	2618.67071,	2621.67845,	2624.68663,	2627.69523,
2630.70425,	2633.71371,	2636.72358,	2639.73388,	2642.74461,	2645.75575,	2648.76732,	2651.77932,	2654.79173,	2657.80457,
2660.81783,	2663.83151,	2666.84561,	2669.86013,	2672.87507,	2675.89043,	2678.90621,	2681.92240,	2684.93902,	2687.95605,
2690.97350,	2693.99137,	2697.00966,	2700.02836,	2703.04747,	2706.06700,	2709.08695,	2712.10731,	2715.12809,	2718.14928,
2721.17088,	2724.19290,	2727.21532,	2730.23816,	2733.26142,	2736.28508,	2739.30916,	2742.33364,	2745.35854,	2748.38384,
2751.40956,	2754.43568,	2757.46222,	2760.48916,	2763.51651,	2766.54426,	2769.57243,	2772.60100,	2775.62998,	2778.65936,
2781.68915,	2784.71935,	2787.74995,	2790.78095,	2793.81236,	2796.84417,	2799.87639,	2802.90901,	2805.94203,	2808.97545,
2812.00928,	2815.04350,	2818.07813,	2821.11316,	2824.14859,	2827.18442,	2830.22065,	2833.25728,	2836.29431,	2839.33173,
2842.36956,	2845.40778,	2848.44640,	2851.48542,	2854.52483,	2857.56464,	2860.60485,	2863.64545,	2866.68645,	2869.72784,
2872.76963,	2875.81181,	2878.85439,	2881.89736,	2884.94072,	2887.98447,	2891.02862,	2894.07316,	2897.11809,	2900.16342,
2903.20913,	2906.25523,	2909.30173,	2912.34861,	2915.39589,	2918.44355,	2921.49161,	2924.54005,	2927.58888,	2930.63810,
2933.68770,	2936.73770,	2939.78808,	2942.83884,	2945.88999,	2948.94153,	2951.99346,	2955.04577,	2958.09846,	2961.15154,
2964.20500,	2967.25885,	2970.31308,	2973.36769,	2976.42269,	2979.47806,	2982.53382,	2985.58997,	2988.64649,	2991.70340,
2994.76068,	2997.81835,	3000.87639,	3003.93482,	3006.99362,	3010.05281,	3013.11237,	3016.17231,	3019.23263,	3022.29333,
3025.35441,	3028.41586,	3031.47769,	3034.53990,	3037.60248,	3040.66544,	3043.72877,	3046.79248,	3049.85656,	3052.92102,
3055.98585,	3059.05106,	3062.11664,	3065.18259,	3068.24892,	3071.31561,	3074.38268,	3077.45013,	3080.51794,	3083.58613,
3086.65469,	3089.72361,	3092.79291,	3095.86258,	3098.93262,	3102.00302,	3105.07380,	3108.14495,	3111.21646,	3114.28834,
3117.36059,	3120.43321,	3123.50619,	3126.57955,	3129.65326,	3132.72735,	3135.80180,	3138.87662,	3141.95180,	3145.02734,
3148.10326,	3151.17953,	3154.25617,	3157.33318,	3160.41055,	3163.48828,	3166.56637,	3169.64483,	3172.72365,	3175.80283,
3178.88237,	3181.96228,	3185.04254,	3188.12317,	3191.20415,	3194.28550,	3197.36721,	3200.44928,	3203.53170,	3206.61449,
3209.69763,	3212.78113,	3215.86500,	3218.94921,	3222.03379,	3225.11872,	3228.20401,	3231.28966,	3234.37567,	3237.46203,
3240.54874,	3243.63581,	3246.72324,	3249.81102,	3252.89916,	3255.98765,	3259.07649,	3262.16569,	3265.25524,	3268.34515,
3271.43540,	3274.52602,	3277.61698,	3280.70829,	3283.79996,	3286.89198,	3289.98435,	3293.07707,	3296.17014,	3299.26356,
3302.35733,	3305.45146,	3308.54593,	3311.64075,	3314.73592,	3317.83143,	3320.92730,	3324.02352,	3327.12008,	3330.21699,
3333.31425,	3336.41185,	3339.50980,	3342.60810,	3345.70674,	3348.80573,	3351.90507,	3355.00475,	3358.10477,	3361.20514,
3364.30586,	3367.40692,	3370.50832,	3373.61007,	3376.71216,	3379.81459,	3382.91737,	3386.02049,	3389.12395,	3392.22775,
3395.33190,	3398.43639,	3401.54121,	3404.64638,	3407.75189,	3410.85775,	3413.96394,	3417.07047,	3420.17734,	3423.28455,
3426.39210,	3429.49998,	3432.60821,	3435.71678,	3438.82568,	3441.93492,	3445.04450,	3448.15441,	3451.26467,	3454.37526,
3457.48618,	3460.59745,	3463.70904,	3466.82098,	3469.93325,	3473.04585,	3476.15879,	3479.27207,	3482.38568,	3485.49962,
3488.61390,	3491.72851,	3494.84345,	3497.95873,	3501.07434,	3504.19028,	3507.30656,	3510.42317,	3513.54011,	3516.65738,
3519.77498,	3522.89292,	3526.01118,	3529.12978,	3532.24870,	3535.36796,	3538.48754,	3541.60746,	3544.72770,	3547.84828,
3550.96918,	3554.09041,	3557.21197,	3560.33386,	3563.45608,	3566.57862,	3569.70149,	3572.82469,	3575.94821,	3579.07206,
3582.19624,	3585.32075,	3588.44558,	3591.57073,	3594.69621,	3597.82202,	3600.94815,	3604.07461,	3607.20139,	3610.32849,
3613.45592,	3616.58367,	3619.71175,	3622.84015,	3625.96887,	3629.09792,	3632.22728,	3635.35697,	3638.48699,	3641.61732,
3644.74798,	3647.87895,	3651.01025,	3654.14187,	3657.27381,	3660.40607,	3663.53865,	3666.67155,	3669.80477,	3672.93831,
3676.07216,	3679.20634,	3682.34084,	3685.47565,	3688.61078,	3691.74623,	3694.88200,	3698.01809,	3701.15449,	3704.29121,
3707.42825,	3710.56560,	3713.70328,	3716.84126,	3719.97956,	3723.11818,	3726.25712,	3729.39637,	3732.53593,	3735.67581,
3738.81600,	3741.95651,	3745.09733,	3748.23847,	3751.37992,	3754.52168,	3757.66376,	3760.80615,	3763.94885,	3767.09187,
3770.23519,	3773.37883,	3776.52278,	3779.66705,	3782.81162,	3785.95651,	3789.10170,	3792.24721,	3795.39303,	3798.53916,
3801.68559,	3804.83234,	3807.97940,	3811.12677,	3814.27444,	3817.42243,	3820.57072,	3823.71932,	3826.86824,	3830.01745,
3833.16698,	3836.31682,	3839.46696,	3842.61741,	3845.76816,	3848.91923,	3852.07060,	3855.22227,	3858.37426,	3861.52654,
3864.67914,	3867.83204,	3870.98524,	3874.13875,	3877.29257,	3880.44669,	3883.60111,	3886.75584,	3889.91087,	3893.06621,
3896.22185,	3899.37779,	3902.53404,	3905.69059,	3908.84744,	3912.00459,	3915.16205,	3918.31981,	3921.47787,	3924.63623,
3927.79489,	3930.95386,	3934.11313,	3937.27269,	3940.43256,	3943.59273,	3946.75320,	3949.91397,	3953.07504,	3956.23640,
3959.39807,	3962.56004,	3965.72230,	3968.88487,	3972.04773,	3975.21089,	3978.37435,	3981.53811,	3984.70216,	3987.86652,
3991.03117,	3994.19611,	3997.36136,	4000.52690,	4003.69274,	4006.85887,	4010.02530,	4013.19203,	4016.35905,	4019.52637,
4022.69398,	4025.86189,	4029.03009,	4032.19859,	4035.36738,	4038.53647,	4041.70585,	4044.87552,	4048.04549,	4051.21575,
4054.38631,	4057.55715,	4060.72830,	4063.89973,	4067.07146,	4070.24347,	4073.41579,	4076.58839,	4079.76128,	4082.93447,
4086.10795,	4089.28172,	4092.45578,	4095.63013,	4098.80477,	4101.97970,	4105.15492,	4108.33043,	4111.50623,	4114.68233,
4117.85871,	4121.03538,	4124.21234,	4127.38958,	4130.56712,	4133.74494,	4136.92306,	4140.10146,	4143.28015,	4146.45913,
4149.63839,	4152.81794,	4155.99778,	4159.17791,	4162.35832,	4165.53902,	4168.72000,	4171.90128,	4175.08283,	4178.26468,
4181.44681,	4184.62922,	4187.81192,	4190.99491,	4194.17818,	4197.36173,	4200.54557,	4203.72969,	4206.91410,	4210.09879,
4213.28377,	4216.46903,	4219.65457,	4222.84039,	4226.02650,	4229.21289,	4232.39957,	4235.58652,	4238.77376,	4241.96128,
4245.14908,	4248.33717,	4251.52553,	4254.71418,	4257.90311,	4261.09232,	4264.28181,	4267.47158,	4270.66163,	4273.85196,
4277.04258,	4280.23347,	4283.42464,	4286.61609,	4289.80782,	4292.99983,	4296.19212,	4299.38469,	4302.57753,	4305.77066,
4308.96406,	4312.15774,	4315.35170,	4318.54594,	4321.74045,	4324.93524,	4328.13031,	4331.32566,	4334.52128,	4337.71718,
4340.91336,	4344.10981,	4347.30654,	4350.50354,	4353.70082,	4356.89838,	4360.09621,	4363.29432,	4366.49270,	4369.69136,
4372.89029,	4376.08950,	4379.28898,	4382.48873,	4385.68876,	4388.88906,	4392.08964,	4395.29049,	4398.49162,	4401.69301,
4404.89468,	4408.09663,	4411.29884,	4414.50133,	4417.70409,	4420.90712,	4424.11043,	4427.31401,	4430.51785,	4433.72197,
4436.92637,	4440.13103,	4443.33596,	4446.54117,	4449.74664,	4452.95239,	4456.15840,	4459.36469,	4462.57124,	4465.77807,
4468.98517,	4472.19253,	4475.40016,	4478.60807,	4481.81624,	4485.02468,	4488.23339,	4491.44237,	4494.65162,	4497.86113,
4501.07092,	4504.28097,	4507.49129,	4510.70187,	4513.91272,	4517.12384,	4520.33523,	4523.54689,	4526.75881,	4529.97100,
4533.18345,	4536.39617,	4539.60916,	4542.82241,	4546.03593,	4549.24971,	4552.46376,	4555.67807,	4558.89265,	4562.10749,
4565.32260,	4568.53798,	4571.75361,	4574.96952,	4578.18568,	4581.40211,	4584.61880,	4587.83576,	4591.05298,	4594.27047,
4597.48821,	4600.70622,	4603.92450,	4607.14303,	4610.36183,	4613.58089,	4616.80021,	4620.01980,	4623.23964,	4626.45975,
4629.68012,	4632.90075,	4636.12164,	4639.34280,	4642.56421,	4645.78589,	4649.00782,	4652.23002,	4655.45248,	4658.67519,
4661.89817,	4665.12140,	4668.34490,	4671.56866,	4674.79267,	4678.01694,	4681.24148,	4684.46627,	4687.69132,	4690.91663,
4694.14220,	4697.36802,	4700.59411,	4703.82045,	4707.04705,	4710.27391,	4713.50102,	4716.72839,	4719.95602,	4723.18391,
4726.41205,	4729.64046,	4732.86911,	4736.09803,	4739.32720,	4742.55662,	4745.78630,	4749.01624,	4752.24643,	4755.47688,
4758.70759,	4761.93855,	4765.16976,	4768.40123,	4771.63296,	4774.86493,	4778.09717,	4781.32966,	4784.56240,	4787.79539,
4791.02864,	4794.26215,	4797.49591,	4800.72992,	4803.96418,	4807.19870,	4810.43347,	4813.66849,	4816.90377,	4820.13930,
4823.37508,	4826.61111,	4829.84739,	4833.08393,	4836.32072,	4839.55776,	4842.79505,	4846.03260,	4849.27039,	4852.50844,
4855.74674,	4858.98528,	4862.22408,	4865.46313,	4868.70243,	4871.94198,	4875.18178,	4878.42183,	4881.66213,	4884.90268,
4888.14348,	4891.38453,	4894.62582,	4897.86737,	4901.10917,	4904.35121,	4907.59350,	4910.83604,	4914.07883,	4917.32187,
4920.56516,	4923.80869,	4927.05247,	4930.29650,	4933.54078,	4936.78530,	4940.03008,	4943.27510,	4946.52036,	4949.76587,
4953.01163,	4956.25764,	4959.50389,	4962.75039,	4965.99713,	4969.24413,	4972.49136,	4975.73884,	4978.98657,	4982.23455,
4985.48276,	4988.73123,	4991.97994,	4995.22889,	4998.47809,	5001.72753,	5004.97722,	5008.22715,	5011.47733,	5014.72775,
5017.97841,	5021.22932,	5024.48047,	5027.73186,	5030.98350,	5034.23538,	5037.48751,	5040.73988,	5043.99249,	5047.24534,
5050.49844,	5053.75177,	5057.00535,	5060.25918,	5063.51324,	5066.76755,	5070.02209,	5073.27688,	5076.53192,	5079.78719,
5083.04270,	5086.29846,	5089.55445,	5092.81069,	5096.06717,	5099.32388,	5102.58084,	5105.83804,	5109.09548,	5112.35316,
5115.61108,	5118.86923,	5122.12763,	5125.38627,	5128.64515,	5131.90426,	5135.16362,	5138.42321,	5141.68304,	5144.94311,
5148.20342,	5151.46397,	5154.72476,	5157.98578,	5161.24705,	5164.50855,	5167.77029,	5171.03226,	5174.29448,	5177.55693,
5180.81962,	5184.08254,	5187.34570,	5190.60910,	5193.87274,	5197.13661,	5200.40072,	5203.66507,	5206.92965,	5210.19447,
5213.45952,	5216.72481,	5219.99033,	5223.25610,	5226.52209,	5229.78832,	5233.05479,	5236.32149,	5239.58843,	5242.85560,
5246.12301,	5249.39065,	5252.65852,	5255.92663,	5259.19498,	5262.46356,	5265.73237,	5269.00141,	5272.27069,	5275.54021,
5278.80995,	5282.07993,	5285.35014,	5288.62059,	5291.89127,	5295.16218,	5298.43333,	5301.70470,	5304.97631,	5308.24815,
5311.52023,	5314.79253,	5318.06507,	5321.33784,	5324.61084,	5327.88407,	5331.15754,	5334.43123,	5337.70516,	5340.97932,
5344.25371,	5347.52833,	5350.80318,	5354.07826,	5357.35357,	5360.62911,	5363.90488,	5367.18089,	5370.45712,	5373.73358,
5377.01027,	5380.28719,	5383.56434,	5386.84172,	5390.11933,	5393.39717,	5396.67524,	5399.95353,	5403.23206,	5406.51081,
5409.78979,	5413.06900,	5416.34844,	5419.62811,	5422.90801,	5426.18813,	5429.46848,	5432.74906,	5436.02986,	5439.31090,
5442.59216,	5445.87365,	5449.15536,	5452.43730,	5455.71947,	5459.00187,	5462.28449,	5465.56734,	5468.85041,	5472.13371,
5475.41724,	5478.70099,	5481.98497,	5485.26918,	5488.55361,	5491.83827,	5495.12315,	5498.40825,	5501.69359,	5504.97914,
5508.26493,	5511.55093,	5514.83716,	5518.12362,	5521.41030,	5524.69721,	5527.98434,	5531.27169,	5534.55927,	5537.84707,
5541.13510,	5544.42335,	5547.71182,	5551.00051,	5554.28943,	5557.57858,	5560.86794,	5564.15753,	5567.44734,	5570.73738,
5574.02764,	5577.31812,	5580.60882,	5583.89974,	5587.19089,	5590.48226,	5593.77385,	5597.06566,	5600.35770,	5603.64995,
5606.94243,	5610.23513,	5613.52805,	5616.82119,	5620.11455,	5623.40814,	5626.70194,	5629.99597,	5633.29021,	5636.58468,
5639.87936,	5643.17427,	5646.46940,	5649.76475,	5653.06031,	5656.35610,	5659.65211,	5662.94833,	5666.24478,	5669.54144,
5672.83833,	5676.13543,	5679.43275,	5682.73030,	5686.02806,	5689.32604,	5692.62423,	5695.92265,	5699.22128,	5702.52014,
5705.81921,	5709.11850,	5712.41801,	5715.71773,	5719.01767,	5722.31783,	5725.61821,	5728.91881,	5732.21962,	5735.52065,
5738.82190,	5742.12336,	5745.42504,	5748.72694,	5752.02905,	5755.33139,	5758.63393,	5761.93670,	5765.23968,	5768.54287,
5771.84628,	5775.14991,	5778.45376,	5781.75782,	5785.06209,	5788.36658,	5791.67129,	5794.97621,	5798.28135,	5801.58670,
5804.89226,	5808.19804,	5811.50404,	5814.81025,	5818.11668,	5821.42331,	5824.73017,	5828.03724,	5831.34452,	5834.65201,
5837.95972,	5841.26765,	5844.57579,	5847.88414,	5851.19270,	5854.50148,	5857.81047,	5861.11967,	5864.42909,	5867.73872,
5871.04856,	5874.35862,	5877.66889,	5880.97937,	5884.29006,	5887.60097,	5890.91209,	5894.22342,	5897.53496,	5900.84671,
5904.15868,	5907.47085,	5910.78324,	5914.09584,	5917.40866,	5920.72168,	5924.03491,	5927.34836,	5930.66202,	5933.97588,
5937.28996,	5940.60425,	5943.91875,	5947.23346,	5950.54838,	5953.86351,	5957.17885,	5960.49440,	5963.81016,	5967.12613,
5970.44231,	5973.75870,	5977.07530,	5980.39211,	5983.70913,	5987.02635,	5990.34379,	5993.66144,	5996.97929,	6000.29735,
6003.61563,	6006.93411,	6010.25280,	6013.57169,	6016.89080,	6020.21011,	6023.52964,	6026.84937,	6030.16930,	6033.48945,
6036.80981,	6040.13037,	6043.45114,	6046.77211,	6050.09330,	6053.41469,	6056.73629,	6060.05809,	6063.38010,	6066.70232,
6070.02475,	6073.34738,	6076.67022,	6079.99327,	6083.31652,	6086.63998,	6089.96364,	6093.28751,	6096.61159,	6099.93587,
6103.26036,	6106.58505,	6109.90995,	6113.23506,	6116.56037,	6119.88588,	6123.21161,	6126.53753,	6129.86366,	6133.19000,
6136.51654,	6139.84328,	6143.17023,	6146.49739,	6149.82475,	6153.15231,	6156.48008,	6159.80805,	6163.13623,	6166.46461,
6169.79319,	6173.12198,	6176.45097,	6179.78016,	6183.10956,	6186.43916,	6189.76897,	6193.09897,	6196.42918,	6199.75960,
6203.09021,	6206.42103,	6209.75206,	6213.08328,	6216.41471,	6219.74634,	6223.07817,	6226.41020,	6229.74244,	6233.07488,
6236.40752,	6239.74036,	6243.07341,	6246.40665,	6249.74010,	6253.07375,	6256.40760,	6259.74165,	6263.07590,	6266.41036,
6269.74501,	6273.07987,	6276.41492,	6279.75018,	6283.08564,	6286.42130,	6289.75715,	6293.09321,	6296.42947,	6299.76593,
6303.10259,	6306.43945,	6309.77651,	6313.11377,	6316.45123,	6319.78889,	6323.12675,	6326.46481,	6329.80306,	6333.14152,
6336.48018,	6339.81903,	6343.15808,	6346.49734,	6349.83679,	6353.17644,	6356.51629,	6359.85633,	6363.19658,	6366.53702,
6369.87767,	6373.21851,	6376.55955,	6379.90078,	6383.24222,	6386.58385,	6389.92568,	6393.26771,	6396.60993,	6399.95236,
6403.29498,	6406.63779,	6409.98081,	6413.32402,	6416.66743,	6420.01103,	6423.35484,	6426.69883,	6430.04303,	6433.38742,
6436.73201,	6440.07680,	6443.42178,	6446.76696,	6450.11233,	6453.45790,	6456.80366,	6460.14963,	6463.49578,	6466.84214,
6470.18868,	6473.53543,	6476.88237,	6480.22950,	6483.57683,	6486.92436,	6490.27208,	6493.61999,	6496.96810,	6500.31641,
6503.66491,	6507.01360,	6510.36249,	6513.71157,	6517.06085,	6520.41032,	6523.75999,	6527.10985,	6530.45990,	6533.81015,
6537.16059,	6540.51123,	6543.86206,	6547.21308,	6550.56430,	6553.91571,	6557.26731,	6560.61911,	6563.97110,	6567.32328,
6570.67565,	6574.02822,	6577.38098,	6580.73394,	6584.08708,	6587.44042,	6590.79395,	6594.14768,	6597.50160,	6600.85570,
6604.21000,	6607.56450,	6610.91918,	6614.27406,	6617.62913,	6620.98439,	6624.33984,	6627.69548,	6631.05131,	6634.40734,
6637.76356,	6641.11997,	6644.47657,	6647.83336,	6651.19034,	6654.54751,	6657.90487,	6661.26243,	6664.62017,	6667.97811,
6671.33623,	6674.69455,	6678.05305,	6681.41175,	6684.77063,	6688.12971,	6691.48898,	6694.84843,	6698.20808,	6701.56791,
6704.92794,	6708.28815,	6711.64856,	6715.00915,	6718.36993,	6721.73091,	6725.09207,	6728.45342,	6731.81496,	6735.17668,
6738.53860,	6741.90071,	6745.26300,	6748.62548,	6751.98815,	6755.35101,	6758.71406,	6762.07730,	6765.44072,	6768.80433,
6772.16813,	6775.53212,	6778.89630,	6782.26066,	6785.62521,	6788.98995,	6792.35487,	6795.71999,	6799.08529,	6802.45078,
6805.81645,	6809.18231,	6812.54836,	6815.91460,	6819.28102,	6822.64763,	6826.01443,	6829.38141,	6832.74858,	6836.11594,
6839.48348,	6842.85121,	6846.21912,	6849.58722,	6852.95551,	6856.32398,	6859.69264,	6863.06149,	6866.43052,	6869.79973,
6873.16913,	6876.53872,	6879.90849,	6883.27845,	6886.64859,	6890.01892,	6893.38943,	6896.76013,	6900.13102,	6903.50208,
6906.87334,	6910.24477,	6913.61640,	6916.98820,	6920.36019,	6923.73237,	6927.10473,	6930.47727,	6933.85000,	6937.22291,
6940.59601,	6943.96929,	6947.34275,	6950.71640,	6954.09023,	6957.46424,	6960.83844,	6964.21282,	6967.58739,	6970.96214,
6974.33707,	6977.71218,	6981.08748,	6984.46296,	6987.83863,	6991.21447,	6994.59050,	6997.96671,	7001.34311,	7004.71968,
7008.09644,	7011.47339,	7014.85051,	7018.22782,	7021.60530,	7024.98297,	7028.36083,	7031.73886,	7035.11708,	7038.49548,
7041.87406,	7045.25282,	7048.63176,	7052.01088,	7055.39019,	7058.76968,	7062.14934,	7065.52919,	7068.90922,	7072.28943,
7075.66983,	7079.05040,	7082.43115,	7085.81209,	7089.19320,	7092.57450,	7095.95597,	7099.33763,	7102.71947,	7106.10148,
7109.48368,	7112.86606,	7116.24862,	7119.63135,	7123.01427,	7126.39737,	7129.78064,	7133.16410,	7136.54774,	7139.93155,
7143.31555,	7146.69972,	7150.08407,	7153.46861,	7156.85332,	7160.23821,	7163.62328,	7167.00853,	7170.39396,	7173.77956,
7177.16535,	7180.55131,	7183.93745,	7187.32377,	7190.71027,	7194.09695,	7197.48380,	7200.87084,	7204.25805,	7207.64544,
7211.03301,	7214.42075,	7217.80868,	7221.19678,	7224.58506,	7227.97351,	7231.36215,	7234.75096,	7238.13995,	7241.52911,
7244.91846,	7248.30798,	7251.69768,	7255.08755,	7258.47760,	7261.86783,	7265.25823,	7268.64882,	7272.03958,	7275.43051,
7278.82162,	7282.21291,	7285.60437,	7288.99601,	7292.38783,	7295.77982,	7299.17199,	7302.56434,	7305.95686,	7309.34956,
7312.74243,	7316.13548,	7319.52870,	7322.92210,	7326.31568,	7329.70943,	7333.10335,	7336.49746,	7339.89173,	7343.28618,
7346.68081,	7350.07561,	7353.47059,	7356.86574,	7360.26107,	7363.65657,	7367.05224,	7370.44809,	7373.84412,	7377.24032,
7380.63669,	7384.03324,	7387.42996,	7390.82686,	7394.22393,	7397.62117,	7401.01859,	7404.41619,	7407.81395,	7411.21189,
7414.61001,	7418.00829,	7421.40675,	7424.80539,	7428.20420,	7431.60318,	7435.00233,	7438.40166,	7441.80116,	7445.20083,
7448.60068,	7452.00070,	7455.40089,	7458.80126,	7462.20179,	7465.60251,	7469.00339,	7472.40444,	7475.80567,	7479.20707,
7482.60865,	7486.01039,	7489.41231,	7492.81440,	7496.21666,	7499.61909,	7503.02170,	7506.42447,	7509.82742,	7513.23054,
7516.63384,	7520.03730,	7523.44093,	7526.84474,	7530.24872,	7533.65287,	7537.05719,	7540.46168,	7543.86634,	7547.27118,
7550.67618,	7554.08136,	7557.48670,	7560.89222,	7564.29791,	7567.70377,	7571.10980,	7574.51600,	7577.92237,	7581.32891,
7584.73562,	7588.14250,	7591.54955,	7594.95677,	7598.36416,	7601.77172,	7605.17945,	7608.58735,	7611.99542,	7615.40366,
7618.81207,	7622.22065,	7625.62940,	7629.03832,	7632.44740,	7635.85666,	7639.26609,	7642.67568,	7646.08545,	7649.49538,
7652.90548,	7656.31575,	7659.72619,	7663.13680,	7666.54758,	7669.95852,	7673.36964,	7676.78092,	7680.19237,	7683.60399,
7687.01578,	7690.42774,	7693.83986,	7697.25215,	7700.66461,	7704.07724,	7707.49004,	7710.90300,	7714.31613,	7717.72943,
7721.14290,	7724.55654,	7727.97034,	7731.38431,	7734.79845,	7738.21275,	7741.62722,	7745.04186,	7748.45667,	7751.87164,
7755.28678,	7758.70209,	7762.11756,	7765.53321,	7768.94901,	7772.36499,	7775.78113,	7779.19744,	7782.61391,	7786.03055,
7789.44736,	7792.86433,	7796.28147,	7799.69878,	7803.11625,	7806.53388,	7809.95169,	7813.36966,	7816.78779,	7820.20610,
7823.62456,	7827.04319,	7830.46199,	7833.88096,	7837.30009,	7840.71938,	7844.13884,	7847.55847,	7850.97826,	7854.39821,
7857.81833,	7861.23862,	7864.65907,	7868.07969,	7871.50047,	7874.92141,	7878.34252,	7881.76380,	7885.18524,	7888.60684,
7892.02861,	7895.45054,	7898.87264,	7902.29490,	7905.71733,	7909.13992,	7912.56267,	7915.98559,	7919.40867,	7922.83192,
7926.25533,	7929.67890,	7933.10264,	7936.52654,	7939.95060,	7943.37483,	7946.79922,	7950.22378,	7953.64849,	7957.07338,
7960.49842,	7963.92363,	7967.34900,	7970.77453,	7974.20023,	7977.62609,	7981.05211,	7984.47830,	7987.90465,	7991.33116,
7994.75783,	7998.18467,	8001.61167,	8005.03883,	8008.46615,	8011.89364,	8015.32129,	8018.74910,	8022.17707,	8025.60521,
8029.03350,	8032.46196,	8035.89058,	8039.31937,	8042.74831,	8046.17742,	8049.60668,	8053.03611,	8056.46570,	8059.89546,
8063.32537,	8066.75545,	8070.18568,	8073.61608,	8077.04664,	8080.47736,	8083.90824,	8087.33928,	8090.77048,	8094.20185,
8097.63337,	8101.06506,	8104.49690,	8107.92891,	8111.36108,	8114.79341,	8118.22589,	8121.65854,	8125.09135,	8128.52432,
8131.95745,	8135.39074,	8138.82419,	8142.25780,	8145.69157,	8149.12550,	8152.55959,	8155.99384,	8159.42825,	8162.86282,
8166.29754,	8169.73243,	8173.16748,	8176.60269,	8180.03805,	8183.47358,	8186.90926,	8190.34511,	8193.78111,	8197.21728,
8200.65360,	8204.09008,	8207.52672,	8210.96352,	8214.40047,	8217.83759,	8221.27486,	8224.71230,	8228.14989,	8231.58764,
8235.02555,	8238.46362,	8241.90184,	8245.34023,	8248.77877,	8252.21747,	8255.65633,	8259.09534,	8262.53452,	8265.97385,
8269.41334,	8272.85299,	8276.29280,	8279.73276,	8283.17288,	8286.61316,	8290.05360,	8293.49419,	8296.93494,	8300.37585,
8303.81692,	8307.25814,	8310.69953,	8314.14106,	8317.58276,	8321.02461,	8324.46662,	8327.90879,	8331.35111,	8334.79359,
8338.23622,	8341.67902,	8345.12197,	8348.56507,	8352.00834,	8355.45176,	8358.89533,	8362.33906,	8365.78295,	8369.22700,
8372.67120,	8376.11556,	8379.56007,	8383.00474,	8386.44956,	8389.89455,	8393.33968,	8396.78497,	8400.23042,	8403.67603,
8407.12179,	8410.56770,	8414.01377,	8417.46000,	8420.90638,	8424.35292,	8427.79961,	8431.24646,	8434.69346,	8438.14062,
8441.58793,	8445.03540,	8448.48302,	8451.93080,	8455.37874,	8458.82682,	8462.27507,	8465.72346,	8469.17201,	8472.62072,
8476.06958,	8479.51860,	8482.96777,	8486.41709,	8489.86657,	8493.31620,	8496.76599,	8500.21593,	8503.66602,	8507.11627,
8510.56668,	8514.01723,	8517.46794,	8520.91881,	8524.36983,	8527.82100,	8531.27233,	8534.72381,	8538.17544,	8541.62722,
8545.07916,	8548.53126,	8551.98350,	8555.43590,	8558.88846,	8562.34116,	8565.79402,	8569.24704,	8572.70020,	8576.15352,
8579.60699,	8583.06061,	8586.51439,	8589.96832,	8593.42240,	8596.87664,	8600.33103,	8603.78557,	8607.24026,	8610.69510,
8614.15010,	8617.60525,	8621.06055,	8624.51601,	8627.97161,	8631.42737,	8634.88328,	8638.33934,	8641.79556,	8645.25192,
8648.70844,	8652.16511,	8655.62193,	8659.07890,	8662.53603,	8665.99330,	8669.45073,	8672.90831,	8676.36604,	8679.82392,
8683.28196,	8686.74014,	8690.19848,	8693.65696,	8697.11560,	8700.57439,	8704.03333,	8707.49242,	8710.95166,	8714.41106,
8717.87060,	8721.33029,	8724.79014,	8728.25013,	8731.71028,	8735.17057,	8738.63102,	8742.09162,	8745.55237,	8749.01326,
8752.47431,	8755.93551,	8759.39686,	8762.85836,	8766.32001,	8769.78180,	8773.24375,	8776.70585,	8780.16810,	8783.63050,
8787.09305,	8790.55574,	8794.01859,	8797.48159,	8800.94473,	8804.40803,	8807.87147,	8811.33507,	8814.79881,	8818.26270,
8821.72675,	8825.19094,	8828.65528,	8832.11977,	8835.58441,	8839.04919,	8842.51413,	8845.97922,	8849.44445,	8852.90983,
8856.37536,	8859.84104,	8863.30687,	8866.77285,	8870.23898,	8873.70525,	8877.17167,	8880.63824,	8884.10496,	8887.57183,
8891.03885,	8894.50601,	8897.97332,	8901.44078,	8904.90839,	8908.37615,	8911.84405,	8915.31210,	8918.78030,	8922.24865,
8925.71715,	8929.18579,	8932.65458,	8936.12352,	8939.59260,	8943.06183,	8946.53121,	8950.00074,	8953.47042,	8956.94024,
8960.41021,	8963.88032,	8967.35059,	8970.82100,	8974.29156,	8977.76226,	8981.23311,	8984.70411,	8988.17525,	8991.64655,
8995.11798,	8998.58957,	9002.06130,	9005.53318,	9009.00520,	9012.47738,	9015.94969,	9019.42216,	9022.89477,	9026.36752,
9029.84043,	9033.31348,	9036.78667,	9040.26001,	9043.73350,	9047.20713,	9050.68091,	9054.15483,	9057.62890,	9061.10312,
9064.57748,	9068.05199,	9071.52664,	9075.00144,	9078.47639,	9081.95148,	9085.42671,	9088.90209,	9092.37762,	9095.85329,
9099.32911,	9102.80507,	9106.28117,	9109.75743,	9113.23382,	9116.71036,	9120.18705,	9123.66388,	9127.14086,	9130.61798,
9134.09525,	9137.57266,	9141.05021,	9144.52791,	9148.00576,	9151.48375,	9154.96188,	9158.44016,	9161.91858,	9165.39715,
9168.87586,	9172.35471,	9175.83371,	9179.31285,	9182.79214,	9186.27157,	9189.75115,	9193.23087,	9196.71073,	9200.19074,
9203.67089,	9207.15118,	9210.63162,	9214.11220,	9217.59293,	9221.07380,	9224.55481,	9228.03597,	9231.51726,	9234.99871,
9238.48029,	9241.96202,	9245.44389,	9248.92591,	9252.40807,	9255.89037,	9259.37282,	9262.85540,	9266.33813,	9269.82101,
9273.30402,	9276.78718,	9280.27049,	9283.75393,	9287.23752,	9290.72125,	9294.20512,	9297.68913,	9301.17329,	9304.65759,
9308.14203,	9311.62662,	9315.11135,	9318.59621,	9322.08123,	9325.56638,	9329.05167,	9332.53711,	9336.02269,	9339.50841,
9342.99428,	9346.48028,	9349.96643,	9353.45272,	9356.93915,	9360.42572,	9363.91243,	9367.39929,	9370.88629,	9374.37342,
9377.86070,	9381.34813,	9384.83569,	9388.32339,	9391.81124,	9395.29922,	9398.78735,	9402.27562,	9405.76403,	9409.25258,
9412.74127,	9416.23010,	9419.71908,	9423.20819,	9426.69745,	9430.18684,	9433.67638,	9437.16606,	9440.65587,	9444.14583,
9447.63593,	9451.12617,	9454.61655,	9458.10707,	9461.59773,	9465.08853,	9468.57947,	9472.07056,	9475.56178,	9479.05314,
9482.54464,	9486.03628,	9489.52806,	9493.01999,	9496.51205,	9500.00425,	9503.49659,	9506.98907,	9510.48169,	9513.97445,
9517.46735,	9520.96039,	9524.45357,	9527.94689,	9531.44035,	9534.93395,	9538.42768,	9541.92156,	9545.41557,	9548.90973,
9552.40402,	9555.89846,	9559.39303,	9562.88774,	9566.38259,	9569.87758,	9573.37271,	9576.86797,	9580.36338,	9583.85892,
9587.35460,	9590.85043,	9594.34639,	9597.84249,	9601.33872,	9604.83510,	9608.33161,	9611.82827,	9615.32506,	9618.82199,
9622.31906,	9625.81626,	9629.31361,	9632.81109,	9636.30871,	9639.80647,	9643.30437,	9646.80240,	9650.30057,	9653.79888,
9657.29733,	9660.79592,	9664.29464,	9667.79350,	9671.29250,	9674.79164,	9678.29091,	9681.79033,	9685.28988,	9688.78956,
9692.28939,	9695.78935,	9699.28945,	9702.78969,	9706.29006,	9709.79057,	9713.29122,	9716.79200,	9720.29293,	9723.79398,
9727.29518,	9730.79651,	9734.29798,	9737.79959,	9741.30133,	9744.80322,	9748.30523,	9751.80739,	9755.30968,	9758.81210,
9762.31467,	9765.81737,	9769.32020,	9772.82318,	9776.32629,	9779.82953,	9783.33291,	9786.83643,	9790.34009,	9793.84388,
9797.34781,	9800.85187,	9804.35607,	9807.86040,	9811.36487,	9814.86948,	9818.37422,	9821.87910,	9825.38411,	9828.88926,
9832.39455,	9835.89997,	9839.40553,	9842.91122,	9846.41705,	9849.92301,	9853.42911,	9856.93535,	9860.44172,	9863.94822,
9867.45486,	9870.96164,	9874.46855,	9877.97559,	9881.48277,	9884.99009,	9888.49754,	9892.00513,	9895.51285,	9899.02070,
9902.52869,	9906.03682,	9909.54508,	9913.05348,	9916.56201,	9920.07067,	9923.57947,	9927.08840,	9930.59747,	9934.10667,
9937.61601,	9941.12548,	9944.63509,	9948.14483,	9951.65470,	9955.16471,	9958.67485,	9962.18513,	9965.69554,	9969.20609,
9972.71676,	9976.22758,	9979.73852,	9983.24961,	9986.76082,	9990.27217,	9993.78365,	9997.29527,	10000.80702,	10004.31890,
10007.83092,	10011.34307,	10014.85535,	10018.36777,	10021.88032,	10025.39300,	10028.90582,	10032.41877,	10035.93186,	10039.44508,
10042.95843,	10046.47191,	10049.98553,	10053.49928,	10057.01316,	10060.52718,	10064.04133,	10067.55561,	10071.07002,	10074.58457,
10078.09925,	10081.61406,	10085.12901,	10088.64409,	10092.15930,	10095.67464,	10099.19012,	10102.70573,	10106.22147,	10109.73734,
10113.25335,	10116.76949,	10120.28576,	10123.80216,	10127.31870,	10130.83537,	10134.35217,	10137.86910,	10141.38616,	10144.90336,
10148.42069,	10151.93815,	10155.45574,	10158.97346,	10162.49132,	10166.00930,	10169.52742,	10173.04567,	10176.56406,	10180.08257,
10183.60121,	10187.11999,	10190.63890,	10194.15794,	10197.67711,	10201.19641,	10204.71585,	10208.23541,	10211.75511,	10215.27494,
10218.79490,	10222.31499,	10225.83521,	10229.35556,	10232.87605,	10236.39666,	10239.91741,	10243.43828,	10246.95929,	10250.48043,
10254.00170,	10257.52310,	10261.04463,	10264.56629,	10268.08808,	10271.61000,	10275.13205,	10278.65424,	10282.17655,	10285.69900,
10289.22157,	10292.74428,	10296.26711,	10299.79008,	10303.31317,	10306.83640,	10310.35975,	10313.88324,	10317.40686,	10320.93060,
10324.45448,	10327.97849,	10331.50262,	10335.02689,	10338.55129,	10342.07581,	10345.60047,	10349.12525,	10352.65017,	10356.17521,
10359.70039,	10363.22569,	10366.75112,	10370.27669,	10373.80238,	10377.32820,	10380.85415,	10384.38023,	10387.90644,	10391.43278,
10394.95925,	10398.48585,	10402.01258,	10405.53943,	10409.06642,	10412.59353,	10416.12077,	10419.64815,	10423.17565,	10426.70328,
10430.23104,	10433.75892,	10437.28694,	10440.81509,	10444.34336,	10447.87176,	10451.40029,	10454.92895,	10458.45774,	10461.98666,
10465.51570,	10469.04488,	10472.57418,	10476.10361,	10479.63317,	10483.16285,	10486.69267,	10490.22261,	10493.75268,	10497.28288,
10500.81321,	10504.34367,	10507.87425,	10511.40496,	10514.93580,	10518.46677,	10521.99787,	10525.52909,	10529.06044,	10532.59192,
10536.12353,	10539.65526,	10543.18712,	10546.71911,	10550.25123,	10553.78347,	10557.31585,	10560.84835,	10564.38097,	10567.91373,
10571.44661,	10574.97962,	10578.51275,	10582.04602,	10585.57941,	10589.11293,	10592.64657,	10596.18034,	10599.71424,	10603.24827,
10606.78242,	10610.31670,	10613.85111,	10617.38564,	10620.92030,	10624.45509,	10627.99000,	10631.52504,	10635.06021,	10638.59551,
10642.13093,	10645.66647,	10649.20215,	10652.73795,	10656.27388,	10659.80993,	10663.34611,	10666.88241,	10670.41885,	10673.95540,
10677.49209,	10681.02890,	10684.56584,	10688.10290,	10691.64009,	10695.17740,	10698.71485,	10702.25241,	10705.79011,	10709.32793,
10712.86587,	10716.40394,	10719.94214,	10723.48046,	10727.01891,	10730.55748,	10734.09618,	10737.63501,	10741.17396,	10744.71303,
10748.25223,	10751.79156,	10755.33101,	10758.87059,	10762.41030,	10765.95012,	10769.49008,	10773.03016,	10776.57036,	10780.11069,
10783.65115,	10787.19172,	10790.73243,	10794.27326,	10797.81421,	10801.35529,	10804.89650,	10808.43783,	10811.97928,	10815.52086,
10819.06257,	10822.60439,	10826.14635,	10829.68843,	10833.23063,	10836.77296,	10840.31541,	10843.85798,	10847.40069,	10850.94351,
10854.48646,	10858.02954,	10861.57273,	10865.11606,	10868.65950,	10872.20308,	10875.74677,	10879.29059,	10882.83453,	10886.37860,
10889.92279,	10893.46711,	10897.01155,	10900.55612,	10904.10080,	10907.64562,	10911.19055,	10914.73561,	10918.28079,	10921.82610,
10925.37153,	10928.91709,	10932.46276,	10936.00857,	10939.55449,	10943.10054,	10946.64671,	10950.19301,	10953.73943,	10957.28597,
10960.83264,	10964.37943,	10967.92634,	10971.47337,	10975.02053,	10978.56782,	10982.11522,	10985.66275,	10989.21040,	10992.75818,
10996.30607,	10999.85409,	11003.40224,	11006.95051,	11010.49889,	11014.04741,	11017.59604,	11021.14480,	11024.69368,	11028.24268,
11031.79181,	11035.34106,	11038.89043,	11042.43992,	11045.98954,	11049.53928,	11053.08914,	11056.63912,	11060.18923,	11063.73946,
11067.28981,	11070.84028,	11074.39088,	11077.94159,	11081.49243,	11085.04339,	11088.59448,	11092.14568,	11095.69701,	11099.24846,
11102.80003,	11106.35173,	11109.90354,	11113.45548,	11117.00754,	11120.55972,	11124.11203,	11127.66445,	11131.21700,	11134.76967,
11138.32246,	11141.87537,	11145.42840,	11148.98155,	11152.53483,	11156.08823,	11159.64175,	11163.19539,	11166.74915,	11170.30303,
11173.85704,	11177.41116,	11180.96541,	11184.51978,	11188.07427,	11191.62888,	11195.18361,	11198.73846,	11202.29343,	11205.84853,
11209.40374,	11212.95908,	11216.51454,	11220.07011,	11223.62581,	11227.18163,	11230.73757,	11234.29363,	11237.84982,	11241.40612,
11244.96254,	11248.51909,	11252.07575,	11255.63254,	11259.18944,	11262.74647,	11266.30361,	11269.86088,	11273.41827,	11276.97577,
11280.53340,	11284.09115,	11287.64902,	11291.20700,	11294.76511,	11298.32334,	11301.88169,	11305.44016,	11308.99875,	11312.55746,
11316.11628,	11319.67523,	11323.23430,	11326.79349,	11330.35280,	11333.91222,	11337.47177,	11341.03144,	11344.59123,	11348.15113,
11351.71116,	11355.27130,	11358.83157,	11362.39196,	11365.95246,	11369.51308,	11373.07383,	11376.63469,	11380.19567,	11383.75677,
11387.31799,	11390.87933,	11394.44079,	11398.00237,	11401.56407,	11405.12589,	11408.68782,	11412.24988,	11415.81205,	11419.37434,
11422.93675,	11426.49929,	11430.06193,	11433.62470,	11437.18759,	11440.75060,	11444.31372,	11447.87697,	11451.44033,	11455.00381,
11458.56741,	11462.13113,	11465.69496,	11469.25892,	11472.82299,	11476.38719,	11479.95150,	11483.51593,	11487.08047,	11490.64514,
11494.20992,	11497.77483,	11501.33985,	11504.90499,	11508.47024,	11512.03562,	11515.60111,	11519.16673,	11522.73246,	11526.29830,
11529.86427,	11533.43035,	11536.99655,	11540.56287,	11544.12931,	11547.69587,	11551.26254,	11554.82933,	11558.39624,	11561.96327,
11565.53041,	11569.09767,	11572.66505,	11576.23255,	11579.80016,	11583.36789,	11586.93574,	11590.50371,	11594.07179,	11597.64000,
11601.20832,	11604.77675,	11608.34531,	11611.91398,	11615.48276,	11619.05167,	11622.62069,	11626.18983,	11629.75909,	11633.32846,
11636.89795,	11640.46756,	11644.03729,	11647.60713,	11651.17709,	11654.74716,	11658.31736,	11661.88767,	11665.45809,	11669.02863,
11672.59929,	11676.17007,	11679.74096,	11683.31197,	11686.88310,	11690.45434,	11694.02570,	11697.59718,	11701.16877,	11704.74048,
11708.31230,	11711.88425,	11715.45630,	11719.02848,	11722.60077,	11726.17318,	11729.74570,	11733.31834,	11736.89109,	11740.46397,
11744.03695,	11747.61006,	11751.18328,	11754.75661,	11758.33006,	11761.90363,	11765.47732,	11769.05112,	11772.62503,	11776.19906,
11779.77321,	11783.34747,	11786.92185,	11790.49634,	11794.07095,	11797.64568,	11801.22052,	11804.79548,	11808.37055,	11811.94574,
11815.52104,	11819.09646,	11822.67199,	11826.24764,	11829.82341,	11833.39929,	11836.97529,	11840.55140,	11844.12762,	11847.70396,
11851.28042,	11854.85699,	11858.43368,	11862.01048,	11865.58740,	11869.16443,	11872.74158,	11876.31884,	11879.89622,	11883.47371,
11887.05131,	11890.62904,	11894.20687,	11897.78482,	11901.36289,	11904.94107,	11908.51936,	11912.09777,	11915.67630,	11919.25494,
11922.83369,	11926.41256,	11929.99154,	11933.57064,	11937.14985,	11940.72918,	11944.30862,	11947.88817,	11951.46784,	11955.04763,
11958.62753,	11962.20754,	11965.78766,	11969.36790,	11972.94826,	11976.52873,	11980.10931,	11983.69001,	11987.27082,	11990.85174,
11994.43278,	11998.01394,	12001.59520,	12005.17658,	12008.75808,	12012.33969,	12015.92141,	12019.50324,	12023.08519,	12026.66726,
12030.24943,	12033.83172,	12037.41413,	12040.99665,	12044.57928,	12048.16202,	12051.74488,	12055.32785,	12058.91094,	12062.49414,
12066.07745,	12069.66088,	12073.24441,	12076.82807,	12080.41183,	12083.99571,	12087.57970,	12091.16381,	12094.74802,	12098.33236,
12101.91680,	12105.50136,	12109.08603,	12112.67081,	12116.25571,	12119.84072,	12123.42584,	12127.01107,	12130.59642,	12134.18188,
12137.76746,	12141.35314,	12144.93894,	12148.52485,	12152.11088,	12155.69701,	12159.28326,	12162.86963,	12166.45610,	12170.04269,
12173.62939,	12177.21620,	12180.80313,	12184.39016,	12187.97731,	12191.56457,	12195.15195,	12198.73943,	12202.32703,	12205.91474,
12209.50257,	12213.09050,	12216.67855,	12220.26671,	12223.85498,	12227.44337,	12231.03186,	12234.62047,	12238.20919,	12241.79802,
12245.38696,	12248.97602,	12252.56519,	12256.15447,	12259.74386,	12263.33336,	12266.92297,	12270.51270,	12274.10254,	12277.69249,
12281.28255,	12284.87272,	12288.46301,	12292.05340,	12295.64391,	12299.23453,	12302.82526,	12306.41610,	12310.00705,	12313.59812,
12317.18930,	12320.78058,	12324.37198,	12327.96349,	12331.55511,	12335.14684,	12338.73869,	12342.33064,	12345.92271,	12349.51488,
12353.10717,	12356.69957,	12360.29208,	12363.88470,	12367.47743,	12371.07028,	12374.66323,	12378.25629,	12381.84947,	12385.44276,
12389.03615,	12392.62966,	12396.22328,	12399.81701,	12403.41085,	12407.00480,	12410.59886,	12414.19303,	12417.78731,	12421.38170,
12424.97621,	12428.57082,	12432.16555,	12435.76038,	12439.35532,	12442.95038,	12446.54554,	12450.14082,	12453.73621,	12457.33170,
12460.92731,	12464.52303,	12468.11885,	12471.71479,	12475.31084,	12478.90699,	12482.50326,	12486.09964,	12489.69612,	12493.29272,
12496.88943,	12500.48625,	12504.08317,	12507.68021,	12511.27736,	12514.87461,	12518.47198,	12522.06945,	12525.66704,	12529.26473,
12532.86254,	12536.46045,	12540.05848,	12543.65661,	12547.25485,	12550.85321,	12554.45167,	12558.05024,	12561.64892,	12565.24771,
12568.84661,	12572.44562,	12576.04474,	12579.64397,	12583.24331,	12586.84275,	12590.44231,	12594.04197,	12597.64175,	12601.24163,
12604.84162,	12608.44172,	12612.04193,	12615.64225,	12619.24268,	12622.84322,	12626.44386,	12630.04462,	12633.64548,	12637.24646,
12640.84754,	12644.44873,	12648.05003,	12651.65144,	12655.25295,	12658.85458,	12662.45631,	12666.05816,	12669.66011,	12673.26217,
12676.86434,	12680.46661,	12684.06900,	12687.67149,	12691.27409,	12694.87681,	12698.47962,	12702.08255,	12705.68559,	12709.28873,
12712.89199,	12716.49535,	12720.09882,	12723.70239,	12727.30608,	12730.90987,	12734.51377,	12738.11778,	12741.72190,	12745.32613,
12748.93046,	12752.53490,	12756.13945,	12759.74411,	12763.34888,	12766.95375,	12770.55873,	12774.16382,	12777.76902,	12781.37433,
12784.97974,	12788.58526,	12792.19089,	12795.79662,	12799.40247,	12803.00842,	12806.61448,	12810.22064,	12813.82692,	12817.43330,
12821.03979,	12824.64638,	12828.25309,	12831.85990,	12835.46682,	12839.07384,	12842.68098,	12846.28822,	12849.89556,	12853.50302,
12857.11058,	12860.71825,	12864.32603,	12867.93391,	12871.54190,	12875.15000,	12878.75820,	12882.36652,	12885.97494,	12889.58346,
12893.19209,	12896.80083,	12900.40968,	12904.01864,	12907.62770,	12911.23686,	12914.84614,	12918.45552,	12922.06501,	12925.67460,
12929.28430,	12932.89411,	12936.50402,	12940.11404,	12943.72417,	12947.33441,	12950.94475,	12954.55519,	12958.16575,	12961.77641,
12965.38717,	12968.99805,	12972.60903,	12976.22011,	12979.83130,	12983.44260,	12987.05401,	12990.66552,	12994.27714,	12997.88886,
13001.50069,	13005.11262,	13008.72467,	13012.33681,	13015.94907,	13019.56143,	13023.17389,	13026.78647,	13030.39914,	13034.01193,
13037.62482,	13041.23781,	13044.85091,	13048.46412,	13052.07743,	13055.69085,	13059.30438,	13062.91801,	13066.53175,	13070.14559,
13073.75953,	13077.37359,	13080.98775,	13084.60201,	13088.21638,	13091.83086,	13095.44544,	13099.06012,	13102.67491,	13106.28981,
13109.90481,	13113.51992,	13117.13514,	13120.75045,	13124.36588,	13127.98141,	13131.59704,	13135.21278,	13138.82863,	13142.44458,
13146.06063,	13149.67679,	13153.29306,	13156.90943,	13160.52590,	13164.14248,	13167.75917,	13171.37596,	13174.99286,	13178.60986,
13182.22696,	13185.84417,	13189.46149,	13193.07891,	13196.69643,	13200.31406,	13203.93179,	13207.54963,	13211.16758,	13214.78562,
13218.40378,	13222.02203,	13225.64040,	13229.25886,	13232.87743,	13236.49611,	13240.11489,	13243.73377,	13247.35276,	13250.97186,
13254.59105,	13258.21036,	13261.82976,	13265.44927,	13269.06889,	13272.68861,	13276.30843,	13279.92836,	13283.54839,	13287.16853,
13290.78877,	13294.40911,	13298.02956,	13301.65011,	13305.27077,	13308.89153,	13312.51239,	13316.13336,	13319.75443,	13323.37561,
13326.99689,	13330.61827,	13334.23976,	13337.86135,	13341.48305,	13345.10485,	13348.72675,	13352.34876,	13355.97087,	13359.59308,
13363.21540,	13366.83782,	13370.46035,	13374.08297,	13377.70571,	13381.32854,	13384.95148,	13388.57452,	13392.19767,	13395.82092,
13399.44427,	13403.06773,	13406.69129,	13410.31495,	13413.93872,	13417.56258,	13421.18656,	13424.81063,	13428.43481,	13432.05909,
13435.68348,	13439.30797,	13442.93256,	13446.55725,	13450.18205,	13453.80695,	13457.43196,	13461.05706,	13464.68227,	13468.30758,
13471.93300,	13475.55852,	13479.18414,	13482.80986,	13486.43569,	13490.06162,	13493.68765,	13497.31379,	13500.94002,	13504.56636,
13508.19281,	13511.81935,	13515.44600,	13519.07275,	13522.69961,	13526.32656,	13529.95362,	13533.58078,	13537.20804,	13540.83541,
13544.46288,	13548.09045,	13551.71812,	13555.34590,	13558.97378,	13562.60176,	13566.22984,	13569.85802,	13573.48631,	13577.11470,
13580.74319,	13584.37178,	13588.00048,	13591.62927,	13595.25817,	13598.88718,	13602.51628,	13606.14549,	13609.77479,	13613.40420,
13617.03371,	13620.66333,	13624.29304,	13627.92286,	13631.55278,	13635.18280,	13638.81292,	13642.44315,	13646.07347,	13649.70390,
13653.33443,	13656.96506,	13660.59579,	13664.22663,	13667.85757,	13671.48860,	13675.11974,	13678.75098,	13682.38233,	13686.01377,
13689.64531,	13693.27696,	13696.90871,	13700.54056,	13704.17251,	13707.80456,	13711.43672,	13715.06897,	13718.70133,	13722.33378,
13725.96634,	13729.59900,	13733.23176,	13736.86462,	13740.49759,	13744.13065,	13747.76382,	13751.39708,	13755.03045,	13758.66392,
13762.29749,	13765.93116,	13769.56493,	13773.19880,	13776.83278,	13780.46685,	13784.10102,	13787.73530,	13791.36968,	13795.00415,
13798.63873,	13802.27341,	13805.90819,	13809.54307,	13813.17805,	13816.81313,	13820.44832,	13824.08360,	13827.71898,	13831.35446,
13834.99005,	13838.62573,	13842.26152,	13845.89740,	13849.53339,	13853.16948,	13856.80566,	13860.44195,	13864.07834,	13867.71483,
13871.35141,	13874.98810,	13878.62489,	13882.26178,	13885.89877,	13889.53586,	13893.17305,	13896.81034,	13900.44773,	13904.08522,
13907.72281,	13911.36050,	13914.99829,	13918.63618,	13922.27417,	13925.91226,	13929.55045,	13933.18874,	13936.82713,	13940.46561,
13944.10420,	13947.74289,	13951.38168,	13955.02057,	13958.65956,	13962.29865,	13965.93783,	13969.57712,	13973.21651,	13976.85599,
13980.49558,	13984.13527,	13987.77505,	13991.41494,	13995.05492,	13998.69500,	14002.33519,	14005.97547,	14009.61585,	14013.25633,
14016.89691,	14020.53759,	14024.17837,	14027.81925,	14031.46023,	14035.10131,	14038.74248,	14042.38376,	14046.02513,	14049.66661,
14053.30818,	14056.94985,	14060.59163,	14064.23350,	14067.87547,	14071.51753,	14075.15970,	14078.80197,	14082.44433,	14086.08680,
14089.72936,	14093.37202,	14097.01479,	14100.65765,	14104.30060,	14107.94366,	14111.58682,	14115.23007,	14118.87343,	14122.51688,
14126.16043,	14129.80408,	14133.44783,	14137.09168,	14140.73562,	14144.37967,	14148.02381,	14151.66805,	14155.31239,	14158.95683,
14162.60137,	14166.24600,	14169.89074,	14173.53557,	14177.18050,	14180.82553,	14184.47066,	14188.11588,	14191.76121,	14195.40663,
14199.05215,	14202.69777,	14206.34349,	14209.98930,	14213.63521,	14217.28123,	14220.92734,	14224.57354,	14228.21985,	14231.86625,
14235.51275,	14239.15935,	14242.80605,	14246.45285,	14250.09974,	14253.74673,	14257.39382,	14261.04101,	14264.68829,	14268.33568,
14271.98316,	14275.63074,	14279.27841,	14282.92619,	14286.57406,	14290.22203,	14293.87010,	14297.51826,	14301.16652,	14304.81488,
14308.46334,	14312.11190,	14315.76055,	14319.40930,	14323.05815,	14326.70709,	14330.35613,	14334.00527,	14337.65451,	14341.30385,
14344.95328,	14348.60281,	14352.25243,	14355.90216,	14359.55198,	14363.20190,	14366.85192,	14370.50203,	14374.15224,	14377.80255,
14381.45295,	14385.10345,	14388.75405,	14392.40475,	14396.05554,	14399.70643,	14403.35742,	14407.00850,	14410.65968,	14414.31096,
14417.96234,	14421.61381,	14425.26538,	14428.91704,	14432.56880,	14436.22066,	14439.87262,	14443.52467,	14447.17682,	14450.82907,
14454.48141,	14458.13385,	14461.78639,	14465.43902,	14469.09175,	14472.74458,	14476.39750,	14480.05052,	14483.70364,	14487.35685,
14491.01016,	14494.66356,	14498.31706,	14501.97066,	14505.62436,	14509.27815,	14512.93204,	14516.58602,	14520.24010,	14523.89428,
14527.54855,	14531.20292,	14534.85738,	14538.51195,	14542.16660,	14545.82136,	14549.47621,	14553.13115,	14556.78620,	14560.44133,
14564.09657,	14567.75190,	14571.40733,	14575.06285,	14578.71847,	14582.37418,	14586.02999,	14589.68590,	14593.34190,	14596.99800,
14600.65419,	14604.31048,	14607.96687,	14611.62335,	14615.27993,	14618.93660,	14622.59337,	14626.25023,	14629.90719,	14633.56425,
14637.22140,	14640.87865,	14644.53599,	14648.19343,	14651.85096,	14655.50859,	14659.16632,	14662.82414,	14666.48205,	14670.14007,
14673.79817,	14677.45637,	14681.11467,	14684.77307,	14688.43155,	14692.09014,	14695.74882,	14699.40759,	14703.06646,	14706.72543,
14710.38449,	14714.04364,	14717.70289,	14721.36224,	14725.02168,	14728.68121,	14732.34084,	14736.00057,	14739.66039,	14743.32031,
14746.98032,	14750.64043,	14754.30063,	14757.96092,	14761.62131,	14765.28180,	14768.94238,	14772.60306,	14776.26383,	14779.92469,
14783.58565,	14787.24671,	14790.90786,	14794.56910,	14798.23044,	14801.89188,	14805.55340,	14809.21503,	14812.87675,	14816.53856,
14820.20047,	14823.86247,	14827.52456,	14831.18676,	14834.84904,	14838.51142,	14842.17390,	14845.83646,	14849.49913,	14853.16189,
14856.82474,	14860.48768,	14864.15073,	14867.81386,	14871.47709,	14875.14041,	14878.80383,	14882.46735,	14886.13095,	14889.79465,
14893.45845,	14897.12234,	14900.78632,	14904.45040,	14908.11457,	14911.77884,	14915.44320,	14919.10765,	14922.77220,	14926.43684,
14930.10158,	14933.76641,	14937.43133,	14941.09635,	14944.76146,	14948.42666,	14952.09196,	14955.75736,	14959.42284,	14963.08843,
14966.75410,	14970.41987,	14974.08573,	14977.75169,	14981.41774,	14985.08388,	14988.75012,	14992.41645,	14996.08287,	14999.74939,
15003.41600,	15007.08271,	15010.74951,	15014.41640,	15018.08338,	15021.75046,	15025.41764,	15029.08490,	15032.75226,	15036.41971,
15040.08726,	15043.75490,	15047.42263,	15051.09046,	15054.75838,	15058.42639,	15062.09450,	15065.76270,	15069.43099,	15073.09938,
15076.76786,	15080.43643,	15084.10509,	15087.77385,	15091.44270,	15095.11165,	15098.78069,	15102.44982,	15106.11904,	15109.78836,
15113.45777,	15117.12727,	15120.79687,	15124.46656,	15128.13634,	15131.80621,	15135.47618,	15139.14624,	15142.81639,	15146.48664,
15150.15698,	15153.82741,	15157.49793,	15161.16855,	15164.83926,	15168.51006,	15172.18096,	15175.85194,	15179.52302,	15183.19420,
15186.86546,	15190.53682,	15194.20827,	15197.87981,	15201.55145,	15205.22318,	15208.89500,	15212.56691,	15216.23892,	15219.91101,
15223.58320,	15227.25549,	15230.92786,	15234.60033,	15238.27289,	15241.94554,	15245.61828,	15249.29112,	15252.96405,	15256.63707,
15260.31018,	15263.98339,	15267.65669,	15271.33008,	15275.00356,	15278.67713,	15282.35080,	15286.02456,	15289.69841,	15293.37235,
15297.04638,	15300.72051,	15304.39473,	15308.06904,	15311.74344,	15315.41793,	15319.09252,	15322.76719,	15326.44196,	15330.11682,
15333.79178,	15337.46682,	15341.14196,	15344.81719,	15348.49251,	15352.16792,	15355.84342,	15359.51902,	15363.19470,	15366.87048,
15370.54635,	15374.22231,	15377.89837,	15381.57451,	15385.25075,	15388.92708,	15392.60349,	15396.28001,	15399.95661,	15403.63330,
15407.31009,	15410.98696,	15414.66393,	15418.34099,	15422.01814,	15425.69538,	15429.37272,	15433.05014,	15436.72766,	15440.40526,
15444.08296,	15447.76075,	15451.43863,	15455.11660,	15458.79466,	15462.47282,	15466.15106,	15469.82940,	15473.50783,	15477.18635,
15480.86496,	15484.54366,	15488.22245,	15491.90133,	15495.58030,	15499.25937,	15502.93852,	15506.61777,	15510.29711,	15513.97653,
15517.65605,	15521.33566,	15525.01536,	15528.69515,	15532.37504,	15536.05501,	15539.73507,	15543.41523,	15547.09547,	15550.77581,
15554.45623,	15558.13675,	15561.81736,	15565.49805,	15569.17884,	15572.85972,	15576.54069,	15580.22175,	15583.90290,	15587.58414,
15591.26548,	15594.94690,	15598.62841,	15602.31001,	15605.99171,	15609.67349,	15613.35537,	15617.03733,	15620.71938,	15624.40153,
15628.08376,	15631.76609,	15635.44851,	15639.13101,	15642.81361,	15646.49630,	15650.17907,	15653.86194,	15657.54490,	15661.22794,
15664.91108,	15668.59431,	15672.27762,	15675.96103,	15679.64453,	15683.32812,	15687.01179,	15690.69556,	15694.37942,	15698.06336,
15701.74740,	15705.43153,	15709.11575,	15712.80005,	15716.48445,	15720.16894,	15723.85351,	15727.53818,	15731.22293,	15734.90778,
15738.59271,	15742.27774,	15745.96285,	15749.64806,	15753.33335,	15757.01873,	15760.70421,	15764.38977,	15768.07542,	15771.76116,
15775.44699,	15779.13292,	15782.81893,	15786.50503,	15790.19121,	15793.87749,	15797.56386,	15801.25032,	15804.93687,	15808.62350,
15812.31023,	15815.99704,	15819.68395,	15823.37094,	15827.05802,	15830.74520,	15834.43246,	15838.11981,	15841.80725,	15845.49478,
15849.18239,	15852.87010,	15856.55790,	15860.24578,	15863.93376,	15867.62182,	15871.30997,	15874.99822,	15878.68655,	15882.37497,
15886.06348,	15889.75207,	15893.44076,	15897.12954,	15900.81840,	15904.50735,	15908.19640,	15911.88553,	15915.57475,	15919.26406,
15922.95345,	15926.64294,	15930.33252,	15934.02218,	15937.71193,	15941.40177,	15945.09170,	15948.78172,	15952.47183,	15956.16203,
15959.85231,	15963.54268,	15967.23315,	15970.92370,	15974.61434,	15978.30506,	15981.99588,	15985.68678,	15989.37778,	15993.06886,
15996.76003,	16000.45129,	16004.14263,	16007.83407,	16011.52559,	16015.21720,	16018.90890,	16022.60069,	16026.29257,	16029.98453,
16033.67659,	16037.36873,	16041.06096,	16044.75328,	16048.44568,	16052.13818,	16055.83076,	16059.52343,	16063.21619,	16066.90904,
16070.60197,	16074.29500,	16077.98811,	16081.68131,	16085.37459,	16089.06797,	16092.76143,	16096.45498,	16100.14862,	16103.84235,
16107.53616,	16111.23007,	16114.92406,	16118.61813,	16122.31230,	16126.00655,	16129.70090,	16133.39533,	16137.08984,	16140.78445,
16144.47914,	16148.17392,	16151.86879,	16155.56375,	16159.25879,	16162.95392,	16166.64914,	16170.34445,	16174.03984,	16177.73532,
16181.43089,	16185.12655,	16188.82229,	16192.51813,	16196.21404,	16199.91005,	16203.60615,	16207.30233,	16210.99860,	16214.69495,
16218.39140,	16222.08793,	16225.78455,	16229.48125,	16233.17804,	16236.87492,	16240.57189,	16244.26895,	16247.96609,	16251.66332,
16255.36064,	16259.05804,	16262.75553,	16266.45311,	16270.15077,	16273.84853,	16277.54636,	16281.24429,	16284.94230,	16288.64041,
16292.33859,	16296.03687,	16299.73523,	16303.43368,	16307.13221,	16310.83084,	16314.52954,	16318.22834,	16321.92722,	16325.62619,
16329.32525,	16333.02439,	16336.72363,	16340.42294,	16344.12235,	16347.82184,	16351.52142,	16355.22108,	16358.92083,	16362.62067,
16366.32059,	16370.02060,	16373.72070,	16377.42089,	16381.12116,	16384.82151,	16388.52196,	16392.22249,	16395.92311,	16399.62381,
16403.32460,	16407.02548,	16410.72644,	16414.42749,	16418.12863,	16421.82985,	16425.53116,	16429.23255,	16432.93403,	16436.63560,
16440.33726,	16444.03900,	16447.74082,	16451.44274,	16455.14474,	16458.84682,	16462.54899,	16466.25125,	16469.95360,	16473.65603,
16477.35854,	16481.06115,	16484.76384,	16488.46661,	16492.16947,	16495.87242,	16499.57545,	16503.27857,	16506.98178,	16510.68507,
16514.38845,	16518.09191,	16521.79546,	16525.49909,	16529.20282,	16532.90662,	16536.61052,	16540.31449,	16544.01856,	16547.72271,
16551.42695,	16555.13127,	16558.83568,	16562.54017,	16566.24475,	16569.94941,	16573.65416,	16577.35900,	16581.06392,	16584.76893,
16588.47403,	16592.17920,	16595.88447,	16599.58982,	16603.29526,	16607.00078,	16610.70638,	16614.41208,	16618.11786,	16621.82372,
16625.52967,	16629.23570,	16632.94182,	16636.64803,	16640.35432,	16644.06070,	16647.76716,	16651.47370,	16655.18034,	16658.88706,
16662.59386,	16666.30075,	16670.00772,	16673.71478,	16677.42192,	16681.12915,	16684.83647,	16688.54387,	16692.25135,	16695.95892,
16699.66658,	16703.37432,	16707.08214,	16710.79005,	16714.49805,	16718.20613,	16721.91430,	16725.62255,	16729.33088,	16733.03930,
16736.74781,	16740.45640,	16744.16508,	16747.87384,	16751.58268,	16755.29161,	16759.00063,	16762.70973,	16766.41891,	16770.12818,
16773.83754,	16777.54698,	16781.25650,	16784.96611,	16788.67581,	16792.38559,	16796.09545,	16799.80540,	16803.51543,	16807.22555,
16810.93575,	16814.64604,	16818.35641,	16822.06686,	16825.77740,	16829.48803,	16833.19874,	16836.90953,	16840.62041,	16844.33137,
16848.04242,	16851.75355,	16855.46477,	16859.17607,	16862.88746,	16866.59893,	16870.31048,	16874.02212,	16877.73384,	16881.44565,
16885.15754,	16888.86952,	16892.58158,	16896.29372,	16900.00595,	16903.71826,	16907.43066,	16911.14314,	16914.85571,	16918.56836,
16922.28109,	16925.99391,	16929.70681,	16933.41980,	16937.13287,	16940.84602,	16944.55926,	16948.27258,	16951.98599,	16955.69948,
16959.41305,	16963.12671,	16966.84045,	16970.55428,	16974.26819,	16977.98219,	16981.69626,	16985.41043,	16989.12467,	16992.83900,
16996.55341,	17000.26791,	17003.98249,	17007.69716,	17011.41191,	17015.12674,	17018.84166,	17022.55666,	17026.27174,	17029.98691,
17033.70216,	17037.41749,	17041.13291,	17044.84841,	17048.56400,	17052.27967,	17055.99542,	17059.71126,	17063.42718,	17067.14318,
17070.85927,	17074.57544,	17078.29169,	17082.00803,	17085.72445,	17089.44095,	17093.15754,	17096.87421,	17100.59097,	17104.30780,
17108.02472,	17111.74173,	17115.45882,	17119.17599,	17122.89324,	17126.61058,	17130.32800,	17134.04550,	17137.76309,	17141.48076,
17145.19852,	17148.91635,	17152.63427,	17156.35228,	17160.07036,	17163.78853,	17167.50678,	17171.22512,	17174.94354,	17178.66204,
17182.38062,	17186.09929,	17189.81804,	17193.53688,	17197.25579,	17200.97479,	17204.69388,	17208.41304,	17212.13229,	17215.85162,
17219.57104,	17223.29053,	17227.01011,	17230.72977,	17234.44952,	17238.16935,	17241.88926,	17245.60925,	17249.32933,	17253.04949,
17256.76973,	17260.49006,	17264.21046,	17267.93095,	17271.65153,	17275.37218,	17279.09292,	17282.81374,	17286.53464,	17290.25563,
17293.97670,	17297.69785,	17301.41908,	17305.14040,	17308.86180,	17312.58328,	17316.30484,	17320.02649,	17323.74821,	17327.47002,
17331.19192,	17334.91389,	17338.63595,	17342.35809,	17346.08031,	17349.80262,	17353.52501,	17357.24747,	17360.97003,	17364.69266,
17368.41538,	17372.13817,	17375.86106,	17379.58402,	17383.30706,	17387.03019,	17390.75340,	17394.47669,	17398.20006,	17401.92352,
17405.64706,	17409.37068,	17413.09438,	17416.81816,	17420.54203,	17424.26598,	17427.99001,	17431.71412,	17435.43831,	17439.16259,
17442.88695,	17446.61139,	17450.33591,	17454.06051,	17457.78520,	17461.50996,	17465.23481,	17468.95974,	17472.68476,	17476.40985,
17480.13503,	17483.86029,	17487.58563,	17491.31105,	17495.03655,	17498.76214,	17502.48780,	17506.21355,	17509.93938,	17513.66529,
17517.39129,	17521.11736,	17524.84352,	17528.56976,	17532.29607,	17536.02248,	17539.74896,	17543.47552,	17547.20217,	17550.92890,
17554.65570,	17558.38259,	17562.10957,	17565.83662,	17569.56375,	17573.29097,	17577.01827,	17580.74565,	17584.47311,	17588.20065,
17591.92827,	17595.65597,	17599.38376,	17603.11162,	17606.83957,	17610.56760,	17614.29571,	17618.02390,	17621.75218,	17625.48053,
17629.20896,	17632.93748,	17636.66608,	17640.39476,	17644.12352,	17647.85236,	17651.58128,	17655.31028,	17659.03936,	17662.76853,
17666.49777,	17670.22710,	17673.95651,	17677.68600,	17681.41557,	17685.14522,	17688.87495,	17692.60476,	17696.33466,	17700.06463,
17703.79469,	17707.52482,	17711.25504,	17714.98534,	17718.71571,	17722.44617,	17726.17671,	17729.90733,	17733.63804,	17737.36882,
17741.09968,	17744.83062,	17748.56165,	17752.29275,	17756.02394,	17759.75521,	17763.48655,	17767.21798,	17770.94949,	17774.68108,
17778.41275,	17782.14450,	17785.87633,	17789.60824,	17793.34023,	17797.07230,	17800.80445,	17804.53669,	17808.26900,	17812.00139,
17815.73387,	17819.46642,	17823.19906,	17826.93177,	17830.66457,	17834.39745,	17838.13040,	17841.86344,	17845.59656,	17849.32975,
17853.06303,	17856.79639,	17860.52983,	17864.26334,	17867.99694,	17871.73062,	17875.46438,	17879.19822,	17882.93214,	17886.66614,
17890.40022,	17894.13438,	17897.86862,	17901.60294,	17905.33734,	17909.07182,	17912.80637,	17916.54101,	17920.27573,	17924.01053,
17927.74541,	17931.48037,	17935.21541,	17938.95053,	17942.68573,	17946.42101,	17950.15637,	17953.89181,	17957.62733,	17961.36293,
17965.09861,	17968.83437,	17972.57020,	17976.30612,	17980.04212,	17983.77820,	17987.51436,	17991.25059,	17994.98691,	17998.72331,
18002.45978,	18006.19634,	18009.93297,	18013.66969,	18017.40648,	18021.14336,	18024.88031,	18028.61735,	18032.35446,	18036.09165,
18039.82892,	18043.56627,	18047.30371,	18051.04122,	18054.77881,	18058.51648,	18062.25423,	18065.99205,	18069.72996,	18073.46795,
18077.20602,	18080.94416,	18084.68239,	18088.42069,	18092.15908,	18095.89754,	18099.63608,	18103.37470,	18107.11341,	18110.85219,
18114.59105,	18118.32999,	18122.06900,	18125.80810,	18129.54728,	18133.28653,	18137.02587,	18140.76528,	18144.50478,	18148.24435,
18151.98400,	18155.72373,	18159.46354,	18163.20343,	18166.94340,	18170.68344,	18174.42357,	18178.16377,	18181.90406,	18185.64442,
18189.38486,	18193.12538,	18196.86598,	18200.60666,	18204.34742,	18208.08825,	18211.82917,	18215.57016,	18219.31124,	18223.05239,
18226.79362,	18230.53493,	18234.27631,	18238.01778,	18241.75933,	18245.50095,	18249.24265,	18252.98444,	18256.72630,	18260.46823,
18264.21025,	18267.95235,	18271.69452,	18275.43678,	18279.17911,	18282.92152,	18286.66401,	18290.40658,	18294.14923,	18297.89195,
18301.63475,	18305.37764,	18309.12060,	18312.86364,	18316.60675,	18320.34995,	18324.09322,	18327.83658,	18331.58001,	18335.32352,
18339.06711,	18342.81077,	18346.55452,	18350.29834,	18354.04224,	18357.78622,	18361.53028,	18365.27442,	18369.01863,	18372.76292,
18376.50730,	18380.25175,	18383.99627,	18387.74088,	18391.48556,	18395.23033,	18398.97517,	18402.72008,	18406.46508,	18410.21016,
18413.95531,	18417.70054,	18421.44585,	18425.19124,	18428.93670,	18432.68224,	18436.42787,	18440.17356,	18443.91934,	18447.66520,
18451.41113,	18455.15714,	18458.90323,	18462.64940,	18466.39564,	18470.14196,	18473.88837,	18477.63484,	18481.38140,	18485.12803,
18488.87475,	18492.62154,	18496.36840,	18500.11535,	18503.86237,	18507.60947,	18511.35665,	18515.10391,	18518.85124,	18522.59865,
18526.34614,	18530.09371,	18533.84136,	18537.58908,	18541.33688,	18545.08476,	18548.83271,	18552.58074,	18556.32885,	18560.07704,
18563.82531,	18567.57365,	18571.32207,	18575.07057,	18578.81915,	18582.56780,	18586.31653,	18590.06534,	18593.81422,	18597.56319,
18601.31223,	18605.06134,	18608.81054,	18612.55981,	18616.30916,	18620.05859,	18623.80809,	18627.55767,	18631.30733,	18635.05707,
18638.80688,	18642.55677,	18646.30674,	18650.05679,	18653.80691,	18657.55711,	18661.30739,	18665.05774,	18668.80817,	18672.55868,
18676.30927,	18680.05993,	18683.81067,	18687.56149,	18691.31238,	18695.06335,	18698.81440,	18702.56552,	18706.31673,	18710.06800,
18713.81936,	18717.57079,	18721.32230,	18725.07389,	18728.82555,	18732.57730,	18736.32911,	18740.08101,	18743.83298,	18747.58503,
18751.33715,	18755.08936,	18758.84163,	18762.59399,	18766.34642,	18770.09893,	18773.85152,	18777.60418,	18781.35692,	18785.10974,
18788.86263,	18792.61560,	18796.36865,	18800.12177,	18803.87497,	18807.62825,	18811.38160,	18815.13503,	18818.88854,	18822.64212,
18826.39578,	18830.14952,	18833.90333,	18837.65722,	18841.41118,	18845.16523,	18848.91934,	18852.67354,	18856.42781,	18860.18216,
18863.93658,	18867.69109,	18871.44566,	18875.20032,	18878.95505,	18882.70986,	18886.46474,	18890.21970,	18893.97473,	18897.72985,
18901.48503,	18905.24030,	18908.99564,	18912.75106,	18916.50655,	18920.26212,	18924.01777,	18927.77349,	18931.52929,	18935.28516,
18939.04112,	18942.79714,	18946.55325,	18950.30943,	18954.06568,	18957.82201,	18961.57842,	18965.33490,	18969.09146,	18972.84810,
18976.60481,	18980.36160,	18984.11847,	18987.87541,	18991.63242,	18995.38951,	18999.14668,	19002.90393,	19006.66125,	19010.41864,
19014.17611,	19017.93366,	19021.69129,	19025.44899,	19029.20676,	19032.96461,	19036.72254,	19040.48054,	19044.23862,	19047.99678,
19051.75501,	19055.51331,	19059.27169,	19063.03015,	19066.78869,	19070.54729,	19074.30598,	19078.06474,	19081.82358,	19085.58249,
19089.34148,	19093.10054,	19096.85968,	19100.61889,	19104.37818,	19108.13755,	19111.89699,	19115.65651,	19119.41610,	19123.17577,
19126.93551,	19130.69533,	19134.45522,	19138.21519,	19141.97524,	19145.73536,	19149.49555,	19153.25583,	19157.01617,	19160.77660,
19164.53709,	19168.29767,	19172.05832,	19175.81904,	19179.57984,	19183.34071,	19187.10166,	19190.86269,	19194.62379,	19198.38497,
19202.14622,	19205.90754,	19209.66894,	19213.43042,	19217.19197,	19220.95360,	19224.71530,	19228.47708,	19232.23893,	19236.00086,
19239.76286,	19243.52494,	19247.28710,	19251.04932,	19254.81163,	19258.57401,	19262.33646,	19266.09899,	19269.86159,	19273.62427,
19277.38702,	19281.14985,	19284.91275,	19288.67573,	19292.43879,	19296.20192,	19299.96512,	19303.72840,	19307.49175,	19311.25518,
19315.01868,	19318.78226,	19322.54591,	19326.30964,	19330.07344,	19333.83732,	19337.60127,	19341.36530,	19345.12940,	19348.89357,
19352.65782,	19356.42215,	19360.18655,	19363.95103,	19367.71558,	19371.48020,	19375.24490,	19379.00967,	19382.77452,	19386.53944,
19390.30444,	19394.06951,	19397.83466,	19401.59988,	19405.36518,	19409.13055,	19412.89599,	19416.66151,	19420.42711,	19424.19278,
19427.95852,	19431.72434,	19435.49023,	19439.25619,	19443.02223,	19446.78835,	19450.55454,	19454.32080,	19458.08714,	19461.85356,
19465.62004,	19469.38660,	19473.15324,	19476.91995,	19480.68673,	19484.45359,	19488.22053,	19491.98753,	19495.75462,	19499.52177,
19503.28900,	19507.05631,	19510.82368,	19514.59114,	19518.35866,	19522.12627,	19525.89394,	19529.66169,	19533.42951,	19537.19741,
19540.96538,	19544.73343,	19548.50155,	19552.26974,	19556.03801,	19559.80635,	19563.57477,	19567.34326,	19571.11182,	19574.88046,
19578.64917,	19582.41796,	19586.18682,	19589.95575,	19593.72476,	19597.49384,	19601.26300,	19605.03223,	19608.80153,	19612.57091,
19616.34036,	19620.10988,	19623.87948,	19627.64916,	19631.41890,	19635.18872,	19638.95862,	19642.72858,	19646.49863,	19650.26874,
19654.03893,	19657.80919,	19661.57953,	19665.34994,	19669.12042,	19672.89098,	19676.66161,	19680.43232,	19684.20310,	19687.97395,
19691.74487,	19695.51587,	19699.28695,	19703.05809,	19706.82931,	19710.60060,	19714.37197,	19718.14341,	19721.91493,	19725.68651,
19729.45817,	19733.22991,	19737.00172,	19740.77360,	19744.54555,	19748.31758,	19752.08968,	19755.86186,	19759.63411,	19763.40643,
19767.17882,	19770.95129,	19774.72383,	19778.49645,	19782.26914,	19786.04190,	19789.81473,	19793.58764,	19797.36062,	19801.13368,
19804.90681,	19808.68001,	19812.45328,	19816.22663,	19820.00005,	19823.77354,	19827.54711,	19831.32075,	19835.09446,	19838.86825,
19842.64211,	19846.41604,	19850.19005,	19853.96413,	19857.73828,	19861.51250,	19865.28680,	19869.06117,	19872.83562,	19876.61013,
19880.38472,	19884.15939,	19887.93412,	19891.70893,	19895.48381,	19899.25877,	19903.03379,	19906.80890,	19910.58407,	19914.35932,
19918.13463,	19921.91003,	19925.68549,	19929.46103,	19933.23664,	19937.01232,	19940.78808,	19944.56391,	19948.33981,	19952.11578,
19955.89183,	19959.66795,	19963.44414,	19967.22041,	19970.99675,	19974.77316,	19978.54964,	19982.32620,	19986.10282,	19989.87953,
19993.65630,	19997.43315,	20001.21006,	20004.98706,	20008.76412,	20012.54126,	20016.31847,	20020.09575,	20023.87310,	20027.65053,
20031.42803,	20035.20560,	20038.98324,	20042.76096,	20046.53875,	20050.31661,	20054.09455,	20057.87255,	20061.65063,	20065.42878,
20069.20701,	20072.98530,	20076.76367,	20080.54211,	20084.32062,	20088.09921,	20091.87787,	20095.65660,	20099.43540,	20103.21427,
20106.99322,	20110.77224,	20114.55133,	20118.33049,	20122.10973,	20125.88904,	20129.66842,	20133.44787,	20137.22739,	20141.00699,
20144.78666,	20148.56640,	20152.34621,	20156.12610,	20159.90605,	20163.68608,	20167.46619,	20171.24636,	20175.02660,	20178.80692,
20182.58731,	20186.36777,	20190.14830,	20193.92891,	20197.70959,	20201.49034,	20205.27116,	20209.05205,	20212.83302,	20216.61405,
20220.39516,	20224.17634,	20227.95760,	20231.73892,	20235.52032,	20239.30178,	20243.08332,	20246.86494,	20250.64662,	20254.42837,
20258.21020,	20261.99210,	20265.77407,	20269.55611,	20273.33823,	20277.12041,	20280.90267,	20284.68500,	20288.46740,	20292.24987,
20296.03242,	20299.81503,	20303.59772,	20307.38048,	20311.16331,	20314.94621,	20318.72919,	20322.51223,	20326.29535,	20330.07854,
20333.86180,	20337.64513,	20341.42854,	20345.21201,	20348.99556,	20352.77917,	20356.56286,	20360.34662,	20364.13046,	20367.91436,
20371.69833,	20375.48238,	20379.26650,	20383.05069,	20386.83495,	20390.61928,	20394.40368,	20398.18816,	20401.97270,	20405.75732,
20409.54201,	20413.32677,	20417.11160,	20420.89650,	20424.68148,	20428.46652,	20432.25164,	20436.03683,	20439.82208,	20443.60741,
20447.39282,	20451.17829,	20454.96383,	20458.74945,	20462.53513,	20466.32089,	20470.10672,	20473.89262,	20477.67859,	20481.46463,
20485.25074,	20489.03692,	20492.82318,	20496.60950,	20500.39590,	20504.18237,	20507.96890,	20511.75551,	20515.54219,	20519.32895,
20523.11577,	20526.90266,	20530.68963,	20534.47666,	20538.26377,	20542.05094,	20545.83819,	20549.62551,	20553.41290,	20557.20036,
20560.98789,	20564.77549,	20568.56317,	20572.35091,	20576.13873,	20579.92661,	20583.71457,	20587.50259,	20591.29069,	20595.07886,
20598.86710,	20602.65541,	20606.44379,	20610.23224,	20614.02076,	20617.80936,	20621.59802,	20625.38675,	20629.17556,	20632.96443,
20636.75338,	20640.54239,	20644.33148,	20648.12064,	20651.90987,	20655.69916,	20659.48853,	20663.27797,	20667.06748,	20670.85706,
20674.64672,	20678.43644,	20682.22623,	20686.01609,	20689.80603,	20693.59603,	20697.38610,	20701.17625,	20704.96646,	20708.75675,
20712.54710,	20716.33753,	20720.12802,	20723.91859,	20727.70923,	20731.49994,	20735.29071,	20739.08156,	20742.87248,	20746.66347,
20750.45453,	20754.24566,	20758.03685,	20761.82812,	20765.61946,	20769.41087,	20773.20235,	20776.99390,	20780.78552,	20784.57722,
20788.36898,	20792.16081,	20795.95271,	20799.74468,	20803.53672,	20807.32883,	20811.12101,	20814.91327,	20818.70559,	20822.49798,
20826.29044,	20830.08297,	20833.87557,	20837.66825,	20841.46099,	20845.25380,	20849.04668,	20852.83963,	20856.63265,	20860.42575,
20864.21891,	20868.01214,	20871.80544,	20875.59881,	20879.39225,	20883.18576,	20886.97934,	20890.77300,	20894.56672,	20898.36051,
20902.15437,	20905.94830,	20909.74230,	20913.53637,	20917.33051,	20921.12471,	20924.91899,	20928.71334,	20932.50776,	20936.30225,
20940.09681,	20943.89143,	20947.68613,	20951.48090,	20955.27573,	20959.07064,	20962.86562,	20966.66066,	20970.45578,	20974.25096,
20978.04621,	20981.84154,	20985.63693,	20989.43239,	20993.22793,	20997.02353,	21000.81920,	21004.61494,	21008.41075,	21012.20663,
21016.00258,	21019.79860,	21023.59469,	21027.39085,	21031.18707,	21034.98337,	21038.77974,	21042.57617,	21046.37268,	21050.16925,
21053.96590,	21057.76261,	21061.55939,	21065.35624,	21069.15316,	21072.95015,	21076.74721,	21080.54434,	21084.34154,	21088.13881,
21091.93615,	21095.73355,	21099.53103,	21103.32857,	21107.12619,	21110.92387,	21114.72162,	21118.51944,	21122.31733,	21126.11529,
21129.91332,	21133.71142,	21137.50959,	21141.30782,	21145.10613,	21148.90450,	21152.70294,	21156.50146,	21160.30004,	21164.09869,
21167.89741,	21171.69620,	21175.49506,	21179.29398,	21183.09298,	21186.89204,	21190.69118,	21194.49038,	21198.28965,	21202.08899,
21205.88840,	21209.68788,	21213.48743,	21217.28704,	21221.08673,	21224.88648,	21228.68630,	21232.48620,	21236.28616,	21240.08619,
21243.88628,	21247.68645,	21251.48669,	21255.28699,	21259.08737,	21262.88781,	21266.68832,	21270.48890,	21274.28955,	21278.09026,
21281.89105,	21285.69190,	21289.49283,	21293.29382,	21297.09488,	21300.89601,	21304.69721,	21308.49847,	21312.29981,	21316.10121,
21319.90268,	21323.70422,	21327.50583,	21331.30751,	21335.10926,	21338.91107,	21342.71296,	21346.51491,	21350.31693,	21354.11902,
21357.92118,	21361.72340,	21365.52570,	21369.32806,	21373.13049,	21376.93299,	21380.73556,	21384.53820,	21388.34090,	21392.14368,
21395.94652,	21399.74943,	21403.55241,	21407.35546,	21411.15857,	21414.96176,	21418.76501,	21422.56833,	21426.37172,	21430.17517,
21433.97870,	21437.78229,	21441.58596,	21445.38969,	21449.19348,	21452.99735,	21456.80129,	21460.60529,	21464.40936,	21468.21350,
21472.01771,	21475.82198,	21479.62633,	21483.43074,	21487.23522,	21491.03977,	21494.84438,	21498.64907,	21502.45382,	21506.25864,
21510.06353,	21513.86849,	21517.67351,	21521.47860,	21525.28377,	21529.08899,	21532.89429,	21536.69966,	21540.50509,	21544.31059,
21548.11616,	21551.92180,	21555.72750,	21559.53327,	21563.33911,	21567.14502,	21570.95100,	21574.75704,	21578.56315,	21582.36933,
21586.17558,	21589.98190,	21593.78828,	21597.59473,	21601.40125,	21605.20784,	21609.01449,	21612.82122,	21616.62801,	21620.43486,
21624.24179,	21628.04878,	21631.85585,	21635.66297,	21639.47017,	21643.27744,	21647.08477,	21650.89217,	21654.69963,	21658.50717,
21662.31477,	21666.12244,	21669.93018,	21673.73799,	21677.54586,	21681.35380,	21685.16181,	21688.96988,	21692.77803,	21696.58624,
21700.39452,	21704.20286,	21708.01128,	21711.81976,	21715.62831,	21719.43692,	21723.24561,	21727.05436,	21730.86317,	21734.67206,
21738.48101,	21742.29003,	21746.09912,	21749.90828,	21753.71750,	21757.52679,	21761.33615,	21765.14557,	21768.95507,	21772.76463,
21776.57425,	21780.38395,	21784.19371,	21788.00354,	21791.81343,	21795.62340,	21799.43343,	21803.24353,	21807.05369,	21810.86392,
21814.67422,	21818.48459,	21822.29503,	21826.10553,	21829.91610,	21833.72673,	21837.53743,	21841.34820,	21845.15904,	21848.96995,
21852.78092,	21856.59196,	21860.40306,	21864.21423,	21868.02547,	21871.83678,	21875.64815,	21879.45960,	21883.27110,	21887.08268,
21890.89432,	21894.70603,	21898.51781,	21902.32965,	21906.14156,	21909.95354,	21913.76558,	21917.57769,	21921.38987,	21925.20211,
21929.01442,	21932.82680,	21936.63925,	21940.45176,	21944.26434,	21948.07699,	21951.88970,	21955.70248,	21959.51532,	21963.32824,
21967.14122,	21970.95427,	21974.76738,	21978.58056,	21982.39381,	21986.20712,	21990.02050,	21993.83395,	21997.64746,	22001.46104,
22005.27469,	22009.08841,	22012.90219,	22016.71604,	22020.52995,	22024.34393,	22028.15798,	22031.97209,	22035.78627,	22039.60052,
22043.41484,	22047.22922,	22051.04366,	22054.85818,	22058.67276,	22062.48741,	22066.30212,	22070.11690,	22073.93175,	22077.74666,
22081.56164,	22085.37668,	22089.19180,	22093.00698,	22096.82222,	22100.63753,	22104.45291,	22108.26836,	22112.08387,	22115.89945,
22119.71509,	22123.53080,	22127.34658,	22131.16242,	22134.97833,	22138.79431,	22142.61035,	22146.42646,	22150.24263,	22154.05887,
22157.87518,	22161.69156,	22165.50800,	22169.32450,	22173.14108,	22176.95771,	22180.77442,	22184.59119,	22188.40803,	22192.22493,
22196.04190,	22199.85894,	22203.67604,	22207.49321,	22211.31044,	22215.12775,	22218.94511,	22222.76255,	22226.58004,	22230.39761,
22234.21524,	22238.03294,	22241.85070,	22245.66853,	22249.48643,	22253.30439,	22257.12242,	22260.94051,	22264.75867,	22268.57690,
22272.39519,	22276.21355,	22280.03197,	22283.85046,	22287.66902,	22291.48764,	22295.30633,	22299.12508,	22302.94390,	22306.76278,
22310.58174,	22314.40075,	22318.21984,	22322.03899,	22325.85820,	22329.67748,	22333.49683,	22337.31624,	22341.13572,	22344.95526,
22348.77487,	22352.59455,	22356.41429,	22360.23410,	22364.05397,	22367.87391,	22371.69391,	22375.51398,	22379.33412,	22383.15432,
22386.97459,	22390.79492,	22394.61532,	22398.43578,	22402.25631,	22406.07691,	22409.89757,	22413.71829,	22417.53909,	22421.35994,
22425.18087,	22429.00186,	22432.82291,	22436.64403,	22440.46522,	22444.28647,	22448.10779,	22451.92917,	22455.75062,	22459.57213,
22463.39371,	22467.21535,	22471.03706,	22474.85884,	22478.68068,	22482.50259,	22486.32456,	22490.14660,	22493.96870,	22497.79087,
22501.61310,	22505.43540,	22509.25776,	22513.08019,	22516.90269,	22520.72525,	22524.54787,	22528.37056,	22532.19332,	22536.01614,
22539.83903,	22543.66198,	22547.48500,	22551.30808,	22555.13123,	22558.95444,	22562.77772,	22566.60107,	22570.42448,	22574.24795,
22578.07149,	22581.89509,	22585.71876,	22589.54250,	22593.36630,	22597.19016,	22601.01409,	22604.83809,	22608.66215,	22612.48628,
22616.31047,	22620.13472,	22623.95904,	22627.78343,	22631.60788,	22635.43240,	22639.25698,	22643.08163,	22646.90634,	22650.73111,
22654.55596,	22658.38086,	22662.20583,	22666.03087,	22669.85597,	22673.68114,	22677.50637,	22681.33167,	22685.15703,	22688.98245,
22692.80794,	22696.63350,	22700.45912,	22704.28481,	22708.11056,	22711.93637,	22715.76225,	22719.58820,	22723.41421,	22727.24028,
22731.06642,	22734.89263,	22738.71890,	22742.54523,	22746.37163,	22750.19809,	22754.02462,	22757.85121,	22761.67787,	22765.50459,
22769.33138,	22773.15823,	22776.98515,	22780.81213,	22784.63918,	22788.46629,	22792.29346,	22796.12070,	22799.94801,	22803.77538,
22807.60281,	22811.43031,	22815.25787,	22819.08550,	22822.91319,	22826.74095,	22830.56877,	22834.39666,	22838.22461,	22842.05262,
22845.88070,	22849.70885,	22853.53705,	22857.36533,	22861.19366,	22865.02207,	22868.85053,	22872.67906,	22876.50766,	22880.33632,
22884.16504,	22887.99383,	22891.82269,	22895.65160,	22899.48059,	22903.30963,	22907.13874,	22910.96792,	22914.79716,	22918.62646,
22922.45583,	22926.28526,	22930.11476,	22933.94432,	22937.77394,	22941.60363,	22945.43339,	22949.26321,	22953.09309,	22956.92304,
22960.75305,	22964.58312,	22968.41326,	22972.24346,	22976.07373,	22979.90406,	22983.73446,	22987.56492,	22991.39545,	22995.22603,
22999.05669,	23002.88740,	23006.71818,	23010.54903,	23014.37994,	23018.21091,	23022.04195,	23025.87305,	23029.70422,	23033.53545,
23037.36674,	23041.19810,	23045.02952,	23048.86101,	23052.69256,	23056.52417,	23060.35585,	23064.18759,	23068.01940,	23071.85127,
23075.68320,	23079.51520,	23083.34726,	23087.17938,	23091.01157,	23094.84383,	23098.67614,	23102.50853,	23106.34097,	23110.17348,
23114.00605,	23117.83869,	23121.67139,	23125.50415,	23129.33698,	23133.16987,	23137.00283,	23140.83585,	23144.66893,	23148.50208,
23152.33529,	23156.16856,	23160.00190,	23163.83531,	23167.66877,	23171.50230,	23175.33589,	23179.16955,	23183.00327,	23186.83706,
23190.67090,	23194.50482,	23198.33879,	23202.17283,	23206.00693,	23209.84110,	23213.67533,	23217.50962,	23221.34398,	23225.17840,
23229.01288,	23232.84743,	23236.68204,	23240.51672,	23244.35146,	23248.18626,	23252.02113,	23255.85605,	23259.69105,	23263.52610,
23267.36122,	23271.19641,	23275.03165,	23278.86696,	23282.70234,	23286.53777,	23290.37327,	23294.20884,	23298.04446,	23301.88015,
23305.71591,	23309.55173,	23313.38761,	23317.22355,	23321.05956,	23324.89563,	23328.73176,	23332.56796,	23336.40422,	23340.24055,
23344.07693,	23347.91338,	23351.74990,	23355.58647,	23359.42312,	23363.25982,	23367.09659,	23370.93342,	23374.77031,	23378.60727,
23382.44429,	23386.28137,	23390.11852,	23393.95573,	23397.79300,	23401.63033,	23405.46773,	23409.30520,	23413.14272,	23416.98031,
23420.81796,	23424.65568,	23428.49345,	23432.33129,	23436.16920,	23440.00716,	23443.84519,	23447.68329,	23451.52144,	23455.35966,
23459.19795,	23463.03629,	23466.87470,	23470.71317,	23474.55170,	23478.39030,	23482.22896,	23486.06769,	23489.90647,	23493.74532,
23497.58423,	23501.42321,	23505.26225,	23509.10135,	23512.94051,	23516.77974,	23520.61903,	23524.45838,	23528.29779,	23532.13727,
23535.97681,	23539.81642,	23543.65608,	23547.49581,	23551.33560,	23555.17546,	23559.01538,	23562.85536,	23566.69540,	23570.53551,
23574.37568,	23578.21591,	23582.05620,	23585.89656,	23589.73698,	23593.57746,	23597.41801,	23601.25861,	23605.09928,	23608.94002,
23612.78081,	23616.62167,	23620.46259,	23624.30358,	23628.14462,	23631.98573,	23635.82690,	23639.66814,	23643.50944,	23647.35080,
23651.19222,	23655.03370,	23658.87525,	23662.71686,	23666.55853,	23670.40027,	23674.24206,	23678.08392,	23681.92585,	23685.76783,
23689.60988,	23693.45199,	23697.29416,	23701.13639,	23704.97869,	23708.82105,	23712.66347,	23716.50596,	23720.34850,	23724.19111,
23728.03379,	23731.87652,	23735.71932,	23739.56217,	23743.40510,	23747.24808,	23751.09112,	23754.93423,	23758.77740,	23762.62064,
23766.46393,	23770.30729,	23774.15071,	23777.99419,	23781.83773,	23785.68134,	23789.52501,	23793.36874,	23797.21253,	23801.05639,
23804.90031,	23808.74429,	23812.58833,	23816.43243,	23820.27660,	23824.12083,	23827.96512,	23831.80947,	23835.65389,	23839.49836,
23843.34290,	23847.18750,	23851.03217,	23854.87689,	23858.72168,	23862.56653,	23866.41144,	23870.25642,	23874.10145,	23877.94655,
23881.79171,	23885.63693,	23889.48222,	23893.32756,	23897.17297,	23901.01844,	23904.86397,	23908.70957,	23912.55522,	23916.40094,
23920.24672,	23924.09256,	23927.93847,	23931.78443,	23935.63046,	23939.47655,	23943.32270,	23947.16892,	23951.01519,	23954.86153,
23958.70793,	23962.55439,	23966.40091,	23970.24749,	23974.09414,	23977.94085,	23981.78762,	23985.63445,	23989.48134,	23993.32830,
23997.17532,	24001.02240,	24004.86954,	24008.71674,	24012.56400,	24016.41133,	24020.25872,	24024.10617,	24027.95368,	24031.80125,
24035.64888,	24039.49658,	24043.34434,	24047.19216,	24051.04004,	24054.88798,	24058.73598,	24062.58405,	24066.43218,	24070.28037,
24074.12862,	24077.97693,	24081.82530,	24085.67374,	24089.52224,	24093.37079,	24097.21942,	24101.06810,	24104.91684,	24108.76564,
24112.61451,	24116.46344,	24120.31243,	24124.16148,	24128.01059,	24131.85976,	24135.70900,	24139.55830,	24143.40765,	24147.25707,
24151.10655,	24154.95610,	24158.80570,	24162.65537,	24166.50509,	24170.35488,	24174.20473,	24178.05464,	24181.90461,	24185.75464,
24189.60474,	24193.45489,	24197.30511,	24201.15539,	24205.00573,	24208.85613,	24212.70659,	24216.55712,	24220.40770,	24224.25835,
24228.10906,	24231.95983,	24235.81066,	24239.66155,	24243.51250,	24247.36351,	24251.21459,	24255.06572,	24258.91692,	24262.76818,
24266.61950,	24270.47088,	24274.32232,	24278.17382,	24282.02539,	24285.87701,	24289.72870,	24293.58045,	24297.43226,	24301.28412,
24305.13606,	24308.98805,	24312.84010,	24316.69221,	24320.54439,	24324.39662,	24328.24892,	24332.10128,	24335.95370,	24339.80618,
24343.65872,	24347.51132,	24351.36398,	24355.21671,	24359.06949,	24362.92234,	24366.77525,	24370.62821,	24374.48124,	24378.33433,
24382.18748,	24386.04069,	24389.89397,	24393.74730,	24397.60069,	24401.45415,	24405.30766,	24409.16124,	24413.01488,	24416.86858,
24420.72233,	24424.57615,	24428.43003,	24432.28398,	24436.13798,	24439.99204,	24443.84617,	24447.70035,	24451.55460,	24455.40890,
24459.26327,	24463.11770,	24466.97218,	24470.82673,	24474.68134,	24478.53601,	24482.39074,	24486.24554,	24490.10039,	24493.95530,
24497.81027,	24501.66531,	24505.52040,	24509.37556,	24513.23078,	24517.08605,	24520.94139,	24524.79679,	24528.65225,	24532.50777,
24536.36335,	24540.21899,	24544.07469,	24547.93045,	24551.78627,	24555.64215,	24559.49809,	24563.35410,	24567.21016,	24571.06629,
24574.92247,	24578.77872,	24582.63502,	24586.49139,	24590.34782,	24594.20430,	24598.06085,	24601.91746,	24605.77413,	24609.63086,
24613.48765,	24617.34450,	24621.20141,	24625.05838,	24628.91541,	24632.77250,	24636.62965,	24640.48686,	24644.34413,	24648.20147,
24652.05886,	24655.91631,	24659.77383,	24663.63140,	24667.48903,	24671.34673,	24675.20448,	24679.06230,	24682.92017,	24686.77811,
24690.63610,	24694.49416,	24698.35227,	24702.21045,	24706.06869,	24709.92698,	24713.78534,	24717.64376,	24721.50223,	24725.36077,
24729.21937,	24733.07803,	24736.93674,	24740.79552,	24744.65436,	24748.51326,	24752.37221,	24756.23123,	24760.09031,	24763.94945,
24767.80865,	24771.66791,	24775.52722,	24779.38660,	24783.24604,	24787.10554,	24790.96510,	24794.82472,	24798.68440,	24802.54413,
24806.40393,	24810.26379,	24814.12371,	24817.98369,	24821.84373,	24825.70383,	24829.56398,	24833.42420,	24837.28448,	24841.14482,
24845.00522,	24848.86567,	24852.72619,	24856.58677,	24860.44741,	24864.30810,	24868.16886,	24872.02968,	24875.89055,	24879.75149,
24883.61249,	24887.47354,	24891.33466,	24895.19584,	24899.05707,	24902.91837,	24906.77972,	24910.64114,	24914.50261,	24918.36415,
24922.22574,	24926.08739,	24929.94911,	24933.81088,	24937.67271,	24941.53461,	24945.39656,	24949.25857,	24953.12064,	24956.98277,
24960.84496,	24964.70722,	24968.56953,	24972.43190,	24976.29433,	24980.15681,	24984.01936,	24987.88197,	24991.74464,	24995.60737,
24999.47015,	25003.33300,	25007.19591,	25011.05887,	25014.92190,	25018.78498,	25022.64813,	25026.51133,	25030.37459,	25034.23792,
25038.10130,	25041.96474,	25045.82824,	25049.69180,	25053.55542,	25057.41910,	25061.28284,	25065.14664,	25069.01050,	25072.87442,
25076.73839,	25080.60243,	25084.46652,	25088.33068,	25092.19489,	25096.05917,	25099.92350,	25103.78789,	25107.65235,	25111.51686,
25115.38143,	25119.24606,	25123.11075,	25126.97549,	25130.84030,	25134.70517,	25138.57009,	25142.43508,	25146.30012,	25150.16523,
25154.03039,	25157.89561,	25161.76090,	25165.62624,	25169.49164,	25173.35710,	25177.22261,	25181.08819,	25184.95383,	25188.81953,
25192.68528,	25196.55110,	25200.41697,	25204.28290,	25208.14889,	25212.01494,	25215.88105,	25219.74722,	25223.61345,	25227.47974,
25231.34609,	25235.21249,	25239.07896,	25242.94548,	25246.81206,	25250.67870,	25254.54540,	25258.41216,	25262.27898,	25266.14586,
25270.01280,	25273.87979,	25277.74685,	25281.61396,	25285.48113,	25289.34837,	25293.21566,	25297.08301,	25300.95041,	25304.81788,
25308.68541,	25312.55299,	25316.42064,	25320.28834,	25324.15610,	25328.02392,	25331.89180,	25335.75974,	25339.62774,	25343.49580,
25347.36391,	25351.23209,	25355.10032,	25358.96861,	25362.83696,	25366.70537,	25370.57384,	25374.44237,	25378.31095,	25382.17960,
25386.04830,	25389.91706,	25393.78588,	25397.65476,	25401.52370,	25405.39270,	25409.26175,	25413.13087,	25417.00004,	25420.86927,
25424.73856,	25428.60791,	25432.47732,	25436.34678,	25440.21631,	25444.08589,	25447.95554,	25451.82524,	25455.69500,	25459.56481,
25463.43469,	25467.30463,	25471.17462,	25475.04467,	25478.91478,	25482.78495,	25486.65518,	25490.52547,	25494.39581,	25498.26622,
25502.13668,	25506.00720,	25509.87778,	25513.74842,	25517.61912,	25521.48987,	25525.36068,	25529.23156,	25533.10249,	25536.97347,
25540.84452,	25544.71563,	25548.58679,	25552.45801,	25556.32930,	25560.20063,	25564.07203,	25567.94349,	25571.81500,	25575.68658,
25579.55821,	25583.42990,	25587.30165,	25591.17345,	25595.04532,	25598.91724,	25602.78922,	25606.66126,	25610.53336,	25614.40551,
25618.27773,	25622.15000,	25626.02233,	25629.89472,	25633.76717,	25637.63968,	25641.51224,	25645.38486,	25649.25754,	25653.13028,
25657.00308,	25660.87593,	25664.74885,	25668.62182,	25672.49485,	25676.36794,	25680.24108,	25684.11429,	25687.98755,	25691.86087,
25695.73425,	25699.60769,	25703.48118,	25707.35473,	25711.22835,	25715.10201,	25718.97574,	25722.84953,	25726.72337,	25730.59727,
25734.47123,	25738.34525,	25742.21933,	25746.09346,	25749.96765,	25753.84190,	25757.71621,	25761.59058,	25765.46500,	25769.33948,
25773.21402,	25777.08862,	25780.96327,	25784.83799,	25788.71276,	25792.58759,	25796.46248,	25800.33742,	25804.21243,	25808.08749,
25811.96261,	25815.83778,	25819.71302,	25823.58831,	25827.46366,	25831.33907,	25835.21454,	25839.09006,	25842.96564,	25846.84128,
25850.71698,	25854.59274,	25858.46855,	25862.34442,	25866.22035,	25870.09634,	25873.97238,	25877.84848,	25881.72464,	25885.60086,
25889.47714,	25893.35347,	25897.22986,	25901.10631,	25904.98282,	25908.85938,	25912.73600,	25916.61268,	25920.48942,	25924.36621,
25928.24307,	25932.11998,	25935.99695,	25939.87397,	25943.75105,	25947.62819,	25951.50539,	25955.38265,	25959.25996,	25963.13733,
25967.01476,	25970.89225,	25974.76979,	25978.64740,	25982.52506,	25986.40277,	25990.28055,	25994.15838,	25998.03627,	26001.91421,
26005.79222,	26009.67028,	26013.54840,	26017.42658,	26021.30481,	26025.18310,	26029.06145,	26032.93986,	26036.81832,	26040.69685,
26044.57543,	26048.45406,	26052.33276,	26056.21151,	26060.09032,	26063.96918,	26067.84811,	26071.72709,	26075.60613,	26079.48522,
26083.36438,	26087.24359,	26091.12285,	26095.00218,	26098.88156,	26102.76100,	26106.64050,	26110.52005,	26114.39967,	26118.27934,
26122.15906,	26126.03885,	26129.91869,	26133.79858,	26137.67854,	26141.55855,	26145.43862,	26149.31875,	26153.19894,	26157.07918,
26160.95948,	26164.83983,	26168.72025,	26172.60072,	26176.48124,	26180.36183,	26184.24247,	26188.12317,	26192.00393,	26195.88474,
26199.76561,	26203.64654,	26207.52752,	26211.40857,	26215.28967,	26219.17082,	26223.05204,	26226.93331,	26230.81463,	26234.69602,
26238.57746,	26242.45896,	26246.34051,	26250.22213,	26254.10380,	26257.98552,	26261.86731,	26265.74915,	26269.63105,	26273.51300,
26277.39501,	26281.27708,	26285.15921,	26289.04139,	26292.92363,	26296.80593,	26300.68828,	26304.57069,	26308.45316,	26312.33568,
26316.21827,	26320.10090,	26323.98360,	26327.86635,	26331.74916,	26335.63203,	26339.51495,	26343.39793,	26347.28097,	26351.16406,
26355.04721,	26358.93042,	26362.81368,	26366.69700,	26370.58038,	26374.46381,	26378.34730,	26382.23085,	26386.11446,	26389.99812,
26393.88184,	26397.76561,	26401.64944,	26405.53333,	26409.41728,	26413.30128,	26417.18534,	26421.06945,	26424.95362,	26428.83785,
26432.72214,	26436.60648,	26440.49088,	26444.37533,	26448.25985,	26452.14442,	26456.02904,	26459.91372,	26463.79846,	26467.68326,
26471.56811,	26475.45302,	26479.33798,	26483.22301,	26487.10808,	26490.99322,	26494.87841,	26498.76366,	26502.64896,	26506.53432,
26510.41974,	26514.30522,	26518.19075,	26522.07633,	26525.96198,	26529.84768,	26533.73344,	26537.61925,	26541.50512,	26545.39105,
26549.27703,	26553.16307,	26557.04916,	26560.93532,	26564.82152,	26568.70779,	26572.59411,	26576.48049,	26580.36692,	26584.25341,
26588.13996,	26592.02656,	26595.91322,	26599.79994,	26603.68671,	26607.57354,	26611.46043,	26615.34737,	26619.23437,	26623.12142,
26627.00853,	26630.89570,	26634.78292,	26638.67020,	26642.55754,	26646.44493,	26650.33238,	26654.21988,	26658.10744,	26661.99506,
26665.88274,	26669.77046,	26673.65825,	26677.54609,	26681.43399,	26685.32195,	26689.20996,	26693.09802,	26696.98615,	26700.87433,
26704.76256,	26708.65085,	26712.53920,	26716.42761,	26720.31607,	26724.20458,	26728.09316,	26731.98179,	26735.87047,	26739.75921,
26743.64801,	26747.53686,	26751.42577,	26755.31474,	26759.20376,	26763.09283,	26766.98197,	26770.87116,	26774.76040,	26778.64971,
26782.53906,	26786.42848,	26790.31795,	26794.20747,	26798.09705,	26801.98669,	26805.87639,	26809.76614,	26813.65594,	26817.54580,
26821.43572,	26825.32569,	26829.21572,	26833.10581,	26836.99595,	26840.88615,	26844.77640,	26848.66671,	26852.55708,	26856.44750,
26860.33797,	26864.22851,	26868.11910,	26872.00974,	26875.90044,	26879.79120,	26883.68201,	26887.57288,	26891.46380,	26895.35478,
26899.24582,	26903.13691,	26907.02805,	26910.91926,	26914.81051,	26918.70183,	26922.59320,	26926.48463,	26930.37611,	26934.26764,
26938.15924,	26942.05089,	26945.94259,	26949.83435,	26953.72617,	26957.61804,	26961.50997,	26965.40195,	26969.29399,	26973.18608,
26977.07823,	26980.97044,	26984.86270,	26988.75502,	26992.64739,	26996.53982,	27000.43230,	27004.32484,	27008.21744,	27012.11009,
27016.00280,	27019.89556,	27023.78838,	27027.68125,	27031.57418,	27035.46716,	27039.36020,	27043.25330,	27047.14645,	27051.03966,
27054.93292,	27058.82624,	27062.71961,	27066.61304,	27070.50652,	27074.40006,	27078.29366,	27082.18731,	27086.08102,	27089.97478,
27093.86860,	27097.76247,	27101.65640,	27105.55038,	27109.44442,	27113.33851,	27117.23266,	27121.12687,	27125.02113,	27128.91545,
27132.80982,	27136.70424,	27140.59873,	27144.49326,	27148.38786,	27152.28251,	27156.17721,	27160.07197,	27163.96678,	27167.86165,
27171.75658,	27175.65156,	27179.54659,	27183.44168,	27187.33683,	27191.23203,	27195.12729,	27199.02260,	27202.91797,	27206.81339,
27210.70887,	27214.60440,	27218.49999,	27222.39563,	27226.29133,	27230.18709,	27234.08289,	27237.97876,	27241.87468,	27245.77065,
27249.66668,	27253.56277,	27257.45891,	27261.35510,	27265.25135,	27269.14766,	27273.04402,	27276.94044,	27280.83691,	27284.73343,
27288.63002,	27292.52665,	27296.42334,	27300.32009,	27304.21689,	27308.11375,	27312.01066,	27315.90763,	27319.80465,	27323.70173,
27327.59886,	27331.49605,	27335.39329,	27339.29058,	27343.18794,	27347.08534,	27350.98281,	27354.88032,	27358.77790,	27362.67552,
27366.57320,	27370.47094,	27374.36873,	27378.26658,	27382.16448,	27386.06244,	27389.96045,	27393.85852,	27397.75664,	27401.65482,
27405.55305,	27409.45133,	27413.34967,	27417.24807,	27421.14652,	27425.04503,	27428.94359,	27432.84220,	27436.74087,	27440.63960,
27444.53838,	27448.43721,	27452.33610,	27456.23505,	27460.13405,	27464.03310,	27467.93221,	27471.83137,	27475.73059,	27479.62987,
27483.52919,	27487.42858,	27491.32801,	27495.22751,	27499.12705,	27503.02665,	27506.92631,	27510.82602,	27514.72579,	27518.62561,
27522.52548,	27526.42541,	27530.32540,	27534.22544,	27538.12553,	27542.02568,	27545.92588,	27549.82614,	27553.72645,	27557.62682,
27561.52724,	27565.42772,	27569.32825,	27573.22883,	27577.12947,	27581.03017,	27584.93092,	27588.83172,	27592.73258,	27596.63349,
27600.53446,	27604.43548,	27608.33656,	27612.23769,	27616.13888,	27620.04012,	27623.94141,	27627.84276,	27631.74417,	27635.64562,
27639.54714,	27643.44870,	27647.35033,	27651.25200,	27655.15373,	27659.05552,	27662.95736,	27666.85925,	27670.76120,	27674.66320,
27678.56526,	27682.46737,	27686.36954,	27690.27176,	27694.17403,	27698.07636,	27701.97875,	27705.88118,	27709.78368,	27713.68622,
27717.58883,	27721.49148,	27725.39419,	27729.29695,	27733.19977,	27737.10265,	27741.00557,	27744.90855,	27748.81159,	27752.71468,
27756.61782,	27760.52102,	27764.42428,	27768.32758,	27772.23094,	27776.13436,	27780.03783,	27783.94135,	27787.84493,	27791.74856,
27795.65225,	27799.55599,	27803.45979,	27807.36364,	27811.26754,	27815.17150,	27819.07551,	27822.97958,	27826.88370,	27830.78787,
27834.69210,	27838.59638,	27842.50072,	27846.40511,	27850.30955,	27854.21405,	27858.11861,	27862.02321,	27865.92788,	27869.83259,
27873.73736,	27877.64218,	27881.54706,	27885.45199,	27889.35698,	27893.26202,	27897.16711,	27901.07226,	27904.97746,	27908.88272,
27912.78803,	27916.69339,	27920.59881,	27924.50428,	27928.40981,	27932.31539,	27936.22102,	27940.12671,	27944.03245,	27947.93825,
27951.84410,	27955.75000,	27959.65596,	27963.56197,	27967.46804,	27971.37416,	27975.28033,	27979.18656,	27983.09284,	27986.99917,
27990.90556,	27994.81201,	27998.71850,	28002.62505,	28006.53166,	28010.43832,	28014.34503,	28018.25179,	28022.15861,	28026.06549,
28029.97241,	28033.87940,	28037.78643,	28041.69352,	28045.60066,	28049.50786,	28053.41511,	28057.32241,	28061.22977,	28065.13718,
28069.04465,	28072.95217,	28076.85974,	28080.76736,	28084.67504,	28088.58278,	28092.49057,	28096.39841,	28100.30630,	28104.21425,
28108.12225,	28112.03031,	28115.93842,	28119.84658,	28123.75480,	28127.66307,	28131.57139,	28135.47977,	28139.38820,	28143.29669,
28147.20523,	28151.11382,	28155.02246,	28158.93116,	28162.83992,	28166.74872,	28170.65758,	28174.56650,	28178.47546,	28182.38448,
28186.29356,	28190.20269,	28194.11187,	28198.02110,	28201.93039,	28205.83973,	28209.74913,	28213.65858,	28217.56808,	28221.47764,
28225.38725,	28229.29691,	28233.20663,	28237.11640,	28241.02622,	28244.93610,	28248.84603,	28252.75601,	28256.66605,	28260.57614,
28264.48628,	28268.39648,	28272.30673,	28276.21703,	28280.12739,	28284.03780,	28287.94827,	28291.85878,	28295.76936,	28299.67998,
28303.59066,	28307.50139,	28311.41217,	28315.32301,	28319.23390,	28323.14485,	28327.05584,	28330.96689,	28334.87800,	28338.78916,
28342.70037,	28346.61163,	28350.52295,	28354.43432,	28358.34574,	28362.25722,	28366.16875,	28370.08034,	28373.99197,	28377.90366,
28381.81541,	28385.72720,	28389.63905,	28393.55096,	28397.46291,	28401.37492,	28405.28698,	28409.19910,	28413.11127,	28417.02349,
28420.93577,	28424.84809,	28428.76048,	28432.67291,	28436.58540,	28440.49794,	28444.41053,	28448.32318,	28452.23588,	28456.14863,
28460.06144,	28463.97430,	28467.88721,	28471.80018,	28475.71320,	28479.62627,	28483.53939,	28487.45257,	28491.36580,	28495.27908,
28499.19242,	28503.10581,	28507.01925,	28510.93275,	28514.84630,	28518.75990,	28522.67356,	28526.58726,	28530.50103,	28534.41484,
28538.32871,	28542.24263,	28546.15660,	28550.07062,	28553.98470,	28557.89883,	28561.81302,	28565.72726,	28569.64155,	28573.55589,
28577.47029,	28581.38473,	28585.29924,	28589.21379,	28593.12840,	28597.04306,	28600.95777,	28604.87254,	28608.78736,	28612.70223,
28616.61715,	28620.53213,	28624.44716,	28628.36224,	28632.27738,	28636.19257,	28640.10781,	28644.02311,	28647.93845,	28651.85385,
28655.76930,	28659.68481,	28663.60037,	28667.51598,	28671.43164,	28675.34736,	28679.26313,	28683.17895,	28687.09482,	28691.01075,
28694.92673,	28698.84276,	28702.75885,	28706.67499,	28710.59118,	28714.50742,	28718.42372,	28722.34007,	28726.25647,	28730.17292,
28734.08943,	28738.00599,	28741.92260,	28745.83926,	28749.75598,	28753.67275,	28757.58957,	28761.50645,	28765.42337,	28769.34035,
28773.25739,	28777.17447,	28781.09161,	28785.00880,	28788.92604,	28792.84334,	28796.76069,	28800.67809,	28804.59554,	28808.51305,
28812.43060,	28816.34821,	28820.26588,	28824.18359,	28828.10136,	28832.01918,	28835.93705,	28839.85498,	28843.77296,	28847.69099,
28851.60907,	28855.52721,	28859.44539,	28863.36363,	28867.28193,	28871.20027,	28875.11867,	28879.03712,	28882.95562,	28886.87417,
28890.79278,	28894.71144,	28898.63015,	28902.54892,	28906.46773,	28910.38660,	28914.30552,	28918.22450,	28922.14352,	28926.06260,
28929.98173,	28933.90091,	28937.82015,	28941.73944,	28945.65878,	28949.57817,	28953.49761,	28957.41711,	28961.33666,	28965.25626,
28969.17591,	28973.09562,	28977.01537,	28980.93518,	28984.85505,	28988.77496,	28992.69493,	28996.61495,	29000.53502,	29004.45514,
29008.37532,	29012.29554,	29016.21582,	29020.13616,	29024.05654,	29027.97698,	29031.89747,	29035.81801,	29039.73860,	29043.65924,
29047.57994,	29051.50069,	29055.42149,	29059.34235,	29063.26325,	29067.18421,	29071.10522,	29075.02628,	29078.94739,	29082.86856,
29086.78978,	29090.71105,	29094.63237,	29098.55375,	29102.47517,	29106.39665,	29110.31818,	29114.23976,	29118.16140,	29122.08308,
29126.00482,	29129.92661,	29133.84846,	29137.77035,	29141.69230,	29145.61429,	29149.53635,	29153.45845,	29157.38060,	29161.30281,
29165.22507,	29169.14738,	29173.06974,	29176.99215,	29180.91462,	29184.83714,	29188.75971,	29192.68233,	29196.60500,	29200.52773,
29204.45050,	29208.37333,	29212.29621,	29216.21915,	29220.14213,	29224.06517,	29227.98826,	29231.91140,	29235.83459,	29239.75783,
29243.68113,	29247.60448,	29251.52788,	29255.45133,	29259.37483,	29263.29839,	29267.22199,	29271.14565,	29275.06936,	29278.99312,
29282.91694,	29286.84080,	29290.76472,	29294.68869,	29298.61271,	29302.53678,	29306.46091,	29310.38508,	29314.30931,	29318.23359,
29322.15792,	29326.08230,	29330.00674,	29333.93122,	29337.85576,	29341.78035,	29345.70499,	29349.62968,	29353.55443,	29357.47922,
29361.40407,	29365.32897,	29369.25392,	29373.17892,	29377.10398,	29381.02908,	29384.95424,	29388.87945,	29392.80471,	29396.73002,
29400.65539,	29404.58080,	29408.50627,	29412.43179,	29416.35736,	29420.28298,	29424.20865,	29428.13438,	29432.06015,	29435.98598,
29439.91186,	29443.83779,	29447.76377,	29451.68981,	29455.61589,	29459.54203,	29463.46821,	29467.39445,	29471.32075,	29475.24709,
29479.17348,	29483.09993,	29487.02642,	29490.95297,	29494.87957,	29498.80622,	29502.73293,	29506.65968,	29510.58648,	29514.51334,
29518.44025,	29522.36721,	29526.29422,	29530.22128,	29534.14840,	29538.07556,	29542.00278,	29545.93004,	29549.85736,	29553.78473,
29557.71216,	29561.63963,	29565.56715,	29569.49473,	29573.42236,	29577.35003,	29581.27776,	29585.20554,	29589.13338,	29593.06126,
29596.98919,	29600.91718,	29604.84522,	29608.77331,	29612.70145,	29616.62964,	29620.55788,	29624.48617,	29628.41452,	29632.34291,
29636.27136,	29640.19986,	29644.12841,	29648.05701,	29651.98566,	29655.91436,	29659.84312,	29663.77192,	29667.70078,	29671.62969,
29675.55865,	29679.48766,	29683.41672,	29687.34583,	29691.27499,	29695.20421,	29699.13347,	29703.06279,	29706.99216,	29710.92158,
29714.85105,	29718.78057,	29722.71014,	29726.63976,	29730.56944,	29734.49916,	29738.42894,	29742.35877,	29746.28864,	29750.21857,
29754.14855,	29758.07859,	29762.00867,	29765.93880,	29769.86899,	29773.79922,	29777.72951,	29781.65985,	29785.59024,	29789.52068,
29793.45117,	29797.38171,	29801.31230,	29805.24294,	29809.17364,	29813.10438,	29817.03518,	29820.96603,	29824.89692,	29828.82787,
29832.75887,	29836.68992,	29840.62103,	29844.55218,	29848.48338,	29852.41464,	29856.34594,	29860.27730,	29864.20871,	29868.14016,
29872.07167,	29876.00323,	29879.93484,	29883.86650,	29887.79822,	29891.72998,	29895.66179,	29899.59366,	29903.52557,	29907.45754,
29911.38955,	29915.32162,	29919.25374,	29923.18591,	29927.11813,	29931.05040,	29934.98272,	29938.91509,	29942.84752,	29946.77999,
29950.71252,	29954.64509,	29958.57772,	29962.51039,	29966.44312,	29970.37590,	29974.30873,	29978.24161,	29982.17454,	29986.10752,
29990.04055,	29993.97363,	29997.90677,	30001.83995,	30005.77318,	30009.70647,	30013.63980,	30017.57319,	30021.50663,	30025.44011,
30029.37365,	30033.30724,	30037.24088,	30041.17457,	30045.10831,	30049.04210,	30052.97594,	30056.90983,	30060.84378,	30064.77777,
30068.71181,	30072.64591,	30076.58005,	30080.51425,	30084.44849,	30088.38279,	30092.31714,	30096.25153,	30100.18598,	30104.12048,
30108.05503,	30111.98963,	30115.92428,	30119.85898,	30123.79373,	30127.72853,	30131.66338,	30135.59828,	30139.53324,	30143.46824,
30147.40329,	30151.33840,	30155.27355,	30159.20876,	30163.14401,	30167.07932,	30171.01467,	30174.95008,	30178.88554,	30182.82105,
30186.75660,	30190.69221,	30194.62787,	30198.56358,	30202.49934,	30206.43515,	30210.37101,	30214.30692,	30218.24288,	30222.17889,
30226.11495,	30230.05106,	30233.98722,	30237.92343,	30241.85970,	30245.79601,	30249.73237,	30253.66879,	30257.60525,	30261.54176,
30265.47833,	30269.41494,	30273.35161,	30277.28832,	30281.22508,	30285.16190,	30289.09877,	30293.03568,	30296.97265,	30300.90966,
30304.84673,	30308.78385,	30312.72101,	30316.65823,	30320.59550,	30324.53281,	30328.47018,	30332.40760,	30336.34507,	30340.28258,
30344.22015,	30348.15777,	30352.09544,	30356.03316,	30359.97093,	30363.90874,	30367.84661,	30371.78453,	30375.72250,	30379.66052,
30383.59859,	30387.53671,	30391.47488,	30395.41310,	30399.35137,	30403.28969,	30407.22806,	30411.16648,	30415.10495,	30419.04347,
30422.98204,	30426.92066,	30430.85932,	30434.79804,	30438.73681,	30442.67563,	30446.61450,	30450.55342,	30454.49239,	30458.43141,
30462.37048,	30466.30960,	30470.24877,	30474.18799,	30478.12726,	30482.06658,	30486.00595,	30489.94537,	30493.88484,	30497.82436,
30501.76393,	30505.70355,	30509.64322,	30513.58294,	30517.52270,	30521.46252,	30525.40239,	30529.34231,	30533.28228,	30537.22230,
30541.16236,	30545.10248,	30549.04265,	30552.98287,	30556.92313,	30560.86345,	30564.80382,	30568.74424,	30572.68470,	30576.62522,
30580.56579,	30584.50640,	30588.44707,	30592.38778,	30596.32855,	30600.26936,	30604.21023,	30608.15114,	30612.09211,	30616.03312,
30619.97419,	30623.91530,	30627.85646,	30631.79768,	30635.73894,	30639.68025,	30643.62161,	30647.56303,	30651.50449,	30655.44600,
30659.38756,	30663.32917,	30667.27083,	30671.21254,	30675.15430,	30679.09611,	30683.03797,	30686.97988,	30690.92184,	30694.86385,
30698.80590,	30702.74801,	30706.69017,	30710.63237,	30714.57463,	30718.51694,	30722.45929,	30726.40170,	30730.34415,	30734.28665,
30738.22921,	30742.17181,	30746.11446,	30750.05717,	30753.99992,	30757.94272,	30761.88557,	30765.82847,	30769.77142,	30773.71442,
30777.65747,	30781.60057,	30785.54372,	30789.48691,	30793.43016,	30797.37346,	30801.31680,	30805.26020,	30809.20365,	30813.14714,
30817.09068,	30821.03428,	30824.97792,	30828.92161,	30832.86535,	30836.80915,	30840.75299,	30844.69688,	30848.64082,	30852.58480,
30856.52884,	30860.47293,	30864.41707,	30868.36125,	30872.30549,	30876.24978,	30880.19411,	30884.13849,	30888.08293,	30892.02741,
30895.97194,	30899.91652,	30903.86115,	30907.80583,	30911.75056,	30915.69534,	30919.64017,	30923.58505,	30927.52997,	30931.47495,
30935.41997,	30939.36505,	30943.31017,	30947.25535,	30951.20057,	30955.14584,	30959.09116,	30963.03653,	30966.98195,	30970.92742,
30974.87294,	30978.81850,	30982.76412,	30986.70979,	30990.65550,	30994.60126,	30998.54708,	31002.49294,	31006.43885,	31010.38481,
31014.33082,	31018.27688,	31022.22299,	31026.16915,	31030.11535,	31034.06161,	31038.00791,	31041.95427,	31045.90067,	31049.84712,
31053.79362,	31057.74017,	31061.68677,	31065.63342,	31069.58012,	31073.52687,	31077.47366,	31081.42051,	31085.36740,	31089.31435,
31093.26134,	31097.20838,	31101.15547,	31105.10261,	31109.04980,	31112.99704,	31116.94432,	31120.89166,	31124.83904,	31128.78648,
31132.73396,	31136.68149,	31140.62907,	31144.57670,	31148.52438,	31152.47211,	31156.41989,	31160.36771,	31164.31559,	31168.26351,
31172.21148,	31176.15950,	31180.10757,	31184.05569,	31188.00386,	31191.95208,	31195.90035,	31199.84866,	31203.79702,	31207.74544,
31211.69390,	31215.64241,	31219.59097,	31223.53958,	31227.48824,	31231.43694,	31235.38570,	31239.33450,	31243.28335,	31247.23226,
31251.18121,	31255.13021,	31259.07925,	31263.02835,	31266.97750,	31270.92669,	31274.87594,	31278.82523,	31282.77457,	31286.72396,
31290.67340,	31294.62289,	31298.57242,	31302.52201,	31306.47164,	31310.42132,	31314.37106,	31318.32084,	31322.27066,	31326.22054,
31330.17047,	31334.12044,	31338.07047,	31342.02054,	31345.97066,	31349.92083,	31353.87105,	31357.82132,	31361.77163,	31365.72200,
31369.67241,	31373.62287,	31377.57339,	31381.52395,	31385.47455,	31389.42521,	31393.37592,	31397.32667,	31401.27747,	31405.22832,
31409.17922,	31413.13017,	31417.08117,	31421.03222,	31424.98331,	31428.93445,	31432.88565,	31436.83689,	31440.78818,	31444.73951,
31448.69090,	31452.64233,	31456.59382,	31460.54535,	31464.49693,	31468.44856,	31472.40024,	31476.35196,	31480.30374,	31484.25556,
31488.20743,	31492.15935,	31496.11132,	31500.06334,	31504.01540,	31507.96752,	31511.91968,	31515.87189,	31519.82415,	31523.77646,
31527.72881,	31531.68122,	31535.63367,	31539.58617,	31543.53872,	31547.49132,	31551.44397,	31555.39667,	31559.34941,	31563.30220,
31567.25504,	31571.20793,	31575.16087,	31579.11386,	31583.06689,	31587.01997,	31590.97310,	31594.92628,	31598.87951,	31602.83279,
31606.78611,	31610.73949,	31614.69291,	31618.64638,	31622.59989,	31626.55346,	31630.50708,	31634.46074,	31638.41445,	31642.36821,
31646.32202,	31650.27587,	31654.22978,	31658.18373,	31662.13773,	31666.09178,	31670.04588,	31674.00003,	31677.95422,	31681.90846,
31685.86275,	31689.81709,	31693.77148,	31697.72592,	31701.68040,	31705.63493,	31709.58951,	31713.54414,	31717.49882,	31721.45354,
31725.40831,	31729.36314,	31733.31800,	31737.27292,	31741.22789,	31745.18290,	31749.13796,	31753.09307,	31757.04823,	31761.00344,
31764.95869,	31768.91400,	31772.86935,	31776.82475,	31780.78019,	31784.73569,	31788.69123,	31792.64682,	31796.60246,	31800.55815,
31804.51389,	31808.46967,	31812.42550,	31816.38138,	31820.33731,	31824.29329,	31828.24931,	31832.20538,	31836.16150,	31840.11767,
31844.07389,	31848.03015,	31851.98647,	31855.94283,	31859.89924,	31863.85569,	31867.81220,	31871.76875,	31875.72535,	31879.68200,
31883.63870,	31887.59544,	31891.55223,	31895.50907,	31899.46596,	31903.42290,	31907.37988,	31911.33691,	31915.29399,	31919.25112,
31923.20830,	31927.16552,	31931.12280,	31935.08012,	31939.03748,	31942.99490,	31946.95236,	31950.90987,	31954.86743,	31958.82504,
31962.78270,	31966.74040,	31970.69815,	31974.65595,	31978.61379,	31982.57169,	31986.52963,	31990.48762,	31994.44566,	31998.40375,
32002.36188,	32006.32006,	32010.27829,	32014.23657,	32018.19489,	32022.15327,	32026.11169,	32030.07015,	32034.02867,	32037.98723,
32041.94585,	32045.90450,	32049.86321,	32053.82197,	32057.78077,	32061.73962,	32065.69852,	32069.65746,	32073.61646,	32077.57550,
32081.53459,	32085.49373,	32089.45291,	32093.41214,	32097.37142,	32101.33075,	32105.29013,	32109.24955,	32113.20902,	32117.16854,
32121.12810,	32125.08772,	32129.04738,	32133.00709,	32136.96684,	32140.92665,	32144.88650,	32148.84640,	32152.80635,	32156.76634,
32160.72638,	32164.68647,	32168.64661,	32172.60680,	32176.56703,	32180.52731,	32184.48764,	32188.44801,	32192.40844,	32196.36891,
32200.32943,	32204.28999,	32208.25061,	32212.21127,	32216.17198,	32220.13273,	32224.09354,	32228.05439,	32232.01529,	32235.97623,
32239.93723,	32243.89827,	32247.85936,	32251.82049,	32255.78167,	32259.74291,	32263.70418,	32267.66551,	32271.62688,	32275.58831,
32279.54977,	32283.51129,	32287.47285,	32291.43446,	32295.39612,	32299.35783,	32303.31958,	32307.28138,	32311.24323,	32315.20513,
32319.16707,	32323.12906,	32327.09110,	32331.05318,	32335.01531,	32338.97749,	32342.93972,	32346.90200,	32350.86432,	32354.82669,
32358.78910,	32362.75157,	32366.71408,	32370.67664,	32374.63924,	32378.60190,	32382.56460,	32386.52735,	32390.49014,	32394.45298,
32398.41587,	32402.37881,	32406.34180,	32410.30483,	32414.26791,	32418.23103,	32422.19421,	32426.15743,	32430.12070,	32434.08401,
32438.04738,	32442.01079,	32445.97424,	32449.93775,	32453.90130,	32457.86490,	32461.82854,	32465.79224,	32469.75598,	32473.71977,
32477.68360,	32481.64748,	32485.61141,	32489.57539,	32493.53941,	32497.50348,	32501.46760,	32505.43177,	32509.39598,	32513.36024,
32517.32455,	32521.28890,	32525.25330,	32529.21775,	32533.18224,	32537.14679,	32541.11138,	32545.07601,	32549.04070,	32553.00543,
32556.97021,	32560.93503,	32564.89990,	32568.86482,	32572.82979,	32576.79480,	32580.75986,	32584.72497,	32588.69013,	32592.65533,
32596.62058,	32600.58587,	32604.55121,	32608.51660,	32612.48204,	32616.44753,	32620.41306,	32624.37863,	32628.34426,	32632.30993,
32636.27565,	32640.24142,	32644.20723,	32648.17309,	32652.13900,	32656.10495,	32660.07095,	32664.03700,	32668.00309,	32671.96923,
32675.93542,	32679.90166,	32683.86794,	32687.83427,	32691.80065,	32695.76707,	32699.73354,	32703.70006,	32707.66662,	32711.63323,
32715.59989,	32719.56660,	32723.53335,	32727.50015,	32731.46699,	32735.43388,	32739.40082,	32743.36781,	32747.33484,	32751.30192,
32755.26905,	32759.23622,	32763.20344,	32767.17071,	32771.13802,	32775.10538,	32779.07279,	32783.04025,	32787.00775,	32790.97530,
32794.94289,	32798.91053,	32802.87822,	32806.84595,	32810.81374,	32814.78157,	32818.74944,	32822.71736,	32826.68533,	32830.65335,
32834.62141,	32838.58952,	32842.55768,	32846.52588,	32850.49413,	32854.46242,	32858.43077,	32862.39916,	32866.36759,	32870.33608,
32874.30460,	32878.27318,	32882.24180,	32886.21047,	32890.17919,	32894.14795,	32898.11676,	32902.08562,	32906.05452,	32910.02347,
32913.99247,	32917.96151,	32921.93060,	32925.89974,	32929.86892,	32933.83815,	32937.80743,	32941.77675,	32945.74612,	32949.71553,
32953.68500,	32957.65451,	32961.62406,	32965.59366,	32969.56331,	32973.53301,	32977.50275,	32981.47254,	32985.44237,	32989.41225,
32993.38218,	32997.35216,	33001.32218,	33005.29225,	33009.26236,	33013.23252,	33017.20273,	33021.17298,	33025.14328,	33029.11363,
33033.08402,	33037.05446,	33041.02495,	33044.99548,	33048.96606,	33052.93669,	33056.90736,	33060.87808,	33064.84884,	33068.81966,
33072.79051,	33076.76142,	33080.73237,	33084.70337,	33088.67441,	33092.64550,	33096.61664,	33100.58782,	33104.55905,	33108.53033,
33112.50165,	33116.47302,	33120.44443,	33124.41589,	33128.38740,	33132.35895,	33136.33056,	33140.30220,	33144.27390,	33148.24563,
33152.21742,	33156.18925,	33160.16113,	33164.13306,	33168.10503,	33172.07705,	33176.04911,	33180.02122,	33183.99338,	33187.96558,
33191.93783,	33195.91012,	33199.88247,	33203.85485,	33207.82729,	33211.79977,	33215.77229,	33219.74487,	33223.71749,	33227.69015,
33231.66286,	33235.63562,	33239.60843,	33243.58128,	33247.55417,	33251.52712,	33255.50011,	33259.47314,	33263.44622,	33267.41935,
33271.39253,	33275.36575,	33279.33901,	33283.31233,	33287.28568,	33291.25909,	33295.23254,	33299.20604,	33303.17958,	33307.15317,
33311.12681,	33315.10049,	33319.07422,	33323.04799,	33327.02181,	33330.99568,	33334.96959,	33338.94355,	33342.91755,	33346.89160,
33350.86570,	33354.83984,	33358.81403,	33362.78827,	33366.76255,	33370.73688,	33374.71125,	33378.68567,	33382.66014,	33386.63465,
33390.60921,	33394.58381,	33398.55846,	33402.53316,	33406.50790,	33410.48268,	33414.45752,	33418.43240,	33422.40732,	33426.38230,
33430.35731,	33434.33238,	33438.30749,	33442.28264,	33446.25785,	33450.23309,	33454.20839,	33458.18373,	33462.15911,	33466.13455,
33470.11002,	33474.08555,	33478.06112,	33482.03673,	33486.01239,	33489.98810,	33493.96386,	33497.93965,	33501.91550,	33505.89139,
33509.86733,	33513.84331,	33517.81934,	33521.79541,	33525.77154,	33529.74770,	33533.72391,	33537.70017,	33541.67648,	33545.65283,
33549.62922,	33553.60566,	33557.58215,	33561.55868,	33565.53526,	33569.51189,	33573.48856,	33577.46528,	33581.44204,	33585.41885,
33589.39570,	33593.37260,	33597.34955,	33601.32654,	33605.30358,	33609.28066,	33613.25779,	33617.23496,	33621.21218,	33625.18945,
33629.16676,	33633.14412,	33637.12152,	33641.09897,	33645.07647,	33649.05401,	33653.03159,	33657.00923,	33660.98690,	33664.96463,
33668.94240,	33672.92021,	33676.89807,	33680.87598,	33684.85393,	33688.83193,	33692.80997,	33696.78806,	33700.76620,	33704.74438,
33708.72260,	33712.70088,	33716.67919,	33720.65756,	33724.63596,	33728.61442,	33732.59292,	33736.57146,	33740.55006,	33744.52869,
33748.50738,	33752.48610,	33756.46488,	33760.44370,	33764.42256,	33768.40147,	33772.38043,	33776.35943,	33780.33848,	33784.31757,
33788.29671,	33792.27589,	33796.25512,	33800.23440,	33804.21372,	33808.19308,	33812.17250,	33816.15195,	33820.13146,	33824.11101,
33828.09060,	33832.07024,	33836.04992,	33840.02965,	33844.00943,	33847.98925,	33851.96912,	33855.94903,	33859.92899,	33863.90899,
33867.88904,	33871.86914,	33875.84927,	33879.82946,	33883.80969,	33887.78997,	33891.77029,	33895.75066,	33899.73107,	33903.71153,
33907.69203,	33911.67258,	33915.65317,	33919.63381,	33923.61450,	33927.59523,	33931.57600,	33935.55682,	33939.53769,	33943.51860,
33947.49956,	33951.48056,	33955.46161,	33959.44270,	33963.42384,	33967.40503,	33971.38626,	33975.36753,	33979.34885,	33983.33022,
33987.31163,	33991.29308,	33995.27459,	33999.25613,	34003.23772,	34007.21936,	34011.20104,	34015.18277,	34019.16455,	34023.14636,
34027.12823,	34031.11014,	34035.09209,	34039.07409,	34043.05614,	34047.03823,	34051.02036,	34055.00254,	34058.98477,	34062.96704,
34066.94936,	34070.93172,	34074.91413,	34078.89658,	34082.87907,	34086.86162,	34090.84421,	34094.82684,	34098.80952,	34102.79224,
34106.77501,	34110.75782,	34114.74068,	34118.72359,	34122.70653,	34126.68953,	34130.67257,	34134.65565,	34138.63878,	34142.62196,
34146.60518,	34150.58844,	34154.57175,	34158.55511,	34162.53851,	34166.52196,	34170.50545,	34174.48898,	34178.47256,	34182.45619,
34186.43986,	34190.42358,	34194.40734,	34198.39115,	34202.37500,	34206.35890,	34210.34284,	34214.32682,	34218.31086,	34222.29493,
34226.27906,	34230.26322,	34234.24743,	34238.23169,	34242.21599,	34246.20034,	34250.18473,	34254.16917,	34258.15365,	34262.13818,
34266.12275,	34270.10737,	34274.09203,	34278.07674,	34282.06149,	34286.04629,	34290.03113,	34294.01602,	34298.00095,	34301.98593,
34305.97095,	34309.95602,	34313.94113,	34317.92629,	34321.91149,	34325.89673,	34329.88203,	34333.86736,	34337.85274,	34341.83817,
34345.82364,	34349.80916,	34353.79472,	34357.78033,	34361.76598,	34365.75167,	34369.73741,	34373.72320,	34377.70903,	34381.69491,
34385.68083,	34389.66679,	34393.65280,	34397.63886,	34401.62495,	34405.61110,	34409.59729,	34413.58352,	34417.56980,	34421.55613,
34425.54249,	34429.52891,	34433.51537,	34437.50187,	34441.48842,	34445.47501,	34449.46165,	34453.44833,	34457.43506,	34461.42183,
34465.40864,	34469.39551,	34473.38241,	34477.36936,	34481.35636,	34485.34340,	34489.33048,	34493.31761,	34497.30479,	34501.29201,
34505.27927,	34509.26658,	34513.25393,	34517.24133,	34521.22877,	34525.21626,	34529.20379,	34533.19137,	34537.17899,	34541.16666,
34545.15437,	34549.14212,	34553.12992,	34557.11777,	34561.10566,	34565.09359,	34569.08157,	34573.06960,	34577.05766,	34581.04578,
34585.03393,	34589.02214,	34593.01038,	34596.99867,	34600.98701,	34604.97539,	34608.96382,	34612.95229,	34616.94080,	34620.92936,
34624.91796,	34628.90661,	34632.89530,	34636.88404,	34640.87282,	34644.86165,	34648.85052,	34652.83944,	34656.82840,	34660.81740,
34664.80645,	34668.79554,	34672.78468,	34676.77386,	34680.76309,	34684.75236,	34688.74168,	34692.73104,	34696.72045,	34700.70990,
34704.69939,	34708.68893,	34712.67851,	34716.66814,	34720.65781,	34724.64753,	34728.63729,	34732.62710,	34736.61695,	34740.60684,
34744.59678,	34748.58676,	34752.57679,	34756.56686,	34760.55698,	34764.54714,	34768.53735,	34772.52760,	34776.51789,	34780.50823,
34784.49861,	34788.48904,	34792.47951,	34796.47003,	34800.46059,	34804.45120,	34808.44184,	34812.43254,	34816.42328,	34820.41406,
34824.40489,	34828.39576,	34832.38667,	34836.37763,	34840.36864,	34844.35969,	34848.35078,	34852.34192,	34856.33310,	34860.32433,
34864.31560,	34868.30691,	34872.29827,	34876.28967,	34880.28112,	34884.27261,	34888.26415,	34892.25573,	34896.24735,	34900.23902,
34904.23074,	34908.22249,	34912.21430,	34916.20614,	34920.19803,	34924.18997,	34928.18195,	34932.17397,	34936.16604,	34940.15815,
34944.15030,	34948.14250,	34952.13475,	34956.12704,	34960.11937,	34964.11174,	34968.10417,	34972.09663,	34976.08914,	34980.08169,
34984.07429,	34988.06693,	34992.05962,	34996.05235,	35000.04512,	35004.03794,	35008.03080,	35012.02371,	35016.01666,	35020.00966,
35024.00270,	35027.99578,	35031.98891,	35035.98208,	35039.97530,	35043.96856,	35047.96186,	35051.95521,	35055.94860,	35059.94204,
35063.93552,	35067.92904,	35071.92261,	35075.91622,	35079.90988,	35083.90358,	35087.89732,	35091.89111,	35095.88494,	35099.87882,
35103.87274,	35107.86671,	35111.86072,	35115.85477,	35119.84887,	35123.84301,	35127.83719,	35131.83142,	35135.82570,	35139.82001,
35143.81437,	35147.80878,	35151.80323,	35155.79772,	35159.79226,	35163.78684,	35167.78146,	35171.77613,	35175.77085,	35179.76560,
35183.76040,	35187.75525,	35191.75014,	35195.74507,	35199.74005,	35203.73507,	35207.73013,	35211.72524,	35215.72039,	35219.71559,
35223.71083,	35227.70611,	35231.70144,	35235.69681,	35239.69223,	35243.68769,	35247.68319,	35251.67874,	35255.67433,	35259.66997,
35263.66565,	35267.66137,	35271.65714,	35275.65295,	35279.64880,	35283.64470,	35287.64064,	35291.63663,	35295.63266,	35299.62873,
35303.62485,	35307.62101,	35311.61721,	35315.61346,	35319.60976,	35323.60609,	35327.60247,	35331.59890,	35335.59537,	35339.59188,
35343.58843,	35347.58503,	35351.58167,	35355.57836,	35359.57509,	35363.57187,	35367.56868,	35371.56555,	35375.56245,	35379.55940,
35383.55639,	35387.55343,	35391.55051,	35395.54763,	35399.54480,	35403.54201,	35407.53927,	35411.53657,	35415.53391,	35419.53130,
35423.52873,	35427.52620,	35431.52372,	35435.52128,	35439.51888,	35443.51653,	35447.51423,	35451.51196,	35455.50974,	35459.50756,
35463.50543,	35467.50334,	35471.50129,	35475.49929,	35479.49733,	35483.49542,	35487.49355,	35491.49172,	35495.48993,	35499.48819,
35503.48650,	35507.48484,	35511.48323,	35515.48167,	35519.48014,	35523.47867,	35527.47723,	35531.47584,	35535.47449,	35539.47318,
35543.47192,	35547.47071,	35551.46953,	35555.46840,	35559.46731,	35563.46627,	35567.46527,	35571.46431,	35575.46340,	35579.46253,
35583.46171,	35587.46092,	35591.46018,	35595.45949,	35599.45884,	35603.45823,	35607.45766,	35611.45714,	35615.45666,	35619.45623,
35623.45584,	35627.45549,	35631.45519,	35635.45493,	35639.45471,	35643.45454,	35647.45440,	35651.45432,	35655.45427,	35659.45427,
35663.45432,	35667.45440,	35671.45454,	35675.45471,	35679.45493,	35683.45519,	35687.45549,	35691.45584,	35695.45623,	35699.45666,
35703.45714,	35707.45766,	35711.45822,	35715.45883,	35719.45948,	35723.46018,	35727.46092,	35731.46170,	35735.46252,	35739.46339,
35743.46430,	35747.46525,	35751.46625,	35755.46729,	35759.46838,	35763.46950,	35767.47068,	35771.47189,	35775.47315,	35779.47445,
35783.47579,	35787.47718,	35791.47861,	35795.48009,	35799.48160,	35803.48316,	35807.48477,	35811.48641,	35815.48810,	35819.48984,
35823.49162,	35827.49344,	35831.49530,	35835.49721,	35839.49916,	35843.50115,	35847.50319,	35851.50527,	35855.50739,	35859.50955,
35863.51176,	35867.51402,	35871.51631,	35875.51865,	35879.52103,	35883.52346,	35887.52593,	35891.52844,	35895.53099,	35899.53359,
35903.53623,	35907.53892,	35911.54164,	35915.54441,	35919.54723,	35923.55008,	35927.55298,	35931.55593,	35935.55891,	35939.56194,
35943.56502,	35947.56813,	35951.57129,	35955.57449,	35959.57774,	35963.58103,	35967.58436,	35971.58773,	35975.59115,	35979.59461,
35983.59811,	35987.60166,	35991.60525,	35995.60888,	35999.61256,	36003.61628,	36007.62004,	36011.62384,	36015.62769,	36019.63158,
36023.63552,	36027.63950,	36031.64352,	36035.64758,	36039.65169,	36043.65583,	36047.66003,	36051.66426,	36055.66854,	36059.67286,
36063.67723,	36067.68163,	36071.68608,	36075.69058,	36079.69511,	36083.69969,	36087.70432,	36091.70898,	36095.71369,	36099.71844,
36103.72323,	36107.72807,	36111.73295,	36115.73787,	36119.74284,	36123.74785,	36127.75290,	36131.75800,	36135.76313,	36139.76831,
36143.77354,	36147.77880,	36151.78411,	36155.78946,	36159.79486,	36163.80030,	36167.80578,	36171.81130,	36175.81687,	36179.82248,
36183.82813,	36187.83383,	36191.83956,	36195.84534,	36199.85117,	36203.85703,	36207.86294,	36211.86890,	36215.87489,	36219.88093,
36223.88701,	36227.89313,	36231.89930,	36235.90551,	36239.91176,	36243.91806,	36247.92439,	36251.93077,	36255.93720,	36259.94366,
36263.95017,	36267.95672,	36271.96332,	36275.96996,	36279.97664,	36283.98336,	36287.99012,	36291.99693,	36296.00378,	36300.01068,
36304.01761,	36308.02459,	36312.03161,	36316.03868,	36320.04579,	36324.05294,	36328.06013,	36332.06737,	36336.07464,	36340.08196,
36344.08933,	36348.09673,	36352.10418,	36356.11168,	36360.11921,	36364.12679,	36368.13441,	36372.14207,	36376.14977,	36380.15752,
36384.16531,	36388.17315,	36392.18102,	36396.18894,	36400.19690,	36404.20490,	36408.21295,	36412.22104,	36416.22917,	36420.23735,
36424.24556,	36428.25382,	36432.26212,	36436.27047,	36440.27886,	36444.28728,	36448.29576,	36452.30427,	36456.31283,	36460.32143,
36464.33007,	36468.33876,	36472.34749,	36476.35626,	36480.36507,	36484.37393,	36488.38282,	36492.39176,	36496.40075,	36500.40977,
36504.41884,	36508.42795,	36512.43711,	36516.44630,	36520.45554,	36524.46482,	36528.47414,	36532.48351,	36536.49292,	36540.50237,
36544.51186,	36548.52140,	36552.53098,	36556.54060,	36560.55026,	36564.55997,	36568.56971,	36572.57951,	36576.58934,	36580.59921,
36584.60913,	36588.61909,	36592.62910,	36596.63914,	36600.64923,	36604.65936,	36608.66953,	36612.67975,	36616.69000,	36620.70030,
36624.71065,	36628.72103,	36632.73146,	36636.74193,	36640.75244,	36644.76299,	36648.77359,	36652.78423,	36656.79491,	36660.80564,
36664.81640,	36668.82721,	36672.83806,	36676.84896,	36680.85989,	36684.87087,	36688.88189,	36692.89295,	36696.90406,	36700.91520,
36704.92639,	36708.93763,	36712.94890,	36716.96022,	36720.97158,	36724.98298,	36728.99442,	36733.00591,	36737.01743,	36741.02901,
36745.04062,	36749.05227,	36753.06397,	36757.07571,	36761.08749,	36765.09932,	36769.11118,	36773.12309,	36777.13504,	36781.14703,
36785.15907,	36789.17115,	36793.18327,	36797.19543,	36801.20763,	36805.21988,	36809.23217,	36813.24450,	36817.25687,	36821.26929,
36825.28175,	36829.29425,	36833.30679,	36837.31937,	36841.33200,	36845.34467,	36849.35738,	36853.37013,	36857.38293,	36861.39576,
36865.40864,	36869.42156,	36873.43453,	36877.44753,	36881.46058,	36885.47367,	36889.48680,	36893.49998,	36897.51319,	36901.52645,
36905.53975,	36909.55310,	36913.56648,	36917.57991,	36921.59338,	36925.60689,	36929.62044,	36933.63404,	36937.64768,	36941.66136,
36945.67508,	36949.68884,	36953.70265,	36957.71650,	36961.73039,	36965.74432,	36969.75829,	36973.77231,	36977.78637,	36981.80047,
36985.81461,	36989.82879,	36993.84302,	36997.85729,	37001.87160,	37005.88595,	37009.90035,	37013.91478,	37017.92926,	37021.94378,
37025.95834,	37029.97295,	37033.98760,	37038.00228,	37042.01701,	37046.03179,	37050.04660,	37054.06146,	37058.07636,	37062.09130,
37066.10628,	37070.12130,	37074.13637,	37078.15148,	37082.16663,	37086.18182,	37090.19705,	37094.21233,	37098.22765,	37102.24301,
37106.25841,	37110.27385,	37114.28934,	37118.30486,	37122.32043,	37126.33605,	37130.35170,	37134.36739,	37138.38313,	37142.39891,
37146.41473,	37150.43059,	37154.44650,	37158.46244,	37162.47843,	37166.49446,	37170.51053,	37174.52665,	37178.54280,	37182.55900,
37186.57524,	37190.59152,	37194.60784,	37198.62421,	37202.64061,	37206.65706,	37210.67355,	37214.69008,	37218.70666,	37222.72327,
37226.73993,	37230.75663,	37234.77337,	37238.79015,	37242.80698,	37246.82384,	37250.84075,	37254.85770,	37258.87469,	37262.89173,
37266.90880,	37270.92592,	37274.94308,	37278.96028,	37282.97752,	37286.99480,	37291.01213,	37295.02950,	37299.04691,	37303.06436,
37307.08185,	37311.09938,	37315.11696,	37319.13458,	37323.15224,	37327.16994,	37331.18768,	37335.20546,	37339.22329,	37343.24116,
37347.25907,	37351.27702,	37355.29501,	37359.31305,	37363.33112,	37367.34924,	37371.36740,	37375.38560,	37379.40384,	37383.42213,
37387.44045,	37391.45882,	37395.47723,	37399.49568,	37403.51417,	37407.53271,	37411.55128,	37415.56990,	37419.58856,	37423.60726,
37427.62600,	37431.64478,	37435.66361,	37439.68248,	37443.70139,	37447.72034,	37451.73933,	37455.75836,	37459.77743,	37463.79655,
37467.81571,	37471.83491,	37475.85415,	37479.87343,	37483.89276,	37487.91212,	37491.93153,	37495.95098,	37499.97047,	37503.99000,
37508.00957,	37512.02919,	37516.04884,	37520.06854,	37524.08828,	37528.10806,	37532.12788,	37536.14775,	37540.16765,	37544.18760,
37548.20759,	37552.22762,	37556.24769,	37560.26780,	37564.28795,	37568.30815,	37572.32839,	37576.34866,	37580.36898,	37584.38935,
37588.40975,	37592.43019,	37596.45068,	37600.47121,	37604.49177,	37608.51238,	37612.53303,	37616.55373,	37620.57446,	37624.59524,
37628.61605,	37632.63691,	37636.65781,	37640.67875,	37644.69974,	37648.72076,	37652.74182,	37656.76293,	37660.78408,	37664.80527,
37668.82650,	37672.84777,	37676.86908,	37680.89044,	37684.91184,	37688.93327,	37692.95475,	37696.97627,	37700.99783,	37705.01944,
37709.04108,	37713.06276,	37717.08449,	37721.10626,	37725.12807,	37729.14992,	37733.17181,	37737.19374,	37741.21572,	37745.23773,
37749.25979,	37753.28189,	37757.30403,	37761.32621,	37765.34843,	37769.37070,	37773.39300,	37777.41535,	37781.43773,	37785.46016,
37789.48263,	37793.50514,	37797.52769,	37801.55029,	37805.57292,	37809.59560,	37813.61831,	37817.64107,	37821.66387,	37825.68671,
37829.70959,	37833.73252,	37837.75548,	37841.77849,	37845.80153,	37849.82462,	37853.84775,	37857.87092,	37861.89413,	37865.91738,
37869.94068,	37873.96401,	37877.98739,	37882.01081,	37886.03426,	37890.05776,	37894.08130,	37898.10489,	37902.12851,	37906.15217,
37910.17588,	37914.19962,	37918.22341,	37922.24724,	37926.27111,	37930.29502,	37934.31897,	37938.34296,	37942.36700,	37946.39107,
37950.41519,	37954.43935,	37958.46354,	37962.48778,	37966.51206,	37970.53639,	37974.56075,	37978.58515,	37982.60960,	37986.63408,
37990.65861,	37994.68318,	37998.70779,	38002.73244,	38006.75713,	38010.78186,	38014.80663,	38018.83144,	38022.85630,	38026.88120,
38030.90613,	38034.93111,	38038.95613,	38042.98119,	38047.00629,	38051.03143,	38055.05662,	38059.08184,	38063.10710,	38067.13241,
38071.15776,	38075.18314,	38079.20857,	38083.23404,	38087.25955,	38091.28511,	38095.31070,	38099.33633,	38103.36201,	38107.38772,
38111.41348,	38115.43927,	38119.46511,	38123.49099,	38127.51691,	38131.54287,	38135.56887,	38139.59492,	38143.62100,	38147.64713,
38151.67329,	38155.69950,	38159.72574,	38163.75203,	38167.77836,	38171.80473,	38175.83114,	38179.85759,	38183.88409,	38187.91062,
38191.93719,	38195.96381,	38199.99046,	38204.01716,	38208.04390,	38212.07068,	38216.09750,	38220.12436,	38224.15126,	38228.17820,
38232.20518,	38236.23220,	38240.25927,	38244.28637,	38248.31352,	38252.34070,	38256.36793,	38260.39520,	38264.42251,	38268.44986,
38272.47725,	38276.50468,	38280.53215,	38284.55966,	38288.58722,	38292.61481,	38296.64245,	38300.67012,	38304.69784,	38308.72560,
38312.75339,	38316.78123,	38320.80911,	38324.83703,	38328.86499,	38332.89300,	38336.92104,	38340.94912,	38344.97724,	38349.00541,
38353.03361,	38357.06186,	38361.09015,	38365.11847,	38369.14684,	38373.17525,	38377.20370,	38381.23219,	38385.26072,	38389.28929,
38393.31790,	38397.34656,	38401.37525,	38405.40398,	38409.43276,	38413.46157,	38417.49043,	38421.51932,	38425.54826,	38429.57724,
38433.60626,	38437.63532,	38441.66442,	38445.69356,	38449.72274,	38453.75196,	38457.78122,	38461.81052,	38465.83987,	38469.86925,
38473.89867,	38477.92814,	38481.95764,	38485.98719,	38490.01678,	38494.04640,	38498.07607,	38502.10578,	38506.13553,	38510.16532,
38514.19515,	38518.22502,	38522.25493,	38526.28488,	38530.31487,	38534.34491,	38538.37498,	38542.40509,	38546.43525,	38550.46544,
38554.49568,	38558.52595,	38562.55627,	38566.58663,	38570.61703,	38574.64746,	38578.67794,	38582.70846,	38586.73902,	38590.76962,
38594.80026,	38598.83094,	38602.86166,	38606.89242,	38610.92322,	38614.95407,	38618.98495,	38623.01587,	38627.04684,	38631.07784,
38635.10889,	38639.13997,	38643.17110,	38647.20226,	38651.23347,	38655.26472,	38659.29600,	38663.32733,	38667.35870,	38671.39011,
38675.42156,	38679.45305,	38683.48458,	38687.51615,	38691.54776,	38695.57941,	38699.61110,	38703.64283,	38707.67460,	38711.70641,
38715.73827,	38719.77016,	38723.80209,	38727.83407,	38731.86608,	38735.89813,	38739.93023,	38743.96236,	38747.99454,	38752.02676,
38756.05901,	38760.09131,	38764.12364,	38768.15602,	38772.18844,	38776.22090,	38780.25339,	38784.28593,	38788.31851,	38792.35113,
38796.38379,	38800.41649,	38804.44923,	38808.48201,	38812.51483,	38816.54769,	38820.58059,	38824.61353,	38828.64651,	38832.67953,
38836.71259,	38840.74570,	38844.77884,	38848.81202,	38852.84524,	38856.87851,	38860.91181,	38864.94515,	38868.97854,	38873.01196,
38877.04542,	38881.07893,	38885.11247,	38889.14606,	38893.17968,	38897.21335,	38901.24705,	38905.28080,	38909.31458,	38913.34841,
38917.38227,	38921.41618,	38925.45013,	38929.48411,	38933.51814,	38937.55221,	38941.58631,	38945.62046,	38949.65465,	38953.68887,
38957.72314,	38961.75745,	38965.79180,	38969.82618,	38973.86061,	38977.89508,	38981.92959,	38985.96414,	38989.99873,	38994.03335,
38998.06802,	39002.10273,	39006.13748,	39010.17227,	39014.20710,	39018.24197,	39022.27688,	39026.31182,	39030.34681,	39034.38184,
39038.41691,	39042.45202,	39046.48717,	39050.52236,	39054.55759,	39058.59286,	39062.62817,	39066.66352,	39070.69891,	39074.73434,
39078.76981,	39082.80532,	39086.84087,	39090.87646,	39094.91209,	39098.94776,	39102.98347,	39107.01922,	39111.05501,	39115.09084,
39119.12671,	39123.16262,	39127.19857,	39131.23456,	39135.27059,	39139.30666,	39143.34277,	39147.37891,	39151.41510,	39155.45133,
39159.48760,	39163.52391,	39167.56026,	39171.59665,	39175.63308,	39179.66955,	39183.70606,	39187.74261,	39191.77920,	39195.81583,
39199.85249,	39203.88920,	39207.92595,	39211.96274,	39215.99957,	39220.03644,	39224.07335,	39228.11029,	39232.14728,	39236.18431,
39240.22138,	39244.25849,	39248.29563,	39252.33282,	39256.37005,	39260.40731,	39264.44462,	39268.48197,	39272.51935,	39276.55678,
39280.59425,	39284.63175,	39288.66930,	39292.70689,	39296.74451,	39300.78218,	39304.81988,	39308.85763,	39312.89541,	39316.93324,
39320.97110,	39325.00901,	39329.04695,	39333.08493,	39337.12296,	39341.16102,	39345.19912,	39349.23727,	39353.27545,	39357.31367,
39361.35194,	39365.39024,	39369.42858,	39373.46696,	39377.50538,	39381.54384,	39385.58234,	39389.62089,	39393.65947,	39397.69809,
39401.73675,	39405.77545,	39409.81419,	39413.85296,	39417.89178,	39421.93064,	39425.96954,	39430.00848,	39434.04746,	39438.08647,
39442.12553,	39446.16463,	39450.20376,	39454.24294,	39458.28215,	39462.32141,	39466.36071,	39470.40004,	39474.43941,	39478.47883,
39482.51828,	39486.55778,	39490.59731,	39494.63688,	39498.67649,	39502.71615,	39506.75584,	39510.79557,	39514.83534,	39518.87515,
39522.91500,	39526.95489,	39530.99482,	39535.03479,	39539.07480,	39543.11485,	39547.15493,	39551.19506,	39555.23523,	39559.27543,
39563.31568,	39567.35597,	39571.39629,	39575.43666,	39579.47706,	39583.51751,	39587.55799,	39591.59851,	39595.63908,	39599.67968,
39603.72032,	39607.76100,	39611.80172,	39615.84248,	39619.88328,	39623.92412,	39627.96500,	39632.00592,	39636.04688,	39640.08788,
39644.12891,	39648.16999,	39652.21111,	39656.25226,	39660.29346,	39664.33469,	39668.37597,	39672.41728,	39676.45863,	39680.50003,
39684.54146,	39688.58293,	39692.62444,	39696.66599,	39700.70758,	39704.74921,	39708.79088,	39712.83259,	39716.87434,	39720.91612,
39724.95795,	39728.99982,	39733.04172,	39737.08367,	39741.12565,	39745.16768,	39749.20974,	39753.25184,	39757.29398,	39761.33617,
39765.37839,	39769.42065,	39773.46295,	39777.50529,	39781.54766,	39785.59008,	39789.63254,	39793.67504,	39797.71757,	39801.76015,
39805.80276,	39809.84542,	39813.88811,	39817.93084,	39821.97362,	39826.01643,	39830.05928,	39834.10217,	39838.14510,	39842.18807,
39846.23108,	39850.27412,	39854.31721,	39858.36034,	39862.40350,	39866.44671,	39870.48995,	39874.53324,	39878.57656,	39882.61992,
39886.66332,	39890.70676,	39894.75024,	39898.79376,	39902.83732,	39906.88092,	39910.92456,	39914.96823,	39919.01195,	39923.05571,
39927.09950,	39931.14333,	39935.18721,	39939.23112,	39943.27507,	39947.31906,	39951.36309,	39955.40716,	39959.45127,	39963.49542,
39967.53960,	39971.58383,	39975.62809,	39979.67240,	39983.71674,	39987.76112,	39991.80555,	39995.85001,	39999.89451,	40003.93905,
40007.98363,	40012.02825,	40016.07290,	40020.11760,	40024.16234,	40028.20711,	40032.25192,	40036.29678,	40040.34167,	40044.38660,
40048.43157,	40052.47658,	40056.52163,	40060.56672,	40064.61185,	40068.65701,	40072.70222,	40076.74746,	40080.79275,	40084.83807,
40088.88343,	40092.92883,	40096.97427,	40101.01975,	40105.06527,	40109.11083,	40113.15643,	40117.20206,	40121.24774,	40125.29345,
40129.33920,	40133.38500,	40137.43083,	40141.47670,	40145.52261,	40149.56856,	40153.61454,	40157.66057,	40161.70664,	40165.75274,
40169.79888,	40173.84507,	40177.89129,	40181.93755,	40185.98385,	40190.03019,	40194.07657,	40198.12298,	40202.16944,	40206.21594,
40210.26247,	40214.30904,	40218.35566,	40222.40231,	40226.44900,	40230.49573,	40234.54249,	40238.58930,	40242.63615,	40246.68303,
40250.72996,	40254.77692,	40258.82392,	40262.87096,	40266.91804,	40270.96516,	40275.01232,	40279.05952,	40283.10675,	40287.15403,
40291.20134,	40295.24870,	40299.29609,	40303.34352,	40307.39099,	40311.43850,	40315.48604,	40319.53363,	40323.58125,	40327.62892,
40331.67662,	40335.72436,	40339.77215,	40343.81996,	40347.86782,	40351.91572,	40355.96366,	40360.01163,	40364.05965,	40368.10770,
40372.15579,	40376.20392,	40380.25209,	40384.30030,	40388.34855,	40392.39684,	40396.44516,	40400.49353,	40404.54193,	40408.59037,
40412.63885,	40416.68737,	40420.73593,	40424.78453,	40428.83316,	40432.88184,	40436.93055,	40440.97930,	40445.02809,	40449.07692,
40453.12579,	40457.17470,	40461.22365,	40465.27263,	40469.32166,	40473.37072,	40477.41982,	40481.46896,	40485.51814,	40489.56736,
40493.61662,	40497.66591,	40501.71525,	40505.76462,	40509.81403,	40513.86348,	40517.91297,	40521.96250,	40526.01207,	40530.06167,
40534.11132,	40538.16100,	40542.21072,	40546.26048,	40550.31028,	40554.36012,	40558.40999,	40562.45991,	40566.50986,	40570.55986,
40574.60989,	40578.65996,	40582.71007,	40586.76022,	40590.81040,	40594.86063,	40598.91089,	40602.96119,	40607.01153,	40611.06191,
40615.11233,	40619.16279,	40623.21329,	40627.26382,	40631.31439,	40635.36500,	40639.41565,	40643.46634,	40647.51707,	40651.56784,
40655.61864,	40659.66949,	40663.72037,	40667.77129,	40671.82225,	40675.87325,	40679.92428,	40683.97536,	40688.02647,	40692.07763,
40696.12882,	40700.18005,	40704.23131,	40708.28262,	40712.33397,	40716.38535,	40720.43677,	40724.48824,	40728.53973,	40732.59127,
40736.64285,	40740.69447,	40744.74612,	40748.79781,	40752.84954,	40756.90131,	40760.95312,	40765.00497,	40769.05685,	40773.10878,
40777.16074,	40781.21274,	40785.26478,	40789.31686,	40793.36898,	40797.42113,	40801.47332,	40805.52556,	40809.57783,	40813.63014,
40817.68248,	40821.73487,	40825.78729,	40829.83976,	40833.89226,	40837.94480,	40841.99738,	40846.04999,	40850.10265,	40854.15534,
40858.20808,	40862.26085,	40866.31366,	40870.36650,	40874.41939,	40878.47232,	40882.52528,	40886.57828,	40890.63132,	40894.68440,
40898.73752,	40902.79067,	40906.84386,	40910.89710,	40914.95037,	40919.00368,	40923.05702,	40927.11041,	40931.16383,	40935.21730,
40939.27080,	40943.32434,	40947.37791,	40951.43153,	40955.48518,	40959.53888,	40963.59261,	40967.64638,	40971.70019,	40975.75403,
40979.80792,	40983.86184,	40987.91580,	40991.96980,	40996.02384,	41000.07792,	41004.13203,	41008.18619,	41012.24038,	41016.29461,
41020.34888,	41024.40318,	41028.45753,	41032.51191,	41036.56633,	41040.62079,	41044.67529,	41048.72983,	41052.78440,	41056.83901,
41060.89366,	41064.94835,	41069.00308,	41073.05785,	41077.11265,	41081.16750,	41085.22238,	41089.27730,	41093.33225,	41097.38725,
41101.44228,	41105.49736,	41109.55247,	41113.60762,	41117.66280,	41121.71803,	41125.77329,	41129.82859,	41133.88393,	41137.93931,
41141.99473,	41146.05018,	41150.10568,	41154.16121,	41158.21678,	41162.27238,	41166.32803,	41170.38371,	41174.43944,	41178.49520,
41182.55100,	41186.60683,	41190.66271,	41194.71862,	41198.77457,	41202.83056,	41206.88659,	41210.94266,	41214.99876,	41219.05490,
41223.11108,	41227.16730,	41231.22356,	41235.27985,	41239.33619,	41243.39256,	41247.44897,	41251.50541,	41255.56190,	41259.61842,
41263.67499,	41267.73159,	41271.78822,	41275.84490,	41279.90161,	41283.95837,	41288.01516,	41292.07199,	41296.12885,	41300.18576,
41304.24270,	41308.29968,	41312.35670,	41316.41376,	41320.47085,	41324.52799,	41328.58516,	41332.64237,	41336.69961,	41340.75690,
41344.81422,	41348.87159,	41352.92899,	41356.98642,	41361.04390,	41365.10141,	41369.15897,	41373.21656,	41377.27418,	41381.33185,
41385.38955,	41389.44730,	41393.50508,	41397.56289,	41401.62075,	41405.67864,	41409.73658,	41413.79455,	41417.85256,	41421.91060,
41425.96869,	41430.02681,	41434.08497,	41438.14317,	41442.20140,	41446.25968,	41450.31799,	41454.37634,	41458.43473,	41462.49315,
41466.55162,	41470.61012,	41474.66866,	41478.72724,	41482.78585,	41486.84451,	41490.90320,	41494.96193,	41499.02069,	41503.07950,
41507.13834,	41511.19723,	41515.25614,	41519.31510,	41523.37410,	41527.43313,	41531.49220,	41535.55131,	41539.61046,	41543.66964,
41547.72886,	41551.78812,	41555.84742,	41559.90676,	41563.96613,	41568.02554,	41572.08499,	41576.14448,	41580.20401,	41584.26357,
41588.32317,	41592.38281,	41596.44249,	41600.50220,	41604.56196,	41608.62175,	41612.68157,	41616.74144,	41620.80134,	41624.86129,
41628.92127,	41632.98128,	41637.04134,	41641.10143,	41645.16156,	41649.22173,	41653.28194,	41657.34218,	41661.40247,	41665.46279,
41669.52314,	41673.58354,	41677.64397,	41681.70444,	41685.76495,	41689.82550,	41693.88608,	41697.94671,	41702.00737,	41706.06806,
41710.12880,	41714.18957,	41718.25038,	41722.31123,	41726.37212,	41730.43304,	41734.49401,	41738.55501,	41742.61604,	41746.67712,
41750.73823,	41754.79938,	41758.86057,	41762.92180,	41766.98306,	41771.04436,	41775.10570,	41779.16708,	41783.22849,	41787.28995,
41791.35144,	41795.41296,	41799.47453,	41803.53613,	41807.59777,	41811.65945,	41815.72117,	41819.78292,	41823.84472,	41827.90654,
41831.96841,	41836.03032,	41840.09226,	41844.15424,	41848.21626,	41852.27831,	41856.34040,	41860.40253,	41864.46470,	41868.52691,
41872.58915,	41876.65143,	41880.71375,	41884.77611,	41888.83850,	41892.90093,	41896.96340,	41901.02591,	41905.08845,	41909.15104,
41913.21366,	41917.27631,	41921.33901,	41925.40174,	41929.46451,	41933.52732,	41937.59016,	41941.65305,	41945.71597,	41949.77892,
41953.84192,	41957.90495,	41961.96802,	41966.03113,	41970.09428,	41974.15746,	41978.22068,	41982.28394,	41986.34723,	41990.41057,
41994.47394,	41998.53735,	42002.60079,	42006.66428,	42010.72780,	42014.79136,	42018.85495,	42022.91859,	42026.98226,	42031.04596,
42035.10971,	42039.17349,	42043.23732,	42047.30117,	42051.36507,	42055.42900,	42059.49297,	42063.55698,	42067.62103,	42071.68511,
42075.74923,	42079.81339,	42083.87759,	42087.94182,	42092.00609,	42096.07040,	42100.13475,	42104.19913,	42108.26355,	42112.32801,
42116.39250,	42120.45704,	42124.52161,	42128.58621,	42132.65086,	42136.71554,	42140.78026,	42144.84502,	42148.90981,	42152.97465,
42157.03952,	42161.10442,	42165.16937,	42169.23435,	42173.29937,	42177.36442,	42181.42952,	42185.49465,	42189.55982,	42193.62502,
42197.69027,	42201.75555,	42205.82087,	42209.88622,	42213.95162,	42218.01705,	42222.08251,	42226.14802,	42230.21356,	42234.27914,
42238.34476,	42242.41041,	42246.47610,	42250.54183,	42254.60760,	42258.67340,	42262.73924,	42266.80512,	42270.87104,	42274.93699,
42279.00298,	42283.06901,	42287.13507,	42291.20118,	42295.26732,	42299.33349,	42303.39971,	42307.46596,	42311.53225,	42315.59857,
42319.66494,	42323.73134,	42327.79777,	42331.86425,	42335.93076,	42339.99731,	42344.06390,	42348.13052,	42352.19718,	42356.26388,
42360.33062,	42364.39739,	42368.46420,	42372.53105,	42376.59793,	42380.66485,	42384.73181,	42388.79881,	42392.86584,	42396.93291,
42401.00002,	42405.06717,	42409.13435,	42413.20157,	42417.26883,	42421.33612,	42425.40345,	42429.47082,	42433.53823,	42437.60567,
42441.67315,	42445.74067,	42449.80822,	42453.87581,	42457.94344,	42462.01111,	42466.07881,	42470.14655,	42474.21433,	42478.28214,
42482.34999,	42486.41788,	42490.48581,	42494.55377,	42498.62177,	42502.68981,	42506.75788,	42510.82600,	42514.89414,	42518.96233,
42523.03055,	42527.09881,	42531.16711,	42535.23544,	42539.30382,	42543.37222,	42547.44067,	42551.50915,	42555.57767,	42559.64623,
42563.71482,	42567.78345,	42571.85212,	42575.92083,	42579.98957,	42584.05835,	42588.12717,	42592.19602,	42596.26491,	42600.33384,
42604.40280,	42608.47180,	42612.54084,	42616.60992,	42620.67903,	42624.74818,	42628.81737,	42632.88659,	42636.95585,	42641.02515,
42645.09449,	42649.16386,	42653.23327,	42657.30271,	42661.37220,	42665.44172,	42669.51127,	42673.58087,	42677.65050,	42681.72017,
42685.78987,	42689.85961,	42693.92939,	42697.99921,	42702.06906,	42706.13895,	42710.20888,	42714.27884,	42718.34884,	42722.41888,
42726.48896,	42730.55907,	42734.62922,	42738.69940,	42742.76963,	42746.83989,	42750.91018,	42754.98052,	42759.05089,	42763.12129,
42767.19174,	42771.26222,	42775.33274,	42779.40329,	42783.47388,	42787.54451,	42791.61518,	42795.68588,	42799.75662,	42803.82740,
42807.89821,	42811.96906,	42816.03995,	42820.11087,	42824.18183,	42828.25283,	42832.32387,	42836.39494,	42840.46605,	42844.53719,
42848.60837,	42852.67959,	42856.75085,	42860.82214,	42864.89347,	42868.96484,	42873.03624,	42877.10768,	42881.17916,	42885.25067,
42889.32222,	42893.39381,	42897.46543,	42901.53709,	42905.60879,	42909.68053,	42913.75230,	42917.82411,	42921.89595,	42925.96783,
42930.03975,	42934.11171,	42938.18370,	42942.25573,	42946.32780,	42950.39990,	42954.47204,	42958.54421,	42962.61643,	42966.68868,
42970.76096,	42974.83329,	42978.90565,	42982.97804,	42987.05048,	42991.12295,	42995.19546,	42999.26800,	43003.34058,	43007.41320,
43011.48585,	43015.55854,	43019.63127,	43023.70404,	43027.77684,	43031.84967,	43035.92255,	43039.99546,	43044.06841,	43048.14139,
43052.21441,	43056.28747,	43060.36057,	43064.43370,	43068.50687,	43072.58007,	43076.65331,	43080.72659,	43084.79991,	43088.87326,
43092.94665,	43097.02007,	43101.09353,	43105.16703,	43109.24057,	43113.31414,	43117.38775,	43121.46139,	43125.53507,	43129.60879,
43133.68255,	43137.75634,	43141.83017,	43145.90403,	43149.97793,	43154.05187,	43158.12585,	43162.19986,	43166.27391,	43170.34799,
43174.42211,	43178.49627,	43182.57047,	43186.64470,	43190.71896,	43194.79327,	43198.86761,	43202.94199,	43207.01640,	43211.09085,
43215.16534,	43219.23986,	43223.31442,	43227.38902,	43231.46365,	43235.53832,	43239.61303,	43243.68777,	43247.76255,	43251.83737,
43255.91222,	43259.98711,	43264.06204,	43268.13700,	43272.21200,	43276.28704,	43280.36211,	43284.43722,	43288.51236,	43292.58755,
43296.66276,	43300.73802,	43304.81331,	43308.88864,	43312.96400,	43317.03940,	43321.11484,	43325.19031,	43329.26583,	43333.34137,
43337.41696,	43341.49258,	43345.56823,	43349.64393,	43353.71965,	43357.79542,	43361.87122,	43365.94706,	43370.02294,	43374.09885,
43378.17480,	43382.25078,	43386.32680,	43390.40286,	43394.47895,	43398.55508,	43402.63125,	43406.70746,	43410.78369,	43414.85997,
43418.93628,	43423.01263,	43427.08902,	43431.16544,	43435.24190,	43439.31839,	43443.39492,	43447.47149,	43451.54810,	43455.62474,
43459.70141,	43463.77813,	43467.85488,	43471.93166,	43476.00849,	43480.08534,	43484.16224,	43488.23917,	43492.31614,	43496.39314,
43500.47018,	43504.54726,	43508.62437,	43512.70152,	43516.77871,	43520.85593,	43524.93319,	43529.01049,	43533.08782,	43537.16519,
43541.24259,	43545.32003,	43549.39751,	43553.47502,	43557.55257,	43561.63016,	43565.70778,	43569.78544,	43573.86313,	43577.94086,
43582.01863,	43586.09643,	43590.17428,	43594.25215,	43598.33006,	43602.40801,	43606.48600,	43610.56402,	43614.64208,	43618.72017,
43622.79830,	43626.87647,	43630.95467,	43635.03291,	43639.11119,	43643.18950,	43647.26785,	43651.34623,	43655.42465,	43659.50311,
43663.58160,	43667.66013,	43671.73870,	43675.81730,	43679.89594,	43683.97461,	43688.05332,	43692.13207,	43696.21085,	43700.28967,
43704.36853,	43708.44742,	43712.52634,	43716.60531,	43720.68431,	43724.76335,	43728.84242,	43732.92153,	43737.00067,	43741.07985,
43745.15907,	43749.23832,	43753.31761,	43757.39694,	43761.47630,	43765.55570,	43769.63514,	43773.71461,	43777.79411,	43781.87366,
43785.95323,	43790.03285,	43794.11250,	43798.19219,	43802.27191,	43806.35167,	43810.43147,	43814.51130,	43818.59117,	43822.67107,
43826.75101,	43830.83099,	43834.91100,	43838.99105,	43843.07114,	43847.15126,	43851.23142,	43855.31161,	43859.39184,	43863.47211,
43867.55241,	43871.63274,	43875.71312,	43879.79353,	43883.87397,	43887.95446,	43892.03498,	43896.11553,	43900.19612,	43904.27675,
43908.35741,	43912.43811,	43916.51884,	43920.59961,	43924.68042,	43928.76126,	43932.84214,	43936.92306,	43941.00401,	43945.08499,
43949.16602,	43953.24708,	43957.32817,	43961.40930,	43965.49047,	43969.57167,	43973.65291,	43977.73419,	43981.81550,	43985.89685,
43989.97823,	43994.05965,	43998.14110,	44002.22260,	44006.30412,	44010.38569,	44014.46729,	44018.54892,	44022.63059,	44026.71230,
44030.79404,	44034.87582,	44038.95764,	44043.03949,	44047.12138,	44051.20330,	44055.28526,	44059.36725,	44063.44928,	44067.53135,
44071.61345,	44075.69559,	44079.77777,	44083.85998,	44087.94223,	44092.02451,	44096.10683,	44100.18918,	44104.27157,	44108.35400,
44112.43646,	44116.51896,	44120.60149,	44124.68406,	44128.76667,	44132.84931,	44136.93199,	44141.01470,	44145.09745,	44149.18024,
44153.26306,	44157.34591,	44161.42881,	44165.51174,	44169.59470,	44173.67770,	44177.76074,	44181.84381,	44185.92692,	44190.01006,
44194.09324,	44198.17646,	44202.25971,	44206.34300,	44210.42632,	44214.50968,	44218.59308,	44222.67651,	44226.75997,	44230.84348,
44234.92701,	44239.01059,	44243.09420,	44247.17784,	44251.26153,	44255.34524,	44259.42900,	44263.51279,	44267.59661,	44271.68047,
44275.76437,	44279.84830,	44283.93227,	44288.01627,	44292.10031,	44296.18439,	44300.26850,	44304.35265,	44308.43683,	44312.52105,
44316.60530,	44320.68959,	44324.77392,	44328.85828,	44332.94268,	44337.02711,	44341.11158,	44345.19609,	44349.28063,	44353.36520,
44357.44981,	44361.53446,	44365.61915,	44369.70387,	44373.78862,	44377.87341,	44381.95824,	44386.04310,	44390.12800,	44394.21293,
44398.29790,	44402.38291,	44406.46795,	44410.55302,	44414.63813,	44418.72328,	44422.80847,	44426.89369,	44430.97894,	44435.06423,
44439.14956,	44443.23492,	44447.32032,	44451.40575,	44455.49122,	44459.57672,	44463.66226,	44467.74784,	44471.83345,	44475.91910,
44480.00478,	44484.09050,	44488.17625,	44492.26204,	44496.34787,	44500.43373,	44504.51963,	44508.60556,	44512.69153,	44516.77753,
44520.86357,	44524.94965,	44529.03576,	44533.12190,	44537.20808,	44541.29430,	44545.38056,	44549.46684,	44553.55317,	44557.63953,
44561.72592,	44565.81235,	44569.89882,	44573.98532,	44578.07186,	44582.15843,	44586.24504,	44590.33169,	44594.41837,	44598.50508,
44602.59183,	44606.67862,	44610.76544,	44614.85230,	44618.93920,	44623.02612,	44627.11309,	44631.20009,	44635.28712,	44639.37420,
44643.46130,	44647.54844,	44651.63562,	44655.72284,	44659.81008,	44663.89737,	44667.98469,	44672.07204,	44676.15944,	44680.24686,
44684.33432,	44688.42182,	44692.50935,	44696.59692,	44700.68453,	44704.77217,	44708.85984,	44712.94755,	44717.03530,	44721.12308,
44725.21090,	44729.29875,	44733.38664,	44737.47456,	44741.56252,	44745.65051,	44749.73854,	44753.82661,	44757.91471,	44762.00284,
44766.09102,	44770.17922,	44774.26747,	44778.35574,	44782.44406,	44786.53241,	44790.62079,	44794.70921,	44798.79766,	44802.88615,
44806.97468,	44811.06324,	44815.15184,	44819.24047,	44823.32914,	44827.41784,	44831.50658,	44835.59535,	44839.68416,	44843.77301,
44847.86189,	44851.95080,	44856.03975,	44860.12874,	44864.21776,	44868.30682,	44872.39591,	44876.48504,	44880.57420,	44884.66340,
44888.75263,	44892.84190,	44896.93121,	44901.02055,	44905.10992,	44909.19933,	44913.28878,	44917.37826,	44921.46778,	44925.55733,
44929.64691,	44933.73654,	44937.82619,	44941.91589,	44946.00562,	44950.09538,	44954.18518,	44958.27501,	44962.36488,	44966.45479,
44970.54473,	44974.63470,	44978.72472,	44982.81476,	44986.90484,	44990.99496,	44995.08511,	44999.17530,	45003.26552,	45007.35578,
45011.44607,	45015.53640,	45019.62677,	45023.71717,	45027.80760,	45031.89807,	45035.98858,	45040.07912,	45044.16969,	45048.26030,
45052.35095,	45056.44163,	45060.53235,	45064.62310,	45068.71388,	45072.80471,	45076.89556,	45080.98646,	45085.07738,	45089.16835,
45093.25935,	45097.35038,	45101.44145,	45105.53255,	45109.62369,	45113.71486,	45117.80607,	45121.89732,	45125.98860,	45130.07991,
45134.17126,	45138.26265,	45142.35407,	45146.44553,	45150.53702,	45154.62854,	45158.72011,	45162.81170,	45166.90333,	45170.99500,
45175.08670,	45179.17844,	45183.27021,	45187.36202,	45191.45386,	45195.54574,	45199.63765,	45203.72960,	45207.82159,	45211.91360,
45216.00566,	45220.09775,	45224.18987,	45228.28203,	45232.37422,	45236.46645,	45240.55872,	45244.65102,	45248.74335,	45252.83572,
45256.92813,	45261.02057,	45265.11304,	45269.20555,	45273.29810,	45277.39068,	45281.48329,	45285.57594,	45289.66863,	45293.76135,
45297.85410,	45301.94689,	45306.03972,	45310.13258,	45314.22548,	45318.31841,	45322.41137,	45326.50438,	45330.59741,	45334.69048,
45338.78359,	45342.87673,	45346.96991,	45351.06312,	45355.15637,	45359.24965,	45363.34296,	45367.43632,	45371.52970,	45375.62312,
45379.71658,	45383.81007,	45387.90360,	45391.99716,	45396.09076,	45400.18439,	45404.27806,	45408.37176,	45412.46549,	45416.55927,
45420.65307,	45424.74692,	45428.84079,	45432.93470,	45437.02865,	45441.12263,	45445.21665,	45449.31070,	45453.40479,	45457.49891,
45461.59307,	45465.68726,	45469.78148,	45473.87574,	45477.97004,	45482.06437,	45486.15874,	45490.25314,	45494.34758,	45498.44205,
45502.53655,	45506.63109,	45510.72567,	45514.82028,	45518.91493,	45523.00961,	45527.10432,	45531.19907,	45535.29386,	45539.38868,
45543.48354,	45547.57843,	45551.67335,	45555.76831,	45559.86331,	45563.95834,	45568.05340,	45572.14850,	45576.24363,	45580.33880,
45584.43401,	45588.52925,	45592.62452,	45596.71983,	45600.81517,	45604.91055,	45609.00597,	45613.10141,	45617.19690,	45621.29241,
45625.38797,	45629.48356,	45633.57918,	45637.67484,	45641.77053,	45645.86625,	45649.96202,	45654.05781,	45658.15365,	45662.24951,
45666.34541,	45670.44135,	45674.53732,	45678.63333,	45682.72937,	45686.82544,	45690.92155,	45695.01770,	45699.11388,	45703.21009,
45707.30634,	45711.40262,	45715.49894,	45719.59530,	45723.69169,	45727.78811,	45731.88457,	45735.98106,	45740.07759,	45744.17415,
45748.27075,	45752.36738,	45756.46405,	45760.56075,	45764.65748,	45768.75426,	45772.85106,	45776.94790,	45781.04478,	45785.14169,
45789.23863,	45793.33561,	45797.43263,	45801.52967,	45805.62676,	45809.72388,	45813.82103,	45817.91822,	45822.01544,	45826.11270,
45830.20999,	45834.30732,	45838.40468,	45842.50207,	45846.59950,	45850.69697,	45854.79447,	45858.89201,	45862.98957,	45867.08718,
45871.18482,	45875.28249,	45879.38020,	45883.47794,	45887.57572,	45891.67353,	45895.77138,	45899.86926,	45903.96718,	45908.06513,
45912.16312,	45916.26114,	45920.35919,	45924.45728,	45928.55540,	45932.65356,	45936.75176,	45940.84999,	45944.94825,	45949.04655,
45953.14488,	45957.24325,	45961.34165,	45965.44008,	45969.53855,	45973.63706,	45977.73560,	45981.83417,	45985.93278,	45990.03143,
45994.13010,	45998.22882,	46002.32756,	46006.42635,	46010.52516,	46014.62401,	46018.72290,	46022.82182,	46026.92078,	46031.01977,
46035.11879,	46039.21785,	46043.31694,	46047.41607,	46051.51523,	46055.61443,	46059.71366,	46063.81293,	46067.91223,	46072.01156,
46076.11093,	46080.21034,	46084.30978,	46088.40925,	46092.50876,	46096.60830,	46100.70788,	46104.80749,	46108.90714,	46113.00682,
46117.10653,	46121.20628,	46125.30606,	46129.40588,	46133.50574,	46137.60562,	46141.70555,	46145.80550,	46149.90549,	46154.00552,
46158.10558,	46162.20568,	46166.30580,	46170.40597,	46174.50617,	46178.60640,	46182.70667,	46186.80697,	46190.90730,	46195.00767,
46199.10808,	46203.20852,	46207.30899,	46211.40950,	46215.51004,	46219.61062,	46223.71123,	46227.81188,	46231.91256,	46236.01328,
46240.11402,	46244.21481,	46248.31563,	46252.41648,	46256.51737,	46260.61829,	46264.71924,	46268.82024,	46272.92126,	46277.02232,
46281.12341,	46285.22454,	46289.32570,	46293.42690,	46297.52813,	46301.62940,	46305.73070,	46309.83203,	46313.93340,	46318.03481,
46322.13624,	46326.23772,	46330.33922,	46334.44076,	46338.54234,	46342.64395,	46346.74559,	46350.84727,	46354.94898,	46359.05073,
46363.15251,	46367.25433,	46371.35618,	46375.45806,	46379.55998,	46383.66193,	46387.76392,	46391.86594,	46395.96800,	46400.07009,
46404.17221,	46408.27437,	46412.37657,	46416.47880,	46420.58106,	46424.68335,	46428.78568,	46432.88805,	46436.99045,	46441.09288,
46445.19535,	46449.29785,	46453.40039,	46457.50296,	46461.60557,	46465.70821,	46469.81088,	46473.91359,	46478.01633,	46482.11911,
46486.22192,	46490.32476,	46494.42764,	46498.53056,	46502.63350,	46506.73649,	46510.83950,	46514.94255,	46519.04564,	46523.14876,
46527.25191,	46531.35510,	46535.45832,	46539.56158,	46543.66487,	46547.76819,	46551.87155,	46555.97494,	46560.07837,	46564.18183,
46568.28533,	46572.38886,	46576.49242,	46580.59602,	46584.69965,	46588.80332,	46592.90702,	46597.01076,	46601.11453,	46605.21833,
46609.32217,	46613.42604,	46617.52995,	46621.63389,	46625.73786,	46629.84187,	46633.94591,	46638.04999,	46642.15410,	46646.25825,
46650.36243,	46654.46664,	46658.57089,	46662.67517,	46666.77949,	46670.88384,	46674.98822,	46679.09264,	46683.19710,	46687.30158,
46691.40610,	46695.51066,	46699.61525,	46703.71987,	46707.82453,	46711.92922,	46716.03395,	46720.13871,	46724.24350,	46728.34833,
46732.45319,	46736.55809,	46740.66302,	46744.76799,	46748.87298,	46752.97802,	46757.08308,	46761.18819,	46765.29332,	46769.39849,
46773.50369,	46777.60893,	46781.71420,	46785.81951,	46789.92485,	46794.03022,	46798.13563,	46802.24107,	46806.34655,	46810.45206,
46814.55760,	46818.66318,	46822.76879,	46826.87444,	46830.98012,	46835.08584,	46839.19158,	46843.29737,	46847.40318,	46851.50903,
46855.61492,	46859.72084,	46863.82679,	46867.93278,	46872.03880,	46876.14485,	46880.25094,	46884.35706,	46888.46322,	46892.56941,
46896.67564,	46900.78190,	46904.88819,	46908.99452,	46913.10088,	46917.20727,	46921.31370,	46925.42016,	46929.52666,	46933.63319,
46937.73976,	46941.84635,	46945.95299,	46950.05965,	46954.16636,	46958.27309,	46962.37986,	46966.48666,	46970.59350,	46974.70037,
46978.80727,	46982.91421,	46987.02118,	46991.12819,	46995.23523,	46999.34230,	47003.44941,	47007.55655,	47011.66373,	47015.77094,
47019.87818,	47023.98546,	47028.09277,	47032.20012,	47036.30750,	47040.41491,	47044.52236,	47048.62984,	47052.73736,	47056.84491,
47060.95249,	47065.06011,	47069.16776,	47073.27544,	47077.38316,	47081.49091,	47085.59870,	47089.70652,	47093.81437,	47097.92226,
47102.03018,	47106.13814,	47110.24613,	47114.35415,	47118.46221,	47122.57030,	47126.67843,	47130.78659,	47134.89478,	47139.00300,
47143.11127,	47147.21956,	47151.32789,	47155.43625,	47159.54465,	47163.65308,	47167.76154,	47171.87004,	47175.97857,	47180.08713,
47184.19573,	47188.30436,	47192.41303,	47196.52173,	47200.63046,	47204.73923,	47208.84803,	47212.95687,	47217.06574,	47221.17464,
47225.28358,	47229.39255,	47233.50155,	47237.61059,	47241.71966,	47245.82877,	47249.93791,	47254.04708,	47258.15629,	47262.26553,
47266.37481,	47270.48412,	47274.59346,	47278.70283,	47282.81224,	47286.92169,	47291.03116,	47295.14068,	47299.25022,	47303.35980,
47307.46941,	47311.57906,	47315.68874,	47319.79845,	47323.90820,	47328.01798,	47332.12779,	47336.23764,	47340.34752,	47344.45744,
47348.56739,	47352.67737,	47356.78739,	47360.89744,	47365.00752,	47369.11764,	47373.22779,	47377.33798,	47381.44820,	47385.55845,
47389.66874,	47393.77906,	47397.88941,	47401.99980,	47406.11022,	47410.22068,	47414.33117,	47418.44169,	47422.55224,	47426.66283,
47430.77346,	47434.88411,	47438.99481,	47443.10553,	47447.21629,	47451.32708,	47455.43790,	47459.54876,	47463.65966,	47467.77058,
47471.88154,	47475.99254,	47480.10356,	47484.21462,	47488.32572,	47492.43685,	47496.54801,	47500.65920,	47504.77043,	47508.88169,
47512.99299,	47517.10432,	47521.21568,	47525.32708,	47529.43851,	47533.54998,	47537.66147,	47541.77300,	47545.88457,	47549.99617,
47554.10780,	47558.21947,	47562.33116,	47566.44290,	47570.55466,	47574.66646,	47578.77830,	47582.89016,	47587.00207,	47591.11400,
47595.22597,	47599.33797,	47603.45000,	47607.56207,	47611.67417,	47615.78631,	47619.89848,	47624.01068,	47628.12292,	47632.23519,
47636.34749,	47640.45983,	47644.57220,	47648.68460,	47652.79704,	47656.90951,	47661.02202,	47665.13455,	47669.24712,	47673.35973,
47677.47237,	47681.58504,	47685.69775,	47689.81048,	47693.92326,	47698.03606,	47702.14890,	47706.26178,	47710.37468,	47714.48762,
47718.60060,	47722.71360,	47726.82664,	47730.93972,	47735.05282,	47739.16597,	47743.27914,	47747.39235,	47751.50559,	47755.61886,
47759.73217,	47763.84551,	47767.95889,	47772.07230,	47776.18574,	47780.29921,	47784.41272,	47788.52626,	47792.63984,	47796.75345,
47800.86709,	47804.98077,	47809.09448,	47813.20822,	47817.32200,	47821.43581,	47825.54965,	47829.66353,	47833.77744,	47837.89138,
47842.00536,	47846.11937,	47850.23341,	47854.34749,	47858.46160,	47862.57574,	47866.68992,	47870.80413,	47874.91837,	47879.03265,
47883.14696,	47887.26130,	47891.37568,	47895.49009,	47899.60454,	47903.71901,	47907.83353,	47911.94807,	47916.06265,	47920.17726,
47924.29190,	47928.40658,	47932.52129,	47936.63604,	47940.75081,	47944.86562,	47948.98047,	47953.09535,	47957.21026,	47961.32520,
47965.44018,	47969.55519,	47973.67024,	47977.78531,	47981.90042,	47986.01557,	47990.13075,	47994.24596,	47998.36120,	48002.47648,
48006.59179,	48010.70713,	48014.82251,	48018.93792,	48023.05337,	48027.16884,	48031.28435,	48035.39990,	48039.51548,	48043.63109,
48047.74673,	48051.86241,	48055.97812,	48060.09386,	48064.20964,	48068.32545,	48072.44129,	48076.55717,	48080.67308,	48084.78902,
48088.90500,	48093.02101,	48097.13705,	48101.25313,	48105.36924,	48109.48538,	48113.60155,	48117.71776,	48121.83401,	48125.95028,
48130.06659,	48134.18293,	48138.29931,	48142.41572,	48146.53216,	48150.64863,	48154.76514,	48158.88168,	48162.99826,	48167.11486,
48171.23151,	48175.34818,	48179.46489,	48183.58163,	48187.69840,	48191.81521,	48195.93205,	48200.04892,	48204.16583,	48208.28277,
48212.39974,	48216.51675,	48220.63379,	48224.75086,	48228.86796,	48232.98510,	48237.10227,	48241.21948,	48245.33672,	48249.45399,
48253.57129,	48257.68863,	48261.80600,	48265.92341,	48270.04084,	48274.15831,	48278.27582,	48282.39335,	48286.51092,	48290.62852,
48294.74616,	48298.86383,	48302.98153,	48307.09927,	48311.21703,	48315.33484,	48319.45267,	48323.57054,	48327.68844,	48331.80637,
48335.92434,	48340.04234,	48344.16037,	48348.27844,	48352.39654,	48356.51467,	48360.63284,	48364.75103,	48368.86927,	48372.98753,
48377.10583,	48381.22416,	48385.34252,	48389.46092,	48393.57935,	48397.69781,	48401.81631,	48405.93484,	48410.05340,	48414.17200,
48418.29063,	48422.40929,	48426.52798,	48430.64671,	48434.76547,	48438.88426,	48443.00309,	48447.12195,	48451.24084,	48455.35977,
48459.47873,	48463.59772,	48467.71674,	48471.83580,	48475.95489,	48480.07402,	48484.19317,	48488.31236,	48492.43159,	48496.55084,
48500.67013,	48504.78945,	48508.90881,	48513.02820,	48517.14762,	48521.26707,	48525.38656,	48529.50608,	48533.62563,	48537.74522,
48541.86483,	48545.98449,	48550.10417,	48554.22389,	48558.34364,	48562.46342,	48566.58324,	48570.70309,	48574.82297,	48578.94289,
48583.06283,	48587.18282,	48591.30283,	48595.42288,	48599.54296,	48603.66307,	48607.78322,	48611.90340,	48616.02361,	48620.14385,
48624.26413,	48628.38444,	48632.50478,	48636.62516,	48640.74557,	48644.86601,	48648.98649,	48653.10700,	48657.22754,	48661.34811,
48665.46872,	48669.58936,	48673.71003,	48677.83074,	48681.95147,	48686.07224,	48690.19305,	48694.31389,	48698.43476,	48702.55566,
48706.67659,	48710.79756,	48714.91856,	48719.03960,	48723.16067,	48727.28177,	48731.40290,	48735.52406,	48739.64526,	48743.76649,
48747.88776,	48752.00906,	48756.13039,	48760.25175,	48764.37314,	48768.49457,	48772.61603,	48776.73753,	48780.85906,	48784.98062,
48789.10221,	48793.22383,	48797.34549,	48801.46718,	48805.58891,	48809.71066,	48813.83245,	48817.95428,	48822.07613,	48826.19802,
48830.31994,	48834.44189,	48838.56388,	48842.68590,	48846.80795,	48850.93004,	48855.05215,	48859.17430,	48863.29649,	48867.41870,
48871.54095,	48875.66323,	48879.78555,	48883.90789,	48888.03027,	48892.15269,	48896.27513,	48900.39761,	48904.52012,	48908.64266,
48912.76524,	48916.88785,	48921.01049,	48925.13317,	48929.25587,	48933.37861,	48937.50139,	48941.62419,	48945.74703,	48949.86990,
48953.99280,	48958.11574,	48962.23871,	48966.36171,	48970.48475,	48974.60781,	48978.73091,	48982.85405,	48986.97721,	48991.10041,
48995.22364,	48999.34690,	49003.47020,	49007.59353,	49011.71689,	49015.84028,	49019.96371,	49024.08717,	49028.21066,	49032.33419,
49036.45775,	49040.58134,	49044.70496,	49048.82861,	49052.95230,	49057.07602,	49061.19978,	49065.32356,	49069.44738,	49073.57123,
49077.69512,	49081.81904,	49085.94298,	49090.06697,	49094.19098,	49098.31503,	49102.43911,	49106.56322,	49110.68737,	49114.81155,
49118.93576,	49123.06000,	49127.18428,	49131.30858,	49135.43293,	49139.55730,	49143.68171,	49147.80614,	49151.93062,	49156.05512,
49160.17966,	49164.30423,	49168.42883,	49172.55346,	49176.67813,	49180.80283,	49184.92756,	49189.05233,	49193.17713,	49197.30196,
49201.42682,	49205.55171,	49209.67664,	49213.80160,	49217.92660,	49222.05162,	49226.17668,	49230.30177,	49234.42689,	49238.55205,
49242.67724,	49246.80246,	49250.92771,	49255.05300,	49259.17832,	49263.30367,	49267.42905,	49271.55447,	49275.67992,	49279.80540,
49283.93091,	49288.05646,	49292.18204,	49296.30765,	49300.43329,	49304.55897,	49308.68468,	49312.81042,	49316.93619,	49321.06200,
49325.18784,	49329.31371,	49333.43961,	49337.56555,	49341.69152,	49345.81752,	49349.94355,	49354.06962,	49358.19572,	49362.32185,
49366.44801,	49370.57421,	49374.70044,	49378.82670,	49382.95299,	49387.07932,	49391.20568,	49395.33207,	49399.45849,	49403.58495,
49407.71144,	49411.83796,	49415.96451,	49420.09110,	49424.21772,	49428.34437,	49432.47105,	49436.59777,	49440.72452,	49444.85130,
49448.97811,	49453.10495,	49457.23183,	49461.35874,	49465.48569,	49469.61266,	49473.73967,	49477.86671,	49481.99378,	49486.12089,
49490.24802,	49494.37519,	49498.50239,	49502.62963,	49506.75690,	49510.88419,	49515.01153,	49519.13889,	49523.26629,	49527.39372,
49531.52118,	49535.64867,	49539.77620,	49543.90375,	49548.03135,	49552.15897,	49556.28662,	49560.41431,	49564.54203,	49568.66978,
49572.79757,	49576.92539,	49581.05324,	49585.18112,	49589.30903,	49593.43698,	49597.56496,	49601.69297,	49605.82101,	49609.94909,
49614.07720,	49618.20534,	49622.33351,	49626.46172,	49630.58995,	49634.71822,	49638.84653,	49642.97486,	49647.10323,	49651.23163,
49655.36006,	49659.48852,	49663.61702,	49667.74555,	49671.87411,	49676.00270,	49680.13133,	49684.25998,	49688.38867,	49692.51740,
49696.64615,	49700.77494,	49704.90376,	49709.03261,	49713.16149,	49717.29041,	49721.41936,	49725.54834,	49729.67735,	49733.80639,
49737.93547,	49742.06458,	49746.19372,	49750.32290,	49754.45210,	49758.58134,	49762.71061,	49766.83992,	49770.96925,	49775.09862,
49779.22802,	49783.35745,	49787.48692,	49791.61641,	49795.74594,	49799.87550,	49804.00510,	49808.13472,	49812.26438,	49816.39407,
49820.52379,	49824.65354,	49828.78333,	49832.91315,	49837.04300,	49841.17288,	49845.30280,	49849.43275,	49853.56273,	49857.69274,
49861.82278,	49865.95286,	49870.08297,	49874.21311,	49878.34328,	49882.47349,	49886.60372,	49890.73399,	49894.86429,	49898.99463,
49903.12499,	49907.25539,	49911.38582,	49915.51629,	49919.64678,	49923.77731,	49927.90787,	49932.03846,	49936.16908,	49940.29974,
49944.43042,	49948.56114,	49952.69189,	49956.82268,	49960.95349,	49965.08434,	49969.21522,	49973.34613,	49977.47708,	49981.60806,
49985.73906,	49989.87011,	49994.00118,	49998.13228,	50002.26342,	50006.39459,	50010.52579,	50014.65703,	50018.78829,	50022.91959,
50027.05092,	50031.18228,	50035.31368,	50039.44510,	50043.57656,	50047.70805,	50051.83957,	50055.97113,	50060.10271,	50064.23433,
50068.36598,	50072.49767,	50076.62938,	50080.76113,	50084.89291,	50089.02472,	50093.15656,	50097.28844,	50101.42034,	50105.55228,
50109.68425,	50113.81626,	50117.94829,	50122.08036,	50126.21246,	50130.34459,	50134.47675,	50138.60895,	50142.74118,	50146.87344,
50151.00573,	50155.13805,	50159.27041,	50163.40280,	50167.53522,	50171.66767,	50175.80015,	50179.93267,	50184.06522,	50188.19780,
50192.33041,	50196.46305,	50200.59573,	50204.72844,	50208.86118,	50212.99395,	50217.12675,	50221.25959,	50225.39245,	50229.52535,
50233.65829,	50237.79125,	50241.92425,	50246.05727,	50250.19033,	50254.32342,	50258.45655,	50262.58970,	50266.72289,	50270.85611,
50274.98936,	50279.12265,	50283.25596,	50287.38931,	50291.52269,	50295.65610,	50299.78954,	50303.92302,	50308.05652,	50312.19006,
50316.32363,	50320.45724,	50324.59087,	50328.72454,	50332.85824,	50336.99197,	50341.12573,	50345.25952,	50349.39335,	50353.52721,
50357.66110,	50361.79502,	50365.92897,	50370.06296,	50374.19698,	50378.33103,	50382.46511,	50386.59922,	50390.73337,	50394.86754,
50399.00175,	50403.13599,	50407.27027,	50411.40457,	50415.53891,	50419.67327,	50423.80768,	50427.94211,	50432.07657,	50436.21107,
50440.34559,	50444.48015,	50448.61475,	50452.74937,	50456.88402,	50461.01871,	50465.15343,	50469.28818,	50473.42296,	50477.55778,
50481.69262,	50485.82750,	50489.96241,	50494.09735,	50498.23233,	50502.36733,	50506.50237,	50510.63744,	50514.77254,	50518.90767,
50523.04284,	50527.17803,	50531.31326,	50535.44852,	50539.58381,	50543.71914,	50547.85449,	50551.98988,	50556.12530,	50560.26075,
50564.39623,	50568.53174,	50572.66729,	50576.80287,	50580.93848,	50585.07412,	50589.20979,	50593.34550,	50597.48123,	50601.61700,
50605.75280,	50609.88864,	50614.02450,	50618.16040,	50622.29632,	50626.43228,	50630.56827,	50634.70429,	50638.84035,	50642.97644,
50647.11255,	50651.24870,	50655.38488,	50659.52110,	50663.65734,	50667.79362,	50671.92993,	50676.06627,	50680.20264,	50684.33904,
50688.47548,	50692.61194,	50696.74844,	50700.88497,	50705.02154,	50709.15813,	50713.29475,	50717.43141,	50721.56810,	50725.70482,
50729.84157,	50733.97836,	50738.11517,	50742.25202,	50746.38890,	50750.52581,	50754.66275,	50758.79973,	50762.93673,	50767.07377,
50771.21084,	50775.34794,	50779.48507,	50783.62224,	50787.75943,	50791.89666,	50796.03392,	50800.17121,	50804.30853,	50808.44589,
50812.58327,	50816.72069,	50820.85814,	50824.99562,	50829.13313,	50833.27068,	50837.40825,	50841.54586,	50845.68350,	50849.82117,
50853.95887,	50858.09660,	50862.23437,	50866.37217,	50870.50999,	50874.64785,	50878.78575,	50882.92367,	50887.06163,	50891.19961,
50895.33763,	50899.47568,	50903.61376,	50907.75188,	50911.89002,	50916.02820,	50920.16640,	50924.30464,	50928.44291,	50932.58122,
50936.71955,	50940.85792,	50944.99632,	50949.13474,	50953.27320,	50957.41170,	50961.55022,	50965.68878,	50969.82736,	50973.96598,
50978.10463,	50982.24331,	50986.38203,	50990.52077,	50994.65955,	50998.79835,	51002.93719,	51007.07606,	51011.21497,	51015.35390,
51019.49287,	51023.63186,	51027.77089,	51031.90995,	51036.04904,	51040.18817,	51044.32732,	51048.46651,	51052.60573,	51056.74497,
51060.88426,	51065.02357,	51069.16291,	51073.30229,	51077.44169,	51081.58113,	51085.72060,	51089.86010,	51093.99964,	51098.13920,
51102.27880,	51106.41842,	51110.55808,	51114.69777,	51118.83749,	51122.97725,	51127.11703,	51131.25685,	51135.39670,	51139.53657,
51143.67648,	51147.81643,	51151.95640,	51156.09641,	51160.23644,	51164.37651,	51168.51661,	51172.65674,	51176.79690,	51180.93710,
51185.07732,	51189.21758,	51193.35787,	51197.49818,	51201.63854,	51205.77892,	51209.91933,	51214.05978,	51218.20025,	51222.34076,
51226.48130,	51230.62187,	51234.76247,	51238.90311,	51243.04377,	51247.18447,	51251.32520,	51255.46596,	51259.60675,	51263.74757,
51267.88842,	51272.02931,	51276.17022,	51280.31117,	51284.45215,	51288.59316,	51292.73420,	51296.87528,	51301.01638,	51305.15752,
51309.29869,	51313.43988,	51317.58111,	51321.72238,	51325.86367,	51330.00499,	51334.14635,	51338.28774,	51342.42915,	51346.57060,
51350.71209,	51354.85360,	51358.99514,	51363.13672,	51367.27832,	51371.41996,	51375.56163,	51379.70333,	51383.84506,	51387.98683,
51392.12862,	51396.27045,	51400.41230,	51404.55419,	51408.69611,	51412.83806,	51416.98005,	51421.12206,	51425.26411,	51429.40618,
51433.54829,	51437.69043,	51441.83260,	51445.97480,	51450.11703,	51454.25930,	51458.40159,	51462.54392,	51466.68628,	51470.82867,
51474.97109,	51479.11354,	51483.25602,	51487.39854,	51491.54108,	51495.68366,	51499.82627,	51503.96891,	51508.11158,	51512.25428,
51516.39702,	51520.53978,	51524.68258,	51528.82540,	51532.96826,	51537.11115,	51541.25407,	51545.39703,	51549.54001,	51553.68303,
51557.82607,	51561.96915,	51566.11226,	51570.25540,	51574.39857,	51578.54177,	51582.68500,	51586.82827,	51590.97156,	51595.11489,
51599.25825,	51603.40164,	51607.54506,	51611.68851,	51615.83199,	51619.97551,	51624.11905,	51628.26263,	51632.40624,	51636.54988,
51640.69355,	51644.83725,	51648.98098,	51653.12475,	51657.26854,	51661.41237,	51665.55623,	51669.70012,	51673.84404,	51677.98799,
51682.13197,	51686.27598,	51690.42003,	51694.56410,	51698.70821,	51702.85235,	51706.99652,	51711.14072,	51715.28495,	51719.42921,
51723.57351,	51727.71783,	51731.86219,	51736.00658,	51740.15099,	51744.29544,	51748.43992,	51752.58444,	51756.72898,	51760.87355,
51765.01816,	51769.16280,	51773.30746,	51777.45216,	51781.59689,	51785.74165,	51789.88644,	51794.03127,	51798.17612,	51802.32101,
51806.46592,	51810.61087,	51814.75585,	51818.90086,	51823.04590,	51827.19097,	51831.33608,	51835.48121,	51839.62638,	51843.77157,
51847.91680,	51852.06206,	51856.20735,	51860.35267,	51864.49802,	51868.64340,	51872.78882,	51876.93426,	51881.07974,	51885.22525,
51889.37078,	51893.51635,	51897.66195,	51901.80758,	51905.95325,	51910.09894,	51914.24467,	51918.39042,	51922.53621,	51926.68203,
51930.82787,	51934.97375,	51939.11966,	51943.26561,	51947.41158,	51951.55758,	51955.70362,	51959.84968,	51963.99578,	51968.14191,
51972.28807,	51976.43426,	51980.58048,	51984.72673,	51988.87301,	51993.01933,	51997.16567,	52001.31205,	52005.45846,	52009.60490,
52013.75136,	52017.89786,	52022.04440,	52026.19096,	52030.33755,	52034.48418,	52038.63083,	52042.77752,	52046.92423,	52051.07098,
52055.21776,	52059.36457,	52063.51141,	52067.65828,	52071.80519,	52075.95212,	52080.09908,	52084.24608,	52088.39311,	52092.54016,
52096.68725,	52100.83437,	52104.98152,	52109.12870,	52113.27592,	52117.42316,	52121.57044,	52125.71774,	52129.86508,	52134.01244,
52138.15984,	52142.30727,	52146.45473,	52150.60222,	52154.74974,	52158.89730,	52163.04488,	52167.19249,	52171.34014,	52175.48782,
52179.63552,	52183.78326,	52187.93103,	52192.07883,	52196.22666,	52200.37452,	52204.52242,	52208.67034,	52212.81829,	52216.96628,
52221.11429,	52225.26234,	52229.41042,	52233.55853,	52237.70667,	52241.85484,	52246.00304,	52250.15127,	52254.29954,	52258.44783,
52262.59616,	52266.74451,	52270.89290,	52275.04132,	52279.18976,	52283.33824,	52287.48675,	52291.63529,	52295.78387,	52299.93247,
52304.08110,	52308.22977,	52312.37846,	52316.52719,	52320.67594,	52324.82473,	52328.97355,	52333.12240,	52337.27128,	52341.42019,
52345.56913,	52349.71811,	52353.86711,	52358.01614,	52362.16521,	52366.31430,	52370.46343,	52374.61259,	52378.76178,	52382.91100,
52387.06025,	52391.20953,	52395.35884,	52399.50818,	52403.65755,	52407.80696,	52411.95639,	52416.10586,	52420.25535,	52424.40488,
52428.55444,	52432.70403,	52436.85365,	52441.00330,	52445.15298,	52449.30269,	52453.45243,	52457.60220,	52461.75201,	52465.90184,
52470.05171,	52474.20160,	52478.35153,	52482.50149,	52486.65148,	52490.80150,	52494.95155,	52499.10163,	52503.25174,	52507.40188,
52511.55205,	52515.70226,	52519.85249,	52524.00276,	52528.15305,	52532.30338,	52536.45374,	52540.60412,	52544.75454,	52548.90499,
52553.05547,	52557.20598,	52561.35653,	52565.50710,	52569.65770,	52573.80833,	52577.95900,	52582.10969,	52586.26042,	52590.41118,
52594.56196,	52598.71278,	52602.86363,	52607.01451,	52611.16542,	52615.31636,	52619.46733,	52623.61833,	52627.76936,	52631.92043,
52636.07152,	52640.22265,	52644.37380,	52648.52499,	52652.67620,	52656.82745,	52660.97873,	52665.13004,	52669.28138,	52673.43275,
52677.58415,	52681.73558,	52685.88704,	52690.03853,	52694.19006,	52698.34161,	52702.49319,	52706.64481,	52710.79645,	52714.94813,
52719.09984,	52723.25157,	52727.40334,	52731.55514,	52735.70697,	52739.85883,	52744.01072,	52748.16264,	52752.31459,	52756.46658,
52760.61859,	52764.77063,	52768.92271,	52773.07481,	52777.22695,	52781.37911,	52785.53131,	52789.68354,	52793.83580,	52797.98808,
52802.14040,	52806.29275,	52810.44513,	52814.59754,	52818.74998,	52822.90246,	52827.05496,	52831.20749,	52835.36005,	52839.51265,
52843.66527,	52847.81793,	52851.97061,	52856.12333,	52860.27608,	52864.42886,	52868.58166,	52872.73450,	52876.88737,	52881.04027,
52885.19320,	52889.34616,	52893.49915,	52897.65217,	52901.80523,	52905.95831,	52910.11142,	52914.26457,	52918.41774,	52922.57095,
52926.72418,	52930.87745,	52935.03074,	52939.18407,	52943.33743,	52947.49082,	52951.64423,	52955.79768,	52959.95116,	52964.10467,
52968.25821,	52972.41178,	52976.56539,	52980.71902,	52984.87268,	52989.02637,	52993.18010,	52997.33385,	53001.48763,	53005.64145,
53009.79530,	53013.94917,	53018.10308,	53022.25701,	53026.41098,	53030.56498,	53034.71901,	53038.87307,	53043.02715,	53047.18127,
53051.33542,	53055.48960,	53059.64382,	53063.79806,	53067.95233,	53072.10663,	53076.26096,	53080.41533,	53084.56972,	53088.72414,
53092.87860,	53097.03308,	53101.18760,	53105.34214,	53109.49672,	53113.65133,	53117.80596,	53121.96063,	53126.11533,	53130.27006,
53134.42482,	53138.57960,	53142.73442,	53146.88927,	53151.04415,	53155.19907,	53159.35401,	53163.50898,	53167.66398,	53171.81901,
53175.97407,	53180.12917,	53184.28429,	53188.43944,	53192.59463,	53196.74984,	53200.90509,	53205.06036,	53209.21567,	53213.37101,
53217.52637,	53221.68177,	53225.83720,	53229.99265,	53234.14814,	53238.30366,	53242.45921,	53246.61479,	53250.77040,	53254.92604,
53259.08171,	53263.23741,	53267.39314,	53271.54890,	53275.70469,	53279.86051,	53284.01636,	53288.17224,	53292.32816,	53296.48410,
53300.64007,	53304.79608,	53308.95211,	53313.10818,	53317.26427,	53321.42040,	53325.57655,	53329.73274,	53333.88895,	53338.04520,
53342.20147,	53346.35778,	53350.51412,	53354.67049,	53358.82688,	53362.98331,	53367.13977,	53371.29626,	53375.45278,	53379.60933,
53383.76591,	53387.92252,	53392.07916,	53396.23583,	53400.39253,	53404.54926,	53408.70602,	53412.86281,	53417.01963,	53421.17648,
53425.33337,	53429.49028,	53433.64722,	53437.80419,	53441.96120,	53446.11823,	53450.27529,	53454.43239,	53458.58951,	53462.74667,
53466.90385,	53471.06107,	53475.21831,	53479.37559,	53483.53289,	53487.69023,	53491.84759,	53496.00499,	53500.16242,	53504.31987,
53508.47736,	53512.63488,	53516.79243,	53520.95000,	53525.10761,	53529.26525,	53533.42292,	53537.58062,	53541.73834,	53545.89610,
53550.05389,	53554.21171,	53558.36956,	53562.52744,	53566.68535,	53570.84329,	53575.00126,	53579.15926,	53583.31729,	53587.47535,
53591.63344,	53595.79157,	53599.94972,	53604.10790,	53608.26611,	53612.42435,	53616.58262,	53620.74093,	53624.89926,	53629.05762,
53633.21601,	53637.37444,	53641.53289,	53645.69137,	53649.84989,	53654.00843,	53658.16700,	53662.32561,	53666.48424,	53670.64290,
53674.80160,	53678.96032,	53683.11908,	53687.27786,	53691.43668,	53695.59552,	53699.75440,	53703.91330,	53708.07224,	53712.23120,
53716.39020,	53720.54922,	53724.70828,	53728.86736,	53733.02648,	53737.18562,	53741.34480,	53745.50401,	53749.66324,	53753.82251,
53757.98181,	53762.14113,	53766.30049,	53770.45988,	53774.61929,	53778.77874,	53782.93822,	53787.09772,	53791.25726,	53795.41683,
53799.57642,	53803.73605,	53807.89571,	53812.05540,	53816.21511,	53820.37486,	53824.53464,	53828.69445,	53832.85429,	53837.01415,
53841.17405,	53845.33398,	53849.49394,	53853.65393,	53857.81394,	53861.97399,	53866.13407,	53870.29418,	53874.45432,	53878.61448,
53882.77468,	53886.93491,	53891.09517,	53895.25546,	53899.41578,	53903.57612,	53907.73650,	53911.89691,	53916.05735,	53920.21782,
53924.37832,	53928.53885,	53932.69940,	53936.85999,	53941.02061,	53945.18126,	53949.34194,	53953.50265,	53957.66339,	53961.82415,
53965.98495,	53970.14578,	53974.30664,	53978.46753,	53982.62845,	53986.78940,	53990.95037,	53995.11138,	53999.27242,	54003.43349,
54007.59459,	54011.75572,	54015.91687,	54020.07806,	54024.23928,	54028.40053,	54032.56181,	54036.72312,	54040.88445,	54045.04582,
54049.20722,	54053.36865,	54057.53010,	54061.69159,	54065.85311,	54070.01466,	54074.17624,	54078.33784,	54082.49948,	54086.66115,
54090.82285,	54094.98457,	54099.14633,	54103.30812,	54107.46993,	54111.63178,	54115.79366,	54119.95556,	54124.11750,	54128.27947,
54132.44146,	54136.60349,	54140.76555,	54144.92763,	54149.08975,	54153.25190,	54157.41407,	54161.57628,	54165.73851,	54169.90078,
54174.06307,	54178.22540,	54182.38776,	54186.55014,	54190.71256,	54194.87500,	54199.03747,	54203.19998,	54207.36251,	54211.52508,
54215.68767,	54219.85030,	54224.01295,	54228.17563,	54232.33835,	54236.50109,	54240.66387,	54244.82667,	54248.98950,	54253.15237,
54257.31526,	54261.47818,	54265.64113,	54269.80412,	54273.96713,	54278.13017,	54282.29324,	54286.45634,	54290.61947,	54294.78264,
54298.94583,	54303.10905,	54307.27230,	54311.43558,	54315.59889,	54319.76223,	54323.92560,	54328.08900,	54332.25243,	54336.41589,
54340.57938,	54344.74290,	54348.90645,	54353.07003,	54357.23363,	54361.39727,	54365.56094,	54369.72464,	54373.88837,	54378.05212,
54382.21591,	54386.37973,	54390.54358,	54394.70745,	54398.87136,	54403.03530,	54407.19926,	54411.36326,	54415.52728,	54419.69134,
54423.85542,	54428.01954,	54432.18368,	54436.34786,	54440.51206,	54444.67629,	54448.84056,	54453.00485,	54457.16917,	54461.33353,
54465.49791,	54469.66232,	54473.82676,	54477.99124,	54482.15574,	54486.32027,	54490.48483,	54494.64942,	54498.81404,	54502.97869,
54507.14337,	54511.30808,	54515.47282,	54519.63759,	54523.80239,	54527.96722,	54532.13208,	54536.29696,	54540.46188,	54544.62683,
54548.79181,	54552.95681,	54557.12185,	54561.28691,	54565.45201,	54569.61714,	54573.78229,	54577.94748,	54582.11269,	54586.27794,
54590.44321,	54594.60851,	54598.77385,	54602.93921,	54607.10460,	54611.27002,	54615.43548,	54619.60096,	54623.76647,	54627.93201,
54632.09758,	54636.26318,	54640.42881,	54644.59447,	54648.76016,	54652.92588,	54657.09163,	54661.25741,	54665.42322,	54669.58905,
54673.75492,	54677.92082,	54682.08674,	54686.25270,	54690.41869,	54694.58470,	54698.75075,	54702.91682,	54707.08293,	54711.24906,
54715.41522,	54719.58142,	54723.74764,	54727.91389,	54732.08017,	54736.24649,	54740.41283,	54744.57920,	54748.74560,	54752.91203,
54757.07849,	54761.24498,	54765.41150,	54769.57804,	54773.74462,	54777.91123,	54782.07787,	54786.24453,	54790.41123,	54794.57796,
54798.74471,	54802.91150,	54807.07831,	54811.24516,	54815.41203,	54819.57893,	54823.74587,	54827.91283,	54832.07982,	54836.24684,
54840.41390,	54844.58098,	54848.74809,	54852.91523,	54857.08240,	54861.24960,	54865.41682,	54869.58408,	54873.75137,	54877.91869,
54882.08603,	54886.25341,	54890.42082,	54894.58825,	54898.75572,	54902.92321,	54907.09074,	54911.25829,	54915.42587,	54919.59349,
54923.76113,	54927.92880,	54932.09650,	54936.26423,	54940.43199,	54944.59978,	54948.76760,	54952.93545,	54957.10333,	54961.27124,
54965.43917,	54969.60714,	54973.77514,	54977.94316,	54982.11122,	54986.27930,	54990.44742,	54994.61556,	54998.78373,	55002.95194,
55007.12017,	55011.28843,	55015.45672,	55019.62504,	55023.79339,	55027.96177,	55032.13018,	55036.29862,	55040.46709,	55044.63559,
55048.80411,	55052.97267,	55057.14125,	55061.30987,	55065.47851,	55069.64719,	55073.81589,	55077.98463,	55082.15339,	55086.32218,
55090.49100,	55094.65985,	55098.82873,	55102.99764,	55107.16658,	55111.33555,	55115.50455,	55119.67358,	55123.84263,	55128.01172,
55132.18083,	55136.34998,	55140.51915,	55144.68836,	55148.85759,	55153.02686,	55157.19615,	55161.36547,	55165.53482,	55169.70420,
55173.87361,	55178.04305,	55182.21252,	55186.38202,	55190.55154,	55194.72110,	55198.89069,	55203.06030,	55207.22995,	55211.39962,
55215.56933,	55219.73906,	55223.90882,	55228.07861,	55232.24844,	55236.41829,	55240.58817,	55244.75808,	55248.92801,	55253.09798,
55257.26798,	55261.43801,	55265.60806,	55269.77815,	55273.94826,	55278.11841,	55282.28858,	55286.45878,	55290.62902,	55294.79928,
55298.96957,	55303.13989,	55307.31024,	55311.48062,	55315.65103,	55319.82147,	55323.99193,	55328.16243,	55332.33295,	55336.50351,
55340.67409,	55344.84471,	55349.01535,	55353.18602,	55357.35672,	55361.52746,	55365.69822,	55369.86901,	55374.03982,	55378.21067,
55382.38155,	55386.55246,	55390.72339,	55394.89436,	55399.06535,	55403.23638,	55407.40743,	55411.57851,	55415.74962,	55419.92077,
55424.09194,	55428.26314,	55432.43437,	55436.60562,	55440.77691,	55444.94823,	55449.11957,	55453.29095,	55457.46235,	55461.63379,
55465.80525,	55469.97674,	55474.14827,	55478.31982,	55482.49140,	55486.66301,	55490.83464,	55495.00631,	55499.17801,	55503.34974,
55507.52149,	55511.69328,	55515.86509,	55520.03693,	55524.20881,	55528.38071,	55532.55264,	55536.72460,	55540.89659,	55545.06861,
55549.24066,	55553.41273,	55557.58484,	55561.75698,	55565.92914,	55570.10134,	55574.27356,	55578.44581,	55582.61809,	55586.79040,
55590.96274,	55595.13511,	55599.30751,	55603.47994,	55607.65240,	55611.82488,	55615.99740,	55620.16994,	55624.34252,	55628.51512,
55632.68775,	55636.86041,	55641.03310,	55645.20582,	55649.37857,	55653.55135,	55657.72416,	55661.89699,	55666.06986,	55670.24275,
55674.41568,	55678.58863,	55682.76161,	55686.93462,	55691.10766,	55695.28073,	55699.45383,	55703.62696,	55707.80012,	55711.97330,
55716.14652,	55720.31976,	55724.49304,	55728.66634,	55732.83967,	55737.01303,	55741.18642,	55745.35984,	55749.53329,	55753.70677,
55757.88028,	55762.05381,	55766.22738,	55770.40097,	55774.57459,	55778.74825,	55782.92193,	55787.09564,	55791.26938,	55795.44315,
55799.61695,	55803.79077,	55807.96463,	55812.13851,	55816.31243,	55820.48637,	55824.66034,	55828.83435,	55833.00838,	55837.18244,
55841.35653,	55845.53064,	55849.70479,	55853.87897,	55858.05317,	55862.22741,	55866.40167,	55870.57596,	55874.75028,	55878.92463,
55883.09901,	55887.27342,	55891.44786,	55895.62233,	55899.79682,	55903.97135,	55908.14590,	55912.32049,	55916.49510,	55920.66974,
55924.84441,	55929.01911,	55933.19384,	55937.36859,	55941.54338,	55945.71820,	55949.89304,	55954.06791,	55958.24282,	55962.41775,
55966.59271,	55970.76770,	55974.94272,	55979.11776,	55983.29284,	55987.46795,	55991.64308,	55995.81825,	55999.99344,	56004.16866,
56008.34391,	56012.51919,	56016.69450,	56020.86984,	56025.04520,	56029.22060,	56033.39603,	56037.57148,	56041.74696,	56045.92247,
56050.09801,	56054.27358,	56058.44918,	56062.62481,	56066.80047,	56070.97615,	56075.15187,	56079.32761,	56083.50338,	56087.67919,
56091.85502,	56096.03088,	56100.20676,	56104.38268,	56108.55863,	56112.73460,	56116.91061,	56121.08664,	56125.26270,	56129.43880,
56133.61492,	56137.79106,	56141.96724,	56146.14345,	56150.31969,	56154.49595,	56158.67224,	56162.84857,	56167.02492,	56171.20130,
56175.37771,	56179.55415,	56183.73062,	56187.90711,	56192.08364,	56196.26019,	56200.43677,	56204.61339,	56208.79003,	56212.96670,
56217.14340,	56221.32012,	56225.49688,	56229.67367,	56233.85048,	56238.02732,	56242.20420,	56246.38110,	56250.55803,	56254.73499,
56258.91197,	56263.08899,	56267.26604,	56271.44311,	56275.62022,	56279.79735,	56283.97451,	56288.15170,	56292.32892,	56296.50617,
56300.68344,	56304.86075,	56309.03808,	56313.21545,	56317.39284,	56321.57026,	56325.74771,	56329.92519,	56334.10270,	56338.28023,
56342.45780,	56346.63539,	56350.81301,	56354.99067,	56359.16835,	56363.34606,	56367.52380,	56371.70156,	56375.87936,	56380.05718,
56384.23504,	56388.41292,	56392.59083,	56396.76877,	56400.94674,	56405.12474,	56409.30277,	56413.48082,	56417.65891,	56421.83702,
56426.01516,	56430.19333,	56434.37153,	56438.54976,	56442.72802,	56446.90630,	56451.08462,	56455.26296,	56459.44133,	56463.61974,
56467.79817,	56471.97663,	56476.15511,	56480.33363,	56484.51217,	56488.69075,	56492.86935,	56497.04798,	56501.22664,	56505.40533,
56509.58405,	56513.76280,	56517.94157,	56522.12038,	56526.29921,	56530.47807,	56534.65696,	56538.83588,	56543.01483,	56547.19381,
56551.37281,	56555.55185,	56559.73091,	56563.91000,	56568.08912,	56572.26827,	56576.44745,	56580.62666,	56584.80589,	56588.98516,
56593.16445,	56597.34377,	56601.52312,	56605.70250,	56609.88191,	56614.06135,	56618.24082,	56622.42031,	56626.59983,	56630.77938,
56634.95896,	56639.13857,	56643.31821,	56647.49788,	56651.67757,	56655.85730,	56660.03705,	56664.21683,	56668.39664,	56672.57648,
56676.75635,	56680.93625,	56685.11617,	56689.29612,	56693.47611,	56697.65612,	56701.83616,	56706.01623,	56710.19632,	56714.37645,
56718.55660,	56722.73679,	56726.91700,	56731.09724,	56735.27751,	56739.45781,	56743.63813,	56747.81849,	56751.99887,	56756.17929,
56760.35973,	56764.54020,	56768.72070,	56772.90122,	56777.08178,	56781.26236,	56785.44298,	56789.62362,	56793.80429,	56797.98499,
56802.16572,	56806.34647,	56810.52726,	56814.70807,	56818.88891,	56823.06978,	56827.25068,	56831.43161,	56835.61257,	56839.79356,
56843.97457,	56848.15561,	56852.33668,	56856.51778,	56860.69891,	56864.88007,	56869.06126,	56873.24247,	56877.42371,	56881.60499,
56885.78629,	56889.96761,	56894.14897,	56898.33036,	56902.51177,	56906.69322,	56910.87469,	56915.05619,	56919.23772,	56923.41928,
56927.60086,	56931.78248,	56935.96412,	56940.14579,	56944.32749,	56948.50922,	56952.69098,	56956.87277,	56961.05458,	56965.23643,
56969.41830,	56973.60020,	56977.78213,	56981.96409,	56986.14607,	56990.32809,	56994.51013,	56998.69220,	57002.87430,	57007.05643,
57011.23859,	57015.42078,	57019.60299,	57023.78524,	57027.96751,	57032.14981,	57036.33214,	57040.51449,	57044.69688,	57048.87930,
57053.06174,	57057.24421,	57061.42671,	57065.60924,	57069.79180,	57073.97438,	57078.15700,	57082.33964,	57086.52231,	57090.70501,
57094.88774,	57099.07050,	57103.25328,	57107.43610,	57111.61894,	57115.80181,	57119.98471,	57124.16764,	57128.35059,	57132.53358,
57136.71659,	57140.89963,	57145.08270,	57149.26580,	57153.44893,	57157.63209,	57161.81527,	57165.99848,	57170.18172,	57174.36499,
57178.54829,	57182.73162,	57186.91497,	57191.09836,	57195.28177,	57199.46521,	57203.64868,	57207.83218,	57212.01570,	57216.19926,
57220.38284,	57224.56645,	57228.75009,	57232.93376,	57237.11746,	57241.30118,	57245.48494,	57249.66872,	57253.85253,	57258.03637,
57262.22024,	57266.40413,	57270.58806,	57274.77201,	57278.95599,	57283.14000,	57287.32404,	57291.50810,	57295.69220,	57299.87632,
57304.06048,	57308.24466,	57312.42886,	57316.61310,	57320.79737,	57324.98166,	57329.16598,	57333.35033,	57337.53471,	57341.71912,
57345.90356,	57350.08802,	57354.27251,	57358.45703,	57362.64158,	57366.82616,	57371.01077,	57375.19540,	57379.38006,	57383.56476,
57387.74948,	57391.93422,	57396.11900,	57400.30381,	57404.48864,	57408.67350,	57412.85839,	57417.04331,	57421.22826,	57425.41323,
57429.59824,	57433.78327,	57437.96833,	57442.15342,	57446.33853,	57450.52368,	57454.70885,	57458.89405,	57463.07928,	57467.26454,
57471.44983,	57475.63515,	57479.82049,	57484.00586,	57488.19126,	57492.37669,	57496.56215,	57500.74763,	57504.93315,	57509.11869,
57513.30426,	57517.48986,	57521.67549,	57525.86114,	57530.04683,	57534.23254,	57538.41828,	57542.60405,	57546.78984,	57550.97567,
57555.16152,	57559.34740,	57563.53331,	57567.71925,	57571.90522,	57576.09122,	57580.27724,	57584.46329,	57588.64937,	57592.83548,
57597.02162,	57601.20778,	57605.39397,	57609.58020,	57613.76645,	57617.95272,	57622.13903,	57626.32536,	57630.51173,	57634.69812,
57638.88454,	57643.07099,	57647.25746,	57651.44397,	57655.63050,	57659.81706,	57664.00365,	57668.19027,	57672.37691,	57676.56359,
57680.75029,	57684.93702,	57689.12378,	57693.31056,	57697.49738,	57701.68422,	57705.87109,	57710.05799,	57714.24492,	57718.43188,
57722.61886,	57726.80588,	57730.99292,	57735.17999,	57739.36708,	57743.55421,	57747.74136,	57751.92855,	57756.11576,	57760.30299,
57764.49026,	57768.67756,	57772.86488,	57777.05223,	57781.23961,	57785.42702,	57789.61445,	57793.80192,	57797.98941,	57802.17693,
57806.36448,	57810.55206,	57814.73966,	57818.92730,	57823.11496,	57827.30265,	57831.49037,	57835.67811,	57839.86589,	57844.05369,
57848.24152,	57852.42938,	57856.61727,	57860.80518,	57864.99313,	57869.18110,	57873.36910,	57877.55713,	57881.74518,	57885.93327,
57890.12138,	57894.30952,	57898.49769,	57902.68589,	57906.87411,	57911.06236,	57915.25065,	57919.43895,	57923.62729,	57927.81566,
57932.00405,	57936.19247,	57940.38093,	57944.56940,	57948.75791,	57952.94645,	57957.13501,	57961.32360,	57965.51222,	57969.70087,
57973.88954,	57978.07824,	57982.26698,	57986.45574,	57990.64452,	57994.83334,	57999.02218,	58003.21106,	58007.39996,	58011.58889,
58015.77784,	58019.96683,	58024.15584,	58028.34488,	58032.53395,	58036.72305,	58040.91217,	58045.10132,	58049.29051,	58053.47972,
58057.66895,	58061.85822,	58066.04751,	58070.23683,	58074.42618,	58078.61556,	58082.80497,	58086.99440,	58091.18387,	58095.37336,
58099.56287,	58103.75242,	58107.94199,	58112.13160,	58116.32123,	58120.51089,	58124.70057,	58128.89029,	58133.08003,	58137.26980,
58141.45960,	58145.64943,	58149.83928,	58154.02917,	58158.21908,	58162.40902,	58166.59898,	58170.78898,	58174.97900,	58179.16905,
58183.35913,	58187.54924,	58191.73938,	58195.92954,	58200.11973,	58204.30995,	58208.50020,	58212.69047,	58216.88078,	58221.07111,
58225.26147,	58229.45186,	58233.64227,	58237.83272,	58242.02319,	58246.21369,	58250.40422,	58254.59477,	58258.78536,	58262.97597,
58267.16661,	58271.35728,	58275.54797,	58279.73870,	58283.92945,	58288.12023,	58292.31103,	58296.50187,	58300.69273,	58304.88363,
58309.07455,	58313.26549,	58317.45647,	58321.64747,	58325.83850,	58330.02956,	58334.22065,	58338.41177,	58342.60291,	58346.79408,
58350.98528,	58355.17651,	58359.36776,	58363.55905,	58367.75036,	58371.94170,	58376.13306,	58380.32446,	58384.51588,	58388.70733,
58392.89881,	58397.09032,	58401.28185,	58405.47342,	58409.66501,	58413.85663,	58418.04827,	58422.23995,	58426.43165,	58430.62338,
58434.81514,	58439.00693,	58443.19874,	58447.39058,	58451.58245,	58455.77435,	58459.96628,	58464.15823,	58468.35021,	58472.54222,
58476.73426,	58480.92632,	58485.11842,	58489.31054,	58493.50269,	58497.69486,	58501.88707,	58506.07930,	58510.27156,	58514.46385,
58518.65617,	58522.84851,	58527.04088,	58531.23328,	58535.42571,	58539.61817,	58543.81065,	58548.00316,	58552.19570,	58556.38827,
58560.58087,	58564.77349,	58568.96614,	58573.15882,	58577.35153,	58581.54426,	58585.73702,	58589.92981,	58594.12263,	58598.31548,
58602.50835,	58606.70125,	58610.89418,	58615.08714,	58619.28013,	58623.47314,	58627.66618,	58631.85925,	58636.05235,	58640.24547,
58644.43862,	58648.63180,	58652.82501,	58657.01825,	58661.21151,	58665.40480,	58669.59812,	58673.79147,	58677.98485,	58682.17825,
58686.37168,	58690.56514,	58694.75862,	58698.95214,	58703.14568,	58707.33925,	58711.53285,	58715.72647,	58719.92013,	58724.11381,
58728.30752,	58732.50125,	58736.69502,	58740.88881,	58745.08263,	58749.27648,	58753.47035,	58757.66426,	58761.85819,	58766.05215,
58770.24613,	58774.44015,	58778.63419,	58782.82826,	58787.02236,	58791.21648,	58795.41064,	58799.60482,	58803.79903,	58807.99326,
58812.18753,	58816.38182,	58820.57614,	58824.77049,	58828.96486,	58833.15927,	58837.35370,	58841.54816,	58845.74264,	58849.93716,
58854.13170,	58858.32627,	58862.52087,	58866.71549,	58870.91015,	58875.10483,	58879.29954,	58883.49427,	58887.68904,	58891.88383,
58896.07865,	58900.27349,	58904.46837,	58908.66327,	58912.85820,	58917.05316,	58921.24815,	58925.44316,	58929.63820,	58933.83327,
58938.02837,	58942.22349,	58946.41864,	58950.61382,	58954.80903,	58959.00427,	58963.19953,	58967.39482,	58971.59014,	58975.78548,
58979.98086,	58984.17626,	58988.37169,	58992.56715,	58996.76263,	59000.95814,	59005.15368,	59009.34925,	59013.54484,	59017.74047,
59021.93612,	59026.13180,	59030.32750,	59034.52324,	59038.71900,	59042.91479,	59047.11060,	59051.30645,	59055.50232,	59059.69822,
59063.89415,	59068.09010,	59072.28608,	59076.48209,	59080.67813,	59084.87420,	59089.07029,	59093.26641,	59097.46256,	59101.65874,
59105.85494,	59110.05117,	59114.24743,	59118.44372,	59122.64003,	59126.83637,	59131.03274,	59135.22914,	59139.42557,	59143.62202,
59147.81850,	59152.01501,	59156.21154,	59160.40810,	59164.60470,	59168.80131,	59172.99796,	59177.19463,	59181.39133,	59185.58806,
59189.78482,	59193.98160,	59198.17841,	59202.37525,	59206.57212,	59210.76902,	59214.96594,	59219.16289,	59223.35986,	59227.55687,
59231.75390,	59235.95096,	59240.14805,	59244.34516,	59248.54231,	59252.73948,	59256.93667,	59261.13390,	59265.33115,	59269.52843,
59273.72574,	59277.92308,	59282.12044,	59286.31783,	59290.51525,	59294.71270,	59298.91017,	59303.10767,	59307.30520,	59311.50275,
59315.70034,	59319.89795,	59324.09559,	59328.29326,	59332.49095,	59336.68867,	59340.88642,	59345.08420,	59349.28200,	59353.47983,
59357.67769,	59361.87558,	59366.07349,	59370.27143,	59374.46940,	59378.66740,	59382.86543,	59387.06348,	59391.26156,	59395.45966,
59399.65780,	59403.85596,	59408.05415,	59412.25237,	59416.45061,	59420.64888,	59424.84718,	59429.04551,	59433.24386,	59437.44225,
59441.64066,	59445.83909,	59450.03756,	59454.23605,	59458.43457,	59462.63312,	59466.83169,	59471.03029,	59475.22892,	59479.42758,
59483.62627,	59487.82498,	59492.02372,	59496.22248,	59500.42128,	59504.62010,	59508.81895,	59513.01783,	59517.21673,	59521.41566,
59525.61462,	59529.81361,	59534.01262,	59538.21167,	59542.41073,	59546.60983,	59550.80896,	59555.00811,	59559.20729,	59563.40649,
59567.60573,	59571.80499,	59576.00428,	59580.20359,	59584.40294,	59588.60231,	59592.80171,	59597.00113,	59601.20059,	59605.40007,
59609.59957,	59613.79911,	59617.99867,	59622.19826,	59626.39788,	59630.59753,	59634.79720,	59638.99690,	59643.19663,	59647.39638,
59651.59617,	59655.79598,	59659.99581,	59664.19568,	59668.39557,	59672.59549,	59676.79544,	59680.99541,	59685.19541,	59689.39544,
59693.59550,	59697.79558,	59701.99570,	59706.19583,	59710.39600,	59714.59619,	59718.79642,	59722.99666,	59727.19694,	59731.39724,
59735.59757,	59739.79793,	59743.99832,	59748.19873,	59752.39917,	59756.59964,	59760.80013,	59765.00065,	59769.20120,	59773.40178,
59777.60238,	59781.80302,	59786.00368,	59790.20436,	59794.40508,	59798.60582,	59802.80659,	59807.00738,	59811.20820,	59815.40905,
59819.60993,	59823.81084,	59828.01177,	59832.21273,	59836.41372,	59840.61473,	59844.81577,	59849.01684,	59853.21794,	59857.41906,
59861.62021,	59865.82139,	59870.02260,	59874.22383,	59878.42509,	59882.62638,	59886.82770,	59891.02904,	59895.23041,	59899.43181,
59903.63323,	59907.83468,	59912.03616,	59916.23767,	59920.43920,	59924.64076,	59928.84235,	59933.04397,	59937.24561,	59941.44728,
59945.64898,	59949.85070,	59954.05245,	59958.25423,	59962.45604,	59966.65787,	59970.85973,	59975.06162,	59979.26354,	59983.46548,
59987.66745,	59991.86945,	59996.07147,	60000.27353,	60004.47561,	60008.67771,	60012.87985,	60017.08201,	60021.28420,	60025.48641,
60029.68865,	60033.89093,	60038.09322,	60042.29555,	60046.49790,	60050.70028,	60054.90269,	60059.10512,	60063.30758,	60067.51007,
60071.71258,	60075.91513,	60080.11770,	60084.32029,	60088.52292,	60092.72557,	60096.92825,	60101.13096,	60105.33369,	60109.53645,
60113.73924,	60117.94205,	60122.14490,	60126.34777,	60130.55066,	60134.75359,	60138.95654,	60143.15952,	60147.36252,	60151.56555,
60155.76861,	60159.97170,	60164.17482,	60168.37796,	60172.58113,	60176.78432,	60180.98755,	60185.19080,	60189.39407,	60193.59738,
60197.80071,	60202.00407,	60206.20746,	60210.41087,	60214.61431,	60218.81778,	60223.02128,	60227.22480,	60231.42835,	60235.63192,
60239.83553,	60244.03916,	60248.24282,	60252.44650,	60256.65022,	60260.85396,	60265.05772,	60269.26152,	60273.46534,	60277.66919,
60281.87306,	60286.07696,	60290.28089,	60294.48485,	60298.68884,	60302.89285,	60307.09689,	60311.30095,	60315.50504,	60319.70916,
60323.91331,	60328.11749,	60332.32169,	60336.52592,	60340.73017,	60344.93445,	60349.13876,	60353.34310,	60357.54747,	60361.75186,
60365.95628,	60370.16072,	60374.36519,	60378.56969,	60382.77422,	60386.97877,	60391.18336,	60395.38796,	60399.59260,	60403.79726,
60408.00195,	60412.20667,	60416.41141,	60420.61618,	60424.82098,	60429.02581,	60433.23066,	60437.43554,	60441.64044,	60445.84538,
60450.05034,	60454.25533,	60458.46034,	60462.66538,	60466.87045,	60471.07555,	60475.28067,	60479.48582,	60483.69100,	60487.89620,
60492.10143,	60496.30669,	60500.51198,	60504.71729,	60508.92263,	60513.12800,	60517.33339,	60521.53881,	60525.74426,	60529.94973,
60534.15524,	60538.36077,	60542.56632,	60546.77191,	60550.97752,	60555.18315,	60559.38882,	60563.59451,	60567.80023,	60572.00597,
60576.21175,	60580.41755,	60584.62337,	60588.82923,	60593.03511,	60597.24101,	60601.44695,	60605.65291,	60609.85890,	60614.06492,
60618.27096,	60622.47703,	60626.68313,	60630.88925,	60635.09540,	60639.30158,	60643.50778,	60647.71402,	60651.92027,	60656.12656,
60660.33287,	60664.53921,	60668.74558,	60672.95197,	60677.15840,	60681.36484,	60685.57132,	60689.77782,	60693.98435,	60698.19091,
60702.39749,	60706.60410,	60710.81074,	60715.01740,	60719.22409,	60723.43081,	60727.63755,	60731.84433,	60736.05112,	60740.25795,
60744.46480,	60748.67168,	60752.87859,	60757.08552,	60761.29248,	60765.49947,	60769.70649,	60773.91353,	60778.12060,	60782.32769,
60786.53482,	60790.74196,	60794.94914,	60799.15634,	60803.36357,	60807.57083,	60811.77812,	60815.98543,	60820.19277,	60824.40013,
60828.60752,	60832.81494,	60837.02239,	60841.22986,	60845.43736,	60849.64489,	60853.85244,	60858.06002,	60862.26763,	60866.47526,
60870.68292,	60874.89061,	60879.09833,	60883.30607,	60887.51384,	60891.72163,	60895.92946,	60900.13731,	60904.34518,	60908.55309,
60912.76102,	60916.96897,	60921.17696,	60925.38497,	60929.59301,	60933.80107,	60938.00916,	60942.21728,	60946.42543,	60950.63360,
60954.84180,	60959.05003,	60963.25828,	60967.46656,	60971.67487,	60975.88320,	60980.09156,	60984.29995,	60988.50836,	60992.71681,
60996.92527,	61001.13377,	61005.34229,	61009.55084,	61013.75942,	61017.96802,	61022.17665,	61026.38530,	61030.59399,	61034.80270,
61039.01143,	61043.22020,	61047.42899,	61051.63781,	61055.84665,	61060.05552,	61064.26442,	61068.47334,	61072.68230,	61076.89127,
61081.10028,	61085.30931,	61089.51837,	61093.72746,	61097.93657,	61102.14571,	61106.35487,	61110.56407,	61114.77329,	61118.98253,
61123.19181,	61127.40111,	61131.61044,	61135.81979,	61140.02917,	61144.23858,	61148.44801,	61152.65748,	61156.86696,	61161.07648,
61165.28602,	61169.49559,	61173.70518,	61177.91481,	61182.12446,	61186.33413,	61190.54383,	61194.75356,	61198.96332,	61203.17310,
61207.38291,	61211.59275,	61215.80261,	61220.01250,	61224.22242,	61228.43236,	61232.64233,	61236.85233,	61241.06236,	61245.27241,
61249.48248,	61253.69259,	61257.90272,	61262.11288,	61266.32306,	61270.53327,	61274.74351,	61278.95378,	61283.16407,	61287.37439,
61291.58473,	61295.79510,	61300.00550,	61304.21593,	61308.42638,	61312.63686,	61316.84737,	61321.05790,	61325.26846,	61329.47904,
61333.68966,	61337.90030,	61342.11096,	61346.32166,	61350.53237,	61354.74312,	61358.95389,	61363.16469,	61367.37552,	61371.58637,
61375.79725,	61380.00816,	61384.21909,	61388.43005,	61392.64104,	61396.85206,	61401.06310,	61405.27416,	61409.48526,	61413.69638,
61417.90752,	61422.11870,	61426.32990,	61430.54113,	61434.75238,	61438.96366,	61443.17497,	61447.38630,	61451.59766,	61455.80905,
61460.02047,	61464.23191,	61468.44337,	61472.65487,	61476.86639,	61481.07794,	61485.28951,	61489.50111,	61493.71274,	61497.92439,
61502.13608,	61506.34778,	61510.55952,	61514.77128,	61518.98307,	61523.19488,	61527.40672,	61531.61859,	61535.83048,	61540.04241,
61544.25435,	61548.46633,	61552.67833,	61556.89036,	61561.10241,	61565.31449,	61569.52660,	61573.73873,	61577.95090,	61582.16308,
61586.37530,	61590.58754,	61594.79981,	61599.01210,	61603.22442,	61607.43677,	61611.64914,	61615.86154,	61620.07397,	61624.28642,
61628.49890,	61632.71141,	61636.92395,	61641.13651,	61645.34909,	61649.56171,	61653.77435,	61657.98701,	61662.19971,	61666.41243,
61670.62517,	61674.83795,	61679.05075,	61683.26357,	61687.47643,	61691.68931,	61695.90221,	61700.11515,	61704.32811,	61708.54109,
61712.75411,	61716.96714,	61721.18021,	61725.39330,	61729.60642,	61733.81957,	61738.03274,	61742.24594,	61746.45916,	61750.67242,
61754.88570,	61759.09900,	61763.31233,	61767.52569,	61771.73908,	61775.95249,	61780.16593,	61784.37939,	61788.59288,	61792.80640,
61797.01994,	61801.23351,	61805.44711,	61809.66074,	61813.87439,	61818.08806,	61822.30177,	61826.51550,	61830.72925,	61834.94304,
61839.15685,	61843.37068,	61847.58455,	61851.79844,	61856.01235,	61860.22629,	61864.44026,	61868.65426,	61872.86828,	61877.08233,
61881.29640,	61885.51051,	61889.72463,	61893.93879,	61898.15297,	61902.36718,	61906.58141,	61910.79567,	61915.00996,	61919.22428,
61923.43862,	61927.65298,	61931.86738,	61936.08180,	61940.29624,	61944.51072,	61948.72521,	61952.93974,	61957.15429,	61961.36887,
61965.58348,	61969.79811,	61974.01277,	61978.22745,	61982.44216,	61986.65690,	61990.87167,	61995.08646,	61999.30127,	62003.51612,
62007.73099,	62011.94589,	62016.16081,	62020.37576,	62024.59074,	62028.80574,	62033.02077,	62037.23582,	62041.45090,	62045.66601,
62049.88115,	62054.09631,	62058.31150,	62062.52671,	62066.74195,	62070.95722,	62075.17251,	62079.38783,	62083.60318,	62087.81855,
62092.03395,	62096.24938,	62100.46483,	62104.68031,	62108.89582,	62113.11135,	62117.32691,	62121.54249,	62125.75810,	62129.97374,
62134.18940,	62138.40509,	62142.62081,	62146.83656,	62151.05232,	62155.26812,	62159.48394,	62163.69979,	62167.91567,	62172.13157,
62176.34750,	62180.56345,	62184.77943,	62188.99544,	62193.21147,	62197.42754,	62201.64362,	62205.85973,	62210.07587,	62214.29204,
62218.50823,	62222.72445,	62226.94070,	62231.15697,	62235.37327,	62239.58959,	62243.80594,	62248.02232,	62252.23872,	62256.45515,
62260.67161,	62264.88809,	62269.10460,	62273.32113,	62277.53770,	62281.75428,	62285.97090,	62290.18754,	62294.40421,	62298.62090,
62302.83762,	62307.05437,	62311.27114,	62315.48794,	62319.70476,	62323.92162,	62328.13849,	62332.35540,	62336.57233,	62340.78929,
62345.00627,	62349.22328,	62353.44032,	62357.65738,	62361.87447,	62366.09158,	62370.30872,	62374.52589,	62378.74309,	62382.96031,
62387.17755,	62391.39483,	62395.61213,	62399.82945,	62404.04681,	62408.26418,	62412.48159,	62416.69902,	62420.91648,	62425.13396,
62429.35147,	62433.56901,	62437.78657,	62442.00416,	62446.22178,	62450.43942,	62454.65709,	62458.87478,	62463.09250,	62467.31025,
62471.52802,	62475.74582,	62479.96365,	62484.18150,	62488.39938,	62492.61728,	62496.83521,	62501.05317,	62505.27116,	62509.48917,
62513.70720,	62517.92527,	62522.14335,	62526.36147,	62530.57961,	62534.79778,	62539.01597,	62543.23419,	62547.45244,	62551.67071,
62555.88901,	62560.10734,	62564.32569,	62568.54407,	62572.76247,	62576.98090,	62581.19936,	62585.41784,	62589.63635,	62593.85489,
62598.07345,	62602.29204,	62606.51065,	62610.72929,	62614.94796,	62619.16665,	62623.38537,	62627.60411,	62631.82289,	62636.04168,
62640.26051,	62644.47936,	62648.69824,	62652.91714,	62657.13607,	62661.35502,	62665.57401,	62669.79301,	62674.01205,	62678.23111,
62682.45019,	62686.66931,	62690.88845,	62695.10761,	62699.32680,	62703.54602,	62707.76526,	62711.98453,	62716.20383,	62720.42315,
62724.64250,	62728.86188,	62733.08128,	62737.30070,	62741.52016,	62745.73964,	62749.95914,	62754.17868,	62758.39823,	62762.61782,
62766.83743,	62771.05707,	62775.27673,	62779.49642,	62783.71613,	62787.93588,	62792.15564,	62796.37544,	62800.59526,	62804.81510,
62809.03498,	62813.25488,	62817.47480,	62821.69475,	62825.91473,	62830.13473,	62834.35476,	62838.57482,	62842.79490,	62847.01501,
62851.23514,	62855.45530,	62859.67549,	62863.89570,	62868.11594,	62872.33621,	62876.55650,	62880.77681,	62884.99716,	62889.21753,
62893.43792,	62897.65835,	62901.87879,	62906.09927,	62910.31977,	62914.54029,	62918.76085,	62922.98143,	62927.20203,	62931.42266,
62935.64332,	62939.86400,	62944.08471,	62948.30545,	62952.52621,	62956.74700,	62960.96781,	62965.18865,	62969.40952,	62973.63041,
62977.85133,	62982.07227,	62986.29324,	62990.51424,	62994.73526,	62998.95631,	63003.17739,	63007.39849,	63011.61961,	63015.84077,
63020.06195,	63024.28315,	63028.50438,	63032.72564,	63036.94693,	63041.16824,	63045.38957,	63049.61093,	63053.83232,	63058.05374,
63062.27518,	63066.49664,	63070.71813,	63074.93965,	63079.16120,	63083.38277,	63087.60437,	63091.82599,	63096.04764,	63100.26931,
63104.49101,	63108.71274,	63112.93449,	63117.15627,	63121.37808,	63125.59991,	63129.82177,	63134.04365,	63138.26556,	63142.48750,
63146.70946,	63150.93145,	63155.15346,	63159.37550,	63163.59756,	63167.81966,	63172.04177,	63176.26392,	63180.48609,	63184.70828,
63188.93051,	63193.15275,	63197.37503,	63201.59733,	63205.81966,	63210.04201,	63214.26439,	63218.48679,	63222.70922,	63226.93168,
63231.15416,	63235.37667,	63239.59920,	63243.82176,	63248.04435,	63252.26696,	63256.48960,	63260.71226,	63264.93495,	63269.15767,
63273.38041,	63277.60318,	63281.82598,	63286.04880,	63290.27164,	63294.49452,	63298.71741,	63302.94034,	63307.16329,	63311.38627,
63315.60927,	63319.83230,	63324.05535,	63328.27843,	63332.50154,	63336.72467,	63340.94783,	63345.17101,	63349.39422,	63353.61746,
63357.84072,	63362.06401,	63366.28732,	63370.51066,	63374.73403,	63378.95742,	63383.18084,	63387.40428,	63391.62775,	63395.85125,
63400.07477,	63404.29832,	63408.52189,	63412.74549,	63416.96912,	63421.19277,	63425.41645,	63429.64015,	63433.86388,	63438.08764,
63442.31142,	63446.53523,	63450.75906,	63454.98292,	63459.20680,	63463.43071,	63467.65465,	63471.87861,	63476.10260,	63480.32662,
63484.55066,	63488.77473,	63492.99882,	63497.22294,	63501.44708,	63505.67125,	63509.89545,	63514.11967,	63518.34392,	63522.56819,
63526.79249,	63531.01682,	63535.24117,	63539.46555,	63543.68995,	63547.91438,	63552.13884,	63556.36332,	63560.58782,	63564.81236,
63569.03692,	63573.26150,	63577.48611,	63581.71075,	63585.93541,	63590.16010,	63594.38481,	63598.60955,	63602.83432,	63607.05911,
63611.28393,	63615.50877,	63619.73364,	63623.95854,	63628.18346,	63632.40841,	63636.63338,	63640.85838,	63645.08340,	63649.30845,
63653.53353,	63657.75863,	63661.98376,	63666.20892,	63670.43410,	63674.65930,	63678.88453,	63683.10979,	63687.33507,	63691.56038,
63695.78572,	63700.01108,	63704.23647,	63708.46188,	63712.68732,	63716.91278,	63721.13827,	63725.36379,	63729.58933,	63733.81490,
63738.04049,	63742.26611,	63746.49176,	63750.71743,	63754.94312,	63759.16885,	63763.39460,	63767.62037,	63771.84617,	63776.07200,
63780.29785,	63784.52373,	63788.74963,	63792.97556,	63797.20151,	63801.42749,	63805.65350,	63809.87953,	63814.10559,	63818.33168,
63822.55779,	63826.78392,	63831.01008,	63835.23627,	63839.46248,	63843.68872,	63847.91499,	63852.14128,	63856.36759,	63860.59394,
63864.82030,	63869.04670,	63873.27312,	63877.49956,	63881.72603,	63885.95253,	63890.17905,	63894.40560,	63898.63217,	63902.85877,
63907.08540,	63911.31205,	63915.53873,	63919.76543,	63923.99216,	63928.21892,	63932.44570,	63936.67250,	63940.89933,	63945.12619,
63949.35307,	63953.57998,	63957.80692,	63962.03388,	63966.26087,	63970.48788,	63974.71492,	63978.94198,	63983.16907,	63987.39618,
63991.62332,	63995.85049,	64000.07768,	64004.30490,	64008.53214,	64012.75941,	64016.98671,	64021.21403,	64025.44138,	64029.66875,
64033.89615,	64038.12357,	64042.35102,	64046.57850,	64050.80600,	64055.03352,	64059.26108,	64063.48866,	64067.71626,	64071.94389,
64076.17154,	64080.39923,	64084.62693,	64088.85466,	64093.08242,	64097.31021,	64101.53802,	64105.76585,	64109.99371,	64114.22160,
64118.44951,	64122.67745,	64126.90541,	64131.13340,	64135.36142,	64139.58946,	64143.81753,	64148.04562,	64152.27374,	64156.50188,
64160.73005,	64164.95824,	64169.18646,	64173.41471,	64177.64298,	64181.87128,	64186.09960,	64190.32795,	64194.55633,	64198.78473,
64203.01315,	64207.24161,	64211.47008,	64215.69859,	64219.92711,	64224.15567,	64228.38425,	64232.61285,	64236.84149,	64241.07014,
64245.29883,	64249.52753,	64253.75627,	64257.98503,	64262.21381,	64266.44262,	64270.67146,	64274.90032,	64279.12921,	64283.35812,
64287.58706,	64291.81603,	64296.04502,	64300.27403,	64304.50307,	64308.73214,	64312.96123,	64317.19035,	64321.41950,	64325.64867,
64329.87786,	64334.10708,	64338.33633,	64342.56560,	64346.79490,	64351.02422,	64355.25357,	64359.48295,	64363.71235,	64367.94177,
64372.17122,	64376.40070,	64380.63020,	64384.85973,	64389.08929,	64393.31887,	64397.54847,	64401.77810,	64406.00776,	64410.23744,
64414.46715,	64418.69688,	64422.92664,	64427.15642,	64431.38623,	64435.61607,	64439.84593,	64444.07582,	64448.30573,	64452.53566,
64456.76563,	64460.99562,	64465.22563,	64469.45567,	64473.68574,	64477.91583,	64482.14594,	64486.37609,	64490.60625,	64494.83645,
64499.06667,	64503.29691,	64507.52718,	64511.75748,	64515.98780,	64520.21815,	64524.44852,	64528.67892,	64532.90934,	64537.13979,
64541.37026,	64545.60076,	64549.83129,	64554.06184,	64558.29242,	64562.52302,	64566.75365,	64570.98430,	64575.21498,	64579.44568,
64583.67641,	64587.90717,	64592.13795,	64596.36875,	64600.59959,	64604.83044,	64609.06133,	64613.29224,	64617.52317,	64621.75413,
64625.98511,	64630.21612,	64634.44716,	64638.67822,	64642.90931,	64647.14042,	64651.37156,	64655.60272,	64659.83391,	64664.06513,
64668.29637,	64672.52763,	64676.75892,	64680.99024,	64685.22158,	64689.45295,	64693.68434,	64697.91576,	64702.14721,	64706.37868,
64710.61017,	64714.84169,	64719.07324,	64723.30481,	64727.53641,	64731.76803,	64735.99968,	64740.23135,	64744.46305,	64748.69477,
64752.92652,	64757.15830,	64761.39010,	64765.62193,	64769.85378,	64774.08565,	64778.31756,	64782.54949,	64786.78144,	64791.01342,
64795.24542,	64799.47745,	64803.70951,	64807.94159,	64812.17369,	64816.40583,	64820.63798,	64824.87017,	64829.10237,	64833.33461,
64837.56687,	64841.79915,	64846.03146,	64850.26380,	64854.49616,	64858.72854,	64862.96096,	64867.19339,	64871.42585,	64875.65834,
64879.89086,	64884.12339,	64888.35596,	64892.58855,	64896.82116,	64901.05380,	64905.28647,	64909.51916,	64913.75188,	64917.98462,
64922.21739,	64926.45018,	64930.68300,	64934.91584,	64939.14871,	64943.38161,	64947.61453,	64951.84747,	64956.08044,	64960.31344,
64964.54646,	64968.77951,	64973.01258,	64977.24568,	64981.47880,	64985.71195,	64989.94512,	64994.17832,	64998.41154,	65002.64479,
65006.87807,	65011.11137,	65015.34470,	65019.57805,	65023.81143,	65028.04483,	65032.27826,	65036.51171,	65040.74519,	65044.97869,
65049.21222,	65053.44577,	65057.67935,	65061.91296,	65066.14659,	65070.38025,	65074.61393,	65078.84763,	65083.08137,	65087.31512,
65091.54891,	65095.78271,	65100.01655,	65104.25041,	65108.48429,	65112.71820,	65116.95213,	65121.18609,	65125.42008,	65129.65409,
65133.88813,	65138.12219,	65142.35628,	65146.59039,	65150.82453,	65155.05869,	65159.29288,	65163.52709,	65167.76133,	65171.99559,
65176.22988,	65180.46420,	65184.69854,	65188.93290,	65193.16729,	65197.40171,	65201.63615,	65205.87062,	65210.10511,	65214.33963,
65218.57417,	65222.80874,	65227.04333,	65231.27795,	65235.51259,	65239.74726,	65243.98196,	65248.21668,	65252.45142,	65256.68619,
65260.92099,	65265.15581,	65269.39065,	65273.62552,	65277.86042,	65282.09534,	65286.33029,	65290.56526,	65294.80026,	65299.03528,
65303.27033,	65307.50541,	65311.74051,	65315.97563,	65320.21078,	65324.44595,	65328.68115,	65332.91638,	65337.15163,	65341.38691,
65345.62221,	65349.85753,	65354.09289,	65358.32826,	65362.56366,	65366.79909,	65371.03454,	65375.27002,	65379.50553,	65383.74105,
65387.97661,	65392.21219,	65396.44779,	65400.68342,	65404.91908,	65409.15476,	65413.39046,	65417.62619,	65421.86195,	65426.09773,
65430.33353,	65434.56936,	65438.80522,	65443.04110,	65447.27701,	65451.51294,	65455.74890,	65459.98488,	65464.22089,	65468.45692,
65472.69298,	65476.92907,	65481.16517,	65485.40131,	65489.63747,	65493.87365,	65498.10986,	65502.34610,	65506.58236,	65510.81864,
65515.05495,	65519.29129,	65523.52765,	65527.76404,	65532.00045,	65536.23688,	65540.47334,	65544.70983,	65548.94634,	65553.18288,
65557.41944,	65561.65603,	65565.89264,	65570.12928,	65574.36594,	65578.60263,	65582.83935,	65587.07609,	65591.31285,	65595.54964,
65599.78645,	65604.02329,	65608.26016,	65612.49705,	65616.73396,	65620.97090,	65625.20787,	65629.44486,	65633.68187,	65637.91891,
65642.15598,	65646.39307,	65650.63019,	65654.86733,	65659.10450,	65663.34169,	65667.57890,	65671.81615,	65676.05341,	65680.29071,
65684.52802,	65688.76537,	65693.00273,	65697.24013,	65701.47754,	65705.71499,	65709.95246,	65714.18995,	65718.42747,	65722.66501,
65726.90258,	65731.14017,	65735.37779,	65739.61544,	65743.85311,	65748.09080,	65752.32852,	65756.56627,	65760.80404,	65765.04183,
65769.27965,	65773.51750,	65777.75537,	65781.99326,	65786.23118,	65790.46913,	65794.70710,	65798.94510,	65803.18312,	65807.42116,
65811.65923,	65815.89733,	65820.13545,	65824.37360,	65828.61177,	65832.84997,	65837.08819,	65841.32643,	65845.56471,	65849.80300,
65854.04133,	65858.27967,	65862.51805,	65866.75644,	65870.99487,	65875.23331,	65879.47179,	65883.71028,	65887.94881,	65892.18735,
65896.42593,	65900.66453,	65904.90315,	65909.14180,	65913.38047,	65917.61917,	65921.85789,	65926.09664,	65930.33541,	65934.57421,
65938.81304,	65943.05188,	65947.29076,	65951.52966,	65955.76858,	65960.00753,	65964.24650,	65968.48550,	65972.72453,	65976.96358,
65981.20265,	65985.44175,	65989.68087,	65993.92002,	65998.15920,	66002.39840,	66006.63762,	66010.87687,	66015.11614,	66019.35544,
66023.59477,	66027.83412,	66032.07349,	66036.31289,	66040.55232,	66044.79177,	66049.03124,	66053.27074,	66057.51027,	66061.74981,
66065.98939,	66070.22899,	66074.46861,	66078.70826,	66082.94794,	66087.18764,	66091.42736,	66095.66711,	66099.90689,	66104.14669,
66108.38651,	66112.62636,	66116.86624,	66121.10614,	66125.34606,	66129.58601,	66133.82599,	66138.06599,	66142.30601,	66146.54606,
66150.78614,	66155.02624,	66159.26636,	66163.50651,	66167.74668,	66171.98688,	66176.22711,	66180.46736,	66184.70763,	66188.94793,
66193.18826,	66197.42861,	66201.66898,	66205.90938,	66210.14981,	66214.39025,	66218.63073,	66222.87123,	66227.11175,	66231.35230,
66235.59288,	66239.83348,	66244.07410,	66248.31475,	66252.55542,	66256.79612,	66261.03685,	66265.27759,	66269.51837,	66273.75917,
66277.99999,	66282.24084,	66286.48171,	66290.72261,	66294.96353,	66299.20448,	66303.44546,	66307.68645,	66311.92748,	66316.16853,
66320.40960,	66324.65070,	66328.89182,	66333.13297,	66337.37414,	66341.61534,	66345.85656,	66350.09781,	66354.33908,	66358.58038,
66362.82170,	66367.06305,	66371.30442,	66375.54582,	66379.78724,	66384.02869,	66388.27016,	66392.51165,	66396.75318,	66400.99472,
66405.23629,	66409.47789,	66413.71951,	66417.96116,	66422.20283,	66426.44452,	66430.68624,	66434.92799,	66439.16976,	66443.41156,
66447.65338,	66451.89522,	66456.13709,	66460.37899,	66464.62091,	66468.86285,	66473.10482,	66477.34682,	66481.58884,	66485.83088,
66490.07295,	66494.31504,	66498.55716,	66502.79931,	66507.04147,	66511.28367,	66515.52589,	66519.76813,	66524.01040,	66528.25269,
66532.49501,	66536.73735,	66540.97972,	66545.22211,	66549.46453,	66553.70697,	66557.94944,	66562.19193,	66566.43444,	66570.67699,
66574.91955,	66579.16214,	66583.40476,	66587.64740,	66591.89007,	66596.13276,	66600.37547,	66604.61821,	66608.86098,	66613.10377,
66617.34658,	66621.58942,	66625.83228,	66630.07517,	66634.31809,	66638.56103,	66642.80399,	66647.04698,	66651.28999,	66655.53303,
66659.77609,	66664.01918,	66668.26229,	66672.50543,	66676.74859,	66680.99178,	66685.23499,	66689.47823,	66693.72149,	66697.96477,
66702.20809,	66706.45142,	66710.69478,	66714.93817,	66719.18158,	66723.42501,	66727.66847,	66731.91196,	66736.15547,	66740.39900,
66744.64256,	66748.88614,	66753.12975,	66757.37338,	66761.61704,	66765.86073,	66770.10443,	66774.34817,	66778.59192,	66782.83570,
66787.07951,	66791.32334,	66795.56720,	66799.81108,	66804.05499,	66808.29892,	66812.54287,	66816.78685,	66821.03086,	66825.27489,
66829.51894,	66833.76302,	66838.00712,	66842.25125,	66846.49541,	66850.73958,	66854.98379,	66859.22801,	66863.47227,	66867.71654,
66871.96085,	66876.20517,	66880.44952,	66884.69390,	66888.93830,	66893.18273,	66897.42718,	66901.67165,	66905.91615,	66910.16068,
66914.40522,	66918.64980,	66922.89440,	66927.13902,	66931.38367,	66935.62834,	66939.87304,	66944.11776,	66948.36251,	66952.60728,
66956.85208,	66961.09690,	66965.34174,	66969.58661,	66973.83151,	66978.07643,	66982.32137,	66986.56634,	66990.81134,	66995.05636,
66999.30140,	67003.54647,	67007.79156,	67012.03668,	67016.28182,	67020.52699,	67024.77218,	67029.01740,	67033.26264,	67037.50790,
67041.75319,	67045.99851,	67050.24385,	67054.48921,	67058.73460,	67062.98002,	67067.22546,	67071.47092,	67075.71641,	67079.96192,
67084.20746,	67088.45302,	67092.69861,	67096.94422,	67101.18985,	67105.43551,	67109.68120,	67113.92691,	67118.17264,	67122.41840,
67126.66419,	67130.91000,	67135.15583,	67139.40169,	67143.64757,	67147.89348,	67152.13941,	67156.38537,	67160.63135,	67164.87735,
67169.12338,	67173.36944,	67177.61552,	67181.86162,	67186.10775,	67190.35391,	67194.60008,	67198.84629,	67203.09252,	67207.33877,
67211.58504,	67215.83135,	67220.07767,	67224.32402,	67228.57040,	67232.81680,	67237.06322,	67241.30967,	67245.55615,	67249.80265,
67254.04917,	67258.29572,	67262.54229,	67266.78889,	67271.03551,	67275.28215,	67279.52883,	67283.77552,	67288.02224,	67292.26899,
67296.51575,	67300.76255,	67305.00937,	67309.25621,	67313.50308,	67317.74997,	67321.99689,	67326.24383,	67330.49079,	67334.73779,
67338.98480,	67343.23184,	67347.47891,	67351.72599,	67355.97311,	67360.22025,	67364.46741,	67368.71460,	67372.96181,	67377.20904,
67381.45631,	67385.70359,	67389.95090,	67394.19824,	67398.44560,	67402.69298,	67406.94039,	67411.18782,	67415.43528,	67419.68276,
67423.93027,	67428.17780,	67432.42536,	67436.67294,	67440.92054,	67445.16817,	67449.41583,	67453.66350,	67457.91121,	67462.15894,
67466.40669,	67470.65446,	67474.90227,	67479.15009,	67483.39794,	67487.64582,	67491.89372,	67496.14164,	67500.38959,	67504.63756,
67508.88556,	67513.13358,	67517.38163,	67521.62970,	67525.87780,	67530.12592,	67534.37406,	67538.62223,	67542.87043,	67547.11865,
67551.36689,	67555.61516,	67559.86345,	67564.11176,	67568.36011,	67572.60847,	67576.85686,	67581.10528,	67585.35372,	67589.60218,
67593.85067,	67598.09918,	67602.34772,	67606.59628,	67610.84487,	67615.09348,	67619.34211,	67623.59077,	67627.83946,	67632.08816,
67636.33690,	67640.58566,	67644.83444,	67649.08324,	67653.33208,	67657.58093,	67661.82981,	67666.07872,	67670.32765,	67674.57660,
67678.82558,	67683.07458,	67687.32361,	67691.57266,	67695.82173,	67700.07083,	67704.31996,	67708.56911,	67712.81828,	67717.06748,
67721.31670,	67725.56595,	67729.81522,	67734.06452,	67738.31384,	67742.56318,	67746.81255,	67751.06195,	67755.31137,	67759.56081,
67763.81028,	67768.05977,	67772.30929,	67776.55883,	67780.80839,	67785.05798,	67789.30760,	67793.55723,	67797.80690,	67802.05658,
67806.30630,	67810.55603,	67814.80579,	67819.05558,	67823.30539,	67827.55522,	67831.80508,	67836.05496,	67840.30487,	67844.55480,
67848.80476,	67853.05474,	67857.30474,	67861.55477,	67865.80483,	67870.05491,	67874.30501,	67878.55514,	67882.80529,	67887.05546,
67891.30566,	67895.55589,	67899.80614,	67904.05641,	67908.30671,	67912.55703,	67916.80738,	67921.05775,	67925.30815,	67929.55857,
67933.80901,	67938.05948,	67942.30997,	67946.56049,	67950.81103,	67955.06160,	67959.31219,	67963.56280,	67967.81344,	67972.06411,
67976.31480,	67980.56551,	67984.81624,	67989.06701,	67993.31779,	67997.56860,	68001.81944,	68006.07030,	68010.32118,	68014.57209,
68018.82302,	68023.07398,	68027.32496,	68031.57596,	68035.82699,	68040.07804,	68044.32912,	68048.58023,	68052.83135,	68057.08250,
68061.33368,	68065.58488,	68069.83610,	68074.08735,	68078.33863,	68082.58992,	68086.84125,	68091.09259,	68095.34396,	68099.59536,
68103.84678,	68108.09822,	68112.34969,	68116.60118,	68120.85270,	68125.10424,	68129.35580,	68133.60739,	68137.85901,	68142.11064,
68146.36231,	68150.61399,	68154.86570,	68159.11744,	68163.36920,	68167.62098,	68171.87279,	68176.12463,	68180.37648,	68184.62836,
68188.88027,	68193.13220,	68197.38415,	68201.63613,	68205.88814,	68210.14016,	68214.39222,	68218.64429,	68222.89639,	68227.14852,
68231.40066,	68235.65284,	68239.90504,	68244.15726,	68248.40950,	68252.66177,	68256.91407,	68261.16639,	68265.41873,	68269.67110,
68273.92349,	68278.17591,	68282.42835,	68286.68081,	68290.93330,	68295.18581,	68299.43835,	68303.69091,	68307.94350,	68312.19611,
68316.44874,	68320.70140,	68324.95409,	68329.20679,	68333.45952,	68337.71228,	68341.96506,	68346.21787,	68350.47069,	68354.72355,
68358.97642,	68363.22933,	68367.48225,	68371.73520,	68375.98818,	68380.24117,	68384.49420,	68388.74724,	68393.00032,	68397.25341,
68401.50653,	68405.75968,	68410.01284,	68414.26604,	68418.51925,	68422.77249,	68427.02576,	68431.27905,	68435.53236,	68439.78570,
68444.03906,	68448.29245,	68452.54586,	68456.79930,	68461.05275,	68465.30624,	68469.55975,	68473.81328,	68478.06683,	68482.32041,
68486.57402,	68490.82765,	68495.08130,	68499.33498,	68503.58868,	68507.84240,	68512.09615,	68516.34993,	68520.60373,	68524.85755,
68529.11139,	68533.36527,	68537.61916,	68541.87308,	68546.12702,	68550.38099,	68554.63498,	68558.88900,	68563.14304,	68567.39710,
68571.65119,	68575.90531,	68580.15944,	68584.41360,	68588.66779,	68592.92200,	68597.17623,	68601.43049,	68605.68477,	68609.93908,
68614.19341,	68618.44776,	68622.70214,	68626.95655,	68631.21097,	68635.46542,	68639.71990,	68643.97440,	68648.22892,	68652.48347,
68656.73804,	68660.99264,	68665.24726,	68669.50191,	68673.75657,	68678.01127,	68682.26598,	68686.52073,	68690.77549,	68695.03028,
68699.28510,	68703.53993,	68707.79480,	68712.04968,	68716.30459,	68720.55953,	68724.81449,	68729.06947,	68733.32448,	68737.57951,
68741.83456,	68746.08964,	68750.34475,	68754.59987,	68758.85502,	68763.11020,	68767.36540,	68771.62062,	68775.87587,	68780.13115,
68784.38644,	68788.64176,	68792.89711,	68797.15248,	68801.40787,	68805.66329,	68809.91873,	68814.17419,	68818.42968,	68822.68520,
68826.94074,	68831.19630,	68835.45188,	68839.70749,	68843.96313,	68848.21879,	68852.47447,	68856.73018,	68860.98591,	68865.24166,
68869.49744,	68873.75324,	68878.00907,	68882.26492,	68886.52080,	68890.77670,	68895.03262,	68899.28857,	68903.54454,	68907.80053,
68912.05655,	68916.31260,	68920.56867,	68924.82476,	68929.08087,	68933.33701,	68937.59318,	68941.84937,	68946.10558,	68950.36182,
68954.61808,	68958.87436,	68963.13067,	68967.38700,	68971.64336,	68975.89974,	68980.15615,	68984.41257,	68988.66903,	68992.92550,
68997.18201,	69001.43853,	69005.69508,	69009.95165,	69014.20825,	69018.46487,	69022.72152,	69026.97819,	69031.23488,	69035.49160,
69039.74834,	69044.00511,	69048.26190,	69052.51871,	69056.77555,	69061.03241,	69065.28930,	69069.54621,	69073.80314,	69078.06010,
69082.31708,	69086.57409,	69090.83112,	69095.08817,	69099.34525,	69103.60235,	69107.85948,	69112.11663,	69116.37380,	69120.63100,
69124.88823,	69129.14547,	69133.40274,	69137.66004,	69141.91736,	69146.17470,	69150.43206,	69154.68945,	69158.94687,	69163.20431,
69167.46177,	69171.71926,	69175.97677,	69180.23430,	69184.49186,	69188.74944,	69193.00705,	69197.26468,	69201.52234,	69205.78001,
69210.03772,	69214.29544,	69218.55319,	69222.81097,	69227.06877,	69231.32659,	69235.58444,	69239.84231,	69244.10020,	69248.35812,
69252.61606,	69256.87403,	69261.13202,	69265.39003,	69269.64807,	69273.90613,	69278.16422,	69282.42233,	69286.68046,	69290.93862,
69295.19680,	69299.45501,	69303.71324,	69307.97149,	69312.22977,	69316.48807,	69320.74640,	69325.00475,	69329.26312,	69333.52152,
69337.77994,	69342.03839,	69346.29686,	69350.55535,	69354.81387,	69359.07241,	69363.33098,	69367.58957,	69371.84818,	69376.10682,
69380.36548,	69384.62416,	69388.88287,	69393.14161,	69397.40036,	69401.65914,	69405.91795,	69410.17678,	69414.43563,	69418.69451,
69422.95341,	69427.21233,	69431.47128,	69435.73025,	69439.98925,	69444.24827,	69448.50731,	69452.76638,	69457.02547,	69461.28459,
69465.54373,	69469.80289,	69474.06208,	69478.32129,	69482.58053,	69486.83979,	69491.09907,	69495.35838,	69499.61771,	69503.87706,
69508.13644,	69512.39584,	69516.65527,	69520.91472,	69525.17420,	69529.43369,	69533.69322,	69537.95276,	69542.21233,	69546.47193,
69550.73154,	69554.99119,	69559.25085,	69563.51054,	69567.77025,	69572.02999,	69576.28975,	69580.54954,	69584.80935,	69589.06918,
69593.32903,	69597.58892,	69601.84882,	69606.10875,	69610.36870,	69614.62868,	69618.88868,	69623.14870,	69627.40875,	69631.66882,
69635.92891,	69640.18903,	69644.44918,	69648.70934,	69652.96953,	69657.22975,	69661.48999,	69665.75025,	69670.01053,	69674.27084,
69678.53118,	69682.79154,	69687.05192,	69691.31232,	69695.57275,	69699.83320,	69704.09368,	69708.35418,	69712.61471,	69716.87526,
69721.13583,	69725.39642,	69729.65704,	69733.91769,	69738.17835,	69742.43905,	69746.69976,	69750.96050,	69755.22126,	69759.48205,
69763.74286,	69768.00369,	69772.26455,	69776.52543,	69780.78634,	69785.04727,	69789.30822,	69793.56920,	69797.83020,	69802.09123,
69806.35228,	69810.61335,	69814.87444,	69819.13556,	69823.39671,	69827.65788,	69831.91907,	69836.18028,	69840.44152,	69844.70278,
69848.96407,	69853.22538,	69857.48672,	69861.74807,	69866.00946,	69870.27086,	69874.53229,	69878.79374,	69883.05522,	69887.31672,
69891.57825,	69895.83979,	69900.10137,	69904.36296,	69908.62458,	69912.88623,	69917.14789,	69921.40958,	69925.67130,	69929.93304,
69934.19480,	69938.45659,	69942.71840,	69946.98023,	69951.24209,	69955.50397,	69959.76587,	69964.02780,	69968.28975,	69972.55173,
69976.81373,	69981.07575,	69985.33780,	69989.59987,	69993.86197,	69998.12409,	70002.38623,	70006.64839,	70010.91058,	70015.17280,
70019.43504,	70023.69730,	70027.95958,	70032.22189,	70036.48422,	70040.74658,	70045.00896,	70049.27136,	70053.53379,	70057.79624,
70062.05872,	70066.32121,	70070.58374,	70074.84628,	70079.10885,	70083.37145,	70087.63406,	70091.89670,	70096.15937,	70100.42206,
70104.68477,	70108.94750,	70113.21026,	70117.47305,	70121.73585,	70125.99868,	70130.26154,	70134.52442,	70138.78732,	70143.05024,
70147.31319,	70151.57617,	70155.83916,	70160.10218,	70164.36523,	70168.62829,	70172.89139,	70177.15450,	70181.41764,	70185.68080,
70189.94399,	70194.20720,	70198.47043,	70202.73369,	70206.99697,	70211.26027,	70215.52360,	70219.78696,	70224.05033,	70228.31373,
70232.57715,	70236.84060,	70241.10407,	70245.36756,	70249.63108,	70253.89462,	70258.15819,	70262.42178,	70266.68539,	70270.94903,
70275.21269,	70279.47637,	70283.74008,	70288.00381,	70292.26756,	70296.53134,	70300.79514,	70305.05897,	70309.32282,	70313.58669,
70317.85058,	70322.11450,	70326.37845,	70330.64241,	70334.90641,	70339.17042,	70343.43446,	70347.69852,	70351.96261,	70356.22672,
70360.49085,	70364.75500,	70369.01918,	70373.28339,	70377.54762,	70381.81187,	70386.07614,	70390.34044,	70394.60476,	70398.86911,
70403.13348,	70407.39787,	70411.66229,	70415.92673,	70420.19119,	70424.45568,	70428.72019,	70432.98472,	70437.24928,	70441.51386,
70445.77847,	70450.04310,	70454.30775,	70458.57242,	70462.83712,	70467.10185,	70471.36659,	70475.63137,	70479.89616,	70484.16098,
70488.42582,	70492.69068,	70496.95557,	70501.22048,	70505.48542,	70509.75038,	70514.01536,	70518.28037,	70522.54540,	70526.81045,
70531.07553,	70535.34063,	70539.60576,	70543.87090,	70548.13608,	70552.40127,	70556.66649,	70560.93173,	70565.19700,	70569.46229,
70573.72760,	70577.99294,	70582.25830,	70586.52368,	70590.78909,	70595.05452,	70599.31998,	70603.58545,	70607.85096,	70612.11648,
70616.38203,	70620.64760,	70624.91320,	70629.17882,	70633.44446,	70637.71013,	70641.97582,	70646.24153,	70650.50727,	70654.77303,
70659.03881,	70663.30462,	70667.57045,	70671.83631,	70676.10219,	70680.36809,	70684.63402,	70688.89997,	70693.16594,	70697.43193,
70701.69795,	70705.96400,	70710.23006,	70714.49616,	70718.76227,	70723.02841,	70727.29457,	70731.56075,	70735.82696,	70740.09319,
70744.35945,	70748.62573,	70752.89203,	70757.15835,	70761.42470,	70765.69108,	70769.95747,	70774.22389,	70778.49034,	70782.75680,
70787.02329,	70791.28981,	70795.55635,	70799.82291,	70804.08949,	70808.35610,	70812.62273,	70816.88938,	70821.15606,	70825.42277,
70829.68949,	70833.95624,	70838.22301,	70842.48981,	70846.75663,	70851.02347,	70855.29034,	70859.55723,	70863.82414,	70868.09108,
70872.35804,	70876.62502,	70880.89203,	70885.15906,	70889.42611,	70893.69319,	70897.96029,	70902.22742,	70906.49457,	70910.76174,
70915.02893,	70919.29615,	70923.56339,	70927.83066,	70932.09795,	70936.36526,	70940.63260,	70944.89996,	70949.16734,	70953.43475,
70957.70218,	70961.96963,	70966.23711,	70970.50461,	70974.77213,	70979.03968,	70983.30725,	70987.57484,	70991.84246,	70996.11010,
71000.37777,	71004.64545,	71008.91316,	71013.18090,	71017.44866,	71021.71644,	71025.98424,	71030.25207,	71034.51992,	71038.78780,
71043.05570,	71047.32362,	71051.59157,	71055.85954,	71060.12753,	71064.39554,	71068.66358,	71072.93165,	71077.19973,	71081.46784,
71085.73598,	71090.00413,	71094.27231,	71098.54052,	71102.80874,	71107.07699,	71111.34527,	71115.61356,	71119.88188,	71124.15023,
71128.41860,	71132.68699,	71136.95540,	71141.22384,	71145.49230,	71149.76078,	71154.02929,	71158.29782,	71162.56638,	71166.83495,
71171.10356,	71175.37218,	71179.64083,	71183.90950,	71188.17820,	71192.44691,	71196.71566,	71200.98442,	71205.25321,	71209.52202,
71213.79086,	71218.05972,	71222.32860,	71226.59750,	71230.86643,	71235.13538,	71239.40436,	71243.67336,	71247.94238,	71252.21143,
71256.48050,	71260.74959,	71265.01870,	71269.28784,	71273.55701,	71277.82619,	71282.09540,	71286.36463,	71290.63389,	71294.90317,
71299.17247,	71303.44180,	71307.71115,	71311.98052,	71316.24992,	71320.51934,	71324.78878,	71329.05824,	71333.32773,	71337.59725,
71341.86678,	71346.13634,	71350.40593,	71354.67553,	71358.94516,	71363.21482,	71367.48449,	71371.75419,	71376.02391,	71380.29366,
71384.56343,	71388.83322,	71393.10304,	71397.37288,	71401.64274,	71405.91263,	71410.18254,	71414.45247,	71418.72243,	71422.99241,
71427.26241,	71431.53244,	71435.80249,	71440.07256,	71444.34266,	71448.61278,	71452.88292,	71457.15308,	71461.42327,	71465.69349,
71469.96372,	71474.23398,	71478.50427,	71482.77457,	71487.04490,	71491.31525,	71495.58563,	71499.85603,	71504.12645,	71508.39690,
71512.66737,	71516.93786,	71521.20838,	71525.47891,	71529.74948,	71534.02006,	71538.29067,	71542.56130,	71546.83196,	71551.10264,
71555.37334,	71559.64407,	71563.91481,	71568.18559,	71572.45638,	71576.72720,	71580.99804,	71585.26891,	71589.53980,	71593.81071,
71598.08164,	71602.35260,	71606.62358,	71610.89459,	71615.16561,	71619.43667,	71623.70774,	71627.97884,	71632.24996,	71636.52110,
71640.79227,	71645.06346,	71649.33468,	71653.60591,	71657.87717,	71662.14846,	71666.41976,	71670.69109,	71674.96245,	71679.23383,
71683.50523,	71687.77665,	71692.04810,	71696.31957,	71700.59106,	71704.86257,	71709.13411,	71713.40568,	71717.67726,	71721.94887,
71726.22051,	71730.49216,	71734.76384,	71739.03554,	71743.30727,	71747.57902,	71751.85079,	71756.12258,	71760.39440,	71764.66624,
71768.93811,	71773.21000,	71777.48191,	71781.75384,	71786.02580,	71790.29778,	71794.56978,	71798.84181,	71803.11386,	71807.38594,
71811.65803,	71815.93015,	71820.20230,	71824.47446,	71828.74665,	71833.01887,	71837.29110,	71841.56336,	71845.83564,	71850.10795,
71854.38028,	71858.65263,	71862.92501,	71867.19741,	71871.46983,	71875.74227,	71880.01474,	71884.28723,	71888.55975,	71892.83228,
71897.10485,	71901.37743,	71905.65004,	71909.92267,	71914.19532,	71918.46800,	71922.74070,	71927.01342,	71931.28617,	71935.55894,
71939.83173,	71944.10455,	71948.37739,	71952.65025,	71956.92313,	71961.19604,	71965.46897,	71969.74193,	71974.01491,	71978.28791,
71982.56093,	71986.83398,	71991.10705,	71995.38014,	71999.65326,	72003.92640,	72008.19957,	72012.47275,	72016.74596,	72021.01919,
72025.29245,	72029.56573,	72033.83903,	72038.11236,	72042.38571,	72046.65908,	72050.93247,	72055.20589,	72059.47933,	72063.75280,
72068.02628,	72072.29979,	72076.57333,	72080.84688,	72085.12046,	72089.39407,	72093.66769,	72097.94134,	72102.21502,	72106.48871,
72110.76243,	72115.03617,	72119.30994,	72123.58372,	72127.85754,	72132.13137,	72136.40523,	72140.67911,	72144.95301,	72149.22694,
72153.50089,	72157.77486,	72162.04886,	72166.32288,	72170.59692,	72174.87098,	72179.14507,	72183.41918,	72187.69332,	72191.96748,
72196.24166,	72200.51586,	72204.79009,	72209.06434,	72213.33861,	72217.61291,	72221.88723,	72226.16157,	72230.43594,	72234.71033,
72238.98474,	72243.25917,	72247.53363,	72251.80811,	72256.08262,	72260.35714,	72264.63169,	72268.90627,	72273.18086,	72277.45548,
72281.73013,	72286.00479,	72290.27948,	72294.55419,	72298.82893,	72303.10369,	72307.37847,	72311.65327,	72315.92810,	72320.20295,
72324.47782,	72328.75272,	72333.02764,	72337.30258,	72341.57755,	72345.85253,	72350.12755,	72354.40258,	72358.67764,	72362.95272,
72367.22782,	72371.50295,	72375.77810,	72380.05327,	72384.32847,	72388.60369,	72392.87893,	72397.15420,	72401.42949,	72405.70480,
72409.98013,	72414.25549,	72418.53087,	72422.80627,	72427.08170,	72431.35715,	72435.63262,	72439.90812,	72444.18364,	72448.45918,
72452.73474,	72457.01033,	72461.28594,	72465.56157,	72469.83723,	72474.11291,	72478.38861,	72482.66434,	72486.94009,	72491.21586,
72495.49166,	72499.76747,	72504.04331,	72508.31918,	72512.59507,	72516.87098,	72521.14691,	72525.42286,	72529.69884,	72533.97484,
72538.25087,	72542.52692,	72546.80299,	72551.07908,	72555.35520,	72559.63134,	72563.90750,	72568.18369,	72572.45990,	72576.73613,
72581.01238,	72585.28866,	72589.56496,	72593.84129,	72598.11763,	72602.39400,	72606.67040,	72610.94681,	72615.22325,	72619.49971,
72623.77620,	72628.05271,	72632.32924,	72636.60579,	72640.88237,	72645.15897,	72649.43559,	72653.71224,	72657.98890,	72662.26560,
72666.54231,	72670.81905,	72675.09581,	72679.37259,	72683.64940,	72687.92623,	72692.20308,	72696.47995,	72700.75685,	72705.03377,
72709.31072,	72713.58768,	72717.86467,	72722.14169,	72726.41872,	72730.69578,	72734.97286,	72739.24997,	72743.52710,	72747.80425,
72752.08142,	72756.35862,	72760.63584,	72764.91308,	72769.19034,	72773.46763,	72777.74494,	72782.02228,	72786.29963,	72790.57701,
72794.85442,	72799.13184,	72803.40929,	72807.68676,	72811.96426,	72816.24178,	72820.51932,	72824.79688,	72829.07447,	72833.35208,
72837.62971,	72841.90736,	72846.18504,	72850.46274,	72854.74047,	72859.01821,	72863.29598,	72867.57377,	72871.85159,	72876.12943,
72880.40729,	72884.68517,	72888.96308,	72893.24101,	72897.51896,	72901.79694,	72906.07494,	72910.35296,	72914.63100,	72918.90907,
72923.18716,	72927.46527,	72931.74341,	72936.02157,	72940.29975,	72944.57796,	72948.85618,	72953.13443,	72957.41271,	72961.69100,
72965.96932,	72970.24766,	72974.52603,	72978.80442,	72983.08283,	72987.36126,	72991.63972,	72995.91820,	73000.19670,	73004.47522,
73008.75377,	73013.03234,	73017.31094,	73021.58955,	73025.86819,	73030.14685,	73034.42554,	73038.70425,	73042.98298,	73047.26173,
73051.54051,	73055.81931,	73060.09813,	73064.37697,	73068.65584,	73072.93473,	73077.21365,	73081.49258,	73085.77154,	73090.05052,
73094.32953,	73098.60856,	73102.88761,	73107.16668,	73111.44578,	73115.72490,	73120.00404,	73124.28320,	73128.56239,	73132.84160,
73137.12083,	73141.40009,	73145.67937,	73149.95867,	73154.23800,	73158.51734,	73162.79671,	73167.07611,	73171.35552,	73175.63496,
73179.91442,	73184.19391,	73188.47341,	73192.75295,	73197.03250,	73201.31207,	73205.59167,	73209.87129,	73214.15094,	73218.43060,
73222.71029,	73226.99001,	73231.26974,	73235.54950,	73239.82928,	73244.10909,	73248.38891,	73252.66876,	73256.94863,	73261.22853,
73265.50845,	73269.78839,	73274.06835,	73278.34834,	73282.62835,	73286.90838,	73291.18843,	73295.46851,	73299.74861,	73304.02873,
73308.30888,	73312.58905,	73316.86924,	73321.14945,	73325.42969,	73329.70995,	73333.99023,	73338.27054,	73342.55086,	73346.83121,
73351.11159,	73355.39198,	73359.67240,	73363.95284,	73368.23331,	73372.51380,	73376.79431,	73381.07484,	73385.35539,	73389.63597,
73393.91657,	73398.19720,	73402.47784,	73406.75851,	73411.03921,	73415.31992,	73419.60066,	73423.88142,	73428.16220,	73432.44301,
73436.72384,	73441.00469,	73445.28556,	73449.56646,	73453.84738,	73458.12832,	73462.40929,	73466.69027,	73470.97129,	73475.25232,
73479.53337,	73483.81445,	73488.09556,	73492.37668,	73496.65783,	73500.93900,	73505.22019,	73509.50140,	73513.78264,	73518.06390,
73522.34519,	73526.62649,	73530.90782,	73535.18917,	73539.47055,	73543.75194,	73548.03336,	73552.31481,	73556.59627,	73560.87776,
73565.15927,	73569.44080,	73573.72236,	73578.00394,	73582.28554,	73586.56716,	73590.84881,	73595.13048,	73599.41217,	73603.69389,
73607.97562,	73612.25739,	73616.53917,	73620.82097,	73625.10280,	73629.38465,	73633.66653,	73637.94842,	73642.23034,	73646.51229,
73650.79425,	73655.07624,	73659.35825,	73663.64028,	73667.92234,	73672.20441,	73676.48651,	73680.76864,	73685.05078,	73689.33295,
73693.61514,	73697.89736,	73702.17959,	73706.46185,	73710.74414,	73715.02644,	73719.30877,	73723.59112,	73727.87349,	73732.15589,
73736.43831,	73740.72075,	73745.00321,	73749.28570,	73753.56820,	73757.85074,	73762.13329,	73766.41587,	73770.69847,	73774.98109,
73779.26373,	73783.54640,	73787.82909,	73792.11180,	73796.39454,	73800.67730,	73804.96008,	73809.24288,	73813.52571,	73817.80856,
73822.09143,	73826.37432,	73830.65724,	73834.94018,	73839.22314,	73843.50612,	73847.78913,	73852.07216,	73856.35521,	73860.63829,
73864.92138,	73869.20450,	73873.48765,	73877.77081,	73882.05400,	73886.33721,	73890.62045,	73894.90370,	73899.18698,	73903.47028,
73907.75360,	73912.03695,	73916.32032,	73920.60371,	73924.88713,	73929.17056,	73933.45402,	73937.73751,	73942.02101,	73946.30454,
73950.58809,	73954.87166,	73959.15525,	73963.43887,	73967.72251,	73972.00618,	73976.28986,	73980.57357,	73984.85730,	73989.14105,
73993.42483,	73997.70863,	74001.99245,	74006.27629,	74010.56016,	74014.84405,	74019.12796,	74023.41189,	74027.69585,	74031.97983,
74036.26383,	74040.54786,	74044.83190,	74049.11597,	74053.40007,	74057.68418,	74061.96832,	74066.25248,	74070.53666,	74074.82087,
74079.10509,	74083.38934,	74087.67362,	74091.95791,	74096.24223,	74100.52657,	74104.81093,	74109.09532,	74113.37973,	74117.66416,
74121.94861,	74126.23309,	74130.51758,	74134.80211,	74139.08665,	74143.37122,	74147.65580,	74151.94041,	74156.22505,	74160.50971,
74164.79438,	74169.07909,	74173.36381,	74177.64856,	74181.93332,	74186.21812,	74190.50293,	74194.78777,	74199.07263,	74203.35751,
74207.64241,	74211.92734,	74216.21229,	74220.49726,	74224.78225,	74229.06727,	74233.35231,	74237.63737,	74241.92246,	74246.20756,
74250.49269,	74254.77785,	74259.06302,	74263.34822,	74267.63344,	74271.91868,	74276.20394,	74280.48923,	74284.77454,	74289.05987,
74293.34523,	74297.63061,	74301.91601,	74306.20143,	74310.48687,	74314.77234,	74319.05783,	74323.34334,	74327.62888,	74331.91443,
74336.20001,	74340.48562,	74344.77124,	74349.05689,	74353.34256,	74357.62825,	74361.91396,	74366.19970,	74370.48546,	74374.77124,
74379.05705,	74383.34288,	74387.62873,	74391.91460,	74396.20049,	74400.48641,	74404.77235,	74409.05831,	74413.34430,	74417.63030,
74421.91633,	74426.20239,	74430.48846,	74434.77456,	74439.06068,	74443.34682,	74447.63298,	74451.91917,	74456.20538,	74460.49161,
74464.77787,	74469.06414,	74473.35044,	74477.63676,	74481.92311,	74486.20947,	74490.49586,	74494.78227,	74499.06871,	74503.35516,
74507.64164,	74511.92815,	74516.21467,	74520.50122,	74524.78778,	74529.07438,	74533.36099,	74537.64762,	74541.93428,	74546.22096,
74550.50767,	74554.79439,	74559.08114,	74563.36791,	74567.65471,	74571.94152,	74576.22836,	74580.51522,	74584.80210,	74589.08901,
74593.37594,	74597.66289,	74601.94986,	74606.23685,	74610.52387,	74614.81091,	74619.09797,	74623.38506,	74627.67217,	74631.95930,
74636.24645,	74640.53362,	74644.82082,	74649.10804,	74653.39528,	74657.68254,	74661.96983,	74666.25714,	74670.54447,	74674.83182,
74679.11920,	74683.40660,	74687.69402,	74691.98146,	74696.26893,	74700.55642,	74704.84393,	74709.13146,	74713.41902,	74717.70659,
74721.99419,	74726.28182,	74730.56946,	74734.85713,	74739.14482,	74743.43253,	74747.72027,	74752.00802,	74756.29580,	74760.58360,
74764.87143,	74769.15928,	74773.44714,	74777.73504,	74782.02295,	74786.31088,	74790.59884,	74794.88682,	74799.17483,	74803.46285,
74807.75090,	74812.03897,	74816.32706,	74820.61518,	74824.90332,	74829.19148,	74833.47966,	74837.76786,	74842.05609,	74846.34434,
74850.63261,	74854.92090,	74859.20922,	74863.49756,	74867.78592,	74872.07430,	74876.36271,	74880.65114,	74884.93959,	74889.22806,
74893.51656,	74897.80507,	74902.09361,	74906.38218,	74910.67076,	74914.95937,	74919.24800,	74923.53665,	74927.82532,	74932.11402,
74936.40274,	74940.69148,	74944.98024,	74949.26903,	74953.55783,	74957.84666,	74962.13552,	74966.42439,	74970.71329,	74975.00221,
74979.29115,	74983.58011,	74987.86910,	74992.15811,	74996.44714,	75000.73620,	75005.02527,	75009.31437,	75013.60349,	75017.89263,
75022.18180,	75026.47099,	75030.76020,	75035.04943,	75039.33868,	75043.62796,	75047.91726,	75052.20658,	75056.49592,	75060.78529,
75065.07468,	75069.36409,	75073.65352,	75077.94298,	75082.23245,	75086.52195,	75090.81147,	75095.10102,	75099.39059,	75103.68017,
75107.96979,	75112.25942,	75116.54907,	75120.83875,	75125.12845,	75129.41818,	75133.70792,	75137.99769,	75142.28748,	75146.57729,
75150.86712,	75155.15698,	75159.44686,	75163.73676,	75168.02668,	75172.31663,	75176.60660,	75180.89659,	75185.18660,	75189.47663,
75193.76669,	75198.05677,	75202.34687,	75206.63699,	75210.92714,	75215.21731,	75219.50750,	75223.79771,	75228.08795,	75232.37820,
75236.66848,	75240.95879,	75245.24911,	75249.53946,	75253.82982,	75258.12022,	75262.41063,	75266.70106,	75270.99152,	75275.28200,
75279.57250,	75283.86303,	75288.15357,	75292.44414,	75296.73473,	75301.02535,	75305.31598,	75309.60664,	75313.89732,	75318.18802,
75322.47875,	75326.76949,	75331.06026,	75335.35105,	75339.64187,	75343.93270,	75348.22356,	75352.51444,	75356.80534,	75361.09627,
75365.38721,	75369.67818,	75373.96918,	75378.26019,	75382.55122,	75386.84228,	75391.13336,	75395.42446,	75399.71559,	75404.00674,
75408.29790,	75412.58910,	75416.88031,	75421.17154,	75425.46280,	75429.75408,	75434.04539,	75438.33671,	75442.62806,	75446.91943,
75451.21082,	75455.50223,	75459.79366,	75464.08512,	75468.37660,	75472.66810,	75476.95963,	75481.25118,	75485.54274,	75489.83433,
75494.12595,	75498.41758,	75502.70924,	75507.00092,	75511.29262,	75515.58435,	75519.87609,	75524.16786,	75528.45965,	75532.75146,
75537.04330,	75541.33515,	75545.62703,	75549.91894,	75554.21086,	75558.50280,	75562.79477,	75567.08676,	75571.37878,	75575.67081,
75579.96287,	75584.25495,	75588.54705,	75592.83917,	75597.13131,	75601.42348,	75605.71567,	75610.00788,	75614.30012,	75618.59237,
75622.88465,	75627.17695,	75631.46927,	75635.76162,	75640.05399,	75644.34637,	75648.63879,	75652.93122,	75657.22367,	75661.51615,
75665.80865,	75670.10117,	75674.39372,	75678.68628,	75682.97887,	75687.27148,	75691.56412,	75695.85677,	75700.14945,	75704.44215,
75708.73487,	75713.02761,	75717.32038,	75721.61316,	75725.90597,	75730.19880,	75734.49166,	75738.78453,	75743.07743,	75747.37035,
75751.66330,	75755.95626,	75760.24925,	75764.54226,	75768.83529,	75773.12834,	75777.42141,	75781.71451,	75786.00763,	75790.30077,
75794.59394,	75798.88712,	75803.18033,	75807.47356,	75811.76681,	75816.06009,	75820.35338,	75824.64670,	75828.94004,	75833.23340,
75837.52679,	75841.82020,	75846.11362,	75850.40707,	75854.70055,	75858.99404,	75863.28756,	75867.58110,	75871.87466,	75876.16824,
75880.46185,	75884.75548,	75889.04913,	75893.34280,	75897.63649,	75901.93021,	75906.22395,	75910.51771,	75914.81149,	75919.10529,
75923.39912,	75927.69297,	75931.98684,	75936.28073,	75940.57465,	75944.86858,	75949.16254,	75953.45652,	75957.75053,	75962.04455,
75966.33860,	75970.63267,	75974.92676,	75979.22087,	75983.51501,	75987.80917,	75992.10335,	75996.39755,	76000.69177,	76004.98602,
76009.28028,	76013.57457,	76017.86889,	76022.16322,	76026.45758,	76030.75195,	76035.04635,	76039.34078,	76043.63522,	76047.92969,
76052.22418,	76056.51869,	76060.81322,	76065.10777,	76069.40235,	76073.69695,	76077.99157,	76082.28621,	76086.58087,	76090.87556,
76095.17027,	76099.46500,	76103.75975,	76108.05453,	76112.34932,	76116.64414,	76120.93898,	76125.23385,	76129.52873,	76133.82364,
76138.11857,	76142.41352,	76146.70849,	76151.00349,	76155.29850,	76159.59354,	76163.88860,	76168.18369,	76172.47879,	76176.77392,
76181.06907,	76185.36424,	76189.65943,	76193.95465,	76198.24988,	76202.54514,	76206.84043,	76211.13573,	76215.43105,	76219.72640,
76224.02177,	76228.31716,	76232.61257,	76236.90801,	76241.20347,	76245.49895,	76249.79445,	76254.08997,	76258.38551,	76262.68108,
76266.97667,	76271.27228,	76275.56792,	76279.86357,	76284.15925,	76288.45495,	76292.75067,	76297.04641,	76301.34218,	76305.63796,
76309.93377,	76314.22960,	76318.52545,	76322.82133,	76327.11723,	76331.41315,	76335.70909,	76340.00505,	76344.30103,	76348.59704,
76352.89307,	76357.18912,	76361.48519,	76365.78129,	76370.07740,	76374.37354,	76378.66970,	76382.96588,	76387.26209,	76391.55831,
76395.85456,	76400.15083,	76404.44713,	76408.74344,	76413.03978,	76417.33613,	76421.63251,	76425.92892,	76430.22534,	76434.52179,
76438.81825,	76443.11474,	76447.41125,	76451.70779,	76456.00434,	76460.30092,	76464.59752,	76468.89414,	76473.19078,	76477.48745,
76481.78414,	76486.08085,	76490.37758,	76494.67433,	76498.97110,	76503.26790,	76507.56472,	76511.86156,	76516.15842,	76520.45531,
76524.75221,	76529.04914,	76533.34609,	76537.64307,	76541.94006,	76546.23708,	76550.53411,	76554.83117,	76559.12825,	76563.42536,
76567.72248,	76572.01963,	76576.31680,	76580.61399,	76584.91121,	76589.20844,	76593.50570,	76597.80298,	76602.10028,	76606.39760,
76610.69494,	76614.99231,	76619.28970,	76623.58711,	76627.88454,	76632.18200,	76636.47947,	76640.77697,	76645.07449,	76649.37203,
76653.66959,	76657.96718,	76662.26479,	76666.56242,	76670.86007,	76675.15774,	76679.45544,	76683.75315,	76688.05089,	76692.34865,
76696.64643,	76700.94424,	76705.24206,	76709.53991,	76713.83778,	76718.13567,	76722.43359,	76726.73152,	76731.02948,	76735.32746,
76739.62546,	76743.92348,	76748.22153,	76752.51960,	76756.81768,	76761.11579,	76765.41393,	76769.71208,	76774.01026,	76778.30845,
76782.60667,	76786.90492,	76791.20318,	76795.50146,	76799.79977,	76804.09810,	76808.39645,	76812.69482,	76816.99322,	76821.29164,
76825.59007,	76829.88853,	76834.18702,	76838.48552,	76842.78404,	76847.08259,	76851.38116,	76855.67975,	76859.97837,	76864.27700,
76868.57566,	76872.87434,	76877.17304,	76881.47176,	76885.77050,	76890.06927,	76894.36806,	76898.66686,	76902.96570,	76907.26455,
76911.56342,	76915.86232,	76920.16124,	76924.46018,	76928.75914,	76933.05813,	76937.35713,	76941.65616,	76945.95521,	76950.25428,
76954.55337,	76958.85249,	76963.15162,	76967.45078,	76971.74996,	76976.04917,	76980.34839,	76984.64764,	76988.94690,	76993.24619,
76997.54550,	77001.84484,	77006.14419,	77010.44357,	77014.74297,	77019.04239,	77023.34183,	77027.64129,	77031.94078,	77036.24028,
77040.53981,	77044.83936,	77049.13894,	77053.43853,	77057.73815,	77062.03779,	77066.33745,	77070.63713,	77074.93683,	77079.23656,
77083.53630,	77087.83607,	77092.13586,	77096.43567,	77100.73551,	77105.03536,	77109.33524,	77113.63514,	77117.93506,	77122.23500,
77126.53497,	77130.83496,	77135.13496,	77139.43499,	77143.73505,	77148.03512,	77152.33521,	77156.63533,	77160.93547,	77165.23563,
77169.53581,	77173.83602,	77178.13624,	77182.43649,	77186.73676,	77191.03705,	77195.33736,	77199.63770,	77203.93805,	77208.23843,
77212.53883,	77216.83925,	77221.13970,	77225.44016,	77229.74065,	77234.04116,	77238.34169,	77242.64224,	77246.94281,	77251.24341,
77255.54403,	77259.84467,	77264.14533,	77268.44601,	77272.74671,	77277.04744,	77281.34819,	77285.64896,	77289.94975,	77294.25056,
77298.55139,	77302.85225,	77307.15313,	77311.45403,	77315.75495,	77320.05589,	77324.35686,	77328.65784,	77332.95885,	77337.25988,
77341.56093,	77345.86201,	77350.16310,	77354.46422,	77358.76536,	77363.06652,	77367.36770,	77371.66890,	77375.97013,	77380.27138,
77384.57264,	77388.87394,	77393.17525,	77397.47658,	77401.77794,	77406.07931,	77410.38071,	77414.68213,	77418.98358,	77423.28504,
77427.58653,	77431.88803,	77436.18956,	77440.49111,	77444.79269,	77449.09428,	77453.39590,	77457.69753,	77461.99919,	77466.30087,
77470.60258,	77474.90430,	77479.20605,	77483.50781,	77487.80960,	77492.11142,	77496.41325,	77500.71510,	77505.01698,	77509.31888,
77513.62080,	77517.92274,	77522.22470,	77526.52668,	77530.82869,	77535.13072,	77539.43277,	77543.73484,	77548.03693,	77552.33904,
77556.64118,	77560.94334,	77565.24552,	77569.54772,	77573.84994,	77578.15219,	77582.45445,	77586.75674,	77591.05905,	77595.36138,
77599.66373,	77603.96611,	77608.26850,	77612.57092,	77616.87336,	77621.17582,	77625.47830,	77629.78081,	77634.08333,	77638.38588,
77642.68845,	77646.99104,	77651.29365,	77655.59629,	77659.89894,	77664.20162,	77668.50432,	77672.80704,	77677.10978,	77681.41254,
77685.71533,	77690.01814,	77694.32096,	77698.62381,	77702.92669,	77707.22958,	77711.53249,	77715.83543,	77720.13839,	77724.44137,
77728.74437,	77733.04739,	77737.35044,	77741.65351,	77745.95659,	77750.25970,	77754.56283,	77758.86599,	77763.16916,	77767.47236,
77771.77558,	77776.07881,	77780.38208,	77784.68536,	77788.98866,	77793.29199,	77797.59533,	77801.89870,	77806.20209,	77810.50551,
77814.80894,	77819.11240,	77823.41587,	77827.71937,	77832.02289,	77836.32643,	77840.63000,	77844.93358,	77849.23719,	77853.54081,
77857.84446,	77862.14814,	77866.45183,	77870.75554,	77875.05928,	77879.36304,	77883.66681,	77887.97062,	77892.27444,	77896.57828,
77900.88215,	77905.18603,	77909.48994,	77913.79387,	77918.09782,	77922.40180,	77926.70579,	77931.00981,	77935.31385,	77939.61791,
77943.92199,	77948.22609,	77952.53021,	77956.83436,	77961.13853,	77965.44272,	77969.74693,	77974.05116,	77978.35541,	77982.65969,
77986.96398,	77991.26830,	77995.57264,	77999.87700,	78004.18138,	78008.48579,	78012.79021,	78017.09466,	78021.39913,	78025.70362,
78030.00813,	78034.31267,	78038.61722,	78042.92180,	78047.22640,	78051.53102,	78055.83566,	78060.14032,	78064.44501,	78068.74971,
78073.05444,	78077.35919,	78081.66396,	78085.96875,	78090.27356,	78094.57840,	78098.88326,	78103.18813,	78107.49303,	78111.79795,
78116.10290,	78120.40786,	78124.71285,	78129.01785,	78133.32288,	78137.62793,	78141.93301,	78146.23810,	78150.54321,	78154.84835,
78159.15351,	78163.45869,	78167.76389,	78172.06911,	78176.37435,	78180.67962,	78184.98491,	78189.29021,	78193.59554,	78197.90090,
78202.20627,	78206.51166,	78210.81708,	78215.12252,	78219.42798,	78223.73346,	78228.03896,	78232.34448,	78236.65003,	78240.95559,
78245.26118,	78249.56679,	78253.87242,	78258.17807,	78262.48375,	78266.78944,	78271.09516,	78275.40090,	78279.70666,	78284.01244,
78288.31824,	78292.62406,	78296.92991,	78301.23578,	78305.54166,	78309.84757,	78314.15351,	78318.45946,	78322.76543,	78327.07143,
78331.37745,	78335.68349,	78339.98955,	78344.29563,	78348.60173,	78352.90786,	78357.21400,	78361.52017,	78365.82636,	78370.13257,
78374.43880,	78378.74505,	78383.05133,	78387.35763,	78391.66394,	78395.97028,	78400.27664,	78404.58302,	78408.88943,	78413.19585,
78417.50230,	78421.80877,	78426.11526,	78430.42177,	78434.72830,	78439.03485,	78443.34143,	78447.64803,	78451.95464,	78456.26128,
78460.56794,	78464.87463,	78469.18133,	78473.48806,	78477.79480,	78482.10157,	78486.40836,	78490.71517,	78495.02200,	78499.32886,
78503.63573,	78507.94263,	78512.24955,	78516.55649,	78520.86345,	78525.17043,	78529.47743,	78533.78446,	78538.09150,	78542.39857,
78546.70566,	78551.01277,	78555.31990,	78559.62706,	78563.93423,	78568.24143,	78572.54865,	78576.85589,	78581.16315,	78585.47043,
78589.77773,	78594.08506,	78598.39240,	78602.69977,	78607.00716,	78611.31457,	78615.62200,	78619.92946,	78624.23693,	78628.54443,
78632.85194,	78637.15948,	78641.46704,	78645.77462,	78650.08223,	78654.38985,	78658.69750,	78663.00517,	78667.31285,	78671.62056,
78675.92829,	78680.23605,	78684.54382,	78688.85162,	78693.15943,	78697.46727,	78701.77513,	78706.08301,	78710.39091,	78714.69884,
78719.00678,	78723.31475,	78727.62274,	78731.93075,	78736.23878,	78740.54683,	78744.85490,	78749.16300,	78753.47111,	78757.77925,
78762.08741,	78766.39559,	78770.70379,	78775.01201,	78779.32026,	78783.62852,	78787.93681,	78792.24512,	78796.55345,	78800.86180,
78805.17017,	78809.47857,	78813.78698,	78818.09542,	78822.40387,	78826.71235,	78831.02085,	78835.32938,	78839.63792,	78843.94648,
78848.25507,	78852.56368,	78856.87230,	78861.18095,	78865.48963,	78869.79832,	78874.10703,	78878.41577,	78882.72452,	78887.03330,
78891.34210,	78895.65092,	78899.95976,	78904.26863,	78908.57751,	78912.88642,	78917.19534,	78921.50429,	78925.81326,	78930.12225,
78934.43126,	78938.74030,	78943.04935,	78947.35843,	78951.66753,	78955.97665,	78960.28579,	78964.59495,	78968.90413,	78973.21333,
78977.52256,	78981.83181,	78986.14107,	78990.45036,	78994.75967,	78999.06901,	79003.37836,	79007.68773,	79011.99713,	79016.30655,
79020.61599,	79024.92545,	79029.23493,	79033.54443,	79037.85395,	79042.16350,	79046.47306,	79050.78265,	79055.09226,	79059.40189,
79063.71154,	79068.02122,	79072.33091,	79076.64062,	79080.95036,	79085.26012,	79089.56990,	79093.87970,	79098.18952,	79102.49936,
79106.80923,	79111.11911,	79115.42902,	79119.73895,	79124.04890,	79128.35887,	79132.66886,	79136.97887,	79141.28891,	79145.59896,
79149.90904,	79154.21914,	79158.52926,	79162.83940,	79167.14956,	79171.45974,	79175.76995,	79180.08018,	79184.39042,	79188.70069,
79193.01098,	79197.32129,	79201.63162,	79205.94198,	79210.25235,	79214.56275,	79218.87316,	79223.18360,	79227.49406,	79231.80454,
79236.11505,	79240.42557,	79244.73611,	79249.04668,	79253.35727,	79257.66788,	79261.97850,	79266.28916,	79270.59983,	79274.91052,
79279.22124,	79283.53197,	79287.84273,	79292.15351,	79296.46431,	79300.77513,	79305.08597,	79309.39683,	79313.70772,	79318.01862,
79322.32955,	79326.64050,	79330.95147,	79335.26246,	79339.57347,	79343.88450,	79348.19556,	79352.50663,	79356.81773,	79361.12885,
79365.43998,	79369.75114,	79374.06233,	79378.37353,	79382.68475,	79386.99600,	79391.30726,	79395.61855,	79399.92986,	79404.24119,
79408.55254,	79412.86391,	79417.17531,	79421.48672,	79425.79816,	79430.10962,	79434.42109,	79438.73259,	79443.04411,	79447.35566,
79451.66722,	79455.97880,	79460.29041,	79464.60204,	79468.91368,	79473.22535,	79477.53704,	79481.84875,	79486.16049,	79490.47224,
79494.78402,	79499.09581,	79503.40763,	79507.71947,	79512.03133,	79516.34321,	79520.65511,	79524.96703,	79529.27898,	79533.59094,
79537.90293,	79542.21494,	79546.52697,	79550.83902,	79555.15109,	79559.46318,	79563.77530,	79568.08743,	79572.39959,	79576.71177,
79581.02396,	79585.33618,	79589.64842,	79593.96069,	79598.27297,	79602.58527,	79606.89760,	79611.20995,	79615.52231,	79619.83470,
79624.14711,	79628.45954,	79632.77200,	79637.08447,	79641.39697,	79645.70948,	79650.02202,	79654.33458,	79658.64716,	79662.95976,
79667.27238,	79671.58502,	79675.89768,	79680.21037,	79684.52308,	79688.83580,	79693.14855,	79697.46132,	79701.77411,	79706.08692,
79710.39976,	79714.71261,	79719.02549,	79723.33838,	79727.65130,	79731.96424,	79736.27720,	79740.59018,	79744.90318,	79749.21620,
79753.52925,	79757.84231,	79762.15540,	79766.46851,	79770.78164,	79775.09479,	79779.40796,	79783.72115,	79788.03436,	79792.34760,
79796.66085,	79800.97413,	79805.28743,	79809.60074,	79813.91408,	79818.22745,	79822.54083,	79826.85423,	79831.16765,	79835.48110,
79839.79457,	79844.10805,	79848.42156,	79852.73509,	79857.04864,	79861.36222,	79865.67581,	79869.98942,	79874.30306,	79878.61671,
79882.93039,	79887.24409,	79891.55781,	79895.87155,	79900.18531,	79904.49910,	79908.81290,	79913.12672,	79917.44057,	79921.75444,
79926.06833,	79930.38224,	79934.69617,	79939.01012,	79943.32409,	79947.63808,	79951.95210,	79956.26613,	79960.58019,	79964.89427,
79969.20837,	79973.52249,	79977.83663,	79982.15079,	79986.46498,	79990.77918,	79995.09341,	79999.40765,	80003.72192,	80008.03621,
80012.35052,	80016.66485,	80020.97920,	80025.29357,	80029.60797,	80033.92238,	80038.23682,	80042.55128,	80046.86575,	80051.18025,
80055.49477,	80059.80931,	80064.12388,	80068.43846,	80072.75306,	80077.06769,	80081.38234,	80085.69700,	80090.01169,	80094.32640,
80098.64113,	80102.95589,	80107.27066,	80111.58545,	80115.90027,	80120.21510,	80124.52996,	80128.84484,	80133.15974,	80137.47466,
80141.78960,	80146.10456,	80150.41954,	80154.73455,	80159.04957,	80163.36462,	80167.67969,	80171.99477,	80176.30988,	80180.62501,
80184.94017,	80189.25534,	80193.57053,	80197.88575,	80202.20098,	80206.51624,	80210.83151,	80215.14681,	80219.46213,	80223.77747,
80228.09283,	80232.40822,	80236.72362,	80241.03904,	80245.35449,	80249.66996,	80253.98544,	80258.30095,	80262.61648,	80266.93203,
80271.24760,	80275.56320,	80279.87881,	80284.19445,	80288.51010,	80292.82578,	80297.14147,	80301.45719,	80305.77293,	80310.08869,
80314.40447,	80318.72028,	80323.03610,	80327.35195,	80331.66781,	80335.98370,	80340.29960,	80344.61553,	80348.93148,	80353.24745,
80357.56344,	80361.87946,	80366.19549,	80370.51154,	80374.82762,	80379.14372,	80383.45983,	80387.77597,	80392.09213,	80396.40831,
80400.72451,	80405.04073,	80409.35698,	80413.67324,	80417.98952,	80422.30583,	80426.62216,	80430.93851,	80435.25487,	80439.57126,
80443.88767,	80448.20411,	80452.52056,	80456.83703,	80461.15353,	80465.47004,	80469.78658,	80474.10314,	80478.41971,	80482.73631,
80487.05293,	80491.36958,	80495.68624,	80500.00292,	80504.31962,	80508.63635,	80512.95310,	80517.26986,	80521.58665,	80525.90346,
80530.22029,	80534.53714,	80538.85401,	80543.17090,	80547.48782,	80551.80475,	80556.12171,	80560.43868,	80564.75568,	80569.07270,
80573.38974,	80577.70680,	80582.02388,	80586.34098,	80590.65810,	80594.97525,	80599.29241,	80603.60960,	80607.92680,	80612.24403,
80616.56128,	80620.87855,	80625.19584,	80629.51315,	80633.83048,	80638.14783,	80642.46521,	80646.78260,	80651.10002,	80655.41745,
80659.73491,	80664.05239,	80668.36989,	80672.68741,	80677.00495,	80681.32251,	80685.64009,	80689.95770,	80694.27532,	80698.59297,
80702.91064,	80707.22832,	80711.54603,	80715.86376,	80720.18151,	80724.49928,	80728.81707,	80733.13489,	80737.45272,	80741.77057,
80746.08845,	80750.40634,	80754.72426,	80759.04220,	80763.36016,	80767.67814,	80771.99614,	80776.31416,	80780.63220,	80784.95027,
80789.26835,	80793.58646,	80797.90458,	80802.22273,	80806.54090,	80810.85909,	80815.17729,	80819.49553,	80823.81378,	80828.13205,
80832.45034,	80836.76866,	80841.08699,	80845.40535,	80849.72372,	80854.04212,	80858.36054,	80862.67898,	80866.99744,	80871.31592,
80875.63442,	80879.95294,	80884.27148,	80888.59005,	80892.90863,	80897.22724,	80901.54587,	80905.86451,	80910.18318,	80914.50187,
80918.82058,	80923.13931,	80927.45806,	80931.77684,	80936.09563,	80940.41444,	80944.73328,	80949.05214,	80953.37101,	80957.68991,
80962.00883,	80966.32777,	80970.64673,	80974.96571,	80979.28471,	80983.60373,	80987.92278,	80992.24184,	80996.56093,	81000.88003,
81005.19916,	81009.51831,	81013.83748,	81018.15667,	81022.47588,	81026.79511,	81031.11436,	81035.43363,	81039.75293,	81044.07224,
81048.39157,	81052.71093,	81057.03031,	81061.34971,	81065.66912,	81069.98856,	81074.30802,	81078.62750,	81082.94701,	81087.26653,
81091.58607,	81095.90563,	81100.22522,	81104.54483,	81108.86445,	81113.18410,	81117.50377,	81121.82346,	81126.14317,	81130.46290,
81134.78265,	81139.10242,	81143.42221,	81147.74203,	81152.06186,	81156.38172,	81160.70159,	81165.02149,	81169.34141,	81173.66135,
81177.98130,	81182.30128,	81186.62129,	81190.94131,	81195.26135,	81199.58141,	81203.90150,	81208.22160,	81212.54173,	81216.86187,
81221.18204,	81225.50223,	81229.82244,	81234.14267,	81238.46292,	81242.78319,	81247.10348,	81251.42379,	81255.74412,	81260.06448,
81264.38485,	81268.70525,	81273.02567,	81277.34610,	81281.66656,	81285.98704,	81290.30754,	81294.62806,	81298.94860,	81303.26916,
81307.58974,	81311.91035,	81316.23097,	81320.55162,	81324.87228,	81329.19297,	81333.51367,	81337.83440,	81342.15515,	81346.47592,
81350.79671,	81355.11752,	81359.43835,	81363.75920,	81368.08008,	81372.40097,	81376.72188,	81381.04282,	81385.36378,	81389.68475,
81394.00575,	81398.32677,	81402.64781,	81406.96887,	81411.28995,	81415.61105,	81419.93217,	81424.25331,	81428.57448,	81432.89566,
81437.21686,	81441.53809,	81445.85934,	81450.18060,	81454.50189,	81458.82320,	81463.14453,	81467.46588,	81471.78725,	81476.10864,
81480.43005,	81484.75148,	81489.07294,	81493.39441,	81497.71591,	81502.03742,	81506.35896,	81510.68052,	81515.00209,	81519.32369,
81523.64531,	81527.96695,	81532.28861,	81536.61029,	81540.93200,	81545.25372,	81549.57546,	81553.89723,	81558.21901,	81562.54082,
81566.86264,	81571.18449,	81575.50636,	81579.82824,	81584.15015,	81588.47208,	81592.79403,	81597.11600,	81601.43800,	81605.76001,
81610.08204,	81614.40410,	81618.72617,	81623.04827,	81627.37038,	81631.69252,	81636.01467,	81640.33685,	81644.65905,	81648.98127,
81653.30351,	81657.62577,	81661.94805,	81666.27035,	81670.59268,	81674.91502,	81679.23738,	81683.55977,	81687.88217,	81692.20460,
81696.52705,	81700.84952,	81705.17200,	81709.49451,	81713.81704,	81718.13959,	81722.46216,	81726.78475,	81731.10737,	81735.43000,
81739.75265,	81744.07533,	81748.39802,	81752.72074,	81757.04347,	81761.36623,	81765.68901,	81770.01180,	81774.33462,	81778.65746,
81782.98032,	81787.30320,	81791.62610,	81795.94903,	81800.27197,	81804.59493,	81808.91791,	81813.24092,	81817.56394,	81821.88699,
81826.21006,	81830.53314,	81834.85625,	81839.17938,	81843.50253,	81847.82570,	81852.14889,	81856.47210,	81860.79533,	81865.11858,
81869.44185,	81873.76515,	81878.08846,	81882.41180,	81886.73515,	81891.05853,	81895.38192,	81899.70534,	81904.02878,	81908.35224,
81912.67572,	81916.99922,	81921.32274,	81925.64628,	81929.96984,	81934.29342,	81938.61702,	81942.94065,	81947.26429,	81951.58796,
81955.91164,	81960.23535,	81964.55907,	81968.88282,	81973.20659,	81977.53038,	81981.85418,	81986.17801,	81990.50186,	81994.82573,
81999.14963,	82003.47354,	82007.79747,	82012.12142,	82016.44540,	82020.76939,	82025.09341,	82029.41744,	82033.74150,	82038.06557,
82042.38967,	82046.71379,	82051.03793,	82055.36209,	82059.68627,	82064.01047,	82068.33469,	82072.65893,	82076.98319,	82081.30747,
82085.63177,	82089.95610,	82094.28044,	82098.60481,	82102.92919,	82107.25360,	82111.57802,	82115.90247,	82120.22694,	82124.55143,
82128.87594,	82133.20047,	82137.52502,	82141.84959,	82146.17418,	82150.49879,	82154.82342,	82159.14807,	82163.47275,	82167.79744,
82172.12216,	82176.44689,	82180.77165,	82185.09642,	82189.42122,	82193.74604,	82198.07087,	82202.39573,	82206.72061,	82211.04551,
82215.37043,	82219.69537,	82224.02033,	82228.34532,	82232.67032,	82236.99534,	82241.32038,	82245.64545,	82249.97053,	82254.29564,
82258.62076,	82262.94591,	82267.27107,	82271.59626,	82275.92147,	82280.24670,	82284.57195,	82288.89722,	82293.22251,	82297.54782,
82301.87315,	82306.19850,	82310.52387,	82314.84926,	82319.17468,	82323.50011,	82327.82556,	82332.15104,	82336.47653,	82340.80205,
82345.12759,	82349.45314,	82353.77872,	82358.10432,	82362.42994,	82366.75557,	82371.08123,	82375.40691,	82379.73261,	82384.05833,
82388.38408,	82392.70984,	82397.03562,	82401.36142,	82405.68725,	82410.01309,	82414.33895,	82418.66484,	82422.99075,	82427.31667,
82431.64262,	82435.96858,	82440.29457,	82444.62058,	82448.94661,	82453.27266,	82457.59873,	82461.92482,	82466.25093,	82470.57706,
82474.90321,	82479.22938,	82483.55557,	82487.88179,	82492.20802,	82496.53427,	82500.86055,	82505.18684,	82509.51316,	82513.83949,
82518.16585,	82522.49223,	82526.81863,	82531.14504,	82535.47148,	82539.79794,	82544.12442,	82548.45092,	82552.77744,	82557.10398,
82561.43054,	82565.75712,	82570.08372,	82574.41035,	82578.73699,	82583.06365,	82587.39034,	82591.71704,	82596.04377,	82600.37051,
82604.69728,	82609.02406,	82613.35087,	82617.67770,	82622.00455,	82626.33141,	82630.65830,	82634.98521,	82639.31214,	82643.63909,
82647.96606,	82652.29305,	82656.62006,	82660.94710,	82665.27415,	82669.60122,	82673.92831,	82678.25543,	82682.58256,	82686.90972,
82691.23689,	82695.56409,	82699.89130,	82704.21854,	82708.54580,	82712.87307,	82717.20037,	82721.52769,	82725.85503,	82730.18239,
82734.50977,	82738.83717,	82743.16459,	82747.49203,	82751.81949,	82756.14697,	82760.47447,	82764.80199,	82769.12954,	82773.45710,
82777.78468,	82782.11229,	82786.43991,	82790.76756,	82795.09522,	82799.42291,	82803.75061,	82808.07834,	82812.40609,	82816.73386,
82821.06164,	82825.38945,	82829.71728,	82834.04513,	82838.37300,	82842.70089,	82847.02880,	82851.35673,	82855.68468,	82860.01265,
82864.34065,	82868.66866,	82872.99669,	82877.32474,	82881.65282,	82885.98091,	82890.30903,	82894.63716,	82898.96532,	82903.29349,
82907.62169,	82911.94990,	82916.27814,	82920.60640,	82924.93468,	82929.26297,	82933.59129,	82937.91963,	82942.24799,	82946.57637,
82950.90477,	82955.23319,	82959.56163,	82963.89009,	82968.21857,	82972.54708,	82976.87560,	82981.20414,	82985.53270,	82989.86129,
82994.18989,	82998.51852,	83002.84716,	83007.17582,	83011.50451,	83015.83322,	83020.16194,	83024.49069,	83028.81946,	83033.14824,
83037.47705,	83041.80588,	83046.13473,	83050.46360,	83054.79248,	83059.12139,	83063.45032,	83067.77927,	83072.10824,	83076.43723,
83080.76625,	83085.09528,	83089.42433,	83093.75340,	83098.08249,	83102.41161,	83106.74074,	83111.06989,	83115.39907,	83119.72826,
83124.05748,	83128.38671,	83132.71597,	83137.04524,	83141.37454,	83145.70386,	83150.03319,	83154.36255,	83158.69193,	83163.02133,
83167.35074,	83171.68018,	83176.00964,	83180.33912,	83184.66862,	83188.99814,	83193.32768,	83197.65724,	83201.98682,	83206.31642,
83210.64605,	83214.97569,	83219.30535,	83223.63503,	83227.96473,	83232.29446,	83236.62420,	83240.95397,	83245.28375,	83249.61355,
83253.94338,	83258.27322,	83262.60309,	83266.93298,	83271.26288,	83275.59281,	83279.92275,	83284.25272,	83288.58271,	83292.91272,
83297.24275,	83301.57279,	83305.90286,	83310.23295,	83314.56306,	83318.89319,	83323.22334,	83327.55351,	83331.88370,	83336.21391,
83340.54414,	83344.87439,	83349.20467,	83353.53496,	83357.86527,	83362.19560,	83366.52596,	83370.85633,	83375.18672,	83379.51714,
83383.84757,	83388.17802,	83392.50850,	83396.83899,	83401.16951,	83405.50004,	83409.83060,	83414.16118,	83418.49177,	83422.82239,
83427.15303,	83431.48368,	83435.81436,	83440.14506,	83444.47578,	83448.80652,	83453.13727,	83457.46805,	83461.79885,	83466.12967,
83470.46051,	83474.79137,	83479.12225,	83483.45315,	83487.78407,	83492.11501,	83496.44598,	83500.77696,	83505.10796,	83509.43898,
83513.77002,	83518.10109,	83522.43217,	83526.76327,	83531.09440,	83535.42554,	83539.75670,	83544.08789,	83548.41909,	83552.75032,
83557.08156,	83561.41283,	83565.74411,	83570.07542,	83574.40674,	83578.73809,	83583.06946,	83587.40084,	83591.73225,	83596.06368,
83600.39513,	83604.72659,	83609.05808,	83613.38959,	83617.72112,	83622.05267,	83626.38424,	83630.71583,	83635.04744,	83639.37907,
83643.71072,	83648.04239,	83652.37408,	83656.70579,	83661.03752,	83665.36927,	83669.70104,	83674.03283,	83678.36464,	83682.69648,
83687.02833,	83691.36020,	83695.69209,	83700.02401,	83704.35594,	83708.68789,	83713.01987,	83717.35186,	83721.68387,	83726.01591,
83730.34796,	83734.68004,	83739.01213,	83743.34425,	83747.67638,	83752.00854,	83756.34071,	83760.67291,	83765.00513,	83769.33736,
83773.66962,	83778.00190,	83782.33419,	83786.66651,	83790.99885,	83795.33121,	83799.66358,	83803.99598,	83808.32840,	83812.66084,
83816.99330,	83821.32578,	83825.65827,	83829.99079,	83834.32333,	83838.65589,	83842.98847,	83847.32107,	83851.65369,	83855.98633,
83860.31899,	83864.65167,	83868.98438,	83873.31710,	83877.64984,	83881.98260,	83886.31538,	83890.64818,	83894.98101,	83899.31385,
83903.64671,	83907.97959,	83912.31250,	83916.64542,	83920.97836,	83925.31133,	83929.64431,	83933.97731,	83938.31034,	83942.64338,
83946.97644,	83951.30953,	83955.64263,	83959.97576,	83964.30890,	83968.64207,	83972.97525,	83977.30846,	83981.64168,	83985.97493,
83990.30820,	83994.64148,	83998.97479,	84003.30811,	84007.64146,	84011.97483,	84016.30821,	84020.64162,	84024.97505,	84029.30850,
84033.64196,	84037.97545,	84042.30896,	84046.64249,	84050.97603,	84055.30960,	84059.64319,	84063.97680,	84068.31043,	84072.64408,
84076.97775,	84081.31143,	84085.64514,	84089.97887,	84094.31262,	84098.64639,	84102.98018,	84107.31399,	84111.64782,	84115.98167,
84120.31554,	84124.64943,	84128.98334,	84133.31727,	84137.65122,	84141.98520,	84146.31919,	84150.65320,	84154.98723,	84159.32128,
84163.65535,	84167.98944,	84172.32356,	84176.65769,	84180.99184,	84185.32601,	84189.66020,	84193.99442,	84198.32865,	84202.66290,
84206.99717,	84211.33147,	84215.66578,	84220.00011,	84224.33447,	84228.66884,	84233.00323,	84237.33765,	84241.67208,	84246.00653,
84250.34101,	84254.67550,	84259.01002,	84263.34455,	84267.67910,	84272.01368,	84276.34827,	84280.68289,	84285.01752,	84289.35218,
84293.68685,	84298.02155,	84302.35626,	84306.69100,	84311.02575,	84315.36053,	84319.69532,	84324.03014,	84328.36497,	84332.69983,
84337.03471,	84341.36960,	84345.70452,	84350.03945,	84354.37441,	84358.70939,	84363.04438,	84367.37940,	84371.71444,	84376.04949,
84380.38457,	84384.71967,	84389.05478,	84393.38992,	84397.72508,	84402.06025,	84406.39545,	84410.73067,	84415.06590,	84419.40116,
84423.73644,	84428.07174,	84432.40705,	84436.74239,	84441.07775,	84445.41313,	84449.74852,	84454.08394,	84458.41938,	84462.75484,
84467.09032,	84471.42581,	84475.76133,	84480.09687,	84484.43243,	84488.76801,	84493.10360,	84497.43922,	84501.77486,	84506.11052,
84510.44620,	84514.78190,	84519.11762,	84523.45335,	84527.78911,	84532.12489,	84536.46069,	84540.79651,	84545.13235,	84549.46821,
84553.80409,	84558.13998,	84562.47590,	84566.81184,	84571.14780,	84575.48378,	84579.81978,	84584.15580,	84588.49184,	84592.82790,
84597.16398,	84601.50008,	84605.83620,	84610.17234,	84614.50849,	84618.84467,	84623.18087,	84627.51709,	84631.85333,	84636.18959,
84640.52587,	84644.86217,	84649.19849,	84653.53483,	84657.87119,	84662.20757,	84666.54397,	84670.88039,	84675.21683,	84679.55329,
84683.88977,	84688.22627,	84692.56279,	84696.89933,	84701.23589,	84705.57247,	84709.90907,	84714.24569,	84718.58233,	84722.91899,
84727.25567,	84731.59237,	84735.92909,	84740.26583,	84744.60259,	84748.93937,	84753.27617,	84757.61299,	84761.94983,	84766.28668,
84770.62356,	84774.96046,	84779.29738,	84783.63432,	84787.97128,	84792.30826,	84796.64526,	84800.98228,	84805.31932,	84809.65638,
84813.99346,	84818.33056,	84822.66768,	84827.00482,	84831.34198,	84835.67916,	84840.01636,	84844.35358,	84848.69082,	84853.02808,
84857.36536,	84861.70266,	84866.03998,	84870.37732,	84874.71468,	84879.05206,	84883.38946,	84887.72687,	84892.06431,	84896.40177,
84900.73925,	84905.07675,	84909.41427,	84913.75181,	84918.08937,	84922.42695,	84926.76455,	84931.10217,	84935.43980,	84939.77746,
84944.11514,	84948.45284,	84952.79056,	84957.12830,	84961.46606,	84965.80384,	84970.14163,	84974.47945,	84978.81729,	84983.15515,
84987.49303,	84991.83093,	84996.16884,	85000.50678,	85004.84474,	85009.18272,	85013.52072,	85017.85874,	85022.19677,	85026.53483,
85030.87291,	85035.21101,	85039.54912,	85043.88726,	85048.22542,	85052.56360,	85056.90179,	85061.24001,	85065.57825,	85069.91651,
85074.25478,	85078.59308,	85082.93140,	85087.26973,	85091.60809,	85095.94647,	85100.28487,	85104.62328,	85108.96172,	85113.30017,
85117.63865,	85121.97715,	85126.31566,	85130.65420,	85134.99276,	85139.33133,	85143.66993,	85148.00854,	85152.34718,	85156.68584,
85161.02451,	85165.36321,	85169.70192,	85174.04066,	85178.37941,	85182.71819,	85187.05698,	85191.39580,	85195.73463,	85200.07349,
85204.41236,	85208.75126,	85213.09017,	85217.42911,	85221.76806,	85226.10703,	85230.44603,	85234.78504,	85239.12408,	85243.46313,
85247.80220,	85252.14130,	85256.48041,	85260.81954,	85265.15870,	85269.49787,	85273.83706,	85278.17628,	85282.51551,	85286.85476,
85291.19403,	85295.53333,	85299.87264,	85304.21197,	85308.55132,	85312.89069,	85317.23009,	85321.56950,	85325.90893,	85330.24838,
85334.58785,	85338.92734,	85343.26685,	85347.60638,	85351.94594,	85356.28551,	85360.62510,	85364.96471,	85369.30434,	85373.64399,
85377.98366,	85382.32335,	85386.66306,	85391.00279,	85395.34254,	85399.68231,	85404.02210,	85408.36190,	85412.70173,	85417.04158,
85421.38145,	85425.72134,	85430.06125,	85434.40118,	85438.74112,	85443.08109,	85447.42108,	85451.76109,	85456.10111,	85460.44116,
85464.78123,	85469.12132,	85473.46142,	85477.80155,	85482.14170,	85486.48186,	85490.82205,	85495.16225,	85499.50248,	85503.84273,
85508.18299,	85512.52328,	85516.86358,	85521.20391,	85525.54425,	85529.88462,	85534.22500,	85538.56541,	85542.90583,	85547.24627,
85551.58674,	85555.92722,	85560.26773,	85564.60825,	85568.94879,	85573.28936,	85577.62994,	85581.97054,	85586.31116,	85590.65181,
85594.99247,	85599.33315,	85603.67385,	85608.01457,	85612.35532,	85616.69608,	85621.03686,	85625.37766,	85629.71848,	85634.05932,
85638.40018,	85642.74106,	85647.08196,	85651.42288,	85655.76382,	85660.10478,	85664.44576,	85668.78676,	85673.12778,	85677.46882,
85681.80987,	85686.15095,	85690.49205,	85694.83317,	85699.17431,	85703.51546,	85707.85664,	85712.19784,	85716.53905,	85720.88029,
85725.22155,	85729.56282,	85733.90412,	85738.24544,	85742.58677,	85746.92813,	85751.26950,	85755.61090,	85759.95231,	85764.29375,
85768.63520,	85772.97667,	85777.31817,	85781.65968,	85786.00121,	85790.34277,	85794.68434,	85799.02593,	85803.36755,	85807.70918,
85812.05083,	85816.39250,	85820.73419,	85825.07591,	85829.41764,	85833.75939,	85838.10116,	85842.44295,	85846.78476,	85851.12659,
85855.46844,	85859.81031,	85864.15220,	85868.49411,	85872.83604,	85877.17799,	85881.51995,	85885.86194,	85890.20395,	85894.54598,
85898.88802,	85903.23009,	85907.57218,	85911.91429,	85916.25641,	85920.59856,	85924.94072,	85929.28291,	85933.62512,	85937.96734,
85942.30959,	85946.65185,	85950.99413,	85955.33644,	85959.67876,	85964.02111,	85968.36347,	85972.70585,	85977.04826,	85981.39068,
85985.73312,	85990.07558,	85994.41807,	85998.76057,	86003.10309,	86007.44563,	86011.78819,	86016.13077,	86020.47337,	86024.81599,
86029.15863,	86033.50129,	86037.84397,	86042.18667,	86046.52939,	86050.87213,	86055.21488,	86059.55766,	86063.90046,	86068.24328,
86072.58611,	86076.92897,	86081.27185,	86085.61474,	86089.95766,	86094.30060,	86098.64355,	86102.98653,	86107.32952,	86111.67253,
86116.01557,	86120.35862,	86124.70170,	86129.04479,	86133.38790,	86137.73104,	86142.07419,	86146.41736,	86150.76055,	86155.10376,
86159.44700,	86163.79025,	86168.13352,	86172.47681,	86176.82012,	86181.16345,	86185.50680,	86189.85017,	86194.19355,	86198.53696,
86202.88039,	86207.22384,	86211.56731,	86215.91079,	86220.25430,	86224.59783,	86228.94137,	86233.28494,	86237.62853,	86241.97213,
86246.31576,	86250.65940,	86255.00307,	86259.34675,	86263.69046,	86268.03418,	86272.37792,	86276.72169,	86281.06547,	86285.40927,
86289.75309,	86294.09693,	86298.44080,	86302.78468,	86307.12858,	86311.47250,	86315.81644,	86320.16040,	86324.50438,	86328.84838,
86333.19239,	86337.53643,	86341.88049,	86346.22457,	86350.56867,	86354.91278,	86359.25692,	86363.60108,	86367.94525,	86372.28945,
86376.63366,	86380.97790,	86385.32215,	86389.66643,	86394.01072,	86398.35503,	86402.69937,	86407.04372,	86411.38809,	86415.73249,
86420.07690,	86424.42133,	86428.76578,	86433.11025,	86437.45474,	86441.79925,	86446.14378,	86450.48833,	86454.83290,	86459.17749,
86463.52210,	86467.86673,	86472.21137,	86476.55604,	86480.90073,	86485.24543,	86489.59016,	86493.93491,	86498.27967,	86502.62446,
86506.96926,	86511.31409,	86515.65893,	86520.00379,	86524.34868,	86528.69358,	86533.03850,	86537.38344,	86541.72841,	86546.07339,
86550.41839,	86554.76341,	86559.10845,	86563.45351,	86567.79859,	86572.14369,	86576.48881,	86580.83395,	86585.17910,	86589.52428,
86593.86948,	86598.21470,	86602.55993,	86606.90519,	86611.25046,	86615.59576,	86619.94107,	86624.28641,	86628.63176,	86632.97714,
86637.32253,	86641.66794,	86646.01337,	86650.35883,	86654.70430,	86659.04979,	86663.39530,	86667.74083,	86672.08638,	86676.43195,
86680.77754,	86685.12315,	86689.46878,	86693.81443,	86698.16009,	86702.50578,	86706.85149,	86711.19722,	86715.54296,	86719.88873,
86724.23451,	86728.58032,	86732.92614,	86737.27199,	86741.61785,	86745.96373,	86750.30964,	86754.65556,	86759.00150,	86763.34746,
86767.69344,	86772.03944,	86776.38546,	86780.73150,	86785.07756,	86789.42364,	86793.76974,	86798.11586,	86802.46200,	86806.80815,
86811.15433,	86815.50053,	86819.84674,	86824.19298,	86828.53923,	86832.88551,	86837.23180,	86841.57812,	86845.92445,	86850.27080,
86854.61718,	86858.96357,	86863.30998,	86867.65641,	86872.00286,	86876.34933,	86880.69582,	86885.04233,	86889.38886,	86893.73541,
86898.08198,	86902.42856,	86906.77517,	86911.12180,	86915.46844,	86919.81511,	86924.16180,	86928.50850,	86932.85522,	86937.20197,
86941.54873,	86945.89552,	86950.24232,	86954.58914,	86958.93598,	86963.28284,	86967.62972,	86971.97662,	86976.32354,	86980.67048,
86985.01744,	86989.36442,	86993.71142,	86998.05844,	87002.40547,	87006.75253,	87011.09961,	87015.44670,	87019.79382,	87024.14095,
87028.48811,	87032.83528,	87037.18247,	87041.52969,	87045.87692,	87050.22417,	87054.57144,	87058.91873,	87063.26605,	87067.61338,
87071.96072,	87076.30809,	87080.65548,	87085.00289,	87089.35032,	87093.69776,	87098.04523,	87102.39272,	87106.74022,	87111.08775,
87115.43529,	87119.78286,	87124.13044,	87128.47804,	87132.82567,	87137.17331,	87141.52097,	87145.86865,	87150.21635,	87154.56407,
87158.91181,	87163.25957,	87167.60735,	87171.95515,	87176.30297,	87180.65080,	87184.99866,	87189.34654,	87193.69443,	87198.04235,
87202.39028,	87206.73824,	87211.08621,	87215.43420,	87219.78222,	87224.13025,	87228.47830,	87232.82637,	87237.17446,	87241.52257,
87245.87070,	87250.21885,	87254.56702,	87258.91521,	87263.26341,	87267.61164,	87271.95989,	87276.30815,	87280.65644,	87285.00474,
87289.35307,	87293.70141,	87298.04977,	87302.39816,	87306.74656,	87311.09498,	87315.44342,	87319.79188,	87324.14036,	87328.48886,
87332.83738,	87337.18592,	87341.53448,	87345.88306,	87350.23165,	87354.58027,	87358.92891,	87363.27756,	87367.62624,	87371.97493,
87376.32364,	87380.67238,	87385.02113,	87389.36990,	87393.71869,	87398.06750,	87402.41633,	87406.76518,	87411.11405,	87415.46294,
87419.81185,	87424.16078,	87428.50972,	87432.85869,	87437.20768,	87441.55668,	87445.90571,	87450.25475,	87454.60381,	87458.95290,
87463.30200,	87467.65112,	87472.00026,	87476.34943,	87480.69861,	87485.04781,	87489.39702,	87493.74626,	87498.09552,	87502.44480,
87506.79410,	87511.14341,	87515.49275,	87519.84210,	87524.19148,	87528.54087,	87532.89029,	87537.23972,	87541.58917,	87545.93864,
87550.28813,	87554.63764,	87558.98717,	87563.33672,	87567.68629,	87572.03588,	87576.38549,	87580.73512,	87585.08476,	87589.43443,
87593.78411,	87598.13382,	87602.48354,	87606.83329,	87611.18305,	87615.53283,	87619.88263,	87624.23246,	87628.58230,	87632.93216,
87637.28204,	87641.63193,	87645.98185,	87650.33179,	87654.68175,	87659.03172,	87663.38172,	87667.73174,	87672.08177,	87676.43182,
87680.78190,	87685.13199,	87689.48210,	87693.83223,	87698.18239,	87702.53256,	87706.88275,	87711.23295,	87715.58318,	87719.93343,
87724.28370,	87728.63399,	87732.98429,	87737.33462,	87741.68496,	87746.03533,	87750.38571,	87754.73611,	87759.08654,	87763.43698,
87767.78744,	87772.13792,	87776.48842,	87780.83894,	87785.18948,	87789.54004,	87793.89061,	87798.24121,	87802.59183,	87806.94246,
87811.29312,	87815.64379,	87819.99449,	87824.34520,	87828.69593,	87833.04668,	87837.39745,	87841.74824,	87846.09905,	87850.44988,
87854.80073,	87859.15160,	87863.50249,	87867.85339,	87872.20432,	87876.55527,	87880.90623,	87885.25721,	87889.60822,	87893.95924,
87898.31028,	87902.66134,	87907.01243,	87911.36353,	87915.71465,	87920.06578,	87924.41694,	87928.76812,	87933.11932,	87937.47053,
87941.82177,	87946.17302,	87950.52430,	87954.87559,	87959.22691,	87963.57824,	87967.92959,	87972.28096,	87976.63235,	87980.98376,
87985.33519,	87989.68664,	87994.03811,	87998.38959,	88002.74110,	88007.09263,	88011.44417,	88015.79574,	88020.14732,	88024.49892,
88028.85054,	88033.20219,	88037.55385,	88041.90553,	88046.25723,	88050.60895,	88054.96068,	88059.31244,	88063.66422,	88068.01602,
88072.36783,	88076.71967,	88081.07152,	88085.42339,	88089.77529,	88094.12720,	88098.47913,	88102.83108,	88107.18305,	88111.53504,
88115.88705,	88120.23908,	88124.59113,	88128.94319,	88133.29528,	88137.64738,	88141.99951,	88146.35165,	88150.70381,	88155.05600,
88159.40820,	88163.76042,	88168.11266,	88172.46492,	88176.81720,	88181.16950,	88185.52182,	88189.87415,	88194.22651,	88198.57888,
88202.93128,	88207.28369,	88211.63613,	88215.98858,	88220.34105,	88224.69354,	88229.04605,	88233.39858,	88237.75113,	88242.10370,
88246.45629,	88250.80889,	88255.16152,	88259.51417,	88263.86683,	88268.21952,	88272.57222,	88276.92494,	88281.27768,	88285.63044,
88289.98322,	88294.33602,	88298.68884,	88303.04168,	88307.39454,	88311.74742,	88316.10031,	88320.45323,	88324.80616,	88329.15912,
88333.51209,	88337.86508,	88342.21809,	88346.57112,	88350.92417,	88355.27724,	88359.63033,	88363.98344,	88368.33657,	88372.68972,
88377.04288,	88381.39607,	88385.74927,	88390.10249,	88394.45574,	88398.80900,	88403.16228,	88407.51558,	88411.86890,	88416.22224,
88420.57560,	88424.92898,	88429.28237,	88433.63579,	88437.98922,	88442.34268,	88446.69615,	88451.04965,	88455.40316,	88459.75669,
88464.11024,	88468.46381,	88472.81740,	88477.17101,	88481.52464,	88485.87828,	88490.23195,	88494.58563,	88498.93934,	88503.29306,
88507.64681,	88512.00057,	88516.35435,	88520.70815,	88525.06197,	88529.41581,	88533.76967,	88538.12355,	88542.47744,	88546.83136,
88551.18530,	88555.53925,	88559.89322,	88564.24722,	88568.60123,	88572.95526,	88577.30931,	88581.66338,	88586.01747,	88590.37158,
88594.72571,	88599.07985,	88603.43402,	88607.78821,	88612.14241,	88616.49663,	88620.85088,	88625.20514,	88629.55942,	88633.91372,
88638.26804,	88642.62238,	88646.97674,	88651.33111,	88655.68551,	88660.03993,	88664.39436,	88668.74882,	88673.10329,	88677.45778,
88681.81229,	88686.16683,	88690.52138,	88694.87594,	88699.23053,	88703.58514,	88707.93977,	88712.29441,	88716.64908,	88721.00376,
88725.35847,	88729.71319,	88734.06793,	88738.42269,	88742.77747,	88747.13227,	88751.48709,	88755.84193,	88760.19679,	88764.55167,
88768.90656,	88773.26148,	88777.61641,	88781.97136,	88786.32634,	88790.68133,	88795.03634,	88799.39137,	88803.74642,	88808.10148,
88812.45657,	88816.81168,	88821.16680,	88825.52195,	88829.87711,	88834.23230,	88838.58750,	88842.94272,	88847.29796,	88851.65322,
88856.00850,	88860.36380,	88864.71912,	88869.07445,	88873.42981,	88877.78518,	88882.14058,	88886.49599,	88890.85142,	88895.20687,
88899.56234,	88903.91783,	88908.27334,	88912.62887,	88916.98442,	88921.33999,	88925.69557,	88930.05118,	88934.40680,	88938.76244,
88943.11810,	88947.47379,	88951.82949,	88956.18521,	88960.54094,	88964.89670,	88969.25248,	88973.60828,	88977.96409,	88982.31993,
88986.67578,	88991.03165,	88995.38754,	88999.74346,	89004.09939,	89008.45533,	89012.81130,	89017.16729,	89021.52330,	89025.87932,
89030.23537,	89034.59143,	89038.94752,	89043.30362,	89047.65974,	89052.01588,	89056.37204,	89060.72822,	89065.08442,	89069.44063,
89073.79687,	89078.15313,	89082.50940,	89086.86569,	89091.22201,	89095.57834,	89099.93469,	89104.29106,	89108.64745,	89113.00386,
89117.36028,	89121.71673,	89126.07320,	89130.42968,	89134.78619,	89139.14271,	89143.49925,	89147.85581,	89152.21239,	89156.56899,
89160.92561,	89165.28225,	89169.63890,	89173.99558,	89178.35228,	89182.70899,	89187.06572,	89191.42247,	89195.77925,	89200.13604,
89204.49285,	89208.84967,	89213.20652,	89217.56339,	89221.92028,	89226.27718,	89230.63410,	89234.99105,	89239.34801,	89243.70499,
89248.06199,	89252.41901,	89256.77605,	89261.13311,	89265.49018,	89269.84728,	89274.20440,	89278.56153,	89282.91868,	89287.27586,
89291.63305,	89295.99026,	89300.34749,	89304.70474,	89309.06200,	89313.41929,	89317.77660,	89322.13392,	89326.49126,	89330.84863,
89335.20601,	89339.56341,	89343.92083,	89348.27827,	89352.63573,	89356.99321,	89361.35070,	89365.70822,	89370.06575,	89374.42331,
89378.78088,	89383.13847,	89387.49608,	89391.85371,	89396.21136,	89400.56903,	89404.92672,	89409.28442,	89413.64215,	89417.99989,
89422.35766,	89426.71544,	89431.07324,	89435.43106,	89439.78890,	89444.14676,	89448.50464,	89452.86253,	89457.22045,	89461.57838,
89465.93634,	89470.29431,	89474.65230,	89479.01031,	89483.36834,	89487.72639,	89492.08446,	89496.44255,	89500.80065,	89505.15878,
89509.51692,	89513.87509,	89518.23327,	89522.59147,	89526.94969,	89531.30793,	89535.66619,	89540.02447,	89544.38276,	89548.74108,
89553.09941,	89557.45777,	89561.81614,	89566.17453,	89570.53294,	89574.89137,	89579.24982,	89583.60829,	89587.96678,	89592.32528,
89596.68381,	89601.04235,	89605.40091,	89609.75950,	89614.11810,	89618.47672,	89622.83536,	89627.19401,	89631.55269,	89635.91139,
89640.27010,	89644.62884,	89648.98759,	89653.34636,	89657.70515,	89662.06396,	89666.42279,	89670.78164,	89675.14051,	89679.49939,
89683.85830,	89688.21722,	89692.57617,	89696.93513,	89701.29411,	89705.65311,	89710.01213,	89714.37117,	89718.73022,	89723.08930,
89727.44840,	89731.80751,	89736.16664,	89740.52580,	89744.88497,	89749.24416,	89753.60337,	89757.96259,	89762.32184,	89766.68111,
89771.04039,	89775.39970,	89779.75902,	89784.11836,	89788.47772,	89792.83710,	89797.19650,	89801.55592,	89805.91536,	89810.27481,
89814.63429,	89818.99378,	89823.35330,	89827.71283,	89832.07238,	89836.43195,	89840.79154,	89845.15115,	89849.51077,	89853.87042,
89858.23008,	89862.58977,	89866.94947,	89871.30919,	89875.66893,	89880.02869,	89884.38847,	89888.74827,	89893.10808,	89897.46792,
89901.82777,	89906.18765,	89910.54754,	89914.90745,	89919.26738,	89923.62733,	89927.98730,	89932.34729,	89936.70729,	89941.06732,
89945.42736,	89949.78742,	89954.14751,	89958.50761,	89962.86773,	89967.22787,	89971.58802,	89975.94820,	89980.30840,	89984.66861,
89989.02884,	89993.38910,	89997.74937,	90002.10966,	90006.46997,	90010.83030,	90015.19064,	90019.55101,	90023.91139,	90028.27180,
90032.63222,	90036.99266,	90041.35312,	90045.71360,	90050.07410,	90054.43462,	90058.79516,	90063.15571,	90067.51629,	90071.87688,
90076.23749,	90080.59812,	90084.95877,	90089.31944,	90093.68013,	90098.04084,	90102.40156,	90106.76231,	90111.12307,	90115.48386,
90119.84466,	90124.20548,	90128.56632,	90132.92718,	90137.28805,	90141.64895,	90146.00986,	90150.37080,	90154.73175,	90159.09272,
90163.45371,	90167.81472,	90172.17575,	90176.53680,	90180.89787,	90185.25895,	90189.62006,	90193.98118,	90198.34232,	90202.70348,
90207.06466,	90211.42586,	90215.78708,	90220.14832,	90224.50957,	90228.87085,	90233.23214,	90237.59345,	90241.95478,	90246.31613,
90250.67750,	90255.03889,	90259.40030,	90263.76172,	90268.12317,	90272.48463,	90276.84611,	90281.20761,	90285.56913,	90289.93067,
90294.29223,	90298.65381,	90303.01540,	90307.37702,	90311.73865,	90316.10030,	90320.46197,	90324.82366,	90329.18537,	90333.54710,
90337.90885,	90342.27061,	90346.63240,	90350.99420,	90355.35602,	90359.71786,	90364.07972,	90368.44160,	90372.80350,	90377.16542,
90381.52735,	90385.88931,	90390.25128,	90394.61327,	90398.97528,	90403.33731,	90407.69936,	90412.06143,	90416.42352,	90420.78562,
90425.14775,	90429.50989,	90433.87205,	90438.23423,	90442.59643,	90446.95865,	90451.32089,	90455.68314,	90460.04542,	90464.40771,
90468.77002,	90473.13236,	90477.49471,	90481.85708,	90486.21946,	90490.58187,	90494.94430,	90499.30674,	90503.66921,	90508.03169,
90512.39419,	90516.75671,	90521.11925,	90525.48181,	90529.84438,	90534.20698,	90538.56959,	90542.93223,	90547.29488,	90551.65755,
90556.02024,	90560.38295,	90564.74568,	90569.10842,	90573.47119,	90577.83397,	90582.19677,	90586.55959,	90590.92244,	90595.28529,
90599.64817,	90604.01107,	90608.37399,	90612.73692,	90617.09987,	90621.46285,	90625.82584,	90630.18885,	90634.55188,	90638.91492,
90643.27799,	90647.64108,	90652.00418,	90656.36730,	90660.73044,	90665.09360,	90669.45678,	90673.81998,	90678.18320,	90682.54643,
90686.90969,	90691.27296,	90695.63625,	90699.99957,	90704.36290,	90708.72624,	90713.08961,	90717.45300,	90721.81640,	90726.17983,
90730.54327,	90734.90673,	90739.27021,	90743.63371,	90747.99723,	90752.36077,	90756.72432,	90761.08790,	90765.45149,	90769.81510,
90774.17873,	90778.54238,	90782.90605,	90787.26974,	90791.63344,	90795.99717,	90800.36091,	90804.72467,	90809.08845,	90813.45225,
90817.81607,	90822.17991,	90826.54377,	90830.90764,	90835.27154,	90839.63545,	90843.99938,	90848.36333,	90852.72730,	90857.09129,
90861.45529,	90865.81932,	90870.18336,	90874.54743,	90878.91151,	90883.27561,	90887.63973,	90892.00387,	90896.36802,	90900.73220,
90905.09639,	90909.46061,	90913.82484,	90918.18909,	90922.55336,	90926.91765,	90931.28195,	90935.64628,	90940.01062,	90944.37499,
90948.73937,	90953.10377,	90957.46819,	90961.83263,	90966.19709,	90970.56156,	90974.92606,	90979.29057,	90983.65510,	90988.01965,
90992.38422,	90996.74881,	91001.11342,	91005.47804,	91009.84269,	91014.20735,	91018.57204,	91022.93674,	91027.30146,	91031.66619,
91036.03095,	91040.39573,	91044.76052,	91049.12534,	91053.49017,	91057.85502,	91062.21989,	91066.58478,	91070.94969,	91075.31461,
91079.67956,	91084.04452,	91088.40950,	91092.77450,	91097.13952,	91101.50456,	91105.86962,	91110.23469,	91114.59979,	91118.96490,
91123.33003,	91127.69519,	91132.06036,	91136.42554,	91140.79075,	91145.15598,	91149.52122,	91153.88648,	91158.25177,	91162.61707,
91166.98239,	91171.34773,	91175.71308,	91180.07846,	91184.44385,	91188.80927,	91193.17470,	91197.54015,	91201.90562,	91206.27110,
91210.63661,	91215.00214,	91219.36768,	91223.73324,	91228.09883,	91232.46443,	91236.83004,	91241.19568,	91245.56134,	91249.92701,
91254.29271,	91258.65842,	91263.02415,	91267.38990,	91271.75567,	91276.12146,	91280.48726,	91284.85309,	91289.21893,	91293.58479,
91297.95068,	91302.31657,	91306.68249,	91311.04843,	91315.41439,	91319.78036,	91324.14635,	91328.51237,	91332.87840,	91337.24445,
91341.61051,	91345.97660,	91350.34270,	91354.70883,	91359.07497,	91363.44113,	91367.80731,	91372.17351,	91376.53973,	91380.90597,
91385.27222,	91389.63849,	91394.00479,	91398.37110,	91402.73743,	91407.10377,	91411.47014,	91415.83653,	91420.20293,	91424.56935,
91428.93580,	91433.30226,	91437.66874,	91442.03523,	91446.40175,	91450.76828,	91455.13484,	91459.50141,	91463.86800,	91468.23461,
91472.60124,	91476.96789,	91481.33455,	91485.70124,	91490.06794,	91494.43466,	91498.80140,	91503.16816,	91507.53494,	91511.90173,
91516.26855,	91520.63538,	91525.00224,	91529.36911,	91533.73600,	91538.10291,	91542.46983,	91546.83678,	91551.20374,	91555.57073,
91559.93773,	91564.30475,	91568.67179,	91573.03884,	91577.40592,	91581.77301,	91586.14013,	91590.50726,	91594.87441,	91599.24158,
91603.60877,	91607.97598,	91612.34320,	91616.71045,	91621.07771,	91625.44499,	91629.81229,	91634.17961,	91638.54695,	91642.91430,
91647.28168,	91651.64907,	91656.01648,	91660.38391,	91664.75136,	91669.11883,	91673.48631,	91677.85382,	91682.22134,	91686.58889,
91690.95645,	91695.32403,	91699.69162,	91704.05924,	91708.42688,	91712.79453,	91717.16220,	91721.52989,	91725.89760,	91730.26533,
91734.63308,	91739.00085,	91743.36863,	91747.73643,	91752.10425,	91756.47209,	91760.83995,	91765.20783,	91769.57573,	91773.94364,
91778.31158,	91782.67953,	91787.04750,	91791.41549,	91795.78350,	91800.15152,	91804.51957,	91808.88763,	91813.25571,	91817.62381,
91821.99193,	91826.36007,	91830.72823,	91835.09640,	91839.46460,	91843.83281,	91848.20104,	91852.56929,	91856.93756,	91861.30584,
91865.67415,	91870.04247,	91874.41082,	91878.77918,	91883.14756,	91887.51596,	91891.88437,	91896.25281,	91900.62126,	91904.98974,
91909.35823,	91913.72674,	91918.09527,	91922.46381,	91926.83238,	91931.20096,	91935.56957,	91939.93819,	91944.30683,	91948.67549,
91953.04416,	91957.41286,	91961.78157,	91966.15031,	91970.51906,	91974.88783,	91979.25662,	91983.62543,	91987.99425,	91992.36310,
91996.73196,	92001.10084,	92005.46974,	92009.83866,	92014.20760,	92018.57655,	92022.94553,	92027.31452,	92031.68353,	92036.05256,
92040.42161,	92044.79068,	92049.15977,	92053.52887,	92057.89799,	92062.26713,	92066.63629,	92071.00547,	92075.37467,	92079.74389,
92084.11312,	92088.48237,	92092.85165,	92097.22094,	92101.59024,	92105.95957,	92110.32892,	92114.69828,	92119.06766,	92123.43707,
92127.80649,	92132.17592,	92136.54538,	92140.91486,	92145.28435,	92149.65386,	92154.02339,	92158.39294,	92162.76251,	92167.13210,
92171.50171,	92175.87133,	92180.24097,	92184.61063,	92188.98031,	92193.35001,	92197.71973,	92202.08946,	92206.45922,	92210.82899,
92215.19878,	92219.56859,	92223.93842,	92228.30826,	92232.67813,	92237.04801,	92241.41791,	92245.78783,	92250.15777,	92254.52773,
92258.89771,	92263.26770,	92267.63771,	92272.00775,	92276.37780,	92280.74787,	92285.11795,	92289.48806,	92293.85818,	92298.22833,
92302.59849,	92306.96867,	92311.33887,	92315.70908,	92320.07932,	92324.44957,	92328.81984,	92333.19014,	92337.56044,	92341.93077,
92346.30112,	92350.67148,	92355.04187,	92359.41227,	92363.78269,	92368.15313,	92372.52359,	92376.89406,	92381.26456,	92385.63507,
92390.00560,	92394.37615,	92398.74672,	92403.11731,	92407.48791,	92411.85854,	92416.22918,	92420.59984,	92424.97052,	92429.34122,
92433.71194,	92438.08267,	92442.45342,	92446.82420,	92451.19499,	92455.56580,	92459.93662,	92464.30747,	92468.67833,	92473.04922,
92477.42012,	92481.79104,	92486.16198,	92490.53293,	92494.90391,	92499.27490,	92503.64592,	92508.01695,	92512.38800,	92516.75906,
92521.13015,	92525.50126,	92529.87238,	92534.24352,	92538.61468,	92542.98586,	92547.35706,	92551.72827,	92556.09951,	92560.47076,
92564.84203,	92569.21332,	92573.58463,	92577.95595,	92582.32730,	92586.69866,	92591.07004,	92595.44144,	92599.81286,	92604.18430,
92608.55576,	92612.92723,	92617.29872,	92621.67024,	92626.04176,	92630.41331,	92634.78488,	92639.15646,	92643.52807,	92647.89969,
92652.27133,	92656.64299,	92661.01467,	92665.38636,	92669.75808,	92674.12981,	92678.50156,	92682.87333,	92687.24512,	92691.61692,
92695.98875,	92700.36059,	92704.73245,	92709.10433,	92713.47623,	92717.84815,	92722.22009,	92726.59204,	92730.96401,	92735.33600,
92739.70801,	92744.08004,	92748.45209,	92752.82415,	92757.19623,	92761.56834,	92765.94046,	92770.31259,	92774.68475,	92779.05693,
92783.42912,	92787.80133,	92792.17356,	92796.54581,	92800.91808,	92805.29037,	92809.66267,	92814.03499,	92818.40733,	92822.77969,
92827.15207,	92831.52447,	92835.89688,	92840.26932,	92844.64177,	92849.01424,	92853.38673,	92857.75923,	92862.13176,	92866.50430,
92870.87686,	92875.24944,	92879.62204,	92883.99466,	92888.36730,	92892.73995,	92897.11262,	92901.48532,	92905.85802,	92910.23075,
92914.60350,	92918.97626,	92923.34905,	92927.72185,	92932.09467,	92936.46751,	92940.84036,	92945.21324,	92949.58613,	92953.95904,
92958.33198,	92962.70492,	92967.07789,	92971.45088,	92975.82388,	92980.19690,	92984.56994,	92988.94300,	92993.31608,	92997.68918,
93002.06229,	93006.43542,	93010.80857,	93015.18174,	93019.55493,	93023.92814,	93028.30136,	93032.67461,	93037.04787,	93041.42115,
93045.79445,	93050.16776,	93054.54110,	93058.91445,	93063.28782,	93067.66121,	93072.03462,	93076.40805,	93080.78149,	93085.15496,
93089.52844,	93093.90194,	93098.27546,	93102.64900,	93107.02255,	93111.39613,	93115.76972,	93120.14333,	93124.51696,	93128.89061,
93133.26427,	93137.63796,	93142.01166,	93146.38538,	93150.75912,	93155.13288,	93159.50665,	93163.88045,	93168.25426,	93172.62809,
93177.00194,	93181.37581,	93185.74969,	93190.12360,	93194.49752,	93198.87146,	93203.24542,	93207.61940,	93211.99340,	93216.36741,
93220.74145,	93225.11550,	93229.48957,	93233.86365,	93238.23776,	93242.61189,	93246.98603,	93251.36019,	93255.73437,	93260.10857,
93264.48279,	93268.85702,	93273.23127,	93277.60555,	93281.97984,	93286.35414,	93290.72847,	93295.10282,	93299.47718,	93303.85156,
93308.22596,	93312.60038,	93316.97482,	93321.34927,	93325.72374,	93330.09824,	93334.47275,	93338.84727,	93343.22182,	93347.59639,
93351.97097,	93356.34557,	93360.72019,	93365.09483,	93369.46949,	93373.84416,	93378.21885,	93382.59357,	93386.96830,	93391.34304,
93395.71781,	93400.09260,	93404.46740,	93408.84222,	93413.21706,	93417.59192,	93421.96680,	93426.34169,	93430.71660,	93435.09154,
93439.46649,	93443.84145,	93448.21644,	93452.59145,	93456.96647,	93461.34151,	93465.71657,	93470.09165,	93474.46674,	93478.84186,
93483.21699,	93487.59214,	93491.96731,	93496.34250,	93500.71771,	93505.09293,	93509.46817,	93513.84344,	93518.21871,	93522.59401,
93526.96933,	93531.34466,	93535.72002,	93540.09539,	93544.47078,	93548.84618,	93553.22161,	93557.59705,	93561.97252,	93566.34800,
93570.72350,	93575.09901,	93579.47455,	93583.85010,	93588.22567,	93592.60126,	93596.97687,	93601.35250,	93605.72815,	93610.10381,
93614.47949,	93618.85519,	93623.23091,	93627.60665,	93631.98240,	93636.35818,	93640.73397,	93645.10978,	93649.48560,	93653.86145,
93658.23732,	93662.61320,	93666.98910,	93671.36502,	93675.74096,	93680.11691,	93684.49289,	93688.86888,	93693.24489,	93697.62092,
93701.99697,	93706.37303,	93710.74912,	93715.12522,	93719.50134,	93723.87748,	93728.25364,	93732.62981,	93737.00601,	93741.38222,
93745.75845,	93750.13470,	93754.51096,	93758.88725,	93763.26355,	93767.63987,	93772.01621,	93776.39257,	93780.76895,	93785.14534,
93789.52175,	93793.89818,	93798.27463,	93802.65110,	93807.02759,	93811.40409,	93815.78061,	93820.15715,	93824.53371,	93828.91029,
93833.28688,	93837.66350,	93842.04013,	93846.41678,	93850.79345,	93855.17013,	93859.54684,	93863.92356,	93868.30030,	93872.67706,
93877.05384,	93881.43064,	93885.80745,	93890.18428,	93894.56113,	93898.93800,	93903.31489,	93907.69179,	93912.06872,	93916.44566,
93920.82262,	93925.19960,	93929.57659,	93933.95361,	93938.33064,	93942.70769,	93947.08476,	93951.46185,	93955.83895,	93960.21608,
93964.59322,	93968.97038,	93973.34756,	93977.72476,	93982.10197,	93986.47921,	93990.85646,	93995.23373,	93999.61102,	94003.98832,
94008.36565,	94012.74299,	94017.12035,	94021.49773,	94025.87513,	94030.25254,	94034.62998,	94039.00743,	94043.38490,	94047.76239,
94052.13989,	94056.51742,	94060.89496,	94065.27252,	94069.65010,	94074.02770,	94078.40531,	94082.78295,	94087.16060,	94091.53827,
94095.91596,	94100.29367,	94104.67139,	94109.04913,	94113.42690,	94117.80468,	94122.18247,	94126.56029,	94130.93812,	94135.31598,
94139.69385,	94144.07174,	94148.44964,	94152.82757,	94157.20551,	94161.58347,	94165.96145,	94170.33945,	94174.71747,	94179.09550,
94183.47355,	94187.85162,	94192.22971,	94196.60782,	94200.98595,	94205.36409,	94209.74225,	94214.12043,	94218.49863,	94222.87684,
94227.25508,	94231.63333,	94236.01160,	94240.38989,	94244.76820,	94249.14652,	94253.52487,	94257.90323,	94262.28161,	94266.66001,
94271.03842,	94275.41686,	94279.79531,	94284.17378,	94288.55227,	94292.93077,	94297.30930,	94301.68784,	94306.06640,	94310.44498,
94314.82358,	94319.20220,	94323.58083,	94327.95948,	94332.33815,	94336.71684,	94341.09555,	94345.47427,	94349.85302,	94354.23178,
94358.61056,	94362.98936,	94367.36817,	94371.74700,	94376.12586,	94380.50473,	94384.88362,	94389.26252,	94393.64145,	94398.02039,
94402.39935,	94406.77833,	94411.15733,	94415.53634,	94419.91537,	94424.29443,	94428.67350,	94433.05258,	94437.43169,	94441.81081,
94446.18996,	94450.56912,	94454.94829,	94459.32749,	94463.70671,	94468.08594,	94472.46519,	94476.84446,	94481.22375,	94485.60305,
94489.98238,	94494.36172,	94498.74108,	94503.12046,	94507.49985,	94511.87927,	94516.25870,	94520.63815,	94525.01762,	94529.39711,
94533.77661,	94538.15613,	94542.53567,	94546.91523,	94551.29481,	94555.67441,	94560.05402,	94564.43365,	94568.81330,	94573.19297,
94577.57266,	94581.95236,	94586.33208,	94590.71182,	94595.09158,	94599.47136,	94603.85115,	94608.23097,	94612.61080,	94616.99065,
94621.37051,	94625.75040,	94630.13030,	94634.51022,	94638.89016,	94643.27012,	94647.65010,	94652.03009,	94656.41010,	94660.79013,
94665.17018,	94669.55025,	94673.93033,	94678.31044,	94682.69056,	94687.07070,	94691.45085,	94695.83103,	94700.21122,	94704.59143,
94708.97166,	94713.35191,	94717.73217,	94722.11246,	94726.49276,	94730.87308,	94735.25342,	94739.63377,	94744.01415,	94748.39454,
94752.77495,	94757.15538,	94761.53582,	94765.91629,	94770.29677,	94774.67727,	94779.05779,	94783.43833,	94787.81888,	94792.19946,
94796.58005,	94800.96066,	94805.34128,	94809.72193,	94814.10259,	94818.48327,	94822.86397,	94827.24469,	94831.62543,	94836.00618,
94840.38695,	94844.76774,	94849.14855,	94853.52938,	94857.91022,	94862.29108,	94866.67196,	94871.05286,	94875.43378,	94879.81471,
94884.19566,	94888.57664,	94892.95762,	94897.33863,	94901.71966,	94906.10070,	94910.48176,	94914.86284,	94919.24394,	94923.62505,
94928.00618,	94932.38733,	94936.76850,	94941.14969,	94945.53090,	94949.91212,	94954.29336,	94958.67462,	94963.05590,	94967.43719,
94971.81851,	94976.19984,	94980.58119,	94984.96256,	94989.34394,	94993.72535,	94998.10677,	95002.48821,	95006.86967,	95011.25114,
95015.63264,	95020.01415,	95024.39568,	95028.77723,	95033.15879,	95037.54038,	95041.92198,	95046.30360,	95050.68524,	95055.06690,
95059.44857,	95063.83026,	95068.21197,	95072.59370,	95076.97545,	95081.35721,	95085.73900,	95090.12080,	95094.50262,	95098.88445,
95103.26631,	95107.64818,	95112.03007,	95116.41198,	95120.79391,	95125.17585,	95129.55782,	95133.93980,	95138.32180,	95142.70381,
95147.08585,	95151.46790,	95155.84997,	95160.23206,	95164.61417,	95168.99629,	95173.37844,	95177.76060,	95182.14278,	95186.52497,
95190.90719,	95195.28942,	95199.67167,	95204.05394,	95208.43623,	95212.81854,	95217.20086,	95221.58320,	95225.96556,	95230.34794,
95234.73033,	95239.11274,	95243.49518,	95247.87763,	95252.26009,	95256.64258,	95261.02508,	95265.40760,	95269.79014,	95274.17270,
95278.55527,	95282.93787,	95287.32048,	95291.70311,	95296.08576,	95300.46842,	95304.85110,	95309.23381,	95313.61653,	95317.99926,
95322.38202,	95326.76479,	95331.14758,	95335.53039,	95339.91322,	95344.29606,	95348.67893,	95353.06181,	95357.44471,	95361.82762,
95366.21056,	95370.59351,	95374.97648,	95379.35947,	95383.74248,	95388.12550,	95392.50855,	95396.89161,	95401.27469,	95405.65778,
95410.04090,	95414.42403,	95418.80718,	95423.19035,	95427.57354,	95431.95674,	95436.33997,	95440.72321,	95445.10647,	95449.48974,
95453.87304,	95458.25635,	95462.63968,	95467.02303,	95471.40640,	95475.78978,	95480.17318,	95484.55660,	95488.94004,	95493.32350,
95497.70697,	95502.09046,	95506.47397,	95510.85750,	95515.24105,	95519.62461,	95524.00819,	95528.39179,	95532.77541,	95537.15905,
95541.54270,	95545.92637,	95550.31006,	95554.69377,	95559.07750,	95563.46124,	95567.84500,	95572.22878,	95576.61258,	95580.99639,
95585.38023,	95589.76408,	95594.14795,	95598.53183,	95602.91574,	95607.29966,	95611.68360,	95616.06756,	95620.45154,	95624.83553,
95629.21955,	95633.60358,	95637.98763,	95642.37169,	95646.75578,	95651.13988,	95655.52400,	95659.90814,	95664.29229,	95668.67647,
95673.06066,	95677.44487,	95681.82910,	95686.21334,	95690.59761,	95694.98189,	95699.36619,	95703.75051,	95708.13484,	95712.51920,
95716.90357,	95721.28796,	95725.67236,	95730.05679,	95734.44123,	95738.82569,	95743.21017,	95747.59467,	95751.97918,	95756.36372,
95760.74827,	95765.13283,	95769.51742,	95773.90203,	95778.28665,	95782.67129,	95787.05595,	95791.44062,	95795.82532,	95800.21003,
95804.59476,	95808.97950,	95813.36427,	95817.74905,	95822.13385,	95826.51867,	95830.90351,	95835.28837,	95839.67324,	95844.05813,
95848.44304,	95852.82796,	95857.21291,	95861.59787,	95865.98285,	95870.36785,	95874.75287,	95879.13790,	95883.52295,	95887.90802,
95892.29311,	95896.67822,	95901.06334,	95905.44848,	95909.83364,	95914.21882,	95918.60401,	95922.98922,	95927.37446,	95931.75970,
95936.14497,	95940.53025,	95944.91556,	95949.30088,	95953.68622,	95958.07157,	95962.45695,	95966.84234,	95971.22775,	95975.61317,
95979.99862,	95984.38408,	95988.76956,	95993.15506,	95997.54058,	96001.92611,	96006.31167,	96010.69724,	96015.08283,	96019.46843,
96023.85406,	96028.23970,	96032.62536,	96037.01104,	96041.39673,	96045.78245,	96050.16818,	96054.55393,	96058.93969,	96063.32548,
96067.71128,	96072.09710,	96076.48294,	96080.86880,	96085.25467,	96089.64056,	96094.02647,	96098.41240,	96102.79835,	96107.18431,
96111.57029,	96115.95629,	96120.34231,	96124.72834,	96129.11440,	96133.50047,	96137.88656,	96142.27266,	96146.65879,	96151.04493,
96155.43109,	96159.81727,	96164.20346,	96168.58967,	96172.97591,	96177.36216,	96181.74842,	96186.13471,	96190.52101,	96194.90733,
96199.29367,	96203.68003,	96208.06640,	96212.45279,	96216.83920,	96221.22563,	96225.61207,	96229.99854,	96234.38502,	96238.77152,
96243.15803,	96247.54457,	96251.93112,	96256.31769,	96260.70428,	96265.09089,	96269.47751,	96273.86415,	96278.25081,	96282.63749,
96287.02418,	96291.41090,	96295.79763,	96300.18438,	96304.57114,	96308.95793,	96313.34473,	96317.73155,	96322.11839,	96326.50524,
96330.89211,	96335.27901,	96339.66591,	96344.05284,	96348.43979,	96352.82675,	96357.21373,	96361.60073,	96365.98774,	96370.37478,
96374.76183,	96379.14890,	96383.53598,	96387.92309,	96392.31021,	96396.69735,	96401.08451,	96405.47169,	96409.85888,	96414.24609,
96418.63332,	96423.02057,	96427.40784,	96431.79512,	96436.18242,	96440.56974,	96444.95707,	96449.34443,	96453.73180,	96458.11919,
96462.50660,	96466.89402,	96471.28147,	96475.66893,	96480.05641,	96484.44390,	96488.83142,	96493.21895,	96497.60650,	96501.99407,
96506.38165,	96510.76926,	96515.15688,	96519.54452,	96523.93217,	96528.31985,	96532.70754,	96537.09525,	96541.48298,	96545.87072,
96550.25849,	96554.64627,	96559.03407,	96563.42188,	96567.80972,	96572.19757,	96576.58544,	96580.97333,	96585.36123,	96589.74916,
96594.13710,	96598.52506,	96602.91304,	96607.30103,	96611.68904,	96616.07707,	96620.46512,	96624.85319,	96629.24127,	96633.62937,
96638.01749,	96642.40563,	96646.79378,	96651.18195,	96655.57014,	96659.95835,	96664.34658,	96668.73482,	96673.12308,	96677.51136,
96681.89966,	96686.28797,	96690.67630,	96695.06465,	96699.45302,	96703.84141,	96708.22981,	96712.61823,	96717.00667,	96721.39513,
96725.78360,	96730.17209,	96734.56060,	96738.94913,	96743.33767,	96747.72624,	96752.11482,	96756.50342,	96760.89203,	96765.28067,
96769.66932,	96774.05799,	96778.44667,	96782.83538,	96787.22410,	96791.61284,	96796.00160,	96800.39038,	96804.77917,	96809.16798,
96813.55681,	96817.94566,	96822.33452,	96826.72341,	96831.11231,	96835.50122,	96839.89016,	96844.27911,	96848.66808,	96853.05707,
96857.44608,	96861.83510,	96866.22414,	96870.61320,	96875.00228,	96879.39138,	96883.78049,	96888.16962,	96892.55877,	96896.94793,
96901.33712,	96905.72632,	96910.11554,	96914.50478,	96918.89403,	96923.28330,	96927.67259,	96932.06190,	96936.45123,	96940.84057,
96945.22993,	96949.61931,	96954.00871,	96958.39812,	96962.78755,	96967.17700,	96971.56647,	96975.95595,	96980.34546,	96984.73498,
96989.12452,	96993.51407,	96997.90365,	97002.29324,	97006.68285,	97011.07247,	97015.46212,	97019.85178,	97024.24146,	97028.63116,
97033.02087,	97037.41060,	97041.80036,	97046.19012,	97050.57991,	97054.96971,	97059.35954,	97063.74937,	97068.13923,	97072.52911,
97076.91900,	97081.30891,	97085.69884,	97090.08878,	97094.47874,	97098.86872,	97103.25872,	97107.64874,	97112.03877,	97116.42882,
97120.81889,	97125.20898,	97129.59909,	97133.98921,	97138.37935,	97142.76950,	97147.15968,	97151.54987,	97155.94008,	97160.33031,
97164.72056,	97169.11082,	97173.50110,	97177.89140,	97182.28172,	97186.67205,	97191.06241,	97195.45278,	97199.84316,	97204.23357,
97208.62399,	97213.01443,	97217.40489,	97221.79537,	97226.18586,	97230.57637,	97234.96690,	97239.35745,	97243.74801,	97248.13859,
97252.52919,	97256.91981,	97261.31044,	97265.70110,	97270.09177,	97274.48245,	97278.87316,	97283.26388,	97287.65462,	97292.04538,
97296.43616,	97300.82695,	97305.21776,	97309.60859,	97313.99944,	97318.39030,	97322.78119,	97327.17209,	97331.56300,	97335.95394,
97340.34489,	97344.73586,	97349.12685,	97353.51786,	97357.90888,	97362.29992,	97366.69098,	97371.08206,	97375.47315,	97379.86426,
97384.25539,	97388.64654,	97393.03770,	97397.42888,	97401.82008,	97406.21130,	97410.60254,	97414.99379,	97419.38506,	97423.77635,
97428.16765,	97432.55898,	97436.95032,	97441.34168,	97445.73305,	97450.12445,	97454.51586,	97458.90729,	97463.29873,	97467.69020,
97472.08168,	97476.47318,	97480.86470,	97485.25623,	97489.64778,	97494.03935,	97498.43094,	97502.82255,	97507.21417,	97511.60581,
97515.99747,	97520.38915,	97524.78084,	97529.17255,	97533.56428,	97537.95603,	97542.34779,	97546.73957,	97551.13137,	97555.52319,
97559.91502,	97564.30687,	97568.69874,	97573.09063,	97577.48254,	97581.87446,	97586.26640,	97590.65836,	97595.05033,	97599.44233,
97603.83434,	97608.22637,	97612.61841,	97617.01047,	97621.40256,	97625.79465,	97630.18677,	97634.57890,	97638.97106,	97643.36323,
97647.75541,	97652.14762,	97656.53984,	97660.93208,	97665.32434,	97669.71661,	97674.10890,	97678.50121,	97682.89354,	97687.28588,
97691.67825,	97696.07063,	97700.46303,	97704.85544,	97709.24787,	97713.64033,	97718.03279,	97722.42528,	97726.81778,	97731.21030,
97735.60284,	97739.99540,	97744.38797,	97748.78056,	97753.17317,	97757.56580,	97761.95844,	97766.35111,	97770.74379,	97775.13648,
97779.52920,	97783.92193,	97788.31468,	97792.70745,	97797.10023,	97801.49303,	97805.88585,	97810.27869,	97814.67155,	97819.06442,
97823.45731,	97827.85022,	97832.24314,	97836.63609,	97841.02905,	97845.42202,	97849.81502,	97854.20803,	97858.60106,	97862.99411,
97867.38718,	97871.78026,	97876.17336,	97880.56648,	97884.95962,	97889.35277,	97893.74594,	97898.13913,	97902.53234,	97906.92556,
97911.31881,	97915.71206,	97920.10534,	97924.49864,	97928.89195,	97933.28528,	97937.67862,	97942.07199,	97946.46537,	97950.85877,
97955.25219,	97959.64562,	97964.03907,	97968.43254,	97972.82603,	97977.21954,	97981.61306,	97986.00660,	97990.40016,	97994.79373,
97999.18733,	98003.58094,	98007.97456,	98012.36821,	98016.76187,	98021.15555,	98025.54925,	98029.94297,	98034.33670,	98038.73045,
98043.12422,	98047.51800,	98051.91181,	98056.30563,	98060.69947,	98065.09332,	98069.48720,	98073.88109,	98078.27499,	98082.66892,
98087.06286,	98091.45683,	98095.85080,	98100.24480,	98104.63881,	98109.03284,	98113.42689,	98117.82096,	98122.21504,	98126.60915,
98131.00326,	98135.39740,	98139.79155,	98144.18573,	98148.57991,	98152.97412,	98157.36834,	98161.76259,	98166.15685,	98170.55112,
98174.94542,	98179.33973,	98183.73406,	98188.12840,	98192.52277,	98196.91715,	98201.31155,	98205.70596,	98210.10040,	98214.49485,
98218.88932,	98223.28381,	98227.67831,	98232.07283,	98236.46737,	98240.86193,	98245.25650,	98249.65109,	98254.04570,	98258.44033,
98262.83497,	98267.22964,	98271.62432,	98276.01901,	98280.41373,	98284.80846,	98289.20321,	98293.59797,	98297.99276,	98302.38756,
98306.78238,	98311.17722,	98315.57207,	98319.96694,	98324.36183,	98328.75674,	98333.15166,	98337.54660,	98341.94156,	98346.33654,
98350.73153,	98355.12655,	98359.52158,	98363.91662,	98368.31169,	98372.70677,	98377.10187,	98381.49698,	98385.89212,	98390.28727,
98394.68244,	98399.07763,	98403.47283,	98407.86805,	98412.26329,	98416.65855,	98421.05382,	98425.44911,	98429.84442,	98434.23975,
98438.63509,	98443.03045,	98447.42583,	98451.82123,	98456.21664,	98460.61207,	98465.00752,	98469.40299,	98473.79847,	98478.19397,
98482.58949,	98486.98503,	98491.38058,	98495.77615,	98500.17174,	98504.56735,	98508.96297,	98513.35861,	98517.75427,	98522.14994,
98526.54564,	98530.94135,	98535.33708,	98539.73282,	98544.12858,	98548.52437,	98552.92016,	98557.31598,	98561.71181,	98566.10766,
98570.50353,	98574.89942,	98579.29532,	98583.69124,	98588.08718,	98592.48313,	98596.87910,	98601.27509,	98605.67110,	98610.06713,
98614.46317,	98618.85923,	98623.25531,	98627.65140,	98632.04751,	98636.44364,	98640.83979,	98645.23595,	98649.63214,	98654.02833,
98658.42455,	98662.82079,	98667.21704,	98671.61331,	98676.00959,	98680.40590,	98684.80222,	98689.19856,	98693.59491,	98697.99129,
98702.38768,	98706.78409,	98711.18051,	98715.57696,	98719.97342,	98724.36990,	98728.76639,	98733.16290,	98737.55943,	98741.95598,
98746.35255,	98750.74913,	98755.14573,	98759.54235,	98763.93898,	98768.33564,	98772.73231,	98777.12899,	98781.52570,	98785.92242,
98790.31916,	98794.71592,	98799.11269,	98803.50949,	98807.90629,	98812.30312,	98816.69997,	98821.09683,	98825.49371,	98829.89060,
98834.28752,	98838.68445,	98843.08140,	98847.47836,	98851.87535,	98856.27235,	98860.66937,	98865.06640,	98869.46345,	98873.86052,
98878.25761,	98882.65472,	98887.05184,	98891.44898,	98895.84614,	98900.24331,	98904.64051,	98909.03772,	98913.43494,	98917.83219,
98922.22945,	98926.62673,	98931.02403,	98935.42134,	98939.81867,	98944.21602,	98948.61339,	98953.01077,	98957.40817,	98961.80559,
98966.20303,	98970.60048,	98974.99795,	98979.39544,	98983.79294,	98988.19047,	98992.58801,	98996.98556,	99001.38314,	99005.78073,
99010.17834,	99014.57597,	99018.97361,	99023.37128,	99027.76895,	99032.16665,	99036.56437,	99040.96210,	99045.35985,	99049.75761,
99054.15540,	99058.55320,	99062.95102,	99067.34885,	99071.74670,	99076.14457,	99080.54246,	99084.94037,	99089.33829,	99093.73623,
99098.13419,	99102.53216,	99106.93015,	99111.32816,	99115.72619,	99120.12424,	99124.52230,	99128.92038,	99133.31847,	99137.71659,
99142.11472,	99146.51287,	99150.91103,	99155.30921,	99159.70741,	99164.10563,	99168.50387,	99172.90212,	99177.30039,	99181.69868,
99186.09698,	99190.49530,	99194.89364,	99199.29200,	99203.69037,	99208.08877,	99212.48717,	99216.88560,	99221.28404,	99225.68251,
99230.08098,	99234.47948,	99238.87799,	99243.27652,	99247.67507,	99252.07363,	99256.47222,	99260.87082,	99265.26943,	99269.66807,
99274.06672,	99278.46539,	99282.86408,	99287.26278,	99291.66150,	99296.06024,	99300.45899,	99304.85777,	99309.25656,	99313.65537,
99318.05419,	99322.45303,	99326.85189,	99331.25077,	99335.64966,	99340.04858,	99344.44750,	99348.84645,	99353.24541,	99357.64440,
99362.04339,	99366.44241,	99370.84144,	99375.24049,	99379.63956,	99384.03865,	99388.43775,	99392.83687,	99397.23601,	99401.63516,
99406.03433,	99410.43352,	99414.83273,	99419.23195,	99423.63119,	99428.03045,	99432.42972,	99436.82902,	99441.22833,	99445.62766,
99450.02700,	99454.42636,	99458.82574,	99463.22514,	99467.62455,	99472.02398,	99476.42343,	99480.82290,	99485.22238,	99489.62188,
99494.02140,	99498.42094,	99502.82049,	99507.22006,	99511.61965,	99516.01925,	99520.41887,	99524.81851,	99529.21817,	99533.61784,
99538.01753,	99542.41724,	99546.81697,	99551.21671,	99555.61647,	99560.01625,	99564.41604,	99568.81585,	99573.21568,	99577.61553,
99582.01539,	99586.41528,	99590.81517,	99595.21509,	99599.61502,	99604.01497,	99608.41494,	99612.81493,	99617.21493,	99621.61495,
99626.01499,	99630.41504,	99634.81511,	99639.21520,	99643.61531,	99648.01543,	99652.41557,	99656.81573,	99661.21590,	99665.61610,
99670.01631,	99674.41653,	99678.81678,	99683.21704,	99687.61732,	99692.01761,	99696.41793,	99700.81826,	99705.21861,	99709.61897,
99714.01935,	99718.41975,	99722.82017,	99727.22060,	99731.62106,	99736.02153,	99740.42201,	99744.82251,	99749.22304,	99753.62357,
99758.02413,	99762.42470,	99766.82529,	99771.22590,	99775.62652,	99780.02716,	99784.42782,	99788.82850,	99793.22919,	99797.62990,
99802.03063,	99806.43138,	99810.83214,	99815.23292,	99819.63372,	99824.03453,	99828.43536,	99832.83621,	99837.23708,	99841.63796,
99846.03886,	99850.43978,	99854.84071,	99859.24166,	99863.64263,	99868.04362,	99872.44462,	99876.84565,	99881.24668,	99885.64774,
99890.04881,	99894.44990,	99898.85101,	99903.25214,	99907.65328,	99912.05444,	99916.45561,	99920.85681,	99925.25802,	99929.65925,
99934.06049,	99938.46175,	99942.86303,	99947.26433,	99951.66565,	99956.06698,	99960.46833,	99964.86969,	99969.27107,	99973.67248,
99978.07389,	99982.47533,	99986.87678,	99991.27825,	99995.67974,	100000.08124,	100004.48276,	100008.88430,	100013.28586,	100017.68743,
100022.08902,	100026.49063,	100030.89225,	100035.29389,	100039.69555,	100044.09723,	100048.49892,	100052.90063,	100057.30236,	100061.70410,
100066.10587,	100070.50765,	100074.90944,	100079.31126,	100083.71309,	100088.11494,	100092.51680,	100096.91868,	100101.32058,	100105.72250,
100110.12444,	100114.52639,	100118.92836,	100123.33034,	100127.73235,	100132.13437,	100136.53640,	100140.93846,	100145.34053,	100149.74262,
100154.14473,	100158.54685,	100162.94899,	100167.35115,	100171.75333,	100176.15552,	100180.55773,	100184.95996,	100189.36220,	100193.76446,
100198.16674,	100202.56904,	100206.97135,	100211.37368,	100215.77603,	100220.17839,	100224.58077,	100228.98317,	100233.38559,	100237.78802,
100242.19047,	100246.59294,	100250.99542,	100255.39793,	100259.80045,	100264.20298,	100268.60554,	100273.00811,	100277.41069,	100281.81330,
100286.21592,	100290.61856,	100295.02122,	100299.42389,	100303.82658,	100308.22929,	100312.63202,	100317.03476,	100321.43752,	100325.84030,
100330.24309,	100334.64590,	100339.04873,	100343.45158,	100347.85444,	100352.25732,	100356.66022,	100361.06313,	100365.46606,	100369.86901,
100374.27198,	100378.67496,	100383.07796,	100387.48098,	100391.88401,	100396.28707,	100400.69014,	100405.09322,	100409.49632,	100413.89945,
100418.30258,	100422.70574,	100427.10891,	100431.51210,	100435.91531,	100440.31853,	100444.72177,	100449.12503,	100453.52830,	100457.93159,
100462.33490,	100466.73823,	100471.14157,	100475.54493,	100479.94831,	100484.35171,	100488.75512,	100493.15855,	100497.56200,	100501.96546,
100506.36894,	100510.77244,	100515.17595,	100519.57949,	100523.98304,	100528.38660,	100532.79019,	100537.19379,	100541.59740,	100546.00104,
100550.40469,	100554.80836,	100559.21205,	100563.61575,	100568.01947,	100572.42321,	100576.82697,	100581.23074,	100585.63453,	100590.03833,
100594.44216,	100598.84600,	100603.24986,	100607.65373,	100612.05762,	100616.46153,	100620.86546,	100625.26940,	100629.67337,	100634.07734,
100638.48134,	100642.88535,	100647.28938,	100651.69343,	100656.09749,	100660.50157,	100664.90567,	100669.30978,	100673.71392,	100678.11806,
100682.52223,	100686.92641,	100691.33062,	100695.73483,	100700.13907,	100704.54332,	100708.94759,	100713.35188,	100717.75618,	100722.16050,
100726.56484,	100730.96919,	100735.37356,	100739.77795,	100744.18236,	100748.58678,	100752.99122,	100757.39568,	100761.80015,	100766.20465,
100770.60915,	100775.01368,	100779.41822,	100783.82278,	100788.22736,	100792.63195,	100797.03657,	100801.44119,	100805.84584,	100810.25050,
100814.65518,	100819.05988,	100823.46459,	100827.86932,	100832.27407,	100836.67884,	100841.08362,	100845.48842,	100849.89324,	100854.29807,
100858.70292,	100863.10779,	100867.51267,	100871.91758,	100876.32250,	100880.72743,	100885.13238,	100889.53736,	100893.94234,	100898.34735,
100902.75237,	100907.15741,	100911.56246,	100915.96754,	100920.37263,	100924.77773,	100929.18286,	100933.58800,	100937.99316,	100942.39833,
100946.80353,	100951.20874,	100955.61396,	100960.01921,	100964.42447,	100968.82975,	100973.23504,	100977.64035,	100982.04568,	100986.45103,
100990.85639,	100995.26177,	100999.66717,	101004.07259,	101008.47802,	101012.88347,	101017.28893,	101021.69441,	101026.09991,	101030.50543,
101034.91097,	101039.31652,	101043.72209,	101048.12767,	101052.53327,	101056.93889,	101061.34453,	101065.75018,	101070.15585,	101074.56154,
101078.96725,	101083.37297,	101087.77871,	101092.18446,	101096.59024,	101100.99603,	101105.40183,	101109.80766,	101114.21350,	101118.61936,
101123.02523,	101127.43113,	101131.83704,	101136.24296,	101140.64891,	101145.05487,	101149.46084,	101153.86684,	101158.27285,	101162.67888,
101167.08493,	101171.49099,	101175.89707,	101180.30317,	101184.70928,	101189.11541,	101193.52156,	101197.92773,	101202.33391,	101206.74011,
101211.14632,	101215.55256,	101219.95881,	101224.36508,	101228.77136,	101233.17766,	101237.58398,	101241.99032,	101246.39667,	101250.80304,
101255.20943,	101259.61583,	101264.02225,	101268.42869,	101272.83514,	101277.24162,	101281.64810,	101286.05461,	101290.46113,	101294.86767,
101299.27423,	101303.68081,	101308.08740,	101312.49400,	101316.90063,	101321.30727,	101325.71393,	101330.12061,	101334.52730,	101338.93401,
101343.34074,	101347.74748,	101352.15425,	101356.56102,	101360.96782,	101365.37463,	101369.78146,	101374.18831,	101378.59517,	101383.00205,
101387.40895,	101391.81587,	101396.22280,	101400.62975,	101405.03671,	101409.44369,	101413.85069,	101418.25771,	101422.66474,	101427.07180,
101431.47886,	101435.88595,	101440.29305,	101444.70017,	101449.10730,	101453.51446,	101457.92163,	101462.32881,	101466.73602,	101471.14324,
101475.55048,	101479.95773,	101484.36500,	101488.77229,	101493.17960,	101497.58692,	101501.99426,	101506.40162,	101510.80899,	101515.21638,
101519.62379,	101524.03122,	101528.43866,	101532.84612,	101537.25359,	101541.66109,	101546.06860,	101550.47612,	101554.88367,	101559.29123,
101563.69881,	101568.10640,	101572.51401,	101576.92164,	101581.32929,	101585.73695,	101590.14463,	101594.55233,	101598.96004,	101603.36777,
101607.77552,	101612.18328,	101616.59106,	101620.99886,	101625.40668,	101629.81451,	101634.22236,	101638.63023,	101643.03811,	101647.44601,
101651.85393,	101656.26186,	101660.66981,	101665.07778,	101669.48577,	101673.89377,	101678.30179,	101682.70983,	101687.11788,	101691.52595,
101695.93404,	101700.34214,	101704.75026,	101709.15840,	101713.56656,	101717.97473,	101722.38292,	101726.79112,	101731.19935,	101735.60759,
101740.01584,	101744.42412,	101748.83241,	101753.24072,	101757.64904,	101762.05738,	101766.46574,	101770.87412,	101775.28251,	101779.69092,
101784.09935,	101788.50779,	101792.91625,	101797.32473,	101801.73322,	101806.14173,	101810.55026,	101814.95881,	101819.36737,	101823.77595,
101828.18454,	101832.59316,	101837.00179,	101841.41043,	101845.81910,	101850.22778,	101854.63648,	101859.04519,	101863.45392,	101867.86267,
101872.27144,	101876.68022,	101881.08902,	101885.49783,	101889.90667,	101894.31552,	101898.72439,	101903.13327,	101907.54217,	101911.95109,
101916.36002,	101920.76898,	101925.17794,	101929.58693,	101933.99593,	101938.40495,	101942.81399,	101947.22304,	101951.63211,	101956.04120,
101960.45030,	101964.85943,	101969.26856,	101973.67772,	101978.08689,	101982.49608,	101986.90529,	101991.31451,	101995.72375,	102000.13301,
102004.54228,	102008.95157,	102013.36088,	102017.77020,	102022.17954,	102026.58890,	102030.99828,	102035.40767,	102039.81708,	102044.22650,
102048.63595,	102053.04541,	102057.45488,	102061.86438,	102066.27389,	102070.68341,	102075.09296,	102079.50252,	102083.91210,	102088.32169,
102092.73130,	102097.14093,	102101.55058,	102105.96024,	102110.36992,	102114.77962,	102119.18933,	102123.59906,	102128.00881,	102132.41857,
102136.82835,	102141.23815,	102145.64797,	102150.05780,	102154.46765,	102158.87751,	102163.28739,	102167.69729,	102172.10721,	102176.51714,
102180.92709,	102185.33706,	102189.74704,	102194.15704,	102198.56706,	102202.97710,	102207.38715,	102211.79722,	102216.20730,	102220.61740,
102225.02752,	102229.43766,	102233.84781,	102238.25798,	102242.66817,	102247.07837,	102251.48859,	102255.89883,	102260.30908,	102264.71935,
102269.12964,	102273.53995,	102277.95027,	102282.36061,	102286.77096,	102291.18133,	102295.59172,	102300.00213,	102304.41255,	102308.82299,
102313.23345,	102317.64392,	102322.05441,	102326.46492,	102330.87544,	102335.28598,	102339.69654,	102344.10712,	102348.51771,	102352.92832,
102357.33894,	102361.74958,	102366.16024,	102370.57092,	102374.98161,	102379.39232,	102383.80305,	102388.21379,	102392.62455,	102397.03533,
102401.44612,	102405.85694,	102410.26776,	102414.67861,	102419.08947,	102423.50035,	102427.91124,	102432.32216,	102436.73308,	102441.14403,
102445.55499,	102449.96597,	102454.37697,	102458.78798,	102463.19901,	102467.61006,	102472.02112,	102476.43220,	102480.84330,	102485.25442,
102489.66555,	102494.07670,	102498.48786,	102502.89904,	102507.31024,	102511.72146,	102516.13269,	102520.54394,	102524.95520,	102529.36649,
102533.77779,	102538.18910,	102542.60044,	102547.01179,	102551.42315,	102555.83454,	102560.24594,	102564.65736,	102569.06879,	102573.48024,
102577.89171,	102582.30320,	102586.71470,	102591.12622,	102595.53775,	102599.94930,	102604.36087,	102608.77246,	102613.18406,	102617.59568,
102622.00732,	102626.41897,	102630.83064,	102635.24233,	102639.65403,	102644.06575,	102648.47749,	102652.88925,	102657.30102,	102661.71280,
102666.12461,	102670.53643,	102674.94827,	102679.36012,	102683.77200,	102688.18389,	102692.59579,	102697.00771,	102701.41965,	102705.83161,
102710.24358,	102714.65557,	102719.06758,	102723.47960,	102727.89164,	102732.30370,	102736.71577,	102741.12787,	102745.53997,	102749.95210,
102754.36424,	102758.77640,	102763.18857,	102767.60076,	102772.01297,	102776.42520,	102780.83744,	102785.24970,	102789.66197,	102794.07427,
102798.48658,	102802.89890,	102807.31124,	102811.72360,	102816.13598,	102820.54837,	102824.96078,	102829.37321,	102833.78565,	102838.19812,
102842.61059,	102847.02309,	102851.43560,	102855.84813,	102860.26067,	102864.67323,	102869.08581,	102873.49840,	102877.91102,	102882.32364,
102886.73629,	102891.14895,	102895.56163,	102899.97433,	102904.38704,	102908.79977,	102913.21251,	102917.62528,	102922.03806,	102926.45085,
102930.86367,	102935.27650,	102939.68934,	102944.10221,	102948.51509,	102952.92798,	102957.34090,	102961.75383,	102966.16678,	102970.57974,
102974.99272,	102979.40572,	102983.81873,	102988.23177,	102992.64481,	102997.05788,	103001.47096,	103005.88406,	103010.29717,	103014.71031,
103019.12346,	103023.53662,	103027.94980,	103032.36300,	103036.77622,	103041.18945,	103045.60270,	103050.01597,	103054.42925,	103058.84255,
103063.25587,	103067.66920,	103072.08255,	103076.49592,	103080.90930,	103085.32270,	103089.73612,	103094.14955,	103098.56300,	103102.97647,
103107.38995,	103111.80345,	103116.21697,	103120.63051,	103125.04406,	103129.45763,	103133.87121,	103138.28481,	103142.69843,	103147.11207,
103151.52572,	103155.93939,	103160.35307,	103164.76677,	103169.18049,	103173.59423,	103178.00798,	103182.42175,	103186.83553,	103191.24934,
103195.66316,	103200.07699,	103204.49084,	103208.90471,	103213.31860,	103217.73250,	103222.14642,	103226.56036,	103230.97431,	103235.38828,
103239.80227,	103244.21627,	103248.63029,	103253.04433,	103257.45838,	103261.87245,	103266.28654,	103270.70065,	103275.11477,	103279.52890,
103283.94306,	103288.35723,	103292.77142,	103297.18562,	103301.59984,	103306.01408,	103310.42833,	103314.84260,	103319.25689,	103323.67120,
103328.08552,	103332.49986,	103336.91421,	103341.32858,	103345.74297,	103350.15738,	103354.57180,	103358.98624,	103363.40069,	103367.81516,
103372.22965,	103376.64416,	103381.05868,	103385.47322,	103389.88777,	103394.30235,	103398.71694,	103403.13154,	103407.54616,	103411.96080,
103416.37546,	103420.79013,	103425.20482,	103429.61953,	103434.03425,	103438.44899,	103442.86375,	103447.27852,	103451.69331,	103456.10811,
103460.52294,	103464.93778,	103469.35263,	103473.76751,	103478.18240,	103482.59730,	103487.01223,	103491.42717,	103495.84212,	103500.25710,
103504.67209,	103509.08709,	103513.50212,	103517.91716,	103522.33221,	103526.74729,	103531.16238,	103535.57748,	103539.99261,	103544.40775,
103548.82290,	103553.23808,	103557.65327,	103562.06848,	103566.48370,	103570.89894,	103575.31420,	103579.72947,	103584.14476,	103588.56007,
103592.97539,	103597.39073,	103601.80609,	103606.22147,	103610.63686,	103615.05226,	103619.46769,	103623.88313,	103628.29859,	103632.71406,
103637.12955,	103641.54506,	103645.96058,	103650.37612,	103654.79168,	103659.20726,	103663.62285,	103668.03845,	103672.45408,	103676.86972,
103681.28538,	103685.70105,	103690.11674,	103694.53245,	103698.94817,	103703.36392,	103707.77967,	103712.19545,	103716.61124,	103721.02705,
103725.44287,	103729.85871,	103734.27457,	103738.69044,	103743.10634,	103747.52224,	103751.93817,	103756.35411,	103760.77007,	103765.18604,
103769.60203,	103774.01804,	103778.43406,	103782.85010,	103787.26616,	103791.68224,	103796.09833,	103800.51444,	103804.93056,	103809.34670,
103813.76286,	103818.17903,	103822.59522,	103827.01143,	103831.42766,	103835.84390,	103840.26015,	103844.67643,	103849.09272,	103853.50903,
103857.92535,	103862.34169,	103866.75805,	103871.17442,	103875.59082,	103880.00722,	103884.42365,	103888.84009,	103893.25655,	103897.67302,
103902.08951,	103906.50602,	103910.92254,	103915.33908,	103919.75564,	103924.17221,	103928.58880,	103933.00541,	103937.42203,	103941.83868,
103946.25533,	103950.67201,	103955.08870,	103959.50540,	103963.92213,	103968.33887,	103972.75562,	103977.17240,	103981.58919,	103986.00600,
103990.42282,	103994.83966,	103999.25652,	104003.67339,	104008.09028,	104012.50719,	104016.92411,	104021.34105,	104025.75801,	104030.17498,
104034.59197,	104039.00898,	104043.42600,	104047.84304,	104052.26009,	104056.67717,	104061.09426,	104065.51136,	104069.92849,	104074.34563,
104078.76278,	104083.17995,	104087.59714,	104092.01435,	104096.43157,	104100.84881,	104105.26607,	104109.68334,	104114.10063,	104118.51793,
104122.93526,	104127.35259,	104131.76995,	104136.18732,	104140.60471,	104145.02212,	104149.43954,	104153.85698,	104158.27443,	104162.69190,
104167.10939,	104171.52690,	104175.94442,	104180.36196,	104184.77951,	104189.19708,	104193.61467,	104198.03227,	104202.44990,	104206.86753,
104211.28519,	104215.70286,	104220.12055,	104224.53825,	104228.95597,	104233.37371,	104237.79146,	104242.20923,	104246.62702,	104251.04482,
104255.46264,	104259.88048,	104264.29833,	104268.71620,	104273.13409,	104277.55199,	104281.96991,	104286.38785,	104290.80580,	104295.22377,
104299.64176,	104304.05976,	104308.47778,	104312.89582,	104317.31387,	104321.73194,	104326.15003,	104330.56813,	104334.98625,	104339.40438,
104343.82253,	104348.24070,	104352.65889,	104357.07709,	104361.49531,	104365.91354,	104370.33179,	104374.75006,	104379.16835,	104383.58665,
104388.00497,	104392.42330,	104396.84165,	104401.26002,	104405.67840,	104410.09680,	104414.51522,	104418.93366,	104423.35211,	104427.77057,
104432.18906,	104436.60756,	104441.02607,	104445.44461,	104449.86316,	104454.28172,	104458.70031,	104463.11891,	104467.53752,	104471.95615,
104476.37480,	104480.79347,	104485.21215,	104489.63085,	104494.04957,	104498.46830,	104502.88705,	104507.30581,	104511.72459,	104516.14339,
104520.56221,	104524.98104,	104529.39989,	104533.81875,	104538.23763,	104542.65653,	104547.07544,	104551.49437,	104555.91332,	104560.33229,
104564.75127,	104569.17026,	104573.58928,	104578.00831,	104582.42735,	104586.84642,	104591.26550,	104595.68459,	104600.10370,	104604.52283,
104608.94198,	104613.36114,	104617.78032,	104622.19952,	104626.61873,	104631.03796,	104635.45720,	104639.87646,	104644.29574,	104648.71504,
104653.13435,	104657.55368,	104661.97302,	104666.39238,	104670.81176,	104675.23115,	104679.65056,	104684.06999,	104688.48943,	104692.90889,
104697.32837,	104701.74786,	104706.16737,	104710.58690,	104715.00644,	104719.42600,	104723.84558,	104728.26517,	104732.68478,	104737.10440,
104741.52405,	104745.94370,	104750.36338,	104754.78307,	104759.20278,	104763.62250,	104768.04224,	104772.46200,	104776.88178,	104781.30157,
104785.72137,	104790.14120,	104794.56104,	104798.98089,	104803.40077,	104807.82066,	104812.24056,	104816.66049,	104821.08042,	104825.50038,
104829.92035,	104834.34034,	104838.76035,	104843.18037,	104847.60041,	104852.02046,	104856.44053,	104860.86062,	104865.28073,	104869.70085,
104874.12098,	104878.54114,	104882.96131,	104887.38149,	104891.80170,	104896.22192,	104900.64215,	104905.06241,	104909.48268,	104913.90296,
104918.32326,	104922.74358,	104927.16392,	104931.58427,	104936.00464,	104940.42502,	104944.84543,	104949.26584,	104953.68628,	104958.10673,
104962.52720,	104966.94768,	104971.36818,	104975.78870,	104980.20923,	104984.62978,	104989.05035,	104993.47093,	104997.89153,	105002.31214,
105006.73278,	105011.15343,	105015.57409,	105019.99477,	105024.41547,	105028.83618,	105033.25692,	105037.67766,	105042.09843,	105046.51921,
105050.94001,	105055.36082,	105059.78165,	105064.20250,	105068.62336,	105073.04424,	105077.46513,	105081.88605,	105086.30698,	105090.72792,
105095.14888,	105099.56986,	105103.99086,	105108.41187,	105112.83290,	105117.25394,	105121.67500,	105126.09608,	105130.51717,	105134.93828,
105139.35941,	105143.78055,	105148.20171,	105152.62289,	105157.04408,	105161.46529,	105165.88651,	105170.30776,	105174.72901,	105179.15029,
105183.57158,	105187.99289,	105192.41421,	105196.83555,	105201.25691,	105205.67828,	105210.09967,	105214.52108,	105218.94250,	105223.36394,
105227.78540,	105232.20687,	105236.62836,	105241.04986,	105245.47139,	105249.89292,	105254.31448,	105258.73605,	105263.15764,	105267.57924,
105272.00086,	105276.42250,	105280.84415,	105285.26582,	105289.68751,	105294.10921,	105298.53093,	105302.95266,	105307.37442,	105311.79618,
105316.21797,	105320.63977,	105325.06159,	105329.48342,	105333.90527,	105338.32714,	105342.74902,	105347.17092,	105351.59284,	105356.01477,
105360.43672,	105364.85869,	105369.28067,	105373.70267,	105378.12468,	105382.54671,	105386.96876,	105391.39083,	105395.81291,	105400.23500,
105404.65712,	105409.07925,	105413.50139,	105417.92356,	105422.34574,	105426.76793,	105431.19014,	105435.61237,	105440.03462,	105444.45688,
105448.87916,	105453.30145,	105457.72376,	105462.14609,	105466.56843,	105470.99079,	105475.41317,	105479.83556,	105484.25797,	105488.68040,
105493.10284,	105497.52530,	105501.94777,	105506.37026,	105510.79277,	105515.21530,	105519.63784,	105524.06039,	105528.48297,	105532.90556,
105537.32816,	105541.75079,	105546.17343,	105550.59608,	105555.01875,	105559.44144,	105563.86415,	105568.28687,	105572.70960,	105577.13236,
105581.55513,	105585.97792,	105590.40072,	105594.82354,	105599.24637,	105603.66923,	105608.09210,	105612.51498,	105616.93788,	105621.36080,
105625.78373,	105630.20669,	105634.62965,	105639.05264,	105643.47564,	105647.89865,	105652.32169,	105656.74473,	105661.16780,	105665.59088,
105670.01398,	105674.43710,	105678.86023,	105683.28337,	105687.70654,	105692.12972,	105696.55291,	105700.97613,	105705.39936,	105709.82260,
105714.24587,	105718.66914,	105723.09244,	105727.51575,	105731.93908,	105736.36242,	105740.78578,	105745.20916,	105749.63255,	105754.05596,
105758.47939,	105762.90283,	105767.32629,	105771.74977,	105776.17326,	105780.59677,	105785.02029,	105789.44383,	105793.86739,	105798.29096,
105802.71455,	105807.13816,	105811.56178,	105815.98542,	105820.40907,	105824.83275,	105829.25643,	105833.68014,	105838.10386,	105842.52760,
105846.95135,	105851.37512,	105855.79891,	105860.22271,	105864.64653,	105869.07036,	105873.49422,	105877.91808,	105882.34197,	105886.76587,
105891.18979,	105895.61372,	105900.03767,	105904.46164,	105908.88562,	105913.30962,	105917.73363,	105922.15767,	105926.58171,	105931.00578,
105935.42986,	105939.85396,	105944.27807,	105948.70220,	105953.12635,	105957.55051,	105961.97469,	105966.39888,	105970.82310,	105975.24732,
105979.67157,	105984.09583,	105988.52011,	105992.94440,	105997.36871,	106001.79304,	106006.21738,	106010.64174,	106015.06611,	106019.49050,
106023.91491,	106028.33934,	106032.76378,	106037.18823,	106041.61271,	106046.03720,	106050.46170,	106054.88622,	106059.31076,	106063.73532,
106068.15989,	106072.58448,	106077.00908,	106081.43370,	106085.85834,	106090.28299,	106094.70766,	106099.13235,	106103.55705,	106107.98177,
106112.40650,	106116.83125,	106121.25602,	106125.68080,	106130.10560,	106134.53042,	106138.95525,	106143.38010,	106147.80497,	106152.22985,
106156.65475,	106161.07966,	106165.50459,	106169.92954,	106174.35450,	106178.77948,	106183.20448,	106187.62949,	106192.05452,	106196.47956,
106200.90462,	106205.32970,	106209.75479,	106214.17990,	106218.60503,	106223.03017,	106227.45533,	106231.88051,	106236.30570,	106240.73091,
106245.15613,	106249.58137,	106254.00663,	106258.43190,	106262.85719,	106267.28250,	106271.70782,	106276.13316,	106280.55851,	106284.98389,
106289.40927,	106293.83468,	106298.26010,	106302.68553,	106307.11099,	106311.53646,	106315.96194,	106320.38744,	106324.81296,	106329.23849,
106333.66405,	106338.08961,	106342.51520,	106346.94079,	106351.36641,	106355.79204,	106360.21769,	106364.64336,	106369.06904,	106373.49473,
106377.92045,	106382.34618,	106386.77192,	106391.19769,	106395.62346,	106400.04926,	106404.47507,	106408.90090,	106413.32674,	106417.75260,
106422.17848,	106426.60437,	106431.03028,	106435.45621,	106439.88215,	106444.30810,	106448.73408,	106453.16007,	106457.58608,	106462.01210,
106466.43814,	106470.86419,	106475.29027,	106479.71635,	106484.14246,	106488.56858,	106492.99472,	106497.42087,	106501.84704,	106506.27322,
106510.69943,	106515.12565,	106519.55188,	106523.97813,	106528.40440,	106532.83068,	106537.25698,	106541.68330,	106546.10963,	106550.53598,
106554.96234,	106559.38872,	106563.81512,	106568.24153,	106572.66796,	106577.09441,	106581.52087,	106585.94735,	106590.37385,	106594.80036,
106599.22689,	106603.65343,	106608.07999,	106612.50657,	106616.93316,	106621.35977,	106625.78639,	106630.21303,	106634.63969,	106639.06637,
106643.49306,	106647.91976,	106652.34648,	106656.77322,	106661.19998,	106665.62675,	106670.05354,	106674.48034,	106678.90716,	106683.33400,
106687.76085,	106692.18772,	106696.61461,	106701.04151,	106705.46842,	106709.89536,	106714.32231,	106718.74928,	106723.17626,	106727.60326,
106732.03027,	106736.45730,	106740.88435,	106745.31142,	106749.73850,	106754.16559,	106758.59270,	106763.01983,	106767.44698,	106771.87414,
106776.30132,	106780.72851,	106785.15572,	106789.58295,	106794.01019,	106798.43745,	106802.86472,	106807.29202,	106811.71932,	106816.14665,
106820.57399,	106825.00134,	106829.42872,	106833.85610,	106838.28351,	106842.71093,	106847.13837,	106851.56582,	106855.99329,	106860.42078,
106864.84828,	106869.27580,	106873.70333,	106878.13088,	106882.55845,	106886.98604,	106891.41364,	106895.84125,	106900.26888,	106904.69653,
106909.12420,	106913.55188,	106917.97957,	106922.40729,	106926.83502,	106931.26276,	106935.69052,	106940.11830,	106944.54610,	106948.97391,
106953.40173,	106957.82958,	106962.25744,	106966.68531,	106971.11320,	106975.54111,	106979.96904,	106984.39698,	106988.82493,	106993.25291,
106997.68089,	107002.10890,	107006.53692,	107010.96496,	107015.39301,	107019.82108,	107024.24917,	107028.67727,	107033.10539,	107037.53352,
107041.96167,	107046.38984,	107050.81803,	107055.24622,	107059.67444,	107064.10267,	107068.53092,	107072.95919,	107077.38747,	107081.81576,
107086.24408,	107090.67240,	107095.10075,	107099.52911,	107103.95749,	107108.38588,	107112.81429,	107117.24272,	107121.67116,	107126.09962,
107130.52810,	107134.95659,	107139.38510,	107143.81362,	107148.24216,	107152.67071,	107157.09929,	107161.52787,	107165.95648,	107170.38510,
107174.81374,	107179.24239,	107183.67106,	107188.09974,	107192.52845,	107196.95716,	107201.38590,	107205.81465,	107210.24341,	107214.67220,
107219.10100,	107223.52981,	107227.95864,	107232.38749,	107236.81635,	107241.24523,	107245.67413,	107250.10304,	107254.53197,	107258.96091,
107263.38987,	107267.81885,	107272.24784,	107276.67685,	107281.10588,	107285.53492,	107289.96397,	107294.39305,	107298.82214,	107303.25124,
107307.68037,	107312.10950,	107316.53866,	107320.96783,	107325.39702,	107329.82622,	107334.25544,	107338.68467,	107343.11393,	107347.54319,
107351.97248,	107356.40178,	107360.83109,	107365.26043,	107369.68977,	107374.11914,	107378.54852,	107382.97792,	107387.40733,	107391.83676,
107396.26620,	107400.69567,	107405.12514,	107409.55464,	107413.98415,	107418.41367,	107422.84322,	107427.27277,	107431.70235,	107436.13194,
107440.56155,	107444.99117,	107449.42081,	107453.85046,	107458.28014,	107462.70982,	107467.13953,	107471.56925,	107475.99898,	107480.42874,
107484.85850,	107489.28829,	107493.71809,	107498.14791,	107502.57774,	107507.00759,	107511.43745,	107515.86734,	107520.29723,	107524.72715,
107529.15708,	107533.58702,	107538.01698,	107542.44696,	107546.87696,	107551.30697,	107555.73699,	107560.16704,	107564.59710,	107569.02717,
107573.45726,	107577.88737,	107582.31749,	107586.74763,	107591.17779,	107595.60796,	107600.03815,	107604.46835,	107608.89857,	107613.32881,
107617.75906,	107622.18933,	107626.61961,	107631.04992,	107635.48023,	107639.91057,	107644.34092,	107648.77128,	107653.20166,	107657.63206,
107662.06247,	107666.49290,	107670.92335,	107675.35381,	107679.78429,	107684.21478,	107688.64529,	107693.07582,	107697.50636,	107701.93692,
107706.36750,	107710.79809,	107715.22870,	107719.65932,	107724.08996,	107728.52061,	107732.95128,	107737.38197,	107741.81268,	107746.24340,
107750.67413,	107755.10488,	107759.53565,	107763.96644,	107768.39724,	107772.82805,	107777.25889,	107781.68973,	107786.12060,	107790.55148,
107794.98238,	107799.41329,	107803.84422,	107808.27517,	107812.70613,	107817.13710,	107821.56810,	107825.99911,	107830.43013,	107834.86118,
107839.29223,	107843.72331,	107848.15440,	107852.58550,	107857.01663,	107861.44777,	107865.87892,	107870.31009,	107874.74128,	107879.17248,
107883.60370,	107888.03493,	107892.46619,	107896.89745,	107901.32874,	107905.76004,	107910.19135,	107914.62268,	107919.05403,	107923.48539,
107927.91677,	107932.34817,	107936.77958,	107941.21101,	107945.64245,	107950.07391,	107954.50539,	107958.93688,	107963.36839,	107967.79992,
107972.23146,	107976.66301,	107981.09459,	107985.52618,	107989.95778,	107994.38940,	107998.82104,	108003.25269,	108007.68436,	108012.11605,
108016.54775,	108020.97947,	108025.41120,	108029.84295,	108034.27471,	108038.70650,	108043.13829,	108047.57011,	108052.00194,	108056.43378,
108060.86565,	108065.29752,	108069.72942,	108074.16133,	108078.59325,	108083.02520,	108087.45716,	108091.88913,	108096.32112,	108100.75313,
108105.18515,	108109.61719,	108114.04924,	108118.48132,	108122.91340,	108127.34551,	108131.77762,	108136.20976,	108140.64191,	108145.07408,
108149.50626,	108153.93846,	108158.37068,	108162.80291,	108167.23516,	108171.66742,	108176.09970,	108180.53199,	108184.96431,	108189.39663,
108193.82898,	108198.26134,	108202.69371,	108207.12611,	108211.55851,	108215.99094,	108220.42338,	108224.85583,	108229.28831,	108233.72079,
108238.15330,	108242.58582,	108247.01836,	108251.45091,	108255.88348,	108260.31606,	108264.74866,	108269.18128,	108273.61391,	108278.04656,
108282.47922,	108286.91190,	108291.34460,	108295.77731,	108300.21004,	108304.64279,	108309.07555,	108313.50833,	108317.94112,	108322.37393,
108326.80675,	108331.23959,	108335.67245,	108340.10532,	108344.53821,	108348.97112,	108353.40404,	108357.83698,	108362.26993,	108366.70290,
108371.13588,	108375.56889,	108380.00190,	108384.43494,	108388.86799,	108393.30105,	108397.73413,	108402.16723,	108406.60034,	108411.03347,
108415.46662,	108419.89978,	108424.33296,	108428.76615,	108433.19936,	108437.63259,	108442.06583,	108446.49909,	108450.93236,	108455.36565,
108459.79896,	108464.23228,	108468.66561,	108473.09897,	108477.53234,	108481.96572,	108486.39913,	108490.83254,	108495.26598,	108499.69943,
108504.13289,	108508.56637,	108512.99987,	108517.43339,	108521.86692,	108526.30046,	108530.73402,	108535.16760,	108539.60120,	108544.03481,
108548.46843,	108552.90207,	108557.33573,	108561.76940,	108566.20309,	108570.63680,	108575.07052,	108579.50426,	108583.93801,	108588.37178,
108592.80557,	108597.23937,	108601.67319,	108606.10702,	108610.54087,	108614.97474,	108619.40862,	108623.84252,	108628.27643,	108632.71036,
108637.14431,	108641.57827,	108646.01225,	108650.44624,	108654.88025,	108659.31428,	108663.74832,	108668.18238,	108672.61645,	108677.05054,
108681.48464,	108685.91877,	108690.35290,	108694.78706,	108699.22123,	108703.65541,	108708.08961,	108712.52383,	108716.95806,	108721.39231,
108725.82658,	108730.26086,	108734.69516,	108739.12947,	108743.56380,	108747.99815,	108752.43251,	108756.86688,	108761.30128,	108765.73569,
108770.17011,	108774.60455,	108779.03901,	108783.47348,	108787.90797,	108792.34248,	108796.77700,	108801.21154,	108805.64609,	108810.08066,
108814.51524,	108818.94984,	108823.38446,	108827.81909,	108832.25374,	108836.68841,	108841.12309,	108845.55778,	108849.99250,	108854.42722,
108858.86197,	108863.29673,	108867.73151,	108872.16630,	108876.60111,	108881.03593,	108885.47077,	108889.90563,	108894.34050,	108898.77539,
108903.21029,	108907.64521,	108912.08015,	108916.51510,	108920.95007,	108925.38505,	108929.82005,	108934.25507,	108938.69010,	108943.12515,
108947.56021,	108951.99529,	108956.43039,	108960.86550,	108965.30062,	108969.73577,	108974.17093,	108978.60610,	108983.04129,	108987.47650,
108991.91172,	108996.34696,	109000.78222,	109005.21749,	109009.65277,	109014.08808,	109018.52340,	109022.95873,	109027.39408,	109031.82945,
109036.26483,	109040.70023,	109045.13564,	109049.57107,	109054.00652,	109058.44198,	109062.87746,	109067.31295,	109071.74846,	109076.18399,
109080.61953,	109085.05509,	109089.49066,	109093.92625,	109098.36186,	109102.79748,	109107.23312,	109111.66877,	109116.10444,	109120.54012,
109124.97583,	109129.41154,	109133.84727,	109138.28302,	109142.71879,	109147.15457,	109151.59037,	109156.02618,	109160.46201,	109164.89785,
109169.33371,	109173.76959,	109178.20548,	109182.64139,	109187.07731,	109191.51325,	109195.94921,	109200.38518,	109204.82117,	109209.25717,
109213.69319,	109218.12923,	109222.56528,	109227.00134,	109231.43743,	109235.87353,	109240.30964,	109244.74577,	109249.18192,	109253.61808,
109258.05426,	109262.49045,	109266.92666,	109271.36289,	109275.79913,	109280.23539,	109284.67166,	109289.10795,	109293.54426,	109297.98058,
109302.41692,	109306.85327,	109311.28964,	109315.72603,	109320.16243,	109324.59885,	109329.03528,	109333.47173,	109337.90819,	109342.34467,
109346.78117,	109351.21768,	109355.65421,	109360.09076,	109364.52732,	109368.96389,	109373.40048,	109377.83709,	109382.27372,	109386.71035,
109391.14701,	109395.58368,	109400.02037,	109404.45707,	109408.89379,	109413.33053,	109417.76728,	109422.20404,	109426.64083,	109431.07763,
109435.51444,	109439.95127,	109444.38812,	109448.82498,	109453.26186,	109457.69875,	109462.13566,	109466.57258,	109471.00953,	109475.44648,
109479.88346,	109484.32045,	109488.75745,	109493.19447,	109497.63151,	109502.06856,	109506.50563,	109510.94271,	109515.37981,	109519.81693,
109524.25406,	109528.69121,	109533.12837,	109537.56555,	109542.00275,	109546.43996,	109550.87719,	109555.31443,	109559.75169,	109564.18896,
109568.62625,	109573.06356,	109577.50088,	109581.93822,	109586.37558,	109590.81295,	109595.25033,	109599.68773,	109604.12515,	109608.56258,
109613.00003,	109617.43750,	109621.87498,	109626.31248,	109630.74999,	109635.18752,	109639.62506,	109644.06262,	109648.50020,	109652.93779,
109657.37540,	109661.81302,	109666.25066,	109670.68832,	109675.12599,	109679.56368,	109684.00138,	109688.43910,	109692.87683,	109697.31458,
109701.75235,	109706.19013,	109710.62793,	109715.06574,	109719.50357,	109723.94142,	109728.37928,	109732.81716,	109737.25505,	109741.69296,
109746.13089,	109750.56883,	109755.00678,	109759.44476,	109763.88274,	109768.32075,	109772.75877,	109777.19680,	109781.63486,	109786.07292,
109790.51101,	109794.94911,	109799.38722,	109803.82535,	109808.26350,	109812.70166,	109817.13984,	109821.57803,	109826.01624,	109830.45447,
109834.89271,	109839.33097,	109843.76924,	109848.20753,	109852.64583,	109857.08416,	109861.52249,	109865.96084,	109870.39921,	109874.83760,
109879.27600,	109883.71441,	109888.15284,	109892.59129,	109897.02975,	109901.46823,	109905.90673,	109910.34524,	109914.78377,	109919.22231,
109923.66087,	109928.09944,	109932.53803,	109936.97664,	109941.41526,	109945.85389,	109950.29255,	109954.73122,	109959.16990,	109963.60860,
109968.04732,	109972.48605,	109976.92480,	109981.36356,	109985.80234,	109990.24114,	109994.67995,	109999.11878,	110003.55762,	110007.99648,
110012.43535,	110016.87424,	110021.31315,	110025.75207,	110030.19101,	110034.62996,	110039.06893,	110043.50792,	110047.94692,	110052.38593,
110056.82497,	110061.26401,	110065.70308,	110070.14216,	110074.58125,	110079.02037,	110083.45949,	110087.89864,	110092.33779,	110096.77697,
110101.21616,	110105.65537,	110110.09459,	110114.53383,	110118.97308,	110123.41235,	110127.85163,	110132.29094,	110136.73025,	110141.16959,
110145.60893,	110150.04830,	110154.48768,	110158.92707,	110163.36649,	110167.80591,	110172.24536,	110176.68482,	110181.12429,	110185.56378,
110190.00329,	110194.44281,	110198.88235,	110203.32190,	110207.76147,	110212.20106,	110216.64066,	110221.08027,	110225.51991,	110229.95956,
110234.39922,	110238.83890,	110243.27860,	110247.71831,	110252.15803,	110256.59778,	110261.03754,	110265.47731,	110269.91710,	110274.35691,
110278.79673,	110283.23657,	110287.67642,	110292.11629,	110296.55617,	110300.99608,	110305.43599,	110309.87592,	110314.31587,	110318.75584,
110323.19582,	110327.63581,	110332.07582,	110336.51585,	110340.95589,	110345.39595,	110349.83603,	110354.27612,	110358.71622,	110363.15634,
110367.59648,	110372.03663,	110376.47680,	110380.91699,	110385.35719,	110389.79740,	110394.23764,	110398.67788,	110403.11815,	110407.55843,
110411.99872,	110416.43903,	110420.87936,	110425.31970,	110429.76006,	110434.20043,	110438.64082,	110443.08123,	110447.52165,	110451.96209,
110456.40254,	110460.84301,	110465.28349,	110469.72399,	110474.16451,	110478.60504,	110483.04558,	110487.48615,	110491.92672,	110496.36732,
110500.80793,	110505.24855,	110509.68920,	110514.12985,	110518.57053,	110523.01122,	110527.45192,	110531.89264,	110536.33338,	110540.77413,
110545.21490,	110549.65568,	110554.09648,	110558.53729,	110562.97812,	110567.41897,	110571.85983,	110576.30071,	110580.74160,	110585.18251,
110589.62344,	110594.06438,	110598.50533,	110602.94630,	110607.38729,	110611.82830,	110616.26931,	110620.71035,	110625.15140,	110629.59247,
110634.03355,	110638.47465,	110642.91576,	110647.35689,	110651.79803,	110656.23920,	110660.68037,	110665.12156,	110669.56277,	110674.00400,
110678.44523,	110682.88649,	110687.32776,	110691.76905,	110696.21035,	110700.65167,	110705.09300,	110709.53435,	110713.97572,	110718.41710,
110722.85849,	110727.29991,	110731.74133,	110736.18278,	110740.62424,	110745.06571,	110749.50720,	110753.94871,	110758.39023,	110762.83177,
110767.27332,	110771.71489,	110776.15648,	110780.59808,	110785.03970,	110789.48133,	110793.92298,	110798.36464,	110802.80632,	110807.24801,
110811.68973,	110816.13145,	110820.57319,	110825.01495,	110829.45673,	110833.89852,	110838.34032,	110842.78214,	110847.22398,	110851.66583,
110856.10770,	110860.54958,	110864.99148,	110869.43340,	110873.87533,	110878.31727,	110882.75923,	110887.20121,	110891.64321,	110896.08521,
110900.52724,	110904.96928,	110909.41134,	110913.85341,	110918.29550,	110922.73760,	110927.17972,	110931.62185,	110936.06400,	110940.50617,
110944.94835,	110949.39055,	110953.83276,	110958.27499,	110962.71724,	110967.15950,	110971.60177,	110976.04406,	110980.48637,	110984.92869,
110989.37103,	110993.81339,	110998.25576,	111002.69814,	111007.14054,	111011.58296,	111016.02539,	111020.46784,	111024.91031,	111029.35279,
111033.79528,	111038.23779,	111042.68032,	111047.12286,	111051.56542,	111056.00799,	111060.45058,	111064.89319,	111069.33581,	111073.77845,
111078.22110,	111082.66377,	111087.10645,	111091.54915,	111095.99186,	111100.43459,	111104.87734,	111109.32010,	111113.76288,	111118.20567,
111122.64848,	111127.09131,	111131.53415,	111135.97700,	111140.41987,	111144.86276,	111149.30566,	111153.74858,	111158.19152,	111162.63447,
111167.07743,	111171.52041,	111175.96341,	111180.40642,	111184.84945,	111189.29249,	111193.73555,	111198.17863,	111202.62172,	111207.06483,
111211.50795,	111215.95109,	111220.39424,	111224.83741,	111229.28059,	111233.72379,	111238.16701,	111242.61024,	111247.05349,	111251.49675,
111255.94003,	111260.38332,	111264.82663,	111269.26996,	111273.71330,	111278.15666,	111282.60003,	111287.04342,	111291.48682,	111295.93024,
111300.37368,	111304.81713,	111309.26059,	111313.70408,	111318.14757,	111322.59109,	111327.03462,	111331.47816,	111335.92172,	111340.36530,
111344.80889,	111349.25250,	111353.69612,	111358.13976,	111362.58341,	111367.02708,	111371.47077,	111375.91447,	111380.35818,	111384.80192,
111389.24566,	111393.68943,	111398.13321,	111402.57700,	111407.02081,	111411.46464,	111415.90848,	111420.35234,	111424.79621,	111429.24010,
111433.68400,	111438.12792,	111442.57186,	111447.01581,	111451.45978,	111455.90376,	111460.34776,	111464.79177,	111469.23580,	111473.67984,
111478.12390,	111482.56798,	111487.01207,	111491.45618,	111495.90030,	111500.34444,	111504.78859,	111509.23276,	111513.67695,	111518.12115,
111522.56537,	111527.00960,	111531.45385,	111535.89811,	111540.34239,	111544.78668,	111549.23099,	111553.67532,	111558.11966,	111562.56402,
111567.00839,	111571.45278,	111575.89718,	111580.34160,	111584.78604,	111589.23049,	111593.67496,	111598.11944,	111602.56394,	111607.00845,
111611.45298,	111615.89752,	111620.34208,	111624.78666,	111629.23125,	111633.67586,	111638.12048,	111642.56512,	111647.00977,	111651.45444,
111655.89912,	111660.34382,	111664.78854,	111669.23327,	111673.67802,	111678.12278,	111682.56756,	111687.01235,	111691.45716,	111695.90199,
111700.34683,	111704.79169,	111709.23656,	111713.68145,	111718.12635,	111722.57127,	111727.01620,	111731.46115,	111735.90612,	111740.35110,
111744.79610,	111749.24111,	111753.68614,	111758.13118,	111762.57624,	111767.02131,	111771.46640,	111775.91151,	111780.35663,	111784.80177,
111789.24692,	111793.69209,	111798.13727,	111802.58247,	111807.02769,	111811.47292,	111815.91816,	111820.36342,	111824.80870,	111829.25399,
111833.69930,	111838.14463,	111842.58997,	111847.03532,	111851.48069,	111855.92608,	111860.37148,	111864.81690,	111869.26233,	111873.70778,
111878.15324,	111882.59872,	111887.04422,	111891.48973,	111895.93525,	111900.38080,	111904.82635,	111909.27193,	111913.71752,	111918.16312,
111922.60874,	111927.05437,	111931.50003,	111935.94569,	111940.39137,	111944.83707,	111949.28278,	111953.72851,	111958.17426,	111962.62002,
111967.06579,	111971.51158,	111975.95739,	111980.40321,	111984.84905,	111989.29490,	111993.74077,	111998.18666,	112002.63256,	112007.07847,
112011.52440,	112015.97035,	112020.41631,	112024.86229,	112029.30828,	112033.75429,	112038.20032,	112042.64635,	112047.09241,	112051.53848,
112055.98457,	112060.43067,	112064.87679,	112069.32292,	112073.76907,	112078.21523,	112082.66141,	112087.10761,	112091.55382,	112096.00005,
112100.44629,	112104.89255,	112109.33882,	112113.78511,	112118.23141,	112122.67773,	112127.12407,	112131.57042,	112136.01678,	112140.46316,
112144.90956,	112149.35597,	112153.80240,	112158.24885,	112162.69531,	112167.14178,	112171.58827,	112176.03478,	112180.48130,	112184.92784,
112189.37439,	112193.82096,	112198.26754,	112202.71414,	112207.16076,	112211.60739,	112216.05403,	112220.50069,	112224.94737,	112229.39406,
112233.84077,	112238.28749,	112242.73423,	112247.18099,	112251.62776,	112256.07454,	112260.52135,	112264.96816,	112269.41499,	112273.86184,
112278.30870,	112282.75558,	112287.20248,	112291.64939,	112296.09631,	112300.54325,	112304.99021,	112309.43718,	112313.88417,	112318.33117,
112322.77819,	112327.22522,	112331.67227,	112336.11934,	112340.56642,	112345.01352,	112349.46063,	112353.90775,	112358.35490,	112362.80205,
112367.24923,	112371.69642,	112376.14362,	112380.59084,	112385.03808,	112389.48533,	112393.93260,	112398.37988,	112402.82717,	112407.27449,
112411.72182,	112416.16916,	112420.61652,	112425.06390,	112429.51129,	112433.95869,	112438.40611,	112442.85355,	112447.30100,	112451.74847,
112456.19596,	112460.64345,	112465.09097,	112469.53850,	112473.98604,	112478.43361,	112482.88118,	112487.32877,	112491.77638,	112496.22401,
112500.67164,	112505.11930,	112509.56697,	112514.01465,	112518.46235,	112522.91007,	112527.35780,	112531.80555,	112536.25331,	112540.70109,
112545.14888,	112549.59669,	112554.04452,	112558.49236,	112562.94021,	112567.38808,	112571.83597,	112576.28387,	112580.73179,	112585.17972,
112589.62767,	112594.07563,	112598.52361,	112602.97161,	112607.41962,	112611.86764,	112616.31568,	112620.76374,	112625.21181,	112629.65990,
112634.10800,	112638.55612,	112643.00426,	112647.45241,	112651.90057,	112656.34875,	112660.79695,	112665.24516,	112669.69339,	112674.14163,
112678.58989,	112683.03816,	112687.48645,	112691.93475,	112696.38307,	112700.83141,	112705.27976,	112709.72812,	112714.17651,	112718.62490,
112723.07332,	112727.52174,	112731.97019,	112736.41865,	112740.86712,	112745.31561,	112749.76412,	112754.21264,	112758.66117,	112763.10972,
112767.55829,	112772.00687,	112776.45547,	112780.90409,	112785.35272,	112789.80136,	112794.25002,	112798.69870,	112803.14739,	112807.59609,
112812.04481,	112816.49355,	112820.94230,	112825.39107,	112829.83986,	112834.28865,	112838.73747,	112843.18630,	112847.63514,	112852.08401,
112856.53288,	112860.98177,	112865.43068,	112869.87960,	112874.32854,	112878.77749,	112883.22646,	112887.67545,	112892.12445,	112896.57346,
112901.02249,	112905.47154,	112909.92060,	112914.36968,	112918.81877,	112923.26788,	112927.71700,	112932.16614,	112936.61530,	112941.06447,
112945.51365,	112949.96285,	112954.41207,	112958.86130,	112963.31055,	112967.75981,	112972.20909,	112976.65838,	112981.10769,	112985.55701,
112990.00635,	112994.45571,	112998.90508,	113003.35446,	113007.80386,	113012.25328,	113016.70271,	113021.15216,	113025.60162,	113030.05110,
113034.50060,	113038.95011,	113043.39963,	113047.84917,	113052.29873,	113056.74830,	113061.19788,	113065.64748,	113070.09710,	113074.54673,
113078.99638,	113083.44605,	113087.89572,	113092.34542,	113096.79513,	113101.24485,	113105.69459,	113110.14435,	113114.59412,	113119.04391,
113123.49371,	113127.94353,	113132.39336,	113136.84321,	113141.29307,	113145.74295,	113150.19285,	113154.64276,	113159.09268,	113163.54263,
113167.99258,	113172.44255,	113176.89254,	113181.34254,	113185.79256,	113190.24259,	113194.69264,	113199.14271,	113203.59279,	113208.04288,
113212.49299,	113216.94312,	113221.39326,	113225.84342,	113230.29359,	113234.74378,	113239.19398,	113243.64420,	113248.09443,	113252.54468,
113256.99495,	113261.44523,	113265.89552,	113270.34583,	113274.79616,	113279.24650,	113283.69686,	113288.14723,	113292.59762,	113297.04802,
113301.49844,	113305.94887,	113310.39932,	113314.84978,	113319.30027,	113323.75076,	113328.20127,	113332.65180,	113337.10234,	113341.55290,
113346.00347,	113350.45406,	113354.90466,	113359.35528,	113363.80591,	113368.25656,	113372.70723,	113377.15791,	113381.60860,	113386.05931,
113390.51004,	113394.96078,	113399.41154,	113403.86231,	113408.31310,	113412.76390,	113417.21472,	113421.66555,	113426.11640,	113430.56727,
113435.01815,	113439.46904,	113443.91995,	113448.37088,	113452.82182,	113457.27278,	113461.72375,	113466.17474,	113470.62574,	113475.07676,
113479.52779,	113483.97884,	113488.42991,	113492.88099,	113497.33208,	113501.78319,	113506.23432,	113510.68546,	113515.13662,	113519.58779,
113524.03898,	113528.49018,	113532.94140,	113537.39263,	113541.84388,	113546.29515,	113550.74643,	113555.19772,	113559.64903,	113564.10036,
113568.55170,	113573.00305,	113577.45443,	113581.90581,	113586.35722,	113590.80863,	113595.26007,	113599.71152,	113604.16298,	113608.61446,
113613.06595,	113617.51746,	113621.96899,	113626.42053,	113630.87209,	113635.32366,	113639.77525,	113644.22685,	113648.67847,	113653.13010,
113657.58175,	113662.03341,	113666.48509,	113670.93678,	113675.38849,	113679.84022,	113684.29196,	113688.74371,	113693.19549,	113697.64727,
113702.09907,	113706.55089,	113711.00272,	113715.45457,	113719.90643,	113724.35831,	113728.81021,	113733.26212,	113737.71404,	113742.16598,
113746.61794,	113751.06991,	113755.52189,	113759.97389,	113764.42591,	113768.87794,	113773.32999,	113777.78205,	113782.23413,	113786.68622,
113791.13833,	113795.59046,	113800.04259,	113804.49475,	113808.94692,	113813.39910,	113817.85130,	113822.30352,	113826.75575,	113831.20800,
113835.66026,	113840.11254,	113844.56483,	113849.01714,	113853.46946,	113857.92180,	113862.37415,	113866.82652,	113871.27891,	113875.73131,
113880.18372,	113884.63615,	113889.08860,	113893.54106,	113897.99354,	113902.44603,	113906.89854,	113911.35106,	113915.80360,	113920.25615,
113924.70872,	113929.16130,	113933.61390,	113938.06651,	113942.51914,	113946.97179,	113951.42445,	113955.87712,	113960.32982,	113964.78252,
113969.23524,	113973.68798,	113978.14073,	113982.59350,	113987.04628,	113991.49908,	113995.95189,	114000.40472,	114004.85757,	114009.31043,
114013.76330,	114018.21619,	114022.66910,	114027.12202,	114031.57495,	114036.02790,	114040.48087,	114044.93385,	114049.38685,	114053.83986,
114058.29289,	114062.74593,	114067.19899,	114071.65206,	114076.10515,	114080.55826,	114085.01138,	114089.46451,	114093.91766,	114098.37083,
114102.82401,	114107.27720,	114111.73041,	114116.18364,	114120.63688,	114125.09014,	114129.54341,	114133.99670,	114138.45000,	114142.90332,
114147.35666,	114151.81000,	114156.26337,	114160.71675,	114165.17014,	114169.62355,	114174.07698,	114178.53042,	114182.98387,	114187.43735,
114191.89083,	114196.34433,	114200.79785,	114205.25138,	114209.70493,	114214.15849,	114218.61207,	114223.06567,	114227.51927,	114231.97290,
114236.42654,	114240.88019,	114245.33386,	114249.78755,	114254.24125,	114258.69496,	114263.14870,	114267.60244,	114272.05620,	114276.50998,
114280.96377,	114285.41758,	114289.87140,	114294.32524,	114298.77909,	114303.23296,	114307.68685,	114312.14074,	114316.59466,	114321.04859,
114325.50253,	114329.95649,	114334.41047,	114338.86446,	114343.31847,	114347.77249,	114352.22652,	114356.68058,	114361.13464,	114365.58872,
114370.04282,	114374.49693,	114378.95106,	114383.40521,	114387.85936,	114392.31354,	114396.76773,	114401.22193,	114405.67615,	114410.13039,
114414.58464,	114419.03890,	114423.49318,	114427.94748,	114432.40179,	114436.85612,	114441.31046,	114445.76482,	114450.21919,	114454.67357,
114459.12798,	114463.58240,	114468.03683,	114472.49128,	114476.94574,	114481.40022,	114485.85471,	114490.30922,	114494.76375,	114499.21829,
114503.67284,	114508.12741,	114512.58200,	114517.03660,	114521.49122,	114525.94585,	114530.40050,	114534.85516,	114539.30983,	114543.76453,
114548.21923,	114552.67396,	114557.12870,	114561.58345,	114566.03822,	114570.49300,	114574.94780,	114579.40262,	114583.85744,	114588.31229,
114592.76715,	114597.22203,	114601.67692,	114606.13182,	114610.58674,	114615.04168,	114619.49663,	114623.95160,	114628.40658,	114632.86158,
114637.31659,	114641.77162,	114646.22666,	114650.68172,	114655.13679,	114659.59188,	114664.04698,	114668.50210,	114672.95724,	114677.41239,
114681.86755,	114686.32273,	114690.77793,	114695.23314,	114699.68836,	114704.14360,	114708.59886,	114713.05413,	114717.50942,	114721.96472,
114726.42004,	114730.87537,	114735.33072,	114739.78608,	114744.24146,	114748.69685,	114753.15226,	114757.60768,	114762.06312,	114766.51857,
114770.97404,	114775.42953,	114779.88503,	114784.34054,	114788.79607,	114793.25162,	114797.70718,	114802.16275,	114806.61834,	114811.07395,
114815.52957,	114819.98521,	114824.44086,	114828.89653,	114833.35221,	114837.80791,	114842.26362,	114846.71935,	114851.17509,	114855.63085,
114860.08662,	114864.54241,	114868.99821,	114873.45403,	114877.90987,	114882.36572,	114886.82158,	114891.27746,	114895.73336,	114900.18927,
114904.64519,	114909.10113,	114913.55709,	114918.01306,	114922.46905,	114926.92505,	114931.38106,	114935.83710,	114940.29314,	114944.74920,
114949.20528,	114953.66137,	114958.11748,	114962.57361,	114967.02974,	114971.48590,	114975.94207,	114980.39825,	114984.85445,	114989.31066,
114993.76689,	114998.22314,	115002.67940,	115007.13567,	115011.59196,	115016.04827,	115020.50459,	115024.96092,	115029.41727,	115033.87364,
115038.33002,	115042.78642,	115047.24283,	115051.69926,	115056.15570,	115060.61215,	115065.06863,	115069.52511,	115073.98162,	115078.43813,
115082.89467,	115087.35122,	115091.80778,	115096.26436,	115100.72095,	115105.17756,	115109.63418,	115114.09082,	115118.54748,	115123.00415,
115127.46083,	115131.91753,	115136.37425,	115140.83098,	115145.28772,	115149.74448,	115154.20126,	115158.65805,	115163.11486,	115167.57168,
115172.02852,	115176.48537,	115180.94223,	115185.39912,	115189.85601,	115194.31293,	115198.76985,	115203.22680,	115207.68375,	115212.14073,
115216.59771,	115221.05472,	115225.51174,	115229.96877,	115234.42582,	115238.88288,	115243.33996,	115247.79706,	115252.25417,	115256.71129,
115261.16843,	115265.62559,	115270.08276,	115274.53994,	115278.99714,	115283.45436,	115287.91159,	115292.36883,	115296.82609,	115301.28337,
115305.74066,	115310.19797,	115314.65529,	115319.11263,	115323.56998,	115328.02735,	115332.48473,	115336.94213,	115341.39954,	115345.85697,
115350.31441,	115354.77187,	115359.22934,	115363.68683,	115368.14433,	115372.60185,	115377.05938,	115381.51693,	115385.97450,	115390.43208,
115394.88967,	115399.34728,	115403.80490,	115408.26254,	115412.72020,	115417.17787,	115421.63555,	115426.09325,	115430.55097,	115435.00870,
115439.46645,	115443.92421,	115448.38198,	115452.83977,	115457.29758,	115461.75540,	115466.21324,	115470.67109,	115475.12896,	115479.58684,
115484.04473,	115488.50265,	115492.96057,	115497.41852,	115501.87647,	115506.33445,	115510.79243,	115515.25044,	115519.70846,	115524.16649,
115528.62454,	115533.08260,	115537.54068,	115541.99877,	115546.45688,	115550.91501,	115555.37314,	115559.83130,	115564.28947,	115568.74765,
115573.20585,	115577.66407,	115582.12230,	115586.58054,	115591.03880,	115595.49708,	115599.95537,	115604.41367,	115608.87199,	115613.33033,
115617.78868,	115622.24705,	115626.70543,	115631.16382,	115635.62223,	115640.08066,	115644.53910,	115648.99756,	115653.45603,	115657.91452,
115662.37302,	115666.83154,	115671.29007,	115675.74861,	115680.20718,	115684.66575,	115689.12435,	115693.58295,	115698.04158,	115702.50021,
115706.95887,	115711.41754,	115715.87622,	115720.33492,	115724.79363,	115729.25236,	115733.71110,	115738.16986,	115742.62864,	115747.08742,
115751.54623,	115756.00505,	115760.46388,	115764.92273,	115769.38160,	115773.84047,	115778.29937,	115782.75828,	115787.21720,	115791.67614,
115796.13510,	115800.59407,	115805.05305,	115809.51205,	115813.97107,	115818.43010,	115822.88915,	115827.34821,	115831.80728,	115836.26637,
115840.72548,	115845.18460,	115849.64374,	115854.10289,	115858.56205,	115863.02123,	115867.48043,	115871.93964,	115876.39887,	115880.85811,
115885.31737,	115889.77664,	115894.23593,	115898.69523,	115903.15454,	115907.61388,	115912.07322,	115916.53259,	115920.99196,	115925.45136,
115929.91076,	115934.37019,	115938.82962,	115943.28908,	115947.74854,	115952.20803,	115956.66753,	115961.12704,	115965.58657,	115970.04611,
115974.50567,	115978.96524,	115983.42483,	115987.88443,	115992.34405,	115996.80369,	116001.26334,	116005.72300,	116010.18268,	116014.64237,
116019.10208,	116023.56180,	116028.02154,	116032.48130,	116036.94107,	116041.40085,	116045.86065,	116050.32047,	116054.78030,	116059.24014,
116063.70000,	116068.15987,	116072.61976,	116077.07967,	116081.53959,	116085.99952,	116090.45947,	116094.91944,	116099.37942,	116103.83942,
116108.29943,	116112.75945,	116117.21949,	116121.67955,	116126.13962,	116130.59970,	116135.05980,	116139.51992,	116143.98005,	116148.44020,
116152.90036,	116157.36053,	116161.82072,	116166.28093,	116170.74115,	116175.20139,	116179.66164,	116184.12190,	116188.58219,	116193.04248,
116197.50279,	116201.96312,	116206.42346,	116210.88382,	116215.34419,	116219.80458,	116224.26498,	116228.72539,	116233.18583,	116237.64627,
116242.10673,	116246.56721,	116251.02770,	116255.48821,	116259.94873,	116264.40927,	116268.86982,	116273.33039,	116277.79097,	116282.25157,
116286.71218,	116291.17281,	116295.63345,	116300.09411,	116304.55478,	116309.01547,	116313.47617,	116317.93689,	116322.39762,	116326.85837,
116331.31913,	116335.77991,	116340.24070,	116344.70151,	116349.16233,	116353.62317,	116358.08402,	116362.54489,	116367.00577,	116371.46667,
116375.92758,	116380.38851,	116384.84945,	116389.31041,	116393.77138,	116398.23237,	116402.69337,	116407.15439,	116411.61543,	116416.07647,
116420.53754,	116424.99861,	116429.45971,	116433.92082,	116438.38194,	116442.84308,	116447.30423,	116451.76540,	116456.22658,	116460.68778,
116465.14899,	116469.61022,	116474.07147,	116478.53272,	116482.99400,	116487.45529,	116491.91659,	116496.37791,	116500.83924,	116505.30059,
116509.76195,	116514.22333,	116518.68472,	116523.14613,	116527.60756,	116532.06900,	116536.53045,	116540.99192,	116545.45340,	116549.91490,
116554.37641,	116558.83794,	116563.29948,	116567.76104,	116572.22262,	116576.68421,	116581.14581,	116585.60743,	116590.06906,	116594.53071,
116598.99237,	116603.45405,	116607.91575,	116612.37745,	116616.83918,	116621.30092,	116625.76267,	116630.22444,	116634.68622,	116639.14802,
116643.60983,	116648.07166,	116652.53351,	116656.99536,	116661.45724,	116665.91913,	116670.38103,	116674.84295,	116679.30488,	116683.76683,
116688.22879,	116692.69077,	116697.15277,	116701.61477,	116706.07680,	116710.53884,	116715.00089,	116719.46296,	116723.92504,	116728.38714,
116732.84925,	116737.31138,	116741.77353,	116746.23568,	116750.69786,	116755.16005,	116759.62225,	116764.08447,	116768.54670,	116773.00895,
116777.47121,	116781.93349,	116786.39578,	116790.85809,	116795.32041,	116799.78275,	116804.24510,	116808.70747,	116813.16986,	116817.63225,
116822.09467,	116826.55709,	116831.01954,	116835.48200,	116839.94447,	116844.40696,	116848.86946,	116853.33198,	116857.79451,	116862.25706,
116866.71962,	116871.18220,	116875.64479,	116880.10740,	116884.57002,	116889.03266,	116893.49531,	116897.95798,	116902.42066,	116906.88336,
116911.34607,	116915.80880,	116920.27154,	116924.73430,	116929.19707,	116933.65986,	116938.12266,	116942.58548,	116947.04831,	116951.51116,
116955.97402,	116960.43689,	116964.89979,	116969.36269,	116973.82561,	116978.28855,	116982.75150,	116987.21447,	116991.67745,	116996.14045,
117000.60346,	117005.06649,	117009.52953,	117013.99258,	117018.45566,	117022.91874,	117027.38184,	117031.84496,	117036.30809,	117040.77124,
117045.23440,	117049.69757,	117054.16076,	117058.62397,	117063.08719,	117067.55043,	117072.01368,	117076.47694,	117080.94022,	117085.40352,
117089.86683,	117094.33016,	117098.79350,	117103.25685,	117107.72022,	117112.18361,	117116.64701,	117121.11042,	117125.57385,	117130.03730,
117134.50076,	117138.96423,	117143.42772,	117147.89123,	117152.35475,	117156.81828,	117161.28183,	117165.74540,	117170.20898,	117174.67257,
117179.13618,	117183.59980,	117188.06344,	117192.52710,	117196.99077,	117201.45445,	117205.91815,	117210.38186,	117214.84559,	117219.30934,
117223.77309,	117228.23687,	117232.70066,	117237.16446,	117241.62828,	117246.09211,	117250.55596,	117255.01982,	117259.48370,	117263.94759,
117268.41150,	117272.87542,	117277.33936,	117281.80331,	117286.26728,	117290.73127,	117295.19526,	117299.65927,	117304.12330,	117308.58734,
117313.05140,	117317.51547,	117321.97956,	117326.44366,	117330.90778,	117335.37191,	117339.83606,	117344.30022,	117348.76440,	117353.22859,
117357.69279,	117362.15701,	117366.62125,	117371.08550,	117375.54977,	117380.01405,	117384.47834,	117388.94265,	117393.40698,	117397.87132,
117402.33568,	117406.80005,	117411.26443,	117415.72883,	117420.19325,	117424.65768,	117429.12212,	117433.58658,	117438.05106,	117442.51555,
117446.98005,	117451.44457,	117455.90910,	117460.37365,	117464.83822,	117469.30280,	117473.76739,	117478.23200,	117482.69662,	117487.16126,
117491.62591,	117496.09058,	117500.55527,	117505.01996,	117509.48468,	117513.94940,	117518.41415,	117522.87891,	117527.34368,	117531.80847,
117536.27327,	117540.73809,	117545.20292,	117549.66776,	117554.13263,	117558.59750,	117563.06240,	117567.52730,	117571.99222,	117576.45716,
117580.92211,	117585.38708,	117589.85206,	117594.31705,	117598.78207,	117603.24709,	117607.71213,	117612.17719,	117616.64226,	117621.10734,
117625.57244,	117630.03756,	117634.50269,	117638.96783,	117643.43299,	117647.89817,	117652.36336,	117656.82856,	117661.29378,	117665.75901,
117670.22426,	117674.68953,	117679.15481,	117683.62010,	117688.08541,	117692.55073,	117697.01607,	117701.48142,	117705.94679,	117710.41217,
117714.87757,	117719.34298,	117723.80841,	117728.27385,	117732.73931,	117737.20478,	117741.67027,	117746.13577,	117750.60129,	117755.06682,
117759.53237,	117763.99793,	117768.46350,	117772.92909,	117777.39470,	117781.86032,	117786.32596,	117790.79161,	117795.25727,	117799.72295,
117804.18865,	117808.65436,	117813.12008,	117817.58582,	117822.05158,	117826.51735,	117830.98313,	117835.44893,	117839.91474,	117844.38057,
117848.84642,	117853.31227,	117857.77815,	117862.24404,	117866.70994,	117871.17586,	117875.64179,	117880.10774,	117884.57370,	117889.03968,
117893.50567,	117897.97168,	117902.43770,	117906.90374,	117911.36979,	117915.83585,	117920.30194,	117924.76803,	117929.23414,	117933.70027,
117938.16641,	117942.63256,	117947.09873,	117951.56492,	117956.03112,	117960.49734,	117964.96356,	117969.42981,	117973.89607,	117978.36234,
117982.82863,	117987.29494,	117991.76126,	117996.22759,	118000.69394,	118005.16030,	118009.62668,	118014.09307,	118018.55948,	118023.02590,
118027.49234,	118031.95879,	118036.42526,	118040.89174,	118045.35824,	118049.82475,	118054.29128,	118058.75782,	118063.22437,	118067.69095,
118072.15753,	118076.62413,	118081.09075,	118085.55738,	118090.02402,	118094.49068,	118098.95736,	118103.42405,	118107.89075,	118112.35747,
118116.82421,	118121.29096,	118125.75772,	118130.22450,	118134.69129,	118139.15810,	118143.62492,	118148.09176,	118152.55861,	118157.02548,
118161.49236,	118165.95926,	118170.42617,	118174.89310,	118179.36004,	118183.82700,	118188.29397,	118192.76096,	118197.22796,	118201.69497,
118206.16200,	118210.62905,	118215.09611,	118219.56318,	118224.03027,	118228.49738,	118232.96450,	118237.43163,	118241.89878,	118246.36595,
118250.83312,	118255.30032,	118259.76753,	118264.23475,	118268.70199,	118273.16924,	118277.63651,	118282.10379,	118286.57109,	118291.03840,
118295.50573,	118299.97307,	118304.44043,	118308.90780,	118313.37518,	118317.84258,	118322.31000,	118326.77743,	118331.24488,	118335.71234,
118340.17981,	118344.64730,	118349.11480,	118353.58232,	118358.04986,	118362.51741,	118366.98497,	118371.45255,	118375.92014,	118380.38775,
118384.85537,	118389.32301,	118393.79066,	118398.25833,	118402.72601,	118407.19371,	118411.66142,	118416.12915,	118420.59689,	118425.06465,
118429.53242,	118434.00020,	118438.46800,	118442.93582,	118447.40365,	118451.87149,	118456.33935,	118460.80723,	118465.27512,	118469.74302,
118474.21094,	118478.67887,	118483.14682,	118487.61478,	118492.08276,	118496.55075,	118501.01876,	118505.48678,	118509.95482,	118514.42287,
118518.89094,	118523.35902,	118527.82712,	118532.29523,	118536.76335,	118541.23149,	118545.69965,	118550.16782,	118554.63600,	118559.10420,
118563.57242,	118568.04065,	118572.50889,	118576.97715,	118581.44542,	118585.91371,	118590.38201,	118594.85033,	118599.31866,	118603.78701,
118608.25537,	118612.72375,	118617.19214,	118621.66055,	118626.12897,	118630.59741,	118635.06586,	118639.53432,	118644.00280,	118648.47130,
118652.93981,	118657.40833,	118661.87687,	118666.34542,	118670.81399,	118675.28258,	118679.75118,	118684.21979,	118688.68842,	118693.15706,
118697.62572,	118702.09439,	118706.56308,	118711.03178,	118715.50049,	118719.96922,	118724.43797,	118728.90673,	118733.37551,	118737.84430,
118742.31310,	118746.78192,	118751.25076,	118755.71961,	118760.18847,	118764.65735,	118769.12624,	118773.59515,	118778.06407,	118782.53301,
118787.00196,	118791.47093,	118795.93991,	118800.40891,	118804.87792,	118809.34695,	118813.81599,	118818.28505,	118822.75412,	118827.22320,
118831.69230,	118836.16142,	118840.63055,	118845.09969,	118849.56885,	118854.03802,	118858.50721,	118862.97641,	118867.44563,	118871.91486,
118876.38411,	118880.85337,	118885.32265,	118889.79194,	118894.26125,	118898.73057,	118903.19991,	118907.66926,	118912.13862,	118916.60800,
118921.07740,	118925.54681,	118930.01623,	118934.48567,	118938.95512,	118943.42459,	118947.89408,	118952.36357,	118956.83309,	118961.30261,
118965.77216,	118970.24171,	118974.71129,	118979.18087,	118983.65047,	118988.12009,	118992.58972,	118997.05936,	119001.52903,	119005.99870,
119010.46839,	119014.93809,	119019.40781,	119023.87755,	119028.34729,	119032.81706,	119037.28684,	119041.75663,	119046.22644,	119050.69626,
119055.16609,	119059.63595,	119064.10581,	119068.57569,	119073.04559,	119077.51550,	119081.98542,	119086.45536,	119090.92532,	119095.39529,
119099.86527,	119104.33527,	119108.80528,	119113.27531,	119117.74535,	119122.21541,	119126.68548,	119131.15557,	119135.62567,	119140.09579,
119144.56592,	119149.03607,	119153.50623,	119157.97640,	119162.44659,	119166.91680,	119171.38701,	119175.85725,	119180.32750,	119184.79776,
119189.26804,	119193.73833,	119198.20864,	119202.67896,	119207.14930,	119211.61965,	119216.09002,	119220.56040,	119225.03079,	119229.50120,
119233.97163,	119238.44207,	119242.91252,	119247.38299,	119251.85348,	119256.32398,	119260.79449,	119265.26502,	119269.73556,	119274.20612,
119278.67669,	119283.14728,	119287.61788,	119292.08849,	119296.55913,	119301.02977,	119305.50043,	119309.97111,	119314.44180,	119318.91250,
119323.38322,	119327.85395,	119332.32470,	119336.79547,	119341.26624,	119345.73704,	119350.20784,	119354.67867,	119359.14950,	119363.62035,
119368.09122,	119372.56210,	119377.03300,	119381.50391,	119385.97483,	119390.44577,	119394.91672,	119399.38769,	119403.85868,	119408.32967,
119412.80069,	119417.27171,	119421.74276,	119426.21381,	119430.68489,	119435.15597,	119439.62707,	119444.09819,	119448.56932,	119453.04046,
119457.51162,	119461.98280,	119466.45399,	119470.92519,	119475.39641,	119479.86764,	119484.33889,	119488.81015,	119493.28143,	119497.75272,
119502.22403,	119506.69535,	119511.16668,	119515.63803,	119520.10940,	119524.58078,	119529.05217,	119533.52358,	119537.99501,	119542.46644,
119546.93790,	119551.40936,	119555.88085,	119560.35234,	119564.82386,	119569.29538,	119573.76692,	119578.23848,	119582.71005,	119587.18163,
119591.65323,	119596.12485,	119600.59648,	119605.06812,	119609.53978,	119614.01145,	119618.48314,	119622.95484,	119627.42656,	119631.89829,
119636.37004,	119640.84180,	119645.31357,	119649.78536,	119654.25717,	119658.72899,	119663.20082,	119667.67267,	119672.14454,	119676.61641,
119681.08831,	119685.56021,	119690.03214,	119694.50407,	119698.97602,	119703.44799,	119707.91997,	119712.39197,	119716.86398,	119721.33600,
119725.80804,	119730.28010,	119734.75216,	119739.22425,	119743.69635,	119748.16846,	119752.64058,	119757.11273,	119761.58488,	119766.05705,
119770.52924,	119775.00144,	119779.47366,	119783.94589,	119788.41813,	119792.89039,	119797.36266,	119801.83495,	119806.30725,	119810.77957,
119815.25190,	119819.72425,	119824.19661,	119828.66899,	119833.14138,	119837.61378,	119842.08620,	119846.55864,	119851.03109,	119855.50355,
119859.97603,	119864.44852,	119868.92103,	119873.39355,	119877.86609,	119882.33864,	119886.81121,	119891.28379,	119895.75638,	119900.22900,
119904.70162,	119909.17426,	119913.64691,	119918.11958,	119922.59227,	119927.06496,	119931.53768,	119936.01040,	119940.48315,	119944.95590,
119949.42867,	119953.90146,	119958.37426,	119962.84707,	119967.31990,	119971.79275,	119976.26561,	119980.73848,	119985.21137,	119989.68427,
119994.15719,	119998.63012,	120003.10307,	120007.57603,	120012.04900,	120016.52199,	120020.99500,	120025.46802,	120029.94105,	120034.41410,
120038.88716,	120043.36024,	120047.83333,	120052.30644,	120056.77956,	120061.25270,	120065.72585,	120070.19902,	120074.67220,	120079.14539,
120083.61860,	120088.09183,	120092.56506,	120097.03832,	120101.51159,	120105.98487,	120110.45817,	120114.93148,	120119.40480,	120123.87814,
120128.35150,	120132.82487,	120137.29826,	120141.77165,	120146.24507,	120150.71850,	120155.19194,	120159.66540,	120164.13887,	120168.61236,
120173.08586,	120177.55938,	120182.03291,	120186.50645,	120190.98001,	120195.45359,	120199.92717,	120204.40078,	120208.87440,	120213.34803,
120217.82168,	120222.29534,	120226.76902,	120231.24271,	120235.71641,	120240.19013,	120244.66387,	120249.13762,	120253.61138,	120258.08516,
120262.55896,	120267.03276,	120271.50659,	120275.98042,	120280.45427,	120284.92814,	120289.40202,	120293.87592,	120298.34983,	120302.82375,
120307.29769,	120311.77165,	120316.24561,	120320.71960,	120325.19359,	120329.66761,	120334.14163,	120338.61567,	120343.08973,	120347.56380,
120352.03789,	120356.51199,	120360.98610,	120365.46023,	120369.93437,	120374.40853,	120378.88270,	120383.35689,	120387.83109,	120392.30531,
120396.77954,	120401.25378,	120405.72804,	120410.20232,	120414.67661,	120419.15091,	120423.62523,	120428.09956,	120432.57391,	120437.04827,
120441.52265,	120445.99704,	120450.47145,	120454.94587,	120459.42030,	120463.89475,	120468.36921,	120472.84369,	120477.31819,	120481.79269,
120486.26722,	120490.74175,	120495.21630,	120499.69087,	120504.16545,	120508.64004,	120513.11465,	120517.58928,	120522.06392,	120526.53857,
120531.01324,	120535.48792,	120539.96262,	120544.43733,	120548.91206,	120553.38680,	120557.86155,	120562.33632,	120566.81110,	120571.28590,
120575.76072,	120580.23554,	120584.71039,	120589.18524,	120593.66012,	120598.13500,	120602.60990,	120607.08482,	120611.55975,	120616.03469,
120620.50965,	120624.98462,	120629.45961,	120633.93461,	120638.40963,	120642.88466,	120647.35971,	120651.83477,	120656.30985,	120660.78494,
120665.26004,	120669.73516,	120674.21029,	120678.68544,	120683.16060,	120687.63578,	120692.11097,	120696.58618,	120701.06140,	120705.53663,
120710.01188,	120714.48715,	120718.96243,	120723.43772,	120727.91303,	120732.38835,	120736.86369,	120741.33904,	120745.81440,	120750.28979,
120754.76518,	120759.24059,	120763.71601,	120768.19145,	120772.66691,	120777.14237,	120781.61786,	120786.09335,	120790.56886,	120795.04439,
120799.51993,	120803.99549,	120808.47106,	120812.94664,	120817.42224,	120821.89785,	120826.37348,	120830.84912,	120835.32478,	120839.80045,
120844.27613,	120848.75183,	120853.22755,	120857.70328,	120862.17902,	120866.65478,	120871.13055,	120875.60634,	120880.08214,	120884.55796,
120889.03379,	120893.50964,	120897.98550,	120902.46137,	120906.93726,	120911.41316,	120915.88908,	120920.36501,	120924.84096,	120929.31692,
120933.79290,	120938.26889,	120942.74489,	120947.22091,	120951.69695,	120956.17300,	120960.64906,	120965.12514,	120969.60123,	120974.07734,
120978.55346,	120983.02959,	120987.50574,	120991.98191,	120996.45809,	121000.93428,	121005.41049,	121009.88671,	121014.36295,	121018.83920,
121023.31547,	121027.79175,	121032.26804,	121036.74435,	121041.22068,	121045.69702,	121050.17337,	121054.64974,	121059.12612,	121063.60252,
121068.07893,	121072.55535,	121077.03179,	121081.50825,	121085.98472,	121090.46120,	121094.93770,	121099.41421,	121103.89074,	121108.36728,
121112.84384,	121117.32041,	121121.79700,	121126.27359,	121130.75021,	121135.22684,	121139.70348,	121144.18014,	121148.65681,	121153.13350,
121157.61020,	121162.08691,	121166.56365,	121171.04039,	121175.51715,	121179.99392,	121184.47071,	121188.94751,	121193.42433,	121197.90116,
121202.37801,	121206.85487,	121211.33174,	121215.80863,	121220.28554,	121224.76246,	121229.23939,	121233.71634,	121238.19330,	121242.67028,
121247.14727,	121251.62427,	121256.10129,	121260.57833,	121265.05537,	121269.53244,	121274.00952,	121278.48661,	121282.96372,	121287.44084,
121291.91797,	121296.39512,	121300.87229,	121305.34947,	121309.82666,	121314.30387,	121318.78109,	121323.25833,	121327.73558,	121332.21284,
121336.69013,	121341.16742,	121345.64473,	121350.12205,	121354.59939,	121359.07674,	121363.55411,	121368.03149,	121372.50889,	121376.98630,
121381.46373,	121385.94117,	121390.41862,	121394.89609,	121399.37357,	121403.85107,	121408.32858,	121412.80611,	121417.28365,	121421.76120,
121426.23877,	121430.71636,	121435.19396,	121439.67157,	121444.14920,	121448.62684,	121453.10450,	121457.58217,	121462.05985,	121466.53755,
121471.01527,	121475.49300,	121479.97074,	121484.44850,	121488.92627,	121493.40405,	121497.88186,	121502.35967,	121506.83750,	121511.31535,
121515.79321,	121520.27108,	121524.74897,	121529.22687,	121533.70479,	121538.18272,	121542.66066,	121547.13862,	121551.61660,	121556.09459,
121560.57259,	121565.05061,	121569.52864,	121574.00669,	121578.48475,	121582.96282,	121587.44091,	121591.91902,	121596.39714,	121600.87527,
121605.35342,	121609.83158,	121614.30976,	121618.78795,	121623.26615,	121627.74437,	121632.22261,	121636.70086,	121641.17912,	121645.65740,
121650.13569,	121654.61400,	121659.09232,	121663.57065,	121668.04900,	121672.52737,	121677.00575,	121681.48414,	121685.96255,	121690.44097,
121694.91941,	121699.39786,	121703.87632,	121708.35480,	121712.83330,	121717.31181,	121721.79033,	121726.26887,	121730.74742,	121735.22599,
121739.70457,	121744.18316,	121748.66177,	121753.14040,	121757.61904,	121762.09769,	121766.57636,	121771.05504,	121775.53373,	121780.01244,
121784.49117,	121788.96991,	121793.44866,	121797.92743,	121802.40622,	121806.88501,	121811.36382,	121815.84265,	121820.32149,	121824.80035,
121829.27922,	121833.75810,	121838.23700,	121842.71591,	121847.19484,	121851.67378,	121856.15273,	121860.63170,	121865.11069,	121869.58969,
121874.06870,	121878.54773,	121883.02677,	121887.50583,	121891.98490,	121896.46399,	121900.94309,	121905.42220,	121909.90133,	121914.38047,
121918.85963,	121923.33880,	121927.81799,	121932.29719,	121936.77640,	121941.25563,	121945.73488,	121950.21414,	121954.69341,	121959.17270,
121963.65200,	121968.13132,	121972.61065,	121977.08999,	121981.56935,	121986.04872,	121990.52811,	121995.00751,	121999.48693,	122003.96636,
122008.44581,	122012.92527,	122017.40474,	122021.88423,	122026.36374,	122030.84325,	122035.32279,	122039.80233,	122044.28189,	122048.76147,
122053.24106,	122057.72066,	122062.20028,	122066.67991,	122071.15956,	122075.63922,	122080.11890,	122084.59859,	122089.07829,	122093.55801,
122098.03775,	122102.51749,	122106.99726,	122111.47703,	122115.95682,	122120.43663,	122124.91645,	122129.39628,	122133.87613,	122138.35600,
122142.83587,	122147.31577,	122151.79567,	122156.27559,	122160.75553,	122165.23548,	122169.71544,	122174.19542,	122178.67541,	122183.15542,
122187.63544,	122192.11548,	122196.59553,	122201.07559,	122205.55567,	122210.03576,	122214.51587,	122218.99599,	122223.47613,	122227.95628,
122232.43644,	122236.91662,	122241.39682,	122245.87703,	122250.35725,	122254.83748,	122259.31774,	122263.79800,	122268.27828,	122272.75858,
122277.23889,	122281.71921,	122286.19955,	122290.67990,	122295.16026,	122299.64065,	122304.12104,	122308.60145,	122313.08187,	122317.56231,
122322.04276,	122326.52323,	122331.00371,	122335.48421,	122339.96472,	122344.44524,	122348.92578,	122353.40633,	122357.88690,	122362.36748,
122366.84808,	122371.32869,	122375.80931,	122380.28995,	122384.77061,	122389.25128,	122393.73196,	122398.21265,	122402.69337,	122407.17409,
122411.65483,	122416.13558,	122420.61635,	122425.09714,	122429.57793,	122434.05874,	122438.53957,	122443.02041,	122447.50127,	122451.98213,
122456.46302,	122460.94391,	122465.42483,	122469.90575,	122474.38669,	122478.86765,	122483.34862,	122487.82960,	122492.31060,	122496.79161,
122501.27264,	122505.75368,	122510.23474,	122514.71581,	122519.19689,	122523.67799,	122528.15910,	122532.64023,	122537.12137,	122541.60253,
122546.08370,	122550.56488,	122555.04608,	122559.52729,	122564.00852,	122568.48976,	122572.97102,	122577.45229,	122581.93357,	122586.41487,
122590.89619,	122595.37751,	122599.85886,	122604.34021,	122608.82158,	122613.30297,	122617.78437,	122622.26578,	122626.74721,	122631.22865,
122635.71011,	122640.19158,	122644.67307,	122649.15457,	122653.63608,	122658.11761,	122662.59915,	122667.08071,	122671.56228,	122676.04387,
122680.52547,	122685.00708,	122689.48871,	122693.97036,	122698.45201,	122702.93369,	122707.41537,	122711.89707,	122716.37879,	122720.86052,
122725.34226,	122729.82402,	122734.30579,	122738.78758,	122743.26938,	122747.75119,	122752.23302,	122756.71487,	122761.19672,	122765.67860,
122770.16048,	122774.64238,	122779.12430,	122783.60623,	122788.08817,	122792.57013,	122797.05210,	122801.53409,	122806.01609,	122810.49811,
122814.98014,	122819.46218,	122823.94424,	122828.42631,	122832.90840,	122837.39050,	122841.87262,	122846.35475,	122850.83689,	122855.31905,
122859.80122,	122864.28341,	122868.76561,	122873.24783,	122877.73006,	122882.21230,	122886.69456,	122891.17684,	122895.65912,	122900.14142,
122904.62374,	122909.10607,	122913.58842,	122918.07077,	122922.55315,	122927.03554,	122931.51794,	122936.00035,	122940.48278,	122944.96523,
122949.44769,	122953.93016,	122958.41265,	122962.89515,	122967.37767,	122971.86020,	122976.34274,	122980.82530,	122985.30788,	122989.79046,
122994.27307,	122998.75568,	123003.23831,	123007.72096,	123012.20362,	123016.68629,	123021.16898,	123025.65168,	123030.13440,	123034.61713,
123039.09987,	123043.58263,	123048.06540,	123052.54819,	123057.03099,	123061.51381,	123065.99664,	123070.47949,	123074.96235,	123079.44522,
123083.92811,	123088.41101,	123092.89393,	123097.37686,	123101.85980,	123106.34276,	123110.82573,	123115.30872,	123119.79172,	123124.27474,
123128.75777,	123133.24082,	123137.72388,	123142.20695,	123146.69004,	123151.17314,	123155.65626,	123160.13939,	123164.62253,	123169.10569,
123173.58886,	123178.07205,	123182.55525,	123187.03847,	123191.52170,	123196.00495,	123200.48821,	123204.97148,	123209.45477,	123213.93807,
123218.42138,	123222.90471,	123227.38806,	123231.87142,	123236.35479,	123240.83818,	123245.32158,	123249.80500,	123254.28843,	123258.77187,
123263.25533,	123267.73880,	123272.22229,	123276.70579,	123281.18931,	123285.67284,	123290.15638,	123294.63994,	123299.12352,	123303.60710,
123308.09071,	123312.57432,	123317.05795,	123321.54160,	123326.02525,	123330.50893,	123334.99261,	123339.47632,	123343.96003,	123348.44376,
123352.92750,	123357.41126,	123361.89504,	123366.37882,	123370.86262,	123375.34644,	123379.83027,	123384.31411,	123388.79797,	123393.28184,
123397.76573,	123402.24963,	123406.73355,	123411.21748,	123415.70142,	123420.18538,	123424.66935,	123429.15334,	123433.63734,	123438.12135,
123442.60538,	123447.08942,	123451.57348,	123456.05755,	123460.54164,	123465.02574,	123469.50986,	123473.99398,	123478.47813,	123482.96229,
123487.44646,	123491.93064,	123496.41484,	123500.89906,	123505.38329,	123509.86753,	123514.35179,	123518.83606,	123523.32034,	123527.80464,
123532.28896,	123536.77329,	123541.25763,	123545.74198,	123550.22636,	123554.71074,	123559.19514,	123563.67955,	123568.16398,	123572.64842,
123577.13288,	123581.61735,	123586.10184,	123590.58634,	123595.07085,	123599.55538,	123604.03992,	123608.52447,	123613.00904,	123617.49363,
123621.97823,	123626.46284,	123630.94747,	123635.43211,	123639.91677,	123644.40144,	123648.88612,	123653.37082,	123657.85553,	123662.34026,
123666.82500,	123671.30975,	123675.79452,	123680.27931,	123684.76410,	123689.24892,	123693.73374,	123698.21858,	123702.70344,	123707.18831,
123711.67319,	123716.15809,	123720.64300,	123725.12793,	123729.61287,	123734.09782,	123738.58279,	123743.06777,	123747.55277,	123752.03778,
123756.52281,	123761.00785,	123765.49290,	123769.97797,	123774.46305,	123778.94815,	123783.43326,	123787.91838,	123792.40352,	123796.88867,
123801.37384,	123805.85902,	123810.34422,	123814.82943,	123819.31465,	123823.79989,	123828.28515,	123832.77041,	123837.25569,	123841.74099,
123846.22630,	123850.71162,	123855.19696,	123859.68231,	123864.16768,	123868.65306,	123873.13845,	123877.62386,	123882.10929,	123886.59472,
123891.08018,	123895.56564,	123900.05112,	123904.53662,	123909.02212,	123913.50765,	123917.99318,	123922.47874,	123926.96430,	123931.44988,
123935.93547,	123940.42108,	123944.90670,	123949.39234,	123953.87799,	123958.36366,	123962.84933,	123967.33503,	123971.82073,	123976.30646,
123980.79219,	123985.27794,	123989.76371,	123994.24948,	123998.73528,	124003.22108,	124007.70690,	124012.19274,	124016.67859,	124021.16445,
124025.65033,	124030.13622,	124034.62213,	124039.10805,	124043.59398,	124048.07993,	124052.56589,	124057.05187,	124061.53786,	124066.02386,
124070.50988,	124074.99592,	124079.48196,	124083.96803,	124088.45410,	124092.94019,	124097.42630,	124101.91242,	124106.39855,	124110.88470,
124115.37086,	124119.85703,	124124.34322,	124128.82943,	124133.31564,	124137.80188,	124142.28812,	124146.77438,	124151.26066,	124155.74695,
124160.23325,	124164.71957,	124169.20590,	124173.69224,	124178.17860,	124182.66498,	124187.15136,	124191.63777,	124196.12418,	124200.61061,
124205.09706,	124209.58352,	124214.06999,	124218.55648,	124223.04298,	124227.52949,	124232.01602,	124236.50257,	124240.98912,	124245.47570,
124249.96228,	124254.44888,	124258.93550,	124263.42213,	124267.90877,	124272.39543,	124276.88210,	124281.36878,	124285.85548,	124290.34220,
124294.82893,	124299.31567,	124303.80242,	124308.28919,	124312.77598,	124317.26278,	124321.74959,	124326.23642,	124330.72326,	124335.21011,
124339.69698,	124344.18387,	124348.67076,	124353.15768,	124357.64460,	124362.13154,	124366.61850,	124371.10547,	124375.59245,	124380.07945,
124384.56646,	124389.05348,	124393.54052,	124398.02757,	124402.51464,	124407.00172,	124411.48882,	124415.97593,	124420.46305,	124424.95019,
124429.43735,	124433.92451,	124438.41169,	124442.89889,	124447.38610,	124451.87332,	124456.36056,	124460.84781,	124465.33507,	124469.82235,
124474.30965,	124478.79696,	124483.28428,	124487.77162,	124492.25897,	124496.74633,	124501.23371,	124505.72110,	124510.20851,	124514.69593,
124519.18337,	124523.67082,	124528.15828,	124532.64576,	124537.13325,	124541.62075,	124546.10827,	124550.59581,	124555.08336,	124559.57092,
124564.05850,	124568.54609,	124573.03369,	124577.52131,	124582.00894,	124586.49659,	124590.98425,	124595.47193,	124599.95962,	124604.44732,
124608.93504,	124613.42277,	124617.91052,	124622.39828,	124626.88605,	124631.37384,	124635.86165,	124640.34946,	124644.83729,	124649.32514,
124653.81300,	124658.30087,	124662.78876,	124667.27666,	124671.76458,	124676.25251,	124680.74045,	124685.22841,	124689.71638,	124694.20437,
124698.69237,	124703.18038,	124707.66841,	124712.15645,	124716.64451,	124721.13258,	124725.62067,	124730.10877,	124734.59688,	124739.08501,
124743.57315,	124748.06130,	124752.54947,	124757.03766,	124761.52586,	124766.01407,	124770.50229,	124774.99053,	124779.47879,	124783.96706,
124788.45534,	124792.94364,	124797.43195,	124801.92027,	124806.40861,	124810.89697,	124815.38533,	124819.87371,	124824.36211,	124828.85052,
124833.33894,	124837.82738,	124842.31583,	124846.80430,	124851.29278,	124855.78127,	124860.26978,	124864.75830,	124869.24684,	124873.73539,
124878.22396,	124882.71254,	124887.20113,	124891.68974,	124896.17836,	124900.66699,	124905.15564,	124909.64431,	124914.13298,	124918.62167,
124923.11038,	124927.59910,	124932.08783,	124936.57658,	124941.06534,	124945.55412,	124950.04291,	124954.53172,	124959.02053,	124963.50937,
124967.99821,	124972.48707,	124976.97595,	124981.46484,	124985.95374,	124990.44266,	124994.93159,	124999.42054,	125003.90949,	125008.39847,
125012.88746,	125017.37646,	125021.86547,	125026.35450,	125030.84355,	125035.33261,	125039.82168,	125044.31076,	125048.79986,	125053.28898,
125057.77811,	125062.26725,	125066.75641,	125071.24558,	125075.73476,	125080.22396,	125084.71317,	125089.20240,	125093.69164,	125098.18090,
125102.67017,	125107.15945,	125111.64875,	125116.13806,	125120.62738,	125125.11672,	125129.60608,	125134.09544,	125138.58483,	125143.07422,
125147.56363,	125152.05306,	125156.54249,	125161.03195,	125165.52141,	125170.01089,	125174.50039,	125178.98990,	125183.47942,	125187.96896,
125192.45851,	125196.94807,	125201.43765,	125205.92724,	125210.41685,	125214.90647,	125219.39611,	125223.88575,	125228.37542,	125232.86510,
125237.35479,	125241.84449,	125246.33421,	125250.82394,	125255.31369,	125259.80345,	125264.29323,	125268.78302,	125273.27282,	125277.76264,
125282.25247,	125286.74232,	125291.23218,	125295.72205,	125300.21194,	125304.70184,	125309.19176,	125313.68169,	125318.17164,	125322.66159,
125327.15157,	125331.64155,	125336.13155,	125340.62157,	125345.11160,	125349.60164,	125354.09170,	125358.58177,	125363.07185,	125367.56195,
125372.05206,	125376.54219,	125381.03233,	125385.52249,	125390.01266,	125394.50284,	125398.99304,	125403.48325,	125407.97347,	125412.46371,
125416.95397,	125421.44424,	125425.93452,	125430.42481,	125434.91512,	125439.40545,	125443.89578,	125448.38614,	125452.87650,	125457.36688,
125461.85728,	125466.34768,	125470.83811,	125475.32854,	125479.81899,	125484.30946,	125488.79993,	125493.29043,	125497.78093,	125502.27145,
125506.76199,	125511.25254,	125515.74310,	125520.23367,	125524.72426,	125529.21487,	125533.70549,	125538.19612,	125542.68677,	125547.17743,
125551.66810,	125556.15879,	125560.64949,	125565.14021,	125569.63094,	125574.12169,	125578.61245,	125583.10322,	125587.59401,	125592.08481,
125596.57562,	125601.06645,	125605.55729,	125610.04815,	125614.53902,	125619.02991,	125623.52081,	125628.01172,	125632.50265,	125636.99359,
125641.48454,	125645.97551,	125650.46649,	125654.95749,	125659.44850,	125663.93953,	125668.43057,	125672.92162,	125677.41269,	125681.90377,
125686.39487,	125690.88598,	125695.37710,	125699.86824,	125704.35939,	125708.85055,	125713.34173,	125717.83293,	125722.32413,	125726.81536,
125731.30659,	125735.79784,	125740.28910,	125744.78038,	125749.27167,	125753.76298,	125758.25430,	125762.74563,	125767.23698,	125771.72834,
125776.21972,	125780.71111,	125785.20251,	125789.69393,	125794.18536,	125798.67681,	125803.16827,	125807.65974,	125812.15123,	125816.64273,
125821.13424,	125825.62577,	125830.11732,	125834.60888,	125839.10045,	125843.59203,	125848.08363,	125852.57525,	125857.06688,	125861.55852,
125866.05017,	125870.54184,	125875.03353,	125879.52522,	125884.01694,	125888.50866,	125893.00040,	125897.49216,	125901.98392,	125906.47570,
125910.96750,	125915.45931,	125919.95113,	125924.44297,	125928.93482,	125933.42669,	125937.91857,	125942.41046,	125946.90237,	125951.39429,
125955.88623,	125960.37818,	125964.87014,	125969.36212,	125973.85411,	125978.34612,	125982.83814,	125987.33017,	125991.82222,	125996.31428,
126000.80635,	126005.29844,	126009.79055,	126014.28267,	126018.77480,	126023.26694,	126027.75910,	126032.25128,	126036.74346,	126041.23566,
126045.72788,	126050.22011,	126054.71235,	126059.20461,	126063.69688,	126068.18917,	126072.68147,	126077.17378,	126081.66611,	126086.15845,
126090.65080,	126095.14317,	126099.63556,	126104.12795,	126108.62036,	126113.11279,	126117.60523,	126122.09768,	126126.59015,	126131.08263,
126135.57512,	126140.06763,	126144.56016,	126149.05269,	126153.54524,	126158.03781,	126162.53039,	126167.02298,	126171.51559,	126176.00821,
126180.50084,	126184.99349,	126189.48615,	126193.97883,	126198.47152,	126202.96423,	126207.45694,	126211.94968,	126216.44242,	126220.93518,
126225.42796,	126229.92075,	126234.41355,	126238.90636,	126243.39919,	126247.89204,	126252.38490,	126256.87777,	126261.37065,	126265.86355,
126270.35647,	126274.84940,	126279.34234,	126283.83529,	126288.32826,	126292.82125,	126297.31425,	126301.80726,	126306.30028,	126310.79332,
126315.28638,	126319.77944,	126324.27253,	126328.76562,	126333.25873,	126337.75185,	126342.24499,	126346.73814,	126351.23131,	126355.72449,
126360.21768,	126364.71089,	126369.20411,	126373.69734,	126378.19059,	126382.68385,	126387.17713,	126391.67042,	126396.16373,	126400.65704,
126405.15038,	126409.64372,	126414.13708,	126418.63046,	126423.12385,	126427.61725,	126432.11067,	126436.60410,	126441.09754,	126445.59100,
126450.08447,	126454.57796,	126459.07146,	126463.56497,	126468.05850,	126472.55204,	126477.04559,	126481.53916,	126486.03275,	126490.52634,
126495.01996,	126499.51358,	126504.00722,	126508.50087,	126512.99454,	126517.48822,	126521.98192,	126526.47563,	126530.96935,	126535.46309,
126539.95684,	126544.45060,	126548.94438,	126553.43817,	126557.93198,	126562.42580,	126566.91963,	126571.41348,	126575.90734,	126580.40122,
126584.89511,	126589.38901,	126593.88293,	126598.37686,	126602.87081,	126607.36477,	126611.85874,	126616.35273,	126620.84673,	126625.34075,
126629.83478,	126634.32882,	126638.82288,	126643.31695,	126647.81103,	126652.30513,	126656.79924,	126661.29337,	126665.78751,	126670.28167,
126674.77583,	126679.27002,	126683.76421,	126688.25842,	126692.75265,	126697.24689,	126701.74114,	126706.23540,	126710.72968,	126715.22398,
126719.71829,	126724.21261,	126728.70694,	126733.20129,	126737.69566,	126742.19003,	126746.68442,	126751.17883,	126755.67325,	126760.16768,
126764.66213,	126769.15659,	126773.65106,	126778.14555,	126782.64005,	126787.13457,	126791.62910,	126796.12364,	126800.61820,	126805.11277,
126809.60736,	126814.10196,	126818.59657,	126823.09120,	126827.58584,	126832.08050,	126836.57517,	126841.06985,	126845.56455,	126850.05926,
126854.55398,	126859.04872,	126863.54348,	126868.03824,	126872.53302,	126877.02782,	126881.52263,	126886.01745,	126890.51228,	126895.00713,
126899.50200,	126903.99688,	126908.49177,	126912.98667,	126917.48159,	126921.97653,	126926.47147,	126930.96643,	126935.46141,	126939.95640,
126944.45140,	126948.94642,	126953.44145,	126957.93649,	126962.43155,	126966.92662,	126971.42171,	126975.91681,	126980.41192,	126984.90705,
126989.40219,	126993.89735,	126998.39252,	127002.88770,	127007.38290,	127011.87811,	127016.37334,	127020.86858,	127025.36383,	127029.85909,
127034.35438,	127038.84967,	127043.34498,	127047.84030,	127052.33564,	127056.83099,	127061.32635,	127065.82173,	127070.31712,	127074.81253,
127079.30795,	127083.80338,	127088.29883,	127092.79429,	127097.28976,	127101.78525,	127106.28075,	127110.77627,	127115.27180,	127119.76734,
127124.26290,	127128.75848,	127133.25406,	127137.74966,	127142.24527,	127146.74090,	127151.23654,	127155.73220,	127160.22787,	127164.72355,
127169.21925,	127173.71496,	127178.21068,	127182.70642,	127187.20217,	127191.69794,	127196.19372,	127200.68952,	127205.18532,	127209.68114,
127214.17698,	127218.67283,	127223.16869,	127227.66457,	127232.16046,	127236.65637,	127241.15229,	127245.64822,	127250.14416,	127254.64012,
127259.13610,	127263.63209,	127268.12809,	127272.62411,	127277.12013,	127281.61618,	127286.11224,	127290.60831,	127295.10439,	127299.60049,
127304.09660,	127308.59273,	127313.08887,	127317.58503,	127322.08119,	127326.57738,	127331.07357,	127335.56978,	127340.06601,	127344.56224,
127349.05849,	127353.55476,	127358.05104,	127362.54733,	127367.04364,	127371.53996,	127376.03629,	127380.53264,	127385.02900,	127389.52538,
127394.02177,	127398.51817,	127403.01459,	127407.51102,	127412.00747,	127416.50393,	127421.00040,	127425.49689,	127429.99339,	127434.48990,
127438.98643,	127443.48297,	127447.97953,	127452.47610,	127456.97268,	127461.46928,	127465.96589,	127470.46252,	127474.95916,	127479.45581,
127483.95248,	127488.44916,	127492.94585,	127497.44256,	127501.93928,	127506.43602,	127510.93277,	127515.42953,	127519.92631,	127524.42310,
127528.91990,	127533.41672,	127537.91356,	127542.41040,	127546.90726,	127551.40414,	127555.90103,	127560.39793,	127564.89484,	127569.39177,
127573.88872,	127578.38567,	127582.88265,	127587.37963,	127591.87663,	127596.37364,	127600.87067,	127605.36771,	127609.86476,	127614.36183,
127618.85891,	127623.35601,	127627.85312,	127632.35024,	127636.84738,	127641.34453,	127645.84169,	127650.33887,	127654.83606,	127659.33327,
127663.83049,	127668.32772,	127672.82497,	127677.32223,	127681.81951,	127686.31680,	127690.81410,	127695.31142,	127699.80875,	127704.30609,
127708.80345,	127713.30082,	127717.79821,	127722.29561,	127726.79302,	127731.29045,	127735.78789,	127740.28534,	127744.78281,	127749.28030,
127753.77779,	127758.27530,	127762.77283,	127767.27036,	127771.76792,	127776.26548,	127780.76306,	127785.26065,	127789.75826,	127794.25588,
127798.75352,	127803.25116,	127807.74883,	127812.24650,	127816.74419,	127821.24190,	127825.73961,	127830.23734,	127834.73509,	127839.23285,
127843.73062,	127848.22841,	127852.72621,	127857.22402,	127861.72185,	127866.21969,	127870.71754,	127875.21541,	127879.71330,	127884.21119,
127888.70910,	127893.20703,	127897.70497,	127902.20292,	127906.70088,	127911.19886,	127915.69686,	127920.19486,	127924.69289,	127929.19092,
127933.68897,	127938.18703,	127942.68511,	127947.18320,	127951.68130,	127956.17942,	127960.67755,	127965.17569,	127969.67385,	127974.17203,
127978.67021,	127983.16841,	127987.66663,	127992.16485,	127996.66310,	128001.16135,	128005.65962,	128010.15790,	128014.65620,	128019.15451,
128023.65284,	128028.15117,	128032.64953,	128037.14789,	128041.64627,	128046.14466,	128050.64307,	128055.14149,	128059.63993,	128064.13837,
128068.63684,	128073.13531,	128077.63380,	128082.13231,	128086.63082,	128091.12935,	128095.62790,	128100.12646,	128104.62503,	128109.12362,
128113.62222,	128118.12083,	128122.61946,	128127.11810,	128131.61675,	128136.11542,	128140.61411,	128145.11280,	128149.61151,	128154.11024,
128158.60897,	128163.10773,	128167.60649,	128172.10527,	128176.60406,	128181.10287,	128185.60169,	128190.10052,	128194.59937,	128199.09823,
128203.59711,	128208.09600,	128212.59490,	128217.09382,	128221.59275,	128226.09169,	128230.59065,	128235.08962,	128239.58861,	128244.08761,
128248.58662,	128253.08565,	128257.58469,	128262.08374,	128266.58281,	128271.08189,	128275.58099,	128280.08010,	128284.57922,	128289.07836,
128293.57751,	128298.07667,	128302.57585,	128307.07504,	128311.57425,	128316.07347,	128320.57270,	128325.07195,	128329.57121,	128334.07049,
128338.56977,	128343.06908,	128347.56839,	128352.06772,	128356.56706,	128361.06642,	128365.56579,	128370.06518,	128374.56458,	128379.06399,
128383.56341,	128388.06285,	128392.56231,	128397.06177,	128401.56125,	128406.06075,	128410.56026,	128415.05978,	128419.55932,	128424.05886,
128428.55843,	128433.05801,	128437.55760,	128442.05720,	128446.55682,	128451.05645,	128455.55610,	128460.05576,	128464.55543,	128469.05512,
128473.55482,	128478.05453,	128482.55426,	128487.05400,	128491.55376,	128496.05353,	128500.55331,	128505.05311,	128509.55292,	128514.05274,
128518.55258,	128523.05243,	128527.55230,	128532.05218,	128536.55207,	128541.05198,	128545.55190,	128550.05183,	128554.55178,	128559.05174,
128563.55172,	128568.05171,	128572.55171,	128577.05173,	128581.55176,	128586.05180,	128590.55186,	128595.05193,	128599.55202,	128604.05212,
128608.55223,	128613.05236,	128617.55250,	128622.05265,	128626.55282,	128631.05300,	128635.55320,	128640.05341,	128644.55363,	128649.05387,
128653.55412,	128658.05438,	128662.55466,	128667.05495,	128671.55525,	128676.05557,	128680.55591,	128685.05625,	128689.55661,	128694.05698,
128698.55737,	128703.05777,	128707.55819,	128712.05862,	128716.55906,	128721.05952,	128725.55999,	128730.06047,	128734.56097,	128739.06148,
128743.56200,	128748.06254,	128752.56309,	128757.06366,	128761.56424,	128766.06483,	128770.56544,	128775.06606,	128779.56669,	128784.06734,
128788.56800,	128793.06868,	128797.56937,	128802.07007,	128806.57079,	128811.07152,	128815.57226,	128820.07302,	128824.57379,	128829.07457,
128833.57537,	128838.07619,	128842.57701,	128847.07785,	128851.57871,	128856.07957,	128860.58046,	128865.08135,	128869.58226,	128874.08318,
128878.58412,	128883.08507,	128887.58603,	128892.08701,	128896.58800,	128901.08900,	128905.59002,	128910.09105,	128914.59210,	128919.09316,
128923.59423,	128928.09532,	128932.59642,	128937.09753,	128941.59866,	128946.09980,	128950.60096,	128955.10212,	128959.60331,	128964.10450,
128968.60571,	128973.10694,	128977.60817,	128982.10942,	128986.61069,	128991.11197,	128995.61326,	129000.11457,	129004.61589,	129009.11722,
129013.61857,	129018.11993,	129022.62130,	129027.12269,	129031.62409,	129036.12550,	129040.62693,	129045.12838,	129049.62983,	129054.13130,
129058.63279,	129063.13428,	129067.63580,	129072.13732,	129076.63886,	129081.14041,	129085.64198,	129090.14356,	129094.64515,	129099.14676,
129103.64838,	129108.15001,	129112.65166,	129117.15332,	129121.65500,	129126.15669,	129130.65839,	129135.16010,	129139.66183,	129144.16358,
129148.66534,	129153.16711,	129157.66889,	129162.17069,	129166.67250,	129171.17433,	129175.67617,	129180.17802,	129184.67989,	129189.18177,
129193.68366,	129198.18557,	129202.68749,	129207.18943,	129211.69138,	129216.19334,	129220.69531,	129225.19730,	129229.69931,	129234.20132,
129238.70336,	129243.20540,	129247.70746,	129252.20953,	129256.71162,	129261.21372,	129265.71583,	129270.21795,	129274.72009,	129279.22225,
129283.72442,	129288.22660,	129292.72879,	129297.23100,	129301.73322,	129306.23546,	129310.73771,	129315.23997,	129319.74225,	129324.24454,
129328.74684,	129333.24916,	129337.75149,	129342.25384,	129346.75620,	129351.25857,	129355.76096,	129360.26336,	129364.76577,	129369.26820,
129373.77064,	129378.27309,	129382.77556,	129387.27804,	129391.78054,	129396.28305,	129400.78557,	129405.28810,	129409.79065,	129414.29322,
129418.79580,	129423.29839,	129427.80099,	129432.30361,	129436.80624,	129441.30889,	129445.81155,	129450.31422,	129454.81691,	129459.31961,
129463.82232,	129468.32505,	129472.82779,	129477.33054,	129481.83331,	129486.33609,	129490.83889,	129495.34170,	129499.84452,	129504.34736,
129508.85021,	129513.35307,	129517.85595,	129522.35884,	129526.86175,	129531.36466,	129535.86760,	129540.37054,	129544.87350,	129549.37647,
129553.87946,	129558.38246,	129562.88548,	129567.38850,	129571.89154,	129576.39460,	129580.89767,	129585.40075,	129589.90385,	129594.40696,
129598.91008,	129603.41321,	129607.91637,	129612.41953,	129616.92271,	129621.42590,	129625.92910,	129630.43232,	129634.93555,	129639.43880,
129643.94206,	129648.44533,	129652.94862,	129657.45192,	129661.95523,	129666.45856,	129670.96190,	129675.46526,	129679.96862,	129684.47201,
129688.97540,	129693.47881,	129697.98223,	129702.48567,	129706.98912,	129711.49259,	129715.99606,	129720.49955,	129725.00306,	129729.50658,
129734.01011,	129738.51365,	129743.01721,	129747.52079,	129752.02437,	129756.52797,	129761.03159,	129765.53521,	129770.03885,	129774.54251,
129779.04618,	129783.54986,	129788.05355,	129792.55726,	129797.06099,	129801.56472,	129806.06847,	129810.57224,	129815.07601,	129819.57980,
129824.08361,	129828.58743,	129833.09126,	129837.59510,	129842.09896,	129846.60283,	129851.10672,	129855.61062,	129860.11453,	129864.61846,
129869.12240,	129873.62635,	129878.13032,	129882.63430,	129887.13830,	129891.64231,	129896.14633,	129900.65036,	129905.15441,	129909.65848,
129914.16255,	129918.66664,	129923.17075,	129927.67486,	129932.17899,	129936.68314,	129941.18730,	129945.69147,	129950.19565,	129954.69985,
129959.20406,	129963.70829,	129968.21253,	129972.71678,	129977.22105,	129981.72533,	129986.22963,	129990.73393,	129995.23825,	129999.74259,
130004.24694,	130008.75130,	130013.25568,	130017.76007,	130022.26447,	130026.76888,	130031.27331,	130035.77776,	130040.28222,	130044.78669,
130049.29117,	130053.79567,	130058.30018,	130062.80471,	130067.30924,	130071.81380,	130076.31836,	130080.82294,	130085.32754,	130089.83214,
130094.33676,	130098.84140,	130103.34604,	130107.85071,	130112.35538,	130116.86007,	130121.36477,	130125.86949,	130130.37421,	130134.87896,
130139.38371,	130143.88848,	130148.39327,	130152.89806,	130157.40287,	130161.90770,	130166.41254,	130170.91739,	130175.42225,	130179.92713,
130184.43202,	130188.93693,	130193.44185,	130197.94678,	130202.45173,	130206.95669,	130211.46166,	130215.96665,	130220.47165,	130224.97666,
130229.48169,	130233.98673,	130238.49179,	130242.99686,	130247.50194,	130252.00703,	130256.51214,	130261.01727,	130265.52240,	130270.02755,
130274.53271,	130279.03789,	130283.54308,	130288.04829,	130292.55350,	130297.05874,	130301.56398,	130306.06924,	130310.57451,	130315.07980,
130319.58510,	130324.09041,	130328.59574,	130333.10108,	130337.60643,	130342.11180,	130346.61718,	130351.12257,	130355.62798,	130360.13340,
130364.63884,	130369.14428,	130373.64975,	130378.15522,	130382.66071,	130387.16621,	130391.67173,	130396.17726,	130400.68280,	130405.18836,
130409.69393,	130414.19951,	130418.70511,	130423.21072,	130427.71635,	130432.22199,	130436.72764,	130441.23330,	130445.73898,	130450.24467,
130454.75038,	130459.25610,	130463.76183,	130468.26758,	130472.77334,	130477.27911,	130481.78490,	130486.29070,	130490.79652,	130495.30235,
130499.80819,	130504.31404,	130508.81991,	130513.32579,	130517.83169,	130522.33760,	130526.84352,	130531.34946,	130535.85541,	130540.36137,
130544.86735,	130549.37334,	130553.87934,	130558.38536,	130562.89139,	130567.39744,	130571.90349,	130576.40957,	130580.91565,	130585.42175,
130589.92786,	130594.43399,	130598.94013,	130603.44628,	130607.95245,	130612.45863,	130616.96482,	130621.47103,	130625.97725,	130630.48349,
130634.98973,	130639.49599,	130644.00227,	130648.50856,	130653.01486,	130657.52118,	130662.02750,	130666.53385,	130671.04020,	130675.54657,
130680.05296,	130684.55935,	130689.06576,	130693.57219,	130698.07862,	130702.58508,	130707.09154,	130711.59802,	130716.10451,	130720.61101,
130725.11753,	130729.62407,	130734.13061,	130738.63717,	130743.14374,	130747.65033,	130752.15693,	130756.66354,	130761.17017,	130765.67681,
130770.18346,	130774.69013,	130779.19681,	130783.70351,	130788.21021,	130792.71693,	130797.22367,	130801.73042,	130806.23718,	130810.74396,
130815.25074,	130819.75755,	130824.26436,	130828.77119,	130833.27804,	130837.78489,	130842.29176,	130846.79865,	130851.30554,	130855.81245,
130860.31938,	130864.82632,	130869.33327,	130873.84023,	130878.34721,	130882.85420,	130887.36121,	130891.86823,	130896.37526,	130900.88231,
130905.38936,	130909.89644,	130914.40352,	130918.91062,	130923.41774,	130927.92486,	130932.43200,	130936.93916,	130941.44633,	130945.95351,
130950.46070,	130954.96791,	130959.47513,	130963.98237,	130968.48961,	130972.99688,	130977.50415,	130982.01144,	130986.51874,	130991.02606,
130995.53339,	131000.04073,	131004.54809,	131009.05546,	131013.56284,	131018.07024,	131022.57765,	131027.08507,	131031.59251,	131036.09996,
131040.60743,	131045.11491,	131049.62240,	131054.12990,	131058.63742,	131063.14495,	131067.65250,	131072.16006,	131076.66763,	131081.17522,
131085.68282,	131090.19043,	131094.69806,	131099.20570,	131103.71335,	131108.22102,	131112.72870,	131117.23639,	131121.74410,	131126.25182,
131130.75955,	131135.26730,	131139.77506,	131144.28284,	131148.79063,	131153.29843,	131157.80624,	131162.31407,	131166.82191,	131171.32977,
131175.83764,	131180.34552,	131184.85342,	131189.36133,	131193.86925,	131198.37719,	131202.88514,	131207.39310,	131211.90108,	131216.40907,
131220.91707,	131225.42509,	131229.93312,	131234.44117,	131238.94923,	131243.45730,	131247.96538,	131252.47348,	131256.98159,	131261.48972,
131265.99786,	131270.50601,	131275.01418,	131279.52236,	131284.03055,	131288.53876,	131293.04698,	131297.55521,	131302.06346,	131306.57172,
131311.07999,	131315.58828,	131320.09658,	131324.60489,	131329.11322,	131333.62156,	131338.12992,	131342.63828,	131347.14667,	131351.65506,
131356.16347,	131360.67189,	131365.18033,	131369.68878,	131374.19724,	131378.70571,	131383.21420,	131387.72271,	131392.23122,	131396.73975,
131401.24829,	131405.75685,	131410.26542,	131414.77400,	131419.28260,	131423.79121,	131428.29984,	131432.80847,	131437.31712,	131441.82579,
131446.33447,	131450.84316,	131455.35186,	131459.86058,	131464.36931,	131468.87806,	131473.38682,	131477.89559,	131482.40437,	131486.91317,
131491.42199,	131495.93081,	131500.43965,	131504.94850,	131509.45737,	131513.96625,	131518.47514,	131522.98405,	131527.49297,	131532.00190,
131536.51085,	131541.01981,	131545.52878,	131550.03777,	131554.54677,	131559.05579,	131563.56481,	131568.07386,	131572.58291,	131577.09198,
131581.60106,	131586.11015,	131590.61926,	131595.12838,	131599.63752,	131604.14667,	131608.65583,	131613.16501,	131617.67420,	131622.18340,
131626.69261,	131631.20184,	131635.71109,	131640.22034,	131644.72961,	131649.23890,	131653.74819,	131658.25750,	131662.76683,	131667.27616,
131671.78551,	131676.29488,	131680.80425,	131685.31365,	131689.82305,	131694.33247,	131698.84190,	131703.35134,	131707.86080,	131712.37027,
131716.87976,	131721.38925,	131725.89877,	131730.40829,	131734.91783,	131739.42738,	131743.93695,	131748.44653,	131752.95612,	131757.46572,
131761.97534,	131766.48498,	131770.99462,	131775.50428,	131780.01395,	131784.52364,	131789.03334,	131793.54305,	131798.05278,	131802.56252,
131807.07227,	131811.58204,	131816.09182,	131820.60161,	131825.11142,	131829.62124,	131834.13108,	131838.64092,	131843.15078,	131847.66066,
131852.17055,	131856.68045,	131861.19036,	131865.70029,	131870.21023,	131874.72019,	131879.23015,	131883.74014,	131888.25013,	131892.76014,
131897.27016,	131901.78020,	131906.29025,	131910.80031,	131915.31038,	131919.82047,	131924.33058,	131928.84069,	131933.35082,	131937.86096,
131942.37112,	131946.88129,	131951.39147,	131955.90167,	131960.41188,	131964.92210,	131969.43234,	131973.94259,	131978.45285,	131982.96313,
131987.47342,	131991.98372,	131996.49404,	132001.00437,	132005.51471,	132010.02507,	132014.53544,	132019.04583,	132023.55622,	132028.06663,
132032.57706,	132037.08750,	132041.59795,	132046.10841,	132050.61889,	132055.12938,	132059.63989,	132064.15040,	132068.66094,	132073.17148,
132077.68204,	132082.19261,	132086.70320,	132091.21379,	132095.72441,	132100.23503,	132104.74567,	132109.25632,	132113.76699,	132118.27767,
132122.78836,	132127.29907,	132131.80979,	132136.32052,	132140.83126,	132145.34202,	132149.85280,	132154.36358,	132158.87438,	132163.38520,
132167.89602,	132172.40686,	132176.91771,	132181.42858,	132185.93946,	132190.45035,	132194.96126,	132199.47218,	132203.98311,	132208.49406,
132213.00502,	132217.51600,	132222.02698,	132226.53798,	132231.04900,	132235.56002,	132240.07107,	132244.58212,	132249.09319,	132253.60427,
132258.11536,	132262.62647,	132267.13759,	132271.64873,	132276.15987,	132280.67103,	132285.18221,	132289.69340,	132294.20460,	132298.71581,
132303.22704,	132307.73828,	132312.24954,	132316.76081,	132321.27209,	132325.78338,	132330.29469,	132334.80601,	132339.31735,	132343.82870,
132348.34006,	132352.85143,	132357.36282,	132361.87422,	132366.38564,	132370.89707,	132375.40851,	132379.91997,	132384.43143,	132388.94292,
132393.45441,	132397.96592,	132402.47744,	132406.98898,	132411.50053,	132416.01209,	132420.52367,	132425.03526,	132429.54686,	132434.05847,
132438.57010,	132443.08175,	132447.59340,	132452.10507,	132456.61676,	132461.12845,	132465.64016,	132470.15188,	132474.66362,	132479.17537,
132483.68713,	132488.19891,	132492.71070,	132497.22250,	132501.73432,	132506.24615,	132510.75799,	132515.26985,	132519.78172,	132524.29360,
132528.80550,	132533.31741,	132537.82933,	132542.34127,	132546.85322,	132551.36518,	132555.87716,	132560.38915,	132564.90115,	132569.41317,
132573.92520,	132578.43725,	132582.94930,	132587.46137,	132591.97346,	132596.48555,	132600.99766,	132605.50979,	132610.02192,	132614.53408,
132619.04624,	132623.55842,	132628.07061,	132632.58281,	132637.09503,	132641.60726,	132646.11950,	132650.63176,	132655.14403,	132659.65632,
132664.16861,	132668.68092,	132673.19325,	132677.70559,	132682.21794,	132686.73030,	132691.24268,	132695.75507,	132700.26747,	132704.77989,
132709.29232,	132713.80477,	132718.31722,	132722.82969,	132727.34218,	132731.85468,	132736.36719,	132740.87971,	132745.39225,	132749.90480,
132754.41736,	132758.92994,	132763.44253,	132767.95514,	132772.46775,	132776.98039,	132781.49303,	132786.00569,	132790.51836,	132795.03104,
132799.54374,	132804.05645,	132808.56918,	132813.08191,	132817.59467,	132822.10743,	132826.62021,	132831.13300,	132835.64580,	132840.15862,
132844.67145,	132849.18430,	132853.69715,	132858.21003,	132862.72291,	132867.23581,	132871.74872,	132876.26164,	132880.77458,	132885.28753,
132889.80050,	132894.31347,	132898.82646,	132903.33947,	132907.85249,	132912.36552,	132916.87856,	132921.39162,	132925.90469,	132930.41778,
132934.93087,	132939.44398,	132943.95711,	132948.47025,	132952.98340,	132957.49656,	132962.00974,	132966.52293,	132971.03613,	132975.54935,
132980.06258,	132984.57583,	132989.08908,	132993.60236,	132998.11564,	133002.62894,	133007.14225,	133011.65557,	133016.16891,	133020.68226,
133025.19562,	133029.70900,	133034.22239,	133038.73580,	133043.24921,	133047.76265,	133052.27609,	133056.78955,	133061.30302,	133065.81650,
133070.33000,	133074.84351,	133079.35703,	133083.87057,	133088.38412,	133092.89768,	133097.41126,	133101.92485,	133106.43846,	133110.95207,
133115.46570,	133119.97935,	133124.49300,	133129.00667,	133133.52036,	133138.03405,	133142.54776,	133147.06149,	133151.57523,	133156.08898,
133160.60274,	133165.11652,	133169.63031,	133174.14411,	133178.65793,	133183.17176,	133187.68560,	133192.19946,	133196.71333,	133201.22721,
133205.74111,	133210.25501,	133214.76894,	133219.28287,	133223.79682,	133228.31079,	133232.82476,	133237.33875,	133241.85276,	133246.36677,
133250.88080,	133255.39484,	133259.90890,	133264.42297,	133268.93705,	133273.45115,	133277.96526,	133282.47938,	133286.99352,	133291.50767,
133296.02183,	133300.53600,	133305.05019,	133309.56439,	133314.07861,	133318.59284,	133323.10708,	133327.62134,	133332.13561,	133336.64989,
133341.16418,	133345.67849,	133350.19281,	133354.70715,	133359.22150,	133363.73586,	133368.25023,	133372.76462,	133377.27902,	133381.79344,
133386.30787,	133390.82231,	133395.33676,	133399.85123,	133404.36571,	133408.88021,	133413.39472,	133417.90924,	133422.42377,	133426.93832,
133431.45288,	133435.96745,	133440.48204,	133444.99664,	133449.51126,	133454.02588,	133458.54052,	133463.05518,	133467.56985,	133472.08453,
133476.59922,	133481.11393,	133485.62865,	133490.14338,	133494.65813,	133499.17289,	133503.68766,	133508.20245,	133512.71725,	133517.23206,
133521.74689,	133526.26173,	133530.77658,	133535.29145,	133539.80633,	133544.32122,	133548.83613,	133553.35105,	133557.86598,	133562.38093,
133566.89588,	133571.41086,	133575.92584,	133580.44084,	133584.95585,	133589.47088,	133593.98592,	133598.50097,	133603.01604,	133607.53111,
133612.04621,	133616.56131,	133621.07643,	133625.59156,	133630.10671,	133634.62187,	133639.13704,	133643.65222,	133648.16742,	133652.68263,
133657.19786,	133661.71309,	133666.22834,	133670.74361,	133675.25889,	133679.77418,	133684.28948,	133688.80480,	133693.32013,	133697.83547,
133702.35083,	133706.86620,	133711.38158,	133715.89698,	133720.41239,	133724.92782,	133729.44325,	133733.95870,	133738.47416,	133742.98964,
133747.50513,	133752.02063,	133756.53615,	133761.05168,	133765.56722,	133770.08278,	133774.59835,	133779.11393,	133783.62953,	133788.14513,
133792.66076,	133797.17639,	133801.69204,	133806.20770,	133810.72338,	133815.23907,	133819.75477,	133824.27048,	133828.78621,	133833.30195,
133837.81771,	133842.33348,	133846.84926,	133851.36505,	133855.88086,	133860.39668,	133864.91251,	133869.42836,	133873.94422,	133878.46010,
133882.97598,	133887.49188,	133892.00780,	133896.52372,	133901.03966,	133905.55562,	133910.07158,	133914.58756,	133919.10356,	133923.61956,
133928.13558,	133932.65161,	133937.16766,	133941.68372,	133946.19979,	133950.71588,	133955.23198,	133959.74809,	133964.26421,	133968.78035,
133973.29650,	133977.81267,	133982.32885,	133986.84504,	133991.36124,	133995.87746,	134000.39369,	134004.90994,	134009.42619,	134013.94247,
134018.45875,	134022.97505,	134027.49136,	134032.00768,	134036.52402,	134041.04037,	134045.55673,	134050.07311,	134054.58950,	134059.10590,
134063.62232,	134068.13875,	134072.65519,	134077.17165,	134081.68812,	134086.20460,	134090.72109,	134095.23760,	134099.75413,	134104.27066,
134108.78721,	134113.30377,	134117.82035,	134122.33693,	134126.85354,	134131.37015,	134135.88678,	134140.40342,	134144.92007,	134149.43674,
134153.95342,	134158.47012,	134162.98682,	134167.50354,	134172.02028,	134176.53702,	134181.05378,	134185.57056,	134190.08734,	134194.60414,
134199.12096,	134203.63778,	134208.15462,	134212.67147,	134217.18834,	134221.70522,	134226.22211,	134230.73902,	134235.25594,	134239.77287,
134244.28981,	134248.80677,	134253.32374,	134257.84073,	134262.35772,	134266.87474,	134271.39176,	134275.90880,	134280.42585,	134284.94291,
134289.45999,	134293.97708,	134298.49418,	134303.01130,	134307.52843,	134312.04557,	134316.56273,	134321.07990,	134325.59708,	134330.11428,
134334.63149,	134339.14871,	134343.66594,	134348.18319,	134352.70045,	134357.21773,	134361.73502,	134366.25232,	134370.76963,	134375.28696,
134379.80430,	134384.32166,	134388.83902,	134393.35641,	134397.87380,	134402.39121,	134406.90863,	134411.42606,	134415.94351,	134420.46097,
134424.97844,	134429.49593,	134434.01343,	134438.53094,	134443.04846,	134447.56600,	134452.08355,	134456.60112,	134461.11870,	134465.63629,
134470.15390,	134474.67151,	134479.18914,	134483.70679,	134488.22445,	134492.74212,	134497.25980,	134501.77750,	134506.29521,	134510.81293,
134515.33067,	134519.84842,	134524.36618,	134528.88396,	134533.40175,	134537.91955,	134542.43737,	134546.95520,	134551.47304,	134555.99089,
134560.50876,	134565.02664,	134569.54454,	134574.06245,	134578.58037,	134583.09830,	134587.61625,	134592.13421,	134596.65219,	134601.17017,
134605.68817,	134610.20619,	134614.72421,	134619.24225,	134623.76031,	134628.27837,	134632.79645,	134637.31454,	134641.83265,	134646.35077,
134650.86890,	134655.38705,	134659.90521,	134664.42338,	134668.94156,	134673.45976,	134677.97797,	134682.49620,	134687.01443,	134691.53268,
134696.05095,	134700.56922,	134705.08751,	134709.60582,	134714.12413,	134718.64246,	134723.16081,	134727.67916,	134732.19753,	134736.71591,
134741.23431,	134745.75272,	134750.27114,	134754.78957,	134759.30802,	134763.82648,	134768.34496,	134772.86345,	134777.38195,	134781.90046,
134786.41899,	134790.93753,	134795.45608,	134799.97465,	134804.49323,	134809.01182,	134813.53043,	134818.04905,	134822.56768,	134827.08632,
134831.60498,	134836.12365,	134840.64234,	134845.16104,	134849.67975,	134854.19847,	134858.71721,	134863.23596,	134867.75473,	134872.27350,
134876.79229,	134881.31110,	134885.82991,	134890.34874,	134894.86759,	134899.38644,	134903.90531,	134908.42419,	134912.94309,	134917.46200,
134921.98092,	134926.49985,	134931.01880,	134935.53776,	134940.05674,	134944.57572,	134949.09473,	134953.61374,	134958.13277,	134962.65181,
134967.17086,	134971.68993,	134976.20900,	134980.72810,	134985.24720,	134989.76632,	134994.28545,	134998.80460,	135003.32376,	135007.84293,
135012.36211,	135016.88131,	135021.40052,	135025.91975,	135030.43898,	135034.95823,	135039.47750,	135043.99677,	135048.51606,	135053.03537,
135057.55468,	135062.07401,	135066.59335,	135071.11271,	135075.63208,	135080.15146,	135084.67085,	135089.19026,	135093.70968,	135098.22912,
135102.74856,	135107.26803,	135111.78750,	135116.30699,	135120.82649,	135125.34600,	135129.86552,	135134.38506,	135138.90462,	135143.42418,
135147.94376,	135152.46335,	135156.98296,	135161.50257,	135166.02221,	135170.54185,	135175.06151,	135179.58118,	135184.10086,	135188.62056,
135193.14027,	135197.65999,	135202.17973,	135206.69948,	135211.21924,	135215.73901,	135220.25880,	135224.77861,	135229.29842,	135233.81825,
135238.33809,	135242.85794,	135247.37781,	135251.89769,	135256.41758,	135260.93749,	135265.45741,	135269.97734,	135274.49729,	135279.01725,
135283.53722,	135288.05721,	135292.57721,	135297.09722,	135301.61724,	135306.13728,	135310.65733,	135315.17740,	135319.69747,	135324.21756,
135328.73767,	135333.25778,	135337.77791,	135342.29806,	135346.81821,	135351.33838,	135355.85856,	135360.37876,	135364.89897,	135369.41919,
135373.93942,	135378.45967,	135382.97993,	135387.50020,	135392.02049,	135396.54079,	135401.06110,	135405.58143,	135410.10177,	135414.62212,
135419.14249,	135423.66287,	135428.18326,	135432.70366,	135437.22408,	135441.74451,	135446.26496,	135450.78541,	135455.30588,	135459.82637,
135464.34686,	135468.86737,	135473.38790,	135477.90843,	135482.42898,	135486.94954,	135491.47012,	135495.99071,	135500.51131,	135505.03192,
135509.55255,	135514.07319,	135518.59385,	135523.11451,	135527.63519,	135532.15589,	135536.67659,	135541.19731,	135545.71804,	135550.23879,
135554.75955,	135559.28032,	135563.80110,	135568.32190,	135572.84271,	135577.36354,	135581.88437,	135586.40522,	135590.92609,	135595.44696,
135599.96785,	135604.48876,	135609.00967,	135613.53060,	135618.05154,	135622.57250,	135627.09347,	135631.61445,	135636.13544,	135640.65645,
135645.17747,	135649.69850,	135654.21955,	135658.74061,	135663.26168,	135667.78277,	135672.30386,	135676.82498,	135681.34610,	135685.86724,
135690.38839,	135694.90956,	135699.43073,	135703.95192,	135708.47313,	135712.99434,	135717.51557,	135722.03682,	135726.55807,	135731.07934,
135735.60062,	135740.12192,	135744.64323,	135749.16455,	135753.68588,	135758.20723,	135762.72859,	135767.24996,	135771.77135,	135776.29275,
135780.81416,	135785.33559,	135789.85703,	135794.37848,	135798.89994,	135803.42142,	135807.94291,	135812.46442,	135816.98593,	135821.50746,
135826.02901,	135830.55056,	135835.07213,	135839.59372,	135844.11531,	135848.63692,	135853.15854,	135857.68018,	135862.20182,	135866.72349,
135871.24516,	135875.76685,	135880.28855,	135884.81026,	135889.33199,	135893.85373,	135898.37548,	135902.89724,	135907.41902,	135911.94081,
135916.46262,	135920.98444,	135925.50627,	135930.02811,	135934.54997,	135939.07184,	135943.59372,	135948.11562,	135952.63753,	135957.15945,
135961.68138,	135966.20333,	135970.72529,	135975.24727,	135979.76926,	135984.29126,	135988.81327,	135993.33530,	135997.85734,	136002.37939,
136006.90146,	136011.42353,	136015.94563,	136020.46773,	136024.98985,	136029.51198,	136034.03412,	136038.55628,	136043.07845,	136047.60064,
136052.12283,	136056.64504,	136061.16726,	136065.68950,	136070.21175,	136074.73401,	136079.25628,	136083.77857,	136088.30087,	136092.82319,
136097.34551,	136101.86785,	136106.39021,	136110.91257,	136115.43495,	136119.95734,	136124.47975,	136129.00217,	136133.52460,	136138.04704,
136142.56950,	136147.09197,	136151.61445,	136156.13695,	136160.65946,	136165.18198,	136169.70452,	136174.22706,	136178.74963,	136183.27220,
136187.79479,	136192.31739,	136196.84000,	136201.36263,	136205.88527,	136210.40792,	136214.93059,	136219.45327,	136223.97596,	136228.49866,
136233.02138,	136237.54411,	136242.06686,	136246.58961,	136251.11238,	136255.63517,	136260.15796,	136264.68077,	136269.20360,	136273.72643,
136278.24928,	136282.77214,	136287.29502,	136291.81790,	136296.34080,	136300.86372,	136305.38664,	136309.90958,	136314.43254,	136318.95550,
136323.47848,	136328.00147,	136332.52448,	136337.04749,	136341.57052,	136346.09357,	136350.61662,	136355.13969,	136359.66278,	136364.18587,
136368.70898,	136373.23210,	136377.75524,	136382.27839,	136386.80155,	136391.32472,	136395.84791,	136400.37111,	136404.89432,	136409.41755,
136413.94079,	136418.46404,	136422.98730,	136427.51058,	136432.03387,	136436.55718,	136441.08049,	136445.60382,	136450.12717,	136454.65052,
136459.17389,	136463.69728,	136468.22067,	136472.74408,	136477.26750,	136481.79093,	136486.31438,	136490.83784,	136495.36132,	136499.88480,
136504.40830,	136508.93181,	136513.45534,	136517.97888,	136522.50243,	136527.02599,	136531.54957,	136536.07316,	136540.59676,	136545.12038,
136549.64401,	136554.16765,	136558.69131,	136563.21498,	136567.73866,	136572.26235,	136576.78606,	136581.30978,	136585.83351,	136590.35726,
136594.88102,	136599.40479,	136603.92858,	136608.45238,	136612.97619,	136617.50001,	136622.02385,	136626.54770,	136631.07156,	136635.59544,
136640.11933,	136644.64323,	136649.16715,	136653.69108,	136658.21502,	136662.73897,	136667.26294,	136671.78692,	136676.31091,	136680.83492,
136685.35894,	136689.88297,	136694.40702,	136698.93108,	136703.45515,	136707.97923,	136712.50333,	136717.02744,	136721.55156,	136726.07570,
136730.59985,	136735.12401,	136739.64819,	136744.17237,	136748.69658,	136753.22079,	136757.74502,	136762.26926,	136766.79351,	136771.31778,
136775.84206,	136780.36635,	136784.89065,	136789.41497,	136793.93930,	136798.46365,	136802.98800,	136807.51237,	136812.03676,	136816.56115,
136821.08556,	136825.60998,	136830.13442,	136834.65887,	136839.18333,	136843.70780,	136848.23229,	136852.75679,	136857.28130,	136861.80583,
136866.33037,	136870.85492,	136875.37948,	136879.90406,	136884.42865,	136888.95326,	136893.47787,	136898.00250,	136902.52715,	136907.05180,
136911.57647,	136916.10115,	136920.62585,	136925.15055,	136929.67528,	136934.20001,	136938.72476,	136943.24951,	136947.77429,	136952.29907,
136956.82387,	136961.34868,	136965.87351,	136970.39834,	136974.92319,	136979.44806,	136983.97293,	136988.49782,	136993.02273,	136997.54764,
137002.07257,	137006.59751,	137011.12246,	137015.64743,	137020.17241,	137024.69740,	137029.22241,	137033.74743,	137038.27246,	137042.79751,
137047.32256,	137051.84763,	137056.37272,	137060.89781,	137065.42292,	137069.94805,	137074.47318,	137078.99833,	137083.52349,	137088.04867,
137092.57385,	137097.09905,	137101.62427,	137106.14949,	137110.67473,	137115.19999,	137119.72525,	137124.25053,	137128.77582,	137133.30112,
137137.82644,	137142.35177,	137146.87711,	137151.40247,	137155.92784,	137160.45322,	137164.97861,	137169.50402,	137174.02944,	137178.55488,
137183.08032,	137187.60578,	137192.13125,	137196.65674,	137201.18224,	137205.70775,	137210.23327,	137214.75881,	137219.28436,	137223.80992,
137228.33550,	137232.86109,	137237.38669,	137241.91231,	137246.43793,	137250.96357,	137255.48923,	137260.01489,	137264.54057,	137269.06627,
137273.59197,	137278.11769,	137282.64342,	137287.16917,	137291.69492,	137296.22069,	137300.74648,	137305.27227,	137309.79808,	137314.32390,
137318.84974,	137323.37559,	137327.90145,	137332.42732,	137336.95321,	137341.47911,	137346.00502,	137350.53095,	137355.05688,	137359.58283,
137364.10880,	137368.63478,	137373.16077,	137377.68677,	137382.21279,	137386.73881,	137391.26486,	137395.79091,	137400.31698,	137404.84306,
137409.36915,	137413.89526,	137418.42138,	137422.94751,	137427.47366,	137431.99982,	137436.52599,	137441.05217,	137445.57837,	137450.10458,
137454.63080,	137459.15704,	137463.68329,	137468.20955,	137472.73582,	137477.26211,	137481.78841,	137486.31472,	137490.84105,	137495.36739,
137499.89374,	137504.42011,	137508.94648,	137513.47288,	137517.99928,	137522.52570,	137527.05213,	137531.57857,	137536.10502,	137540.63149,
137545.15797,	137549.68447,	137554.21098,	137558.73750,	137563.26403,	137567.79058,	137572.31713,	137576.84371,	137581.37029,	137585.89689,
137590.42350,	137594.95012,	137599.47676,	137604.00341,	137608.53007,	137613.05675,	137617.58343,	137622.11014,	137626.63685,	137631.16358,
137635.69032,	137640.21707,	137644.74383,	137649.27061,	137653.79740,	137658.32421,	137662.85103,	137667.37786,	137671.90470,	137676.43155,
137680.95842,	137685.48531,	137690.01220,	137694.53911,	137699.06603,	137703.59296,	137708.11991,	137712.64687,	137717.17384,	137721.70082,
137726.22782,	137730.75483,	137735.28186,	137739.80889,	137744.33594,	137748.86301,	137753.39008,	137757.91717,	137762.44427,	137766.97138,
137771.49851,	137776.02565,	137780.55280,	137785.07997,	137789.60715,	137794.13434,	137798.66155,	137803.18876,	137807.71599,	137812.24324,
137816.77049,	137821.29776,	137825.82504,	137830.35234,	137834.87964,	137839.40697,	137843.93430,	137848.46164,	137852.98900,	137857.51638,
137862.04376,	137866.57116,	137871.09857,	137875.62599,	137880.15343,	137884.68088,	137889.20834,	137893.73582,	137898.26331,	137902.79081,
137907.31832,	137911.84585,	137916.37339,	137920.90094,	137925.42850,	137929.95608,	137934.48367,	137939.01128,	137943.53890,	137948.06653,
137952.59417,	137957.12182,	137961.64949,	137966.17717,	137970.70487,	137975.23258,	137979.76030,	137984.28803,	137988.81577,	137993.34353,
137997.87130,	138002.39909,	138006.92689,	138011.45470,	138015.98252,	138020.51036,	138025.03820,	138029.56607,	138034.09394,	138038.62183,
138043.14973,	138047.67764,	138052.20557,	138056.73351,	138061.26146,	138065.78942,	138070.31740,	138074.84539,	138079.37340,	138083.90141,
138088.42944,	138092.95748,	138097.48554,	138102.01361,	138106.54169,	138111.06978,	138115.59789,	138120.12601,	138124.65414,	138129.18228,
138133.71044,	138138.23861,	138142.76680,	138147.29499,	138151.82320,	138156.35143,	138160.87966,	138165.40791,	138169.93617,	138174.46444,
138178.99273,	138183.52103,	138188.04934,	138192.57767,	138197.10600,	138201.63436,	138206.16272,	138210.69110,	138215.21949,	138219.74789,
138224.27630,	138228.80473,	138233.33317,	138237.86163,	138242.39009,	138246.91857,	138251.44707,	138255.97557,	138260.50409,	138265.03262,
138269.56116,	138274.08972,	138278.61829,	138283.14687,	138287.67547,	138292.20408,	138296.73270,	138301.26133,	138305.78998,	138310.31864,
138314.84731,	138319.37600,	138323.90469,	138328.43341,	138332.96213,	138337.49087,	138342.01962,	138346.54838,	138351.07715,	138355.60594,
138360.13474,	138364.66356,	138369.19238,	138373.72122,	138378.25008,	138382.77894,	138387.30782,	138391.83671,	138396.36561,	138400.89453,
138405.42346,	138409.95240,	138414.48136,	138419.01033,	138423.53931,	138428.06830,	138432.59731,	138437.12633,	138441.65536,	138446.18440,
138450.71346,	138455.24253,	138459.77162,	138464.30071,	138468.82982,	138473.35894,	138477.88808,	138482.41723,	138486.94639,	138491.47556,
138496.00475,	138500.53395,	138505.06316,	138509.59238,	138514.12162,	138518.65087,	138523.18014,	138527.70941,	138532.23870,	138536.76800,
138541.29732,	138545.82665,	138550.35599,	138554.88534,	138559.41471,	138563.94409,	138568.47348,	138573.00288,	138577.53230,	138582.06173,
138586.59117,	138591.12063,	138595.65010,	138600.17958,	138604.70907,	138609.23858,	138613.76810,	138618.29764,	138622.82718,	138627.35674,
138631.88631,	138636.41590,	138640.94549,	138645.47510,	138650.00473,	138654.53436,	138659.06401,	138663.59367,	138668.12335,	138672.65303,
138677.18273,	138681.71244,	138686.24217,	138690.77191,	138695.30166,	138699.83142,	138704.36120,	138708.89099,	138713.42079,	138717.95061,
138722.48043,	138727.01028,	138731.54013,	138736.07000,	138740.59988,	138745.12977,	138749.65967,	138754.18959,	138758.71952,	138763.24946,
138767.77942,	138772.30939,	138776.83937,	138781.36937,	138785.89937,	138790.42939,	138794.95943,	138799.48947,	138804.01953,	138808.54960,
138813.07969,	138817.60978,	138822.13989,	138826.67002,	138831.20015,	138835.73030,	138840.26046,	138844.79064,	138849.32082,	138853.85102,
138858.38124,	138862.91146,	138867.44170,	138871.97195,	138876.50221,	138881.03249,	138885.56278,	138890.09308,	138894.62340,	138899.15372,
138903.68407,	138908.21442,	138912.74479,	138917.27516,	138921.80556,	138926.33596,	138930.86638,	138935.39681,	138939.92725,	138944.45771,
138948.98818,	138953.51866,	138958.04915,	138962.57966,	138967.11018,	138971.64071,	138976.17126,	138980.70181,	138985.23239,	138989.76297,
138994.29357,	138998.82418,	139003.35480,	139007.88543,	139012.41608,	139016.94674,	139021.47742,	139026.00810,	139030.53880,	139035.06951,
139039.60024,	139044.13097,	139048.66172,	139053.19249,	139057.72326,	139062.25405,	139066.78485,	139071.31567,	139075.84649,	139080.37733,
139084.90819,	139089.43905,	139093.96993,	139098.50082,	139103.03173,	139107.56264,	139112.09357,	139116.62451,	139121.15547,	139125.68644,
139130.21742,	139134.74841,	139139.27942,	139143.81043,	139148.34147,	139152.87251,	139157.40357,	139161.93464,	139166.46572,	139170.99682,
139175.52792,	139180.05905,	139184.59018,	139189.12133,	139193.65249,	139198.18366,	139202.71484,	139207.24604,	139211.77725,	139216.30847,
139220.83971,	139225.37096,	139229.90222,	139234.43350,	139238.96478,	139243.49608,	139248.02740,	139252.55872,	139257.09006,	139261.62141,
139266.15277,	139270.68415,	139275.21554,	139279.74694,	139284.27836,	139288.80979,	139293.34123,	139297.87268,	139302.40415,	139306.93563,
139311.46712,	139315.99862,	139320.53014,	139325.06167,	139329.59321,	139334.12477,	139338.65634,	139343.18792,	139347.71951,	139352.25112,
139356.78274,	139361.31437,	139365.84601,	139370.37767,	139374.90934,	139379.44102,	139383.97272,	139388.50443,	139393.03615,	139397.56789,
139402.09963,	139406.63139,	139411.16316,	139415.69495,	139420.22675,	139424.75856,	139429.29038,	139433.82222,	139438.35407,	139442.88593,
139447.41781,	139451.94969,	139456.48159,	139461.01351,	139465.54543,	139470.07737,	139474.60932,	139479.14129,	139483.67326,	139488.20525,
139492.73725,	139497.26927,	139501.80130,	139506.33334,	139510.86539,	139515.39746,	139519.92954,	139524.46163,	139528.99373,	139533.52585,
139538.05798,	139542.59012,	139547.12228,	139551.65445,	139556.18663,	139560.71882,	139565.25103,	139569.78325,	139574.31548,	139578.84772,
139583.37998,	139587.91225,	139592.44453,	139596.97683,	139601.50914,	139606.04146,	139610.57379,	139615.10614,	139619.63850,	139624.17087,
139628.70325,	139633.23565,	139637.76806,	139642.30049,	139646.83292,	139651.36537,	139655.89783,	139660.43031,	139664.96279,	139669.49529,
139674.02780,	139678.56033,	139683.09287,	139687.62542,	139692.15798,	139696.69056,	139701.22315,	139705.75575,	139710.28836,	139714.82099,
139719.35363,	139723.88628,	139728.41895,	139732.95162,	139737.48431,	139742.01702,	139746.54973,	139751.08246,	139755.61520,	139760.14796,
139764.68073,	139769.21351,	139773.74630,	139778.27910,	139782.81192,	139787.34475,	139791.87760,	139796.41045,	139800.94332,	139805.47620,
139810.00910,	139814.54200,	139819.07492,	139823.60786,	139828.14080,	139832.67376,	139837.20673,	139841.73972,	139846.27271,	139850.80572,
139855.33874,	139859.87178,	139864.40482,	139868.93788,	139873.47096,	139878.00404,	139882.53714,	139887.07025,	139891.60337,	139896.13651,
139900.66966,	139905.20282,	139909.73600,	139914.26918,	139918.80238,	139923.33560,	139927.86882,	139932.40206,	139936.93531,	139941.46857,
139946.00185,	139950.53514,	139955.06844,	139959.60175,	139964.13508,	139968.66842,	139973.20177,	139977.73514,	139982.26852,	139986.80191,
139991.33531,	139995.86873,	140000.40216,	140004.93560,	140009.46905,	140014.00252,	140018.53600,	140023.06949,	140027.60300,	140032.13651,
140036.67005,	140041.20359,	140045.73714,	140050.27071,	140054.80429,	140059.33789,	140063.87150,	140068.40512,	140072.93875,	140077.47239,
140082.00605,	140086.53972,	140091.07340,	140095.60710,	140100.14081,	140104.67453,	140109.20826,	140113.74201,	140118.27577,	140122.80954,
140127.34333,	140131.87712,	140136.41093,	140140.94476,	140145.47859,	140150.01244,	140154.54630,	140159.08018,	140163.61406,	140168.14796,
140172.68187,	140177.21580,	140181.74973,	140186.28368,	140190.81765,	140195.35162,	140199.88561,	140204.41961,	140208.95362,	140213.48765,
140218.02169,	140222.55574,	140227.08980,	140231.62388,	140236.15797,	140240.69207,	140245.22619,	140249.76032,	140254.29446,	140258.82861,
140263.36278,	140267.89695,	140272.43114,	140276.96535,	140281.49957,	140286.03379,	140290.56804,	140295.10229,	140299.63656,	140304.17084,
140308.70513,	140313.23944,	140317.77375,	140322.30809,	140326.84243,	140331.37678,	140335.91115,	140340.44554,	140344.97993,	140349.51434,
140354.04876,	140358.58319,	140363.11763,	140367.65209,	140372.18656,	140376.72104,	140381.25554,	140385.79005,	140390.32457,	140394.85910,
140399.39365,	140403.92821,	140408.46278,	140412.99736,	140417.53196,	140422.06657,	140426.60119,	140431.13583,	140435.67048,	140440.20514,
140444.73981,	140449.27450,	140453.80920,	140458.34391,	140462.87863,	140467.41337,	140471.94812,	140476.48288,	140481.01765,	140485.55244,
140490.08724,	140494.62205,	140499.15688,	140503.69172,	140508.22657,	140512.76143,	140517.29631,	140521.83120,	140526.36610,	140530.90101,
140535.43594,	140539.97088,	140544.50583,	140549.04080,	140553.57577,	140558.11076,	140562.64577,	140567.18078,	140571.71581,	140576.25085,
140580.78590,	140585.32097,	140589.85605,	140594.39114,	140598.92624,	140603.46136,	140607.99649,	140612.53163,	140617.06679,	140621.60195,
140626.13714,	140630.67233,	140635.20753,	140639.74275,	140644.27798,	140648.81323,	140653.34848,	140657.88375,	140662.41903,	140666.95433,
140671.48963,	140676.02495,	140680.56028,	140685.09563,	140689.63099,	140694.16636,	140698.70174,	140703.23713,	140707.77254,	140712.30796,
140716.84340,	140721.37884,	140725.91430,	140730.44977,	140734.98526,	140739.52075,	140744.05626,	140748.59179,	140753.12732,	140757.66287,
140762.19843,	140766.73400,	140771.26958,	140775.80518,	140780.34079,	140784.87642,	140789.41205,	140793.94770,	140798.48336,	140803.01904,
140807.55472,	140812.09042,	140816.62613,	140821.16186,	140825.69759,	140830.23334,	140834.76911,	140839.30488,	140843.84067,	140848.37647,
140852.91228,	140857.44811,	140861.98395,	140866.51980,	140871.05566,	140875.59154,	140880.12743,	140884.66333,	140889.19924,	140893.73517,
140898.27111,	140902.80706,	140907.34302,	140911.87900,	140916.41499,	140920.95099,	140925.48701,	140930.02304,	140934.55908,	140939.09513,
140943.63120,	140948.16727,	140952.70337,	140957.23947,	140961.77559,	140966.31171,	140970.84786,	140975.38401,	140979.92018,	140984.45636,
140988.99255,	140993.52875,	140998.06497,	141002.60120,	141007.13744,	141011.67370,	141016.20997,	141020.74625,	141025.28254,	141029.81885,
141034.35517,	141038.89150,	141043.42784,	141047.96420,	141052.50057,	141057.03695,	141061.57334,	141066.10975,	141070.64617,	141075.18260,
141079.71905,	141084.25550,	141088.79197,	141093.32846,	141097.86495,	141102.40146,	141106.93798,	141111.47451,	141116.01106,	141120.54762,
141125.08419,	141129.62077,	141134.15737,	141138.69398,	141143.23060,	141147.76723,	141152.30388,	141156.84054,	141161.37721,	141165.91390,
141170.45059,	141174.98730,	141179.52403,	141184.06076,	141188.59751,	141193.13427,	141197.67104,	141202.20783,	141206.74463,	141211.28144,
141215.81826,	141220.35510,	141224.89195,	141229.42881,	141233.96568,	141238.50257,	141243.03947,	141247.57638,	141252.11330,	141256.65024,
141261.18719,	141265.72415,	141270.26113,	141274.79811,	141279.33511,	141283.87213,	141288.40915,	141292.94619,	141297.48324,	141302.02030,
141306.55738,	141311.09447,	141315.63157,	141320.16868,	141324.70581,	141329.24295,	141333.78010,	141338.31726,	141342.85444,	141347.39163,
141351.92883,	141356.46604,	141361.00327,	141365.54051,	141370.07776,	141374.61503,	141379.15231,	141383.68960,	141388.22690,	141392.76421,
141397.30154,	141401.83888,	141406.37624,	141410.91360,	141415.45098,	141419.98837,	141424.52577,	141429.06319,	141433.60062,	141438.13806,
141442.67551,	141447.21298,	141451.75046,	141456.28795,	141460.82545,	141465.36297,	141469.90050,	141474.43804,	141478.97560,	141483.51317,
141488.05075,	141492.58834,	141497.12594,	141501.66356,	141506.20119,	141510.73883,	141515.27649,	141519.81416,	141524.35184,	141528.88953,
141533.42724,	141537.96495,	141542.50269,	141547.04043,	141551.57819,	141556.11595,	141560.65374,	141565.19153,	141569.72934,	141574.26715,
141578.80499,	141583.34283,	141587.88069,	141592.41856,	141596.95644,	141601.49433,	141606.03224,	141610.57016,	141615.10809,	141619.64604,
141624.18400,	141628.72197,	141633.25995,	141637.79794,	141642.33595,	141646.87397,	141651.41201,	141655.95005,	141660.48811,	141665.02618,
141669.56426,	141674.10236,	141678.64047,	141683.17859,	141687.71672,	141692.25487,	141696.79303,	141701.33120,	141705.86938,	141710.40758,
141714.94579,	141719.48401,	141724.02224,	141728.56049,	141733.09875,	141737.63702,	141742.17531,	141746.71360,	141751.25191,	141755.79024,
141760.32857,	141764.86692,	141769.40528,	141773.94365,	141778.48204,	141783.02044,	141787.55885,	141792.09727,	141796.63570,	141801.17415,
141805.71261,	141810.25109,	141814.78957,	141819.32807,	141823.86658,	141828.40510,	141832.94364,	141837.48219,	141842.02075,	141846.55932,
141851.09791,	141855.63651,	141860.17512,	141864.71374,	141869.25238,	141873.79103,	141878.32969,	141882.86837,	141887.40705,	141891.94575,
141896.48446,	141901.02319,	141905.56193,	141910.10068,	141914.63944,	141919.17821,	141923.71700,	141928.25580,	141932.79461,	141937.33344,
141941.87227,	141946.41112,	141950.94999,	141955.48886,	141960.02775,	141964.56665,	141969.10556,	141973.64449,	141978.18343,	141982.72238,
141987.26134,	141991.80032,	141996.33930,	142000.87831,	142005.41732,	142009.95634,	142014.49538,	142019.03443,	142023.57350,	142028.11257,
142032.65166,	142037.19076,	142041.72988,	142046.26900,	142050.80814,	142055.34729,	142059.88646,	142064.42563,	142068.96482,	142073.50402,
142078.04324,	142082.58247,	142087.12170,	142091.66096,	142096.20022,	142100.73950,	142105.27879,	142109.81809,	142114.35740,	142118.89673,
142123.43607,	142127.97542,	142132.51479,	142137.05416,	142141.59355,	142146.13296,	142150.67237,	142155.21180,	142159.75124,	142164.29069,
142168.83016,	142173.36963,	142177.90912,	142182.44863,	142186.98814,	142191.52767,	142196.06721,	142200.60676,	142205.14633,	142209.68591,
142214.22550,	142218.76510,	142223.30471,	142227.84434,	142232.38398,	142236.92364,	142241.46330,	142246.00298,	142250.54267,	142255.08237,
142259.62209,	142264.16182,	142268.70156,	142273.24131,	142277.78108,	142282.32086,	142286.86065,	142291.40045,	142295.94027,	142300.48010,
142305.01994,	142309.55979,	142314.09966,	142318.63954,	142323.17943,	142327.71933,	142332.25925,	142336.79918,	142341.33912,	142345.87907,
142350.41904,	142354.95902,	142359.49901,	142364.03901,	142368.57903,	142373.11906,	142377.65910,	142382.19915,	142386.73922,	142391.27930,
142395.81939,	142400.35949,	142404.89961,	142409.43974,	142413.97988,	142418.52004,	142423.06020,	142427.60038,	142432.14057,	142436.68078,
142441.22099,	142445.76122,	142450.30147,	142454.84172,	142459.38199,	142463.92227,	142468.46256,	142473.00286,	142477.54318,	142482.08351,
142486.62385,	142491.16421,	142495.70457,	142500.24495,	142504.78534,	142509.32575,	142513.86617,	142518.40660,	142522.94704,	142527.48749,
142532.02796,	142536.56844,	142541.10893,	142545.64944,	142550.18995,	142554.73048,	142559.27102,	142563.81158,	142568.35215,	142572.89273,
142577.43332,	142581.97392,	142586.51454,	142591.05517,	142595.59581,	142600.13647,	142604.67713,	142609.21781,	142613.75851,	142618.29921,
142622.83993,	142627.38066,	142631.92140,	142636.46216,	142641.00292,	142645.54370,	142650.08449,	142654.62530,	142659.16612,	142663.70695,
142668.24779,	142672.78864,	142677.32951,	142681.87039,	142686.41128,	142690.95219,	142695.49311,	142700.03404,	142704.57498,	142709.11593,
142713.65690,	142718.19788,	142722.73887,	142727.27988,	142731.82089,	142736.36192,	142740.90297,	142745.44402,	142749.98509,	142754.52617,
142759.06726,	142763.60836,	142768.14948,	142772.69061,	142777.23175,	142781.77291,	142786.31408,	142790.85526,	142795.39645,	142799.93765,
142804.47887,	142809.02010,	142813.56134,	142818.10260,	142822.64386,	142827.18514,	142831.72644,	142836.26774,	142840.80906,	142845.35039,
142849.89173,	142854.43308,	142858.97445,	142863.51583,	142868.05722,	142872.59863,	142877.14004,	142881.68147,	142886.22291,	142890.76437,
142895.30584,	142899.84732,	142904.38881,	142908.93031,	142913.47183,	142918.01336,	142922.55490,	142927.09645,	142931.63802,	142936.17960,
142940.72119,	142945.26280,	142949.80441,	142954.34604,	142958.88768,	142963.42934,	142967.97100,	142972.51268,	142977.05437,	142981.59608,
142986.13779,	142990.67952,	142995.22127,	142999.76302,	143004.30479,	143008.84656,	143013.38836,	143017.93016,	143022.47198,	143027.01380,
143031.55565,	143036.09750,	143040.63937,	143045.18124,	143049.72314,	143054.26504,	143058.80696,	143063.34888,	143067.89082,	143072.43278,
143076.97474,	143081.51672,	143086.05871,	143090.60072,	143095.14273,	143099.68476,	143104.22680,	143108.76886,	143113.31092,	143117.85300,
143122.39509,	143126.93719,	143131.47931,	143136.02144,	143140.56358,	143145.10573,	143149.64789,	143154.19007,	143158.73226,	143163.27447,
143167.81668,	143172.35891,	143176.90115,	143181.44340,	143185.98567,	143190.52794,	143195.07023,	143199.61254,	143204.15485,	143208.69718,
143213.23952,	143217.78187,	143222.32424,	143226.86661,	143231.40900,	143235.95140,	143240.49382,	143245.03625,	143249.57869,	143254.12114,
143258.66360,	143263.20608,	143267.74857,	143272.29107,	143276.83358,	143281.37611,	143285.91865,	143290.46120,	143295.00377,	143299.54634,
143304.08893,	143308.63153,	143313.17415,	143317.71677,	143322.25941,	143326.80206,	143331.34473,	143335.88740,	143340.43009,	143344.97279,
143349.51551,	143354.05823,	143358.60097,	143363.14372,	143367.68648,	143372.22926,	143376.77205,	143381.31485,	143385.85766,	143390.40049,
143394.94332,	143399.48617,	143404.02904,	143408.57191,	143413.11480,	143417.65770,	143422.20061,	143426.74354,	143431.28647,	143435.82942,
143440.37239,	143444.91536,	143449.45835,	143454.00135,	143458.54436,	143463.08739,	143467.63042,	143472.17347,	143476.71653,	143481.25961,
143485.80269,	143490.34579,	143494.88890,	143499.43203,	143503.97517,	143508.51831,	143513.06148,	143517.60465,	143522.14784,	143526.69103,
143531.23424,	143535.77747,	143540.32070,	143544.86395,	143549.40721,	143553.95049,	143558.49377,	143563.03707,	143567.58038,	143572.12370,
143576.66704,	143581.21039,	143585.75375,	143590.29712,	143594.84050,	143599.38390,	143603.92731,	143608.47073,	143613.01417,	143617.55762,
143622.10108,	143626.64455,	143631.18803,	143635.73153,	143640.27504,	143644.81856,	143649.36209,	143653.90564,	143658.44920,	143662.99277,
143667.53635,	143672.07995,	143676.62356,	143681.16718,	143685.71081,	143690.25446,	143694.79812,	143699.34179,	143703.88547,	143708.42917,
143712.97288,	143717.51660,	143722.06033,	143726.60408,	143731.14783,	143735.69160,	143740.23539,	143744.77918,	143749.32299,	143753.86681,
143758.41064,	143762.95448,	143767.49834,	143772.04221,	143776.58609,	143781.12999,	143785.67389,	143790.21781,	143794.76174,	143799.30569,
143803.84964,	143808.39361,	143812.93759,	143817.48159,	143822.02559,	143826.56961,	143831.11364,	143835.65769,	143840.20174,	143844.74581,
143849.28989,	143853.83398,	143858.37809,	143862.92221,	143867.46634,	143872.01048,	143876.55463,	143881.09880,	143885.64298,	143890.18717,
143894.73138,	143899.27559,	143903.81982,	143908.36407,	143912.90832,	143917.45259,	143921.99687,	143926.54116,	143931.08546,	143935.62978,
143940.17411,	143944.71845,	143949.26280,	143953.80717,	143958.35154,	143962.89593,	143967.44034,	143971.98475,	143976.52918,	143981.07362,
143985.61807,	143990.16254,	143994.70702,	143999.25150,	144003.79601,	144008.34052,	144012.88505,	144017.42959,	144021.97414,	144026.51870,
144031.06328,	144035.60787,	144040.15247,	144044.69708,	144049.24171,	144053.78635,	144058.33100,	144062.87566,	144067.42034,	144071.96503,
144076.50973,	144081.05444,	144085.59916,	144090.14390,	144094.68865,	144099.23341,	144103.77819,	144108.32298,	144112.86778,	144117.41259,
144121.95741,	144126.50225,	144131.04710,	144135.59196,	144140.13683,	144144.68172,	144149.22662,	144153.77153,	144158.31645,	144162.86139,
144167.40634,	144171.95130,	144176.49627,	144181.04125,	144185.58625,	144190.13126,	144194.67629,	144199.22132,	144203.76637,	144208.31143,
144212.85650,	144217.40158,	144221.94668,	144226.49179,	144231.03691,	144235.58204,	144240.12719,	144244.67235,	144249.21752,	144253.76270,
144258.30790,	144262.85311,	144267.39833,	144271.94356,	144276.48881,	144281.03406,	144285.57933,	144290.12462,	144294.66991,	144299.21522,
144303.76054,	144308.30587,	144312.85121,	144317.39657,	144321.94194,	144326.48732,	144331.03271,	144335.57812,	144340.12354,	144344.66897,
144349.21441,	144353.75987,	144358.30534,	144362.85082,	144367.39631,	144371.94181,	144376.48733,	144381.03286,	144385.57840,	144390.12396,
144394.66952,	144399.21510,	144403.76070,	144408.30630,	144412.85192,	144417.39754,	144421.94319,	144426.48884,	144431.03450,	144435.58018,
144440.12587,	144444.67158,	144449.21729,	144453.76302,	144458.30876,	144462.85451,	144467.40028,	144471.94605,	144476.49184,	144481.03764,
144485.58346,	144490.12928,	144494.67512,	144499.22097,	144503.76684,	144508.31271,	144512.85860,	144517.40450,	144521.95042,	144526.49634,
144531.04228,	144535.58823,	144540.13419,	144544.68017,	144549.22615,	144553.77215,	144558.31816,	144562.86419,	144567.41023,	144571.95627,
144576.50234,	144581.04841,	144585.59450,	144590.14059,	144594.68670,	144599.23283,	144603.77896,	144608.32511,	144612.87127,	144617.41744,
144621.96363,	144626.50982,	144631.05603,	144635.60226,	144640.14849,	144644.69474,	144649.24099,	144653.78727,	144658.33355,	144662.87985,
144667.42615,	144671.97247,	144676.51881,	144681.06515,	144685.61151,	144690.15788,	144694.70426,	144699.25066,	144703.79706,	144708.34348,
144712.88991,	144717.43636,	144721.98281,	144726.52928,	144731.07576,	144735.62226,	144740.16876,	144744.71528,	144749.26181,	144753.80835,
144758.35491,	144762.90148,	144767.44806,	144771.99465,	144776.54125,	144781.08787,	144785.63450,	144790.18114,	144794.72779,	144799.27446,
144803.82114,	144808.36783,	144812.91453,	144817.46125,	144822.00797,	144826.55471,	144831.10147,	144835.64823,	144840.19501,	144844.74180,
144849.28860,	144853.83541,	144858.38224,	144862.92908,	144867.47593,	144872.02279,	144876.56967,	144881.11656,	144885.66346,	144890.21037,
144894.75729,	144899.30423,	144903.85118,	144908.39814,	144912.94512,	144917.49210,	144922.03910,	144926.58611,	144931.13314,	144935.68017,
144940.22722,	144944.77428,	144949.32136,	144953.86844,	144958.41554,	144962.96265,	144967.50977,	144972.05690,	144976.60405,	144981.15121,
144985.69838,	144990.24557,	144994.79276,	144999.33997,	145003.88719,	145008.43442,	145012.98167,	145017.52893,	145022.07620,	145026.62348,
145031.17077,	145035.71808,	145040.26540,	145044.81273,	145049.36008,	145053.90743,	145058.45480,	145063.00218,	145067.54957,	145072.09698,
145076.64440,	145081.19183,	145085.73927,	145090.28672,	145094.83419,	145099.38167,	145103.92916,	145108.47667,	145113.02418,	145117.57171,
145122.11925,	145126.66681,	145131.21437,	145135.76195,	145140.30954,	145144.85714,	145149.40476,	145153.95238,	145158.50002,	145163.04767,
145167.59534,	145172.14301,	145176.69070,	145181.23840,	145185.78612,	145190.33384,	145194.88158,	145199.42933,	145203.97709,	145208.52487,
145213.07265,	145217.62045,	145222.16827,	145226.71609,	145231.26393,	145235.81177,	145240.35963,	145244.90751,	145249.45539,	145254.00329,
145258.55120,	145263.09912,	145267.64706,	145272.19500,	145276.74296,	145281.29094,	145285.83892,	145290.38692,	145294.93492,	145299.48294,
145304.03098,	145308.57902,	145313.12708,	145317.67515,	145322.22323,	145326.77133,	145331.31943,	145335.86755,	145340.41568,	145344.96383,
145349.51198,	145354.06015,	145358.60833,	145363.15653,	145367.70473,	145372.25295,	145376.80118,	145381.34942,	145385.89767,	145390.44594,
145394.99422,	145399.54251,	145404.09081,	145408.63913,	145413.18746,	145417.73580,	145422.28415,	145426.83251,	145431.38089,	145435.92928,
145440.47768,	145445.02610,	145449.57452,	145454.12296,	145458.67141,	145463.21988,	145467.76835,	145472.31684,	145476.86534,	145481.41385,
145485.96238,	145490.51091,	145495.05946,	145499.60802,	145504.15660,	145508.70518,	145513.25378,	145517.80239,	145522.35101,	145526.89965,
145531.44830,	145535.99696,	145540.54563,	145545.09431,	145549.64301,	145554.19172,	145558.74044,	145563.28917,	145567.83792,	145572.38668,
145576.93545,	145581.48423,	145586.03302,	145590.58183,	145595.13065,	145599.67948,	145604.22832,	145608.77718,	145613.32605,	145617.87493,
145622.42382,	145626.97273,	145631.52164,	145636.07057,	145640.61952,	145645.16847,	145649.71744,	145654.26641,	145658.81541,	145663.36441,
145667.91342,	145672.46245,	145677.01149,	145681.56054,	145686.10961,	145690.65869,	145695.20778,	145699.75688,	145704.30599,	145708.85512,
145713.40425,	145717.95340,	145722.50257,	145727.05174,	145731.60093,	145736.15013,	145740.69934,	145745.24857,	145749.79780,	145754.34705,
145758.89631,	145763.44558,	145767.99487,	145772.54417,	145777.09348,	145781.64280,	145786.19213,	145790.74148,	145795.29084,	145799.84021,
145804.38959,	145808.93899,	145813.48840,	145818.03782,	145822.58725,	145827.13669,	145831.68615,	145836.23562,	145840.78510,	145845.33460,
145849.88410,	145854.43362,	145858.98315,	145863.53269,	145868.08225,	145872.63182,	145877.18139,	145881.73099,	145886.28059,	145890.83021,
145895.37984,	145899.92948,	145904.47913,	145909.02879,	145913.57847,	145918.12816,	145922.67786,	145927.22758,	145931.77730,	145936.32704,
145940.87679,	145945.42656,	145949.97633,	145954.52612,	145959.07592,	145963.62573,	145968.17556,	145972.72539,	145977.27524,	145981.82510,
145986.37498,	145990.92486,	145995.47476,	146000.02467,	146004.57459,	146009.12453,	146013.67447,	146018.22443,	146022.77441,	146027.32439,
146031.87438,	146036.42439,	146040.97441,	146045.52445,	146050.07449,	146054.62455,	146059.17462,	146063.72470,	146068.27479,	146072.82490,
146077.37502,	146081.92515,	146086.47529,	146091.02544,	146095.57561,	146100.12579,	146104.67598,	146109.22619,	146113.77640,	146118.32663,
146122.87687,	146127.42712,	146131.97739,	146136.52767,	146141.07796,	146145.62826,	146150.17857,	146154.72890,	146159.27924,	146163.82959,
146168.37995,	146172.93033,	146177.48071,	146182.03111,	146186.58152,	146191.13195,	146195.68238,	146200.23283,	146204.78329,	146209.33377,
146213.88425,	146218.43475,	146222.98526,	146227.53578,	146232.08631,	146236.63686,	146241.18742,	146245.73799,	146250.28857,	146254.83917,
146259.38978,	146263.94040,	146268.49103,	146273.04167,	146277.59233,	146282.14300,	146286.69368,	146291.24437,	146295.79508,	146300.34579,
146304.89652,	146309.44726,	146313.99802,	146318.54878,	146323.09956,	146327.65035,	146332.20116,	146336.75197,	146341.30280,	146345.85364,
146350.40449,	146354.95536,	146359.50623,	146364.05712,	146368.60802,	146373.15893,	146377.70986,	146382.26080,	146386.81175,	146391.36271,
146395.91368,	146400.46467,	146405.01567,	146409.56668,	146414.11770,	146418.66873,	146423.21978,	146427.77084,	146432.32191,	146436.87300,
146441.42409,	146445.97520,	146450.52632,	146455.07745,	146459.62860,	146464.17976,	146468.73093,	146473.28211,	146477.83330,	146482.38451,
146486.93572,	146491.48695,	146496.03820,	146500.58945,	146505.14072,	146509.69200,	146514.24329,	146518.79459,	146523.34591,	146527.89724,
146532.44858,	146536.99993,	146541.55129,	146546.10267,	146550.65406,	146555.20546,	146559.75687,	146564.30830,	146568.85974,	146573.41119,
146577.96265,	146582.51412,	146587.06561,	146591.61711,	146596.16862,	146600.72014,	146605.27168,	146609.82323,	146614.37479,	146618.92636,
146623.47794,	146628.02954,	146632.58115,	146637.13277,	146641.68440,	146646.23605,	146650.78770,	146655.33937,	146659.89106,	146664.44275,
146668.99446,	146673.54617,	146678.09790,	146682.64965,	146687.20140,	146691.75317,	146696.30495,	146700.85674,	146705.40854,	146709.96036,
146714.51219,	146719.06403,	146723.61588,	146728.16774,	146732.71962,	146737.27151,	146741.82341,	146746.37532,	146750.92725,	146755.47919,
146760.03114,	146764.58310,	146769.13507,	146773.68706,	146778.23906,	146782.79107,	146787.34309,	146791.89513,	146796.44718,	146800.99923,
146805.55131,	146810.10339,	146814.65549,	146819.20759,	146823.75972,	146828.31185,	146832.86399,	146837.41615,	146841.96832,	146846.52050,
146851.07269,	146855.62490,	146860.17712,	146864.72935,	146869.28159,	146873.83384,	146878.38611,	146882.93839,	146887.49068,	146892.04298,
146896.59530,	146901.14763,	146905.69997,	146910.25232,	146914.80468,	146919.35706,	146923.90945,	146928.46185,	146933.01426,	146937.56668,
146942.11912,	146946.67157,	146951.22403,	146955.77650,	146960.32899,	146964.88149,	146969.43400,	146973.98652,	146978.53906,	146983.09160,
146987.64416,	146992.19673,	146996.74931,	147001.30191,	147005.85452,	147010.40714,	147014.95977,	147019.51241,	147024.06507,	147028.61774,
147033.17042,	147037.72311,	147042.27581,	147046.82853,	147051.38126,	147055.93400,	147060.48675,	147065.03952,	147069.59230,	147074.14509,
147078.69789,	147083.25070,	147087.80353,	147092.35637,	147096.90922,	147101.46208,	147106.01496,	147110.56784,	147115.12074,	147119.67365,
147124.22658,	147128.77951,	147133.33246,	147137.88542,	147142.43839,	147146.99138,	147151.54438,	147156.09738,	147160.65040,	147165.20344,
147169.75648,	147174.30954,	147178.86261,	147183.41569,	147187.96879,	147192.52189,	147197.07501,	147201.62814,	147206.18128,	147210.73444,
147215.28760,	147219.84078,	147224.39397,	147228.94718,	147233.50039,	147238.05362,	147242.60686,	147247.16011,	147251.71337,	147256.26665,
147260.81994,	147265.37324,	147269.92655,	147274.47988,	147279.03321,	147283.58656,	147288.13992,	147292.69330,	147297.24668,	147301.80008,
147306.35349,	147310.90691,	147315.46034,	147320.01379,	147324.56725,	147329.12072,	147333.67420,	147338.22770,	147342.78120,	147347.33472,
147351.88825,	147356.44180,	147360.99535,	147365.54892,	147370.10250,	147374.65609,	147379.20969,	147383.76331,	147388.31694,	147392.87058,
147397.42423,	147401.97790,	147406.53157,	147411.08526,	147415.63896,	147420.19268,	147424.74640,	147429.30014,	147433.85389,	147438.40765,
147442.96142,	147447.51521,	147452.06901,	147456.62282,	147461.17664,	147465.73047,	147470.28432,	147474.83818,	147479.39205,	147483.94593,
147488.49983,	147493.05374,	147497.60766,	147502.16159,	147506.71553,	147511.26949,	147515.82346,	147520.37744,	147524.93143,	147529.48543,
147534.03945,	147538.59348,	147543.14752,	147547.70157,	147552.25564,	147556.80971,	147561.36380,	147565.91790,	147570.47202,	147575.02614,
147579.58028,	147584.13443,	147588.68859,	147593.24277,	147597.79695,	147602.35115,	147606.90536,	147611.45958,	147616.01382,	147620.56806,
147625.12232,	147629.67659,	147634.23088,	147638.78517,	147643.33948,	147647.89380,	147652.44813,	147657.00248,	147661.55683,	147666.11120,
147670.66558,	147675.21997,	147679.77438,	147684.32879,	147688.88322,	147693.43766,	147697.99211,	147702.54658,	147707.10106,	147711.65555,
147716.21005,	147720.76456,	147725.31909,	147729.87362,	147734.42817,	147738.98273,	147743.53731,	147748.09189,	147752.64649,	147757.20110,
147761.75573,	147766.31036,	147770.86501,	147775.41967,	147779.97434,	147784.52902,	147789.08371,	147793.63842,	147798.19314,	147802.74787,
147807.30262,	147811.85737,	147816.41214,	147820.96692,	147825.52171,	147830.07651,	147834.63133,	147839.18616,	147843.74100,	147848.29585,
147852.85072,	147857.40559,	147861.96048,	147866.51538,	147871.07030,	147875.62522,	147880.18016,	147884.73511,	147889.29007,	147893.84504,
147898.40003,	147902.95502,	147907.51003,	147912.06506,	147916.62009,	147921.17514,	147925.73019,	147930.28527,	147934.84035,	147939.39544,
147943.95055,	147948.50567,	147953.06080,	147957.61594,	147962.17110,	147966.72626,	147971.28144,	147975.83663,	147980.39184,	147984.94705,
147989.50228,	147994.05752,	147998.61277,	148003.16803,	148007.72331,	148012.27860,	148016.83390,	148021.38921,	148025.94453,	148030.49987,
148035.05522,	148039.61058,	148044.16595,	148048.72134,	148053.27673,	148057.83214,	148062.38756,	148066.94300,	148071.49844,	148076.05390,
148080.60937,	148085.16485,	148089.72034,	148094.27585,	148098.83137,	148103.38690,	148107.94244,	148112.49799,	148117.05356,	148121.60914,
148126.16473,	148130.72033,	148135.27594,	148139.83157,	148144.38721,	148148.94286,	148153.49852,	148158.05420,	148162.60988,	148167.16558,
148171.72129,	148176.27702,	148180.83275,	148185.38850,	148189.94426,	148194.50003,	148199.05581,	148203.61161,	148208.16741,	148212.72323,
148217.27907,	148221.83491,	148226.39077,	148230.94663,	148235.50251,	148240.05841,	148244.61431,	148249.17023,	148253.72615,	148258.28210,
148262.83805,	148267.39401,	148271.94999,	148276.50598,	148281.06198,	148285.61799,	148290.17402,	148294.73005,	148299.28610,	148303.84216,
148308.39824,	148312.95432,	148317.51042,	148322.06653,	148326.62265,	148331.17878,	148335.73493,	148340.29109,	148344.84726,	148349.40344,
148353.95963,	148358.51584,	148363.07206,	148367.62829,	148372.18453,	148376.74078,	148381.29705,	148385.85333,	148390.40962,	148394.96592,
148399.52224,	148404.07856,	148408.63490,	148413.19125,	148417.74761,	148422.30399,	148426.86038,	148431.41678,	148435.97319,	148440.52961,
148445.08604,	148449.64249,	148454.19895,	148458.75542,	148463.31191,	148467.86840,	148472.42491,	148476.98143,	148481.53796,	148486.09450,
148490.65106,	148495.20763,	148499.76421,	148504.32080,	148508.87740,	148513.43402,	148517.99065,	148522.54729,	148527.10394,	148531.66060,
148536.21728,	148540.77397,	148545.33067,	148549.88738,	148554.44411,	148559.00084,	148563.55759,	148568.11435,	148572.67113,	148577.22791,
148581.78471,	148586.34152,	148590.89834,	148595.45517,	148600.01201,	148604.56887,	148609.12574,	148613.68262,	148618.23952,	148622.79642,
148627.35334,	148631.91027,	148636.46721,	148641.02416,	148645.58113,	148650.13810,	148654.69509,	148659.25210,	148663.80911,	148668.36614,
148672.92317,	148677.48022,	148682.03729,	148686.59436,	148691.15144,	148695.70854,	148700.26565,	148704.82277,	148709.37991,	148713.93706,
148718.49421,	148723.05138,	148727.60857,	148732.16576,	148736.72297,	148741.28018,	148745.83742,	148750.39466,	148754.95191,	148759.50918,
148764.06646,	148768.62375,	148773.18105,	148777.73837,	148782.29569,	148786.85303,	148791.41038,	148795.96774,	148800.52512,	148805.08251,
148809.63990,	148814.19732,	148818.75474,	148823.31217,	148827.86962,	148832.42708,	148836.98455,	148841.54203,	148846.09953,	148850.65704,
148855.21456,	148859.77209,	148864.32963,	148868.88719,	148873.44475,	148878.00233,	148882.55992,	148887.11753,	148891.67514,	148896.23277,
148900.79041,	148905.34806,	148909.90572,	148914.46340,	148919.02109,	148923.57879,	148928.13650,	148932.69422,	148937.25196,	148941.80971,
148946.36747,	148950.92524,	148955.48302,	148960.04082,	148964.59863,	148969.15645,	148973.71428,	148978.27212,	148982.82998,	148987.38785,
148991.94573,	148996.50362,	149001.06152,	149005.61944,	149010.17737,	149014.73531,	149019.29326,	149023.85122,	149028.40920,	149032.96719,
149037.52519,	149042.08320,	149046.64122,	149051.19926,	149055.75731,	149060.31537,	149064.87344,	149069.43152,	149073.98962,	149078.54773,
149083.10585,	149087.66398,	149092.22213,	149096.78028,	149101.33845,	149105.89663,	149110.45482,	149115.01303,	149119.57124,	149124.12947,
149128.68771,	149133.24596,	149137.80423,	149142.36251,	149146.92079,	149151.47909,	149156.03741,	149160.59573,	149165.15407,	149169.71242,
149174.27078,	149178.82915,	149183.38753,	149187.94593,	149192.50434,	149197.06276,	149201.62119,	149206.17964,	149210.73809,	149215.29656,
149219.85504,	149224.41354,	149228.97204,	149233.53056,	149238.08908,	149242.64763,	149247.20618,	149251.76474,	149256.32332,	149260.88191,
149265.44051,	149269.99912,	149274.55775,	149279.11638,	149283.67503,	149288.23369,	149292.79236,	149297.35105,	149301.90975,	149306.46845,
149311.02717,	149315.58591,	149320.14465,	149324.70341,	149329.26218,	149333.82096,	149338.37975,	149342.93855,	149347.49737,	149352.05620,
149356.61504,	149361.17389,	149365.73276,	149370.29163,	149374.85052,	149379.40942,	149383.96833,	149388.52726,	149393.08620,	149397.64514,
149402.20410,	149406.76308,	149411.32206,	149415.88106,	149420.44007,	149424.99909,	149429.55812,	149434.11716,	149438.67622,	149443.23529,
149447.79437,	149452.35346,	149456.91256,	149461.47168,	149466.03081,	149470.58995,	149475.14910,	149479.70827,	149484.26744,	149488.82663,
149493.38583,	149497.94504,	149502.50427,	149507.06350,	149511.62275,	149516.18201,	149520.74128,	149525.30057,	149529.85986,	149534.41917,
149538.97849,	149543.53782,	149548.09717,	149552.65652,	149557.21589,	149561.77527,	149566.33466,	149570.89407,	149575.45348,	149580.01291,
149584.57235,	149589.13180,	149593.69127,	149598.25074,	149602.81023,	149607.36973,	149611.92924,	149616.48876,	149621.04830,	149625.60785,
149630.16741,	149634.72698,	149639.28656,	149643.84616,	149648.40576,	149652.96538,	149657.52502,	149662.08466,	149666.64431,	149671.20398,
149675.76366,	149680.32335,	149684.88305,	149689.44277,	149694.00250,	149698.56224,	149703.12199,	149707.68175,	149712.24153,	149716.80131,
149721.36111,	149725.92092,	149730.48074,	149735.04058,	149739.60043,	149744.16029,	149748.72016,	149753.28004,	149757.83993,	149762.39984,
149766.95976,	149771.51969,	149776.07963,	149780.63959,	149785.19955,	149789.75953,	149794.31952,	149798.87952,	149803.43954,	149807.99956,
149812.55960,	149817.11965,	149821.67971,	149826.23979,	149830.79987,	149835.35997,	149839.92008,	149844.48020,	149849.04034,	149853.60048,
149858.16064,	149862.72081,	149867.28099,	149871.84119,	149876.40139,	149880.96161,	149885.52184,	149890.08208,	149894.64234,	149899.20260,
149903.76288,	149908.32317,	149912.88347,	149917.44378,	149922.00411,	149926.56444,	149931.12479,	149935.68515,	149940.24553,	149944.80591,
149949.36631,	149953.92672,	149958.48714,	149963.04757,	149967.60802,	149972.16847,	149976.72894,	149981.28942,	149985.84991,	149990.41042,
149994.97093,	149999.53146,	150004.09200,	150008.65256,	150013.21312,	150017.77370,	150022.33428,	150026.89488,	150031.45550,	150036.01612,
150040.57676,	150045.13740,	150049.69806,	150054.25873,	150058.81942,	150063.38011,	150067.94082,	150072.50154,	150077.06227,	150081.62302,
150086.18377,	150090.74454,	150095.30532,	150099.86611,	150104.42691,	150108.98773,	150113.54855,	150118.10939,	150122.67024,	150127.23110,
150131.79198,	150136.35287,	150140.91376,	150145.47467,	150150.03560,	150154.59653,	150159.15748,	150163.71844,	150168.27941,	150172.84039,
150177.40138,	150181.96239,	150186.52341,	150191.08444,	150195.64548,	150200.20653,	150204.76760,	150209.32867,	150213.88976,	150218.45087,
150223.01198,	150227.57310,	150232.13424,	150236.69539,	150241.25655,	150245.81772,	150250.37891,	150254.94011,	150259.50131,	150264.06254,
150268.62377,	150273.18501,	150277.74627,	150282.30754,	150286.86882,	150291.43011,	150295.99141,	150300.55273,	150305.11406,	150309.67540,
150314.23675,	150318.79811,	150323.35949,	150327.92088,	150332.48228,	150337.04369,	150341.60511,	150346.16655,	150350.72799,	150355.28945,
150359.85092,	150364.41241,	150368.97390,	150373.53541,	150378.09693,	150382.65846,	150387.22000,	150391.78156,	150396.34312,	150400.90470,
150405.46629,	150410.02789,	150414.58951,	150419.15113,	150423.71277,	150428.27442,	150432.83608,	150437.39776,	150441.95944,	150446.52114,
150451.08285,	150455.64457,	150460.20630,	150464.76805,	150469.32981,	150473.89157,	150478.45336,	150483.01515,	150487.57695,	150492.13877,
150496.70060,	150501.26244,	150505.82429,	150510.38616,	150514.94803,	150519.50992,	150524.07182,	150528.63373,	150533.19566,	150537.75759,
150542.31954,	150546.88150,	150551.44347,	150556.00545,	150560.56745,	150565.12946,	150569.69148,	150574.25351,	150578.81555,	150583.37760,
150587.93967,	150592.50175,	150597.06384,	150601.62594,	150606.18806,	150610.75018,	150615.31232,	150619.87447,	150624.43663,	150628.99881,
150633.56099,	150638.12319,	150642.68540,	150647.24762,	150651.80986,	150656.37210,	150660.93436,	150665.49663,	150670.05891,	150674.62120,
150679.18351,	150683.74582,	150688.30815,	150692.87049,	150697.43284,	150701.99521,	150706.55758,	150711.11997,	150715.68237,	150720.24478,
150724.80721,	150729.36964,	150733.93209,	150738.49455,	150743.05702,	150747.61950,	150752.18200,	150756.74451,	150761.30703,	150765.86956,
150770.43210,	150774.99465,	150779.55722,	150784.11980,	150788.68239,	150793.24499,	150797.80760,	150802.37023,	150806.93287,	150811.49552,
150816.05818,	150820.62085,	150825.18354,	150829.74624,	150834.30894,	150838.87167,	150843.43440,	150847.99714,	150852.55990,	150857.12267,
150861.68545,	150866.24824,	150870.81105,	150875.37386,	150879.93669,	150884.49953,	150889.06238,	150893.62524,	150898.18812,	150902.75101,
150907.31391,	150911.87682,	150916.43974,	150921.00268,	150925.56562,	150930.12858,	150934.69155,	150939.25453,	150943.81753,	150948.38053,
150952.94355,	150957.50658,	150962.06962,	150966.63268,	150971.19574,	150975.75882,	150980.32191,	150984.88501,	150989.44812,	150994.01125,
150998.57439,	151003.13754,	151007.70070,	151012.26387,	151016.82705,	151021.39025,	151025.95346,	151030.51668,	151035.07991,	151039.64315,
151044.20641,	151048.76968,	151053.33295,	151057.89625,	151062.45955,	151067.02286,	151071.58619,	151076.14953,	151080.71288,	151085.27624,
151089.83962,	151094.40300,	151098.96640,	151103.52981,	151108.09323,	151112.65667,	151117.22011,	151121.78357,	151126.34704,	151130.91052,
151135.47401,	151140.03752,	151144.60103,	151149.16456,	151153.72810,	151158.29165,	151162.85522,	151167.41880,	151171.98238,	151176.54598,
151181.10959,	151185.67322,	151190.23685,	151194.80050,	151199.36416,	151203.92783,	151208.49151,	151213.05521,	151217.61891,	151222.18263,
151226.74636,	151231.31010,	151235.87386,	151240.43762,	151245.00140,	151249.56519,	151254.12899,	151258.69281,	151263.25663,	151267.82047,
151272.38432,	151276.94818,	151281.51205,	151286.07593,	151290.63983,	151295.20374,	151299.76766,	151304.33159,	151308.89553,	151313.45949,
151318.02346,	151322.58744,	151327.15143,	151331.71543,	151336.27944,	151340.84347,	151345.40751,	151349.97156,	151354.53562,	151359.09970,
151363.66378,	151368.22788,	151372.79199,	151377.35611,	151381.92024,	151386.48439,	151391.04855,	151395.61271,	151400.17689,	151404.74109,
151409.30529,	151413.86951,	151418.43374,	151422.99798,	151427.56223,	151432.12649,	151436.69077,	151441.25505,	151445.81935,	151450.38366,
151454.94799,	151459.51232,	151464.07667,	151468.64103,	151473.20540,	151477.76978,	151482.33417,	151486.89858,	151491.46299,	151496.02742,
151500.59186,	151505.15632,	151509.72078,	151514.28526,	151518.84975,	151523.41425,	151527.97876,	151532.54328,	151537.10782,	151541.67237,
151546.23693,	151550.80150,	151555.36608,	151559.93068,	151564.49528,	151569.05990,	151573.62453,	151578.18918,	151582.75383,	151587.31850,
151591.88317,	151596.44786,	151601.01257,	151605.57728,	151610.14200,	151614.70674,	151619.27149,	151623.83625,	151628.40102,	151632.96581,
151637.53060,	151642.09541,	151646.66023,	151651.22506,	151655.78991,	151660.35476,	151664.91963,	151669.48451,	151674.04940,	151678.61430,
151683.17922,	151687.74414,	151692.30908,	151696.87403,	151701.43899,	151706.00397,	151710.56895,	151715.13395,	151719.69896,	151724.26398,
151728.82901,	151733.39406,	151737.95911,	151742.52418,	151747.08926,	151751.65435,	151756.21946,	151760.78457,	151765.34970,	151769.91484,
151774.47999,	151779.04515,	151783.61033,	151788.17551,	151792.74071,	151797.30592,	151801.87114,	151806.43638,	151811.00162,	151815.56688,
151820.13215,	151824.69743,	151829.26272,	151833.82803,	151838.39334,	151842.95867,	151847.52401,	151852.08936,	151856.65473,	151861.22010,
151865.78549,	151870.35089,	151874.91630,	151879.48172,	151884.04716,	151888.61260,	151893.17806,	151897.74353,	151902.30901,	151906.87451,
151911.44001,	151916.00553,	151920.57106,	151925.13660,	151929.70215,	151934.26772,	151938.83329,	151943.39888,	151947.96448,	151952.53009,
151957.09572,	151961.66135,	151966.22700,	151970.79266,	151975.35833,	151979.92401,	151984.48971,	151989.05541,	151993.62113,	151998.18686,
152002.75260,	152007.31836,	152011.88412,	152016.44990,	152021.01569,	152025.58149,	152030.14730,	152034.71312,	152039.27896,	152043.84481,
152048.41067,	152052.97654,	152057.54242,	152062.10832,	152066.67422,	152071.24014,	152075.80607,	152080.37202,	152084.93797,	152089.50394,
152094.06991,	152098.63590,	152103.20190,	152107.76792,	152112.33394,	152116.89998,	152121.46603,	152126.03209,	152130.59816,	152135.16424,
152139.73034,	152144.29645,	152148.86256,	152153.42870,	152157.99484,	152162.56099,	152167.12716,	152171.69334,	152176.25953,	152180.82573,
152185.39194,	152189.95817,	152194.52440,	152199.09065,	152203.65691,	152208.22319,	152212.78947,	152217.35577,	152221.92207,	152226.48839,
152231.05473,	152235.62107,	152240.18742,	152244.75379,	152249.32017,	152253.88656,	152258.45296,	152263.01938,	152267.58580,	152272.15224,
152276.71869,	152281.28515,	152285.85162,	152290.41811,	152294.98460,	152299.55111,	152304.11763,	152308.68416,	152313.25071,	152317.81726,
152322.38383,	152326.95041,	152331.51700,	152336.08360,	152340.65022,	152345.21684,	152349.78348,	152354.35013,	152358.91679,	152363.48346,
152368.05015,	152372.61684,	152377.18355,	152381.75027,	152386.31701,	152390.88375,	152395.45051,	152400.01727,	152404.58405,	152409.15084,
152413.71765,	152418.28446,	152422.85129,	152427.41812,	152431.98497,	152436.55184,	152441.11871,	152445.68559,	152450.25249,	152454.81940,
152459.38632,	152463.95325,	152468.52020,	152473.08715,	152477.65412,	152482.22110,	152486.78809,	152491.35509,	152495.92211,	152500.48913,
152505.05617,	152509.62322,	152514.19028,	152518.75736,	152523.32444,	152527.89154,	152532.45865,	152537.02577,	152541.59290,	152546.16004,
152550.72720,	152555.29437,	152559.86155,	152564.42874,	152568.99594,	152573.56316,	152578.13038,	152582.69762,	152587.26487,	152591.83213,
152596.39941,	152600.96669,	152605.53399,	152610.10130,	152614.66862,	152619.23595,	152623.80329,	152628.37065,	152632.93802,	152637.50540,
152642.07279,	152646.64019,	152651.20760,	152655.77503,	152660.34247,	152664.90992,	152669.47738,	152674.04485,	152678.61234,	152683.17984,
152687.74734,	152692.31486,	152696.88240,	152701.44994,	152706.01750,	152710.58506,	152715.15264,	152719.72023,	152724.28784,	152728.85545,
152733.42308,	152737.99071,	152742.55836,	152747.12603,	152751.69370,	152756.26138,	152760.82908,	152765.39679,	152769.96451,	152774.53224,
152779.09999,	152783.66774,	152788.23551,	152792.80329,	152797.37108,	152801.93888,	152806.50669,	152811.07452,	152815.64236,	152820.21021,
152824.77807,	152829.34594,	152833.91383,	152838.48172,	152843.04963,	152847.61755,	152852.18548,	152856.75343,	152861.32138,	152865.88935,
152870.45733,	152875.02532,	152879.59332,	152884.16133,	152888.72936,	152893.29740,	152897.86545,	152902.43351,	152907.00158,	152911.56966,
152916.13776,	152920.70587,	152925.27399,	152929.84212,	152934.41026,	152938.97842,	152943.54658,	152948.11476,	152952.68295,	152957.25115,
152961.81937,	152966.38759,	152970.95583,	152975.52408,	152980.09234,	152984.66061,	152989.22889,	152993.79719,	152998.36550,	153002.93381,
153007.50215,	153012.07049,	153016.63884,	153021.20721,	153025.77559,	153030.34398,	153034.91238,	153039.48079,	153044.04921,	153048.61765,
153053.18610,	153057.75456,	153062.32303,	153066.89151,	153071.46001,	153076.02852,	153080.59703,	153085.16556,	153089.73411,	153094.30266,
153098.87123,	153103.43980,	153108.00839,	153112.57699,	153117.14560,	153121.71423,	153126.28286,	153130.85151,	153135.42017,	153139.98884,
153144.55752,	153149.12622,	153153.69493,	153158.26364,	153162.83237,	153167.40111,	153171.96987,	153176.53863,	153181.10741,	153185.67620,
153190.24500,	153194.81381,	153199.38263,	153203.95147,	153208.52031,	153213.08917,	153217.65804,	153222.22692,	153226.79582,	153231.36472,
153235.93364,	153240.50257,	153245.07151,	153249.64046,	153254.20943,	153258.77840,	153263.34739,	153267.91639,	153272.48540,	153277.05442,
153281.62346,	153286.19250,	153290.76156,	153295.33063,	153299.89971,	153304.46880,	153309.03791,	153313.60702,	153318.17615,	153322.74529,
153327.31444,	153331.88361,	153336.45278,	153341.02197,	153345.59117,	153350.16038,	153354.72960,	153359.29883,	153363.86808,	153368.43733,
153373.00660,	153377.57588,	153382.14517,	153386.71448,	153391.28379,	153395.85312,	153400.42246,	153404.99181,	153409.56117,	153414.13055,
153418.69993,	153423.26933,	153427.83874,	153432.40816,	153436.97759,	153441.54704,	153446.11649,	153450.68596,	153455.25544,	153459.82493,
153464.39443,	153468.96395,	153473.53347,	153478.10301,	153482.67256,	153487.24212,	153491.81169,	153496.38128,	153500.95087,	153505.52048,
153510.09010,	153514.65973,	153519.22938,	153523.79903,	153528.36870,	153532.93838,	153537.50807,	153542.07777,	153546.64748,	153551.21721,
153555.78694,	153560.35669,	153564.92645,	153569.49622,	153574.06601,	153578.63580,	153583.20561,	153587.77543,	153592.34526,	153596.91510,
153601.48495,	153606.05482,	153610.62469,	153615.19458,	153619.76448,	153624.33439,	153628.90432,	153633.47425,	153638.04420,	153642.61416,
153647.18413,	153651.75411,	153656.32411,	153660.89411,	153665.46413,	153670.03416,	153674.60420,	153679.17425,	153683.74432,	153688.31439,
153692.88448,	153697.45458,	153702.02469,	153706.59481,	153711.16494,	153715.73509,	153720.30525,	153724.87542,	153729.44560,	153734.01579,
153738.58600,	153743.15621,	153747.72644,	153752.29668,	153756.86693,	153761.43719,	153766.00747,	153770.57775,	153775.14805,	153779.71836,
153784.28868,	153788.85901,	153793.42936,	153797.99971,	153802.57008,	153807.14046,	153811.71085,	153816.28125,	153820.85167,	153825.42210,
153829.99253,	153834.56298,	153839.13344,	153843.70392,	153848.27440,	153852.84490,	153857.41541,	153861.98592,	153866.55646,	153871.12700,
153875.69755,	153880.26812,	153884.83870,	153889.40929,	153893.97989,	153898.55050,	153903.12113,	153907.69176,	153912.26241,	153916.83307,
153921.40374,	153925.97442,	153930.54512,	153935.11583,	153939.68654,	153944.25727,	153948.82802,	153953.39877,	153957.96953,	153962.54031,
153967.11110,	153971.68190,	153976.25271,	153980.82353,	153985.39437,	153989.96521,	153994.53607,	153999.10694,	154003.67782,	154008.24871,
154012.81962,	154017.39054,	154021.96146,	154026.53240,	154031.10335,	154035.67432,	154040.24529,	154044.81628,	154049.38728,	154053.95829,
154058.52931,	154063.10034,	154067.67139,	154072.24244,	154076.81351,	154081.38459,	154085.95568,	154090.52678,	154095.09790,	154099.66902,
154104.24016,	154108.81131,	154113.38247,	154117.95365,	154122.52483,	154127.09603,	154131.66723,	154136.23845,	154140.80969,	154145.38093,
154149.95218,	154154.52345,	154159.09473,	154163.66602,	154168.23732,	154172.80863,	154177.37995,	154181.95129,	154186.52264,	154191.09400,
154195.66537,	154200.23675,	154204.80815,	154209.37955,	154213.95097,	154218.52240,	154223.09384,	154227.66529,	154232.23676,	154236.80823,
154241.37972,	154245.95122,	154250.52273,	154255.09425,	154259.66579,	154264.23733,	154268.80889,	154273.38046,	154277.95204,	154282.52363,
154287.09524,	154291.66685,	154296.23848,	154300.81012,	154305.38177,	154309.95343,	154314.52511,	154319.09679,	154323.66849,	154328.24020,
154332.81192,	154337.38365,	154341.95539,	154346.52715,	154351.09892,	154355.67069,	154360.24248,	154364.81429,	154369.38610,	154373.95793,
154378.52976,	154383.10161,	154387.67347,	154392.24534,	154396.81723,	154401.38912,	154405.96103,	154410.53295,	154415.10488,	154419.67682,
154424.24877,	154428.82074,	154433.39271,	154437.96470,	154442.53670,	154447.10871,	154451.68074,	154456.25277,	154460.82482,	154465.39687,
154469.96894,	154474.54103,	154479.11312,	154483.68522,	154488.25734,	154492.82947,	154497.40161,	154501.97376,	154506.54592,	154511.11809,
154515.69028,	154520.26248,	154524.83469,	154529.40691,	154533.97914,	154538.55138,	154543.12364,	154547.69591,	154552.26819,	154556.84048,
154561.41278,	154565.98509,	154570.55742,	154575.12976,	154579.70210,	154584.27446,	154588.84684,	154593.41922,	154597.99162,	154602.56402,
154607.13644,	154611.70887,	154616.28131,	154620.85377,	154625.42623,	154629.99871,	154634.57120,	154639.14370,	154643.71621,	154648.28873,
154652.86127,	154657.43381,	154662.00637,	154666.57894,	154671.15152,	154675.72411,	154680.29672,	154684.86933,	154689.44196,	154694.01460,
154698.58725,	154703.15991,	154707.73259,	154712.30527,	154716.87797,	154721.45068,	154726.02340,	154730.59613,	154735.16888,	154739.74163,
154744.31440,	154748.88718,	154753.45997,	154758.03277,	154762.60558,	154767.17841,	154771.75125,	154776.32409,	154780.89695,	154785.46983,
154790.04271,	154794.61560,	154799.18851,	154803.76143,	154808.33436,	154812.90730,	154817.48025,	154822.05322,	154826.62619,	154831.19918,
154835.77218,	154840.34519,	154844.91821,	154849.49125,	154854.06429,	154858.63735,	154863.21042,	154867.78350,	154872.35659,	154876.92970,
154881.50281,	154886.07594,	154890.64908,	154895.22223,	154899.79539,	154904.36856,	154908.94175,	154913.51494,	154918.08815,	154922.66137,
154927.23460,	154931.80785,	154936.38110,	154940.95437,	154945.52765,	154950.10093,	154954.67424,	154959.24755,	154963.82087,	154968.39421,
154972.96756,	154977.54091,	154982.11429,	154986.68767,	154991.26106,	154995.83447,	155000.40788,	155004.98131,	155009.55475,	155014.12820,
155018.70167,	155023.27514,	155027.84863,	155032.42213,	155036.99564,	155041.56916,	155046.14269,	155050.71624,	155055.28979,	155059.86336,
155064.43694,	155069.01053,	155073.58413,	155078.15775,	155082.73137,	155087.30501,	155091.87866,	155096.45232,	155101.02599,	155105.59968,
155110.17337,	155114.74708,	155119.32080,	155123.89453,	155128.46827,	155133.04202,	155137.61579,	155142.18956,	155146.76335,	155151.33715,
155155.91096,	155160.48478,	155165.05862,	155169.63246,	155174.20632,	155178.78019,	155183.35407,	155187.92796,	155192.50187,	155197.07578,
155201.64971,	155206.22365,	155210.79760,	155215.37156,	155219.94553,	155224.51952,	155229.09352,	155233.66752,	155238.24154,	155242.81557,
155247.38962,	155251.96367,	155256.53774,	155261.11182,	155265.68590,	155270.26001,	155274.83412,	155279.40824,	155283.98238,	155288.55652,
155293.13068,	155297.70485,	155302.27904,	155306.85323,	155311.42743,	155316.00165,	155320.57588,	155325.15012,	155329.72437,	155334.29863,
155338.87291,	155343.44719,	155348.02149,	155352.59580,	155357.17012,	155361.74445,	155366.31880,	155370.89315,	155375.46752,	155380.04190,
155384.61629,	155389.19069,	155393.76510,	155398.33953,	155402.91396,	155407.48841,	155412.06287,	155416.63734,	155421.21182,	155425.78632,
155430.36082,	155434.93534,	155439.50987,	155444.08441,	155448.65896,	155453.23353,	155457.80810,	155462.38269,	155466.95729,	155471.53190,
155476.10652,	155480.68115,	155485.25580,	155489.83045,	155494.40512,	155498.97980,	155503.55449,	155508.12919,	155512.70391,	155517.27863,
155521.85337,	155526.42812,	155531.00288,	155535.57765,	155540.15243,	155544.72723,	155549.30204,	155553.87685,	155558.45168,	155563.02652,
155567.60138,	155572.17624,	155576.75112,	155581.32601,	155585.90090,	155590.47581,	155595.05074,	155599.62567,	155604.20062,	155608.77557,
155613.35054,	155617.92552,	155622.50051,	155627.07552,	155631.65053,	155636.22556,	155640.80059,	155645.37564,	155649.95070,	155654.52578,
155659.10086,	155663.67596,	155668.25106,	155672.82618,	155677.40131,	155681.97645,	155686.55161,	155691.12677,	155695.70195,	155700.27713,
155704.85233,	155709.42754,	155714.00277,	155718.57800,	155723.15325,	155727.72850,	155732.30377,	155736.87905,	155741.45434,	155746.02965,
155750.60496,	155755.18029,	155759.75563,	155764.33098,	155768.90634,	155773.48171,	155778.05709,	155782.63249,	155787.20790,	155791.78332,
155796.35875,	155800.93419,	155805.50964,	155810.08511,	155814.66058,	155819.23607,	155823.81157,	155828.38708,	155832.96261,	155837.53814,
155842.11369,	155846.68924,	155851.26481,	155855.84039,	155860.41598,	155864.99159,	155869.56720,	155874.14283,	155878.71847,	155883.29412,
155887.86978,	155892.44545,	155897.02113,	155901.59683,	155906.17254,	155910.74826,	155915.32399,	155919.89973,	155924.47548,	155929.05125,
155933.62702,	155938.20281,	155942.77861,	155947.35442,	155951.93024,	155956.50608,	155961.08192,	155965.65778,	155970.23365,	155974.80953,
155979.38542,	155983.96133,	155988.53724,	155993.11317,	155997.68911,	156002.26506,	156006.84102,	156011.41699,	156015.99297,	156020.56897,
156025.14498,	156029.72099,	156034.29702,	156038.87307,	156043.44912,	156048.02518,	156052.60126,	156057.17735,	156061.75345,	156066.32956,
156070.90568,	156075.48182,	156080.05796,	156084.63412,	156089.21029,	156093.78647,	156098.36266,	156102.93886,	156107.51508,	156112.09130,
156116.66754,	156121.24379,	156125.82005,	156130.39632,	156134.97261,	156139.54890,	156144.12521,	156148.70153,	156153.27786,	156157.85420,
156162.43055,	156167.00691,	156171.58329,	156176.15968,	156180.73608,	156185.31249,	156189.88891,	156194.46534,	156199.04179,	156203.61824,
156208.19471,	156212.77119,	156217.34768,	156221.92418,	156226.50070,	156231.07722,	156235.65376,	156240.23031,	156244.80687,	156249.38344,
156253.96003,	156258.53662,	156263.11323,	156267.68984,	156272.26647,	156276.84311,	156281.41977,	156285.99643,	156290.57311,	156295.14979,
156299.72649,	156304.30320,	156308.87992,	156313.45665,	156318.03340,	156322.61015,	156327.18692,	156331.76370,	156336.34049,	156340.91729,
156345.49411,	156350.07093,	156354.64777,	156359.22462,	156363.80148,	156368.37835,	156372.95523,	156377.53212,	156382.10903,	156386.68595,
156391.26287,	156395.83981,	156400.41677,	156404.99373,	156409.57070,	156414.14769,	156418.72469,	156423.30169,	156427.87872,	156432.45575,
156437.03279,	156441.60985,	156446.18691,	156450.76399,	156455.34108,	156459.91818,	156464.49529,	156469.07242,	156473.64955,	156478.22670,
156482.80386,	156487.38103,	156491.95821,	156496.53540,	156501.11261,	156505.68982,	156510.26705,	156514.84429,	156519.42154,	156523.99880,
156528.57608,	156533.15336,	156537.73066,	156542.30796,	156546.88528,	156551.46262,	156556.03996,	156560.61731,	156565.19468,	156569.77205,
156574.34944,	156578.92684,	156583.50425,	156588.08168,	156592.65911,	156597.23656,	156601.81401,	156606.39148,	156610.96896,	156615.54645,
156620.12396,	156624.70147,	156629.27900,	156633.85654,	156638.43409,	156643.01165,	156647.58922,	156652.16680,	156656.74440,	156661.32200,
156665.89962,	156670.47725,	156675.05489,	156679.63255,	156684.21021,	156688.78789,	156693.36557,	156697.94327,	156702.52098,	156707.09870,
156711.67644,	156716.25418,	156720.83194,	156725.40970,	156729.98748,	156734.56527,	156739.14308,	156743.72089,	156748.29871,	156752.87655,
156757.45440,	156762.03226,	156766.61013,	156771.18801,	156775.76590,	156780.34381,	156784.92173,	156789.49965,	156794.07759,	156798.65554,
156803.23351,	156807.81148,	156812.38947,	156816.96746,	156821.54547,	156826.12349,	156830.70152,	156835.27957,	156839.85762,	156844.43569,
156849.01376,	156853.59185,	156858.16995,	156862.74807,	156867.32619,	156871.90432,	156876.48247,	156881.06063,	156885.63880,	156890.21698,
156894.79517,	156899.37337,	156903.95159,	156908.52981,	156913.10805,	156917.68630,	156922.26456,	156926.84283,	156931.42112,	156935.99941,
156940.57772,	156945.15604,	156949.73437,	156954.31271,	156958.89106,	156963.46943,	156968.04780,	156972.62619,	156977.20459,	156981.78300,
156986.36142,	156990.93985,	156995.51830,	157000.09675,	157004.67522,	157009.25370,	157013.83219,	157018.41069,	157022.98920,	157027.56773,
157032.14626,	157036.72481,	157041.30337,	157045.88194,	157050.46052,	157055.03912,	157059.61772,	157064.19634,	157068.77496,	157073.35360,
157077.93225,	157082.51092,	157087.08959,	157091.66828,	157096.24697,	157100.82568,	157105.40440,	157109.98313,	157114.56187,	157119.14063,
157123.71939,	157128.29817,	157132.87696,	157137.45576,	157142.03457,	157146.61339,	157151.19222,	157155.77107,	157160.34993,	157164.92879,
157169.50767,	157174.08657,	157178.66547,	157183.24438,	157187.82331,	157192.40224,	157196.98119,	157201.56015,	157206.13912,	157210.71811,
157215.29710,	157219.87611,	157224.45512,	157229.03415,	157233.61319,	157238.19224,	157242.77131,	157247.35038,	157251.92947,	157256.50857,
157261.08767,	157265.66679,	157270.24593,	157274.82507,	157279.40422,	157283.98339,	157288.56257,	157293.14176,	157297.72096,	157302.30017,
157306.87939,	157311.45863,	157316.03787,	157320.61713,	157325.19640,	157329.77568,	157334.35497,	157338.93427,	157343.51359,	157348.09292,
157352.67225,	157357.25160,	157361.83096,	157366.41033,	157370.98972,	157375.56911,	157380.14852,	157384.72794,	157389.30737,	157393.88681,
157398.46626,	157403.04572,	157407.62520,	157412.20468,	157416.78418,	157421.36369,	157425.94321,	157430.52274,	157435.10229,	157439.68184,
157444.26141,	157448.84099,	157453.42058,	157458.00018,	157462.57979,	157467.15941,	157471.73905,	157476.31869,	157480.89835,	157485.47802,
157490.05770,	157494.63739,	157499.21710,	157503.79681,	157508.37654,	157512.95628,	157517.53603,	157522.11579,	157526.69556,	157531.27534,
157535.85514,	157540.43494,	157545.01476,	157549.59459,	157554.17443,	157558.75428,	157563.33415,	157567.91402,	157572.49391,	157577.07381,
157581.65372,	157586.23364,	157590.81357,	157595.39351,	157599.97347,	157604.55343,	157609.13341,	157613.71340,	157618.29340,	157622.87341,
157627.45344,	157632.03347,	157636.61352,	157641.19358,	157645.77365,	157650.35373,	157654.93382,	157659.51392,	157664.09404,	157668.67416,
157673.25430,	157677.83445,	157682.41461,	157686.99478,	157691.57497,	157696.15516,	157700.73537,	157705.31558,	157709.89581,	157714.47605,
157719.05631,	157723.63657,	157728.21684,	157732.79713,	157737.37743,	157741.95774,	157746.53806,	157751.11839,	157755.69873,	157760.27909,
157764.85945,	157769.43983,	157774.02022,	157778.60062,	157783.18103,	157787.76145,	157792.34189,	157796.92234,	157801.50279,	157806.08326,
157810.66374,	157815.24423,	157819.82474,	157824.40525,	157828.98578,	157833.56631,	157838.14686,	157842.72742,	157847.30799,	157851.88858,
157856.46917,	157861.04978,	157865.63039,	157870.21102,	157874.79166,	157879.37231,	157883.95298,	157888.53365,	157893.11434,	157897.69503,
157902.27574,	157906.85646,	157911.43719,	157916.01793,	157920.59869,	157925.17945,	157929.76023,	157934.34102,	157938.92182,	157943.50263,
157948.08345,	157952.66429,	157957.24513,	157961.82599,	157966.40686,	157970.98773,	157975.56863,	157980.14953,	157984.73044,	157989.31137,
157993.89230,	157998.47325,	158003.05421,	158007.63518,	158012.21616,	158016.79716,	158021.37816,	158025.95918,	158030.54020,	158035.12124,
158039.70229,	158044.28335,	158048.86443,	158053.44551,	158058.02661,	158062.60772,	158067.18883,	158071.76996,	158076.35111,	158080.93226,
158085.51342,	158090.09460,	158094.67579,	158099.25698,	158103.83819,	158108.41942,	158113.00065,	158117.58189,	158122.16315,	158126.74441,
158131.32569,	158135.90698,	158140.48828,	158145.06960,	158149.65092,	158154.23225,	158158.81360,	158163.39496,	158167.97633,	158172.55771,
158177.13910,	158181.72050,	158186.30192,	158190.88335,	158195.46478,	158200.04623,	158204.62769,	158209.20916,	158213.79065,	158218.37214,
158222.95365,	158227.53517,	158232.11669,	158236.69823,	158241.27979,	158245.86135,	158250.44292,	158255.02451,	158259.60611,	158264.18771,
158268.76933,	158273.35096,	158277.93261,	158282.51426,	158287.09593,	158291.67760,	158296.25929,	158300.84099,	158305.42270,	158310.00442,
158314.58616,	158319.16790,	158323.74966,	158328.33143,	158332.91320,	158337.49499,	158342.07680,	158346.65861,	158351.24043,	158355.82227,
158360.40412,	158364.98598,	158369.56785,	158374.14973,	158378.73162,	158383.31352,	158387.89544,	158392.47737,	158397.05931,	158401.64126,
158406.22322,	158410.80519,	158415.38717,	158419.96917,	158424.55117,	158429.13319,	158433.71522,	158438.29726,	158442.87931,	158447.46138,
158452.04345,	158456.62554,	158461.20764,	158465.78974,	158470.37186,	158474.95400,	158479.53614,	158484.11829,	158488.70046,	158493.28264,
158497.86482,	158502.44702,	158507.02924,	158511.61146,	158516.19369,	158520.77594,	158525.35819,	158529.94046,	158534.52274,	158539.10503,
158543.68733,	158548.26965,	158552.85197,	158557.43431,	158562.01666,	158566.59901,	158571.18138,	158575.76377,	158580.34616,	158584.92856,
158589.51098,	158594.09341,	158598.67584,	158603.25829,	158607.84076,	158612.42323,	158617.00571,	158621.58821,	158626.17071,	158630.75323,
158635.33576,	158639.91830,	158644.50085,	158649.08342,	158653.66599,	158658.24858,	158662.83117,	158667.41378,	158671.99640,	158676.57903,
158681.16168,	158685.74433,	158690.32700,	158694.90967,	158699.49236,	158704.07506,	158708.65777,	158713.24049,	158717.82323,	158722.40597,
158726.98873,	158731.57150,	158736.15428,	158740.73707,	158745.31987,	158749.90268,	158754.48551,	158759.06834,	158763.65119,	158768.23405,
158772.81692,	158777.39980,	158781.98269,	158786.56559,	158791.14851,	158795.73144,	158800.31437,	158804.89732,	158809.48028,	158814.06326,
158818.64624,	158823.22923,	158827.81224,	158832.39526,	158836.97829,	158841.56133,	158846.14438,	158850.72744,	158855.31051,	158859.89360,
158864.47670,	158869.05980,	158873.64292,	158878.22605,	158882.80920,	158887.39235,	158891.97551,	158896.55869,	158901.14188,	158905.72508,
158910.30829,	158914.89151,	158919.47474,	158924.05798,	158928.64124,	158933.22451,	158937.80779,	158942.39107,	158946.97438,	158951.55769,
158956.14101,	158960.72435,	158965.30769,	158969.89105,	158974.47442,	158979.05780,	158983.64119,	158988.22459,	158992.80801,	158997.39143,
159001.97487,	159006.55832,	159011.14178,	159015.72525,	159020.30873,	159024.89222,	159029.47573,	159034.05924,	159038.64277,	159043.22631,
159047.80986,	159052.39342,	159056.97700,	159061.56058,	159066.14417,	159070.72778,	159075.31140,	159079.89503,	159084.47867,	159089.06232,
159093.64599,	159098.22966,	159102.81335,	159107.39704,	159111.98075,	159116.56447,	159121.14820,	159125.73195,	159130.31570,	159134.89947,
159139.48324,	159144.06703,	159148.65083,	159153.23464,	159157.81846,	159162.40230,	159166.98614,	159171.57000,	159176.15386,	159180.73774,
159185.32163,	159189.90553,	159194.48945,	159199.07337,	159203.65731,	159208.24125,	159212.82521,	159217.40918,	159221.99316,	159226.57715,
159231.16115,	159235.74517,	159240.32919,	159244.91323,	159249.49728,	159254.08134,	159258.66541,	159263.24949,	159267.83359,	159272.41769,
159277.00181,	159281.58594,	159286.17007,	159290.75422,	159295.33839,	159299.92256,	159304.50674,	159309.09094,	159313.67515,	159318.25936,
159322.84359,	159327.42783,	159332.01209,	159336.59635,	159341.18062,	159345.76491,	159350.34921,	159354.93352,	159359.51784,	159364.10217,
159368.68651,	159373.27086,	159377.85523,	159382.43961,	159387.02399,	159391.60839,	159396.19280,	159400.77722,	159405.36166,	159409.94610,
159414.53056,	159419.11502,	159423.69950,	159428.28399,	159432.86849,	159437.45300,	159442.03753,	159446.62206,	159451.20661,	159455.79117,
159460.37573,	159464.96031,	159469.54491,	159474.12951,	159478.71412,	159483.29875,	159487.88338,	159492.46803,	159497.05269,	159501.63736,
159506.22204,	159510.80674,	159515.39144,	159519.97616,	159524.56088,	159529.14562,	159533.73037,	159538.31513,	159542.89990,	159547.48469,
159552.06948,	159556.65429,	159561.23910,	159565.82393,	159570.40877,	159574.99362,	159579.57849,	159584.16336,	159588.74825,	159593.33314,
159597.91805,	159602.50297,	159607.08790,	159611.67284,	159616.25779,	159620.84276,	159625.42773,	159630.01272,	159634.59772,	159639.18273,
159643.76775,	159648.35278,	159652.93782,	159657.52288,	159662.10794,	159666.69302,	159671.27811,	159675.86321,	159680.44832,	159685.03344,
159689.61857,	159694.20372,	159698.78887,	159703.37404,	159707.95922,	159712.54441,	159717.12961,	159721.71482,	159726.30005,	159730.88528,
159735.47053,	159740.05579,	159744.64106,	159749.22634,	159753.81163,	159758.39693,	159762.98224,	159767.56757,	159772.15291,	159776.73825,
159781.32361,	159785.90898,	159790.49437,	159795.07976,	159799.66516,	159804.25058,	159808.83601,	159813.42144,	159818.00689,	159822.59235,
159827.17783,	159831.76331,	159836.34880,	159840.93431,	159845.51983,	159850.10536,	159854.69089,	159859.27645,	159863.86201,	159868.44758,
159873.03317,	159877.61876,	159882.20437,	159886.78999,	159891.37562,	159895.96126,	159900.54691,	159905.13258,	159909.71825,	159914.30394,
159918.88963,	159923.47534,	159928.06106,	159932.64679,	159937.23254,	159941.81829,	159946.40406,	159950.98983,	159955.57562,	159960.16142,
159964.74723,	159969.33305,	159973.91888,	159978.50473,	159983.09058,	159987.67645,	159992.26233,	159996.84822,	160001.43412,	160006.02003,
160010.60595,	160015.19189,	160019.77783,	160024.36379,	160028.94976,	160033.53574,	160038.12173,	160042.70773,	160047.29374,	160051.87977,
160056.46580,	160061.05185,	160065.63791,	160070.22398,	160074.81006,	160079.39615,	160083.98225,	160088.56837,	160093.15449,	160097.74063,
160102.32678,	160106.91294,	160111.49911,	160116.08529,	160120.67148,	160125.25769,	160129.84390,	160134.43013,	160139.01637,	160143.60262,
160148.18888,	160152.77515,	160157.36144,	160161.94773,	160166.53404,	160171.12035,	160175.70668,	160180.29302,	160184.87937,	160189.46574,
160194.05211,	160198.63849,	160203.22489,	160207.81130,	160212.39772,	160216.98415,	160221.57059,	160226.15704,	160230.74350,	160235.32998,
160239.91646,	160244.50296,	160249.08947,	160253.67599,	160258.26252,	160262.84906,	160267.43562,	160272.02218,	160276.60876,	160281.19534,
160285.78194,	160290.36855,	160294.95517,	160299.54181,	160304.12845,	160308.71510,	160313.30177,	160317.88845,	160322.47514,	160327.06184,
160331.64855,	160336.23527,	160340.82200,	160345.40875,	160349.99550,	160354.58227,	160359.16905,	160363.75584,	160368.34264,	160372.92945,
160377.51628,	160382.10311,	160386.68996,	160391.27681,	160395.86368,	160400.45056,	160405.03745,	160409.62435,	160414.21127,	160418.79819,
160423.38513,	160427.97208,	160432.55903,	160437.14600,	160441.73299,	160446.31998,	160450.90698,	160455.49400,	160460.08102,	160464.66806,
160469.25511,	160473.84217,	160478.42924,	160483.01632,	160487.60341,	160492.19052,	160496.77763,	160501.36476,	160505.95190,	160510.53905,
160515.12621,	160519.71338,	160524.30056,	160528.88776,	160533.47496,	160538.06218,	160542.64941,	160547.23665,	160551.82390,	160556.41116,
160560.99843,	160565.58572,	160570.17301,	160574.76032,	160579.34764,	160583.93497,	160588.52231,	160593.10966,	160597.69702,	160602.28440,
160606.87178,	160611.45918,	160616.04659,	160620.63401,	160625.22144,	160629.80888,	160634.39633,	160638.98379,	160643.57127,	160648.15876,
160652.74625,	160657.33376,	160661.92128,	160666.50881,	160671.09636,	160675.68391,	160680.27148,	160684.85905,	160689.44664,	160694.03424,
160698.62185,	160703.20947,	160707.79710,	160712.38475,	160716.97240,	160721.56007,	160726.14774,	160730.73543,	160735.32313,	160739.91084,
160744.49857,	160749.08630,	160753.67404,	160758.26180,	160762.84957,	160767.43734,	160772.02513,	160776.61293,	160781.20075,	160785.78857,
160790.37640,	160794.96425,	160799.55211,	160804.13997,	160808.72785,	160813.31574,	160817.90365,	160822.49156,	160827.07948,	160831.66742,
160836.25537,	160840.84332,	160845.43129,	160850.01927,	160854.60726,	160859.19527,	160863.78328,	160868.37130,	160872.95934,	160877.54739,
160882.13545,	160886.72352,	160891.31160,	160895.89969,	160900.48779,	160905.07591,	160909.66404,	160914.25217,	160918.84032,	160923.42848,
160928.01665,	160932.60483,	160937.19303,	160941.78123,	160946.36945,	160950.95767,	160955.54591,	160960.13416,	160964.72242,	160969.31069,
160973.89898,	160978.48727,	160983.07558,	160987.66389,	160992.25222,	160996.84056,	161001.42891,	161006.01727,	161010.60564,	161015.19403,
161019.78242,	161024.37083,	161028.95925,	161033.54767,	161038.13611,	161042.72456,	161047.31303,	161051.90150,	161056.48998,	161061.07848,
161065.66699,	161070.25551,	161074.84404,	161079.43258,	161084.02113,	161088.60969,	161093.19826,	161097.78685,	161102.37545,	161106.96405,
161111.55267,	161116.14130,	161120.72995,	161125.31860,	161129.90726,	161134.49594,	161139.08462,	161143.67332,	161148.26203,	161152.85075,
161157.43948,	161162.02822,	161166.61697,	161171.20574,	161175.79452,	161180.38330,	161184.97210,	161189.56091,	161194.14973,	161198.73856,
161203.32740,	161207.91626,	161212.50512,	161217.09400,	161221.68289,	161226.27179,	161230.86070,	161235.44962,	161240.03855,	161244.62749,
161249.21645,	161253.80542,	161258.39439,	161262.98338,	161267.57238,	161272.16139,	161276.75041,	161281.33945,	161285.92849,	161290.51755,
161295.10661,	161299.69569,	161304.28478,	161308.87388,	161313.46299,	161318.05211,	161322.64125,	161327.23039,	161331.81955,	161336.40872,
161340.99790,	161345.58709,	161350.17629,	161354.76550,	161359.35472,	161363.94396,	161368.53320,	161373.12246,	161377.71173,	161382.30101,
161386.89030,	161391.47960,	161396.06891,	161400.65823,	161405.24757,	161409.83692,	161414.42627,	161419.01564,	161423.60502,	161428.19441,
161432.78382,	161437.37323,	161441.96265,	161446.55209,	161451.14154,	161455.73099,	161460.32046,	161464.90994,	161469.49944,	161474.08894,
161478.67845,	161483.26798,	161487.85751,	161492.44706,	161497.03662,	161501.62619,	161506.21577,	161510.80536,	161515.39497,	161519.98458,
161524.57421,	161529.16384,	161533.75349,	161538.34315,	161542.93282,	161547.52250,	161552.11220,	161556.70190,	161561.29161,	161565.88134,
161570.47108,	161575.06083,	161579.65059,	161584.24036,	161588.83014,	161593.41993,	161598.00974,	161602.59955,	161607.18938,	161611.77922,
161616.36907,	161620.95893,	161625.54880,	161630.13868,	161634.72857,	161639.31848,	161643.90840,	161648.49832,	161653.08826,	161657.67821,
161662.26817,	161666.85814,	161671.44813,	161676.03812,	161680.62813,	161685.21814,	161689.80817,	161694.39821,	161698.98826,	161703.57832,
161708.16839,	161712.75848,	161717.34857,	161721.93868,	161726.52879,	161731.11892,	161735.70906,	161740.29921,	161744.88937,	161749.47955,
161754.06973,	161758.65993,	161763.25013,	161767.84035,	161772.43058,	161777.02082,	161781.61107,	161786.20133,	161790.79160,	161795.38189,
161799.97218,	161804.56249,	161809.15281,	161813.74314,	161818.33348,	161822.92383,	161827.51419,	161832.10457,	161836.69495,	161841.28535,
161845.87575,	161850.46617,	161855.05660,	161859.64704,	161864.23749,	161868.82796,	161873.41843,	161878.00892,	161882.59941,	161887.18992,
161891.78044,	161896.37097,	161900.96151,	161905.55206,	161910.14262,	161914.73320,	161919.32378,	161923.91438,	161928.50499,	161933.09561,
161937.68624,	161942.27688,	161946.86753,	161951.45819,	161956.04887,	161960.63956,	161965.23025,	161969.82096,	161974.41168,	161979.00241,
161983.59315,	161988.18390,	161992.77467,	161997.36544,	162001.95623,	162006.54703,	162011.13783,	162015.72865,	162020.31949,	162024.91033,
162029.50118,	162034.09204,	162038.68292,	162043.27381,	162047.86470,	162052.45561,	162057.04653,	162061.63746,	162066.22840,	162070.81936,
162075.41032,	162080.00130,	162084.59228,	162089.18328,	162093.77429,	162098.36531,	162102.95634,	162107.54738,	162112.13844,	162116.72950,
162121.32058,	162125.91167,	162130.50276,	162135.09387,	162139.68499,	162144.27612,	162148.86727,	162153.45842,	162158.04959,	162162.64076,
162167.23195,	162171.82315,	162176.41436,	162181.00558,	162185.59681,	162190.18805,	162194.77930,	162199.37057,	162203.96185,	162208.55313,
162213.14443,	162217.73574,	162222.32706,	162226.91839,	162231.50974,	162236.10109,	162240.69246,	162245.28383,	162249.87522,	162254.46662,
162259.05803,	162263.64945,	162268.24088,	162272.83232,	162277.42378,	162282.01524,	162286.60672,	162291.19821,	162295.78971,	162300.38122,
162304.97274,	162309.56427,	162314.15581,	162318.74737,	162323.33893,	162327.93051,	162332.52210,	162337.11369,	162341.70530,	162346.29693,
162350.88856,	162355.48020,	162360.07186,	162364.66352,	162369.25520,	162373.84689,	162378.43858,	162383.03029,	162387.62202,	162392.21375,
162396.80549,	162401.39725,	162405.98901,	162410.58079,	162415.17258,	162419.76437,	162424.35618,	162428.94801,	162433.53984,	162438.13168,
162442.72354,	162447.31540,	162451.90728,	162456.49917,	162461.09106,	162465.68298,	162470.27490,	162474.86683,	162479.45877,	162484.05073,
162488.64269,	162493.23467,	162497.82666,	162502.41866,	162507.01067,	162511.60269,	162516.19472,	162520.78676,	162525.37882,	162529.97088,
162534.56296,	162539.15505,	162543.74715,	162548.33926,	162552.93138,	162557.52351,	162562.11565,	162566.70781,	162571.29997,	162575.89215,
162580.48434,	162585.07654,	162589.66875,	162594.26097,	162598.85320,	162603.44544,	162608.03770,	162612.62996,	162617.22224,	162621.81453,
162626.40683,	162630.99914,	162635.59146,	162640.18379,	162644.77614,	162649.36849,	162653.96086,	162658.55323,	162663.14562,	162667.73802,
162672.33043,	162676.92285,	162681.51528,	162686.10772,	162690.70018,	162695.29264,	162699.88512,	162704.47761,	162709.07011,	162713.66262,
162718.25514,	162722.84767,	162727.44021,	162732.03277,	162736.62533,	162741.21791,	162745.81050,	162750.40310,	162754.99571,	162759.58833,
162764.18096,	162768.77360,	162773.36626,	162777.95892,	162782.55160,	162787.14428,	162791.73698,	162796.32969,	162800.92241,	162805.51514,
162810.10789,	162814.70064,	162819.29341,	162823.88618,	162828.47897,	162833.07177,	162837.66458,	162842.25740,	162846.85023,	162851.44307,
162856.03593,	162860.62879,	162865.22167,	162869.81455,	162874.40745,	162879.00036,	162883.59328,	162888.18621,	162892.77916,	162897.37211,
162901.96507,	162906.55805,	162911.15104,	162915.74403,	162920.33704,	162924.93006,	162929.52309,	162934.11614,	162938.70919,	162943.30225,
162947.89533,	162952.48842,	162957.08151,	162961.67462,	162966.26774,	162970.86087,	162975.45402,	162980.04717,	162984.64033,	162989.23351,
162993.82669,	162998.41989,	163003.01310,	163007.60632,	163012.19955,	163016.79279,	163021.38605,	163025.97931,	163030.57258,	163035.16587,
163039.75917,	163044.35248,	163048.94580,	163053.53913,	163058.13247,	163062.72582,	163067.31918,	163071.91256,	163076.50594,	163081.09934,
163085.69275,	163090.28617,	163094.87960,	163099.47304,	163104.06649,	163108.65995,	163113.25343,	163117.84691,	163122.44041,	163127.03392,
163131.62744,	163136.22097,	163140.81451,	163145.40806,	163150.00162,	163154.59520,	163159.18878,	163163.78238,	163168.37598,	163172.96960,
163177.56323,	163182.15687,	163186.75052,	163191.34419,	163195.93786,	163200.53155,	163205.12524,	163209.71895,	163214.31267,	163218.90639,
163223.50013,	163228.09389,	163232.68765,	163237.28142,	163241.87521,	163246.46900,	163251.06281,	163255.65663,	163260.25045,	163264.84429,
163269.43814,	163274.03201,	163278.62588,	163283.21976,	163287.81366,	163292.40756,	163297.00148,	163301.59541,	163306.18935,	163310.78330,
163315.37726,	163319.97123,	163324.56522,	163329.15921,	163333.75322,	163338.34723,	163342.94126,	163347.53530,	163352.12935,	163356.72341,
163361.31748,	163365.91156,	163370.50566,	163375.09976,	163379.69388,	163384.28801,	163388.88215,	163393.47630,	163398.07046,	163402.66463,
163407.25881,	163411.85300,	163416.44721,	163421.04142,	163425.63565,	163430.22989,	163434.82414,	163439.41840,	163444.01267,	163448.60695,
163453.20124,	163457.79555,	163462.38986,	163466.98419,	163471.57853,	163476.17287,	163480.76723,	163485.36160,	163489.95599,	163494.55038,
163499.14478,	163503.73920,	163508.33362,	163512.92806,	163517.52251,	163522.11697,	163526.71144,	163531.30592,	163535.90041,	163540.49491,
163545.08943,	163549.68395,	163554.27849,	163558.87303,	163563.46759,	163568.06216,	163572.65674,	163577.25133,	163581.84594,	163586.44055,
163591.03517,	163595.62981,	163600.22446,	163604.81911,	163609.41378,	163614.00846,	163618.60315,	163623.19786,	163627.79257,	163632.38729,
163636.98203,	163641.57677,	163646.17153,	163650.76630,	163655.36108,	163659.95587,	163664.55067,	163669.14548,	163673.74030,	163678.33514,
163682.92998,	163687.52484,	163692.11971,	163696.71459,	163701.30948,	163705.90438,	163710.49929,	163715.09421,	163719.68914,	163724.28409,
163728.87905,	163733.47401,	163738.06899,	163742.66398,	163747.25898,	163751.85399,	163756.44901,	163761.04404,	163765.63909,	163770.23414,
163774.82921,	163779.42429,	163784.01938,	163788.61447,	163793.20958,	163797.80471,	163802.39984,	163806.99498,	163811.59014,	163816.18530,
163820.78048,	163825.37567,	163829.97086,	163834.56607,	163839.16129,	163843.75653,	163848.35177,	163852.94702,	163857.54229,	163862.13756,
163866.73285,	163871.32815,	163875.92346,	163880.51878,	163885.11411,	163889.70945,	163894.30480,	163898.90016,	163903.49554,	163908.09093,
163912.68632,	163917.28173,	163921.87715,	163926.47258,	163931.06802,	163935.66347,	163940.25894,	163944.85441,	163949.44990,	163954.04539,
163958.64090,	163963.23642,	163967.83195,	163972.42749,	163977.02304,	163981.61860,	163986.21417,	163990.80976,	163995.40535,	164000.00096,
164004.59658,	164009.19221,	164013.78785,	164018.38350,	164022.97916,	164027.57483,	164032.17051,	164036.76621,	164041.36191,	164045.95763,
164050.55336,	164055.14910,	164059.74485,	164064.34061,	164068.93638,	164073.53216,	164078.12796,	164082.72376,	164087.31958,	164091.91540,
164096.51124,	164101.10709,	164105.70295,	164110.29882,	164114.89470,	164119.49059,	164124.08650,	164128.68241,	164133.27834,	164137.87428,
164142.47022,	164147.06618,	164151.66215,	164156.25813,	164160.85413,	164165.45013,	164170.04614,	164174.64217,	164179.23820,	164183.83425,
164188.43031,	164193.02638,	164197.62246,	164202.21855,	164206.81465,	164211.41076,	164216.00689,	164220.60302,	164225.19917,	164229.79533,
164234.39149,	164238.98767,	164243.58386,	164248.18006,	164252.77628,	164257.37250,	164261.96873,	164266.56498,	164271.16124,	164275.75750,
164280.35378,	164284.95007,	164289.54637,	164294.14268,	164298.73900,	164303.33534,	164307.93168,	164312.52804,	164317.12440,	164321.72078,
164326.31717,	164330.91357,	164335.50998,	164340.10640,	164344.70283,	164349.29927,	164353.89573,	164358.49219,	164363.08867,	164367.68516,
164372.28165,	164376.87816,	164381.47468,	164386.07121,	164390.66776,	164395.26431,	164399.86087,	164404.45745,	164409.05403,	164413.65063,
164418.24724,	164422.84386,	164427.44049,	164432.03713,	164436.63378,	164441.23044,	164445.82712,	164450.42380,	164455.02050,	164459.61721,
164464.21393,	164468.81065,	164473.40739,	164478.00415,	164482.60091,	164487.19768,	164491.79446,	164496.39126,	164500.98806,	164505.58488,
164510.18171,	164514.77855,	164519.37540,	164523.97226,	164528.56913,	164533.16601,	164537.76291,	164542.35981,	164546.95673,	164551.55366,
164556.15059,	164560.74754,	164565.34450,	164569.94147,	164574.53845,	164579.13545,	164583.73245,	164588.32947,	164592.92649,	164597.52353,
164602.12058,	164606.71763,	164611.31470,	164615.91178,	164620.50888,	164625.10598,	164629.70309,	164634.30022,	164638.89735,	164643.49450,
164648.09166,	164652.68882,	164657.28600,	164661.88319,	164666.48040,	164671.07761,	164675.67483,	164680.27207,	164684.86931,	164689.46657,
164694.06383,	164698.66111,	164703.25840,	164707.85570,	164712.45301,	164717.05034,	164721.64767,	164726.24501,	164730.84237,	164735.43973,
164740.03711,	164744.63450,	164749.23190,	164753.82931,	164758.42673,	164763.02416,	164767.62160,	164772.21906,	164776.81652,	164781.41400,
164786.01148,	164790.60898,	164795.20649,	164799.80401,	164804.40154,	164808.99908,	164813.59664,	164818.19420,	164822.79177,	164827.38936,
164831.98696,	164836.58456,	164841.18218,	164845.77981,	164850.37745,	164854.97510,	164859.57277,	164864.17044,	164868.76812,	164873.36582,
164877.96352,	164882.56124,	164887.15897,	164891.75671,	164896.35446,	164900.95222,	164905.54999,	164910.14777,	164914.74557,	164919.34337,
164923.94119,	164928.53902,	164933.13685,	164937.73470,	164942.33256,	164946.93043,	164951.52831,	164956.12621,	164960.72411,	164965.32202,
164969.91995,	164974.51789,	164979.11583,	164983.71379,	164988.31176,	164992.90974,	164997.50773,	165002.10573,	165006.70375,	165011.30177,
165015.89981,	165020.49785,	165025.09591,	165029.69398,	165034.29206,	165038.89015,	165043.48825,	165048.08636,	165052.68448,	165057.28262,
165061.88076,	165066.47892,	165071.07708,	165075.67526,	165080.27345,	165084.87165,	165089.46986,	165094.06808,	165098.66631,	165103.26455,
165107.86281,	165112.46107,	165117.05935,	165121.65764,	165126.25593,	165130.85424,	165135.45256,	165140.05089,	165144.64924,	165149.24759,
165153.84595,	165158.44433,	165163.04271,	165167.64111,	165172.23952,	165176.83793,	165181.43636,	165186.03480,	165190.63326,	165195.23172,
165199.83019,	165204.42867,	165209.02717,	165213.62568,	165218.22419,	165222.82272,	165227.42126,	165232.01981,	165236.61837,	165241.21694,
165245.81552,	165250.41412,	165255.01272,	165259.61134,	165264.20996,	165268.80860,	165273.40725,	165278.00591,	165282.60458,	165287.20326,
165291.80195,	165296.40066,	165300.99937,	165305.59809,	165310.19683,	165314.79558,	165319.39433,	165323.99310,	165328.59188,	165333.19067,
165337.78947,	165342.38829,	165346.98711,	165351.58594,	165356.18479,	165360.78365,	165365.38251,	165369.98139,	165374.58028,	165379.17918,
165383.77809,	165388.37701,	165392.97594,	165397.57489,	165402.17384,	165406.77281,	165411.37179,	165415.97077,	165420.56977,	165425.16878,
165429.76780,	165434.36683,	165438.96587,	165443.56493,	165448.16399,	165452.76307,	165457.36215,	165461.96125,	165466.56036,	165471.15947,
165475.75860,	165480.35774,	165484.95690,	165489.55606,	165494.15523,	165498.75441,	165503.35361,	165507.95282,	165512.55203,	165517.15126,
165521.75050,	165526.34975,	165530.94901,	165535.54828,	165540.14756,	165544.74686,	165549.34616,	165553.94548,	165558.54480,	165563.14414,
165567.74349,	165572.34285,	165576.94222,	165581.54160,	165586.14099,	165590.74039,	165595.33981,	165599.93923,	165604.53867,	165609.13811,
165613.73757,	165618.33704,	165622.93652,	165627.53601,	165632.13551,	165636.73502,	165641.33454,	165645.93408,	165650.53362,	165655.13318,
165659.73274,	165664.33232,	165668.93191,	165673.53151,	165678.13112,	165682.73074,	165687.33037,	165691.93001,	165696.52967,	165701.12933,
165705.72901,	165710.32870,	165714.92839,	165719.52810,	165724.12782,	165728.72755,	165733.32729,	165737.92704,	165742.52681,	165747.12658,
165751.72637,	165756.32616,	165760.92597,	165765.52579,	165770.12561,	165774.72545,	165779.32530,	165783.92517,	165788.52504,	165793.12492,
165797.72482,	165802.32472,	165806.92464,	165811.52456,	165816.12450,	165820.72445,	165825.32441,	165829.92438,	165834.52436,	165839.12435,
165843.72436,	165848.32437,	165852.92439,	165857.52443,	165862.12448,	165866.72453,	165871.32460,	165875.92468,	165880.52477,	165885.12487,
165889.72499,	165894.32511,	165898.92524,	165903.52539,	165908.12554,	165912.72571,	165917.32589,	165921.92608,	165926.52628,	165931.12649,
165935.72671,	165940.32694,	165944.92718,	165949.52744,	165954.12770,	165958.72798,	165963.32826,	165967.92856,	165972.52887,	165977.12919,
165981.72952,	165986.32986,	165990.93021,	165995.53058,	166000.13095,	166004.73133,	166009.33173,	166013.93214,	166018.53255,	166023.13298,
166027.73342,	166032.33387,	166036.93433,	166041.53480,	166046.13529,	166050.73578,	166055.33628,	166059.93680,	166064.53733,	166069.13786,
166073.73841,	166078.33897,	166082.93954,	166087.54012,	166092.14071,	166096.74132,	166101.34193,	166105.94255,	166110.54319,	166115.14384,
166119.74449,	166124.34516,	166128.94584,	166133.54653,	166138.14723,	166142.74794,	166147.34866,	166151.94940,	166156.55014,	166161.15090,
166165.75166,	166170.35244,	166174.95323,	166179.55403,	166184.15484,	166188.75566,	166193.35649,	166197.95733,	166202.55818,	166207.15905,
166211.75992,	166216.36081,	166220.96171,	166225.56261,	166230.16353,	166234.76446,	166239.36540,	166243.96635,	166248.56731,	166253.16829,
166257.76927,	166262.37027,	166266.97127,	166271.57229,	166276.17331,	166280.77435,	166285.37540,	166289.97646,	166294.57753,	166299.17861,
166303.77971,	166308.38081,	166312.98193,	166317.58305,	166322.18419,	166326.78533,	166331.38649,	166335.98766,	166340.58884,	166345.19003,
166349.79123,	166354.39244,	166358.99367,	166363.59490,	166368.19615,	166372.79740,	166377.39867,	166381.99995,	166386.60123,	166391.20253,
166395.80384,	166400.40517,	166405.00650,	166409.60784,	166414.20919,	166418.81056,	166423.41193,	166428.01332,	166432.61472,	166437.21613,
166441.81754,	166446.41897,	166451.02041,	166455.62187,	166460.22333,	166464.82480,	166469.42629,	166474.02778,	166478.62929,	166483.23080,
166487.83233,	166492.43387,	166497.03542,	166501.63698,	166506.23855,	166510.84013,	166515.44173,	166520.04333,	166524.64494,	166529.24657,
166533.84821,	166538.44985,	166543.05151,	166547.65318,	166552.25486,	166556.85655,	166561.45825,	166566.05996,	166570.66169,	166575.26342,
166579.86517,	166584.46692,	166589.06869,	166593.67047,	166598.27226,	166602.87406,	166607.47587,	166612.07769,	166616.67952,	166621.28136,
166625.88321,	166630.48508,	166635.08695,	166639.68884,	166644.29074,	166648.89265,	166653.49456,	166658.09649,	166662.69844,	166667.30039,
166671.90235,	166676.50432,	166681.10631,	166685.70830,	166690.31031,	166694.91232,	166699.51435,	166704.11639,	166708.71844,	166713.32050,
166717.92257,	166722.52465,	166727.12674,	166731.72885,	166736.33096,	166740.93309,	166745.53522,	166750.13737,	166754.73953,	166759.34169,
166763.94387,	166768.54606,	166773.14827,	166777.75048,	166782.35270,	166786.95493,	166791.55718,	166796.15943,	166800.76170,	166805.36398,
166809.96627,	166814.56856,	166819.17087,	166823.77319,	166828.37553,	166832.97787,	166837.58022,	166842.18258,	166846.78496,	166851.38734,
166855.98974,	166860.59215,	166865.19457,	166869.79700,	166874.39944,	166879.00189,	166883.60435,	166888.20682,	166892.80930,	166897.41180,
166902.01430,	166906.61682,	166911.21934,	166915.82188,	166920.42443,	166925.02699,	166929.62956,	166934.23214,	166938.83473,	166943.43733,
166948.03995,	166952.64257,	166957.24521,	166961.84785,	166966.45051,	166971.05318,	166975.65586,	166980.25855,	166984.86125,	166989.46396,
166994.06668,	166998.66941,	167003.27215,	167007.87491,	167012.47767,	167017.08045,	167021.68324,	167026.28603,	167030.88884,	167035.49166,
167040.09449,	167044.69733,	167049.30018,	167053.90305,	167058.50592,	167063.10881,	167067.71170,	167072.31461,	167076.91752,	167081.52045,
167086.12339,	167090.72634,	167095.32930,	167099.93227,	167104.53525,	167109.13825,	167113.74125,	167118.34426,	167122.94729,	167127.55032,
167132.15337,	167136.75643,	167141.35950,	167145.96258,	167150.56567,	167155.16877,	167159.77188,	167164.37500,	167168.97814,	167173.58128,
167178.18444,	167182.78760,	167187.39078,	167191.99397,	167196.59717,	167201.20037,	167205.80359,	167210.40683,	167215.01007,	167219.61332,
167224.21658,	167228.81986,	167233.42314,	167238.02644,	167242.62975,	167247.23306,	167251.83639,	167256.43973,	167261.04308,	167265.64644,
167270.24981,	167274.85320,	167279.45659,	167284.05999,	167288.66341,	167293.26684,	167297.87027,	167302.47372,	167307.07718,	167311.68065,
167316.28413,	167320.88762,	167325.49112,	167330.09463,	167334.69815,	167339.30169,	167343.90523,	167348.50879,	167353.11236,	167357.71593,
167362.31952,	167366.92312,	167371.52673,	167376.13035,	167380.73398,	167385.33762,	167389.94128,	167394.54494,	167399.14862,	167403.75230,
167408.35600,	167412.95971,	167417.56342,	167422.16715,	167426.77089,	167431.37464,	167435.97840,	167440.58218,	167445.18596,	167449.78975,
167454.39356,	167458.99737,	167463.60120,	167468.20504,	167472.80888,	167477.41274,	167482.01661,	167486.62049,	167491.22438,	167495.82828,
167500.43220,	167505.03612,	167509.64005,	167514.24400,	167518.84796,	167523.45192,	167528.05590,	167532.65989,	167537.26389,	167541.86790,
167546.47192,	167551.07595,	167555.67999,	167560.28405,	167564.88811,	167569.49218,	167574.09627,	167578.70037,	167583.30447,	167587.90859,
167592.51272,	167597.11686,	167601.72101,	167606.32517,	167610.92934,	167615.53353,	167620.13772,	167624.74192,	167629.34614,	167633.95037,
167638.55460,	167643.15885,	167647.76311,	167652.36738,	167656.97166,	167661.57595,	167666.18025,	167670.78456,	167675.38889,	167679.99322,
167684.59756,	167689.20192,	167693.80629,	167698.41066,	167703.01505,	167707.61945,	167712.22386,	167716.82828,	167721.43271,	167726.03715,
167730.64161,	167735.24607,	167739.85055,	167744.45503,	167749.05953,	167753.66403,	167758.26855,	167762.87308,	167767.47762,	167772.08217,
167776.68673,	167781.29130,	167785.89588,	167790.50048,	167795.10508,	167799.70970,	167804.31432,	167808.91896,	167813.52361,	167818.12826,
167822.73293,	167827.33761,	167831.94230,	167836.54700,	167841.15171,	167845.75644,	167850.36117,	167854.96592,	167859.57067,	167864.17544,
167868.78021,	167873.38500,	167877.98980,	167882.59461,	167887.19943,	167891.80426,	167896.40910,	167901.01395,	167905.61881,	167910.22369,
167914.82857,	167919.43347,	167924.03837,	167928.64329,	167933.24822,	167937.85316,	167942.45811,	167947.06307,	167951.66804,	167956.27302,
167960.87801,	167965.48302,	167970.08803,	167974.69305,	167979.29809,	167983.90314,	167988.50819,	167993.11326,	167997.71834,	168002.32343,
168006.92853,	168011.53364,	168016.13876,	168020.74389,	168025.34904,	168029.95419,	168034.55936,	168039.16453,	168043.76972,	168048.37492,
168052.98012,	168057.58534,	168062.19057,	168066.79581,	168071.40106,	168076.00633,	168080.61160,	168085.21688,	168089.82218,	168094.42748,
168099.03280,	168103.63812,	168108.24346,	168112.84881,	168117.45417,	168122.05954,	168126.66492,	168131.27031,	168135.87571,	168140.48113,
168145.08655,	168149.69198,	168154.29743,	168158.90288,	168163.50835,	168168.11383,	168172.71932,	168177.32482,	168181.93033,	168186.53585,
168191.14138,	168195.74692,	168200.35247,	168204.95804,	168209.56361,	168214.16920,	168218.77479,	168223.38040,	168227.98602,	168232.59164,
168237.19728,	168241.80293,	168246.40859,	168251.01426,	168255.61995,	168260.22564,	168264.83134,	168269.43706,	168274.04278,	168278.64852,
168283.25426,	168287.86002,	168292.46579,	168297.07157,	168301.67736,	168306.28316,	168310.88897,	168315.49479,	168320.10063,	168324.70647,
168329.31232,	168333.91819,	168338.52406,	168343.12995,	168347.73585,	168352.34176,	168356.94767,	168361.55360,	168366.15954,	168370.76550,
168375.37146,	168379.97743,	168384.58341,	168389.18941,	168393.79541,	168398.40143,	168403.00746,	168407.61349,	168412.21954,	168416.82560,
168421.43167,	168426.03775,	168430.64384,	168435.24994,	168439.85605,	168444.46218,	168449.06831,	168453.67446,	168458.28061,	168462.88678,
168467.49296,	168472.09914,	168476.70534,	168481.31155,	168485.91777,	168490.52400,	168495.13024,	168499.73650,	168504.34276,	168508.94903,
168513.55532,	168518.16161,	168522.76792,	168527.37424,	168531.98056,	168536.58690,	168541.19325,	168545.79961,	168550.40598,	168555.01236,
168559.61876,	168564.22516,	168568.83157,	168573.43800,	168578.04443,	168582.65088,	168587.25733,	168591.86380,	168596.47028,	168601.07677,
168605.68327,	168610.28978,	168614.89630,	168619.50283,	168624.10937,	168628.71593,	168633.32249,	168637.92907,	168642.53565,	168647.14225,
168651.74885,	168656.35547,	168660.96210,	168665.56874,	168670.17539,	168674.78205,	168679.38872,	168683.99540,	168688.60210,	168693.20880,
168697.81552,	168702.42224,	168707.02898,	168711.63572,	168716.24248,	168720.84925,	168725.45603,	168730.06282,	168734.66962,	168739.27643,
168743.88325,	168748.49008,	168753.09693,	168757.70378,	168762.31065,	168766.91752,	168771.52441,	168776.13131,	168780.73821,	168785.34513,
168789.95206,	168794.55900,	168799.16595,	168803.77291,	168808.37989,	168812.98687,	168817.59386,	168822.20087,	168826.80788,	168831.41491,
168836.02194,	168840.62899,	168845.23605,	168849.84312,	168854.45020,	168859.05729,	168863.66439,	168868.27150,	168872.87862,	168877.48576,
168882.09290,	168886.70006,	168891.30722,	168895.91440,	168900.52158,	168905.12878,	168909.73599,	168914.34321,	168918.95044,	168923.55768,
168928.16493,	168932.77219,	168937.37946,	168941.98675,	168946.59404,	168951.20135,	168955.80866,	168960.41599,	168965.02333,	168969.63067,
168974.23803,	168978.84540,	168983.45278,	168988.06017,	168992.66757,	168997.27499,	169001.88241,	169006.48984,	169011.09729,	169015.70474,
169020.31221,	169024.91968,	169029.52717,	169034.13467,	169038.74218,	169043.34970,	169047.95723,	169052.56477,	169057.17232,	169061.77988,
169066.38745,	169070.99504,	169075.60263,	169080.21024,	169084.81785,	169089.42548,	169094.03312,	169098.64077,	169103.24842,	169107.85609,
169112.46377,	169117.07146,	169121.67917,	169126.28688,	169130.89460,	169135.50234,	169140.11008,	169144.71783,	169149.32560,	169153.93338,
169158.54116,	169163.14896,	169167.75677,	169172.36459,	169176.97242,	169181.58026,	169186.18811,	169190.79598,	169195.40385,	169200.01173,
169204.61963,	169209.22753,	169213.83545,	169218.44337,	169223.05131,	169227.65926,	169232.26722,	169236.87519,	169241.48317,	169246.09116,
169250.69916,	169255.30717,	169259.91520,	169264.52323,	169269.13127,	169273.73933,	169278.34740,	169282.95547,	169287.56356,	169292.17166,
169296.77977,	169301.38788,	169305.99601,	169310.60416,	169315.21231,	169319.82047,	169324.42864,	169329.03683,	169333.64502,	169338.25323,
169342.86144,	169347.46967,	169352.07790,	169356.68615,	169361.29441,	169365.90268,	169370.51096,	169375.11925,	169379.72755,	169384.33586,
169388.94419,	169393.55252,	169398.16086,	169402.76922,	169407.37758,	169411.98596,	169416.59435,	169421.20275,	169425.81115,	169430.41957,
169435.02800,	169439.63644,	169444.24489,	169448.85336,	169453.46183,	169458.07031,	169462.67881,	169467.28731,	169471.89583,	169476.50435,
169481.11289,	169485.72144,	169490.32999,	169494.93856,	169499.54714,	169504.15573,	169508.76433,	169513.37295,	169517.98157,	169522.59020,
169527.19884,	169531.80750,	169536.41616,	169541.02484,	169545.63353,	169550.24222,	169554.85093,	169559.45965,	169564.06838,	169568.67712,
169573.28587,	169577.89463,	169582.50340,	169587.11219,	169591.72098,	169596.32978,	169600.93860,	169605.54742,	169610.15626,	169614.76511,
169619.37396,	169623.98283,	169628.59171,	169633.20060,	169637.80950,	169642.41841,	169647.02733,	169651.63626,	169656.24521,	169660.85416,
169665.46313,	169670.07210,	169674.68109,	169679.29008,	169683.89909,	169688.50811,	169693.11714,	169697.72618,	169702.33523,	169706.94429,
169711.55336,	169716.16244,	169720.77153,	169725.38064,	169729.98975,	169734.59887,	169739.20801,	169743.81716,	169748.42631,	169753.03548,
169757.64466,	169762.25385,	169766.86305,	169771.47226,	169776.08148,	169780.69071,	169785.29995,	169789.90920,	169794.51847,	169799.12774,
169803.73703,	169808.34632,	169812.95563,	169817.56494,	169822.17427,	169826.78361,	169831.39296,	169836.00232,	169840.61169,	169845.22107,
169849.83046,	169854.43986,	169859.04928,	169863.65870,	169868.26813,	169872.87758,	169877.48704,	169882.09650,	169886.70598,	169891.31547,
169895.92496,	169900.53447,	169905.14399,	169909.75352,	169914.36306,	169918.97262,	169923.58218,	169928.19175,	169932.80134,	169937.41093,
169942.02054,	169946.63015,	169951.23978,	169955.84941,	169960.45906,	169965.06872,	169969.67839,	169974.28807,	169978.89776,	169983.50746,
169988.11717,	169992.72690,	169997.33663,	170001.94637,	170006.55613,	170011.16589,	170015.77567,	170020.38545,	170024.99525,	170029.60506,
170034.21488,	170038.82471,	170043.43455,	170048.04440,	170052.65426,	170057.26413,	170061.87401,	170066.48390,	170071.09381,	170075.70372,
170080.31365,	170084.92358,	170089.53353,	170094.14349,	170098.75345,	170103.36343,	170107.97342,	170112.58342,	170117.19343,	170121.80345,
170126.41349,	170131.02353,	170135.63358,	170140.24364,	170144.85372,	170149.46380,	170154.07390,	170158.68401,	170163.29412,	170167.90425,
170172.51439,	170177.12454,	170181.73470,	170186.34487,	170190.95505,	170195.56524,	170200.17544,	170204.78565,	170209.39588,	170214.00611,
170218.61636,	170223.22661,	170227.83688,	170232.44716,	170237.05744,	170241.66774,	170246.27805,	170250.88837,	170255.49870,	170260.10904,
170264.71939,	170269.32975,	170273.94013,	170278.55051,	170283.16090,	170287.77131,	170292.38172,	170296.99215,	170301.60259,	170306.21303,
170310.82349,	170315.43396,	170320.04444,	170324.65493,	170329.26543,	170333.87594,	170338.48646,	170343.09699,	170347.70754,	170352.31809,
170356.92866,	170361.53923,	170366.14982,	170370.76041,	170375.37102,	170379.98164,	170384.59226,	170389.20290,	170393.81355,	170398.42421,
170403.03488,	170407.64557,	170412.25626,	170416.86696,	170421.47767,	170426.08840,	170430.69913,	170435.30988,	170439.92063,	170444.53140,
170449.14218,	170453.75297,	170458.36376,	170462.97457,	170467.58539,	170472.19622,	170476.80706,	170481.41792,	170486.02878,	170490.63965,
170495.25054,	170499.86143,	170504.47233,	170509.08325,	170513.69418,	170518.30511,	170522.91606,	170527.52702,	170532.13799,	170536.74897,
170541.35996,	170545.97096,	170550.58197,	170555.19299,	170559.80402,	170564.41507,	170569.02612,	170573.63718,	170578.24826,	170582.85935,
170587.47044,	170592.08155,	170596.69267,	170601.30379,	170605.91493,	170610.52608,	170615.13724,	170619.74841,	170624.35960,	170628.97079,
170633.58199,	170638.19320,	170642.80443,	170647.41566,	170652.02691,	170656.63816,	170661.24943,	170665.86071,	170670.47199,	170675.08329,
170679.69460,	170684.30592,	170688.91725,	170693.52859,	170698.13994,	170702.75131,	170707.36268,	170711.97406,	170716.58546,	170721.19686,
170725.80828,	170730.41970,	170735.03114,	170739.64259,	170744.25404,	170748.86551,	170753.47699,	170758.08848,	170762.69998,	170767.31149,
170771.92301,	170776.53455,	170781.14609,	170785.75764,	170790.36921,	170794.98078,	170799.59237,	170804.20396,	170808.81557,	170813.42718,
170818.03881,	170822.65045,	170827.26210,	170831.87376,	170836.48543,	170841.09711,	170845.70880,	170850.32050,	170854.93222,	170859.54394,
170864.15567,	170868.76742,	170873.37917,	170877.99094,	170882.60272,	170887.21450,	170891.82630,	170896.43811,	170901.04993,	170905.66176,
170910.27360,	170914.88545,	170919.49731,	170924.10918,	170928.72106,	170933.33296,	170937.94486,	170942.55678,	170947.16870,	170951.78064,
170956.39258,	170961.00454,	170965.61651,	170970.22848,	170974.84047,	170979.45247,	170984.06448,	170988.67650,	170993.28853,	170997.90058,
171002.51263,	171007.12469,	171011.73676,	171016.34885,	171020.96094,	171025.57305,	171030.18517,	171034.79729,	171039.40943,	171044.02158,
171048.63374,	171053.24590,	171057.85808,	171062.47027,	171067.08248,	171071.69469,	171076.30691,	171080.91914,	171085.53138,	171090.14364,
171094.75590,	171099.36818,	171103.98046,	171108.59276,	171113.20507,	171117.81738,	171122.42971,	171127.04205,	171131.65440,	171136.26676,
171140.87913,	171145.49151,	171150.10390,	171154.71631,	171159.32872,	171163.94114,	171168.55358,	171173.16602,	171177.77848,	171182.39094,
171187.00342,	171191.61591,	171196.22840,	171200.84091,	171205.45343,	171210.06596,	171214.67850,	171219.29105,	171223.90361,	171228.51619,
171233.12877,	171237.74136,	171242.35397,	171246.96658,	171251.57920,	171256.19184,	171260.80449,	171265.41714,	171270.02981,	171274.64249,
171279.25518,	171283.86788,	171288.48059,	171293.09331,	171297.70604,	171302.31878,	171306.93153,	171311.54429,	171316.15707,	171320.76985,
171325.38264,	171329.99545,	171334.60827,	171339.22109,	171343.83393,	171348.44678,	171353.05963,	171357.67250,	171362.28538,	171366.89827,
171371.51117,	171376.12408,	171380.73700,	171385.34994,	171389.96288,	171394.57583,	171399.18880,	171403.80177,	171408.41476,	171413.02775,
171417.64076,	171422.25377,	171426.86680,	171431.47984,	171436.09289,	171440.70595,	171445.31902,	171449.93210,	171454.54519,	171459.15829,
171463.77140,	171468.38453,	171472.99766,	171477.61080,	171482.22396,	171486.83712,	171491.45030,	171496.06348,	171500.67668,	171505.28989,
171509.90311,	171514.51633,	171519.12957,	171523.74282,	171528.35608,	171532.96935,	171537.58264,	171542.19593,	171546.80923,	171551.42254,
171556.03587,	171560.64920,	171565.26255,	171569.87590,	171574.48927,	171579.10264,	171583.71603,	171588.32943,	171592.94284,	171597.55626,
171602.16969,	171606.78313,	171611.39658,	171616.01004,	171620.62351,	171625.23699,	171629.85049,	171634.46399,	171639.07750,	171643.69103,
171648.30456,	171652.91811,	171657.53167,	171662.14523,	171666.75881,	171671.37240,	171675.98600,	171680.59961,	171685.21323,	171689.82686,
171694.44050,	171699.05415,	171703.66781,	171708.28148,	171712.89517,	171717.50886,	171722.12257,	171726.73628,	171731.35001,	171735.96374,
171740.57749,	171745.19125,	171749.80501,	171754.41879,	171759.03258,	171763.64638,	171768.26019,	171772.87401,	171777.48784,	171782.10168,
171786.71554,	171791.32940,	171795.94327,	171800.55716,	171805.17105,	171809.78496,	171814.39887,	171819.01280,	171823.62674,	171828.24068,
171832.85464,	171837.46861,	171842.08259,	171846.69658,	171851.31058,	171855.92459,	171860.53861,	171865.15264,	171869.76669,	171874.38074,
171878.99480,	171883.60888,	171888.22296,	171892.83706,	171897.45116,	171902.06528,	171906.67941,	171911.29354,	171915.90769,	171920.52185,
171925.13602,	171929.75020,	171934.36439,	171938.97859,	171943.59280,	171948.20703,	171952.82126,	171957.43550,	171962.04976,	171966.66402,
171971.27829,	171975.89258,	171980.50688,	171985.12118,	171989.73550,	171994.34983,	171998.96416,	172003.57851,	172008.19287,	172012.80724,
172017.42162,	172022.03601,	172026.65042,	172031.26483,	172035.87925,	172040.49368,	172045.10813,	172049.72258,	172054.33705,	172058.95152,
172063.56601,	172068.18050,	172072.79501,	172077.40953,	172082.02406,	172086.63860,	172091.25314,	172095.86770,	172100.48227,	172105.09686,
172109.71145,	172114.32605,	172118.94066,	172123.55528,	172128.16992,	172132.78456,	172137.39922,	172142.01388,	172146.62856,	172151.24324,
172155.85794,	172160.47265,	172165.08737,	172169.70210,	172174.31683,	172178.93158,	172183.54634,	172188.16111,	172192.77590,	172197.39069,
172202.00549,	172206.62030,	172211.23513,	172215.84996,	172220.46480,	172225.07966,	172229.69453,	172234.30940,	172238.92429,	172243.53919,
172248.15409,	172252.76901,	172257.38394,	172261.99888,	172266.61383,	172271.22879,	172275.84376,	172280.45874,	172285.07373,	172289.68874,
172294.30375,	172298.91877,	172303.53381,	172308.14885,	172312.76391,	172317.37897,	172321.99405,	172326.60914,	172331.22424,	172335.83934,
172340.45446,	172345.06959,	172349.68473,	172354.29988,	172358.91504,	172363.53021,	172368.14539,	172372.76059,	172377.37579,	172381.99100,
172386.60623,	172391.22146,	172395.83671,	172400.45196,	172405.06723,	172409.68250,	172414.29779,	172418.91309,	172423.52840,	172428.14372,
172432.75904,	172437.37438,	172441.98973,	172446.60510,	172451.22047,	172455.83585,	172460.45124,	172465.06664,	172469.68206,	172474.29748,
172478.91292,	172483.52836,	172488.14382,	172492.75928,	172497.37476,	172501.99025,	172506.60574,	172511.22125,	172515.83677,	172520.45230,
172525.06784,	172529.68339,	172534.29895,	172538.91452,	172543.53010,	172548.14570,	172552.76130,	172557.37691,	172561.99254,	172566.60817,
172571.22382,	172575.83947,	172580.45514,	172585.07081,	172589.68650,	172594.30220,	172598.91791,	172603.53363,	172608.14935,	172612.76509,
172617.38084,	172621.99660,	172626.61238,	172631.22816,	172635.84395,	172640.45975,	172645.07557,	172649.69139,	172654.30722,	172658.92307,
172663.53892,	172668.15479,	172672.77067,	172677.38655,	172682.00245,	172686.61836,	172691.23428,	172695.85021,	172700.46615,	172705.08210,
172709.69806,	172714.31403,	172718.93001,	172723.54600,	172728.16200,	172732.77802,	172737.39404,	172742.01008,	172746.62612,	172751.24218,
172755.85824,	172760.47432,	172765.09040,	172769.70650,	172774.32261,	172778.93873,	172783.55486,	172788.17100,	172792.78715,	172797.40331,
172802.01948,	172806.63566,	172811.25185,	172815.86805,	172820.48426,	172825.10049,	172829.71672,	172834.33297,	172838.94922,	172843.56549,
172848.18176,	172852.79805,	172857.41435,	172862.03065,	172866.64697,	172871.26330,	172875.87964,	172880.49599,	172885.11235,	172889.72872,
172894.34510,	172898.96149,	172903.57789,	172908.19431,	172912.81073,	172917.42716,	172922.04361,	172926.66006,	172931.27653,	172935.89300,
172940.50949,	172945.12598,	172949.74249,	172954.35901,	172958.97554,	172963.59207,	172968.20862,	172972.82518,	172977.44175,	172982.05833,
172986.67492,	172991.29153,	172995.90814,	173000.52476,	173005.14139,	173009.75804,	173014.37469,	173018.99136,	173023.60803,	173028.22472,
173032.84141,	173037.45812,	173042.07484,	173046.69156,	173051.30830,	173055.92505,	173060.54181,	173065.15858,	173069.77536,	173074.39215,
173079.00895,	173083.62576,	173088.24258,	173092.85942,	173097.47626,	173102.09311,	173106.70998,	173111.32685,	173115.94374,	173120.56063,
173125.17754,	173129.79445,	173134.41138,	173139.02832,	173143.64527,	173148.26222,	173152.87919,	173157.49617,	173162.11316,	173166.73016,
173171.34717,	173175.96419,	173180.58123,	173185.19827,	173189.81532,	173194.43238,	173199.04946,	173203.66654,	173208.28364,	173212.90074,
173217.51786,	173222.13498,	173226.75212,	173231.36927,	173235.98643,	173240.60359,	173245.22077,	173249.83796,	173254.45516,	173259.07237,
173263.68959,	173268.30682,	173272.92407,	173277.54132,	173282.15858,	173286.77585,	173291.39314,	173296.01043,	173300.62773,	173305.24505,
173309.86237,	173314.47971,	173319.09706,	173323.71441,	173328.33178,	173332.94916,	173337.56655,	173342.18395,	173346.80136,	173351.41878,
173356.03621,	173360.65365,	173365.27110,	173369.88856,	173374.50603,	173379.12351,	173383.74101,	173388.35851,	173392.97602,	173397.59355,
173402.21108,	173406.82863,	173411.44619,	173416.06375,	173420.68133,	173425.29892,	173429.91651,	173434.53412,	173439.15174,	173443.76937,
173448.38701,	173453.00466,	173457.62232,	173462.23999,	173466.85767,	173471.47537,	173476.09307,	173480.71078,	173485.32851,	173489.94624,
173494.56398,	173499.18174,	173503.79950,	173508.41728,	173513.03507,	173517.65286,	173522.27067,	173526.88849,	173531.50632,	173536.12416,
173540.74201,	173545.35987,	173549.97774,	173554.59562,	173559.21351,	173563.83141,	173568.44932,	173573.06724,	173577.68518,	173582.30312,
173586.92107,	173591.53904,	173596.15701,	173600.77500,	173605.39299,	173610.01100,	173614.62902,	173619.24704,	173623.86508,	173628.48313,
173633.10119,	173637.71926,	173642.33734,	173646.95543,	173651.57353,	173656.19164,	173660.80976,	173665.42789,	173670.04603,	173674.66419,
173679.28235,	173683.90052,	173688.51871,	173693.13690,	173697.75511,	173702.37332,	173706.99155,	173711.60978,	173716.22803,	173720.84629,
173725.46456,	173730.08283,	173734.70112,	173739.31942,	173743.93773,	173748.55605,	173753.17438,	173757.79272,	173762.41108,	173767.02944,
173771.64781,	173776.26619,	173780.88459,	173785.50299,	173790.12140,	173794.73983,	173799.35826,	173803.97671,	173808.59517,	173813.21363,
173817.83211,	173822.45060,	173827.06909,	173831.68760,	173836.30612,	173840.92465,	173845.54319,	173850.16174,	173854.78030,	173859.39887,
173864.01745,	173868.63605,	173873.25465,	173877.87326,	173882.49188,	173887.11052,	173891.72916,	173896.34782,	173900.96648,	173905.58516,
173910.20384,	173914.82254,	173919.44125,	173924.05996,	173928.67869,	173933.29743,	173937.91618,	173942.53494,	173947.15371,	173951.77249,
173956.39128,	173961.01008,	173965.62889,	173970.24771,	173974.86654,	173979.48539,	173984.10424,	173988.72310,	173993.34198,	173997.96086,
174002.57976,	174007.19866,	174011.81758,	174016.43650,	174021.05544,	174025.67439,	174030.29335,	174034.91231,	174039.53129,	174044.15028,
174048.76928,	174053.38829,	174058.00731,	174062.62634,	174067.24538,	174071.86443,	174076.48350,	174081.10257,	174085.72165,	174090.34074,
174094.95985,	174099.57896,	174104.19809,	174108.81722,	174113.43637,	174118.05552,	174122.67469,	174127.29387,	174131.91305,	174136.53225,
174141.15146,	174145.77068,	174150.38991,	174155.00915,	174159.62840,	174164.24766,	174168.86693,	174173.48621,	174178.10550,	174182.72480,
174187.34412,	174191.96344,	174196.58277,	174201.20212,	174205.82147,	174210.44083,	174215.06021,	174219.67960,	174224.29899,	174228.91840,
174233.53781,	174238.15724,	174242.77668,	174247.39613,	174252.01559,	174256.63506,	174261.25453,	174265.87402,	174270.49352,	174275.11304,
174279.73256,	174284.35209,	174288.97163,	174293.59118,	174298.21075,	174302.83032,	174307.44990,	174312.06950,	174316.68910,	174321.30872,
174325.92834,	174330.54798,	174335.16762,	174339.78728,	174344.40695,	174349.02663,	174353.64631,	174358.26601,	174362.88572,	174367.50544,
174372.12517,	174376.74491,	174381.36466,	174385.98442,	174390.60419,	174395.22397,	174399.84377,	174404.46357,	174409.08338,	174413.70321,
174418.32304,	174422.94288,	174427.56274,	174432.18260,	174436.80248,	174441.42237,	174446.04226,	174450.66217,	174455.28209,	174459.90201,
174464.52195,	174469.14190,	174473.76186,	174478.38183,	174483.00181,	174487.62180,	174492.24180,	174496.86181,	174501.48183,	174506.10186,
174510.72191,	174515.34196,	174519.96202,	174524.58210,	174529.20218,	174533.82227,	174538.44238,	174543.06249,	174547.68262,	174552.30276,
174556.92290,	174561.54306,	174566.16323,	174570.78340,	174575.40359,	174580.02379,	174584.64400,	174589.26422,	174593.88445,	174598.50469,
174603.12494,	174607.74520,	174612.36547,	174616.98575,	174621.60605,	174626.22635,	174630.84666,	174635.46699,	174640.08732,	174644.70766,
174649.32802,	174653.94838,	174658.56876,	174663.18914,	174667.80954,	174672.42995,	174677.05037,	174681.67079,	174686.29123,	174690.91168,
174695.53214,	174700.15261,	174704.77309,	174709.39358,	174714.01408,	174718.63459,	174723.25511,	174727.87564,	174732.49618,	174737.11674,
174741.73730,	174746.35787,	174750.97846,	174755.59905,	174760.21965,	174764.84027,	174769.46089,	174774.08153,	174778.70218,	174783.32283,
174787.94350,	174792.56418,	174797.18486,	174801.80556,	174806.42627,	174811.04699,	174815.66772,	174820.28846,	174824.90921,	174829.52997,
174834.15074,	174838.77152,	174843.39231,	174848.01311,	174852.63393,	174857.25475,	174861.87558,	174866.49643,	174871.11728,	174875.73815,
174880.35902,	174884.97991,	174889.60080,	174894.22171,	174898.84262,	174903.46355,	174908.08449,	174912.70544,	174917.32639,	174921.94736,
174926.56834,	174931.18933,	174935.81033,	174940.43134,	174945.05236,	174949.67339,	174954.29443,	174958.91548,	174963.53655,	174968.15762,
174972.77870,	174977.39979,	174982.02090,	174986.64201,	174991.26314,	174995.88427,	175000.50542,	175005.12657,	175009.74774,	175014.36891,
175018.99010,	175023.61130,	175028.23250,	175032.85372,	175037.47495,	175042.09619,	175046.71744,	175051.33870,	175055.95997,	175060.58125,
175065.20254,	175069.82384,	175074.44515,	175079.06647,	175083.68780,	175088.30915,	175092.93050,	175097.55186,	175102.17324,	175106.79462,
175111.41602,	175116.03742,	175120.65884,	175125.28026,	175129.90170,	175134.52314,	175139.14460,	175143.76607,	175148.38754,	175153.00903,
175157.63053,	175162.25204,	175166.87356,	175171.49509,	175176.11663,	175180.73818,	175185.35974,	175189.98131,	175194.60289,	175199.22448,
175203.84608,	175208.46770,	175213.08932,	175217.71095,	175222.33260,	175226.95425,	175231.57591,	175236.19759,	175240.81927,	175245.44097,
175250.06268,	175254.68439,	175259.30612,	175263.92785,	175268.54960,	175273.17136,	175277.79313,	175282.41491,	175287.03670,	175291.65849,
175296.28030,	175300.90212,	175305.52395,	175310.14580,	175314.76765,	175319.38951,	175324.01138,	175328.63326,	175333.25515,	175337.87706,
175342.49897,	175347.12089,	175351.74283,	175356.36477,	175360.98673,	175365.60869,	175370.23067,	175374.85265,	175379.47465,	175384.09666,
175388.71867,	175393.34070,	175397.96274,	175402.58479,	175407.20685,	175411.82892,	175416.45099,	175421.07308,	175425.69518,	175430.31729,
175434.93942,	175439.56155,	175444.18369,	175448.80584,	175453.42800,	175458.05017,	175462.67236,	175467.29455,	175471.91675,	175476.53897,
175481.16119,	175485.78343,	175490.40567,	175495.02793,	175499.65019,	175504.27247,	175508.89476,	175513.51705,	175518.13936,	175522.76168,
175527.38401,	175532.00635,	175536.62869,	175541.25105,	175545.87342,	175550.49580,	175555.11819,	175559.74059,	175564.36300,	175568.98543,
175573.60786,	175578.23030,	175582.85275,	175587.47521,	175592.09769,	175596.72017,	175601.34266,	175605.96517,	175610.58768,	175615.21021,
175619.83274,	175624.45529,	175629.07784,	175633.70041,	175638.32299,	175642.94557,	175647.56817,	175652.19078,	175656.81340,	175661.43603,
175666.05866,	175670.68131,	175675.30397,	175679.92664,	175684.54932,	175689.17201,	175693.79471,	175698.41743,	175703.04015,	175707.66288,
175712.28562,	175716.90837,	175721.53114,	175726.15391,	175730.77669,	175735.39949,	175740.02229,	175744.64511,	175749.26793,	175753.89077,
175758.51361,	175763.13647,	175767.75934,	175772.38221,	175777.00510,	175781.62800,	175786.25091,	175790.87383,	175795.49675,	175800.11969,
175804.74264,	175809.36560,	175813.98857,	175818.61155,	175823.23454,	175827.85754,	175832.48056,	175837.10358,	175841.72661,	175846.34965,
175850.97270,	175855.59577,	175860.21884,	175864.84192,	175869.46502,	175874.08812,	175878.71124,	175883.33436,	175887.95750,	175892.58064,
175897.20380,	175901.82697,	175906.45014,	175911.07333,	175915.69653,	175920.31974,	175924.94296,	175929.56618,	175934.18942,	175938.81267,
175943.43593,	175948.05920,	175952.68248,	175957.30577,	175961.92907,	175966.55239,	175971.17571,	175975.79904,	175980.42238,	175985.04573,
175989.66910,	175994.29247,	175998.91585,	176003.53925,	176008.16265,	176012.78607,	176017.40949,	176022.03293,	176026.65637,	176031.27983,
176035.90330,	176040.52677,	176045.15026,	176049.77376,	176054.39726,	176059.02078,	176063.64431,	176068.26785,	176072.89140,	176077.51496,
176082.13853,	176086.76211,	176091.38570,	176096.00930,	176100.63291,	176105.25653,	176109.88016,	176114.50381,	176119.12746,	176123.75112,
176128.37479,	176132.99848,	176137.62217,	176142.24587,	176146.86959,	176151.49331,	176156.11705,	176160.74079,	176165.36455,	176169.98832,
176174.61209,	176179.23588,	176183.85968,	176188.48348,	176193.10730,	176197.73113,	176202.35497,	176206.97882,	176211.60267,	176216.22654,
176220.85042,	176225.47431,	176230.09821,	176234.72212,	176239.34604,	176243.96998,	176248.59392,	176253.21787,	176257.84183,	176262.46580,
176267.08979,	176271.71378,	176276.33778,	176280.96180,	176285.58582,	176290.20986,	176294.83390,	176299.45796,	176304.08202,	176308.70610,
176313.33018,	176317.95428,	176322.57839,	176327.20250,	176331.82663,	176336.45077,	176341.07492,	176345.69907,	176350.32324,	176354.94742,
176359.57161,	176364.19581,	176368.82002,	176373.44424,	176378.06847,	176382.69271,	176387.31696,	176391.94122,	176396.56550,	176401.18978,
176405.81407,	176410.43837,	176415.06269,	176419.68701,	176424.31134,	176428.93569,	176433.56004,	176438.18441,	176442.80878,	176447.43317,
176452.05756,	176456.68197,	176461.30638,	176465.93081,	176470.55525,	176475.17969,	176479.80415,	176484.42862,	176489.05310,	176493.67759,
176498.30208,	176502.92659,	176507.55111,	176512.17564,	176516.80018,	176521.42473,	176526.04929,	176530.67386,	176535.29845,	176539.92304,
176544.54764,	176549.17225,	176553.79687,	176558.42151,	176563.04615,	176567.67080,	176572.29547,	176576.92014,	176581.54482,	176586.16952,
176590.79422,	176595.41894,	176600.04366,	176604.66840,	176609.29315,	176613.91790,	176618.54267,	176623.16745,	176627.79223,	176632.41703,
176637.04184,	176641.66666,	176646.29149,	176650.91632,	176655.54117,	176660.16603,	176664.79090,	176669.41578,	176674.04067,	176678.66557,
176683.29048,	176687.91541,	176692.54034,	176697.16528,	176701.79023,	176706.41519,	176711.04017,	176715.66515,	176720.29014,	176724.91515,
176729.54016,	176734.16518,	176738.79022,	176743.41526,	176748.04032,	176752.66538,	176757.29046,	176761.91555,	176766.54064,	176771.16575,
176775.79086,	176780.41599,	176785.04113,	176789.66628,	176794.29144,	176798.91660,	176803.54178,	176808.16697,	176812.79217,	176817.41738,
176822.04260,	176826.66783,	176831.29307,	176835.91832,	176840.54358,	176845.16885,	176849.79413,	176854.41943,	176859.04473,	176863.67004,
176868.29536,	176872.92070,	176877.54604,	176882.17139,	176886.79676,	176891.42213,	176896.04752,	176900.67291,	176905.29832,	176909.92373,
176914.54916,	176919.17459,	176923.80004,	176928.42550,	176933.05096,	176937.67644,	176942.30193,	176946.92742,	176951.55293,	176956.17845,
176960.80398,	176965.42952,	176970.05507,	176974.68063,	176979.30620,	176983.93178,	176988.55737,	176993.18297,	176997.80858,	177002.43420,
177007.05983,	177011.68547,	177016.31112,	177020.93679,	177025.56246,	177030.18814,	177034.81383,	177039.43954,	177044.06525,	177048.69098,
177053.31671,	177057.94245,	177062.56821,	177067.19397,	177071.81975,	177076.44553,	177081.07133,	177085.69714,	177090.32295,	177094.94878,
177099.57462,	177104.20046,	177108.82632,	177113.45219,	177118.07807,	177122.70396,	177127.32985,	177131.95576,	177136.58168,	177141.20761,
177145.83355,	177150.45950,	177155.08546,	177159.71143,	177164.33741,	177168.96341,	177173.58941,	177178.21542,	177182.84144,	177187.46747,
177192.09352,	177196.71957,	177201.34563,	177205.97170,	177210.59779,	177215.22388,	177219.84999,	177224.47610,	177229.10223,	177233.72836,
177238.35451,	177242.98066,	177247.60683,	177252.23300,	177256.85919,	177261.48539,	177266.11159,	177270.73781,	177275.36404,	177279.99027,
177284.61652,	177289.24278,	177293.86905,	177298.49533,	177303.12162,	177307.74792,	177312.37423,	177317.00055,	177321.62688,	177326.25322,
177330.87957,	177335.50593,	177340.13230,	177344.75868,	177349.38507,	177354.01147,	177358.63789,	177363.26431,	177367.89074,	177372.51718,
177377.14364,	177381.77010,	177386.39658,	177391.02306,	177395.64955,	177400.27606,	177404.90257,	177409.52910,	177414.15563,	177418.78218,
177423.40874,	177428.03530,	177432.66188,	177437.28846,	177441.91506,	177446.54167,	177451.16829,	177455.79491,	177460.42155,	177465.04820,
177469.67486,	177474.30153,	177478.92821,	177483.55490,	177488.18160,	177492.80831,	177497.43503,	177502.06176,	177506.68850,	177511.31525,
177515.94201,	177520.56878,	177525.19556,	177529.82235,	177534.44916,	177539.07597,	177543.70279,	177548.32962,	177552.95647,	177557.58332,
177562.21018,	177566.83706,	177571.46394,	177576.09084,	177580.71774,	177585.34466,	177589.97158,	177594.59852,	177599.22546,	177603.85242,
177608.47938,	177613.10636,	177617.73335,	177622.36034,	177626.98735,	177631.61437,	177636.24140,	177640.86843,	177645.49548,	177650.12254,
177654.74961,	177659.37669,	177664.00378,	177668.63088,	177673.25799,	177677.88511,	177682.51224,	177687.13938,	177691.76653,	177696.39369,
177701.02086,	177705.64804,	177710.27523,	177714.90244,	177719.52965,	177724.15687,	177728.78410,	177733.41135,	177738.03860,	177742.66586,
177747.29314,	177751.92042,	177756.54771,	177761.17502,	177765.80233,	177770.42966,	177775.05699,	177779.68434,	177784.31169,	177788.93906,
177793.56644,	177798.19382,	177802.82122,	177807.44863,	177812.07604,	177816.70347,	177821.33091,	177825.95836,	177830.58581,	177835.21328,
177839.84076,	177844.46825,	177849.09575,	177853.72326,	177858.35078,	177862.97831,	177867.60585,	177872.23340,	177876.86096,	177881.48853,
177886.11611,	177890.74370,	177895.37130,	177899.99891,	177904.62654,	177909.25417,	177913.88181,	177918.50946,	177923.13712,	177927.76480,
177932.39248,	177937.02017,	177941.64788,	177946.27559,	177950.90332,	177955.53105,	177960.15880,	177964.78655,	177969.41432,	177974.04209,
177978.66988,	177983.29767,	177987.92548,	177992.55330,	177997.18112,	178001.80896,	178006.43681,	178011.06466,	178015.69253,	178020.32041,
178024.94830,	178029.57619,	178034.20410,	178038.83202,	178043.45995,	178048.08789,	178052.71584,	178057.34380,	178061.97177,	178066.59975,
178071.22774,	178075.85574,	178080.48375,	178085.11177,	178089.73980,	178094.36784,	178098.99589,	178103.62396,	178108.25203,	178112.88011,
178117.50820,	178122.13630,	178126.76442,	178131.39254,	178136.02067,	178140.64882,	178145.27697,	178149.90514,	178154.53331,	178159.16149,
178163.78969,	178168.41789,	178173.04611,	178177.67434,	178182.30257,	178186.93082,	178191.55907,	178196.18734,	178200.81562,	178205.44390,
178210.07220,	178214.70051,	178219.32882,	178223.95715,	178228.58549,	178233.21384,	178237.84220,	178242.47056,	178247.09894,	178251.72733,
178256.35573,	178260.98414,	178265.61256,	178270.24099,	178274.86943,	178279.49788,	178284.12634,	178288.75481,	178293.38329,	178298.01178,
178302.64028,	178307.26880,	178311.89732,	178316.52585,	178321.15439,	178325.78294,	178330.41151,	178335.04008,	178339.66866,	178344.29726,
178348.92586,	178353.55447,	178358.18310,	178362.81173,	178367.44038,	178372.06903,	178376.69769,	178381.32637,	178385.95505,	178390.58375,
178395.21246,	178399.84117,	178404.46990,	178409.09863,	178413.72738,	178418.35614,	178422.98490,	178427.61368,	178432.24247,	178436.87127,
178441.50007,	178446.12889,	178450.75772,	178455.38656,	178460.01541,	178464.64426,	178469.27313,	178473.90201,	178478.53090,	178483.15980,
178487.78871,	178492.41763,	178497.04656,	178501.67550,	178506.30445,	178510.93341,	178515.56238,	178520.19137,	178524.82036,	178529.44936,
178534.07837,	178538.70739,	178543.33642,	178547.96547,	178552.59452,	178557.22358,	178561.85266,	178566.48174,	178571.11083,	178575.73994,
178580.36905,	178584.99817,	178589.62731,	178594.25645,	178598.88561,	178603.51477,	178608.14395,	178612.77313,	178617.40233,	178622.03153,
178626.66075,	178631.28998,	178635.91921,	178640.54846,	178645.17771,	178649.80698,	178654.43626,	178659.06555,	178663.69484,	178668.32415,
178672.95347,	178677.58280,	178682.21214,	178686.84148,	178691.47084,	178696.10021,	178700.72959,	178705.35898,	178709.98838,	178714.61779,
178719.24721,	178723.87664,	178728.50608,	178733.13553,	178737.76499,	178742.39446,	178747.02394,	178751.65343,	178756.28293,	178760.91244,
178765.54197,	178770.17150,	178774.80104,	178779.43059,	178784.06016,	178788.68973,	178793.31931,	178797.94890,	178802.57851,	178807.20812,
178811.83774,	178816.46738,	178821.09702,	178825.72668,	178830.35634,	178834.98602,	178839.61570,	178844.24540,	178848.87510,	178853.50482,
178858.13454,	178862.76428,	178867.39402,	178872.02378,	178876.65355,	178881.28332,	178885.91311,	178890.54291,	178895.17271,	178899.80253,
178904.43236,	178909.06219,	178913.69204,	178918.32190,	178922.95177,	178927.58165,	178932.21153,	178936.84143,	178941.47134,	178946.10126,
178950.73119,	178955.36113,	178959.99108,	178964.62104,	178969.25101,	178973.88099,	178978.51098,	178983.14098,	178987.77099,	178992.40101,
178997.03104,	179001.66108,	179006.29114,	179010.92120,	179015.55127,	179020.18135,	179024.81144,	179029.44154,	179034.07166,	179038.70178,
179043.33191,	179047.96206,	179052.59221,	179057.22237,	179061.85255,	179066.48273,	179071.11292,	179075.74313,	179080.37334,	179085.00357,
179089.63380,	179094.26405,	179098.89430,	179103.52457,	179108.15484,	179112.78513,	179117.41542,	179122.04573,	179126.67604,	179131.30637,
179135.93671,	179140.56705,	179145.19741,	179149.82778,	179154.45815,	179159.08854,	179163.71894,	179168.34935,	179172.97976,	179177.61019,
179182.24063,	179186.87108,	179191.50154,	179196.13200,	179200.76248,	179205.39297,	179210.02347,	179214.65398,	179219.28450,	179223.91503,
179228.54557,	179233.17612,	179237.80668,	179242.43725,	179247.06783,	179251.69842,	179256.32902,	179260.95963,	179265.59025,	179270.22088,
179274.85153,	179279.48218,	179284.11284,	179288.74351,	179293.37419,	179298.00488,	179302.63559,	179307.26630,	179311.89702,	179316.52776,
179321.15850,	179325.78925,	179330.42002,	179335.05079,	179339.68157,	179344.31237,	179348.94317,	179353.57398,	179358.20481,	179362.83564,
179367.46649,	179372.09734,	179376.72821,	179381.35908,	179385.98997,	179390.62086,	179395.25177,	179399.88269,	179404.51361,	179409.14455,
179413.77549,	179418.40645,	179423.03742,	179427.66839,	179432.29938,	179436.93038,	179441.56138,	179446.19240,	179450.82343,	179455.45447,
179460.08552,	179464.71657,	179469.34764,	179473.97872,	179478.60981,	179483.24091,	179487.87202,	179492.50313,	179497.13426,	179501.76540,
179506.39655,	179511.02771,	179515.65888,	179520.29006,	179524.92125,	179529.55245,	179534.18366,	179538.81488,	179543.44611,	179548.07735,
179552.70860,	179557.33987,	179561.97114,	179566.60242,	179571.23371,	179575.86501,	179580.49632,	179585.12765,	179589.75898,	179594.39032,
179599.02167,	179603.65303,	179608.28441,	179612.91579,	179617.54718,	179622.17859,	179626.81000,	179631.44142,	179636.07286,	179640.70430,
179645.33575,	179649.96722,	179654.59869,	179659.23018,	179663.86167,	179668.49318,	179673.12469,	179677.75622,	179682.38775,	179687.01930,
179691.65085,	179696.28242,	179700.91399,	179705.54558,	179710.17718,	179714.80878,	179719.44040,	179724.07202,	179728.70366,	179733.33531,
179737.96696,	179742.59863,	179747.23031,	179751.86199,	179756.49369,	179761.12540,	179765.75712,	179770.38885,	179775.02058,	179779.65233,
179784.28409,	179788.91586,	179793.54764,	179798.17942,	179802.81122,	179807.44303,	179812.07485,	179816.70668,	179821.33852,	179825.97037,
179830.60223,	179835.23410,	179839.86598,	179844.49787,	179849.12977,	179853.76168,	179858.39360,	179863.02553,	179867.65747,	179872.28942,
179876.92138,	179881.55335,	179886.18534,	179890.81733,	179895.44933,	179900.08134,	179904.71336,	179909.34539,	179913.97744,	179918.60949,
179923.24155,	179927.87362,	179932.50570,	179937.13780,	179941.76990,	179946.40201,	179951.03414,	179955.66627,	179960.29841,	179964.93057,
179969.56273,	179974.19490,	179978.82709,	179983.45928,	179988.09149,	179992.72370,	179997.35592,	180001.98816,	180006.62040,	180011.25266,
180015.88492,	180020.51720,	180025.14948,	180029.78178,	180034.41408,	180039.04640,	180043.67873,	180048.31106,	180052.94341,	180057.57576,
180062.20813,	180066.84051,	180071.47289,	180076.10529,	180080.73770,	180085.37011,	180090.00254,	180094.63498,	180099.26742,	180103.89988,
180108.53235,	180113.16483,	180117.79731,	180122.42981,	180127.06232,	180131.69484,	180136.32736,	180140.95990,	180145.59245,	180150.22501,
180154.85758,	180159.49016,	180164.12275,	180168.75535,	180173.38795,	180178.02057,	180182.65320,	180187.28584,	180191.91849,	180196.55115,
180201.18382,	180205.81650,	180210.44919,	180215.08189,	180219.71460,	180224.34732,	180228.98005,	180233.61279,	180238.24554,	180242.87831,
180247.51108,	180252.14386,	180256.77665,	180261.40945,	180266.04226,	180270.67508,	180275.30791,	180279.94076,	180284.57361,	180289.20647,
180293.83934,	180298.47223,	180303.10512,	180307.73802,	180312.37093,	180317.00386,	180321.63679,	180326.26973,	180330.90268,	180335.53565,
180340.16862,	180344.80160,	180349.43460,	180354.06760,	180358.70061,	180363.33364,	180367.96667,	180372.59972,	180377.23277,	180381.86584,
180386.49891,	180391.13199,	180395.76509,	180400.39819,	180405.03131,	180409.66443,	180414.29757,	180418.93071,	180423.56387,	180428.19703,
180432.83021,	180437.46339,	180442.09659,	180446.72980,	180451.36301,	180455.99624,	180460.62947,	180465.26272,	180469.89598,	180474.52924,
180479.16252,	180483.79581,	180488.42910,	180493.06241,	180497.69573,	180502.32905,	180506.96239,	180511.59574,	180516.22910,	180520.86246,
180525.49584,	180530.12923,	180534.76263,	180539.39603,	180544.02945,	180548.66288,	180553.29632,	180557.92977,	180562.56322,	180567.19669,
180571.83017,	180576.46366,	180581.09716,	180585.73067,	180590.36419,	180594.99772,	180599.63126,	180604.26480,	180608.89836,	180613.53193,
180618.16551,	180622.79910,	180627.43270,	180632.06631,	180636.69993,	180641.33356,	180645.96720,	180650.60085,	180655.23451,	180659.86818,
180664.50186,	180669.13555,	180673.76925,	180678.40297,	180683.03669,	180687.67042,	180692.30416,	180696.93791,	180701.57167,	180706.20544,
180710.83922,	180715.47302,	180720.10682,	180724.74063,	180729.37445,	180734.00828,	180738.64212,	180743.27598,	180747.90984,	180752.54371,
180757.17759,	180761.81149,	180766.44539,	180771.07930,	180775.71322,	180780.34716,	180784.98110,	180789.61505,	180794.24902,	180798.88299,
180803.51697,	180808.15096,	180812.78497,	180817.41898,	180822.05301,	180826.68704,	180831.32108,	180835.95514,	180840.58920,	180845.22327,
180849.85736,	180854.49145,	180859.12556,	180863.75967,	180868.39380,	180873.02793,	180877.66208,	180882.29623,	180886.93039,	180891.56457,
180896.19875,	180900.83295,	180905.46715,	180910.10137,	180914.73560,	180919.36983,	180924.00408,	180928.63833,	180933.27260,	180937.90687,
180942.54116,	180947.17545,	180951.80976,	180956.44408,	180961.07840,	180965.71274,	180970.34708,	180974.98144,	180979.61581,	180984.25018,
180988.88457,	180993.51897,	180998.15337,	181002.78779,	181007.42222,	181012.05665,	181016.69110,	181021.32556,	181025.96003,	181030.59450,
181035.22899,	181039.86349,	181044.49800,	181049.13251,	181053.76704,	181058.40158,	181063.03613,	181067.67068,	181072.30525,	181076.93983,
181081.57442,	181086.20902,	181090.84362,	181095.47824,	181100.11287,	181104.74751,	181109.38216,	181114.01682,	181118.65149,	181123.28616,
181127.92085,	181132.55555,	181137.19026,	181141.82498,	181146.45971,	181151.09445,	181155.72920,	181160.36396,	181164.99873,	181169.63351,
181174.26830,	181178.90309,	181183.53790,	181188.17272,	181192.80755,	181197.44239,	181202.07724,	181206.71210,	181211.34697,	181215.98185,
181220.61674,	181225.25164,	181229.88656,	181234.52148,	181239.15641,	181243.79135,	181248.42630,	181253.06126,	181257.69623,	181262.33121,
181266.96620,	181271.60120,	181276.23621,	181280.87123,	181285.50626,	181290.14131,	181294.77636,	181299.41142,	181304.04649,	181308.68157,
181313.31666,	181317.95176,	181322.58688,	181327.22200,	181331.85713,	181336.49227,	181341.12742,	181345.76258,	181350.39776,	181355.03294,
181359.66813,	181364.30333,	181368.93855,	181373.57377,	181378.20900,	181382.84424,	181387.47949,	181392.11476,	181396.75003,	181401.38531,
181406.02060,	181410.65591,	181415.29122,	181419.92654,	181424.56188,	181429.19722,	181433.83257,	181438.46794,	181443.10331,	181447.73869,
181452.37409,	181457.00949,	181461.64490,	181466.28033,	181470.91576,	181475.55120,	181480.18666,	181484.82212,	181489.45759,	181494.09308,
181498.72857,	181503.36407,	181507.99959,	181512.63511,	181517.27065,	181521.90619,	181526.54174,	181531.17731,	181535.81288,	181540.44847,
181545.08406,	181549.71967,	181554.35528,	181558.99090,	181563.62654,	181568.26218,	181572.89784,	181577.53350,	181582.16918,	181586.80486,
181591.44056,	181596.07626,	181600.71198,	181605.34770,	181609.98344,	181614.61918,	181619.25494,	181623.89070,	181628.52648,	181633.16226,
181637.79806,	181642.43386,	181647.06968,	181651.70550,	181656.34134,	181660.97719,	181665.61304,	181670.24891,	181674.88478,	181679.52067,
181684.15656,	181688.79247,	181693.42838,	181698.06431,	181702.70025,	181707.33619,	181711.97215,	181716.60811,	181721.24409,	181725.88008,
181730.51607,	181735.15208,	181739.78810,	181744.42412,	181749.06016,	181753.69620,	181758.33226,	181762.96833,	181767.60440,	181772.24049,
181776.87659,	181781.51269,	181786.14881,	181790.78494,	181795.42107,	181800.05722,	181804.69338,	181809.32954,	181813.96572,	181818.60191,
181823.23810,	181827.87431,	181832.51053,	181837.14676,	181841.78299,	181846.41924,	181851.05550,	181855.69176,	181860.32804,	181864.96433,
181869.60063,	181874.23693,	181878.87325,	181883.50958,	181888.14592,	181892.78226,	181897.41862,	181902.05499,	181906.69137,	181911.32775,
181915.96415,	181920.60056,	181925.23698,	181929.87340,	181934.50984,	181939.14629,	181943.78275,	181948.41921,	181953.05569,	181957.69218,
181962.32868,	181966.96519,	181971.60170,	181976.23823,	181980.87477,	181985.51132,	181990.14788,	181994.78444,	181999.42102,	182004.05761,
182008.69421,	182013.33082,	182017.96744,	182022.60406,	182027.24070,	182031.87735,	182036.51401,	182041.15068,	182045.78736,	182050.42404,
182055.06074,	182059.69745,	182064.33417,	182068.97090,	182073.60764,	182078.24439,	182082.88114,	182087.51791,	182092.15469,	182096.79148,
182101.42828,	182106.06509,	182110.70191,	182115.33874,	182119.97557,	182124.61242,	182129.24928,	182133.88615,	182138.52303,	182143.15992,
182147.79682,	182152.43373,	182157.07065,	182161.70757,	182166.34451,	182170.98146,	182175.61842,	182180.25539,	182184.89237,	182189.52936,
182194.16636,	182198.80337,	182203.44039,	182208.07741,	182212.71445,	182217.35150,	182221.98856,	182226.62563,	182231.26271,	182235.89980,
182240.53690,	182245.17401,	182249.81113,	182254.44826,	182259.08540,	182263.72255,	182268.35971,	182272.99688,	182277.63405,	182282.27124,
182286.90844,	182291.54565,	182296.18287,	182300.82010,	182305.45734,	182310.09459,	182314.73185,	182319.36912,	182324.00640,	182328.64369,
182333.28099,	182337.91830,	182342.55562,	182347.19295,	182351.83029,	182356.46764,	182361.10500,	182365.74237,	182370.37975,	182375.01713,
182379.65453,	182384.29194,	182388.92936,	182393.56679,	182398.20423,	182402.84168,	182407.47914,	182412.11661,	182416.75409,	182421.39158,
182426.02908,	182430.66659,	182435.30411,	182439.94164,	182444.57918,	182449.21673,	182453.85429,	182458.49186,	182463.12944,	182467.76703,
182472.40463,	182477.04224,	182481.67986,	182486.31749,	182490.95513,	182495.59278,	182500.23044,	182504.86811,	182509.50579,	182514.14348,
182518.78118,	182523.41889,	182528.05661,	182532.69434,	182537.33208,	182541.96983,	182546.60759,	182551.24536,	182555.88314,	182560.52093,
182565.15873,	182569.79654,	182574.43436,	182579.07219,	182583.71002,	182588.34787,	182592.98573,	182597.62360,	182602.26148,	182606.89937,
182611.53727,	182616.17518,	182620.81310,	182625.45103,	182630.08897,	182634.72692,	182639.36488,	182644.00285,	182648.64083,	182653.27882,
182657.91682,	182662.55483,	182667.19285,	182671.83088,	182676.46892,	182681.10697,	182685.74503,	182690.38310,	182695.02118,	182699.65927,
182704.29737,	182708.93548,	182713.57360,	182718.21173,	182722.84987,	182727.48802,	182732.12618,	182736.76435,	182741.40253,	182746.04072,
182750.67892,	182755.31713,	182759.95535,	182764.59357,	182769.23181,	182773.87006,	182778.50832,	182783.14659,	182787.78487,	182792.42316,
182797.06146,	182801.69977,	182806.33809,	182810.97642,	182815.61476,	182820.25311,	182824.89147,	182829.52984,	182834.16822,	182838.80661,
182843.44501,	182848.08342,	182852.72184,	182857.36026,	182861.99870,	182866.63715,	182871.27561,	182875.91408,	182880.55256,	182885.19105,
182889.82955,	182894.46806,	182899.10658,	182903.74511,	182908.38365,	182913.02220,	182917.66075,	182922.29932,	182926.93790,	182931.57649,
182936.21509,	182940.85370,	182945.49232,	182950.13095,	182954.76959,	182959.40824,	182964.04689,	182968.68556,	182973.32424,	182977.96293,
182982.60163,	182987.24034,	182991.87906,	182996.51779,	183001.15653,	183005.79527,	183010.43403,	183015.07280,	183019.71158,	183024.35037,
183028.98917,	183033.62798,	183038.26680,	183042.90562,	183047.54446,	183052.18331,	183056.82217,	183061.46104,	183066.09992,	183070.73880,
183075.37770,	183080.01661,	183084.65553,	183089.29446,	183093.93340,	183098.57234,	183103.21130,	183107.85027,	183112.48925,	183117.12824,
183121.76724,	183126.40624,	183131.04526,	183135.68429,	183140.32333,	183144.96238,	183149.60143,	183154.24050,	183158.87958,	183163.51867,
183168.15777,	183172.79687,	183177.43599,	183182.07512,	183186.71426,	183191.35340,	183195.99256,	183200.63173,	183205.27091,	183209.91009,
183214.54929,	183219.18850,	183223.82772,	183228.46694,	183233.10618,	183237.74543,	183242.38469,	183247.02395,	183251.66323,	183256.30252,
183260.94182,	183265.58112,	183270.22044,	183274.85977,	183279.49910,	183284.13845,	183288.77781,	183293.41717,	183298.05655,	183302.69594,
183307.33534,	183311.97474,	183316.61416,	183321.25359,	183325.89302,	183330.53247,	183335.17193,	183339.81139,	183344.45087,	183349.09036,
183353.72985,	183358.36936,	183363.00887,	183367.64840,	183372.28794,	183376.92748,	183381.56704,	183386.20661,	183390.84618,	183395.48577,
183400.12536,	183404.76497,	183409.40459,	183414.04421,	183418.68385,	183423.32349,	183427.96315,	183432.60282,	183437.24249,	183441.88218,
183446.52187,	183451.16158,	183455.80129,	183460.44102,	183465.08075,	183469.72050,	183474.36025,	183479.00002,	183483.63980,	183488.27958,
183492.91938,	183497.55918,	183502.19900,	183506.83882,	183511.47866,	183516.11850,	183520.75836,	183525.39822,	183530.03810,	183534.67798,
183539.31787,	183543.95778,	183548.59769,	183553.23762,	183557.87755,	183562.51750,	183567.15745,	183571.79742,	183576.43739,	183581.07737,
183585.71737,	183590.35737,	183594.99739,	183599.63741,	183604.27745,	183608.91749,	183613.55754,	183618.19761,	183622.83768,	183627.47776,
183632.11786,	183636.75796,	183641.39808,	183646.03820,	183650.67833,	183655.31848,	183659.95863,	183664.59879,	183669.23897,	183673.87915,
183678.51934,	183683.15955,	183687.79976,	183692.43998,	183697.08021,	183701.72046,	183706.36071,	183711.00097,	183715.64125,	183720.28153,
183724.92182,	183729.56212,	183734.20244,	183738.84276,	183743.48309,	183748.12343,	183752.76378,	183757.40415,	183762.04452,	183766.68490,
183771.32529,	183775.96569,	183780.60611,	183785.24653,	183789.88696,	183794.52740,	183799.16785,	183803.80831,	183808.44879,	183813.08927,
183817.72976,	183822.37026,	183827.01077,	183831.65129,	183836.29182,	183840.93237,	183845.57292,	183850.21348,	183854.85405,	183859.49463,
183864.13522,	183868.77582,	183873.41643,	183878.05705,	183882.69768,	183887.33832,	183891.97897,	183896.61963,	183901.26030,	183905.90098,
183910.54167,	183915.18237,	183919.82308,	183924.46380,	183929.10453,	183933.74527,	183938.38602,	183943.02678,	183947.66755,	183952.30833,
183956.94912,	183961.58992,	183966.23073,	183970.87155,	183975.51238,	183980.15322,	183984.79407,	183989.43492,	183994.07579,	183998.71667,
184003.35756,	184007.99846,	184012.63937,	184017.28029,	184021.92121,	184026.56215,	184031.20310,	184035.84406,	184040.48503,	184045.12601,
184049.76699,	184054.40799,	184059.04900,	184063.69002,	184068.33105,	184072.97208,	184077.61313,	184082.25419,	184086.89526,	184091.53633,
184096.17742,	184100.81852,	184105.45962,	184110.10074,	184114.74187,	184119.38300,	184124.02415,	184128.66531,	184133.30647,	184137.94765,
184142.58884,	184147.23003,	184151.87124,	184156.51246,	184161.15368,	184165.79492,	184170.43617,	184175.07742,	184179.71869,	184184.35996,
184189.00125,	184193.64254,	184198.28385,	184202.92516,	184207.56649,	184212.20783,	184216.84917,	184221.49053,	184226.13189,	184230.77327,
184235.41465,	184240.05605,	184244.69745,	184249.33886,	184253.98029,	184258.62172,	184263.26317,	184267.90462,	184272.54609,	184277.18756,
184281.82904,	184286.47054,	184291.11204,	184295.75356,	184300.39508,	184305.03661,	184309.67816,	184314.31971,	184318.96127,	184323.60285,
184328.24443,	184332.88602,	184337.52763,	184342.16924,	184346.81086,	184351.45249,	184356.09414,	184360.73579,	184365.37745,	184370.01912,
184374.66081,	184379.30250,	184383.94420,	184388.58591,	184393.22764,	184397.86937,	184402.51111,	184407.15286,	184411.79462,	184416.43639,
184421.07817,	184425.71997,	184430.36177,	184435.00358,	184439.64540,	184444.28723,	184448.92907,	184453.57092,	184458.21278,	184462.85465,
184467.49653,	184472.13842,	184476.78032,	184481.42223,	184486.06415,	184490.70608,	184495.34802,	184499.98997,	184504.63193,	184509.27390,
184513.91588,	184518.55787,	184523.19987,	184527.84188,	184532.48390,	184537.12593,	184541.76797,	184546.41002,	184551.05208,	184555.69414,
184560.33622,	184564.97831,	184569.62041,	184574.26252,	184578.90464,	184583.54676,	184588.18890,	184592.83105,	184597.47321,	184602.11537,
184606.75755,	184611.39974,	184616.04194,	184620.68414,	184625.32636,	184629.96859,	184634.61083,	184639.25307,	184643.89533,	184648.53760,
184653.17987,	184657.82216,	184662.46445,	184667.10676,	184671.74908,	184676.39140,	184681.03374,	184685.67608,	184690.31844,	184694.96081,
184699.60318,	184704.24557,	184708.88796,	184713.53037,	184718.17278,	184722.81521,	184727.45764,	184732.10009,	184736.74254,	184741.38501,
184746.02748,	184750.66996,	184755.31246,	184759.95496,	184764.59748,	184769.24000,	184773.88253,	184778.52508,	184783.16763,	184787.81020,
184792.45277,	184797.09535,	184801.73795,	184806.38055,	184811.02316,	184815.66578,	184820.30842,	184824.95106,	184829.59371,	184834.23637,
184838.87905,	184843.52173,	184848.16442,	184852.80712,	184857.44983,	184862.09256,	184866.73529,	184871.37803,	184876.02078,	184880.66354,
184885.30631,	184889.94909,	184894.59188,	184899.23468,	184903.87750,	184908.52032,	184913.16315,	184917.80599,	184922.44884,	184927.09170,
184931.73457,	184936.37745,	184941.02034,	184945.66324,	184950.30615,	184954.94906,	184959.59199,	184964.23493,	184968.87788,	184973.52084,
184978.16381,	184982.80679,	184987.44978,	184992.09277,	184996.73578,	185001.37880,	185006.02183,	185010.66487,	185015.30792,	185019.95097,
185024.59404,	185029.23712,	185033.88021,	185038.52330,	185043.16641,	185047.80953,	185052.45265,	185057.09579,	185061.73894,	185066.38209,
185071.02526,	185075.66844,	185080.31162,	185084.95482,	185089.59802,	185094.24124,	185098.88446,	185103.52770,	185108.17095,	185112.81420,
185117.45747,	185122.10074,	185126.74403,	185131.38732,	185136.03063,	185140.67394,	185145.31726,	185149.96060,	185154.60394,	185159.24730,
185163.89066,	185168.53403,	185173.17742,	185177.82081,	185182.46421,	185187.10763,	185191.75105,	185196.39448,	185201.03793,	185205.68138,
185210.32484,	185214.96831,	185219.61180,	185224.25529,	185228.89879,	185233.54230,	185238.18582,	185242.82936,	185247.47290,	185252.11645,
185256.76001,	185261.40358,	185266.04716,	185270.69075,	185275.33435,	185279.97796,	185284.62158,	185289.26521,	185293.90885,	185298.55250,
185303.19616,	185307.83983,	185312.48351,	185317.12720,	185321.77090,	185326.41461,	185331.05833,	185335.70206,	185340.34580,	185344.98955,
185349.63331,	185354.27707,	185358.92085,	185363.56464,	185368.20844,	185372.85225,	185377.49606,	185382.13989,	185386.78373,	185391.42758,
185396.07143,	185400.71530,	185405.35918,	185410.00306,	185414.64696,	185419.29087,	185423.93478,	185428.57871,	185433.22265,	185437.86659,
185442.51055,	185447.15451,	185451.79849,	185456.44247,	185461.08647,	185465.73047,	185470.37449,	185475.01851,	185479.66255,	185484.30659,
185488.95065,	185493.59471,	185498.23879,	185502.88287,	185507.52696,	185512.17107,	185516.81518,	185521.45930,	185526.10344,	185530.74758,
185535.39173,	185540.03590,	185544.68007,	185549.32425,	185553.96844,	185558.61265,	185563.25686,	185567.90108,	185572.54531,	185577.18955,
185581.83380,	185586.47807,	185591.12234,	185595.76662,	185600.41091,	185605.05521,	185609.69952,	185614.34384,	185618.98817,	185623.63251,
185628.27686,	185632.92122,	185637.56559,	185642.20997,	185646.85436,	185651.49876,	185656.14317,	185660.78759,	185665.43202,	185670.07645,
185674.72090,	185679.36536,	185684.00983,	185688.65431,	185693.29879,	185697.94329,	185702.58780,	185707.23232,	185711.87684,	185716.52138,
185721.16593,	185725.81048,	185730.45505,	185735.09963,	185739.74421,	185744.38881,	185749.03342,	185753.67803,	185758.32266,	185762.96729,
185767.61194,	185772.25659,	185776.90126,	185781.54593,	185786.19062,	185790.83531,	185795.48002,	185800.12473,	185804.76946,	185809.41419,
185814.05893,	185818.70369,	185823.34845,	185827.99322,	185832.63801,	185837.28280,	185841.92760,	185846.57242,	185851.21724,	185855.86207,
185860.50691,	185865.15176,	185869.79663,	185874.44150,	185879.08638,	185883.73127,	185888.37617,	185893.02108,	185897.66600,	185902.31093,
185906.95588,	185911.60083,	185916.24579,	185920.89076,	185925.53574,	185930.18073,	185934.82572,	185939.47073,	185944.11575,	185948.76078,
185953.40582,	185958.05087,	185962.69593,	185967.34100,	185971.98608,	185976.63116,	185981.27626,	185985.92137,	185990.56649,	185995.21161,
185999.85675,	186004.50190,	186009.14706,	186013.79222,	186018.43740,	186023.08258,	186027.72778,	186032.37299,	186037.01820,	186041.66343,
186046.30866,	186050.95391,	186055.59916,	186060.24443,	186064.88970,	186069.53499,	186074.18028,	186078.82559,	186083.47090,	186088.11623,
186092.76156,	186097.40690,	186102.05226,	186106.69762,	186111.34299,	186115.98838,	186120.63377,	186125.27917,	186129.92458,	186134.57001,
186139.21544,	186143.86088,	186148.50633,	186153.15179,	186157.79727,	186162.44275,	186167.08824,	186171.73374,	186176.37925,	186181.02477,
186185.67030,	186190.31584,	186194.96139,	186199.60695,	186204.25252,	186208.89810,	186213.54369,	186218.18929,	186222.83490,	186227.48052,
186232.12614,	186236.77178,	186241.41743,	186246.06309,	186250.70876,	186255.35443,	186260.00012,	186264.64582,	186269.29153,	186273.93724,
186278.58297,	186283.22871,	186287.87445,	186292.52021,	186297.16597,	186301.81175,	186306.45754,	186311.10333,	186315.74914,	186320.39495,
186325.04078,	186329.68661,	186334.33246,	186338.97831,	186343.62418,	186348.27005,	186352.91593,	186357.56183,	186362.20773,	186366.85364,
186371.49957,	186376.14550,	186380.79144,	186385.43739,	186390.08336,	186394.72933,	186399.37531,	186404.02130,	186408.66730,	186413.31332,
186417.95934,	186422.60537,	186427.25141,	186431.89746,	186436.54352,	186441.18959,	186445.83567,	186450.48176,	186455.12786,	186459.77397,
186464.42009,	186469.06622,	186473.71236,	186478.35851,	186483.00466,	186487.65083,	186492.29701,	186496.94320,	186501.58940,	186506.23560,
186510.88182,	186515.52805,	186520.17429,	186524.82053,	186529.46679,	186534.11306,	186538.75933,	186543.40562,	186548.05191,	186552.69822,
186557.34454,	186561.99086,	186566.63720,	186571.28354,	186575.92990,	186580.57626,	186585.22263,	186589.86902,	186594.51541,	186599.16182,
186603.80823,	186608.45465,	186613.10109,	186617.74753,	186622.39398,	186627.04044,	186631.68692,	186636.33340,	186640.97989,	186645.62639,
186650.27290,	186654.91943,	186659.56596,	186664.21250,	186668.85905,	186673.50561,	186678.15218,	186682.79876,	186687.44535,	186692.09195,
186696.73856,	186701.38518,	186706.03181,	186710.67845,	186715.32509,	186719.97175,	186724.61842,	186729.26510,	186733.91179,	186738.55849,
186743.20519,	186747.85191,	186752.49864,	186757.14537,	186761.79212,	186766.43888,	186771.08564,	186775.73242,	186780.37921,	186785.02600,
186789.67281,	186794.31962,	186798.96645,	186803.61328,	186808.26013,	186812.90698,	186817.55385,	186822.20072,	186826.84760,	186831.49450,
186836.14140,	186840.78831,	186845.43524,	186850.08217,	186854.72911,	186859.37606,	186864.02303,	186868.67000,	186873.31698,	186877.96397,
186882.61097,	186887.25798,	186891.90501,	186896.55204,	186901.19908,	186905.84613,	186910.49319,	186915.14026,	186919.78734,	186924.43443,
186929.08152,	186933.72863,	186938.37575,	186943.02288,	186947.67002,	186952.31717,	186956.96433,	186961.61149,	186966.25867,	186970.90586,
186975.55306,	186980.20026,	186984.84748,	186989.49471,	186994.14194,	186998.78919,	187003.43644,	187008.08371,	187012.73098,	187017.37827,
187022.02556,	187026.67287,	187031.32018,	187035.96751,	187040.61484,	187045.26219,	187049.90954,	187054.55690,	187059.20428,	187063.85166,
187068.49905,	187073.14645,	187077.79387,	187082.44129,	187087.08872,	187091.73616,	187096.38361,	187101.03107,	187105.67855,	187110.32603,
187114.97352,	187119.62102,	187124.26853,	187128.91605,	187133.56358,	187138.21112,	187142.85867,	187147.50622,	187152.15379,	187156.80137,
187161.44896,	187166.09656,	187170.74417,	187175.39178,	187180.03941,	187184.68705,	187189.33470,	187193.98235,	187198.63002,	187203.27770,
187207.92538,	187212.57308,	187217.22078,	187221.86850,	187226.51622,	187231.16396,	187235.81170,	187240.45946,	187245.10722,	187249.75500,
187254.40278,	187259.05057,	187263.69838,	187268.34619,	187272.99401,	187277.64185,	187282.28969,	187286.93754,	187291.58540,	187296.23327,
187300.88116,	187305.52905,	187310.17695,	187314.82486,	187319.47278,	187324.12071,	187328.76865,	187333.41660,	187338.06456,	187342.71253,
187347.36051,	187352.00850,	187356.65650,	187361.30450,	187365.95252,	187370.60055,	187375.24859,	187379.89664,	187384.54469,	187389.19276,
187393.84084,	187398.48892,	187403.13702,	187407.78513,	187412.43324,	187417.08137,	187421.72950,	187426.37765,	187431.02580,	187435.67397,
187440.32214,	187444.97033,	187449.61852,	187454.26673,	187458.91494,	187463.56316,	187468.21140,	187472.85964,	187477.50789,	187482.15615,
187486.80443,	187491.45271,	187496.10100,	187500.74930,	187505.39761,	187510.04593,	187514.69426,	187519.34260,	187523.99095,	187528.63931,
187533.28768,	187537.93606,	187542.58445,	187547.23285,	187551.88126,	187556.52968,	187561.17811,	187565.82655,	187570.47499,	187575.12345,
187579.77192,	187584.42040,	187589.06888,	187593.71738,	187598.36589,	187603.01440,	187607.66293,	187612.31146,	187616.96001,	187621.60856,
187626.25713,	187630.90570,	187635.55429,	187640.20288,	187644.85149,	187649.50010,	187654.14872,	187658.79736,	187663.44600,	187668.09465,
187672.74331,	187677.39199,	187682.04067,	187686.68936,	187691.33806,	187695.98677,	187700.63549,	187705.28422,	187709.93297,	187714.58172,
187719.23048,	187723.87925,	187728.52802,	187733.17681,	187737.82561,	187742.47442,	187747.12324,	187751.77207,	187756.42091,	187761.06975,
187765.71861,	187770.36748,	187775.01636,	187779.66524,	187784.31414,	187788.96304,	187793.61196,	187798.26089,	187802.90982,	187807.55877,
187812.20772,	187816.85669,	187821.50566,	187826.15465,	187830.80364,	187835.45264,	187840.10166,	187844.75068,	187849.39971,	187854.04875,
187858.69781,	187863.34687,	187867.99594,	187872.64502,	187877.29411,	187881.94322,	187886.59233,	187891.24145,	187895.89058,	187900.53972,
187905.18887,	187909.83803,	187914.48720,	187919.13637,	187923.78556,	187928.43476,	187933.08397,	187937.73319,	187942.38242,	187947.03165,
187951.68090,	187956.33016,	187960.97942,	187965.62870,	187970.27799,	187974.92728,	187979.57659,	187984.22590,	187988.87523,	187993.52456,
187998.17391,	188002.82326,	188007.47263,	188012.12200,	188016.77138,	188021.42078,	188026.07018,	188030.71959,	188035.36902,	188040.01845,
188044.66789,	188049.31734,	188053.96680,	188058.61627,	188063.26576,	188067.91525,	188072.56475,	188077.21426,	188081.86378,	188086.51331,
188091.16284,	188095.81239,	188100.46195,	188105.11152,	188109.76110,	188114.41069,	188119.06029,	188123.70989,	188128.35951,	188133.00914,
188137.65877,	188142.30842,	188146.95808,	188151.60774,	188156.25742,	188160.90710,	188165.55680,	188170.20650,	188174.85622,	188179.50594,
188184.15567,	188188.80542,	188193.45517,	188198.10493,	188202.75471,	188207.40449,	188212.05428,	188216.70408,	188221.35390,	188226.00372,
188230.65355,	188235.30339,	188239.95324,	188244.60310,	188249.25297,	188253.90285,	188258.55274,	188263.20264,	188267.85255,	188272.50247,
188277.15240,	188281.80233,	188286.45228,	188291.10224,	188295.75221,	188300.40218,	188305.05217,	188309.70217,	188314.35217,	188319.00219,
188323.65221,	188328.30225,	188332.95230,	188337.60235,	188342.25241,	188346.90249,	188351.55257,	188356.20267,	188360.85277,	188365.50288,
188370.15301,	188374.80314,	188379.45328,	188384.10343,	188388.75359,	188393.40377,	188398.05395,	188402.70414,	188407.35434,	188412.00455,
188416.65477,	188421.30500,	188425.95524,	188430.60549,	188435.25575,	188439.90602,	188444.55629,	188449.20658,	188453.85688,	188458.50719,
188463.15750,	188467.80783,	188472.45817,	188477.10851,	188481.75887,	188486.40924,	188491.05961,	188495.71000,	188500.36039,	188505.01080,
188509.66121,	188514.31164,	188518.96207,	188523.61251,	188528.26297,	188532.91343,	188537.56390,	188542.21438,	188546.86488,	188551.51538,
188556.16589,	188560.81641,	188565.46694,	188570.11748,	188574.76803,	188579.41859,	188584.06916,	188588.71974,	188593.37033,	188598.02093,
188602.67154,	188607.32216,	188611.97278,	188616.62342,	188621.27407,	188625.92473,	188630.57539,	188635.22607,	188639.87676,	188644.52745,
188649.17816,	188653.82887,	188658.47960,	188663.13033,	188667.78108,	188672.43183,	188677.08260,	188681.73337,	188686.38415,	188691.03495,
188695.68575,	188700.33656,	188704.98738,	188709.63822,	188714.28906,	188718.93991,	188723.59077,	188728.24164,	188732.89252,	188737.54341,
188742.19431,	188746.84522,	188751.49614,	188756.14707,	188760.79801,	188765.44895,	188770.09991,	188774.75088,	188779.40186,	188784.05285,
188788.70384,	188793.35485,	188798.00586,	188802.65689,	188807.30793,	188811.95897,	188816.61003,	188821.26109,	188825.91217,	188830.56325,
188835.21434,	188839.86545,	188844.51656,	188849.16768,	188853.81882,	188858.46996,	188863.12111,	188867.77227,	188872.42344,	188877.07462,
188881.72581,	188886.37701,	188891.02823,	188895.67944,	188900.33067,	188904.98191,	188909.63316,	188914.28442,	188918.93569,	188923.58697,
188928.23826,	188932.88955,	188937.54086,	188942.19218,	188946.84350,	188951.49484,	188956.14619,	188960.79754,	188965.44891,	188970.10028,
188974.75167,	188979.40306,	188984.05446,	188988.70588,	188993.35730,	188998.00873,	189002.66018,	189007.31163,	189011.96309,	189016.61456,
189021.26604,	189025.91754,	189030.56904,	189035.22055,	189039.87207,	189044.52360,	189049.17514,	189053.82669,	189058.47825,	189063.12981,
189067.78139,	189072.43298,	189077.08458,	189081.73619,	189086.38780,	189091.03943,	189095.69107,	189100.34271,	189104.99437,	189109.64603,
189114.29771,	189118.94940,	189123.60109,	189128.25279,	189132.90451,	189137.55623,	189142.20797,	189146.85971,	189151.51146,	189156.16322,
189160.81500,	189165.46678,	189170.11857,	189174.77037,	189179.42218,	189184.07400,	189188.72583,	189193.37767,	189198.02952,	189202.68138,
189207.33325,	189211.98513,	189216.63702,	189221.28891,	189225.94082,	189230.59274,	189235.24467,	189239.89660,	189244.54855,	189249.20051,
189253.85247,	189258.50445,	189263.15643,	189267.80843,	189272.46043,	189277.11245,	189281.76447,	189286.41650,	189291.06855,	189295.72060,
189300.37266,	189305.02473,	189309.67682,	189314.32891,	189318.98101,	189323.63312,	189328.28524,	189332.93737,	189337.58951,	189342.24166,
189346.89382,	189351.54599,	189356.19817,	189360.85035,	189365.50255,	189370.15476,	189374.80698,	189379.45920,	189384.11144,	189388.76369,
189393.41594,	189398.06821,	189402.72048,	189407.37277,	189412.02506,	189416.67737,	189421.32968,	189425.98201,	189430.63434,	189435.28668,
189439.93904,	189444.59140,	189449.24377,	189453.89615,	189458.54854,	189463.20094,	189467.85335,	189472.50578,	189477.15821,	189481.81065,
189486.46309,	189491.11555,	189495.76802,	189500.42050,	189505.07299,	189509.72549,	189514.37799,	189519.03051,	189523.68304,	189528.33557,
189532.98812,	189537.64068,	189542.29324,	189546.94582,	189551.59840,	189556.25100,	189560.90360,	189565.55621,	189570.20884,	189574.86147,
189579.51411,	189584.16677,	189588.81943,	189593.47210,	189598.12478,	189602.77747,	189607.43017,	189612.08288,	189616.73560,	189621.38833,
189626.04107,	189630.69382,	189635.34658,	189639.99935,	189644.65213,	189649.30491,	189653.95771,	189658.61052,	189663.26333,	189667.91616,
189672.56900,	189677.22184,	189681.87470,	189686.52756,	189691.18044,	189695.83332,	189700.48622,	189705.13912,	189709.79203,	189714.44495,
189719.09789,	189723.75083,	189728.40378,	189733.05674,	189737.70971,	189742.36270,	189747.01569,	189751.66869,	189756.32170,	189760.97471,
189765.62774,	189770.28078,	189774.93383,	189779.58689,	189784.23996,	189788.89303,	189793.54612,	189798.19922,	189802.85232,	189807.50544,
189812.15857,	189816.81170,	189821.46485,	189826.11800,	189830.77117,	189835.42434,	189840.07752,	189844.73072,	189849.38392,	189854.03713,
189858.69035,	189863.34359,	189867.99683,	189872.65008,	189877.30334,	189881.95661,	189886.60989,	189891.26318,	189895.91648,	189900.56979,
189905.22311,	189909.87643,	189914.52977,	189919.18312,	189923.83648,	189928.48984,	189933.14322,	189937.79661,	189942.45000,	189947.10341,
189951.75682,	189956.41025,	189961.06368,	189965.71713,	189970.37058,	189975.02404,	189979.67752,	189984.33100,	189988.98449,	189993.63799,
189998.29150,	190002.94503,	190007.59856,	190012.25210,	190016.90565,	190021.55921,	190026.21278,	190030.86636,	190035.51994,	190040.17354,
190044.82715,	190049.48077,	190054.13440,	190058.78803,	190063.44168,	190068.09534,	190072.74900,	190077.40268,	190082.05636,	190086.71006,
190091.36376,	190096.01748,	190100.67120,	190105.32493,	190109.97868,	190114.63243,	190119.28619,	190123.93996,	190128.59374,	190133.24754,
190137.90134,	190142.55515,	190147.20897,	190151.86280,	190156.51664,	190161.17048,	190165.82434,	190170.47821,	190175.13209,	190179.78598,
190184.43987,	190189.09378,	190193.74770,	190198.40162,	190203.05556,	190207.70951,	190212.36346,	190217.01742,	190221.67140,	190226.32538,
190230.97938,	190235.63338,	190240.28739,	190244.94141,	190249.59545,	190254.24949,	190258.90354,	190263.55760,	190268.21167,	190272.86575,
190277.51984,	190282.17394,	190286.82805,	190291.48217,	190296.13630,	190300.79044,	190305.44458,	190310.09874,	190314.75291,	190319.40708,
190324.06127,	190328.71547,	190333.36967,	190338.02389,	190342.67811,	190347.33235,	190351.98659,	190356.64084,	190361.29511,	190365.94938,
190370.60366,	190375.25795,	190379.91226,	190384.56657,	190389.22089,	190393.87522,	190398.52956,	190403.18391,	190407.83827,	190412.49264,
190417.14702,	190421.80140,	190426.45580,	190431.11021,	190435.76463,	190440.41905,	190445.07349,	190449.72794,	190454.38239,	190459.03686,
190463.69133,	190468.34582,	190473.00031,	190477.65481,	190482.30933,	190486.96385,	190491.61838,	190496.27293,	190500.92748,	190505.58204,
190510.23661,	190514.89119,	190519.54578,	190524.20038,	190528.85499,	190533.50961,	190538.16424,	190542.81888,	190547.47353,	190552.12818,
190556.78285,	190561.43753,	190566.09222,	190570.74691,	190575.40162,	190580.05633,	190584.71106,	190589.36579,	190594.02054,	190598.67529,
190603.33005,	190607.98483,	190612.63961,	190617.29440,	190621.94920,	190626.60402,	190631.25884,	190635.91367,	190640.56851,	190645.22336,
190649.87822,	190654.53309,	190659.18797,	190663.84286,	190668.49775,	190673.15266,	190677.80758,	190682.46251,	190687.11744,	190691.77239,
190696.42734,	190701.08231,	190705.73728,	190710.39227,	190715.04726,	190719.70227,	190724.35728,	190729.01230,	190733.66734,	190738.32238,
190742.97743,	190747.63249,	190752.28756,	190756.94264,	190761.59774,	190766.25284,	190770.90794,	190775.56306,	190780.21819,	190784.87333,
190789.52848,	190794.18364,	190798.83880,	190803.49398,	190808.14917,	190812.80436,	190817.45957,	190822.11478,	190826.77001,	190831.42524,
190836.08049,	190840.73574,	190845.39101,	190850.04628,	190854.70156,	190859.35685,	190864.01215,	190868.66747,	190873.32279,	190877.97812,
190882.63346,	190887.28881,	190891.94417,	190896.59954,	190901.25491,	190905.91030,	190910.56570,	190915.22111,	190919.87652,	190924.53195,
190929.18739,	190933.84283,	190938.49829,	190943.15375,	190947.80923,	190952.46471,	190957.12021,	190961.77571,	190966.43122,	190971.08675,
190975.74228,	190980.39782,	190985.05337,	190989.70893,	190994.36450,	190999.02008,	191003.67567,	191008.33127,	191012.98688,	191017.64250,
191022.29813,	191026.95377,	191031.60941,	191036.26507,	191040.92074,	191045.57641,	191050.23210,	191054.88779,	191059.54350,	191064.19921,
191068.85494,	191073.51067,	191078.16641,	191082.82217,	191087.47793,	191092.13370,	191096.78948,	191101.44527,	191106.10108,	191110.75689,
191115.41271,	191120.06854,	191124.72438,	191129.38022,	191134.03608,	191138.69195,	191143.34783,	191148.00372,	191152.65961,	191157.31552,
191161.97143,	191166.62736,	191171.28330,	191175.93924,	191180.59519,	191185.25116,	191189.90713,	191194.56312,	191199.21911,	191203.87511,
191208.53112,	191213.18714,	191217.84317,	191222.49922,	191227.15527,	191231.81133,	191236.46739,	191241.12347,	191245.77956,	191250.43566,
191255.09177,	191259.74789,	191264.40401,	191269.06015,	191273.71630,	191278.37245,	191283.02862,	191287.68479,	191292.34098,	191296.99717,
191301.65337,	191306.30959,	191310.96581,	191315.62204,	191320.27828,	191324.93454,	191329.59080,	191334.24707,	191338.90335,	191343.55964,
191348.21594,	191352.87225,	191357.52857,	191362.18489,	191366.84123,	191371.49758,	191376.15394,	191380.81030,	191385.46668,	191390.12306,
191394.77946,	191399.43586,	191404.09228,	191408.74870,	191413.40514,	191418.06158,	191422.71803,	191427.37449,	191432.03097,	191436.68745,
191441.34394,	191446.00044,	191450.65695,	191455.31347,	191459.97000,	191464.62654,	191469.28309,	191473.93964,	191478.59621,	191483.25279,
191487.90938,	191492.56597,	191497.22258,	191501.87919,	191506.53582,	191511.19245,	191515.84910,	191520.50575,	191525.16242,	191529.81909,
191534.47577,	191539.13246,	191543.78917,	191548.44588,	191553.10260,	191557.75933,	191562.41607,	191567.07282,	191571.72958,	191576.38635,
191581.04312,	191585.69991,	191590.35671,	191595.01352,	191599.67033,	191604.32716,	191608.98400,	191613.64084,	191618.29770,	191622.95456,
191627.61143,	191632.26832,	191636.92521,	191641.58211,	191646.23903,	191650.89595,	191655.55288,	191660.20982,	191664.86677,	191669.52373,
191674.18070,	191678.83768,	191683.49467,	191688.15167,	191692.80868,	191697.46569,	191702.12272,	191706.77976,	191711.43680,	191716.09386,
191720.75093,	191725.40800,	191730.06508,	191734.72218,	191739.37928,	191744.03640,	191748.69352,	191753.35065,	191758.00779,	191762.66494,
191767.32211,	191771.97928,	191776.63646,	191781.29365,	191785.95085,	191790.60805,	191795.26527,	191799.92250,	191804.57974,	191809.23699,
191813.89424,	191818.55151,	191823.20878,	191827.86607,	191832.52336,	191837.18067,	191841.83798,	191846.49531,	191851.15264,	191855.80998,
191860.46734,	191865.12470,	191869.78207,	191874.43945,	191879.09684,	191883.75424,	191888.41165,	191893.06907,	191897.72650,	191902.38394,
191907.04138,	191911.69884,	191916.35631,	191921.01378,	191925.67127,	191930.32877,	191934.98627,	191939.64379,	191944.30131,	191948.95884,
191953.61639,	191958.27394,	191962.93150,	191967.58908,	191972.24666,	191976.90425,	191981.56185,	191986.21946,	191990.87708,	191995.53471,
192000.19235,	192004.85000,	192009.50765,	192014.16532,	192018.82300,	192023.48069,	192028.13838,	192032.79609,	192037.45380,	192042.11153,
192046.76926,	192051.42701,	192056.08476,	192060.74252,	192065.40030,	192070.05808,	192074.71587,	192079.37367,	192084.03148,	192088.68930,
192093.34713,	192098.00497,	192102.66282,	192107.32068,	192111.97855,	192116.63643,	192121.29431,	192125.95221,	192130.61012,	192135.26803,
192139.92596,	192144.58389,	192149.24184,	192153.89979,	192158.55776,	192163.21573,	192167.87371,	192172.53170,	192177.18971,	192181.84772,
192186.50574,	192191.16377,	192195.82181,	192200.47986,	192205.13792,	192209.79599,	192214.45406,	192219.11215,	192223.77025,	192228.42836,
192233.08647,	192237.74460,	192242.40273,	192247.06088,	192251.71903,	192256.37720,	192261.03537,	192265.69355,	192270.35175,	192275.00995,
192279.66816,	192284.32638,	192288.98461,	192293.64285,	192298.30110,	192302.95936,	192307.61763,	192312.27591,	192316.93420,	192321.59250,
192326.25080,	192330.90912,	192335.56745,	192340.22578,	192344.88413,	192349.54248,	192354.20085,	192358.85922,	192363.51761,	192368.17600,
192372.83440,	192377.49281,	192382.15123,	192386.80967,	192391.46811,	192396.12656,	192400.78502,	192405.44349,	192410.10196,	192414.76045,
192419.41895,	192424.07746,	192428.73598,	192433.39450,	192438.05304,	192442.71158,	192447.37014,	192452.02870,	192456.68728,	192461.34586,
192466.00445,	192470.66306,	192475.32167,	192479.98029,	192484.63892,	192489.29756,	192493.95621,	192498.61487,	192503.27354,	192507.93222,
192512.59091,	192517.24961,	192521.90832,	192526.56703,	192531.22576,	192535.88450,	192540.54324,	192545.20200,	192549.86076,	192554.51954,
192559.17832,	192563.83711,	192568.49592,	192573.15473,	192577.81355,	192582.47238,	192587.13122,	192591.79007,	192596.44893,	192601.10780,
192605.76668,	192610.42557,	192615.08447,	192619.74338,	192624.40229,	192629.06122,	192633.72016,	192638.37910,	192643.03806,	192647.69702,
192652.35600,	192657.01498,	192661.67398,	192666.33298,	192670.99199,	192675.65101,	192680.31004,	192684.96909,	192689.62814,	192694.28720,
192698.94627,	192703.60534,	192708.26443,	192712.92353,	192717.58264,	192722.24176,	192726.90088,	192731.56002,	192736.21917,	192740.87832,
192745.53749,	192750.19666,	192754.85584,	192759.51504,	192764.17424,	192768.83345,	192773.49267,	192778.15191,	192782.81115,	192787.47040,
192792.12966,	192796.78893,	192801.44821,	192806.10749,	192810.76679,	192815.42610,	192820.08542,	192824.74474,	192829.40408,	192834.06342,
192838.72278,	192843.38214,	192848.04152,	192852.70090,	192857.36030,	192862.01970,	192866.67911,	192871.33853,	192875.99796,	192880.65740,
192885.31685,	192889.97631,	192894.63578,	192899.29526,	192903.95475,	192908.61425,	192913.27376,	192917.93327,	192922.59280,	192927.25234,
192931.91188,	192936.57144,	192941.23100,	192945.89057,	192950.55016,	192955.20975,	192959.86935,	192964.52897,	192969.18859,	192973.84822,
192978.50786,	192983.16751,	192987.82717,	192992.48684,	192997.14652,	193001.80620,	193006.46590,	193011.12561,	193015.78532,	193020.44505,
193025.10479,	193029.76453,	193034.42429,	193039.08405,	193043.74382,	193048.40361,	193053.06340,	193057.72320,	193062.38301,	193067.04283,
193071.70267,	193076.36251,	193081.02236,	193085.68221,	193090.34208,	193095.00196,	193099.66185,	193104.32175,	193108.98165,	193113.64157,
193118.30149,	193122.96143,	193127.62137,	193132.28133,	193136.94129,	193141.60127,	193146.26125,	193150.92124,	193155.58124,	193160.24125,
193164.90127,	193169.56130,	193174.22134,	193178.88139,	193183.54145,	193188.20152,	193192.86160,	193197.52169,	193202.18178,	193206.84189,
193211.50200,	193216.16213,	193220.82226,	193225.48241,	193230.14256,	193234.80273,	193239.46290,	193244.12308,	193248.78327,	193253.44347,
193258.10368,	193262.76390,	193267.42413,	193272.08437,	193276.74462,	193281.40488,	193286.06515,	193290.72542,	193295.38571,	193300.04601,
193304.70631,	193309.36663,	193314.02695,	193318.68729,	193323.34763,	193328.00798,	193332.66835,	193337.32872,	193341.98910,	193346.64949,
193351.30989,	193355.97030,	193360.63072,	193365.29115,	193369.95159,	193374.61204,	193379.27249,	193383.93296,	193388.59344,	193393.25392,
193397.91442,	193402.57492,	193407.23544,	193411.89596,	193416.55650,	193421.21704,	193425.87759,	193430.53815,	193435.19873,	193439.85931,
193444.51990,	193449.18050,	193453.84111,	193458.50172,	193463.16235,	193467.82299,	193472.48364,	193477.14430,	193481.80496,	193486.46564,
193491.12632,	193495.78702,	193500.44772,	193505.10844,	193509.76916,	193514.42989,	193519.09063,	193523.75139,	193528.41215,	193533.07292,
193537.73370,	193542.39449,	193547.05529,	193551.71609,	193556.37691,	193561.03774,	193565.69858,	193570.35942,	193575.02028,	193579.68114,
193584.34202,	193589.00290,	193593.66380,	193598.32470,	193602.98561,	193607.64654,	193612.30747,	193616.96841,	193621.62936,	193626.29032,
193630.95129,	193635.61227,	193640.27326,	193644.93426,	193649.59526,	193654.25628,	193658.91731,	193663.57834,	193668.23939,	193672.90045,
193677.56151,	193682.22258,	193686.88367,	193691.54476,	193696.20586,	193700.86697,	193705.52810,	193710.18923,	193714.85037,	193719.51152,
193724.17268,	193728.83385,	193733.49502,	193738.15621,	193742.81741,	193747.47862,	193752.13983,	193756.80106,	193761.46229,	193766.12354,
193770.78479,	193775.44605,	193780.10733,	193784.76861,	193789.42990,	193794.09120,	193798.75251,	193803.41384,	193808.07517,	193812.73650,
193817.39785,	193822.05921,	193826.72058,	193831.38196,	193836.04334,	193840.70474,	193845.36614,	193850.02756,	193854.68898,	193859.35042,
193864.01186,	193868.67332,	193873.33478,	193877.99625,	193882.65773,	193887.31922,	193891.98072,	193896.64223,	193901.30375,	193905.96528,
193910.62682,	193915.28837,	193919.94992,	193924.61149,	193929.27307,	193933.93465,	193938.59625,	193943.25785,	193947.91946,	193952.58109,
193957.24272,	193961.90436,	193966.56602,	193971.22768,	193975.88935,	193980.55103,	193985.21272,	193989.87442,	193994.53612,	193999.19784,
194003.85957,	194008.52131,	194013.18305,	194017.84481,	194022.50658,	194027.16835,	194031.83013,	194036.49193,	194041.15373,	194045.81554,
194050.47737,	194055.13920,	194059.80104,	194064.46289,	194069.12475,	194073.78662,	194078.44850,	194083.11039,	194087.77228,	194092.43419,
194097.09611,	194101.75803,	194106.41997,	194111.08191,	194115.74387,	194120.40583,	194125.06781,	194129.72979,	194134.39178,	194139.05378,
194143.71580,	194148.37782,	194153.03985,	194157.70189,	194162.36394,	194167.02599,	194171.68806,	194176.35014,	194181.01223,	194185.67432,
194190.33643,	194194.99854,	194199.66067,	194204.32280,	194208.98495,	194213.64710,	194218.30926,	194222.97144,	194227.63362,	194232.29581,
194236.95801,	194241.62022,	194246.28244,	194250.94467,	194255.60690,	194260.26915,	194264.93141,	194269.59368,	194274.25595,	194278.91824,
194283.58053,	194288.24284,	194292.90515,	194297.56747,	194302.22981,	194306.89215,	194311.55450,	194316.21686,	194320.87923,	194325.54161,
194330.20400,	194334.86640,	194339.52881,	194344.19123,	194348.85365,	194353.51609,	194358.17854,	194362.84099,	194367.50346,	194372.16593,
194376.82842,	194381.49091,	194386.15341,	194390.81592,	194395.47845,	194400.14098,	194404.80352,	194409.46607,	194414.12863,	194418.79120,
194423.45378,	194428.11636,	194432.77896,	194437.44157,	194442.10418,	194446.76681,	194451.42944,	194456.09209,	194460.75474,	194465.41741,
194470.08008,	194474.74276,	194479.40545,	194484.06815,	194488.73086,	194493.39358,	194498.05631,	194502.71905,	194507.38180,	194512.04456,
194516.70733,	194521.37010,	194526.03289,	194530.69569,	194535.35849,	194540.02130,	194544.68413,	194549.34696,	194554.00980,	194558.67266,
194563.33552,	194567.99839,	194572.66127,	194577.32416,	194581.98706,	194586.64997,	194591.31289,	194595.97581,	194600.63875,	194605.30170,
194609.96465,	194614.62762,	194619.29059,	194623.95358,	194628.61657,	194633.27958,	194637.94259,	194642.60561,	194647.26864,	194651.93168,
194656.59473,	194661.25779,	194665.92086,	194670.58394,	194675.24703,	194679.91013,	194684.57323,	194689.23635,	194693.89948,	194698.56261,
194703.22576,	194707.88891,	194712.55207,	194717.21525,	194721.87843,	194726.54162,	194731.20482,	194735.86803,	194740.53125,	194745.19448,
194749.85772,	194754.52097,	194759.18423,	194763.84750,	194768.51077,	194773.17406,	194777.83736,	194782.50066,	194787.16398,	194791.82730,
194796.49063,	194801.15398,	194805.81733,	194810.48069,	194815.14406,	194819.80744,	194824.47083,	194829.13423,	194833.79764,	194838.46106,
194843.12448,	194847.78792,	194852.45137,	194857.11482,	194861.77829,	194866.44176,	194871.10525,	194875.76874,	194880.43225,	194885.09576,
194889.75928,	194894.42281,	194899.08635,	194903.74990,	194908.41346,	194913.07703,	194917.74061,	194922.40420,	194927.06779,	194931.73140,
194936.39502,	194941.05864,	194945.72228,	194950.38592,	194955.04958,	194959.71324,	194964.37691,	194969.04059,	194973.70428,	194978.36799,
194983.03170,	194987.69542,	194992.35915,	194997.02288,	195001.68663,	195006.35039,	195011.01416,	195015.67793,	195020.34172,	195025.00551,
195029.66932,	195034.33313,	195038.99696,	195043.66079,	195048.32463,	195052.98848,	195057.65234,	195062.31621,	195066.98009,	195071.64398,
195076.30788,	195080.97179,	195085.63571,	195090.29963,	195094.96357,	195099.62752,	195104.29147,	195108.95544,	195113.61941,	195118.28339,
195122.94739,	195127.61139,	195132.27540,	195136.93942,	195141.60345,	195146.26749,	195150.93154,	195155.59560,	195160.25967,	195164.92375,
195169.58783,	195174.25193,	195178.91603,	195183.58015,	195188.24427,	195192.90841,	195197.57255,	195202.23671,	195206.90087,	195211.56504,
195216.22922,	195220.89341,	195225.55761,	195230.22182,	195234.88604,	195239.55027,	195244.21450,	195248.87875,	195253.54301,	195258.20727,
195262.87155,	195267.53583,	195272.20013,	195276.86443,	195281.52874,	195286.19307,	195290.85740,	195295.52174,	195300.18609,	195304.85045,
195309.51482,	195314.17920,	195318.84359,	195323.50798,	195328.17239,	195332.83681,	195337.50123,	195342.16567,	195346.83011,	195351.49457,
195356.15903,	195360.82350,	195365.48798,	195370.15248,	195374.81698,	195379.48149,	195384.14601,	195388.81054,	195393.47507,	195398.13962,
195402.80418,	195407.46875,	195412.13332,	195416.79791,	195421.46250,	195426.12711,	195430.79172,	195435.45634,	195440.12098,	195444.78562,
195449.45027,	195454.11493,	195458.77960,	195463.44428,	195468.10897,	195472.77367,	195477.43838,	195482.10309,	195486.76782,	195491.43256,
195496.09730,	195500.76206,	195505.42682,	195510.09159,	195514.75638,	195519.42117,	195524.08597,	195528.75078,	195533.41560,	195538.08043,
195542.74527,	195547.41012,	195552.07498,	195556.73985,	195561.40472,	195566.06961,	195570.73450,	195575.39941,	195580.06432,	195584.72925,
195589.39418,	195594.05912,	195598.72408,	195603.38904,	195608.05401,	195612.71899,	195617.38398,	195622.04898,	195626.71399,	195631.37900,
195636.04403,	195640.70907,	195645.37411,	195650.03917,	195654.70423,	195659.36931,	195664.03439,	195668.69948,	195673.36459,	195678.02970,
195682.69482,	195687.35995,	195692.02509,	195696.69024,	195701.35540,	195706.02057,	195710.68574,	195715.35093,	195720.01613,	195724.68133,
195729.34655,	195734.01177,	195738.67701,	195743.34225,	195748.00750,	195752.67276,	195757.33803,	195762.00332,	195766.66861,	195771.33390,
195775.99921,	195780.66453,	195785.32986,	195789.99520,	195794.66054,	195799.32590,	195803.99126,	195808.65664,	195813.32202,	195817.98742,
195822.65282,	195827.31823,	195831.98365,	195836.64908,	195841.31452,	195845.97997,	195850.64543,	195855.31090,	195859.97638,	195864.64187,
195869.30736,	195873.97287,	195878.63838,	195883.30391,	195887.96944,	195892.63499,	195897.30054,	195901.96610,	195906.63167,	195911.29725,
195915.96284,	195920.62844,	195925.29405,	195929.95967,	195934.62530,	195939.29094,	195943.95658,	195948.62224,	195953.28790,	195957.95358,
195962.61926,	195967.28496,	195971.95066,	195976.61637,	195981.28209,	195985.94782,	195990.61357,	195995.27931,	195999.94507,	196004.61084,
196009.27662,	196013.94241,	196018.60820,	196023.27401,	196027.93983,	196032.60565,	196037.27148,	196041.93733,	196046.60318,	196051.26904,
196055.93492,	196060.60080,	196065.26669,	196069.93259,	196074.59850,	196079.26441,	196083.93034,	196088.59628,	196093.26223,	196097.92818,
196102.59415,	196107.26012,	196111.92611,	196116.59210,	196121.25810,	196125.92412,	196130.59014,	196135.25617,	196139.92221,	196144.58826,
196149.25432,	196153.92039,	196158.58646,	196163.25255,	196167.91865,	196172.58475,	196177.25087,	196181.91699,	196186.58313,	196191.24927,
196195.91542,	196200.58159,	196205.24776,	196209.91394,	196214.58013,	196219.24633,	196223.91254,	196228.57876,	196233.24498,	196237.91122,
196242.57747,	196247.24372,	196251.90999,	196256.57626,	196261.24255,	196265.90884,	196270.57514,	196275.24145,	196279.90778,	196284.57411,
196289.24045,	196293.90680,	196298.57315,	196303.23952,	196307.90590,	196312.57229,	196317.23868,	196321.90509,	196326.57150,	196331.23793,
196335.90436,	196340.57081,	196345.23726,	196349.90372,	196354.57019,	196359.23667,	196363.90316,	196368.56966,	196373.23617,	196377.90269,
196382.56921,	196387.23575,	196391.90230,	196396.56885,	196401.23542,	196405.90199,	196410.56858,	196415.23517,	196419.90177,	196424.56838,
196429.23500,	196433.90163,	196438.56827,	196443.23492,	196447.90158,	196452.56825,	196457.23492,	196461.90161,	196466.56831,	196471.23501,
196475.90173,	196480.56845,	196485.23518,	196489.90193,	196494.56868,	196499.23544,	196503.90221,	196508.56899,	196513.23578,	196517.90258,
196522.56939,	196527.23620,	196531.90303,	196536.56987,	196541.23671,	196545.90357,	196550.57043,	196555.23730,	196559.90419,	196564.57108,
196569.23798,	196573.90489,	196578.57181,	196583.23874,	196587.90568,	196592.57263,	196597.23959,	196601.90655,	196606.57353,	196611.24052,
196615.90751,	196620.57452,	196625.24153,	196629.90855,	196634.57558,	196639.24263,	196643.90968,	196648.57674,	196653.24381,	196657.91089,
196662.57798,	196667.24507,	196671.91218,	196676.57930,	196681.24642,	196685.91356,	196690.58070,	196695.24786,	196699.91502,	196704.58219,
196709.24938,	196713.91657,	196718.58377,	196723.25098,	196727.91820,	196732.58543,	196737.25266,	196741.91991,	196746.58717,	196751.25443,
196755.92171,	196760.58899,	196765.25629,	196769.92359,	196774.59090,	196779.25823,	196783.92556,	196788.59290,	196793.26025,	196797.92761,
196802.59498,	196807.26236,	196811.92974,	196816.59714,	196821.26455,	196825.93196,	196830.59939,	196835.26682,	196839.93427,	196844.60172,
196849.26918,	196853.93665,	196858.60413,	196863.27162,	196867.93912,	196872.60663,	196877.27415,	196881.94168,	196886.60921,	196891.27676,
196895.94432,	196900.61188,	196905.27946,	196909.94704,	196914.61463,	196919.28224,	196923.94985,	196928.61747,	196933.28510,	196937.95274,
196942.62039,	196947.28805,	196951.95571,	196956.62339,	196961.29108,	196965.95877,	196970.62648,	196975.29419,	196979.96192,	196984.62965,
196989.29739,	196993.96514,	196998.63290,	197003.30067,	197007.96845,	197012.63624,	197017.30404,	197021.97185,	197026.63967,	197031.30749,
197035.97533,	197040.64317,	197045.31103,	197049.97889,	197054.64676,	197059.31465,	197063.98254,	197068.65044,	197073.31835,	197077.98627,
197082.65420,	197087.32214,	197091.99008,	197096.65804,	197101.32601,	197105.99398,	197110.66197,	197115.32996,	197119.99797,	197124.66598,
197129.33400,	197134.00203,	197138.67007,	197143.33812,	197148.00618,	197152.67425,	197157.34233,	197162.01042,	197166.67852,	197171.34662,
197176.01474,	197180.68286,	197185.35100,	197190.01914,	197194.68729,	197199.35546,	197204.02363,	197208.69181,	197213.36000,	197218.02820,
197222.69641,	197227.36462,	197232.03285,	197236.70109,	197241.36933,	197246.03759,	197250.70585,	197255.37413,	197260.04241,	197264.71070,
197269.37901,	197274.04732,	197278.71564,	197283.38397,	197288.05231,	197292.72066,	197297.38901,	197302.05738,	197306.72576,	197311.39414,
197316.06254,	197320.73094,	197325.39936,	197330.06778,	197334.73621,	197339.40466,	197344.07311,	197348.74157,	197353.41004,	197358.07852,
197362.74700,	197367.41550,	197372.08401,	197376.75253,	197381.42105,	197386.08959,	197390.75813,	197395.42668,	197400.09525,	197404.76382,
197409.43240,	197414.10099,	197418.76959,	197423.43820,	197428.10682,	197432.77545,	197437.44409,	197442.11273,	197446.78139,	197451.45005,
197456.11873,	197460.78741,	197465.45611,	197470.12481,	197474.79352,	197479.46224,	197484.13097,	197488.79971,	197493.46846,	197498.13722,
197502.80599,	197507.47477,	197512.14355,	197516.81235,	197521.48115,	197526.14997,	197530.81879,	197535.48762,	197540.15647,	197544.82532,
197549.49418,	197554.16305,	197558.83193,	197563.50082,	197568.16972,	197572.83862,	197577.50754,	197582.17647,	197586.84540,	197591.51435,
197596.18330,	197600.85226,	197605.52124,	197610.19022,	197614.85921,	197619.52821,	197624.19722,	197628.86624,	197633.53527,	197638.20431,
197642.87335,	197647.54241,	197652.21148,	197656.88055,	197661.54964,	197666.21873,	197670.88783,	197675.55694,	197680.22607,	197684.89520,
197689.56434,	197694.23349,	197698.90264,	197703.57181,	197708.24099,	197712.91018,	197717.57937,	197722.24858,	197726.91779,	197731.58702,
197736.25625,	197740.92549,	197745.59474,	197750.26400,	197754.93328,	197759.60255,	197764.27184,	197768.94114,	197773.61045,	197778.27977,
197782.94909,	197787.61843,	197792.28777,	197796.95713,	197801.62649,	197806.29586,	197810.96525,	197815.63464,	197820.30404,	197824.97345,
197829.64287,	197834.31229,	197838.98173,	197843.65118,	197848.32064,	197852.99010,	197857.65958,	197862.32906,	197866.99855,	197871.66806,
197876.33757,	197881.00709,	197885.67662,	197890.34616,	197895.01571,	197899.68527,	197904.35484,	197909.02441,	197913.69400,	197918.36360,
197923.03320,	197927.70282,	197932.37244,	197937.04207,	197941.71171,	197946.38137,	197951.05103,	197955.72070,	197960.39038,	197965.06007,
197969.72976,	197974.39947,	197979.06919,	197983.73891,	197988.40865,	197993.07839,	197997.74815,	198002.41791,	198007.08768,	198011.75746,
198016.42725,	198021.09705,	198025.76686,	198030.43668,	198035.10651,	198039.77635,	198044.44619,	198049.11605,	198053.78592,	198058.45579,
198063.12567,	198067.79557,	198072.46547,	198077.13538,	198081.80530,	198086.47523,	198091.14517,	198095.81512,	198100.48508,	198105.15505,
198109.82502,	198114.49501,	198119.16500,	198123.83501,	198128.50502,	198133.17505,	198137.84508,	198142.51512,	198147.18517,	198151.85523,
198156.52530,	198161.19538,	198165.86547,	198170.53556,	198175.20567,	198179.87579,	198184.54591,	198189.21605,	198193.88619,	198198.55634,
198203.22651,	198207.89668,	198212.56686,	198217.23705,	198221.90725,	198226.57746,	198231.24767,	198235.91790,	198240.58814,	198245.25838,
198249.92864,	198254.59890,	198259.26918,	198263.93946,	198268.60975,	198273.28005,	198277.95037,	198282.62069,	198287.29101,	198291.96135,
198296.63170,	198301.30206,	198305.97242,	198310.64280,	198315.31319,	198319.98358,	198324.65398,	198329.32440,	198333.99482,	198338.66525,
198343.33569,	198348.00614,	198352.67660,	198357.34707,	198362.01755,	198366.68803,	198371.35853,	198376.02904,	198380.69955,	198385.37007,
198390.04061,	198394.71115,	198399.38170,	198404.05226,	198408.72283,	198413.39341,	198418.06400,	198422.73460,	198427.40521,	198432.07583,
198436.74645,	198441.41709,	198446.08773,	198450.75839,	198455.42905,	198460.09972,	198464.77040,	198469.44109,	198474.11179,	198478.78250,
198483.45322,	198488.12395,	198492.79469,	198497.46544,	198502.13619,	198506.80696,	198511.47773,	198516.14852,	198520.81931,	198525.49011,
198530.16092,	198534.83174,	198539.50257,	198544.17341,	198548.84426,	198553.51512,	198558.18599,	198562.85686,	198567.52775,	198572.19864,
198576.86955,	198581.54046,	198586.21138,	198590.88232,	198595.55326,	198600.22421,	198604.89517,	198609.56614,	198614.23711,	198618.90810,
198623.57910,	198628.25010,	198632.92112,	198637.59215,	198642.26318,	198646.93422,	198651.60527,	198656.27634,	198660.94741,	198665.61849,
198670.28958,	198674.96068,	198679.63178,	198684.30290,	198688.97403,	198693.64516,	198698.31631,	198702.98746,	198707.65863,	198712.32980,
198717.00098,	198721.67217,	198726.34337,	198731.01458,	198735.68580,	198740.35703,	198745.02827,	198749.69952,	198754.37077,	198759.04204,
198763.71331,	198768.38460,	198773.05589,	198777.72719,	198782.39850,	198787.06982,	198791.74115,	198796.41249,	198801.08384,	198805.75520,
198810.42657,	198815.09794,	198819.76933,	198824.44072,	198829.11213,	198833.78354,	198838.45497,	198843.12640,	198847.79784,	198852.46929,
198857.14075,	198861.81222,	198866.48370,	198871.15518,	198875.82668,	198880.49819,	198885.16970,	198889.84123,	198894.51276,	198899.18430,
198903.85586,	198908.52742,	198913.19899,	198917.87057,	198922.54216,	198927.21376,	198931.88536,	198936.55698,	198941.22861,	198945.90024,
198950.57189,	198955.24354,	198959.91521,	198964.58688,	198969.25856,	198973.93025,	198978.60195,	198983.27366,	198987.94538,	198992.61711,
198997.28885,	199001.96059,	199006.63235,	199011.30411,	199015.97589,	199020.64767,	199025.31946,	199029.99127,	199034.66308,	199039.33490,
199044.00673,	199048.67857,	199053.35041,	199058.02227,	199062.69414,	199067.36602,	199072.03790,	199076.70980,	199081.38170,	199086.05361,
199090.72553,	199095.39747,	199100.06941,	199104.74136,	199109.41332,	199114.08528,	199118.75726,	199123.42925,	199128.10124,	199132.77325,
199137.44527,	199142.11729,	199146.78932,	199151.46136,	199156.13342,	199160.80548,	199165.47755,	199170.14963,	199174.82172,	199179.49381,
199184.16592,	199188.83804,	199193.51016,	199198.18230,	199202.85444,	199207.52659,	199212.19876,	199216.87093,	199221.54311,	199226.21530,
199230.88750,	199235.55971,	199240.23193,	199244.90415,	199249.57639,	199254.24864,	199258.92089,	199263.59315,	199268.26543,	199272.93771,
199277.61000,	199282.28230,	199286.95461,	199291.62693,	199296.29926,	199300.97160,	199305.64395,	199310.31630,	199314.98867,	199319.66104,
199324.33343,	199329.00582,	199333.67823,	199338.35064,	199343.02306,	199347.69549,	199352.36793,	199357.04038,	199361.71284,	199366.38530,
199371.05778,	199375.73026,	199380.40276,	199385.07526,	199389.74778,	199394.42030,	199399.09283,	199403.76537,	199408.43792,	199413.11048,
199417.78305,	199422.45563,	199427.12822,	199431.80081,	199436.47342,	199441.14603,	199445.81866,	199450.49129,	199455.16394,	199459.83659,
199464.50925,	199469.18192,	199473.85460,	199478.52729,	199483.19999,	199487.87269,	199492.54541,	199497.21813,	199501.89087,	199506.56361,
199511.23637,	199515.90913,	199520.58190,	199525.25468,	199529.92747,	199534.60027,	199539.27308,	199543.94590,	199548.61873,	199553.29156,
199557.96441,	199562.63726,	199567.31013,	199571.98300,	199576.65588,	199581.32878,	199586.00168,	199590.67459,	199595.34751,	199600.02044,
199604.69337,	199609.36632,	199614.03928,	199618.71224,	199623.38522,	199628.05820,	199632.73119,	199637.40420,	199642.07721,	199646.75023,
199651.42326,	199656.09630,	199660.76935,	199665.44241,	199670.11547,	199674.78855,	199679.46163,	199684.13473,	199688.80783,	199693.48095,
199698.15407,	199702.82720,	199707.50034,	199712.17349,	199716.84665,	199721.51982,	199726.19300,	199730.86618,	199735.53938,	199740.21258,
199744.88580,	199749.55902,	199754.23225,	199758.90550,	199763.57875,	199768.25201,	199772.92528,	199777.59856,	199782.27185,	199786.94514,
199791.61845,	199796.29177,	199800.96509,	199805.63843,	199810.31177,	199814.98512,	199819.65848,	199824.33185,	199829.00523,	199833.67862,
199838.35202,	199843.02543,	199847.69885,	199852.37227,	199857.04571,	199861.71916,	199866.39261,	199871.06607,	199875.73955,	199880.41303,
199885.08652,	199889.76002,	199894.43353,	199899.10705,	199903.78057,	199908.45411,	199913.12766,	199917.80121,	199922.47478,	199927.14835,
199931.82193,	199936.49553,	199941.16913,	199945.84274,	199950.51636,	199955.18999,	199959.86362,	199964.53727,	199969.21093,	199973.88459,
199978.55827,	199983.23195,	199987.90565,	199992.57935,	199997.25306,	200001.92678,	200006.60051,	200011.27425,	200015.94800,	200020.62176,
200025.29553,	200029.96930,	200034.64309,	200039.31688,	200043.99069,	200048.66450,	200053.33832,	200058.01215,	200062.68600,	200067.35985,
200072.03370,	200076.70757,	200081.38145,	200086.05534,	200090.72923,	200095.40314,	200100.07705,	200104.75098,	200109.42491,	200114.09885,
200118.77280,	200123.44676,	200128.12073,	200132.79471,	200137.46870,	200142.14270,	200146.81670,	200151.49072,	200156.16474,	200160.83878,
200165.51282,	200170.18687,	200174.86093,	200179.53501,	200184.20909,	200188.88317,	200193.55727,	200198.23138,	200202.90550,	200207.57962,
200212.25376,	200216.92790,	200221.60206,	200226.27622,	200230.95039,	200235.62457,	200240.29876,	200244.97296,	200249.64717,	200254.32139,
200258.99562,	200263.66985,	200268.34410,	200273.01835,	200277.69262,	200282.36689,	200287.04117,	200291.71546,	200296.38976,	200301.06407,
200305.73839,	200310.41272,	200315.08706,	200319.76141,	200324.43576,	200329.11013,	200333.78450,	200338.45888,	200343.13328,	200347.80768,
200352.48209,	200357.15651,	200361.83094,	200366.50538,	200371.17983,	200375.85428,	200380.52875,	200385.20322,	200389.87771,	200394.55220,
200399.22671,	200403.90122,	200408.57574,	200413.25027,	200417.92481,	200422.59936,	200427.27392,	200431.94848,	200436.62306,	200441.29764,
200445.97224,	200450.64684,	200455.32146,	200459.99608,	200464.67071,	200469.34535,	200474.02000,	200478.69466,	200483.36933,	200488.04401,
200492.71869,	200497.39339,	200502.06809,	200506.74281,	200511.41753,	200516.09226,	200520.76701,	200525.44176,	200530.11652,	200534.79129,
200539.46606,	200544.14085,	200548.81565,	200553.49046,	200558.16527,	200562.84009,	200567.51493,	200572.18977,	200576.86462,	200581.53948,
200586.21435,	200590.88923,	200595.56412,	200600.23902,	200604.91393,	200609.58884,	200614.26377,	200618.93870,	200623.61365,	200628.28860,
200632.96356,	200637.63853,	200642.31351,	200646.98850,	200651.66350,	200656.33851,	200661.01353,	200665.68855,	200670.36359,	200675.03863,
200679.71369,	200684.38875,	200689.06382,	200693.73891,	200698.41400,	200703.08910,	200707.76420,	200712.43932,	200717.11445,	200721.78959,
200726.46473,	200731.13989,	200735.81505,	200740.49022,	200745.16541,	200749.84060,	200754.51580,	200759.19101,	200763.86623,	200768.54146,
200773.21669,	200777.89194,	200782.56720,	200787.24246,	200791.91774,	200796.59302,	200801.26831,	200805.94361,	200810.61892,	200815.29424,
200819.96957,	200824.64491,	200829.32026,	200833.99562,	200838.67098,	200843.34636,	200848.02174,	200852.69713,	200857.37254,	200862.04795,
200866.72337,	200871.39880,	200876.07424,	200880.74969,	200885.42514,	200890.10061,	200894.77609,	200899.45157,	200904.12707,	200908.80257,
200913.47808,	200918.15360,	200922.82913,	200927.50467,	200932.18022,	200936.85578,	200941.53135,	200946.20693,	200950.88251,	200955.55811,
200960.23371,	200964.90932,	200969.58495,	200974.26058,	200978.93622,	200983.61187,	200988.28753,	200992.96320,	200997.63888,	201002.31456,
201006.99026,	201011.66596,	201016.34168,	201021.01740,	201025.69313,	201030.36887,	201035.04463,	201039.72039,	201044.39615,	201049.07193,
201053.74772,	201058.42352,	201063.09932,	201067.77514,	201072.45096,	201077.12680,	201081.80264,	201086.47849,	201091.15435,	201095.83022,
201100.50610,	201105.18199,	201109.85789,	201114.53379,	201119.20971,	201123.88563,	201128.56157,	201133.23751,	201137.91346,	201142.58942,
201147.26539,	201151.94137,	201156.61736,	201161.29336,	201165.96937,	201170.64539,	201175.32141,	201179.99745,	201184.67349,	201189.34954,
201194.02561,	201198.70168,	201203.37776,	201208.05385,	201212.72995,	201217.40605,	201222.08217,	201226.75830,	201231.43443,	201236.11058,
201240.78673,	201245.46289,	201250.13907,	201254.81525,	201259.49144,	201264.16764,	201268.84385,	201273.52006,	201278.19629,	201282.87253,
201287.54877,	201292.22503,	201296.90129,	201301.57756,	201306.25385,	201310.93014,	201315.60644,	201320.28275,	201324.95907,	201329.63539,
201334.31173,	201338.98808,	201343.66443,	201348.34080,	201353.01717,	201357.69355,	201362.36994,	201367.04634,	201371.72275,	201376.39917,
201381.07560,	201385.75204,	201390.42849,	201395.10494,	201399.78141,	201404.45788,	201409.13436,	201413.81086,	201418.48736,	201423.16387,
201427.84039,	201432.51692,	201437.19346,	201441.87000,	201446.54656,	201451.22313,	201455.89970,	201460.57628,	201465.25288,	201469.92948,
201474.60609,	201479.28271,	201483.95934,	201488.63598,	201493.31263,	201497.98928,	201502.66595,	201507.34263,	201512.01931,	201516.69600,
201521.37271,	201526.04942,	201530.72614,	201535.40287,	201540.07961,	201544.75636,	201549.43312,	201554.10988,	201558.78666,	201563.46344,
201568.14024,	201572.81704,	201577.49385,	201582.17067,	201586.84751,	201591.52435,	201596.20119,	201600.87805,	201605.55492,	201610.23180,
201614.90868,	201619.58558,	201624.26248,	201628.93939,	201633.61632,	201638.29325,	201642.97019,	201647.64714,	201652.32410,	201657.00106,
201661.67804,	201666.35503,	201671.03202,	201675.70903,	201680.38604,	201685.06306,	201689.74009,	201694.41713,	201699.09418,	201703.77124,
201708.44831,	201713.12539,	201717.80248,	201722.47957,	201727.15668,	201731.83379,	201736.51091,	201741.18805,	201745.86519,	201750.54234,
201755.21950,	201759.89667,	201764.57384,	201769.25103,	201773.92823,	201778.60543,	201783.28265,	201787.95987,	201792.63710,	201797.31435,
201801.99160,	201806.66886,	201811.34613,	201816.02340,	201820.70069,	201825.37799,	201830.05529,	201834.73261,	201839.40993,	201844.08727,
201848.76461,	201853.44196,	201858.11932,	201862.79669,	201867.47407,	201872.15146,	201876.82885,	201881.50626,	201886.18368,	201890.86110,
201895.53853,	201900.21598,	201904.89343,	201909.57089,	201914.24836,	201918.92584,	201923.60333,	201928.28082,	201932.95833,	201937.63585,
201942.31337,	201946.99090,	201951.66845,	201956.34600,	201961.02356,	201965.70113,	201970.37871,	201975.05630,	201979.73390,	201984.41151,
201989.08912,	201993.76675,	201998.44438,	202003.12202,	202007.79968,	202012.47734,	202017.15501,	202021.83269,	202026.51038,	202031.18808,
202035.86578,	202040.54350,	202045.22123,	202049.89896,	202054.57670,	202059.25446,	202063.93222,	202068.60999,	202073.28777,	202077.96556,
202082.64336,	202087.32117,	202091.99898,	202096.67681,	202101.35464,	202106.03249,	202110.71034,	202115.38820,	202120.06607,	202124.74396,
202129.42185,	202134.09974,	202138.77765,	202143.45557,	202148.13350,	202152.81143,	202157.48937,	202162.16733,	202166.84529,	202171.52326,
202176.20124,	202180.87923,	202185.55723,	202190.23524,	202194.91326,	202199.59128,	202204.26932,	202208.94736,	202213.62542,	202218.30348,
202222.98155,	202227.65963,	202232.33772,	202237.01582,	202241.69393,	202246.37205,	202251.05018,	202255.72831,	202260.40646,	202265.08461,
202269.76277,	202274.44095,	202279.11913,	202283.79732,	202288.47552,	202293.15373,	202297.83195,	202302.51017,	202307.18841,	202311.86665,
202316.54491,	202321.22317,	202325.90144,	202330.57973,	202335.25802,	202339.93632,	202344.61462,	202349.29294,	202353.97127,	202358.64961,
202363.32795,	202368.00631,	202372.68467,	202377.36304,	202382.04142,	202386.71981,	202391.39821,	202396.07662,	202400.75504,	202405.43347,
202410.11191,	202414.79035,	202419.46881,	202424.14727,	202428.82574,	202433.50422,	202438.18272,	202442.86122,	202447.53972,	202452.21824,
202456.89677,	202461.57531,	202466.25385,	202470.93241,	202475.61097,	202480.28954,	202484.96813,	202489.64672,	202494.32532,	202499.00393,
202503.68255,	202508.36117,	202513.03981,	202517.71846,	202522.39711,	202527.07578,	202531.75445,	202536.43313,	202541.11182,	202545.79052,
202550.46923,	202555.14795,	202559.82668,	202564.50542,	202569.18416,	202573.86292,	202578.54168,	202583.22045,	202587.89924,	202592.57803,
202597.25683,	202601.93564,	202606.61446,	202611.29328,	202615.97212,	202620.65097,	202625.32982,	202630.00869,	202634.68756,	202639.36644,
202644.04533,	202648.72423,	202653.40314,	202658.08206,	202662.76099,	202667.43993,	202672.11887,	202676.79783,	202681.47679,	202686.15577,
202690.83475,	202695.51374,	202700.19274,	202704.87175,	202709.55077,	202714.22980,	202718.90883,	202723.58788,	202728.26694,	202732.94600,
202737.62507,	202742.30416,	202746.98325,	202751.66235,	202756.34146,	202761.02058,	202765.69971,	202770.37884,	202775.05799,	202779.73714,
202784.41631,	202789.09548,	202793.77466,	202798.45386,	202803.13306,	202807.81227,	202812.49149,	202817.17071,	202821.84995,	202826.52920,
202831.20845,	202835.88772,	202840.56699,	202845.24627,	202849.92556,	202854.60486,	202859.28417,	202863.96349,	202868.64282,	202873.32216,
202878.00150,	202882.68086,	202887.36022,	202892.03960,	202896.71898,	202901.39837,	202906.07777,	202910.75718,	202915.43660,	202920.11603,
202924.79546,	202929.47491,	202934.15437,	202938.83383,	202943.51330,	202948.19279,	202952.87228,	202957.55178,	202962.23129,	202966.91081,
202971.59033,	202976.26987,	202980.94942,	202985.62897,	202990.30854,	202994.98811,	202999.66769,	203004.34728,	203009.02688,	203013.70649,
203018.38611,	203023.06574,	203027.74538,	203032.42502,	203037.10468,	203041.78434,	203046.46401,	203051.14370,	203055.82339,	203060.50309,
203065.18280,	203069.86252,	203074.54224,	203079.22198,	203083.90173,	203088.58148,	203093.26125,	203097.94102,	203102.62080,	203107.30059,
203111.98039,	203116.66020,	203121.34002,	203126.01985,	203130.69968,	203135.37953,	203140.05938,	203144.73925,	203149.41912,	203154.09900,
203158.77889,	203163.45879,	203168.13870,	203172.81862,	203177.49855,	203182.17848,	203186.85843,	203191.53838,	203196.21835,	203200.89832,
203205.57830,	203210.25829,	203214.93829,	203219.61830,	203224.29832,	203228.97835,	203233.65838,	203238.33843,	203243.01848,	203247.69855,
203252.37862,	203257.05870,	203261.73879,	203266.41889,	203271.09900,	203275.77912,	203280.45925,	203285.13938,	203289.81953,	203294.49968,
203299.17984,	203303.86002,	203308.54020,	203313.22039,	203317.90059,	203322.58080,	203327.26101,	203331.94124,	203336.62148,	203341.30172,
203345.98197,	203350.66224,	203355.34251,	203360.02279,	203364.70308,	203369.38338,	203374.06369,	203378.74401,	203383.42433,	203388.10467,
203392.78501,	203397.46537,	203402.14573,	203406.82610,	203411.50648,	203416.18687,	203420.86727,	203425.54768,	203430.22810,	203434.90852,
203439.58896,	203444.26940,	203448.94985,	203453.63032,	203458.31079,	203462.99127,	203467.67176,	203472.35226,	203477.03277,	203481.71328,
203486.39381,	203491.07434,	203495.75489,	203500.43544,	203505.11600,	203509.79657,	203514.47715,	203519.15774,	203523.83834,	203528.51895,
203533.19956,	203537.88019,	203542.56083,	203547.24147,	203551.92212,	203556.60278,	203561.28345,	203565.96413,	203570.64482,	203575.32552,
203580.00623,	203584.68694,	203589.36767,	203594.04840,	203598.72915,	203603.40990,	203608.09066,	203612.77143,	203617.45221,	203622.13300,
203626.81380,	203631.49460,	203636.17542,	203640.85624,	203645.53708,	203650.21792,	203654.89877,	203659.57963,	203664.26050,	203668.94138,
203673.62227,	203678.30317,	203682.98408,	203687.66499,	203692.34592,	203697.02685,	203701.70779,	203706.38874,	203711.06970,	203715.75067,
203720.43165,	203725.11264,	203729.79364,	203734.47464,	203739.15566,	203743.83668,	203748.51771,	203753.19876,	203757.87981,	203762.56087,
203767.24194,	203771.92302,	203776.60410,	203781.28520,	203785.96631,	203790.64742,	203795.32854,	203800.00968,	203804.69082,	203809.37197,
203814.05313,	203818.73430,	203823.41548,	203828.09666,	203832.77786,	203837.45906,	203842.14028,	203846.82150,	203851.50273,	203856.18397,
203860.86522,	203865.54648,	203870.22775,	203874.90903,	203879.59032,	203884.27161,	203888.95292,	203893.63423,	203898.31555,	203902.99688,
203907.67822,	203912.35957,	203917.04093,	203921.72230,	203926.40368,	203931.08506,	203935.76646,	203940.44786,	203945.12928,	203949.81070,
203954.49213,	203959.17357,	203963.85502,	203968.53648,	203973.21794,	203977.89942,	203982.58091,	203987.26240,	203991.94390,	203996.62542,
204001.30694,	204005.98847,	204010.67001,	204015.35156,	204020.03312,	204024.71468,	204029.39626,	204034.07784,	204038.75944,	204043.44104,
204048.12265,	204052.80427,	204057.48590,	204062.16754,	204066.84919,	204071.53085,	204076.21251,	204080.89419,	204085.57587,	204090.25757,
204094.93927,	204099.62098,	204104.30270,	204108.98443,	204113.66617,	204118.34792,	204123.02967,	204127.71144,	204132.39321,	204137.07500,
204141.75679,	204146.43859,	204151.12040,	204155.80222,	204160.48405,	204165.16589,	204169.84774,	204174.52959,	204179.21146,	204183.89333,
204188.57522,	204193.25711,	204197.93901,	204202.62092,	204207.30284,	204211.98477,	204216.66671,	204221.34865,	204226.03061,	204230.71257,
204235.39454,	204240.07653,	204244.75852,	204249.44052,	204254.12253,	204258.80455,	204263.48658,	204268.16861,	204272.85066,	204277.53271,
204282.21478,	204286.89685,	204291.57893,	204296.26102,	204300.94312,	204305.62523,	204310.30735,	204314.98948,	204319.67161,	204324.35376,
204329.03591,	204333.71807,	204338.40025,	204343.08243,	204347.76462,	204352.44682,	204357.12903,	204361.81124,	204366.49347,	204371.17570,
204375.85795,	204380.54020,	204385.22246,	204389.90474,	204394.58702,	204399.26931,	204403.95160,	204408.63391,	204413.31623,	204417.99855,
204422.68089,	204427.36323,	204432.04559,	204436.72795,	204441.41032,	204446.09270,	204450.77509,	204455.45748,	204460.13989,	204464.82231,
204469.50473,	204474.18717,	204478.86961,	204483.55206,	204488.23452,	204492.91699,	204497.59947,	204502.28196,	204506.96446,	204511.64696,
204516.32948,	204521.01200,	204525.69453,	204530.37708,	204535.05963,	204539.74219,	204544.42476,	204549.10734,	204553.78992,	204558.47252,
204563.15512,	204567.83774,	204572.52036,	204577.20299,	204581.88564,	204586.56829,	204591.25095,	204595.93361,	204600.61629,	204605.29898,
204609.98167,	204614.66438,	204619.34709,	204624.02981,	204628.71255,	204633.39529,	204638.07804,	204642.76079,	204647.44356,	204652.12634,
204656.80912,	204661.49192,	204666.17472,	204670.85754,	204675.54036,	204680.22319,	204684.90603,	204689.58888,	204694.27173,	204698.95460,
204703.63748,	204708.32036,	204713.00326,	204717.68616,	204722.36907,	204727.05199,	204731.73492,	204736.41786,	204741.10081,	204745.78376,
204750.46673,	204755.14971,	204759.83269,	204764.51568,	204769.19868,	204773.88170,	204778.56472,	204783.24774,	204787.93078,	204792.61383,
204797.29689,	204801.97995,	204806.66302,	204811.34611,	204816.02920,	204820.71230,	204825.39541,	204830.07853,	204834.76166,	204839.44480,
204844.12794,	204848.81110,	204853.49426,	204858.17743,	204862.86062,	204867.54381,	204872.22701,	204876.91022,	204881.59344,	204886.27666,
204890.95990,	204895.64314,	204900.32640,	204905.00966,	204909.69293,	204914.37621,	204919.05950,	204923.74280,	204928.42611,	204933.10943,
204937.79276,	204942.47609,	204947.15944,	204951.84279,	204956.52615,	204961.20952,	204965.89290,	204970.57629,	204975.25969,	204979.94310,
204984.62651,	204989.30994,	204993.99337,	204998.67682,	205003.36027,	205008.04373,	205012.72720,	205017.41068,	205022.09417,	205026.77767,
205031.46117,	205036.14469,	205040.82821,	205045.51174,	205050.19529,	205054.87884,	205059.56240,	205064.24597,	205068.92955,	205073.61313,
205078.29673,	205082.98034,	205087.66395,	205092.34757,	205097.03121,	205101.71485,	205106.39850,	205111.08216,	205115.76582,	205120.44950,
205125.13319,	205129.81688,	205134.50059,	205139.18430,	205143.86802,	205148.55175,	205153.23549,	205157.91924,	205162.60300,	205167.28677,
205171.97055,	205176.65433,	205181.33813,	205186.02193,	205190.70574,	205195.38956,	205200.07339,	205204.75723,	205209.44108,	205214.12494,
205218.80880,	205223.49268,	205228.17656,	205232.86046,	205237.54436,	205242.22827,	205246.91219,	205251.59612,	205256.28006,	205260.96400,
205265.64796,	205270.33192,	205275.01590,	205279.69988,	205284.38387,	205289.06788,	205293.75189,	205298.43590,	205303.11993,	205307.80397,
205312.48802,	205317.17207,	205321.85613,	205326.54021,	205331.22429,	205335.90838,	205340.59248,	205345.27659,	205349.96071,	205354.64483,
205359.32897,	205364.01312,	205368.69727,	205373.38143,	205378.06560,	205382.74978,	205387.43397,	205392.11817,	205396.80238,	205401.48660,
205406.17082,	205410.85506,	205415.53930,	205420.22355,	205424.90782,	205429.59209,	205434.27637,	205438.96066,	205443.64495,	205448.32926,
205453.01358,	205457.69790,	205462.38223,	205467.06658,	205471.75093,	205476.43529,	205481.11966,	205485.80404,	205490.48842,	205495.17282,
205499.85723,	205504.54164,	205509.22606,	205513.91050,	205518.59494,	205523.27939,	205527.96385,	205532.64832,	205537.33279,	205542.01728,
205546.70177,	205551.38628,	205556.07079,	205560.75531,	205565.43985,	205570.12439,	205574.80893,	205579.49349,	205584.17806,	205588.86264,
205593.54722,	205598.23182,	205602.91642,	205607.60103,	205612.28565,	205616.97028,	205621.65492,	205626.33957,	205631.02422,	205635.70889,
205640.39357,	205645.07825,	205649.76294,	205654.44764,	205659.13235,	205663.81707,	205668.50180,	205673.18654,	205677.87129,	205682.55604,
205687.24081,	205691.92558,	205696.61036,	205701.29516,	205705.97996,	205710.66477,	205715.34958,	205720.03441,	205724.71925,	205729.40409,
205734.08895,	205738.77381,	205743.45868,	205748.14356,	205752.82845,	205757.51335,	205762.19826,	205766.88318,	205771.56810,	205776.25304,
205780.93798,	205785.62294,	205790.30790,	205794.99287,	205799.67785,	205804.36284,	205809.04784,	205813.73284,	205818.41786,	205823.10288,
205827.78792,	205832.47296,	205837.15801,	205841.84307,	205846.52814,	205851.21322,	205855.89831,	205860.58341,	205865.26851,	205869.95363,
205874.63875,	205879.32388,	205884.00902,	205888.69417,	205893.37933,	205898.06450,	205902.74968,	205907.43486,	205912.12006,	205916.80526,
205921.49048,	205926.17570,	205930.86093,	205935.54617,	205940.23142,	205944.91668,	205949.60194,	205954.28722,	205958.97250,	205963.65780,
205968.34310,	205973.02841,	205977.71373,	205982.39906,	205987.08440,	205991.76975,	205996.45510,	206001.14047,	206005.82584,	206010.51123,
206015.19662,	206019.88202,	206024.56743,	206029.25285,	206033.93828,	206038.62372,	206043.30916,	206047.99462,	206052.68008,	206057.36556,
206062.05104,	206066.73653,	206071.42203,	206076.10754,	206080.79305,	206085.47858,	206090.16412,	206094.84966,	206099.53522,	206104.22078,
206108.90635,	206113.59193,	206118.27752,	206122.96312,	206127.64873,	206132.33434,	206137.01997,	206141.70560,	206146.39124,	206151.07690,
206155.76256,	206160.44823,	206165.13391,	206169.81960,	206174.50529,	206179.19100,	206183.87671,	206188.56244,	206193.24817,	206197.93391,
206202.61966,	206207.30542,	206211.99119,	206216.67697,	206221.36275,	206226.04855,	206230.73435,	206235.42017,	206240.10599,	206244.79182,
206249.47766,	206254.16351,	206258.84937,	206263.53524,	206268.22111,	206272.90700,	206277.59289,	206282.27879,	206286.96471,	206291.65063,
206296.33656,	206301.02249,	206305.70844,	206310.39440,	206315.08036,	206319.76634,	206324.45232,	206329.13831,	206333.82432,	206338.51033,
206343.19635,	206347.88237,	206352.56841,	206357.25446,	206361.94051,	206366.62658,	206371.31265,	206375.99873,	206380.68482,	206385.37092,
206390.05703,	206394.74315,	206399.42927,	206404.11541,	206408.80155,	206413.48771,	206418.17387,	206422.86004,	206427.54622,	206432.23241,
206436.91861,	206441.60482,	206446.29103,	206450.97726,	206455.66349,	206460.34973,	206465.03599,	206469.72225,	206474.40852,	206479.09480,
206483.78108,	206488.46738,	206493.15369,	206497.84000,	206502.52632,	206507.21266,	206511.89900,	206516.58535,	206521.27171,	206525.95807,
206530.64445,	206535.33084,	206540.01723,	206544.70364,	206549.39005,	206554.07647,	206558.76290,	206563.44934,	206568.13579,	206572.82225,
206577.50871,	206582.19519,	206586.88167,	206591.56817,	206596.25467,	206600.94118,	206605.62770,	206610.31423,	206615.00077,	206619.68731,
206624.37387,	206629.06043,	206633.74701,	206638.43359,	206643.12018,	206647.80678,	206652.49339,	206657.18001,	206661.86664,	206666.55327,
206671.23992,	206675.92657,	206680.61324,	206685.29991,	206689.98659,	206694.67328,	206699.35998,	206704.04669,	206708.73340,	206713.42013,
206718.10686,	206722.79361,	206727.48036,	206732.16712,	206736.85389,	206741.54067,	206746.22746,	206750.91426,	206755.60106,	206760.28788,
206764.97470,	206769.66153,	206774.34837,	206779.03523,	206783.72208,	206788.40895,	206793.09583,	206797.78272,	206802.46961,	206807.15652,
206811.84343,	206816.53035,	206821.21728,	206825.90422,	206830.59117,	206835.27813,	206839.96510,	206844.65207,	206849.33906,	206854.02605,
206858.71305,	206863.40006,	206868.08709,	206872.77411,	206877.46115,	206882.14820,	206886.83526,	206891.52232,	206896.20939,	206900.89648,
206905.58357,	206910.27067,	206914.95778,	206919.64490,	206924.33203,	206929.01916,	206933.70631,	206938.39346,	206943.08062,	206947.76780,
206952.45498,	206957.14217,	206961.82937,	206966.51657,	206971.20379,	206975.89102,	206980.57825,	206985.26550,	206989.95275,	206994.64001,
206999.32728,	207004.01456,	207008.70185,	207013.38914,	207018.07645,	207022.76376,	207027.45109,	207032.13842,	207036.82576,	207041.51311,
207046.20047,	207050.88784,	207055.57522,	207060.26260,	207064.95000,	207069.63740,	207074.32482,	207079.01224,	207083.69967,	207088.38711,
207093.07456,	207097.76202,	207102.44948,	207107.13696,	207111.82444,	207116.51194,	207121.19944,	207125.88695,	207130.57447,	207135.26200,
207139.94954,	207144.63708,	207149.32464,	207154.01220,	207158.69978,	207163.38736,	207168.07495,	207172.76255,	207177.45016,	207182.13778,
207186.82540,	207191.51304,	207196.20069,	207200.88834,	207205.57600,	207210.26367,	207214.95135,	207219.63904,	207224.32674,	207229.01445,
207233.70217,	207238.38989,	207243.07762,	207247.76537,	207252.45312,	207257.14088,	207261.82865,	207266.51643,	207271.20422,	207275.89201,
207280.57982,	207285.26763,	207289.95546,	207294.64329,	207299.33113,	207304.01898,	207308.70684,	207313.39470,	207318.08258,	207322.77047,
207327.45836,	207332.14626,	207336.83418,	207341.52210,	207346.21003,	207350.89797,	207355.58591,	207360.27387,	207364.96184,	207369.64981,
207374.33780,	207379.02579,	207383.71379,	207388.40180,	207393.08982,	207397.77785,	207402.46588,	207407.15393,	207411.84198,	207416.53005,
207421.21812,	207425.90620,	207430.59429,	207435.28239,	207439.97050,	207444.65862,	207449.34674,	207454.03488,	207458.72302,	207463.41117,
207468.09934,	207472.78751,	207477.47569,	207482.16387,	207486.85207,	207491.54028,	207496.22849,	207500.91672,	207505.60495,	207510.29319,
207514.98144,	207519.66970,	207524.35797,	207529.04625,	207533.73453,	207538.42283,	207543.11113,	207547.79945,	207552.48777,	207557.17610,
207561.86444,	207566.55279,	207571.24115,	207575.92951,	207580.61789,	207585.30627,	207589.99466,	207594.68307,	207599.37148,	207604.05990,
207608.74833,	207613.43676,	207618.12521,	207622.81367,	207627.50213,	207632.19060,	207636.87909,	207641.56758,	207646.25608,	207650.94459,
207655.63310,	207660.32163,	207665.01016,	207669.69871,	207674.38726,	207679.07582,	207683.76440,	207688.45298,	207693.14156,	207697.83016,
207702.51877,	207707.20738,	207711.89601,	207716.58464,	207721.27328,	207725.96194,	207730.65060,	207735.33926,	207740.02794,	207744.71663,
207749.40533,	207754.09403,	207758.78274,	207763.47147,	207768.16020,	207772.84894,	207777.53769,	207782.22644,	207786.91521,	207791.60399,
207796.29277,	207800.98156,	207805.67037,	207810.35918,	207815.04800,	207819.73683,	207824.42566,	207829.11451,	207833.80337,	207838.49223,
207843.18110,	207847.86999,	207852.55888,	207857.24778,	207861.93669,	207866.62561,	207871.31453,	207876.00347,	207880.69241,	207885.38137,
207890.07033,	207894.75930,	207899.44828,	207904.13727,	207908.82627,	207913.51527,	207918.20429,	207922.89331,	207927.58235,	207932.27139,
207936.96044,	207941.64950,	207946.33857,	207951.02765,	207955.71673,	207960.40583,	207965.09493,	207969.78405,	207974.47317,	207979.16230,
207983.85144,	207988.54059,	207993.22975,	207997.91892,	208002.60809,	208007.29728,	208011.98647,	208016.67567,	208021.36488,	208026.05410,
208030.74333,	208035.43257,	208040.12182,	208044.81107,	208049.50034,	208054.18961,	208058.87889,	208063.56818,	208068.25748,	208072.94679,
208077.63611,	208082.32544,	208087.01477,	208091.70412,	208096.39347,	208101.08283,	208105.77220,	208110.46158,	208115.15097,	208119.84037,
208124.52977,	208129.21919,	208133.90861,	208138.59805,	208143.28749,	208147.97694,	208152.66640,	208157.35587,	208162.04535,	208166.73483,
208171.42433,	208176.11383,	208180.80335,	208185.49287,	208190.18240,	208194.87194,	208199.56149,	208204.25104,	208208.94061,	208213.63019,
208218.31977,	208223.00936,	208227.69896,	208232.38858,	208237.07820,	208241.76782,	208246.45746,	208251.14711,	208255.83676,	208260.52643,
208265.21610,	208269.90578,	208274.59547,	208279.28517,	208283.97488,	208288.66460,	208293.35432,	208298.04406,	208302.73380,	208307.42355,
208312.11332,	208316.80309,	208321.49287,	208326.18265,	208330.87245,	208335.56226,	208340.25207,	208344.94189,	208349.63173,	208354.32157,
208359.01142,	208363.70128,	208368.39115,	208373.08102,	208377.77091,	208382.46080,	208387.15071,	208391.84062,	208396.53054,	208401.22047,
208405.91041,	208410.60036,	208415.29031,	208419.98028,	208424.67025,	208429.36024,	208434.05023,	208438.74023,	208443.43024,	208448.12026,
208452.81029,	208457.50032,	208462.19037,	208466.88042,	208471.57049,	208476.26056,	208480.95064,	208485.64073,	208490.33083,	208495.02093,
208499.71105,	208504.40118,	208509.09131,	208513.78145,	208518.47161,	208523.16177,	208527.85194,	208532.54211,	208537.23230,	208541.92250,
208546.61270,	208551.30292,	208555.99314,	208560.68337,	208565.37361,	208570.06386,	208574.75412,	208579.44438,	208584.13466,	208588.82495,
208593.51524,	208598.20554,	208602.89585,	208607.58617,	208612.27650,	208616.96684,	208621.65719,	208626.34754,	208631.03791,	208635.72828,
208640.41866,	208645.10905,	208649.79945,	208654.48986,	208659.18028,	208663.87071,	208668.56114,	208673.25158,	208677.94204,	208682.63250,
208687.32297,	208692.01345,	208696.70394,	208701.39444,	208706.08494,	208710.77546,	208715.46598,	208720.15651,	208724.84706,	208729.53761,
208734.22817,	208738.91873,	208743.60931,	208748.29990,	208752.99049,	208757.68109,	208762.37171,	208767.06233,	208771.75296,	208776.44360,
208781.13425,	208785.82490,	208790.51557,	208795.20624,	208799.89693,	208804.58762,	208809.27832,	208813.96903,	208818.65975,	208823.35047,
208828.04121,	208832.73196,	208837.42271,	208842.11347,	208846.80425,	208851.49503,	208856.18582,	208860.87661,	208865.56742,	208870.25824,
208874.94906,	208879.63990,	208884.33074,	208889.02159,	208893.71245,	208898.40332,	208903.09420,	208907.78508,	208912.47598,	208917.16688,
208921.85780,	208926.54872,	208931.23965,	208935.93059,	208940.62154,	208945.31250,	208950.00346,	208954.69444,	208959.38542,	208964.07642,
208968.76742,	208973.45843,	208978.14945,	208982.84048,	208987.53151,	208992.22256,	208996.91362,	209001.60468,	209006.29575,	209010.98683,
209015.67792,	209020.36902,	209025.06013,	209029.75125,	209034.44237,	209039.13351,	209043.82465,	209048.51580,	209053.20696,	209057.89813,
209062.58931,	209067.28050,	209071.97170,	209076.66290,	209081.35412,	209086.04534,	209090.73657,	209095.42781,	209100.11906,	209104.81032,
209109.50159,	209114.19286,	209118.88415,	209123.57544,	209128.26674,	209132.95806,	209137.64938,	209142.34071,	209147.03204,	209151.72339,
209156.41475,	209161.10611,	209165.79748,	209170.48887,	209175.18026,	209179.87166,	209184.56306,	209189.25448,	209193.94591,	209198.63734,
209203.32879,	209208.02024,	209212.71170,	209217.40317,	209222.09465,	209226.78614,	209231.47764,	209236.16914,	209240.86066,	209245.55218,
209250.24371,	209254.93526,	209259.62681,	209264.31836,	209269.00993,	209273.70151,	209278.39309,	209283.08469,	209287.77629,	209292.46790,
209297.15952,	209301.85115,	209306.54279,	209311.23444,	209315.92609,	209320.61776,	209325.30943,	209330.00112,	209334.69281,	209339.38451,
209344.07622,	209348.76793,	209353.45966,	209358.15140,	209362.84314,	209367.53489,	209372.22666,	209376.91843,	209381.61021,	209386.30200,
209390.99379,	209395.68560,	209400.37741,	209405.06924,	209409.76107,	209414.45291,	209419.14476,	209423.83662,	209428.52849,	209433.22037,
209437.91225,	209442.60415,	209447.29605,	209451.98796,	209456.67988,	209461.37181,	209466.06375,	209470.75570,	209475.44765,	209480.13962,
209484.83159,	209489.52358,	209494.21557,	209498.90757,	209503.59958,	209508.29160,	209512.98362,	209517.67566,	209522.36770,	209527.05976,
209531.75182,	209536.44389,	209541.13597,	209545.82806,	209550.52016,	209555.21226,	209559.90438,	209564.59650,	209569.28863,	209573.98078,
209578.67293,	209583.36508,	209588.05725,	209592.74943,	209597.44162,	209602.13381,	209606.82601,	209611.51823,	209616.21045,	209620.90268,
209625.59492,	209630.28716,	209634.97942,	209639.67168,	209644.36396,	209649.05624,	209653.74853,	209658.44083,	209663.13314,	209667.82546,
209672.51779,	209677.21012,	209681.90247,	209686.59482,	209691.28718,	209695.97955,	209700.67193,	209705.36432,	209710.05672,	209714.74913,
209719.44154,	209724.13396,	209728.82640,	209733.51884,	209738.21129,	209742.90375,	209747.59622,	209752.28869,	209756.98118,	209761.67367,
209766.36618,	209771.05869,	209775.75121,	209780.44374,	209785.13628,	209789.82882,	209794.52138,	209799.21395,	209803.90652,	209808.59910,
209813.29169,	209817.98429,	209822.67690,	209827.36952,	209832.06215,	209836.75478,	209841.44743,	209846.14008,	209850.83274,	209855.52541,
209860.21809,	209864.91078,	209869.60348,	209874.29618,	209878.98890,	209883.68162,	209888.37435,	209893.06710,	209897.75985,	209902.45260,
209907.14537,	209911.83815,	209916.53093,	209921.22373,	209925.91653,	209930.60934,	209935.30216,	209939.99499,	209944.68783,	209949.38068,
209954.07353,	209958.76640,	209963.45927,	209968.15215,	209972.84504,	209977.53794,	209982.23085,	209986.92377,	209991.61670,	209996.30963,
210001.00257,	210005.69553,	210010.38849,	210015.08146,	210019.77444,	210024.46743,	210029.16042,	210033.85343,	210038.54644,	210043.23946,
210047.93250,	210052.62554,	210057.31859,	210062.01165,	210066.70471,	210071.39779,	210076.09087,	210080.78397,	210085.47707,	210090.17018,
210094.86330,	210099.55643,	210104.24957,	210108.94271,	210113.63587,	210118.32903,	210123.02220,	210127.71539,	210132.40858,	210137.10178,
210141.79498,	210146.48820,	210151.18143,	210155.87466,	210160.56790,	210165.26115,	210169.95442,	210174.64769,	210179.34096,	210184.03425,
210188.72755,	210193.42085,	210198.11416,	210202.80749,	210207.50082,	210212.19416,	210216.88751,	210221.58086,	210226.27423,	210230.96761,
210235.66099,	210240.35438,	210245.04778,	210249.74119,	210254.43461,	210259.12804,	210263.82148,	210268.51492,	210273.20838,	210277.90184,
210282.59531,	210287.28879,	210291.98228,	210296.67578,	210301.36929,	210306.06280,	210310.75633,	210315.44986,	210320.14341,	210324.83696,
210329.53052,	210334.22409,	210338.91766,	210343.61125,	210348.30484,	210352.99845,	210357.69206,	210362.38568,	210367.07931,	210371.77295,
210376.46660,	210381.16026,	210385.85392,	210390.54760,	210395.24128,	210399.93497,	210404.62867,	210409.32238,	210414.01610,	210418.70982,
210423.40356,	210428.09731,	210432.79106,	210437.48482,	210442.17859,	210446.87237,	210451.56616,	210456.25996,	210460.95376,	210465.64758,
210470.34140,	210475.03523,	210479.72908,	210484.42293,	210489.11678,	210493.81065,	210498.50453,	210503.19841,	210507.89231,	210512.58621,
210517.28012,	210521.97404,	210526.66797,	210531.36191,	210536.05586,	210540.74981,	210545.44378,	210550.13775,	210554.83173,	210559.52572,
210564.21972,	210568.91373,	210573.60775,	210578.30177,	210582.99581,	210587.68985,	210592.38390,	210597.07796,	210601.77203,	210606.46611,
210611.16020,	210615.85429,	210620.54840,	210625.24251,	210629.93663,	210634.63077,	210639.32491,	210644.01905,	210648.71321,	210653.40738,
210658.10155,	210662.79574,	210667.48993,	210672.18413,	210676.87834,	210681.57256,	210686.26679,	210690.96102,	210695.65527,	210700.34952,
210705.04379,	210709.73806,	210714.43234,	210719.12663,	210723.82093,	210728.51523,	210733.20955,	210737.90387,	210742.59821,	210747.29255,
210751.98690,	210756.68126,	210761.37563,	210766.07000,	210770.76439,	210775.45878,	210780.15319,	210784.84760,	210789.54202,	210794.23645,
210798.93089,	210803.62534,	210808.31979,	210813.01426,	210817.70873,	210822.40321,	210827.09770,	210831.79220,	210836.48671,	210841.18123,
210845.87576,	210850.57029,	210855.26483,	210859.95939,	210864.65395,	210869.34852,	210874.04310,	210878.73768,	210883.43228,	210888.12689,
210892.82150,	210897.51612,	210902.21075,	210906.90539,	210911.60004,	210916.29470,	210920.98937,	210925.68404,	210930.37873,	210935.07342,
210939.76812,	210944.46283,	210949.15755,	210953.85228,	210958.54702,	210963.24176,	210967.93652,	210972.63128,	210977.32605,	210982.02083,
210986.71562,	210991.41042,	210996.10523,	211000.80004,	211005.49487,	211010.18970,	211014.88454,	211019.57939,	211024.27425,	211028.96912,
211033.66400,	211038.35888,	211043.05378,	211047.74868,	211052.44359,	211057.13852,	211061.83344,	211066.52838,	211071.22333,	211075.91829,
211080.61325,	211085.30822,	211090.00321,	211094.69820,	211099.39320,	211104.08821,	211108.78322,	211113.47825,	211118.17329,	211122.86833,
211127.56338,	211132.25844,	211136.95351,	211141.64859,	211146.34368,	211151.03877,	211155.73388,	211160.42899,	211165.12412,	211169.81925,
211174.51439,	211179.20954,	211183.90469,	211188.59986,	211193.29504,	211197.99022,	211202.68541,	211207.38061,	211212.07582,	211216.77104,
211221.46627,	211226.16151,	211230.85675,	211235.55201,	211240.24727,	211244.94254,	211249.63782,	211254.33311,	211259.02841,	211263.72371,
211268.41903,	211273.11435,	211277.80969,	211282.50503,	211287.20038,	211291.89574,	211296.59110,	211301.28648,	211305.98187,	211310.67726,
211315.37266,	211320.06807,	211324.76350,	211329.45892,	211334.15436,	211338.84981,	211343.54526,	211348.24073,	211352.93620,	211357.63168,
211362.32717,	211367.02267,	211371.71818,	211376.41370,	211381.10922,	211385.80476,	211390.50030,	211395.19585,	211399.89141,	211404.58698,
211409.28256,	211413.97815,	211418.67374,	211423.36935,	211428.06496,	211432.76058,	211437.45621,	211442.15185,	211446.84750,	211451.54316,
211456.23882,	211460.93449,	211465.63018,	211470.32587,	211475.02157,	211479.71728,	211484.41300,	211489.10872,	211493.80446,	211498.50020,
211503.19596,	211507.89172,	211512.58749,	211517.28327,	211521.97906,	211526.67485,	211531.37066,	211536.06647,	211540.76230,	211545.45813,
211550.15397,	211554.84982,	211559.54568,	211564.24154,	211568.93742,	211573.63330,	211578.32920,	211583.02510,	211587.72101,	211592.41693,
211597.11285,	211601.80879,	211606.50474,	211611.20069,	211615.89665,	211620.59263,	211625.28861,	211629.98460,	211634.68059,	211639.37660,
211644.07262,	211648.76864,	211653.46467,	211658.16071,	211662.85677,	211667.55282,	211672.24889,	211676.94497,	211681.64105,	211686.33715,
211691.03325,	211695.72936,	211700.42548,	211705.12161,	211709.81775,	211714.51390,	211719.21005,	211723.90622,	211728.60239,	211733.29857,
211737.99476,	211742.69096,	211747.38717,	211752.08338,	211756.77961,	211761.47584,	211766.17209,	211770.86834,	211775.56460,	211780.26087,
211784.95715,	211789.65343,	211794.34973,	211799.04603,	211803.74234,	211808.43867,	211813.13500,	211817.83133,	211822.52768,	211827.22404,
211831.92040,	211836.61678,	211841.31316,	211846.00955,	211850.70595,	211855.40236,	211860.09878,	211864.79520,	211869.49164,	211874.18808,
211878.88454,	211883.58100,	211888.27747,	211892.97395,	211897.67043,	211902.36693,	211907.06343,	211911.75995,	211916.45647,	211921.15300,
211925.84954,	211930.54609,	211935.24265,	211939.93921,	211944.63579,	211949.33237,	211954.02896,	211958.72556,	211963.42217,	211968.11879,
211972.81542,	211977.51206,	211982.20870,	211986.90535,	211991.60202,	211996.29869,	212000.99537,	212005.69205,	212010.38875,	212015.08546,
212019.78217,	212024.47890,	212029.17563,	212033.87237,	212038.56912,	212043.26588,	212047.96264,	212052.65942,	212057.35620,	212062.05300,
212066.74980,	212071.44661,	212076.14343,	212080.84025,	212085.53709,	212090.23394,	212094.93079,	212099.62765,	212104.32453,	212109.02141,
212113.71830,	212118.41519,	212123.11210,	212127.80902,	212132.50594,	212137.20287,	212141.89981,	212146.59676,	212151.29372,	212155.99069,
212160.68767,	212165.38465,	212170.08165,	212174.77865,	212179.47566,	212184.17268,	212188.86971,	212193.56675,	212198.26379,	212202.96085,
212207.65791,	212212.35498,	212217.05206,	212221.74915,	212226.44625,	212231.14336,	212235.84047,	212240.53760,	212245.23473,	212249.93188,
212254.62903,	212259.32619,	212264.02335,	212268.72053,	212273.41772,	212278.11491,	212282.81211,	212287.50933,	212292.20655,	212296.90378,
212301.60101,	212306.29826,	212310.99552,	212315.69278,	212320.39005,	212325.08734,	212329.78463,	212334.48192,	212339.17923,	212343.87655,
212348.57387,	212353.27121,	212357.96855,	212362.66590,	212367.36326,	212372.06063,	212376.75801,	212381.45540,	212386.15279,	212390.85019,
212395.54761,	212400.24503,	212404.94246,	212409.63990,	212414.33734,	212419.03480,	212423.73226,	212428.42974,	212433.12722,	212437.82471,
212442.52221,	212447.21972,	212451.91724,	212456.61476,	212461.31230,	212466.00984,	212470.70739,	212475.40495,	212480.10252,	212484.80010,
212489.49769,	212494.19528,	212498.89289,	212503.59050,	212508.28812,	212512.98575,	212517.68339,	212522.38104,	212527.07869,	212531.77636,
212536.47403,	212541.17171,	212545.86941,	212550.56711,	212555.26481,	212559.96253,	212564.66026,	212569.35799,	212574.05574,	212578.75349,
212583.45125,	212588.14902,	212592.84680,	212597.54459,	212602.24238,	212606.94019,	212611.63800,	212616.33582,	212621.03365,	212625.73149,
212630.42934,	212635.12720,	212639.82506,	212644.52294,	212649.22082,	212653.91871,	212658.61661,	212663.31452,	212668.01244,	212672.71036,
212677.40830,	212682.10624,	212686.80420,	212691.50216,	212696.20013,	212700.89810,	212705.59609,	212710.29409,	212714.99209,	212719.69011,
212724.38813,	212729.08616,	212733.78420,	212738.48225,	212743.18030,	212747.87837,	212752.57645,	212757.27453,	212761.97262,	212766.67072,
212771.36883,	212776.06695,	212780.76507,	212785.46321,	212790.16135,	212794.85951,	212799.55767,	212804.25584,	212808.95402,	212813.65220,
212818.35040,	212823.04861,	212827.74682,	212832.44504,	212837.14327,	212841.84151,	212846.53976,	212851.23802,	212855.93628,	212860.63456,
212865.33284,	212870.03113,	212874.72943,	212879.42774,	212884.12606,	212888.82439,	212893.52272,	212898.22107,	212902.91942,	212907.61778,
212912.31615,	212917.01453,	212921.71292,	212926.41132,	212931.10972,	212935.80814,	212940.50656,	212945.20499,	212949.90343,	212954.60188,
212959.30033,	212963.99880,	212968.69727,	212973.39576,	212978.09425,	212982.79275,	212987.49126,	212992.18978,	212996.88831,	213001.58684,
213006.28538,	213010.98394,	213015.68250,	213020.38107,	213025.07965,	213029.77824,	213034.47683,	213039.17544,	213043.87405,	213048.57267,
213053.27131,	213057.96994,	213062.66859,	213067.36725,	213072.06592,	213076.76459,	213081.46327,	213086.16197,	213090.86067,	213095.55938,
213100.25809,	213104.95682,	213109.65556,	213114.35430,	213119.05305,	213123.75181,	213128.45059,	213133.14936,	213137.84815,	213142.54695,
213147.24575,	213151.94457,	213156.64339,	213161.34222,	213166.04106,	213170.73991,	213175.43876,	213180.13763,	213184.83651,	213189.53539,
213194.23428,	213198.93318,	213203.63209,	213208.33101,	213213.02993,	213217.72887,	213222.42781,	213227.12677,	213231.82573,	213236.52470,
213241.22368,	213245.92266,	213250.62166,	213255.32066,	213260.01968,	213264.71870,	213269.41773,	213274.11677,	213278.81582,	213283.51488,
213288.21394,	213292.91301,	213297.61210,	213302.31119,	213307.01029,	213311.70940,	213316.40852,	213321.10764,	213325.80678,	213330.50592,
213335.20507,	213339.90423,	213344.60340,	213349.30258,	213354.00177,	213358.70097,	213363.40017,	213368.09938,	213372.79861,	213377.49784,
213382.19707,	213386.89632,	213391.59558,	213396.29484,	213400.99412,	213405.69340,	213410.39269,	213415.09199,	213419.79130,	213424.49062,
213429.18994,	213433.88928,	213438.58862,	213443.28797,	213447.98733,	213452.68670,	213457.38608,	213462.08547,	213466.78486,	213471.48427,
213476.18368,	213480.88310,	213485.58253,	213490.28197,	213494.98142,	213499.68088,	213504.38034,	213509.07981,	213513.77930,	213518.47879,
213523.17829,	213527.87779,	213532.57731,	213537.27684,	213541.97637,	213546.67591,	213551.37547,	213556.07503,	213560.77459,	213565.47417,
213570.17376,	213574.87335,	213579.57296,	213584.27257,	213588.97219,	213593.67182,	213598.37146,	213603.07110,	213607.77076,	213612.47042,
213617.17010,	213621.86978,	213626.56947,	213631.26917,	213635.96888,	213640.66859,	213645.36832,	213650.06805,	213654.76779,	213659.46754,
213664.16730,	213668.86707,	213673.56685,	213678.26664,	213682.96643,	213687.66623,	213692.36604,	213697.06587,	213701.76569,	213706.46553,
213711.16538,	213715.86523,	213720.56510,	213725.26497,	213729.96485,	213734.66474,	213739.36464,	213744.06455,	213748.76446,	213753.46439,
213758.16432,	213762.86426,	213767.56421,	213772.26417,	213776.96414,	213781.66411,	213786.36410,	213791.06409,	213795.76410,	213800.46411,
213805.16413,	213809.86415,	213814.56419,	213819.26424,	213823.96429,	213828.66436,	213833.36443,	213838.06451,	213842.76460,	213847.46469,
213852.16480,	213856.86492,	213861.56504,	213866.26517,	213870.96531,	213875.66546,	213880.36562,	213885.06579,	213889.76596,	213894.46615,
213899.16634,	213903.86654,	213908.56675,	213913.26697,	213917.96720,	213922.66744,	213927.36768,	213932.06793,	213936.76820,	213941.46847,
213946.16875,	213950.86903,	213955.56933,	213960.26964,	213964.96995,	213969.67027,	213974.37061,	213979.07095,	213983.77130,	213988.47165,
213993.17202,	213997.87239,	214002.57278,	214007.27317,	214011.97357,	214016.67398,	214021.37440,	214026.07482,	214030.77526,	214035.47570,
214040.17616,	214044.87662,	214049.57709,	214054.27757,	214058.97805,	214063.67855,	214068.37906,	214073.07957,	214077.78009,	214082.48062,
214087.18116,	214091.88171,	214096.58227,	214101.28283,	214105.98340,	214110.68399,	214115.38458,	214120.08518,	214124.78579,	214129.48640,
214134.18703,	214138.88766,	214143.58831,	214148.28896,	214152.98962,	214157.69029,	214162.39097,	214167.09165,	214171.79235,	214176.49305,
214181.19376,	214185.89449,	214190.59521,	214195.29595,	214199.99670,	214204.69746,	214209.39822,	214214.09899,	214218.79977,	214223.50056,
214228.20136,	214232.90217,	214237.60299,	214242.30381,	214247.00465,	214251.70549,	214256.40634,	214261.10720,	214265.80807,	214270.50894,
214275.20983,	214279.91072,	214284.61162,	214289.31254,	214294.01346,	214298.71438,	214303.41532,	214308.11627,	214312.81722,	214317.51819,
214322.21916,	214326.92014,	214331.62113,	214336.32212,	214341.02313,	214345.72415,	214350.42517,	214355.12620,	214359.82724,	214364.52829,
214369.22935,	214373.93042,	214378.63149,	214383.33258,	214388.03367,	214392.73477,	214397.43588,	214402.13700,	214406.83813,	214411.53926,
214416.24041,	214420.94156,	214425.64272,	214430.34389,	214435.04507,	214439.74626,	214444.44746,	214449.14866,	214453.84988,	214458.55110,
214463.25233,	214467.95357,	214472.65482,	214477.35608,	214482.05734,	214486.75862,	214491.45990,	214496.16119,	214500.86249,	214505.56380,
214510.26512,	214514.96644,	214519.66778,	214524.36912,	214529.07047,	214533.77183,	214538.47320,	214543.17458,	214547.87597,	214552.57736,
214557.27877,	214561.98018,	214566.68160,	214571.38303,	214576.08447,	214580.78592,	214585.48737,	214590.18884,	214594.89031,	214599.59179,
214604.29328,	214608.99478,	214613.69629,	214618.39780,	214623.09933,	214627.80086,	214632.50241,	214637.20396,	214641.90552,	214646.60708,
214651.30866,	214656.01025,	214660.71184,	214665.41344,	214670.11505,	214674.81667,	214679.51830,	214684.21994,	214688.92158,	214693.62324,
214698.32490,	214703.02657,	214707.72825,	214712.42994,	214717.13164,	214721.83335,	214726.53506,	214731.23678,	214735.93852,	214740.64026,
214745.34201,	214750.04376,	214754.74553,	214759.44730,	214764.14909,	214768.85088,	214773.55268,	214778.25449,	214782.95631,	214787.65814,
214792.35997,	214797.06182,	214801.76367,	214806.46553,	214811.16740,	214815.86928,	214820.57117,	214825.27306,	214829.97497,	214834.67688,
214839.37880,	214844.08073,	214848.78267,	214853.48462,	214858.18658,	214862.88854,	214867.59051,	214872.29250,	214876.99449,	214881.69649,
214886.39850,	214891.10051,	214895.80254,	214900.50457,	214905.20661,	214909.90867,	214914.61073,	214919.31279,	214924.01487,	214928.71696,
214933.41905,	214938.12115,	214942.82327,	214947.52539,	214952.22751,	214956.92965,	214961.63180,	214966.33395,	214971.03612,	214975.73829,
214980.44047,	214985.14266,	214989.84486,	214994.54706,	214999.24928,	215003.95150,	215008.65373,	215013.35597,	215018.05822,	215022.76048,
215027.46275,	215032.16502,	215036.86731,	215041.56960,	215046.27190,	215050.97421,	215055.67653,	215060.37886,	215065.08119,	215069.78354,
215074.48589,	215079.18825,	215083.89062,	215088.59300,	215093.29539,	215097.99778,	215102.70019,	215107.40260,	215112.10502,	215116.80745,
215121.50989,	215126.21234,	215130.91480,	215135.61726,	215140.31974,	215145.02222,	215149.72471,	215154.42721,	215159.12972,	215163.83223,
215168.53476,	215173.23729,	215177.93984,	215182.64239,	215187.34495,	215192.04752,	215196.75009,	215201.45268,	215206.15527,	215210.85787,
215215.56049,	215220.26311,	215224.96574,	215229.66837,	215234.37102,	215239.07367,	215243.77634,	215248.47901,	215253.18169,	215257.88438,
215262.58707,	215267.28978,	215271.99250,	215276.69522,	215281.39795,	215286.10069,	215290.80344,	215295.50620,	215300.20897,	215304.91174,
215309.61452,	215314.31732,	215319.02012,	215323.72293,	215328.42574,	215333.12857,	215337.83141,	215342.53425,	215347.23710,	215351.93996,
215356.64283,	215361.34571,	215366.04860,	215370.75150,	215375.45440,	215380.15731,	215384.86023,	215389.56316,	215394.26610,	215398.96905,
215403.67201,	215408.37497,	215413.07794,	215417.78092,	215422.48392,	215427.18691,	215431.88992,	215436.59294,	215441.29596,	215445.99900,
215450.70204,	215455.40509,	215460.10815,	215464.81121,	215469.51429,	215474.21738,	215478.92047,	215483.62357,	215488.32668,	215493.02980,
215497.73293,	215502.43607,	215507.13921,	215511.84237,	215516.54553,	215521.24870,	215525.95188,	215530.65507,	215535.35826,	215540.06147,
215544.76468,	215549.46791,	215554.17114,	215558.87438,	215563.57762,	215568.28088,	215572.98415,	215577.68742,	215582.39070,	215587.09400,
215591.79730,	215596.50060,	215601.20392,	215605.90725,	215610.61058,	215615.31392,	215620.01728,	215624.72064,	215629.42400,	215634.12738,
215638.83077,	215643.53416,	215648.23757,	215652.94098,	215657.64440,	215662.34783,	215667.05126,	215671.75471,	215676.45817,	215681.16163,
215685.86510,	215690.56858,	215695.27207,	215699.97557,	215704.67907,	215709.38259,	215714.08611,	215718.78964,	215723.49319,	215728.19673,
215732.90029,	215737.60386,	215742.30743,	215747.01102,	215751.71461,	215756.41821,	215761.12182,	215765.82544,	215770.52907,	215775.23270,
215779.93634,	215784.64000,	215789.34366,	215794.04733,	215798.75101,	215803.45469,	215808.15839,	215812.86209,	215817.56580,	215822.26953,
215826.97326,	215831.67699,	215836.38074,	215841.08450,	215845.78826,	215850.49203,	215855.19581,	215859.89960,	215864.60340,	215869.30721,
215874.01103,	215878.71485,	215883.41868,	215888.12252,	215892.82637,	215897.53023,	215902.23410,	215906.93798,	215911.64186,	215916.34575,
215921.04965,	215925.75356,	215930.45748,	215935.16141,	215939.86535,	215944.56929,	215949.27324,	215953.97721,	215958.68118,	215963.38515,
215968.08914,	215972.79314,	215977.49714,	215982.20116,	215986.90518,	215991.60921,	215996.31325,	216001.01729,	216005.72135,	216010.42541,
216015.12949,	216019.83357,	216024.53766,	216029.24176,	216033.94587,	216038.64998,	216043.35411,	216048.05824,	216052.76238,	216057.46653,
216062.17069,	216066.87486,	216071.57904,	216076.28322,	216080.98742,	216085.69162,	216090.39583,	216095.10005,	216099.80427,	216104.50851,
216109.21276,	216113.91701,	216118.62127,	216123.32554,	216128.02982,	216132.73411,	216137.43841,	216142.14271,	216146.84702,	216151.55135,
216156.25568,	216160.96002,	216165.66436,	216170.36872,	216175.07309,	216179.77746,	216184.48184,	216189.18623,	216193.89063,	216198.59504,
216203.29946,	216208.00388,	216212.70831,	216217.41276,	216222.11721,	216226.82167,	216231.52614,	216236.23061,	216240.93510,	216245.63959,
216250.34409,	216255.04860,	216259.75312,	216264.45765,	216269.16219,	216273.86673,	216278.57129,	216283.27585,	216287.98042,	216292.68500,
216297.38959,	216302.09418,	216306.79879,	216311.50340,	216316.20802,	216320.91266,	216325.61730,	216330.32194,	216335.02660,	216339.73127,
216344.43594,	216349.14062,	216353.84531,	216358.55001,	216363.25472,	216367.95944,	216372.66416,	216377.36890,	216382.07364,	216386.77839,
216391.48315,	216396.18792,	216400.89269,	216405.59748,	216410.30227,	216415.00707,	216419.71188,	216424.41670,	216429.12153,	216433.82637,
216438.53121,	216443.23607,	216447.94093,	216452.64580,	216457.35068,	216462.05557,	216466.76047,	216471.46537,	216476.17028,	216480.87521,
216485.58014,	216490.28508,	216494.99002,	216499.69498,	216504.39995,	216509.10492,	216513.80990,	216518.51489,	216523.21989,	216527.92490,
216532.62992,	216537.33494,	216542.03998,	216546.74502,	216551.45007,	216556.15513,	216560.86020,	216565.56527,	216570.27036,	216574.97545,
216579.68055,	216584.38566,	216589.09078,	216593.79591,	216598.50105,	216603.20619,	216607.91135,	216612.61651,	216617.32168,	216622.02686,
216626.73205,	216631.43724,	216636.14245,	216640.84766,	216645.55288,	216650.25811,	216654.96335,	216659.66860,	216664.37386,	216669.07912,
216673.78439,	216678.48968,	216683.19497,	216687.90027,	216692.60557,	216697.31089,	216702.01622,	216706.72155,	216711.42689,	216716.13224,
216720.83760,	216725.54297,	216730.24834,	216734.95373,	216739.65912,	216744.36452,	216749.06993,	216753.77535,	216758.48078,	216763.18622,
216767.89166,	216772.59711,	216777.30258,	216782.00805,	216786.71352,	216791.41901,	216796.12451,	216800.83001,	216805.53553,	216810.24105,
216814.94658,	216819.65212,	216824.35766,	216829.06322,	216833.76878,	216838.47436,	216843.17994,	216847.88553,	216852.59113,	216857.29673,
216862.00235,	216866.70797,	216871.41361,	216876.11925,	216880.82490,	216885.53056,	216890.23622,	216894.94190,	216899.64758,	216904.35328,
216909.05898,	216913.76469,	216918.47041,	216923.17613,	216927.88187,	216932.58761,	216937.29336,	216941.99913,	216946.70490,	216951.41067,
216956.11646,	216960.82226,	216965.52806,	216970.23387,	216974.93969,	216979.64552,	216984.35136,	216989.05721,	216993.76306,	216998.46893,
217003.17480,	217007.88068,	217012.58657,	217017.29247,	217021.99837,	217026.70429,	217031.41021,	217036.11614,	217040.82208,	217045.52803,
217050.23399,	217054.93996,	217059.64593,	217064.35192,	217069.05791,	217073.76391,	217078.46992,	217083.17593,	217087.88196,	217092.58800,
217097.29404,	217102.00009,	217106.70615,	217111.41222,	217116.11830,	217120.82438,	217125.53048,	217130.23658,	217134.94269,	217139.64881,
217144.35494,	217149.06108,	217153.76722,	217158.47338,	217163.17954,	217167.88571,	217172.59189,	217177.29808,	217182.00428,	217186.71048,
217191.41670,	217196.12292,	217200.82915,	217205.53539,	217210.24164,	217214.94790,	217219.65416,	217224.36043,	217229.06672,	217233.77301,
217238.47931,	217243.18562,	217247.89193,	217252.59826,	217257.30459,	217262.01093,	217266.71728,	217271.42364,	217276.13001,	217280.83639,
217285.54277,	217290.24917,	217294.95557,	217299.66198,	217304.36840,	217309.07482,	217313.78126,	217318.48771,	217323.19416,	217327.90062,
217332.60709,	217337.31357,	217342.02006,	217346.72655,	217351.43306,	217356.13957,	217360.84609,	217365.55262,	217370.25916,	217374.96571,
217379.67226,	217384.37883,	217389.08540,	217393.79198,	217398.49857,	217403.20517,	217407.91178,	217412.61839,	217417.32502,	217422.03165,
217426.73829,	217431.44494,	217436.15160,	217440.85826,	217445.56494,	217450.27162,	217454.97831,	217459.68501,	217464.39172,	217469.09844,
217473.80517,	217478.51190,	217483.21865,	217487.92540,	217492.63216,	217497.33893,	217502.04570,	217506.75249,	217511.45929,	217516.16609,
217520.87290,	217525.57972,	217530.28655,	217534.99339,	217539.70023,	217544.40709,	217549.11395,	217553.82082,	217558.52770,	217563.23459,
217567.94149,	217572.64839,	217577.35531,	217582.06223,	217586.76916,	217591.47610,	217596.18305,	217600.89000,	217605.59697,	217610.30394,
217615.01092,	217619.71791,	217624.42491,	217629.13192,	217633.83894,	217638.54596,	217643.25300,	217647.96004,	217652.66709,	217657.37415,
217662.08121,	217666.78829,	217671.49538,	217676.20247,	217680.90957,	217685.61668,	217690.32380,	217695.03093,	217699.73806,	217704.44521,
217709.15236,	217713.85952,	217718.56669,	217723.27387,	217727.98105,	217732.68825,	217737.39545,	217742.10267,	217746.80989,	217751.51712,
217756.22435,	217760.93160,	217765.63886,	217770.34612,	217775.05339,	217779.76067,	217784.46796,	217789.17526,	217793.88256,	217798.58988,
217803.29720,	217808.00453,	217812.71187,	217817.41922,	217822.12658,	217826.83395,	217831.54132,	217836.24870,	217840.95609,	217845.66349,
217850.37090,	217855.07832,	217859.78574,	217864.49318,	217869.20062,	217873.90807,	217878.61553,	217883.32300,	217888.03048,	217892.73796,
217897.44545,	217902.15296,	217906.86047,	217911.56799,	217916.27551,	217920.98305,	217925.69059,	217930.39815,	217935.10571,	217939.81328,
217944.52086,	217949.22845,	217953.93604,	217958.64365,	217963.35126,	217968.05888,	217972.76651,	217977.47415,	217982.18179,	217986.88945,
217991.59711,	217996.30479,	218001.01247,	218005.72016,	218010.42785,	218015.13556,	218019.84328,	218024.55100,	218029.25873,	218033.96647,
218038.67422,	218043.38198,	218048.08974,	218052.79752,	218057.50530,	218062.21309,	218066.92089,	218071.62870,	218076.33652,	218081.04434,
218085.75218,	218090.46002,	218095.16787,	218099.87573,	218104.58360,	218109.29148,	218113.99936,	218118.70725,	218123.41516,	218128.12307,
218132.83099,	218137.53891,	218142.24685,	218146.95480,	218151.66275,	218156.37071,	218161.07868,	218165.78666,	218170.49465,	218175.20264,
218179.91065,	218184.61866,	218189.32668,	218194.03471,	218198.74275,	218203.45080,	218208.15885,	218212.86691,	218217.57499,	218222.28307,
218226.99116,	218231.69925,	218236.40736,	218241.11548,	218245.82360,	218250.53173,	218255.23987,	218259.94802,	218264.65618,	218269.36434,
218274.07252,	218278.78070,	218283.48889,	218288.19709,	218292.90530,	218297.61352,	218302.32174,	218307.02998,	218311.73822,	218316.44647,
218321.15473,	218325.86300,	218330.57127,	218335.27956,	218339.98785,	218344.69615,	218349.40446,	218354.11278,	218358.82111,	218363.52945,
218368.23779,	218372.94614,	218377.65450,	218382.36287,	218387.07125,	218391.77964,	218396.48804,	218401.19644,	218405.90485,	218410.61327,
218415.32170,	218420.03014,	218424.73859,	218429.44704,	218434.15550,	218438.86398,	218443.57246,	218448.28095,	218452.98944,	218457.69795,
218462.40646,	218467.11499,	218471.82352,	218476.53206,	218481.24061,	218485.94916,	218490.65773,	218495.36630,	218500.07488,	218504.78348,
218509.49207,	218514.20068,	218518.90930,	218523.61792,	218528.32656,	218533.03520,	218537.74385,	218542.45251,	218547.16118,	218551.86985,
218556.57854,	218561.28723,	218565.99593,	218570.70464,	218575.41336,	218580.12208,	218584.83082,	218589.53956,	218594.24832,	218598.95708,
218603.66585,	218608.37462,	218613.08341,	218617.79220,	218622.50101,	218627.20982,	218631.91864,	218636.62747,	218641.33630,	218646.04515,
218650.75400,	218655.46287,	218660.17174,	218664.88062,	218669.58951,	218674.29840,	218679.00731,	218683.71622,	218688.42514,	218693.13407,
218697.84301,	218702.55196,	218707.26092,	218711.96988,	218716.67885,	218721.38784,	218726.09683,	218730.80582,	218735.51483,	218740.22385,
218744.93287,	218749.64190,	218754.35094,	218759.05999,	218763.76905,	218768.47812,	218773.18719,	218777.89627,	218782.60537,	218787.31447,
218792.02358,	218796.73269,	218801.44182,	218806.15095,	218810.86010,	218815.56925,	218820.27841,	218824.98757,	218829.69675,	218834.40594,
218839.11513,	218843.82433,	218848.53354,	218853.24276,	218857.95199,	218862.66123,	218867.37047,	218872.07972,	218876.78898,	218881.49825,
218886.20753,	218890.91682,	218895.62611,	218900.33542,	218905.04473,	218909.75405,	218914.46338,	218919.17272,	218923.88207,	218928.59142,
218933.30078,	218938.01016,	218942.71954,	218947.42892,	218952.13832,	218956.84773,	218961.55714,	218966.26656,	218970.97599,	218975.68543,
218980.39488,	218985.10434,	218989.81380,	218994.52328,	218999.23276,	219003.94225,	219008.65175,	219013.36126,	219018.07077,	219022.78030,
219027.48983,	219032.19937,	219036.90892,	219041.61848,	219046.32805,	219051.03762,	219055.74720,	219060.45680,	219065.16640,	219069.87601,
219074.58562,	219079.29525,	219084.00488,	219088.71453,	219093.42418,	219098.13384,	219102.84351,	219107.55318,	219112.26287,	219116.97256,
219121.68227,	219126.39198,	219131.10170,	219135.81142,	219140.52116,	219145.23090,	219149.94066,	219154.65042,	219159.36019,	219164.06997,
219168.77976,	219173.48955,	219178.19935,	219182.90917,	219187.61899,	219192.32882,	219197.03866,	219201.74850,	219206.45836,	219211.16822,
219215.87809,	219220.58797,	219225.29786,	219230.00776,	219234.71766,	219239.42758,	219244.13750,	219248.84743,	219253.55737,	219258.26732,
219262.97728,	219267.68724,	219272.39721,	219277.10720,	219281.81719,	219286.52719,	219291.23719,	219295.94721,	219300.65723,	219305.36727,
219310.07731,	219314.78736,	219319.49741,	219324.20748,	219328.91756,	219333.62764,	219338.33773,	219343.04783,	219347.75794,	219352.46806,
219357.17818,	219361.88832,	219366.59846,	219371.30861,	219376.01877,	219380.72894,	219385.43912,	219390.14930,	219394.85950,	219399.56970,
219404.27991,	219408.99013,	219413.70035,	219418.41059,	219423.12083,	219427.83109,	219432.54135,	219437.25162,	219441.96190,	219446.67218,
219451.38248,	219456.09278,	219460.80309,	219465.51341,	219470.22374,	219474.93408,	219479.64443,	219484.35478,	219489.06514,	219493.77551,
219498.48589,	219503.19628,	219507.90668,	219512.61708,	219517.32750,	219522.03792,	219526.74835,	219531.45879,	219536.16924,	219540.87969,
219545.59016,	219550.30063,	219555.01111,	219559.72160,	219564.43210,	219569.14261,	219573.85312,	219578.56364,	219583.27418,	219587.98472,
219592.69527,	219597.40582,	219602.11639,	219606.82696,	219611.53755,	219616.24814,	219620.95874,	219625.66934,	219630.37996,	219635.09059,
219639.80122,	219644.51186,	219649.22251,	219653.93317,	219658.64384,	219663.35451,	219668.06520,	219672.77589,	219677.48659,	219682.19730,
219686.90802,	219691.61875,	219696.32948,	219701.04022,	219705.75098,	219710.46174,	219715.17250,	219719.88328,	219724.59407,	219729.30486,
219734.01566,	219738.72648,	219743.43729,	219748.14812,	219752.85896,	219757.56980,	219762.28066,	219766.99152,	219771.70239,	219776.41327,
219781.12415,	219785.83505,	219790.54595,	219795.25687,	219799.96779,	219804.67872,	219809.38965,	219814.10060,	219818.81156,	219823.52252,
219828.23349,	219832.94447,	219837.65546,	219842.36646,	219847.07746,	219851.78847,	219856.49950,	219861.21053,	219865.92157,	219870.63261,
219875.34367,	219880.05474,	219884.76581,	219889.47689,	219894.18798,	219898.89908,	219903.61018,	219908.32130,	219913.03242,	219917.74356,
219922.45470,	219927.16584,	219931.87700,	219936.58817,	219941.29934,	219946.01053,	219950.72172,	219955.43292,	219960.14412,	219964.85534,
219969.56657,	219974.27780,	219978.98904,	219983.70029,	219988.41155,	219993.12282,	219997.83409,	220002.54538,	220007.25667,	220011.96797,
220016.67928,	220021.39060,	220026.10192,	220030.81326,	220035.52460,	220040.23595,	220044.94731,	220049.65868,	220054.37006,	220059.08144,
220063.79284,	220068.50424,	220073.21565,	220077.92707,	220082.63850,	220087.34993,	220092.06138,	220096.77283,	220101.48429,	220106.19576,
220110.90724,	220115.61873,	220120.33022,	220125.04173,	220129.75324,	220134.46476,	220139.17629,	220143.88782,	220148.59937,	220153.31092,
220158.02249,	220162.73406,	220167.44564,	220172.15723,	220176.86882,	220181.58043,	220186.29204,	220191.00366,	220195.71529,	220200.42693,
220205.13858,	220209.85023,	220214.56190,	220219.27357,	220223.98525,	220228.69694,	220233.40864,	220238.12034,	220242.83206,	220247.54378,
220252.25551,	220256.96725,	220261.67900,	220266.39075,	220271.10252,	220275.81429,	220280.52608,	220285.23787,	220289.94966,	220294.66147,
220299.37329,	220304.08511,	220308.79694,	220313.50879,	220318.22063,	220322.93249,	220327.64436,	220332.35623,	220337.06812,	220341.78001,
220346.49191,	220351.20382,	220355.91573,	220360.62766,	220365.33959,	220370.05153,	220374.76348,	220379.47544,	220384.18741,	220388.89939,
220393.61137,	220398.32336,	220403.03537,	220407.74737,	220412.45939,	220417.17142,	220421.88345,	220426.59550,	220431.30755,	220436.01961,
220440.73168,	220445.44375,	220450.15584,	220454.86793,	220459.58004,	220464.29215,	220469.00427,	220473.71639,	220478.42853,	220483.14067,
220487.85283,	220492.56499,	220497.27716,	220501.98934,	220506.70152,	220511.41372,	220516.12592,	220520.83813,	220525.55035,	220530.26258,
220534.97482,	220539.68706,	220544.39932,	220549.11158,	220553.82385,	220558.53613,	220563.24842,	220567.96071,	220572.67302,	220577.38533,
220582.09765,	220586.80998,	220591.52232,	220596.23467,	220600.94702,	220605.65939,	220610.37176,	220615.08414,	220619.79653,	220624.50892,
220629.22133,	220633.93374,	220638.64617,	220643.35860,	220648.07104,	220652.78348,	220657.49594,	220662.20840,	220666.92088,	220671.63336,
220676.34585,	220681.05835,	220685.77085,	220690.48337,	220695.19589,	220699.90842,	220704.62096,	220709.33351,	220714.04607,	220718.75863,
220723.47121,	220728.18379,	220732.89638,	220737.60898,	220742.32159,	220747.03420,	220751.74683,	220756.45946,	220761.17210,	220765.88475,
220770.59741,	220775.31008,	220780.02275,	220784.73544,	220789.44813,	220794.16083,	220798.87354,	220803.58625,	220808.29898,	220813.01171,
220817.72446,	220822.43721,	220827.14997,	220831.86273,	220836.57551,	220841.28829,	220846.00109,	220850.71389,	220855.42670,	220860.13951,
220864.85234,	220869.56518,	220874.27802,	220878.99087,	220883.70373,	220888.41660,	220893.12948,	220897.84236,	220902.55526,	220907.26816,
220911.98107,	220916.69399,	220921.40691,	220926.11985,	220930.83279,	220935.54575,	220940.25871,	220944.97168,	220949.68465,	220954.39764,
220959.11064,	220963.82364,	220968.53665,	220973.24967,	220977.96270,	220982.67574,	220987.38878,	220992.10183,	220996.81490,	221001.52797,
221006.24104,	221010.95413,	221015.66723,	221020.38033,	221025.09344,	221029.80656,	221034.51969,	221039.23283,	221043.94598,	221048.65913,
221053.37229,	221058.08547,	221062.79865,	221067.51183,	221072.22503,	221076.93823,	221081.65145,	221086.36467,	221091.07790,	221095.79114,
221100.50438,	221105.21764,	221109.93090,	221114.64418,	221119.35746,	221124.07075,	221128.78404,	221133.49735,	221138.21066,	221142.92398,
221147.63732,	221152.35066,	221157.06400,	221161.77736,	221166.49072,	221171.20410,	221175.91748,	221180.63087,	221185.34427,	221190.05767,
221194.77109,	221199.48451,	221204.19794,	221208.91138,	221213.62483,	221218.33829,	221223.05175,	221227.76523,	221232.47871,	221237.19220,
221241.90570,	221246.61921,	221251.33272,	221256.04625,	221260.75978,	221265.47332,	221270.18687,	221274.90043,	221279.61399,	221284.32757,
221289.04115,	221293.75474,	221298.46834,	221303.18195,	221307.89557,	221312.60919,	221317.32282,	221322.03647,	221326.75012,	221331.46377,
221336.17744,	221340.89112,	221345.60480,	221350.31849,	221355.03219,	221359.74590,	221364.45962,	221369.17334,	221373.88708,	221378.60082,
221383.31457,	221388.02833,	221392.74210,	221397.45587,	221402.16966,	221406.88345,	221411.59725,	221416.31106,	221421.02488,	221425.73871,
221430.45254,	221435.16639,	221439.88024,	221444.59410,	221449.30797,	221454.02184,	221458.73573,	221463.44962,	221468.16352,	221472.87743,
221477.59135,	221482.30528,	221487.01921,	221491.73316,	221496.44711,	221501.16107,	221505.87504,	221510.58902,	221515.30300,	221520.01700,
221524.73100,	221529.44501,	221534.15903,	221538.87306,	221543.58710,	221548.30114,	221553.01519,	221557.72925,	221562.44332,	221567.15740,
221571.87149,	221576.58558,	221581.29969,	221586.01380,	221590.72792,	221595.44205,	221600.15618,	221604.87033,	221609.58448,	221614.29865,
221619.01282,	221623.72699,	221628.44118,	221633.15538,	221637.86958,	221642.58379,	221647.29801,	221652.01224,	221656.72648,	221661.44073,
221666.15498,	221670.86924,	221675.58352,	221680.29779,	221685.01208,	221689.72638,	221694.44068,	221699.15500,	221703.86932,	221708.58365,
221713.29799,	221718.01233,	221722.72669,	221727.44105,	221732.15542,	221736.86980,	221741.58419,	221746.29859,	221751.01299,	221755.72741,
221760.44183,	221765.15626,	221769.87070,	221774.58514,	221779.29960,	221784.01406,	221788.72854,	221793.44302,	221798.15751,	221802.87200,
221807.58651,	221812.30102,	221817.01555,	221821.73008,	221826.44462,	221831.15916,	221835.87372,	221840.58828,	221845.30286,	221850.01744,
221854.73203,	221859.44663,	221864.16123,	221868.87585,	221873.59047,	221878.30510,	221883.01974,	221887.73439,	221892.44905,	221897.16371,
221901.87838,	221906.59307,	221911.30776,	221916.02246,	221920.73716,	221925.45188,	221930.16660,	221934.88133,	221939.59607,	221944.31082,
221949.02558,	221953.74034,	221958.45512,	221963.16990,	221967.88469,	221972.59949,	221977.31430,	221982.02911,	221986.74394,	221991.45877,
221996.17361,	222000.88846,	222005.60332,	222010.31818,	222015.03306,	222019.74794,	222024.46283,	222029.17773,	222033.89264,	222038.60756,
222043.32248,	222048.03741,	222052.75235,	222057.46730,	222062.18226,	222066.89723,	222071.61220,	222076.32719,	222081.04218,	222085.75718,
222090.47219,	222095.18720,	222099.90223,	222104.61726,	222109.33230,	222114.04735,	222118.76241,	222123.47748,	222128.19256,	222132.90764,
222137.62273,	222142.33783,	222147.05294,	222151.76806,	222156.48318,	222161.19832,	222165.91346,	222170.62861,	222175.34377,	222180.05894,
222184.77411,	222189.48930,	222194.20449,	222198.91969,	222203.63490,	222208.35012,	222213.06534,	222217.78058,	222222.49582,	222227.21107,
222231.92633,	222236.64160,	222241.35687,	222246.07216,	222250.78745,	222255.50275,	222260.21806,	222264.93338,	222269.64871,	222274.36404,
222279.07938,	222283.79473,	222288.51009,	222293.22546,	222297.94084,	222302.65622,	222307.37162,	222312.08702,	222316.80243,	222321.51785,
222326.23327,	222330.94871,	222335.66415,	222340.37960,	222345.09506,	222349.81053,	222354.52601,	222359.24149,	222363.95699,	222368.67249,
222373.38800,	222378.10352,	222382.81905,	222387.53458,	222392.25013,	222396.96568,	222401.68124,	222406.39681,	222411.11238,	222415.82797,
222420.54356,	222425.25917,	222429.97478,	222434.69040,	222439.40602,	222444.12166,	222448.83730,	222453.55295,	222458.26862,	222462.98428,
222467.69996,	222472.41565,	222477.13134,	222481.84704,	222486.56276,	222491.27848,	222495.99420,	222500.70994,	222505.42568,	222510.14144,
222514.85720,	222519.57297,	222524.28874,	222529.00453,	222533.72032,	222538.43613,	222543.15194,	222547.86776,	222552.58359,	222557.29942,
222562.01527,	222566.73112,	222571.44698,	222576.16285,	222580.87873,	222585.59462,	222590.31051,	222595.02641,	222599.74232,	222604.45824,
222609.17417,	222613.89011,	222618.60605,	222623.32201,	222628.03797,	222632.75394,	222637.46992,	222642.18590,	222646.90190,	222651.61790,
222656.33391,	222661.04993,	222665.76596,	222670.48200,	222675.19804,	222679.91410,	222684.63016,	222689.34623,	222694.06231,	222698.77840,
222703.49449,	222708.21059,	222712.92671,	222717.64283,	222722.35895,	222727.07509,	222731.79124,	222736.50739,	222741.22355,	222745.93972,
222750.65590,	222755.37209,	222760.08828,	222764.80449,	222769.52070,	222774.23692,	222778.95315,	222783.66939,	222788.38563,	222793.10189,
222797.81815,	222802.53442,	222807.25070,	222811.96698,	222816.68328,	222821.39958,	222826.11590,	222830.83222,	222835.54855,	222840.26488,
222844.98123,	222849.69758,	222854.41394,	222859.13032,	222863.84669,	222868.56308,	222873.27948,	222877.99588,	222882.71229,	222887.42871,
222892.14514,	222896.86158,	222901.57803,	222906.29448,	222911.01094,	222915.72741,	222920.44389,	222925.16038,	222929.87688,	222934.59338,
222939.30989,	222944.02641,	222948.74294,	222953.45948,	222958.17603,	222962.89258,	222967.60914,	222972.32571,	222977.04229,	222981.75888,
222986.47548,	222991.19208,	222995.90869,	223000.62532,	223005.34194,	223010.05858,	223014.77523,	223019.49188,	223024.20854,	223028.92522,
223033.64190,	223038.35858,	223043.07528,	223047.79198,	223052.50870,	223057.22542,	223061.94215,	223066.65888,	223071.37563,	223076.09238,
223080.80915,	223085.52592,	223090.24270,	223094.95948,	223099.67628,	223104.39309,	223109.10990,	223113.82672,	223118.54355,	223123.26039,
223127.97723,	223132.69409,	223137.41095,	223142.12782,	223146.84470,	223151.56159,	223156.27848,	223160.99539,	223165.71230,	223170.42922,
223175.14615,	223179.86309,	223184.58004,	223189.29699,	223194.01395,	223198.73092,	223203.44790,	223208.16489,	223212.88189,	223217.59889,
223222.31590,	223227.03292,	223231.74995,	223236.46699,	223241.18404,	223245.90109,	223250.61816,	223255.33523,	223260.05231,	223264.76939,
223269.48649,	223274.20359,	223278.92071,	223283.63783,	223288.35496,	223293.07209,	223297.78924,	223302.50640,	223307.22356,	223311.94073,
223316.65791,	223321.37510,	223326.09229,	223330.80950,	223335.52671,	223340.24393,	223344.96116,	223349.67840,	223354.39564,	223359.11290,
223363.83016,	223368.54743,	223373.26471,	223377.98200,	223382.69929,	223387.41660,	223392.13391,	223396.85123,	223401.56856,	223406.28590,
223411.00324,	223415.72060,	223420.43796,	223425.15533,	223429.87271,	223434.59010,	223439.30749,	223444.02490,	223448.74231,	223453.45973,
223458.17716,	223462.89460,	223467.61204,	223472.32950,	223477.04696,	223481.76443,	223486.48191,	223491.19940,	223495.91689,	223500.63440,
223505.35191,	223510.06943,	223514.78696,	223519.50450,	223524.22204,	223528.93960,	223533.65716,	223538.37473,	223543.09231,	223547.80990,
223552.52749,	223557.24510,	223561.96271,	223566.68033,	223571.39796,	223576.11560,	223580.83324,	223585.55089,	223590.26856,	223594.98623,
223599.70391,	223604.42159,	223609.13929,	223613.85699,	223618.57470,	223623.29242,	223628.01015,	223632.72789,	223637.44564,	223642.16339,
223646.88115,	223651.59892,	223656.31670,	223661.03449,	223665.75228,	223670.47009,	223675.18790,	223679.90572,	223684.62355,	223689.34138,
223694.05923,	223698.77708,	223703.49494,	223708.21281,	223712.93069,	223717.64858,	223722.36648,	223727.08438,	223731.80229,	223736.52021,
223741.23814,	223745.95608,	223750.67402,	223755.39197,	223760.10994,	223764.82791,	223769.54588,	223774.26387,	223778.98186,	223783.69987,
223788.41788,	223793.13590,	223797.85393,	223802.57196,	223807.29001,	223812.00806,	223816.72612,	223821.44419,	223826.16227,	223830.88036,
223835.59845,	223840.31655,	223845.03467,	223849.75279,	223854.47091,	223859.18905,	223863.90719,	223868.62535,	223873.34351,	223878.06168,
223882.77985,	223887.49804,	223892.21623,	223896.93444,	223901.65265,	223906.37087,	223911.08910,	223915.80733,	223920.52558,	223925.24383,
223929.96209,	223934.68036,	223939.39864,	223944.11692,	223948.83522,	223953.55352,	223958.27183,	223962.99015,	223967.70847,	223972.42681,
223977.14515,	223981.86351,	223986.58187,	223991.30024,	223996.01861,	224000.73700,	224005.45539,	224010.17379,	224014.89220,	224019.61062,
224024.32905,	224029.04748,	224033.76593,	224038.48438,	224043.20284,	224047.92131,	224052.63979,	224057.35827,	224062.07676,	224066.79527,
224071.51378,	224076.23229,	224080.95082,	224085.66936,	224090.38790,	224095.10645,	224099.82501,	224104.54358,	224109.26215,	224113.98074,
224118.69933,	224123.41793,	224128.13654,	224132.85516,	224137.57379,	224142.29242,	224147.01106,	224151.72972,	224156.44838,	224161.16704,
224165.88572,	224170.60440,	224175.32310,	224180.04180,	224184.76051,	224189.47922,	224194.19795,	224198.91668,	224203.63543,	224208.35418,
224213.07294,	224217.79170,	224222.51048,	224227.22926,	224231.94806,	224236.66686,	224241.38566,	224246.10448,	224250.82331,	224255.54214,
224260.26098,	224264.97983,	224269.69869,	224274.41756,	224279.13643,	224283.85532,	224288.57421,	224293.29311,	224298.01202,	224302.73093,
224307.44986,	224312.16879,	224316.88773,	224321.60668,	224326.32564,	224331.04461,	224335.76358,	224340.48257,	224345.20156,	224349.92056,
224354.63957,	224359.35858,	224364.07761,	224368.79664,	224373.51568,	224378.23473,	224382.95379,	224387.67285,	224392.39193,	224397.11101,
224401.83010,	224406.54920,	224411.26831,	224415.98742,	224420.70655,	224425.42568,	224430.14482,	224434.86397,	224439.58313,	224444.30229,
224449.02147,	224453.74065,	224458.45984,	224463.17904,	224467.89824,	224472.61746,	224477.33668,	224482.05591,	224486.77515,	224491.49440,
224496.21366,	224500.93292,	224505.65220,	224510.37148,	224515.09077,	224519.81007,	224524.52937,	224529.24869,	224533.96801,	224538.68734,
224543.40668,	224548.12603,	224552.84539,	224557.56475,	224562.28412,	224567.00350,	224571.72289,	224576.44229,	224581.16170,	224585.88111,
224590.60053,	224595.31996,	224600.03940,	224604.75885,	224609.47831,	224614.19777,	224618.91724,	224623.63672,	224628.35621,	224633.07571,
224637.79521,	224642.51473,	224647.23425,	224651.95378,	224656.67332,	224661.39286,	224666.11242,	224670.83198,	224675.55155,	224680.27113,
224684.99072,	224689.71032,	224694.42992,	224699.14954,	224703.86916,	224708.58879,	224713.30843,	224718.02807,	224722.74773,	224727.46739,
224732.18706,	224736.90674,	224741.62643,	224746.34612,	224751.06583,	224755.78554,	224760.50526,	224765.22499,	224769.94473,	224774.66447,
224779.38422,	224784.10399,	224788.82376,	224793.54354,	224798.26332,	224802.98312,	224807.70292,	224812.42273,	224817.14255,	224821.86238,
224826.58222,	224831.30206,	224836.02192,	224840.74178,	224845.46165,	224850.18152,	224854.90141,	224859.62131,	224864.34121,	224869.06112,
224873.78104,	224878.50097,	224883.22090,	224887.94085,	224892.66080,	224897.38076,	224902.10073,	224906.82071,	224911.54069,	224916.26069,
224920.98069,	224925.70070,	224930.42072,	224935.14074,	224939.86078,	224944.58082,	224949.30087,	224954.02093,	224958.74100,	224963.46108,
224968.18116,	224972.90126,	224977.62136,	224982.34147,	224987.06159,	224991.78171,	224996.50185,	225001.22199,	225005.94214,	225010.66230,
225015.38247,	225020.10264,	225024.82283,	225029.54302,	225034.26322,	225038.98343,	225043.70365,	225048.42387,	225053.14411,	225057.86435,
225062.58460,	225067.30486,	225072.02512,	225076.74540,	225081.46568,	225086.18597,	225090.90627,	225095.62658,	225100.34690,	225105.06722,
225109.78756,	225114.50790,	225119.22825,	225123.94860,	225128.66897,	225133.38934,	225138.10973,	225142.83012,	225147.55052,	225152.27092,
225156.99134,	225161.71176,	225166.43220,	225171.15264,	225175.87309,	225180.59354,	225185.31401,	225190.03448,	225194.75496,	225199.47545,
225204.19595,	225208.91646,	225213.63697,	225218.35750,	225223.07803,	225227.79857,	225232.51911,	225237.23967,	225241.96024,	225246.68081,
225251.40139,	225256.12198,	225260.84258,	225265.56318,	225270.28380,	225275.00442,	225279.72505,	225284.44569,	225289.16633,	225293.88699,
225298.60765,	225303.32833,	225308.04901,	225312.76969,	225317.49039,	225322.21110,	225326.93181,	225331.65253,	225336.37326,	225341.09400,
225345.81474,	225350.53550,	225355.25626,	225359.97703,	225364.69781,	225369.41860,	225374.13939,	225378.86020,	225383.58101,	225388.30183,
225393.02266,	225397.74350,	225402.46434,	225407.18520,	225411.90606,	225416.62693,	225421.34781,	225426.06869,	225430.78959,	225435.51049,
225440.23140,	225444.95232,	225449.67325,	225454.39419,	225459.11513,	225463.83608,	225468.55705,	225473.27801,	225477.99899,	225482.71998,
225487.44097,	225492.16197,	225496.88298,	225501.60400,	225506.32503,	225511.04607,	225515.76711,	225520.48816,	225525.20922,	225529.93029,
225534.65137,	225539.37245,	225544.09354,	225548.81465,	225553.53575,	225558.25687,	225562.97800,	225567.69913,	225572.42028,	225577.14143,
225581.86259,	225586.58375,	225591.30493,	225596.02611,	225600.74730,	225605.46850,	225610.18971,	225614.91093,	225619.63216,	225624.35339,
225629.07463,	225633.79588,	225638.51714,	225643.23840,	225647.95968,	225652.68096,	225657.40225,	225662.12355,	225666.84486,	225671.56618,
225676.28750,	225681.00883,	225685.73017,	225690.45152,	225695.17288,	225699.89424,	225704.61562,	225709.33700,	225714.05839,	225718.77979,
225723.50120,	225728.22261,	225732.94403,	225737.66546,	225742.38690,	225747.10835,	225751.82981,	225756.55127,	225761.27275,	225765.99423,
225770.71572,	225775.43721,	225780.15872,	225784.88023,	225789.60175,	225794.32328,	225799.04482,	225803.76637,	225808.48793,	225813.20949,
225817.93106,	225822.65264,	225827.37423,	225832.09582,	225836.81743,	225841.53904,	225846.26066,	225850.98229,	225855.70393,	225860.42557,
225865.14723,	225869.86889,	225874.59056,	225879.31224,	225884.03393,	225888.75562,	225893.47733,	225898.19904,	225902.92076,	225907.64249,
225912.36422,	225917.08597,	225921.80772,	225926.52948,	225931.25125,	225935.97303,	225940.69481,	225945.41661,	225950.13841,	225954.86022,
225959.58204,	225964.30387,	225969.02570,	225973.74755,	225978.46940,	225983.19126,	225987.91313,	225992.63500,	225997.35689,	226002.07878,
226006.80068,	226011.52259,	226016.24451,	226020.96644,	226025.68837,	226030.41031,	226035.13226,	226039.85422,	226044.57619,	226049.29816,
226054.02015,	226058.74214,	226063.46414,	226068.18615,	226072.90816,	226077.63019,	226082.35222,	226087.07426,	226091.79631,	226096.51837,
226101.24044,	226105.96251,	226110.68459,	226115.40668,	226120.12878,	226124.85089,	226129.57301,	226134.29513,	226139.01726,	226143.73940,
226148.46155,	226153.18371,	226157.90587,	226162.62804,	226167.35023,	226172.07242,	226176.79461,	226181.51682,	226186.23903,	226190.96126,
226195.68349,	226200.40573,	226205.12797,	226209.85023,	226214.57249,	226219.29476,	226224.01704,	226228.73933,	226233.46163,	226238.18393,
226242.90625,	226247.62857,	226252.35090,	226257.07323,	226261.79558,	226266.51793,	226271.24030,	226275.96267,	226280.68505,	226285.40743,
226290.12983,	226294.85223,	226299.57464,	226304.29706,	226309.01949,	226313.74193,	226318.46437,	226323.18683,	226327.90929,	226332.63176,
226337.35424,	226342.07672,	226346.79921,	226351.52172,	226356.24423,	226360.96675,	226365.68927,	226370.41181,	226375.13435,	226379.85690,
226384.57946,	226389.30203,	226394.02461,	226398.74719,	226403.46979,	226408.19239,	226412.91500,	226417.63761,	226422.36024,	226427.08287,
226431.80552,	226436.52817,	226441.25082,	226445.97349,	226450.69617,	226455.41885,	226460.14154,	226464.86424,	226469.58695,	226474.30966,
226479.03239,	226483.75512,	226488.47786,	226493.20061,	226497.92337,	226502.64613,	226507.36891,	226512.09169,	226516.81448,	226521.53728,
226526.26009,	226530.98290,	226535.70572,	226540.42855,	226545.15139,	226549.87424,	226554.59710,	226559.31996,	226564.04283,	226568.76571,
226573.48860,	226578.21150,	226582.93441,	226587.65732,	226592.38024,	226597.10317,	226601.82611,	226606.54906,	226611.27201,	226615.99497,
226620.71794,	226625.44092,	226630.16391,	226634.88691,	226639.60991,	226644.33292,	226649.05594,	226653.77897,	226658.50201,	226663.22505,
226667.94811,	226672.67117,	226677.39424,	226682.11732,	226686.84040,	226691.56350,	226696.28660,	226701.00971,	226705.73283,	226710.45595,
226715.17909,	226719.90223,	226724.62539,	226729.34855,	226734.07171,	226738.79489,	226743.51807,	226748.24127,	226752.96447,	226757.68768,
226762.41090,	226767.13412,	226771.85736,	226776.58060,	226781.30385,	226786.02711,	226790.75037,	226795.47365,	226800.19693,	226804.92022,
226809.64352,	226814.36683,	226819.09015,	226823.81347,	226828.53680,	226833.26014,	226837.98349,	226842.70685,	226847.43022,	226852.15359,
226856.87697,	226861.60036,	226866.32376,	226871.04717,	226875.77058,	226880.49400,	226885.21743,	226889.94087,	226894.66432,	226899.38778,
226904.11124,	226908.83471,	226913.55819,	226918.28168,	226923.00518,	226927.72868,	226932.45220,	226937.17572,	226941.89925,	226946.62278,
226951.34633,	226956.06988,	226960.79345,	226965.51702,	226970.24060,	226974.96418,	226979.68778,	226984.41138,	226989.13499,	226993.85861,
226998.58224,	227003.30588,	227008.02952,	227012.75318,	227017.47684,	227022.20051,	227026.92418,	227031.64787,	227036.37156,	227041.09526,
227045.81897,	227050.54269,	227055.26642,	227059.99015,	227064.71390,	227069.43765,	227074.16141,	227078.88517,	227083.60895,	227088.33273,
227093.05653,	227097.78033,	227102.50413,	227107.22795,	227111.95178,	227116.67561,	227121.39945,	227126.12330,	227130.84716,	227135.57102,
227140.29490,	227145.01878,	227149.74267,	227154.46657,	227159.19048,	227163.91439,	227168.63832,	227173.36225,	227178.08619,	227182.81013,
227187.53409,	227192.25806,	227196.98203,	227201.70601,	227206.43000,	227211.15399,	227215.87800,	227220.60201,	227225.32604,	227230.05007,
227234.77410,	227239.49815,	227244.22220,	227248.94627,	227253.67034,	227258.39442,	227263.11850,	227267.84260,	227272.56670,	227277.29082,
227282.01494,	227286.73906,	227291.46320,	227296.18735,	227300.91150,	227305.63566,	227310.35983,	227315.08401,	227319.80819,	227324.53239,
227329.25659,	227333.98080,	227338.70502,	227343.42924,	227348.15348,	227352.87772,	227357.60197,	227362.32623,	227367.05050,	227371.77478,
227376.49906,	227381.22335,	227385.94765,	227390.67196,	227395.39628,	227400.12060,	227404.84494,	227409.56928,	227414.29363,	227419.01799,
227423.74235,	227428.46673,	227433.19111,	227437.91550,	227442.63990,	227447.36430,	227452.08872,	227456.81314,	227461.53757,	227466.26201,
227470.98646,	227475.71092,	227480.43538,	227485.15986,	227489.88434,	227494.60882,	227499.33332,	227504.05783,	227508.78234,	227513.50686,
227518.23139,	227522.95593,	227527.68048,	227532.40503,	227537.12959,	227541.85416,	227546.57874,	227551.30333,	227556.02793,	227560.75253,
227565.47714,	227570.20176,	227574.92639,	227579.65102,	227584.37567,	227589.10032,	227593.82498,	227598.54965,	227603.27433,	227607.99901,
227612.72371,	227617.44841,	227622.17312,	227626.89784,	227631.62256,	227636.34730,	227641.07204,	227645.79679,	227650.52155,	227655.24632,
227659.97109,	227664.69588,	227669.42067,	227674.14547,	227678.87028,	227683.59509,	227688.31992,	227693.04475,	227697.76959,	227702.49444,
227707.21930,	227711.94416,	227716.66904,	227721.39392,	227726.11881,	227730.84371,	227735.56861,	227740.29353,	227745.01845,	227749.74338,
227754.46832,	227759.19327,	227763.91822,	227768.64319,	227773.36816,	227778.09314,	227782.81813,	227787.54312,	227792.26813,	227796.99314,
227801.71816,	227806.44319,	227811.16823,	227815.89327,	227820.61833,	227825.34339,	227830.06846,	227834.79354,	227839.51862,	227844.24372,
227848.96882,	227853.69393,	227858.41905,	227863.14418,	227867.86931,	227872.59446,	227877.31961,	227882.04477,	227886.76994,	227891.49511,
227896.22030,	227900.94549,	227905.67069,	227910.39590,	227915.12112,	227919.84634,	227924.57158,	227929.29682,	227934.02207,	227938.74733,
227943.47259,	227948.19787,	227952.92315,	227957.64844,	227962.37374,	227967.09905,	227971.82436,	227976.54968,	227981.27502,	227986.00036,
227990.72570,	227995.45106,	228000.17642,	228004.90180,	228009.62718,	228014.35257,	228019.07796,	228023.80337,	228028.52878,	228033.25420,
228037.97963,	228042.70507,	228047.43052,	228052.15597,	228056.88143,	228061.60690,	228066.33238,	228071.05787,	228075.78337,	228080.50887,
228085.23438,	228089.95990,	228094.68543,	228099.41096,	228104.13651,	228108.86206,	228113.58762,	228118.31319,	228123.03877,	228127.76435,
228132.48994,	228137.21555,	228141.94115,	228146.66677,	228151.39240,	228156.11803,	228160.84367,	228165.56932,	228170.29498,	228175.02065,
228179.74632,	228184.47201,	228189.19770,	228193.92340,	228198.64911,	228203.37482,	228208.10055,	228212.82628,	228217.55202,	228222.27777,
228227.00352,	228231.72929,	228236.45506,	228241.18084,	228245.90663,	228250.63243,	228255.35823,	228260.08405,	228264.80987,	228269.53570,
228274.26154,	228278.98738,	228283.71324,	228288.43910,	228293.16497,	228297.89085,	228302.61674,	228307.34263,	228312.06854,	228316.79445,
228321.52037,	228326.24630,	228330.97223,	228335.69818,	228340.42413,	228345.15009,	228349.87606,	228354.60203,	228359.32802,	228364.05401,
228368.78001,	228373.50602,	228378.23204,	228382.95807,	228387.68410,	228392.41014,	228397.13619,	228401.86225,	228406.58832,	228411.31439,
228416.04048,	228420.76657,	228425.49267,	228430.21878,	228434.94489,	228439.67101,	228444.39715,	228449.12329,	228453.84944,	228458.57559,
228463.30176,	228468.02793,	228472.75411,	228477.48030,	228482.20650,	228486.93270,	228491.65892,	228496.38514,	228501.11137,	228505.83760,
228510.56385,	228515.29011,	228520.01637,	228524.74264,	228529.46892,	228534.19520,	228538.92150,	228543.64780,	228548.37411,	228553.10043,
228557.82676,	228562.55310,	228567.27944,	228572.00579,	228576.73215,	228581.45852,	228586.18490,	228590.91128,	228595.63768,	228600.36408,
228605.09049,	228609.81691,	228614.54333,	228619.26976,	228623.99621,	228628.72266,	228633.44912,	228638.17558,	228642.90206,	228647.62854,
228652.35503,	228657.08153,	228661.80804,	228666.53455,	228671.26107,	228675.98761,	228680.71415,	228685.44069,	228690.16725,	228694.89381,
228699.62039,	228704.34697,	228709.07356,	228713.80015,	228718.52676,	228723.25337,	228727.97999,	228732.70662,	228737.43326,	228742.15990,
228746.88656,	228751.61322,	228756.33989,	228761.06657,	228765.79326,	228770.51995,	228775.24665,	228779.97336,	228784.70008,	228789.42681,
228794.15355,	228798.88029,	228803.60704,	228808.33380,	228813.06057,	228817.78734,	228822.51413,	228827.24092,	228831.96772,	228836.69453,
228841.42135,	228846.14817,	228850.87501,	228855.60185,	228860.32870,	228865.05555,	228869.78242,	228874.50929,	228879.23617,	228883.96306,
228888.68996,	228893.41687,	228898.14378,	228902.87071,	228907.59764,	228912.32458,	228917.05152,	228921.77848,	228926.50544,	228931.23241,
228935.95939,	228940.68638,	228945.41338,	228950.14038,	228954.86739,	228959.59441,	228964.32144,	228969.04848,	228973.77553,	228978.50258,
228983.22964,	228987.95671,	228992.68379,	228997.41087,	229002.13797,	229006.86507,	229011.59218,	229016.31930,	229021.04642,	229025.77356,
229030.50070,	229035.22785,	229039.95501,	229044.68218,	229049.40935,	229054.13653,	229058.86372,	229063.59092,	229068.31813,	229073.04535,
229077.77257,	229082.49980,	229087.22704,	229091.95429,	229096.68155,	229101.40881,	229106.13609,	229110.86337,	229115.59066,	229120.31795,
229125.04526,	229129.77257,	229134.49989,	229139.22722,	229143.95456,	229148.68191,	229153.40926,	229158.13662,	229162.86399,	229167.59137,
229172.31876,	229177.04615,	229181.77356,	229186.50097,	229191.22839,	229195.95582,	229200.68325,	229205.41069,	229210.13815,	229214.86561,
229219.59307,	229224.32055,	229229.04803,	229233.77553,	229238.50303,	229243.23054,	229247.95805,	229252.68558,	229257.41311,	229262.14065,
229266.86820,	229271.59576,	229276.32333,	229281.05090,	229285.77848,	229290.50607,	229295.23367,	229299.96128,	229304.68889,	229309.41651,
229314.14414,	229318.87178,	229323.59943,	229328.32708,	229333.05475,	229337.78242,	229342.51010,	229347.23779,	229351.96548,	229356.69319,
229361.42090,	229366.14862,	229370.87635,	229375.60408,	229380.33183,	229385.05958,	229389.78734,	229394.51511,	229399.24289,	229403.97067,
229408.69847,	229413.42627,	229418.15408,	229422.88189,	229427.60972,	229432.33755,	229437.06540,	229441.79325,	229446.52110,	229451.24897,
229455.97685,	229460.70473,	229465.43262,	229470.16052,	229474.88842,	229479.61634,	229484.34426,	229489.07219,	229493.80013,	229498.52808,
229503.25604,	229507.98400,	229512.71197,	229517.43995,	229522.16794,	229526.89594,	229531.62394,	229536.35196,	229541.07998,	229545.80801,
229550.53604,	229555.26409,	229559.99214,	229564.72020,	229569.44827,	229574.17635,	229578.90444,	229583.63253,	229588.36063,	229593.08874,
229597.81686,	229602.54499,	229607.27312,	229612.00126,	229616.72941,	229621.45757,	229626.18574,	229630.91392,	229635.64210,	229640.37029,
229645.09849,	229649.82670,	229654.55491,	229659.28314,	229664.01137,	229668.73961,	229673.46786,	229678.19611,	229682.92438,	229687.65265,
229692.38093,	229697.10922,	229701.83752,	229706.56582,	229711.29414,	229716.02246,	229720.75079,	229725.47912,	229730.20747,	229734.93582,
229739.66419,	229744.39256,	229749.12093,	229753.84932,	229758.57771,	229763.30612,	229768.03453,	229772.76295,	229777.49137,	229782.21981,
229786.94825,	229791.67670,	229796.40516,	229801.13363,	229805.86210,	229810.59059,	229815.31908,	229820.04758,	229824.77609,	229829.50460,
229834.23313,	229838.96166,	229843.69020,	229848.41875,	229853.14731,	229857.87587,	229862.60444,	229867.33302,	229872.06161,	229876.79021,
229881.51882,	229886.24743,	229890.97605,	229895.70468,	229900.43332,	229905.16197,	229909.89062,	229914.61928,	229919.34795,	229924.07663,
229928.80532,	229933.53401,	229938.26271,	229942.99142,	229947.72014,	229952.44887,	229957.17761,	229961.90635,	229966.63510,	229971.36386,
229976.09263,	229980.82140,	229985.55019,	229990.27898,	229995.00778,	229999.73659,	230004.46540,	230009.19423,	230013.92306,	230018.65190,
230023.38075,	230028.10961,	230032.83847,	230037.56734,	230042.29622,	230047.02511,	230051.75401,	230056.48292,	230061.21183,	230065.94075,
230070.66968,	230075.39862,	230080.12757,	230084.85652,	230089.58548,	230094.31445,	230099.04343,	230103.77242,	230108.50141,	230113.23041,
230117.95943,	230122.68844,	230127.41747,	230132.14651,	230136.87555,	230141.60460,	230146.33366,	230151.06273,	230155.79180,	230160.52089,
230165.24998,	230169.97908,	230174.70819,	230179.43730,	230184.16643,	230188.89556,	230193.62470,	230198.35385,	230203.08301,	230207.81217,
230212.54134,	230217.27052,	230221.99971,	230226.72891,	230231.45812,	230236.18733,	230240.91655,	230245.64578,	230250.37502,	230255.10426,
230259.83352,	230264.56278,	230269.29205,	230274.02133,	230278.75061,	230283.47991,	230288.20921,	230292.93852,	230297.66784,	230302.39717,
230307.12650,	230311.85585,	230316.58520,	230321.31456,	230326.04392,	230330.77330,	230335.50268,	230340.23207,	230344.96147,	230349.69088,
230354.42030,	230359.14972,	230363.87915,	230368.60859,	230373.33804,	230378.06750,	230382.79696,	230387.52644,	230392.25592,	230396.98540,
230401.71490,	230406.44441,	230411.17392,	230415.90344,	230420.63297,	230425.36251,	230430.09205,	230434.82161,	230439.55117,	230444.28074,
230449.01032,	230453.73990,	230458.46950,	230463.19910,	230467.92871,	230472.65833,	230477.38795,	230482.11759,	230486.84723,	230491.57688,
230496.30654,	230501.03621,	230505.76588,	230510.49556,	230515.22525,	230519.95495,	230524.68466,	230529.41438,	230534.14410,	230538.87383,
230543.60357,	230548.33332,	230553.06308,	230557.79284,	230562.52261,	230567.25239,	230571.98218,	230576.71198,	230581.44178,	230586.17159,
230590.90141,	230595.63124,	230600.36108,	230605.09092,	230609.82078,	230614.55064,	230619.28051,	230624.01038,	230628.74027,	230633.47016,
230638.20006,	230642.92997,	230647.65989,	230652.38982,	230657.11975,	230661.84969,	230666.57964,	230671.30960,	230676.03957,	230680.76954,
230685.49952,	230690.22951,	230694.95951,	230699.68952,	230704.41953,	230709.14956,	230713.87959,	230718.60963,	230723.33967,	230728.06973,
230732.79979,	230737.52986,	230742.25994,	230746.99003,	230751.72013,	230756.45023,	230761.18034,	230765.91046,	230770.64059,	230775.37073,
230780.10087,	230784.83102,	230789.56118,	230794.29135,	230799.02153,	230803.75171,	230808.48190,	230813.21210,	230817.94231,	230822.67253,
230827.40276,	230832.13299,	230836.86323,	230841.59348,	230846.32374,	230851.05400,	230855.78427,	230860.51456,	230865.24485,	230869.97514,
230874.70545,	230879.43576,	230884.16608,	230888.89641,	230893.62675,	230898.35710,	230903.08745,	230907.81782,	230912.54819,	230917.27856,
230922.00895,	230926.73935,	230931.46975,	230936.20016,	230940.93058,	230945.66100,	230950.39144,	230955.12188,	230959.85233,	230964.58279,
230969.31326,	230974.04374,	230978.77422,	230983.50471,	230988.23521,	230992.96572,	230997.69623,	231002.42676,	231007.15729,	231011.88783,
231016.61838,	231021.34893,	231026.07950,	231030.81007,	231035.54065,	231040.27124,	231045.00184,	231049.73244,	231054.46305,	231059.19367,
231063.92430,	231068.65494,	231073.38559,	231078.11624,	231082.84690,	231087.57757,	231092.30825,	231097.03893,	231101.76963,	231106.50033,
231111.23104,	231115.96175,	231120.69248,	231125.42321,	231130.15396,	231134.88471,	231139.61546,	231144.34623,	231149.07700,	231153.80779,
231158.53858,	231163.26937,	231168.00018,	231172.73100,	231177.46182,	231182.19265,	231186.92349,	231191.65433,	231196.38519,	231201.11605,
231205.84692,	231210.57780,	231215.30869,	231220.03959,	231224.77049,	231229.50140,	231234.23232,	231238.96325,	231243.69418,	231248.42513,
231253.15608,	231257.88704,	231262.61801,	231267.34898,	231272.07997,	231276.81096,	231281.54196,	231286.27297,	231291.00398,	231295.73501,
231300.46604,	231305.19708,	231309.92813,	231314.65919,	231319.39025,	231324.12132,	231328.85240,	231333.58349,	231338.31459,	231343.04569,
231347.77681,	231352.50793,	231357.23906,	231361.97020,	231366.70134,	231371.43249,	231376.16366,	231380.89483,	231385.62600,	231390.35719,
231395.08838,	231399.81958,	231404.55079,	231409.28201,	231414.01324,	231418.74447,	231423.47571,	231428.20697,	231432.93822,	231437.66949,
231442.40076,	231447.13205,	231451.86334,	231456.59464,	231461.32594,	231466.05726,	231470.78858,	231475.51991,	231480.25125,	231484.98260,
231489.71395,	231494.44531,	231499.17669,	231503.90807,	231508.63945,	231513.37085,	231518.10225,	231522.83366,	231527.56508,	231532.29651,
231537.02795,	231541.75939,	231546.49084,	231551.22230,	231555.95377,	231560.68524,	231565.41673,	231570.14822,	231574.87972,	231579.61123,
231584.34275,	231589.07427,	231593.80580,	231598.53734,	231603.26889,	231608.00045,	231612.73201,	231617.46358,	231622.19517,	231626.92675,
231631.65835,	231636.38996,	231641.12157,	231645.85319,	231650.58482,	231655.31646,	231660.04810,	231664.77975,	231669.51142,	231674.24308,
231678.97476,	231683.70645,	231688.43814,	231693.16984,	231697.90155,	231702.63327,	231707.36500,	231712.09673,	231716.82847,	231721.56022,
231726.29198,	231731.02375,	231735.75552,	231740.48730,	231745.21909,	231749.95089,	231754.68270,	231759.41451,	231764.14633,	231768.87816,
231773.61000,	231778.34185,	231783.07370,	231787.80557,	231792.53744,	231797.26931,	231802.00120,	231806.73310,	231811.46500,	231816.19691,
231820.92883,	231825.66076,	231830.39269,	231835.12463,	231839.85659,	231844.58854,	231849.32051,	231854.05249,	231858.78447,	231863.51646,
231868.24846,	231872.98047,	231877.71248,	231882.44451,	231887.17654,	231891.90858,	231896.64063,	231901.37268,	231906.10475,	231910.83682,
231915.56890,	231920.30099,	231925.03308,	231929.76519,	231934.49730,	231939.22942,	231943.96155,	231948.69368,	231953.42583,	231958.15798,
231962.89014,	231967.62231,	231972.35449,	231977.08667,	231981.81886,	231986.55106,	231991.28327,	231996.01549,	232000.74772,	232005.47995,
232010.21219,	232014.94444,	232019.67670,	232024.40896,	232029.14123,	232033.87351,	232038.60580,	232043.33810,	232048.07041,	232052.80272,
232057.53504,	232062.26737,	232066.99971,	232071.73205,	232076.46441,	232081.19677,	232085.92914,	232090.66152,	232095.39390,	232100.12630,
232104.85870,	232109.59111,	232114.32352,	232119.05595,	232123.78838,	232128.52083,	232133.25328,	232137.98573,	232142.71820,	232147.45068,
232152.18316,	232156.91565,	232161.64815,	232166.38065,	232171.11317,	232175.84569,	232180.57822,	232185.31076,	232190.04330,	232194.77586,
232199.50842,	232204.24099,	232208.97357,	232213.70616,	232218.43875,	232223.17136,	232227.90397,	232232.63659,	232237.36921,	232242.10185,
232246.83449,	232251.56714,	232256.29980,	232261.03247,	232265.76514,	232270.49783,	232275.23052,	232279.96322,	232284.69592,	232289.42864,
232294.16136,	232298.89409,	232303.62683,	232308.35958,	232313.09234,	232317.82510,	232322.55787,	232327.29065,	232332.02344,	232336.75623,
232341.48904,	232346.22185,	232350.95467,	232355.68750,	232360.42033,	232365.15318,	232369.88603,	232374.61889,	232379.35176,	232384.08463,
232388.81752,	232393.55041,	232398.28331,	232403.01622,	232407.74913,	232412.48206,	232417.21499,	232421.94793,	232426.68088,	232431.41384,
232436.14680,	232440.87977,	232445.61275,	232450.34574,	232455.07874,	232459.81174,	232464.54475,	232469.27778,	232474.01080,	232478.74384,
232483.47689,	232488.20994,	232492.94300,	232497.67607,	232502.40914,	232507.14223,	232511.87532,	232516.60842,	232521.34153,	232526.07465,
232530.80777,	232535.54091,	232540.27405,	232545.00720,	232549.74035,	232554.47352,	232559.20669,	232563.93987,	232568.67306,	232573.40626,
232578.13947,	232582.87268,	232587.60590,	232592.33913,	232597.07237,	232601.80561,	232606.53887,	232611.27213,	232616.00540,	232620.73867,
232625.47196,	232630.20525,	232634.93856,	232639.67187,	232644.40518,	232649.13851,	232653.87184,	232658.60518,	232663.33853,	232668.07189,
232672.80526,	232677.53863,	232682.27201,	232687.00540,	232691.73880,	232696.47221,	232701.20562,	232705.93904,	232710.67247,	232715.40591,
232720.13936,	232724.87281,	232729.60627,	232734.33974,	232739.07322,	232743.80671,	232748.54020,	232753.27370,	232758.00721,	232762.74073,
232767.47426,	232772.20779,	232776.94134,	232781.67489,	232786.40844,	232791.14201,	232795.87558,	232800.60917,	232805.34276,	232810.07636,
232814.80996,	232819.54358,	232824.27720,	232829.01083,	232833.74447,	232838.47812,	232843.21177,	232847.94543,	232852.67910,	232857.41278,
232862.14647,	232866.88016,	232871.61387,	232876.34758,	232881.08130,	232885.81502,	232890.54876,	232895.28250,	232900.01625,	232904.75001,
232909.48378,	232914.21755,	232918.95133,	232923.68512,	232928.41892,	232933.15273,	232937.88655,	232942.62037,	232947.35420,	232952.08804,
232956.82189,	232961.55574,	232966.28960,	232971.02347,	232975.75735,	232980.49124,	232985.22514,	232989.95904,	232994.69295,	232999.42687,
233004.16080,	233008.89473,	233013.62867,	233018.36263,	233023.09659,	233027.83055,	233032.56453,	233037.29851,	233042.03250,	233046.76650,
233051.50051,	233056.23452,	233060.96855,	233065.70258,	233070.43662,	233075.17067,	233079.90472,	233084.63878,	233089.37286,	233094.10694,
233098.84102,	233103.57512,	233108.30922,	233113.04333,	233117.77745,	233122.51158,	233127.24572,	233131.97986,	233136.71401,	233141.44817,
233146.18234,	233150.91651,	233155.65070,	233160.38489,	233165.11909,	233169.85329,	233174.58751,	233179.32173,	233184.05597,	233188.79021,
233193.52445,	233198.25871,	233202.99297,	233207.72724,	233212.46152,	233217.19581,	233221.93011,	233226.66441,	233231.39872,	233236.13304,
233240.86737,	233245.60171,	233250.33605,	233255.07040,	233259.80476,	233264.53913,	233269.27350,	233274.00789,	233278.74228,	233283.47668,
233288.21109,	233292.94550,	233297.67993,	233302.41436,	233307.14880,	233311.88325,	233316.61770,	233321.35217,	233326.08664,	233330.82112,
233335.55560,	233340.29010,	233345.02460,	233349.75912,	233354.49364,	233359.22816,	233363.96270,	233368.69724,	233373.43179,	233378.16635,
233382.90092,	233387.63550,	233392.37008,	233397.10467,	233401.83927,	233406.57388,	233411.30850,	233416.04312,	233420.77775,	233425.51239,
233430.24704,	233434.98170,	233439.71636,	233444.45103,	233449.18571,	233453.92040,	233458.65510,	233463.38980,	233468.12451,	233472.85923,
233477.59396,	233482.32870,	233487.06344,	233491.79819,	233496.53295,	233501.26772,	233506.00249,	233510.73728,	233515.47207,	233520.20687,
233524.94168,	233529.67649,	233534.41132,	233539.14615,	233543.88099,	233548.61584,	233553.35069,	233558.08556,	233562.82043,	233567.55531,
233572.29020,	233577.02509,	233581.76000,	233586.49491,	233591.22983,	233595.96475,	233600.69969,	233605.43463,	233610.16959,	233614.90455,
233619.63951,	233624.37449,	233629.10947,	233633.84446,	233638.57946,	233643.31447,	233648.04949,	233652.78451,	233657.51954,	233662.25458,
233666.98963,	233671.72469,	233676.45975,	233681.19482,	233685.92990,	233690.66499,	233695.40008,	233700.13519,	233704.87030,	233709.60542,
233714.34055,	233719.07568,	233723.81083,	233728.54598,	233733.28114,	233738.01631,	233742.75148,	233747.48666,	233752.22186,	233756.95706,
233761.69226,	233766.42748,	233771.16270,	233775.89793,	233780.63317,	233785.36842,	233790.10368,	233794.83894,	233799.57421,	233804.30949,
233809.04478,	233813.78007,	233818.51538,	233823.25069,	233827.98601,	233832.72134,	233837.45667,	233842.19201,	233846.92737,	233851.66272,
233856.39809,	233861.13347,	233865.86885,	233870.60424,	233875.33964,	233880.07505,	233884.81046,	233889.54589,	233894.28132,	233899.01676,
233903.75220,	233908.48766,	233913.22312,	233917.95859,	233922.69407,	233927.42956,	233932.16506,	233936.90056,	233941.63607,	233946.37159,
233951.10712,	233955.84265,	233960.57819,	233965.31374,	233970.04930,	233974.78487,	233979.52045,	233984.25603,	233988.99162,	233993.72722,
233998.46282,	234003.19844,	234007.93406,	234012.66969,	234017.40533,	234022.14098,	234026.87663,	234031.61230,	234036.34797,	234041.08365,
234045.81933,	234050.55503,	234055.29073,	234060.02644,	234064.76216,	234069.49789,	234074.23362,	234078.96936,	234083.70511,	234088.44087,
234093.17664,	234097.91241,	234102.64820,	234107.38399,	234112.11978,	234116.85559,	234121.59141,	234126.32723,	234131.06306,	234135.79890,
234140.53474,	234145.27060,	234150.00646,	234154.74233,	234159.47821,	234164.21409,	234168.94999,	234173.68589,	234178.42180,	234183.15772,
234187.89364,	234192.62958,	234197.36552,	234202.10147,	234206.83743,	234211.57340,	234216.30937,	234221.04535,	234225.78134,	234230.51734,
234235.25334,	234239.98936,	234244.72538,	234249.46141,	234254.19745,	234258.93349,	234263.66955,	234268.40561,	234273.14168,	234277.87776,
234282.61384,	234287.34994,	234292.08604,	234296.82215,	234301.55826,	234306.29439,	234311.03052,	234315.76666,	234320.50281,	234325.23897,
234329.97514,	234334.71131,	234339.44749,	234344.18368,	234348.91988,	234353.65608,	234358.39230,	234363.12852,	234367.86475,	234372.60098,
234377.33723,	234382.07348,	234386.80974,	234391.54601,	234396.28229,	234401.01857,	234405.75487,	234410.49117,	234415.22748,	234419.96379,
234424.70012,	234429.43645,	234434.17279,	234438.90914,	234443.64550,	234448.38186,	234453.11823,	234457.85461,	234462.59100,	234467.32740,
234472.06380,	234476.80022,	234481.53664,	234486.27306,	234491.00950,	234495.74595,	234500.48240,	234505.21886,	234509.95533,	234514.69180,
234519.42829,	234524.16478,	234528.90128,	234533.63779,	234538.37430,	234543.11083,	234547.84736,	234552.58390,	234557.32045,	234562.05700,
234566.79357,	234571.53014,	234576.26672,	234581.00331,	234585.73990,	234590.47650,	234595.21312,	234599.94974,	234604.68636,	234609.42300,
234614.15964,	234618.89629,	234623.63295,	234628.36962,	234633.10630,	234637.84298,	234642.57967,	234647.31637,	234652.05308,	234656.78979,
234661.52652,	234666.26325,	234670.99999,	234675.73673,	234680.47349,	234685.21025,	234689.94702,	234694.68380,	234699.42059,	234704.15738,
234708.89418,	234713.63099,	234718.36781,	234723.10464,	234727.84147,	234732.57832,	234737.31517,	234742.05203,	234746.78889,	234751.52577,
234756.26265,	234760.99954,	234765.73644,	234770.47334,	234775.21026,	234779.94718,	234784.68411,	234789.42105,	234794.15799,	234798.89495,
234803.63191,	234808.36888,	234813.10586,	234817.84284,	234822.57984,	234827.31684,	234832.05385,	234836.79087,	234841.52789,	234846.26493,
234851.00197,	234855.73902,	234860.47607,	234865.21314,	234869.95021,	234874.68729,	234879.42438,	234884.16148,	234888.89859,	234893.63570,
234898.37282,	234903.10995,	234907.84709,	234912.58423,	234917.32138,	234922.05854,	234926.79571,	234931.53289,	234936.27007,	234941.00727,
234945.74447,	234950.48168,	234955.21889,	234959.95612,	234964.69335,	234969.43059,	234974.16784,	234978.90509,	234983.64236,	234988.37963,
234993.11691,	234997.85420,	235002.59149,	235007.32880,	235012.06611,	235016.80343,	235021.54076,	235026.27809,	235031.01544,	235035.75279,
235040.49015,	235045.22752,	235049.96489,	235054.70228,	235059.43967,	235064.17707,	235068.91447,	235073.65189,	235078.38931,	235083.12674,
235087.86418,	235092.60163,	235097.33909,	235102.07655,	235106.81402,	235111.55150,	235116.28898,	235121.02648,	235125.76398,	235130.50149,
235135.23901,	235139.97654,	235144.71407,	235149.45162,	235154.18917,	235158.92672,	235163.66429,	235168.40186,	235173.13945,	235177.87704,
235182.61464,	235187.35224,	235192.08986,	235196.82748,	235201.56511,	235206.30275,	235211.04039,	235215.77804,	235220.51571,	235225.25338,
235229.99105,	235234.72874,	235239.46643,	235244.20413,	235248.94184,	235253.67956,	235258.41729,	235263.15502,	235267.89276,	235272.63051,
235277.36827,	235282.10603,	235286.84380,	235291.58158,	235296.31937,	235301.05717,	235305.79498,	235310.53279,	235315.27061,	235320.00844,
235324.74627,	235329.48412,	235334.22197,	235338.95983,	235343.69770,	235348.43557,	235353.17346,	235357.91135,	235362.64925,	235367.38716,
235372.12507,	235376.86300,	235381.60093,	235386.33887,	235391.07682,	235395.81477,	235400.55274,	235405.29071,	235410.02869,	235414.76667,
235419.50467,	235424.24267,	235428.98068,	235433.71870,	235438.45673,	235443.19477,	235447.93281,	235452.67086,	235457.40892,	235462.14698,
235466.88506,	235471.62314,	235476.36123,	235481.09933,	235485.83744,	235490.57555,	235495.31367,	235500.05180,	235504.78994,	235509.52809,
235514.26624,	235519.00440,	235523.74257,	235528.48075,	235533.21894,	235537.95713,	235542.69533,	235547.43354,	235552.17176,	235556.90999,
235561.64822,	235566.38646,	235571.12471,	235575.86297,	235580.60123,	235585.33950,	235590.07779,	235594.81607,	235599.55437,	235604.29268,
235609.03099,	235613.76931,	235618.50764,	235623.24597,	235627.98432,	235632.72267,	235637.46103,	235642.19940,	235646.93778,	235651.67616,
235656.41455,	235661.15295,	235665.89136,	235670.62978,	235675.36820,	235680.10663,	235684.84507,	235689.58352,	235694.32197,	235699.06044,
235703.79891,	235708.53739,	235713.27588,	235718.01437,	235722.75287,	235727.49139,	235732.22990,	235736.96843,	235741.70697,	235746.44551,
235751.18406,	235755.92262,	235760.66118,	235765.39976,	235770.13834,	235774.87693,	235779.61553,	235784.35414,	235789.09275,	235793.83137,
235798.57000,	235803.30864,	235808.04729,	235812.78594,	235817.52460,	235822.26327,	235827.00195,	235831.74063,	235836.47933,	235841.21803,
235845.95674,	235850.69545,	235855.43418,	235860.17291,	235864.91165,	235869.65040,	235874.38916,	235879.12792,	235883.86670,	235888.60548,
235893.34427,	235898.08306,	235902.82187,	235907.56068,	235912.29950,	235917.03833,	235921.77716,	235926.51601,	235931.25486,	235935.99372,
235940.73259,	235945.47146,	235950.21035,	235954.94924,	235959.68814,	235964.42704,	235969.16596,	235973.90488,	235978.64381,	235983.38275,
235988.12170,	235992.86065,	235997.59962,	236002.33859,	236007.07757,	236011.81655,	236016.55555,	236021.29455,	236026.03356,	236030.77258,
236035.51160,	236040.25064,	236044.98968,	236049.72873,	236054.46779,	236059.20685,	236063.94593,	236068.68501,	236073.42410,	236078.16320,
236082.90230,	236087.64142,	236092.38054,	236097.11967,	236101.85880,	236106.59795,	236111.33710,	236116.07626,	236120.81543,	236125.55461,
236130.29379,	236135.03298,	236139.77218,	236144.51139,	236149.25061,	236153.98983,	236158.72906,	236163.46830,	236168.20755,	236172.94681,
236177.68607,	236182.42534,	236187.16462,	236191.90391,	236196.64321,	236201.38251,	236206.12182,	236210.86114,	236215.60047,	236220.33980,
236225.07914,	236229.81850,	236234.55785,	236239.29722,	236244.03660,	236248.77598,	236253.51537,	236258.25477,	236262.99417,	236267.73359,
236272.47301,	236277.21244,	236281.95188,	236286.69132,	236291.43078,	236296.17024,	236300.90971,	236305.64918,	236310.38867,	236315.12816,
236319.86766,	236324.60717,	236329.34669,	236334.08622,	236338.82575,	236343.56529,	236348.30484,	236353.04439,	236357.78396,	236362.52353,
236367.26311,	236372.00270,	236376.74230,	236381.48190,	236386.22151,	236390.96113,	236395.70076,	236400.44039,	236405.18004,	236409.91969,
236414.65935,	236419.39902,	236424.13869,	236428.87837,	236433.61806,	236438.35776,	236443.09747,	236447.83719,	236452.57691,	236457.31664,
236462.05638,	236466.79612,	236471.53588,	236476.27564,	236481.01541,	236485.75519,	236490.49497,	236495.23477,	236499.97457,	236504.71438,
236509.45420,	236514.19402,	236518.93385,	236523.67370,	236528.41355,	236533.15340,	236537.89327,	236542.63314,	236547.37302,	236552.11291,
236556.85281,	236561.59271,	236566.33262,	236571.07254,	236575.81247,	236580.55241,	236585.29235,	236590.03230,	236594.77226,	236599.51223,
236604.25221,	236608.99219,	236613.73218,	236618.47218,	236623.21219,	236627.95220,	236632.69223,	236637.43226,	236642.17230,	236646.91234,
236651.65240,	236656.39246,	236661.13253,	236665.87261,	236670.61269,	236675.35279,	236680.09289,	236684.83300,	236689.57312,	236694.31324,
236699.05338,	236703.79352,	236708.53367,	236713.27383,	236718.01399,	236722.75416,	236727.49435,	236732.23453,	236736.97473,	236741.71494,
236746.45515,	236751.19537,	236755.93560,	236760.67583,	236765.41608,	236770.15633,	236774.89659,	236779.63686,	236784.37713,	236789.11742,
236793.85771,	236798.59801,	236803.33832,	236808.07863,	236812.81895,	236817.55929,	236822.29963,	236827.03997,	236831.78033,	236836.52069,
236841.26106,	236846.00144,	236850.74182,	236855.48222,	236860.22262,	236864.96303,	236869.70345,	236874.44388,	236879.18431,	236883.92475,
236888.66520,	236893.40566,	236898.14612,	236902.88660,	236907.62708,	236912.36757,	236917.10806,	236921.84857,	236926.58908,	236931.32960,
236936.07013,	236940.81067,	236945.55121,	236950.29176,	236955.03232,	236959.77289,	236964.51347,	236969.25405,	236973.99464,	236978.73524,
236983.47585,	236988.21646,	236992.95709,	236997.69772,	237002.43836,	237007.17900,	237011.91966,	237016.66032,	237021.40099,	237026.14167,
237030.88236,	237035.62305,	237040.36375,	237045.10446,	237049.84518,	237054.58591,	237059.32664,	237064.06738,	237068.80813,	237073.54889,
237078.28965,	237083.03043,	237087.77121,	237092.51200,	237097.25279,	237101.99360,	237106.73441,	237111.47523,	237116.21606,	237120.95690,
237125.69774,	237130.43859,	237135.17945,	237139.92032,	237144.66120,	237149.40208,	237154.14297,	237158.88387,	237163.62478,	237168.36569,
237173.10661,	237177.84755,	237182.58848,	237187.32943,	237192.07039,	237196.81135,	237201.55232,	237206.29330,	237211.03428,	237215.77528,
237220.51628,	237225.25729,	237229.99831,	237234.73933,	237239.48036,	237244.22141,	237248.96245,	237253.70351,	237258.44458,	237263.18565,
237267.92673,	237272.66782,	237277.40891,	237282.15002,	237286.89113,	237291.63225,	237296.37338,	237301.11451,	237305.85566,	237310.59681,
237315.33797,	237320.07914,	237324.82031,	237329.56150,	237334.30269,	237339.04389,	237343.78509,	237348.52631,	237353.26753,	237358.00876,
237362.75000,	237367.49124,	237372.23250,	237376.97376,	237381.71503,	237386.45631,	237391.19759,	237395.93889,	237400.68019,	237405.42150,
237410.16281,	237414.90414,	237419.64547,	237424.38681,	237429.12816,	237433.86952,	237438.61088,	237443.35225,	237448.09363,	237452.83502,
237457.57642,	237462.31782,	237467.05923,	237471.80065,	237476.54208,	237481.28352,	237486.02496,	237490.76641,	237495.50787,	237500.24934,
237504.99081,	237509.73229,	237514.47378,	237519.21528,	237523.95679,	237528.69830,	237533.43982,	237538.18135,	237542.92289,	237547.66444,
237552.40599,	237557.14755,	237561.88912,	237566.63070,	237571.37228,	237576.11388,	237580.85548,	237585.59708,	237590.33870,	237595.08032,
237599.82196,	237604.56360,	237609.30524,	237614.04690,	237618.78856,	237623.53024,	237628.27192,	237633.01360,	237637.75530,	237642.49700,
237647.23871,	237651.98043,	237656.72216,	237661.46389,	237666.20563,	237670.94738,	237675.68914,	237680.43091,	237685.17268,	237689.91446,
237694.65625,	237699.39805,	237704.13986,	237708.88167,	237713.62349,	237718.36532,	237723.10716,	237727.84900,	237732.59085,	237737.33271,
237742.07458,	237746.81646,	237751.55834,	237756.30023,	237761.04213,	237765.78404,	237770.52596,	237775.26788,	237780.00981,	237784.75175,
237789.49370,	237794.23565,	237798.97761,	237803.71958,	237808.46156,	237813.20355,	237817.94554,	237822.68755,	237827.42956,	237832.17157,
237836.91360,	237841.65563,	237846.39767,	237851.13972,	237855.88178,	237860.62384,	237865.36592,	237870.10800,	237874.85009,	237879.59218,
237884.33429,	237889.07640,	237893.81852,	237898.56065,	237903.30278,	237908.04493,	237912.78708,	237917.52924,	237922.27140,	237927.01358,
237931.75576,	237936.49795,	237941.24015,	237945.98236,	237950.72457,	237955.46680,	237960.20903,	237964.95126,	237969.69351,	237974.43576,
237979.17802,	237983.92029,	237988.66257,	237993.40486,	237998.14715,	238002.88945,	238007.63176,	238012.37408,	238017.11640,	238021.85873,
238026.60107,	238031.34342,	238036.08578,	238040.82814,	238045.57051,	238050.31289,	238055.05528,	238059.79767,	238064.54008,	238069.28249,
238074.02491,	238078.76733,	238083.50977,	238088.25221,	238092.99466,	238097.73712,	238102.47958,	238107.22206,	238111.96454,	238116.70703,
238121.44953,	238126.19203,	238130.93454,	238135.67706,	238140.41959,	238145.16213,	238149.90467,	238154.64723,	238159.38979,	238164.13235,
238168.87493,	238173.61751,	238178.36011,	238183.10271,	238187.84531,	238192.58793,	238197.33055,	238202.07318,	238206.81582,	238211.55847,
238216.30112,	238221.04378,	238225.78645,	238230.52913,	238235.27182,	238240.01451,	238244.75721,	238249.49992,	238254.24264,	238258.98537,
238263.72810,	238268.47084,	238273.21359,	238277.95634,	238282.69911,	238287.44188,	238292.18466,	238296.92745,	238301.67024,	238306.41305,
238311.15586,	238315.89868,	238320.64151,	238325.38434,	238330.12718,	238334.87004,	238339.61289,	238344.35576,	238349.09863,	238353.84152,
238358.58441,	238363.32730,	238368.07021,	238372.81312,	238377.55605,	238382.29897,	238387.04191,	238391.78486,	238396.52781,	238401.27077,
238406.01374,	238410.75672,	238415.49970,	238420.24269,	238424.98569,	238429.72870,	238434.47171,	238439.21474,	238443.95777,	238448.70081,
238453.44386,	238458.18691,	238462.92997,	238467.67304,	238472.41612,	238477.15921,	238481.90230,	238486.64540,	238491.38851,	238496.13163,
238500.87476,	238505.61789,	238510.36103,	238515.10418,	238519.84734,	238524.59050,	238529.33367,	238534.07686,	238538.82004,	238543.56324,
238548.30644,	238553.04966,	238557.79287,	238562.53610,	238567.27934,	238572.02258,	238576.76583,	238581.50909,	238586.25236,	238590.99563,
238595.73891,	238600.48220,	238605.22550,	238609.96881,	238614.71212,	238619.45544,	238624.19877,	238628.94211,	238633.68546,	238638.42881,
238643.17217,	238647.91554,	238652.65891,	238657.40230,	238662.14569,	238666.88909,	238671.63250,	238676.37591,	238681.11934,	238685.86277,
238690.60621,	238695.34966,	238700.09311,	238704.83657,	238709.58004,	238714.32352,	238719.06701,	238723.81050,	238728.55400,	238733.29751,
238738.04103,	238742.78456,	238747.52809,	238752.27163,	238757.01518,	238761.75874,	238766.50230,	238771.24587,	238775.98945,	238780.73304,
238785.47664,	238790.22024,	238794.96385,	238799.70747,	238804.45110,	238809.19474,	238813.93838,	238818.68203,	238823.42569,	238828.16936,
238832.91303,	238837.65671,	238842.40040,	238847.14410,	238851.88781,	238856.63152,	238861.37524,	238866.11897,	238870.86271,	238875.60645,
238880.35020,	238885.09396,	238889.83773,	238894.58151,	238899.32529,	238904.06909,	238908.81289,	238913.55669,	238918.30051,	238923.04433,
238927.78816,	238932.53200,	238937.27585,	238942.01970,	238946.76356,	238951.50744,	238956.25131,	238960.99520,	238965.73909,	238970.48299,
238975.22690,	238979.97082,	238984.71475,	238989.45868,	238994.20262,	238998.94657,	239003.69052,	239008.43449,	239013.17846,	239017.92244,
239022.66643,	239027.41042,	239032.15443,	239036.89844,	239041.64246,	239046.38648,	239051.13052,	239055.87456,	239060.61861,	239065.36267,
239070.10674,	239074.85081,	239079.59489,	239084.33898,	239089.08308,	239093.82718,	239098.57130,	239103.31542,	239108.05955,	239112.80368,
239117.54783,	239122.29198,	239127.03614,	239131.78031,	239136.52448,	239141.26867,	239146.01286,	239150.75706,	239155.50126,	239160.24548,
239164.98970,	239169.73393,	239174.47817,	239179.22241,	239183.96667,	239188.71093,	239193.45520,	239198.19948,	239202.94376,	239207.68805,
239212.43236,	239217.17666,	239221.92098,	239226.66530,	239231.40964,	239236.15398,	239240.89832,	239245.64268,	239250.38704,	239255.13141,
239259.87579,	239264.62018,	239269.36458,	239274.10898,	239278.85339,	239283.59781,	239288.34223,	239293.08667,	239297.83111,	239302.57556,
239307.32001,	239312.06448,	239316.80895,	239321.55343,	239326.29792,	239331.04242,	239335.78692,	239340.53143,	239345.27595,	239350.02048,
239354.76502,	239359.50956,	239364.25411,	239368.99867,	239373.74324,	239378.48781,	239383.23239,	239387.97699,	239392.72158,	239397.46619,
239402.21080,	239406.95542,	239411.70005,	239416.44469,	239421.18934,	239425.93399,	239430.67865,	239435.42332,	239440.16799,	239444.91268,
239449.65737,	239454.40207,	239459.14678,	239463.89149,	239468.63622,	239473.38095,	239478.12569,	239482.87043,	239487.61519,	239492.35995,
239497.10472,	239501.84950,	239506.59428,	239511.33908,	239516.08388,	239520.82869,	239525.57350,	239530.31833,	239535.06316,	239539.80800,
239544.55285,	239549.29771,	239554.04257,	239558.78744,	239563.53232,	239568.27721,	239573.02210,	239577.76701,	239582.51192,	239587.25683,
239592.00176,	239596.74670,	239601.49164,	239606.23659,	239610.98154,	239615.72651,	239620.47148,	239625.21646,	239629.96145,	239634.70645,
239639.45145,	239644.19647,	239648.94149,	239653.68651,	239658.43155,	239663.17659,	239667.92165,	239672.66670,	239677.41177,	239682.15685,
239686.90193,	239691.64702,	239696.39212,	239701.13722,	239705.88234,	239710.62746,	239715.37259,	239720.11773,	239724.86287,	239729.60802,
239734.35318,	239739.09835,	239743.84353,	239748.58871,	239753.33391,	239758.07910,	239762.82431,	239767.56953,	239772.31475,	239777.05998,
239781.80522,	239786.55047,	239791.29572,	239796.04098,	239800.78625,	239805.53153,	239810.27682,	239815.02211,	239819.76741,	239824.51272,
239829.25804,	239834.00336,	239838.74870,	239843.49404,	239848.23938,	239852.98474,	239857.73010,	239862.47547,	239867.22085,	239871.96624,
239876.71164,	239881.45704,	239886.20245,	239890.94787,	239895.69329,	239900.43873,	239905.18417,	239909.92962,	239914.67508,	239919.42054,
239924.16601,	239928.91150,	239933.65698,	239938.40248,	239943.14798,	239947.89350,	239952.63902,	239957.38454,	239962.13008,	239966.87562,
239971.62117,	239976.36673,	239981.11230,	239985.85787,	239990.60346,	239995.34905,	240000.09464,	240004.84025,	240009.58586,	240014.33148,
240019.07711,	240023.82275,	240028.56839,	240033.31405,	240038.05971,	240042.80537,	240047.55105,	240052.29673,	240057.04243,	240061.78813,
240066.53383,	240071.27955,	240076.02527,	240080.77100,	240085.51674,	240090.26248,	240095.00824,	240099.75400,	240104.49977,	240109.24555,
240113.99133,	240118.73712,	240123.48292,	240128.22873,	240132.97455,	240137.72037,	240142.46621,	240147.21204,	240151.95789,	240156.70375,
240161.44961,	240166.19548,	240170.94136,	240175.68725,	240180.43314,	240185.17904,	240189.92495,	240194.67087,	240199.41679,	240204.16273,
240208.90867,	240213.65462,	240218.40057,	240223.14654,	240227.89251,	240232.63849,	240237.38448,	240242.13047,	240246.87648,	240251.62249,
240256.36851,	240261.11453,	240265.86057,	240270.60661,	240275.35266,	240280.09872,	240284.84478,	240289.59086,	240294.33694,	240299.08303,
240303.82912,	240308.57523,	240313.32134,	240318.06746,	240322.81359,	240327.55973,	240332.30587,	240337.05202,	240341.79818,	240346.54435,
240351.29052,	240356.03670,	240360.78289,	240365.52909,	240370.27530,	240375.02151,	240379.76773,	240384.51396,	240389.26020,	240394.00645,
240398.75270,	240403.49896,	240408.24523,	240412.99150,	240417.73779,	240422.48408,	240427.23038,	240431.97668,	240436.72300,	240441.46932,
240446.21565,	240450.96199,	240455.70834,	240460.45469,	240465.20105,	240469.94742,	240474.69380,	240479.44018,	240484.18658,	240488.93298,
240493.67939,	240498.42580,	240503.17223,	240507.91866,	240512.66510,	240517.41155,	240522.15800,	240526.90446,	240531.65093,	240536.39741,
240541.14390,	240545.89039,	240550.63690,	240555.38341,	240560.12992,	240564.87645,	240569.62298,	240574.36952,	240579.11607,	240583.86263,
240588.60919,	240593.35576,	240598.10234,	240602.84893,	240607.59553,	240612.34213,	240617.08874,	240621.83536,	240626.58198,	240631.32862,
240636.07526,	240640.82191,	240645.56857,	240650.31523,	240655.06191,	240659.80859,	240664.55528,	240669.30197,	240674.04868,	240678.79539,
240683.54211,	240688.28884,	240693.03557,	240697.78231,	240702.52907,	240707.27582,	240712.02259,	240716.76936,	240721.51615,	240726.26294,
240731.00973,	240735.75654,	240740.50335,	240745.25017,	240749.99700,	240754.74384,	240759.49068,	240764.23754,	240768.98439,	240773.73126,
240778.47814,	240783.22502,	240787.97191,	240792.71881,	240797.46572,	240802.21263,	240806.95955,	240811.70648,	240816.45342,	240821.20037,
240825.94732,	240830.69428,	240835.44125,	240840.18823,	240844.93521,	240849.68220,	240854.42920,	240859.17621,	240863.92323,	240868.67025,
240873.41728,	240878.16432,	240882.91136,	240887.65842,	240892.40548,	240897.15255,	240901.89963,	240906.64671,	240911.39381,	240916.14091,
240920.88802,	240925.63513,	240930.38226,	240935.12939,	240939.87653,	240944.62368,	240949.37083,	240954.11800,	240958.86517,	240963.61234,
240968.35953,	240973.10673,	240977.85393,	240982.60114,	240987.34835,	240992.09558,	240996.84281,	241001.59005,	241006.33730,	241011.08456,
241015.83182,	241020.57910,	241025.32637,	241030.07366,	241034.82096,	241039.56826,	241044.31557,	241049.06289,	241053.81022,	241058.55755,
241063.30489,	241068.05224,	241072.79960,	241077.54696,	241082.29434,	241087.04172,	241091.78911,	241096.53650,	241101.28391,	241106.03132,
241110.77874,	241115.52617,	241120.27360,	241125.02104,	241129.76849,	241134.51595,	241139.26342,	241144.01089,	241148.75837,	241153.50586,
241158.25336,	241163.00087,	241167.74838,	241172.49590,	241177.24343,	241181.99096,	241186.73851,	241191.48606,	241196.23362,	241200.98119,
241205.72876,	241210.47634,	241215.22393,	241219.97153,	241224.71914,	241229.46675,	241234.21437,	241238.96200,	241243.70964,	241248.45729,
241253.20494,	241257.95260,	241262.70027,	241267.44794,	241272.19563,	241276.94332,	241281.69102,	241286.43872,	241291.18644,	241295.93416,
241300.68189,	241305.42963,	241310.17737,	241314.92513,	241319.67289,	241324.42066,	241329.16844,	241333.91622,	241338.66401,	241343.41181,
241348.15962,	241352.90744,	241357.65526,	241362.40309,	241367.15093,	241371.89878,	241376.64663,	241381.39449,	241386.14236,	241390.89024,
241395.63813,	241400.38602,	241405.13392,	241409.88183,	241414.62974,	241419.37767,	241424.12560,	241428.87354,	241433.62149,	241438.36944,
241443.11741,	241447.86538,	241452.61336,	241457.36134,	241462.10934,	241466.85734,	241471.60535,	241476.35337,	241481.10139,	241485.84942,
241490.59746,	241495.34551,	241500.09357,	241504.84163,	241509.58970,	241514.33778,	241519.08587,	241523.83397,	241528.58207,	241533.33018,
241538.07830,	241542.82642,	241547.57456,	241552.32270,	241557.07085,	241561.81900,	241566.56717,	241571.31534,	241576.06352,	241580.81171,
241585.55991,	241590.30811,	241595.05632,	241599.80454,	241604.55277,	241609.30100,	241614.04924,	241618.79749,	241623.54575,	241628.29402,
241633.04229,	241637.79057,	241642.53886,	241647.28716,	241652.03546,	241656.78377,	241661.53209,	241666.28042,	241671.02876,	241675.77710,
241680.52545,	241685.27381,	241690.02218,	241694.77055,	241699.51893,	241704.26732,	241709.01572,	241713.76412,	241718.51254,	241723.26096,
241728.00939,	241732.75782,	241737.50627,	241742.25472,	241747.00318,	241751.75164,	241756.50012,	241761.24860,	241765.99709,	241770.74559,
241775.49410,	241780.24261,	241784.99113,	241789.73966,	241794.48820,	241799.23674,	241803.98529,	241808.73385,	241813.48242,	241818.23100,
241822.97958,	241827.72817,	241832.47677,	241837.22538,	241841.97399,	241846.72261,	241851.47124,	241856.21988,	241860.96853,	241865.71718,
241870.46584,	241875.21451,	241879.96318,	241884.71187,	241889.46056,	241894.20926,	241898.95797,	241903.70668,	241908.45541,	241913.20414,
241917.95287,	241922.70162,	241927.45037,	241932.19914,	241936.94790,	241941.69668,	241946.44547,	241951.19426,	241955.94306,	241960.69187,
241965.44068,	241970.18951,	241974.93834,	241979.68718,	241984.43602,	241989.18488,	241993.93374,	241998.68261,	242003.43149,	242008.18037,
242012.92927,	242017.67817,	242022.42708,	242027.17599,	242031.92492,	242036.67385,	242041.42279,	242046.17174,	242050.92069,	242055.66965,
242060.41862,	242065.16760,	242069.91659,	242074.66558,	242079.41458,	242084.16359,	242088.91261,	242093.66164,	242098.41067,	242103.15971,
242107.90876,	242112.65781,	242117.40688,	242122.15595,	242126.90503,	242131.65411,	242136.40321,	242141.15231,	242145.90142,	242150.65054,
242155.39966,	242160.14879,	242164.89794,	242169.64708,	242174.39624,	242179.14540,	242183.89458,	242188.64376,	242193.39294,	242198.14214,
242202.89134,	242207.64055,	242212.38977,	242217.13900,	242221.88823,	242226.63747,	242231.38672,	242236.13598,	242240.88524,	242245.63451,
242250.38379,	242255.13308,	242259.88238,	242264.63168,	242269.38099,	242274.13031,	242278.87964,	242283.62897,	242288.37831,	242293.12766,
242297.87702,	242302.62639,	242307.37576,	242312.12514,	242316.87453,	242321.62393,	242326.37333,	242331.12274,	242335.87216,	242340.62159,
242345.37102,	242350.12046,	242354.86991,	242359.61937,	242364.36884,	242369.11831,	242373.86779,	242378.61728,	242383.36678,	242388.11628,
242392.86580,	242397.61532,	242402.36484,	242407.11438,	242411.86392,	242416.61347,	242421.36303,	242426.11260,	242430.86217,	242435.61175,
242440.36134,	242445.11094,	242449.86054,	242454.61016,	242459.35978,	242464.10941,	242468.85904,	242473.60869,	242478.35834,	242483.10800,
242487.85766,	242492.60734,	242497.35702,	242502.10671,	242506.85641,	242511.60611,	242516.35582,	242521.10555,	242525.85527,	242530.60501,
242535.35475,	242540.10451,	242544.85427,	242549.60403,	242554.35381,	242559.10359,	242563.85338,	242568.60318,	242573.35299,	242578.10280,
242582.85262,	242587.60245,	242592.35229,	242597.10213,	242601.85198,	242606.60184,	242611.35171,	242616.10159,	242620.85147,	242625.60136,
242630.35126,	242635.10116,	242639.85108,	242644.60100,	242649.35093,	242654.10087,	242658.85081,	242663.60076,	242668.35072,	242673.10069,
242677.85067,	242682.60065,	242687.35064,	242692.10064,	242696.85065,	242701.60066,	242706.35069,	242711.10072,	242715.85075,	242720.60080,
242725.35085,	242730.10091,	242734.85098,	242739.60106,	242744.35114,	242749.10123,	242753.85133,	242758.60144,	242763.35155,	242768.10168,
242772.85181,	242777.60194,	242782.35209,	242787.10224,	242791.85240,	242796.60257,	242801.35275,	242806.10293,	242810.85313,	242815.60333,
242820.35353,	242825.10375,	242829.85397,	242834.60420,	242839.35444,	242844.10469,	242848.85494,	242853.60520,	242858.35547,	242863.10575,
242867.85603,	242872.60633,	242877.35663,	242882.10693,	242886.85725,	242891.60757,	242896.35790,	242901.10824,	242905.85859,	242910.60894,
242915.35930,	242920.10967,	242924.86005,	242929.61044,	242934.36083,	242939.11123,	242943.86164,	242948.61205,	242953.36248,	242958.11291,
242962.86335,	242967.61379,	242972.36425,	242977.11471,	242981.86518,	242986.61566,	242991.36614,	242996.11663,	243000.86714,	243005.61764,
243010.36816,	243015.11868,	243019.86922,	243024.61975,	243029.37030,	243034.12086,	243038.87142,	243043.62199,	243048.37257,	243053.12315,
243057.87375,	243062.62435,	243067.37495,	243072.12557,	243076.87620,	243081.62683,	243086.37747,	243091.12811,	243095.87877,	243100.62943,
243105.38010,	243110.13078,	243114.88147,	243119.63216,	243124.38286,	243129.13357,	243133.88429,	243138.63501,	243143.38574,	243148.13648,
243152.88723,	243157.63798,	243162.38875,	243167.13952,	243171.89030,	243176.64108,	243181.39188,	243186.14268,	243190.89349,	243195.64430,
243200.39513,	243205.14596,	243209.89680,	243214.64765,	243219.39850,	243224.14937,	243228.90024,	243233.65112,	243238.40200,	243243.15290,
243247.90380,	243252.65471,	243257.40562,	243262.15655,	243266.90748,	243271.65842,	243276.40937,	243281.16032,	243285.91129,	243290.66226,
243295.41324,	243300.16422,	243304.91522,	243309.66622,	243314.41723,	243319.16825,	243323.91927,	243328.67030,	243333.42134,	243338.17239,
243342.92345,	243347.67451,	243352.42558,	243357.17666,	243361.92775,	243366.67884,	243371.42994,	243376.18105,	243380.93217,	243385.68330,
243390.43443,	243395.18557,	243399.93672,	243404.68787,	243409.43904,	243414.19021,	243418.94139,	243423.69257,	243428.44377,	243433.19497,
243437.94618,	243442.69740,	243447.44862,	243452.19986,	243456.95110,	243461.70235,	243466.45360,	243471.20486,	243475.95614,	243480.70742,
243485.45870,	243490.21000,	243494.96130,	243499.71261,	243504.46393,	243509.21525,	243513.96658,	243518.71793,	243523.46927,	243528.22063,
243532.97199,	243537.72337,	243542.47474,	243547.22613,	243551.97753,	243556.72893,	243561.48034,	243566.23176,	243570.98318,	243575.73461,
243580.48606,	243585.23750,	243589.98896,	243594.74042,	243599.49190,	243604.24337,	243608.99486,	243613.74636,	243618.49786,	243623.24937,
243628.00089,	243632.75241,	243637.50394,	243642.25549,	243647.00703,	243651.75859,	243656.51015,	243661.26173,	243666.01331,	243670.76489,
243675.51649,	243680.26809,	243685.01970,	243689.77132,	243694.52294,	243699.27458,	243704.02622,	243708.77787,	243713.52952,	243718.28119,
243723.03286,	243727.78454,	243732.53622,	243737.28792,	243742.03962,	243746.79133,	243751.54305,	243756.29477,	243761.04651,	243765.79825,
243770.55000,	243775.30175,	243780.05352,	243784.80529,	243789.55707,	243794.30885,	243799.06065,	243803.81245,	243808.56426,	243813.31608,
243818.06791,	243822.81974,	243827.57158,	243832.32343,	243837.07528,	243841.82715,	243846.57902,	243851.33090,	243856.08279,	243860.83468,
243865.58658,	243870.33849,	243875.09041,	243879.84234,	243884.59427,	243889.34621,	243894.09816,	243898.85012,	243903.60208,	243908.35405,
243913.10603,	243917.85802,	243922.61001,	243927.36201,	243932.11402,	243936.86604,	243941.61807,	243946.37010,	243951.12214,	243955.87419,
243960.62625,	243965.37831,	243970.13038,	243974.88246,	243979.63455,	243984.38664,	243989.13874,	243993.89085,	243998.64297,	244003.39510,
244008.14723,	244012.89937,	244017.65152,	244022.40367,	244027.15584,	244031.90801,	244036.66019,	244041.41238,	244046.16457,	244050.91677,
244055.66898,	244060.42120,	244065.17342,	244069.92566,	244074.67790,	244079.43015,	244084.18240,	244088.93467,	244093.68694,	244098.43922,
244103.19150,	244107.94380,	244112.69610,	244117.44841,	244122.20073,	244126.95305,	244131.70538,	244136.45772,	244141.21007,	244145.96243,
244150.71479,	244155.46716,	244160.21954,	244164.97193,	244169.72432,	244174.47672,	244179.22913,	244183.98155,	244188.73398,	244193.48641,
244198.23885,	244202.99130,	244207.74375,	244212.49622,	244217.24869,	244222.00117,	244226.75365,	244231.50615,	244236.25865,	244241.01116,
244245.76367,	244250.51620,	244255.26873,	244260.02127,	244264.77382,	244269.52638,	244274.27894,	244279.03151,	244283.78409,	244288.53667,
244293.28927,	244298.04187,	244302.79448,	244307.54710,	244312.29972,	244317.05235,	244321.80499,	244326.55764,	244331.31029,	244336.06296,
244340.81563,	244345.56831,	244350.32099,	244355.07369,	244359.82639,	244364.57910,	244369.33181,	244374.08454,	244378.83727,	244383.59001,
244388.34276,	244393.09551,	244397.84827,	244402.60104,	244407.35382,	244412.10661,	244416.85940,	244421.61220,	244426.36501,	244431.11783,
244435.87065,	244440.62348,	244445.37632,	244450.12917,	244454.88203,	244459.63489,	244464.38776,	244469.14064,	244473.89352,	244478.64641,
244483.39932,	244488.15222,	244492.90514,	244497.65806,	244502.41100,	244507.16393,	244511.91688,	244516.66984,	244521.42280,	244526.17577,
244530.92875,	244535.68173,	244540.43472,	244545.18772,	244549.94073,	244554.69375,	244559.44677,	244564.19980,	244568.95284,	244573.70589,
244578.45894,	244583.21200,	244587.96507,	244592.71815,	244597.47124,	244602.22433,	244606.97743,	244611.73054,	244616.48365,	244621.23678,
244625.98991,	244630.74305,	244635.49619,	244640.24935,	244645.00251,	244649.75568,	244654.50885,	244659.26204,	244664.01523,	244668.76843,
244673.52164,	244678.27485,	244683.02808,	244687.78131,	244692.53454,	244697.28779,	244702.04104,	244706.79431,	244711.54757,	244716.30085,
244721.05414,	244725.80743,	244730.56073,	244735.31403,	244740.06735,	244744.82067,	244749.57400,	244754.32734,	244759.08068,	244763.83404,
244768.58740,	244773.34077,	244778.09414,	244782.84753,	244787.60092,	244792.35432,	244797.10773,	244801.86114,	244806.61456,	244811.36799,
244816.12143,	244820.87487,	244825.62833,	244830.38179,	244835.13526,	244839.88873,	244844.64222,	244849.39571,	244854.14921,	244858.90271,
244863.65623,	244868.40975,	244873.16328,	244877.91681,	244882.67036,	244887.42391,	244892.17747,	244896.93104,	244901.68461,	244906.43820,
244911.19179,	244915.94539,	244920.69899,	244925.45261,	244930.20623,	244934.95986,	244939.71349,	244944.46714,	244949.22079,	244953.97445,
244958.72812,	244963.48179,	244968.23547,	244972.98916,	244977.74286,	244982.49657,	244987.25028,	244992.00400,	244996.75773,	245001.51147,
245006.26521,	245011.01896,	245015.77272,	245020.52649,	245025.28026,	245030.03405,	245034.78783,	245039.54163,	245044.29544,	245049.04925,
245053.80307,	245058.55690,	245063.31073,	245068.06458,	245072.81843,	245077.57229,	245082.32615,	245087.08003,	245091.83391,	245096.58780,
245101.34170,	245106.09560,	245110.84951,	245115.60343,	245120.35736,	245125.11130,	245129.86524,	245134.61919,	245139.37315,	245144.12711,
245148.88109,	245153.63507,	245158.38906,	245163.14305,	245167.89706,	245172.65107,	245177.40509,	245182.15912,	245186.91315,	245191.66719,
245196.42124,	245201.17530,	245205.92937,	245210.68344,	245215.43752,	245220.19161,	245224.94570,	245229.69981,	245234.45392,	245239.20804,
245243.96216,	245248.71630,	245253.47044,	245258.22459,	245262.97875,	245267.73291,	245272.48708,	245277.24126,	245281.99545,	245286.74965,
245291.50385,	245296.25806,	245301.01228,	245305.76651,	245310.52074,	245315.27498,	245320.02923,	245324.78349,	245329.53775,	245334.29202,
245339.04630,	245343.80059,	245348.55488,	245353.30919,	245358.06350,	245362.81781,	245367.57214,	245372.32647,	245377.08081,	245381.83516,
245386.58952,	245391.34388,	245396.09825,	245400.85263,	245405.60702,	245410.36141,	245415.11581,	245419.87022,	245424.62464,	245429.37906,
245434.13350,	245438.88794,	245443.64239,	245448.39684,	245453.15130,	245457.90577,	245462.66025,	245467.41474,	245472.16923,	245476.92373,
245481.67824,	245486.43276,	245491.18728,	245495.94181,	245500.69635,	245505.45090,	245510.20546,	245514.96002,	245519.71459,	245524.46917,
245529.22375,	245533.97834,	245538.73294,	245543.48755,	245548.24217,	245552.99679,	245557.75142,	245562.50606,	245567.26071,	245572.01536,
245576.77002,	245581.52469,	245586.27937,	245591.03406,	245595.78875,	245600.54345,	245605.29816,	245610.05287,	245614.80759,	245619.56232,
245624.31706,	245629.07181,	245633.82656,	245638.58132,	245643.33609,	245648.09087,	245652.84565,	245657.60044,	245662.35524,	245667.11005,
245671.86486,	245676.61969,	245681.37451,	245686.12935,	245690.88420,	245695.63905,	245700.39391,	245705.14878,	245709.90365,	245714.65854,
245719.41343,	245724.16833,	245728.92323,	245733.67815,	245738.43307,	245743.18800,	245747.94293,	245752.69788,	245757.45283,	245762.20779,
245766.96276,	245771.71773,	245776.47271,	245781.22770,	245785.98270,	245790.73771,	245795.49272,	245800.24774,	245805.00277,	245809.75781,
245814.51285,	245819.26790,	245824.02296,	245828.77803,	245833.53310,	245838.28818,	245843.04327,	245847.79837,	245852.55347,	245857.30858,
245862.06370,	245866.81883,	245871.57397,	245876.32911,	245881.08426,	245885.83942,	245890.59458,	245895.34976,	245900.10494,	245904.86013,
245909.61532,	245914.37053,	245919.12574,	245923.88096,	245928.63618,	245933.39142,	245938.14666,	245942.90191,	245947.65717,	245952.41243,
245957.16770,	245961.92298,	245966.67827,	245971.43357,	245976.18887,	245980.94418,	245985.69950,	245990.45483,	245995.21016,	245999.96550,
246004.72085,	246009.47621,	246014.23157,	246018.98694,	246023.74232,	246028.49771,	246033.25310,	246038.00850,	246042.76391,	246047.51933,
246052.27476,	246057.03019,	246061.78563,	246066.54108,	246071.29653,	246076.05200,	246080.80747,	246085.56295,	246090.31843,	246095.07393,
246099.82943,	246104.58494,	246109.34045,	246114.09598,	246118.85151,	246123.60705,	246128.36260,	246133.11815,	246137.87371,	246142.62928,
246147.38486,	246152.14045,	246156.89604,	246161.65164,	246166.40725,	246171.16286,	246175.91849,	246180.67412,	246185.42976,	246190.18540,
246194.94106,	246199.69672,	246204.45239,	246209.20806,	246213.96375,	246218.71944,	246223.47514,	246228.23085,	246232.98656,	246237.74228,
246242.49801,	246247.25375,	246252.00950,	246256.76525,	246261.52101,	246266.27678,	246271.03255,	246275.78834,	246280.54413,	246285.29993,
246290.05573,	246294.81155,	246299.56737,	246304.32320,	246309.07903,	246313.83488,	246318.59073,	246323.34659,	246328.10246,	246332.85833,
246337.61422,	246342.37011,	246347.12600,	246351.88191,	246356.63782,	246361.39374,	246366.14967,	246370.90561,	246375.66155,	246380.41750,
246385.17346,	246389.92943,	246394.68540,	246399.44138,	246404.19737,	246408.95337,	246413.70937,	246418.46538,	246423.22140,	246427.97743,
246432.73346,	246437.48951,	246442.24556,	246447.00161,	246451.75768,	246456.51375,	246461.26983,	246466.02592,	246470.78202,	246475.53812,
246480.29423,	246485.05035,	246489.80648,	246494.56261,	246499.31875,	246504.07490,	246508.83106,	246513.58722,	246518.34339,	246523.09957,
246527.85576,	246532.61196,	246537.36816,	246542.12437,	246546.88059,	246551.63681,	246556.39304,	246561.14928,	246565.90553,	246570.66179,
246575.41805,	246580.17432,	246584.93060,	246589.68689,	246594.44318,	246599.19948,	246603.95579,	246608.71211,	246613.46843,	246618.22476,
246622.98110,	246627.73745,	246632.49380,	246637.25017,	246642.00654,	246646.76291,	246651.51930,	246656.27569,	246661.03209,	246665.78850,
246670.54491,	246675.30134,	246680.05777,	246684.81421,	246689.57065,	246694.32711,	246699.08357,	246703.84004,	246708.59651,	246713.35300,
246718.10949,	246722.86599,	246727.62249,	246732.37901,	246737.13553,	246741.89206,	246746.64860,	246751.40514,	246756.16169,	246760.91825,
246765.67482,	246770.43140,	246775.18798,	246779.94457,	246784.70117,	246789.45777,	246794.21439,	246798.97101,	246803.72764,	246808.48427,
246813.24092,	246817.99757,	246822.75423,	246827.51089,	246832.26757,	246837.02425,	246841.78094,	246846.53764,	246851.29434,	246856.05105,
246860.80777,	246865.56450,	246870.32123,	246875.07798,	246879.83473,	246884.59148,	246889.34825,	246894.10502,	246898.86180,	246903.61859,
246908.37539,	246913.13219,	246917.88900,	246922.64582,	246927.40265,	246932.15948,	246936.91632,	246941.67317,	246946.43003,	246951.18689,
246955.94376,	246960.70064,	246965.45753,	246970.21443,	246974.97133,	246979.72824,	246984.48515,	246989.24208,	246993.99901,	246998.75595,
247003.51290,	247008.26986,	247013.02682,	247017.78379,	247022.54077,	247027.29775,	247032.05475,	247036.81175,	247041.56876,	247046.32577,
247051.08280,	247055.83983,	247060.59687,	247065.35391,	247070.11097,	247074.86803,	247079.62510,	247084.38218,	247089.13926,	247093.89635,
247098.65345,	247103.41056,	247108.16768,	247112.92480,	247117.68193,	247122.43907,	247127.19621,	247131.95336,	247136.71052,	247141.46769,
247146.22487,	247150.98205,	247155.73924,	247160.49644,	247165.25365,	247170.01086,	247174.76808,	247179.52531,	247184.28255,	247189.03979,
247193.79704,	247198.55430,	247203.31157,	247208.06885,	247212.82613,	247217.58342,	247222.34071,	247227.09802,	247231.85533,	247236.61265,
247241.36998,	247246.12732,	247250.88466,	247255.64201,	247260.39937,	247265.15673,	247269.91411,	247274.67149,	247279.42887,	247284.18627,
247288.94367,	247293.70109,	247298.45850,	247303.21593,	247307.97336,	247312.73081,	247317.48826,	247322.24571,	247327.00318,	247331.76065,
247336.51813,	247341.27562,	247346.03311,	247350.79061,	247355.54812,	247360.30564,	247365.06316,	247369.82070,	247374.57824,	247379.33579,
247384.09334,	247388.85090,	247393.60847,	247398.36605,	247403.12364,	247407.88123,	247412.63883,	247417.39644,	247422.15406,	247426.91168,
247431.66931,	247436.42695,	247441.18460,	247445.94225,	247450.69991,	247455.45758,	247460.21526,	247464.97294,	247469.73064,	247474.48834,
247479.24604,	247484.00376,	247488.76148,	247493.51921,	247498.27695,	247503.03469,	247507.79245,	247512.55021,	247517.30797,	247522.06575,
247526.82353,	247531.58132,	247536.33912,	247541.09693,	247545.85474,	247550.61256,	247555.37039,	247560.12823,	247564.88607,	247569.64392,
247574.40178,	247579.15965,	247583.91752,	247588.67540,	247593.43329,	247598.19119,	247602.94909,	247607.70701,	247612.46493,	247617.22285,
247621.98079,	247626.73873,	247631.49668,	247636.25464,	247641.01260,	247645.77057,	247650.52856,	247655.28654,	247660.04454,	247664.80254,
247669.56055,	247674.31857,	247679.07660,	247683.83463,	247688.59267,	247693.35072,	247698.10877,	247702.86684,	247707.62491,	247712.38299,
247717.14107,	247721.89917,	247726.65727,	247731.41538,	247736.17350,	247740.93162,	247745.68975,	247750.44789,	247755.20604,	247759.96419,
247764.72236,	247769.48053,	247774.23870,	247778.99689,	247783.75508,	247788.51328,	247793.27149,	247798.02970,	247802.78793,	247807.54616,
247812.30439,	247817.06264,	247821.82089,	247826.57915,	247831.33742,	247836.09570,	247840.85398,	247845.61227,	247850.37057,	247855.12888,
247859.88719,	247864.64551,	247869.40384,	247874.16218,	247878.92052,	247883.67887,	247888.43723,	247893.19560,	247897.95397,	247902.71236,
247907.47075,	247912.22914,	247916.98755,	247921.74596,	247926.50438,	247931.26281,	247936.02124,	247940.77968,	247945.53813,	247950.29659,
247955.05506,	247959.81353,	247964.57201,	247969.33050,	247974.08899,	247978.84750,	247983.60601,	247988.36453,	247993.12305,	247997.88159,
248002.64013,	248007.39867,	248012.15723,	248016.91579,	248021.67437,	248026.43294,	248031.19153,	248035.95013,	248040.70873,	248045.46734,
248050.22595,	248054.98458,	248059.74321,	248064.50185,	248069.26050,	248074.01915,	248078.77781,	248083.53648,	248088.29516,	248093.05384,
248097.81254,	248102.57124,	248107.32994,	248112.08866,	248116.84738,	248121.60611,	248126.36485,	248131.12360,	248135.88235,	248140.64111,
248145.39988,	248150.15865,	248154.91744,	248159.67623,	248164.43503,	248169.19383,	248173.95264,	248178.71147,	248183.47029,	248188.22913,
248192.98797,	248197.74683,	248202.50568,	248207.26455,	248212.02343,	248216.78231,	248221.54120,	248226.30009,	248231.05900,	248235.81791,
248240.57683,	248245.33576,	248250.09469,	248254.85363,	248259.61258,	248264.37154,	248269.13050,	248273.88948,	248278.64846,	248283.40744,
248288.16644,	248292.92544,	248297.68445,	248302.44347,	248307.20250,	248311.96153,	248316.72057,	248321.47962,	248326.23867,	248330.99774,
248335.75681,	248340.51588,	248345.27497,	248350.03406,	248354.79316,	248359.55227,	248364.31139,	248369.07051,	248373.82964,	248378.58878,
248383.34793,	248388.10708,	248392.86625,	248397.62541,	248402.38459,	248407.14377,	248411.90297,	248416.66217,	248421.42137,	248426.18059,
248430.93981,	248435.69904,	248440.45828,	248445.21752,	248449.97677,	248454.73603,	248459.49530,	248464.25457,	248469.01386,	248473.77315,
248478.53245,	248483.29175,	248488.05106,	248492.81038,	248497.56971,	248502.32905,	248507.08839,	248511.84774,	248516.60710,	248521.36646,
248526.12584,	248530.88522,	248535.64461,	248540.40400,	248545.16341,	248549.92282,	248554.68223,	248559.44166,	248564.20109,	248568.96054,
248573.71998,	248578.47944,	248583.23890,	248587.99838,	248592.75785,	248597.51734,	248602.27684,	248607.03634,	248611.79585,	248616.55536,
248621.31489,	248626.07442,	248630.83396,	248635.59351,	248640.35306,	248645.11262,	248649.87219,	248654.63177,	248659.39135,	248664.15095,
248668.91055,	248673.67015,	248678.42977,	248683.18939,	248687.94902,	248692.70866,	248697.46830,	248702.22796,	248706.98762,	248711.74728,
248716.50696,	248721.26664,	248726.02633,	248730.78603,	248735.54574,	248740.30545,	248745.06517,	248749.82490,	248754.58464,	248759.34438,
248764.10413,	248768.86389,	248773.62365,	248778.38343,	248783.14321,	248787.90300,	248792.66279,	248797.42260,	248802.18241,	248806.94223,
248811.70205,	248816.46189,	248821.22173,	248825.98158,	248830.74144,	248835.50130,	248840.26117,	248845.02105,	248849.78094,	248854.54083,
248859.30073,	248864.06064,	248868.82056,	248873.58048,	248878.34042,	248883.10036,	248887.86030,	248892.62026,	248897.38022,	248902.14019,
248906.90017,	248911.66015,	248916.42015,	248921.18015,	248925.94015,	248930.70017,	248935.46019,	248940.22022,	248944.98026,	248949.74030,
248954.50036,	248959.26042,	248964.02049,	248968.78056,	248973.54064,	248978.30073,	248983.06083,	248987.82094,	248992.58105,	248997.34117,
249002.10130,	249006.86144,	249011.62158,	249016.38173,	249021.14189,	249025.90206,	249030.66223,	249035.42241,	249040.18260,	249044.94280,
249049.70300,	249054.46321,	249059.22343,	249063.98366,	249068.74389,	249073.50413,	249078.26438,	249083.02464,	249087.78490,	249092.54517,
249097.30545,	249102.06574,	249106.82603,	249111.58633,	249116.34664,	249121.10696,	249125.86729,	249130.62762,	249135.38796,	249140.14830,
249144.90866,	249149.66902,	249154.42939,	249159.18977,	249163.95015,	249168.71054,	249173.47094,	249178.23135,	249182.99177,	249187.75219,
249192.51262,	249197.27306,	249202.03350,	249206.79395,	249211.55441,	249216.31488,	249221.07536,	249225.83584,	249230.59633,	249235.35683,
249240.11733,	249244.87785,	249249.63837,	249254.39890,	249259.15943,	249263.91997,	249268.68053,	249273.44108,	249278.20165,	249282.96222,
249287.72280,	249292.48339,	249297.24399,	249302.00459,	249306.76520,	249311.52582,	249316.28645,	249321.04708,	249325.80772,	249330.56837,
249335.32903,	249340.08969,	249344.85036,	249349.61104,	249354.37173,	249359.13242,	249363.89312,	249368.65383,	249373.41455,	249378.17527,
249382.93600,	249387.69674,	249392.45749,	249397.21824,	249401.97900,	249406.73977,	249411.50055,	249416.26133,	249421.02212,	249425.78292,
249430.54373,	249435.30455,	249440.06537,	249444.82620,	249449.58703,	249454.34788,	249459.10873,	249463.86959,	249468.63046,	249473.39133,
249478.15221,	249482.91310,	249487.67400,	249492.43491,	249497.19582,	249501.95674,	249506.71766,	249511.47860,	249516.23954,	249521.00049,
249525.76145,	249530.52241,	249535.28339,	249540.04437,	249544.80535,	249549.56635,	249554.32735,	249559.08836,	249563.84938,	249568.61041,
249573.37144,	249578.13248,	249582.89353,	249587.65458,	249592.41564,	249597.17672,	249601.93779,	249606.69888,	249611.45997,	249616.22107,
249620.98218,	249625.74330,	249630.50442,	249635.26555,	249640.02669,	249644.78783,	249649.54899,	249654.31015,	249659.07132,	249663.83249,
249668.59368,	249673.35487,	249678.11606,	249682.87727,	249687.63848,	249692.39970,	249697.16093,	249701.92217,	249706.68341,	249711.44466,
249716.20592,	249720.96719,	249725.72846,	249730.48974,	249735.25103,	249740.01233,	249744.77363,	249749.53494,	249754.29626,	249759.05759,
249763.81892,	249768.58026,	249773.34161,	249778.10297,	249782.86433,	249787.62570,	249792.38708,	249797.14847,	249801.90986,	249806.67127,
249811.43267,	249816.19409,	249820.95552,	249825.71695,	249830.47839,	249835.23983,	249840.00129,	249844.76275,	249849.52422,	249854.28569,
249859.04718,	249863.80867,	249868.57017,	249873.33168,	249878.09319,	249882.85471,	249887.61624,	249892.37778,	249897.13932,	249901.90088,
249906.66244,	249911.42400,	249916.18558,	249920.94716,	249925.70875,	249930.47035,	249935.23195,	249939.99356,	249944.75518,	249949.51681,
249954.27844,	249959.04009,	249963.80174,	249968.56339,	249973.32506,	249978.08673,	249982.84841,	249987.61010,	249992.37179,	249997.13350,
250001.89520,	250006.65692,	250011.41865,	250016.18038,	250020.94212,	250025.70387,	250030.46562,	250035.22738,	250039.98915,	250044.75093,
250049.51272,	250054.27451,	250059.03631,	250063.79812,	250068.55993,	250073.32176,	250078.08359,	250082.84542,	250087.60727,	250092.36912,
250097.13098,	250101.89285,	250106.65472,	250111.41661,	250116.17850,	250120.94039,	250125.70230,	250130.46421,	250135.22613,	250139.98806,
250144.75000,	250149.51194,	250154.27389,	250159.03585,	250163.79781,	250168.55979,	250173.32177,	250178.08375,	250182.84575,	250187.60775,
250192.36976,	250197.13178,	250201.89381,	250206.65584,	250211.41788,	250216.17993,	250220.94198,	250225.70405,	250230.46612,	250235.22820,
250239.99028,	250244.75237,	250249.51447,	250254.27658,	250259.03870,	250263.80082,	250268.56295,	250273.32509,	250278.08724,	250282.84939,
250287.61155,	250292.37372,	250297.13589,	250301.89808,	250306.66027,	250311.42247,	250316.18467,	250320.94689,	250325.70911,	250330.47133,
250335.23357,	250339.99581,	250344.75806,	250349.52032,	250354.28259,	250359.04486,	250363.80714,	250368.56943,	250373.33173,	250378.09403,
250382.85634,	250387.61866,	250392.38099,	250397.14332,	250401.90566,	250406.66801,	250411.43036,	250416.19273,	250420.95510,	250425.71748,
250430.47986,	250435.24226,	250440.00466,	250444.76707,	250449.52948,	250454.29191,	250459.05434,	250463.81677,	250468.57922,	250473.34167,
250478.10413,	250482.86660,	250487.62908,	250492.39156,	250497.15405,	250501.91655,	250506.67906,	250511.44157,	250516.20409,	250520.96662,
250525.72916,	250530.49170,	250535.25425,	250540.01681,	250544.77938,	250549.54195,	250554.30453,	250559.06712,	250563.82972,	250568.59232,
250573.35493,	250578.11755,	250582.88018,	250587.64281,	250592.40545,	250597.16810,	250601.93075,	250606.69342,	250611.45609,	250616.21877,
250620.98145,	250625.74415,	250630.50685,	250635.26956,	250640.03227,	250644.79500,	250649.55773,	250654.32047,	250659.08321,	250663.84597,
250668.60873,	250673.37150,	250678.13427,	250682.89705,	250687.65985,	250692.42264,	250697.18545,	250701.94826,	250706.71109,	250711.47391,
250716.23675,	250720.99959,	250725.76244,	250730.52530,	250735.28817,	250740.05104,	250744.81392,	250749.57681,	250754.33971,	250759.10261,
250763.86552,	250768.62844,	250773.39137,	250778.15430,	250782.91724,	250787.68019,	250792.44315,	250797.20611,	250801.96908,	250806.73206,
250811.49505,	250816.25804,	250821.02104,	250825.78405,	250830.54706,	250835.31009,	250840.07312,	250844.83616,	250849.59920,	250854.36226,
250859.12532,	250863.88839,	250868.65146,	250873.41455,	250878.17764,	250882.94073,	250887.70384,	250892.46695,	250897.23007,	250901.99320,
250906.75634,	250911.51948,	250916.28263,	250921.04579,	250925.80896,	250930.57213,	250935.33531,	250940.09850,	250944.86170,	250949.62490,
250954.38811,	250959.15133,	250963.91455,	250968.67779,	250973.44103,	250978.20428,	250982.96753,	250987.73079,	250992.49407,	250997.25734,
251002.02063,	251006.78392,	251011.54722,	251016.31053,	251021.07385,	251025.83717,	251030.60050,	251035.36384,	251040.12718,	251044.89054,
251049.65390,	251054.41727,	251059.18064,	251063.94403,	251068.70742,	251073.47081,	251078.23422,	251082.99763,	251087.76105,	251092.52448,
251097.28792,	251102.05136,	251106.81481,	251111.57827,	251116.34173,	251121.10521,	251125.86869,	251130.63217,	251135.39567,	251140.15917,
251144.92268,	251149.68620,	251154.44973,	251159.21326,	251163.97680,	251168.74035,	251173.50390,	251178.26746,	251183.03104,	251187.79461,
251192.55820,	251197.32179,	251202.08539,	251206.84900,	251211.61261,	251216.37624,	251221.13987,	251225.90350,	251230.66715,	251235.43080,
251240.19446,	251244.95813,	251249.72180,	251254.48549,	251259.24918,	251264.01287,	251268.77658,	251273.54029,	251278.30401,	251283.06774,
251287.83147,	251292.59522,	251297.35897,	251302.12272,	251306.88649,	251311.65026,	251316.41404,	251321.17783,	251325.94162,	251330.70542,
251335.46923,	251340.23305,	251344.99688,	251349.76071,	251354.52455,	251359.28840,	251364.05225,	251368.81611,	251373.57998,	251378.34386,
251383.10774,	251387.87163,	251392.63553,	251397.39944,	251402.16336,	251406.92728,	251411.69121,	251416.45514,	251421.21909,	251425.98304,
251430.74700,	251435.51097,	251440.27494,	251445.03892,	251449.80291,	251454.56691,	251459.33091,	251464.09492,	251468.85894,	251473.62297,
251478.38700,	251483.15105,	251487.91509,	251492.67915,	251497.44321,	251502.20729,	251506.97137,	251511.73545,	251516.49955,	251521.26365,
251526.02776,	251530.79187,	251535.55600,	251540.32013,	251545.08427,	251549.84841,	251554.61257,	251559.37673,	251564.14090,	251568.90507,
251573.66926,	251578.43345,	251583.19765,	251587.96185,	251592.72606,	251597.49029,	251602.25451,	251607.01875,	251611.78299,	251616.54724,
251621.31150,	251626.07577,	251630.84004,	251635.60432,	251640.36861,	251645.13291,	251649.89721,	251654.66152,	251659.42584,	251664.19016,
251668.95450,	251673.71884,	251678.48319,	251683.24754,	251688.01190,	251692.77627,	251697.54065,	251702.30504,	251707.06943,	251711.83383,
251716.59824,	251721.36265,	251726.12708,	251730.89151,	251735.65594,	251740.42039,	251745.18484,	251749.94930,	251754.71377,	251759.47825,
251764.24273,	251769.00722,	251773.77172,	251778.53622,	251783.30073,	251788.06525,	251792.82978,	251797.59431,	251802.35886,	251807.12341,
251811.88796,	251816.65253,	251821.41710,	251826.18168,	251830.94627,	251835.71086,	251840.47546,	251845.24007,	251850.00469,	251854.76931,
251859.53395,	251864.29859,	251869.06323,	251873.82789,	251878.59255,	251883.35722,	251888.12189,	251892.88658,	251897.65127,	251902.41597,
251907.18068,	251911.94539,	251916.71011,	251921.47484,	251926.23958,	251931.00432,	251935.76907,	251940.53383,	251945.29860,	251950.06337,
251954.82815,	251959.59294,	251964.35774,	251969.12254,	251973.88735,	251978.65217,	251983.41700,	251988.18183,	251992.94667,	251997.71152,
252002.47637,	252007.24124,	252012.00611,	252016.77099,	252021.53587,	252026.30076,	252031.06567,	252035.83057,	252040.59549,	252045.36041,
252050.12534,	252054.89028,	252059.65523,	252064.42018,	252069.18514,	252073.95011,	252078.71508,	252083.48006,	252088.24505,	252093.01005,
252097.77506,	252102.54007,	252107.30509,	252112.07012,	252116.83515,	252121.60019,	252126.36524,	252131.13030,	252135.89537,	252140.66044,
252145.42552,	252150.19061,	252154.95570,	252159.72080,	252164.48591,	252169.25103,	252174.01615,	252178.78128,	252183.54642,	252188.31157,
252193.07672,	252197.84189,	252202.60706,	252207.37223,	252212.13742,	252216.90261,	252221.66781,	252226.43301,	252231.19823,	252235.96345,
252240.72868,	252245.49391,	252250.25916,	252255.02441,	252259.78967,	252264.55493,	252269.32021,	252274.08549,	252278.85078,	252283.61607,
252288.38138,	252293.14669,	252297.91201,	252302.67733,	252307.44266,	252312.20800,	252316.97335,	252321.73871,	252326.50407,	252331.26944,
252336.03482,	252340.80021,	252345.56560,	252350.33100,	252355.09641,	252359.86182,	252364.62724,	252369.39267,	252374.15811,	252378.92356,
252383.68901,	252388.45447,	252393.21994,	252397.98541,	252402.75089,	252407.51638,	252412.28188,	252417.04739,	252421.81290,	252426.57842,
252431.34394,	252436.10948,	252440.87502,	252445.64057,	252450.40613,	252455.17169,	252459.93726,	252464.70284,	252469.46843,	252474.23402,
252478.99962,	252483.76523,	252488.53085,	252493.29647,	252498.06210,	252502.82774,	252507.59339,	252512.35904,	252517.12470,	252521.89037,
252526.65605,	252531.42173,	252536.18742,	252540.95312,	252545.71883,	252550.48454,	252555.25026,	252560.01599,	252564.78172,	252569.54747,
252574.31322,	252579.07898,	252583.84474,	252588.61051,	252593.37629,	252598.14208,	252602.90788,	252607.67368,	252612.43949,	252617.20531,
252621.97113,	252626.73696,	252631.50280,	252636.26865,	252641.03451,	252645.80037,	252650.56624,	252655.33212,	252660.09800,	252664.86389,
252669.62979,	252674.39570,	252679.16161,	252683.92753,	252688.69346,	252693.45940,	252698.22534,	252702.99130,	252707.75726,	252712.52322,
252717.28920,	252722.05518,	252726.82117,	252731.58716,	252736.35317,	252741.11918,	252745.88519,	252750.65122,	252755.41725,	252760.18330,
252764.94934,	252769.71540,	252774.48146,	252779.24753,	252784.01361,	252788.77970,	252793.54579,	252798.31189,	252803.07800,	252807.84411,
252812.61024,	252817.37637,	252822.14250,	252826.90865,	252831.67480,	252836.44096,	252841.20713,	252845.97330,	252850.73949,	252855.50568,
252860.27187,	252865.03808,	252869.80429,	252874.57051,	252879.33674,	252884.10297,	252888.86921,	252893.63546,	252898.40172,	252903.16798,
252907.93425,	252912.70053,	252917.46682,	252922.23311,	252926.99941,	252931.76572,	252936.53204,	252941.29836,	252946.06469,	252950.83103,
252955.59738,	252960.36373,	252965.13009,	252969.89646,	252974.66284,	252979.42922,	252984.19561,	252988.96201,	252993.72841,	252998.49483,
253003.26125,	253008.02767,	253012.79411,	253017.56055,	253022.32700,	253027.09346,	253031.85992,	253036.62640,	253041.39288,	253046.15936,
253050.92586,	253055.69236,	253060.45887,	253065.22539,	253069.99191,	253074.75844,	253079.52498,	253084.29153,	253089.05808,	253093.82464,
253098.59121,	253103.35779,	253108.12437,	253112.89096,	253117.65756,	253122.42417,	253127.19078,	253131.95740,	253136.72403,	253141.49067,
253146.25731,	253151.02396,	253155.79062,	253160.55729,	253165.32396,	253170.09064,	253174.85733,	253179.62402,	253184.39073,	253189.15744,
253193.92415,	253198.69088,	253203.45761,	253208.22435,	253212.99110,	253217.75785,	253222.52462,	253227.29138,	253232.05816,	253236.82495,
253241.59174,	253246.35854,	253251.12534,	253255.89216,	253260.65898,	253265.42581,	253270.19265,	253274.95949,	253279.72634,	253284.49320,
253289.26007,	253294.02694,	253298.79382,	253303.56071,	253308.32761,	253313.09451,	253317.86142,	253322.62834,	253327.39526,	253332.16220,
253336.92914,	253341.69609,	253346.46304,	253351.23000,	253355.99697,	253360.76395,	253365.53094,	253370.29793,	253375.06493,	253379.83194,
253384.59895,	253389.36597,	253394.13300,	253398.90004,	253403.66708,	253408.43414,	253413.20120,	253417.96826,	253422.73534,	253427.50242,
253432.26951,	253437.03660,	253441.80371,	253446.57082,	253451.33794,	253456.10506,	253460.87220,	253465.63934,	253470.40649,	253475.17364,
253479.94081,	253484.70798,	253489.47516,	253494.24234,	253499.00953,	253503.77673,	253508.54394,	253513.31116,	253518.07838,	253522.84561,
253527.61285,	253532.38009,	253537.14734,	253541.91460,	253546.68187,	253551.44915,	253556.21643,	253560.98372,	253565.75101,	253570.51832,
253575.28563,	253580.05295,	253584.82028,	253589.58761,	253594.35495,	253599.12230,	253603.88966,	253608.65702,	253613.42439,	253618.19177,
253622.95916,	253627.72655,	253632.49395,	253637.26136,	253642.02877,	253646.79620,	253651.56363,	253656.33107,	253661.09851,	253665.86596,
253670.63342,	253675.40089,	253680.16837,	253684.93585,	253689.70334,	253694.47084,	253699.23834,	253704.00585,	253708.77337,	253713.54090,
253718.30843,	253723.07597,	253727.84352,	253732.61108,	253737.37864,	253742.14622,	253746.91379,	253751.68138,	253756.44897,	253761.21658,
253765.98418,	253770.75180,	253775.51942,	253780.28705,	253785.05469,	253789.82234,	253794.58999,	253799.35765,	253804.12532,	253808.89299,
253813.66068,	253818.42837,	253823.19606,	253827.96377,	253832.73148,	253837.49920,	253842.26693,	253847.03466,	253851.80241,	253856.57015,
253861.33791,	253866.10568,	253870.87345,	253875.64123,	253880.40901,	253885.17681,	253889.94461,	253894.71242,	253899.48023,	253904.24806,
253909.01589,	253913.78373,	253918.55157,	253923.31942,	253928.08728,	253932.85515,	253937.62303,	253942.39091,	253947.15880,	253951.92670,
253956.69460,	253961.46252,	253966.23044,	253970.99836,	253975.76630,	253980.53424,	253985.30219,	253990.07015,	253994.83811,	253999.60608,
254004.37406,	254009.14205,	254013.91004,	254018.67804,	254023.44605,	254028.21407,	254032.98209,	254037.75012,	254042.51816,	254047.28621,
254052.05426,	254056.82232,	254061.59039,	254066.35846,	254071.12655,	254075.89464,	254080.66274,	254085.43084,	254090.19895,	254094.96707,
254099.73520,	254104.50333,	254109.27148,	254114.03963,	254118.80778,	254123.57595,	254128.34412,	254133.11230,	254137.88048,	254142.64868,
254147.41688,	254152.18509,	254156.95331,	254161.72153,	254166.48976,	254171.25800,	254176.02624,	254180.79450,	254185.56276,	254190.33103,
254195.09930,	254199.86758,	254204.63587,	254209.40417,	254214.17248,	254218.94079,	254223.70911,	254228.47744,	254233.24577,	254238.01411,
254242.78246,	254247.55082,	254252.31918,	254257.08756,	254261.85593,	254266.62432,	254271.39271,	254276.16112,	254280.92952,	254285.69794,
254290.46636,	254295.23480,	254300.00323,	254304.77168,	254309.54013,	254314.30859,	254319.07706,	254323.84554,	254328.61402,	254333.38251,
254338.15101,	254342.91951,	254347.68802,	254352.45654,	254357.22507,	254361.99361,	254366.76215,	254371.53070,	254376.29925,	254381.06782,
254385.83639,	254390.60497,	254395.37355,	254400.14215,	254404.91075,	254409.67936,	254414.44797,	254419.21660,	254423.98523,	254428.75387,
254433.52251,	254438.29116,	254443.05982,	254447.82849,	254452.59717,	254457.36585,	254462.13454,	254466.90324,	254471.67194,	254476.44065,
254481.20937,	254485.97810,	254490.74683,	254495.51558,	254500.28432,	254505.05308,	254509.82184,	254514.59062,	254519.35939,	254524.12818,
254528.89697,	254533.66577,	254538.43458,	254543.20340,	254547.97222,	254552.74105,	254557.50989,	254562.27874,	254567.04759,	254571.81645,
254576.58532,	254581.35419,	254586.12307,	254590.89196,	254595.66086,	254600.42976,	254605.19867,	254609.96759,	254614.73652,	254619.50545,
254624.27440,	254629.04334,	254633.81230,	254638.58126,	254643.35024,	254648.11921,	254652.88820,	254657.65719,	254662.42619,	254667.19520,
254671.96422,	254676.73324,	254681.50227,	254686.27131,	254691.04035,	254695.80940,	254700.57846,	254705.34753,	254710.11660,	254714.88569,
254719.65478,	254724.42387,	254729.19298,	254733.96209,	254738.73121,	254743.50033,	254748.26947,	254753.03861,	254757.80775,	254762.57691,
254767.34607,	254772.11524,	254776.88442,	254781.65361,	254786.42280,	254791.19200,	254795.96121,	254800.73042,	254805.49964,	254810.26887,
254815.03811,	254819.80735,	254824.57661,	254829.34587,	254834.11513,	254838.88441,	254843.65369,	254848.42298,	254853.19227,	254857.96158,
254862.73089,	254867.50020,	254872.26953,	254877.03886,	254881.80820,	254886.57755,	254891.34691,	254896.11627,	254900.88564,	254905.65502,
254910.42440,	254915.19379,	254919.96319,	254924.73260,	254929.50201,	254934.27144,	254939.04086,	254943.81030,	254948.57974,	254953.34920,
254958.11865,	254962.88812,	254967.65759,	254972.42707,	254977.19656,	254981.96606,	254986.73556,	254991.50507,	254996.27459,	255001.04411,
255005.81365,	255010.58319,	255015.35273,	255020.12229,	255024.89185,	255029.66142,	255034.43100,	255039.20058,	255043.97017,	255048.73977,
255053.50938,	255058.27899,	255063.04861,	255067.81824,	255072.58788,	255077.35752,	255082.12717,	255086.89683,	255091.66649,	255096.43616,
255101.20584,	255105.97553,	255110.74523,	255115.51493,	255120.28464,	255125.05436,	255129.82408,	255134.59381,	255139.36355,	255144.13330,
255148.90305,	255153.67281,	255158.44258,	255163.21236,	255167.98214,	255172.75193,	255177.52173,	255182.29153,	255187.06135,	255191.83117,
255196.60100,	255201.37083,	255206.14067,	255210.91052,	255215.68038,	255220.45024,	255225.22012,	255229.99000,	255234.75988,	255239.52978,
255244.29968,	255249.06959,	255253.83950,	255258.60943,	255263.37936,	255268.14930,	255272.91924,	255277.68919,	255282.45915,	255287.22912,
255291.99910,	255296.76908,	255301.53907,	255306.30907,	255311.07907,	255315.84908,	255320.61910,	255325.38913,	255330.15916,	255334.92921,
255339.69925,	255344.46931,	255349.23937,	255354.00945,	255358.77952,	255363.54961,	255368.31970,	255373.08980,	255377.85991,	255382.63003,
255387.40015,	255392.17028,	255396.94042,	255401.71056,	255406.48071,	255411.25087,	255416.02104,	255420.79121,	255425.56140,	255430.33159,
255435.10178,	255439.87199,	255444.64220,	255449.41242,	255454.18264,	255458.95287,	255463.72312,	255468.49336,	255473.26362,	255478.03388,
255482.80415,	255487.57443,	255492.34471,	255497.11501,	255501.88531,	255506.65561,	255511.42593,	255516.19625,	255520.96658,	255525.73691,
255530.50726,	255535.27761,	255540.04797,	255544.81833,	255549.58871,	255554.35909,	255559.12948,	255563.89987,	255568.67027,	255573.44068,
255578.21110,	255582.98153,	255587.75196,	255592.52240,	255597.29284,	255602.06330,	255606.83376,	255611.60423,	255616.37471,	255621.14519,
255625.91568,	255630.68618,	255635.45669,	255640.22720,	255644.99772,	255649.76825,	255654.53878,	255659.30933,	255664.07988,	255668.85043,
255673.62100,	255678.39157,	255683.16215,	255687.93274,	255692.70333,	255697.47393,	255702.24454,	255707.01516,	255711.78578,	255716.55641,
255721.32705,	255726.09770,	255730.86835,	255735.63901,	255740.40968,	255745.18035,	255749.95104,	255754.72173,	255759.49242,	255764.26313,
255769.03384,	255773.80456,	255778.57529,	255783.34602,	255788.11676,	255792.88751,	255797.65827,	255802.42903,	255807.19980,	255811.97058,
255816.74137,	255821.51216,	255826.28296,	255831.05377,	255835.82458,	255840.59541,	255845.36624,	255850.13707,	255854.90792,	255859.67877,
255864.44963,	255869.22050,	255873.99137,	255878.76225,	255883.53314,	255888.30404,	255893.07494,	255897.84585,	255902.61677,	255907.38770,
255912.15863,	255916.92957,	255921.70052,	255926.47147,	255931.24243,	255936.01340,	255940.78438,	255945.55537,	255950.32636,	255955.09736,
255959.86836,	255964.63938,	255969.41040,	255974.18143,	255978.95246,	255983.72351,	255988.49456,	255993.26562,	255998.03668,	256002.80775,
256007.57883,	256012.34992,	256017.12102,	256021.89212,	256026.66323,	256031.43434,	256036.20547,	256040.97660,	256045.74774,	256050.51889,
256055.29004,	256060.06120,	256064.83237,	256069.60355,	256074.37473,	256079.14592,	256083.91712,	256088.68832,	256093.45953,	256098.23075,
256103.00198,	256107.77322,	256112.54446,	256117.31571,	256122.08696,	256126.85823,	256131.62950,	256136.40078,	256141.17206,	256145.94336,
256150.71466,	256155.48597,	256160.25728,	256165.02861,	256169.79994,	256174.57127,	256179.34262,	256184.11397,	256188.88533,	256193.65670,
256198.42807,	256203.19945,	256207.97084,	256212.74224,	256217.51364,	256222.28505,	256227.05647,	256231.82790,	256236.59933,	256241.37077,
256246.14222,	256250.91367,	256255.68514,	256260.45661,	256265.22808,	256269.99957,	256274.77106,	256279.54256,	256284.31407,	256289.08558,
256293.85710,	256298.62863,	256303.40017,	256308.17171,	256312.94326,	256317.71482,	256322.48638,	256327.25796,	256332.02954,	256336.80112,
256341.57272,	256346.34432,	256351.11593,	256355.88755,	256360.65917,	256365.43080,	256370.20244,	256374.97409,	256379.74574,	256384.51740,
256389.28907,	256394.06075,	256398.83243,	256403.60412,	256408.37582,	256413.14752,	256417.91924,	256422.69095,	256427.46268,	256432.23442,
256437.00616,	256441.77791,	256446.54966,	256451.32143,	256456.09320,	256460.86498,	256465.63676,	256470.40856,	256475.18036,	256479.95216,
256484.72398,	256489.49580,	256494.26763,	256499.03947,	256503.81131,	256508.58317,	256513.35503,	256518.12689,	256522.89877,	256527.67065,
256532.44254,	256537.21443,	256541.98634,	256546.75825,	256551.53016,	256556.30209,	256561.07402,	256565.84596,	256570.61791,	256575.38986,
256580.16183,	256584.93380,	256589.70577,	256594.47776,	256599.24975,	256604.02175,	256608.79375,	256613.56577,	256618.33779,	256623.10982,
256627.88185,	256632.65389,	256637.42594,	256642.19800,	256646.97007,	256651.74214,	256656.51422,	256661.28631,	256666.05840,	256670.83050,
256675.60261,	256680.37473,	256685.14685,	256689.91898,	256694.69112,	256699.46326,	256704.23542,	256709.00758,	256713.77975,	256718.55192,
256723.32410,	256728.09629,	256732.86849,	256737.64069,	256742.41291,	256747.18512,	256751.95735,	256756.72958,	256761.50183,	256766.27407,
256771.04633,	256775.81859,	256780.59086,	256785.36314,	256790.13543,	256794.90772,	256799.68002,	256804.45232,	256809.22464,	256813.99696,
256818.76929,	256823.54163,	256828.31397,	256833.08632,	256837.85868,	256842.63105,	256847.40342,	256852.17580,	256856.94819,	256861.72058,
256866.49298,	256871.26539,	256876.03781,	256880.81023,	256885.58267,	256890.35511,	256895.12755,	256899.90001,	256904.67247,	256909.44494,
256914.21741,	256918.98989,	256923.76238,	256928.53488,	256933.30739,	256938.07990,	256942.85242,	256947.62495,	256952.39748,	256957.17002,
256961.94257,	256966.71513,	256971.48769,	256976.26026,	256981.03284,	256985.80543,	256990.57802,	256995.35062,	257000.12323,	257004.89584,
257009.66847,	257014.44110,	257019.21373,	257023.98638,	257028.75903,	257033.53169,	257038.30435,	257043.07703,	257047.84971,	257052.62240,
257057.39509,	257062.16780,	257066.94051,	257071.71322,	257076.48595,	257081.25868,	257086.03142,	257090.80417,	257095.57692,	257100.34968,
257105.12245,	257109.89523,	257114.66801,	257119.44080,	257124.21360,	257128.98641,	257133.75922,	257138.53204,	257143.30487,	257148.07770,
257152.85055,	257157.62339,	257162.39625,	257167.16912,	257171.94199,	257176.71487,	257181.48775,	257186.26065,	257191.03355,	257195.80646,
257200.57937,	257205.35229,	257210.12522,	257214.89816,	257219.67111,	257224.44406,	257229.21702,	257233.98998,	257238.76296,	257243.53594,
257248.30893,	257253.08193,	257257.85493,	257262.62794,	257267.40096,	257272.17398,	257276.94702,	257281.72006,	257286.49310,	257291.26616,
257296.03922,	257300.81229,	257305.58537,	257310.35845,	257315.13154,	257319.90464,	257324.67775,	257329.45086,	257334.22398,	257338.99711,
257343.77024,	257348.54339,	257353.31653,	257358.08969,	257362.86286,	257367.63603,	257372.40921,	257377.18239,	257381.95559,	257386.72879,
257391.50200,	257396.27521,	257401.04844,	257405.82167,	257410.59490,	257415.36815,	257420.14140,	257424.91466,	257429.68793,	257434.46120,
257439.23448,	257444.00777,	257448.78107,	257453.55437,	257458.32768,	257463.10100,	257467.87433,	257472.64766,	257477.42100,	257482.19435,
257486.96770,	257491.74107,	257496.51444,	257501.28781,	257506.06120,	257510.83459,	257515.60799,	257520.38139,	257525.15481,	257529.92823,
257534.70166,	257539.47509,	257544.24853,	257549.02198,	257553.79544,	257558.56891,	257563.34238,	257568.11586,	257572.88934,	257577.66284,
257582.43634,	257587.20985,	257591.98336,	257596.75689,	257601.53042,	257606.30395,	257611.07750,	257615.85105,	257620.62461,	257625.39818,
257630.17175,	257634.94533,	257639.71892,	257644.49252,	257649.26612,	257654.03973,	257658.81335,	257663.58698,	257668.36061,	257673.13425,
257677.90790,	257682.68155,	257687.45522,	257692.22888,	257697.00256,	257701.77625,	257706.54994,	257711.32364,	257716.09734,	257720.87106,
257725.64478,	257730.41850,	257735.19224,	257739.96598,	257744.73973,	257749.51349,	257754.28725,	257759.06103,	257763.83480,	257768.60859,
257773.38238,	257778.15619,	257782.92999,	257787.70381,	257792.47763,	257797.25146,	257802.02530,	257806.79915,	257811.57300,	257816.34686,
257821.12072,	257825.89460,	257830.66848,	257835.44237,	257840.21626,	257844.99017,	257849.76408,	257854.53800,	257859.31192,	257864.08585,
257868.85979,	257873.63374,	257878.40770,	257883.18166,	257887.95563,	257892.72960,	257897.50359,	257902.27758,	257907.05158,	257911.82558,
257916.59960,	257921.37362,	257926.14764,	257930.92168,	257935.69572,	257940.46977,	257945.24383,	257950.01789,	257954.79196,	257959.56604,
257964.34013,	257969.11422,	257973.88832,	257978.66243,	257983.43655,	257988.21067,	257992.98480,	257997.75894,	258002.53308,	258007.30723,
258012.08139,	258016.85556,	258021.62973,	258026.40391,	258031.17810,	258035.95230,	258040.72650,	258045.50071,	258050.27493,	258055.04915,
258059.82338,	258064.59762,	258069.37187,	258074.14613,	258078.92039,	258083.69466,	258088.46893,	258093.24321,	258098.01751,	258102.79180,
258107.56611,	258112.34042,	258117.11474,	258121.88907,	258126.66340,	258131.43774,	258136.21209,	258140.98645,	258145.76081,	258150.53518,
258155.30956,	258160.08395,	258164.85834,	258169.63274,	258174.40715,	258179.18156,	258183.95599,	258188.73041,	258193.50485,	258198.27930,
258203.05375,	258207.82821,	258212.60267,	258217.37714,	258222.15162,	258226.92611,	258231.70061,	258236.47511,	258241.24962,	258246.02414,
258250.79866,	258255.57319,	258260.34773,	258265.12228,	258269.89683,	258274.67139,	258279.44596,	258284.22054,	258288.99512,	258293.76971,
258298.54430,	258303.31891,	258308.09352,	258312.86814,	258317.64277,	258322.41740,	258327.19204,	258331.96669,	258336.74135,	258341.51601,
258346.29068,	258351.06536,	258355.84004,	258360.61473,	258365.38943,	258370.16414,	258374.93885,	258379.71357,	258384.48830,	258389.26304,
258394.03778,	258398.81253,	258403.58729,	258408.36206,	258413.13683,	258417.91161,	258422.68639,	258427.46119,	258432.23599,	258437.01080,
258441.78562,	258446.56044,	258451.33527,	258456.11011,	258460.88495,	258465.65981,	258470.43467,	258475.20953,	258479.98441,	258484.75929,
258489.53418,	258494.30907,	258499.08398,	258503.85889,	258508.63381,	258513.40873,	258518.18367,	258522.95861,	258527.73355,	258532.50851,
258537.28347,	258542.05844,	258546.83342,	258551.60840,	258556.38339,	258561.15839,	258565.93339,	258570.70841,	258575.48343,	258580.25846,
258585.03349,	258589.80853,	258594.58358,	258599.35864,	258604.13370,	258608.90877,	258613.68385,	258618.45894,	258623.23403,	258628.00913,
258632.78424,	258637.55936,	258642.33448,	258647.10961,	258651.88474,	258656.65989,	258661.43504,	258666.21020,	258670.98536,	258675.76054,
258680.53572,	258685.31091,	258690.08610,	258694.86130,	258699.63651,	258704.41173,	258709.18696,	258713.96219,	258718.73743,	258723.51267,
258728.28793,	258733.06319,	258737.83846,	258742.61373,	258747.38901,	258752.16430,	258756.93960,	258761.71491,	258766.49022,	258771.26554,
258776.04086,	258780.81620,	258785.59154,	258790.36689,	258795.14224,	258799.91760,	258804.69297,	258809.46835,	258814.24374,	258819.01913,
258823.79453,	258828.56993,	258833.34535,	258838.12077,	258842.89620,	258847.67163,	258852.44708,	258857.22253,	258861.99798,	258866.77345,
258871.54892,	258876.32440,	258881.09989,	258885.87538,	258890.65088,	258895.42639,	258900.20191,	258904.97743,	258909.75296,	258914.52850,
258919.30404,	258924.07959,	258928.85515,	258933.63072,	258938.40629,	258943.18188,	258947.95746,	258952.73306,	258957.50866,	258962.28427,
258967.05989,	258971.83552,	258976.61115,	258981.38679,	258986.16244,	258990.93809,	258995.71375,	259000.48942,	259005.26510,	259010.04078,
259014.81647,	259019.59217,	259024.36787,	259029.14358,	259033.91930,	259038.69503,	259043.47077,	259048.24651,	259053.02226,	259057.79801,
259062.57377,	259067.34955,	259072.12532,	259076.90111,	259081.67690,	259086.45270,	259091.22851,	259096.00432,	259100.78014,	259105.55597,
259110.33181,	259115.10765,	259119.88350,	259124.65936,	259129.43523,	259134.21110,	259138.98698,	259143.76286,	259148.53876,	259153.31466,
259158.09057,	259162.86649,	259167.64241,	259172.41834,	259177.19428,	259181.97022,	259186.74618,	259191.52214,	259196.29810,	259201.07408,
259205.85006,	259210.62605,	259215.40204,	259220.17805,	259224.95406,	259229.73008,	259234.50610,	259239.28213,	259244.05817,	259248.83422,
259253.61027,	259258.38634,	259263.16240,	259267.93848,	259272.71456,	259277.49066,	259282.26675,	259287.04286,	259291.81897,	259296.59509,
259301.37122,	259306.14735,	259310.92349,	259315.69964,	259320.47580,	259325.25196,	259330.02813,	259334.80431,	259339.58050,	259344.35669,
259349.13289,	259353.90910,	259358.68531,	259363.46153,	259368.23776,	259373.01400,	259377.79024,	259382.56649,	259387.34275,	259392.11901,
259396.89529,	259401.67157,	259406.44785,	259411.22415,	259416.00045,	259420.77676,	259425.55307,	259430.32940,	259435.10573,	259439.88207,
259444.65841,	259449.43476,	259454.21112,	259458.98749,	259463.76386,	259468.54025,	259473.31663,	259478.09303,	259482.86943,	259487.64584,
259492.42226,	259497.19869,	259501.97512,	259506.75156,	259511.52801,	259516.30446,	259521.08092,	259525.85739,	259530.63387,	259535.41035,
259540.18684,	259544.96334,	259549.73984,	259554.51636,	259559.29288,	259564.06940,	259568.84594,	259573.62248,	259578.39903,	259583.17558,
259587.95215,	259592.72872,	259597.50529,	259602.28188,	259607.05847,	259611.83507,	259616.61168,	259621.38829,	259626.16491,	259630.94154,
259635.71818,	259640.49482,	259645.27147,	259650.04813,	259654.82479,	259659.60146,	259664.37814,	259669.15483,	259673.93152,	259678.70823,
259683.48493,	259688.26165,	259693.03837,	259697.81510,	259702.59184,	259707.36859,	259712.14534,	259716.92210,	259721.69886,	259726.47564,
259731.25242,	259736.02921,	259740.80600,	259745.58280,	259750.35962,	259755.13643,	259759.91326,	259764.69009,	259769.46693,	259774.24377,
259779.02063,	259783.79749,	259788.57436,	259793.35123,	259798.12812,	259802.90501,	259807.68190,	259812.45881,	259817.23572,	259822.01264,
259826.78956,	259831.56650,	259836.34344,	259841.12039,	259845.89734,	259850.67430,	259855.45127,	259860.22825,	259865.00524,	259869.78223,
259874.55923,	259879.33623,	259884.11325,	259888.89027,	259893.66729,	259898.44433,	259903.22137,	259907.99842,	259912.77548,	259917.55254,
259922.32961,	259927.10669,	259931.88378,	259936.66087,	259941.43797,	259946.21508,	259950.99219,	259955.76932,	259960.54645,	259965.32358,
259970.10073,	259974.87788,	259979.65504,	259984.43220,	259989.20938,	259993.98656,	259998.76374,	260003.54094,	260008.31814,	260013.09535,
260017.87257,	260022.64979,	260027.42702,	260032.20426,	260036.98150,	260041.75876,	260046.53602,	260051.31328,	260056.09056,	260060.86784,
260065.64513,	260070.42243,	260075.19973,	260079.97704,	260084.75436,	260089.53168,	260094.30902,	260099.08636,	260103.86370,	260108.64106,
260113.41842,	260118.19579,	260122.97316,	260127.75055,	260132.52794,	260137.30534,	260142.08274,	260146.86015,	260151.63757,	260156.41500,
260161.19243,	260165.96987,	260170.74732,	260175.52478,	260180.30224,	260185.07971,	260189.85719,	260194.63467,	260199.41217,	260204.18967,
260208.96717,	260213.74469,	260218.52221,	260223.29974,	260228.07727,	260232.85481,	260237.63236,	260242.40992,	260247.18749,	260251.96506,
260256.74264,	260261.52022,	260266.29782,	260271.07542,	260275.85303,	260280.63064,	260285.40826,	260290.18589,	260294.96353,	260299.74117,
260304.51883,	260309.29648,	260314.07415,	260318.85182,	260323.62950,	260328.40719,	260333.18489,	260337.96259,	260342.74030,	260347.51802,
260352.29574,	260357.07347,	260361.85121,	260366.62896,	260371.40671,	260376.18447,	260380.96224,	260385.74001,	260390.51779,	260395.29558,
260400.07338,	260404.85118,	260409.62899,	260414.40681,	260419.18464,	260423.96247,	260428.74031,	260433.51816,	260438.29601,	260443.07387,
260447.85174,	260452.62962,	260457.40750,	260462.18539,	260466.96329,	260471.74119,	260476.51911,	260481.29703,	260486.07495,	260490.85289,
260495.63083,	260500.40878,	260505.18673,	260509.96470,	260514.74267,	260519.52064,	260524.29863,	260529.07662,	260533.85462,	260538.63263,
260543.41064,	260548.18866,	260552.96669,	260557.74472,	260562.52277,	260567.30082,	260572.07887,	260576.85694,	260581.63501,	260586.41309,
260591.19117,	260595.96927,	260600.74737,	260605.52548,	260610.30359,	260615.08171,	260619.85984,	260624.63798,	260629.41612,	260634.19427,
260638.97243,	260643.75060,	260648.52877,	260653.30695,	260658.08514,	260662.86333,	260667.64154,	260672.41975,	260677.19796,	260681.97619,
260686.75442,	260691.53265,	260696.31090,	260701.08915,	260705.86741,	260710.64568,	260715.42395,	260720.20224,	260724.98052,	260729.75882,
260734.53712,	260739.31543,	260744.09375,	260748.87208,	260753.65041,	260758.42875,	260763.20709,	260767.98545,	260772.76381,	260777.54218,
260782.32055,	260787.09894,	260791.87733,	260796.65572,	260801.43413,	260806.21254,	260810.99096,	260815.76938,	260820.54782,	260825.32626,
260830.10471,	260834.88316,	260839.66162,	260844.44009,	260849.21857,	260853.99706,	260858.77555,	260863.55404,	260868.33255,	260873.11106,
260877.88958,	260882.66811,	260887.44665,	260892.22519,	260897.00374,	260901.78229,	260906.56086,	260911.33943,	260916.11801,	260920.89659,
260925.67518,	260930.45378,	260935.23239,	260940.01101,	260944.78963,	260949.56826,	260954.34689,	260959.12553,	260963.90418,	260968.68284,
260973.46151,	260978.24018,	260983.01886,	260987.79755,	260992.57624,	260997.35494,	261002.13365,	261006.91236,	261011.69109,	261016.46982,
261021.24855,	261026.02730,	261030.80605,	261035.58481,	261040.36357,	261045.14235,	261049.92113,	261054.69992,	261059.47871,	261064.25751,
261069.03632,	261073.81514,	261078.59396,	261083.37279,	261088.15163,	261092.93048,	261097.70933,	261102.48819,	261107.26706,	261112.04593,
261116.82481,	261121.60370,	261126.38260,	261131.16150,	261135.94041,	261140.71933,	261145.49826,	261150.27719,	261155.05613,	261159.83507,
261164.61403,	261169.39299,	261174.17196,	261178.95093,	261183.72992,	261188.50891,	261193.28790,	261198.06691,	261202.84592,	261207.62494,
261212.40397,	261217.18300,	261221.96204,	261226.74109,	261231.52014,	261236.29921,	261241.07827,	261245.85735,	261250.63644,	261255.41553,
261260.19462,	261264.97373,	261269.75284,	261274.53196,	261279.31109,	261284.09023,	261288.86937,	261293.64852,	261298.42767,	261303.20684,
261307.98601,	261312.76518,	261317.54437,	261322.32356,	261327.10276,	261331.88197,	261336.66118,	261341.44040,	261346.21963,	261350.99887,
261355.77811,	261360.55736,	261365.33662,	261370.11588,	261374.89515,	261379.67443,	261384.45372,	261389.23301,	261394.01231,	261398.79162,
261403.57094,	261408.35026,	261413.12959,	261417.90892,	261422.68827,	261427.46762,	261432.24698,	261437.02634,	261441.80572,	261446.58510,
261451.36448,	261456.14388,	261460.92328,	261465.70269,	261470.48210,	261475.26153,	261480.04096,	261484.82040,	261489.59984,	261494.37929,
261499.15875,	261503.93822,	261508.71769,	261513.49717,	261518.27666,	261523.05616,	261527.83566,	261532.61517,	261537.39469,	261542.17421,
261546.95374,	261551.73328,	261556.51283,	261561.29238,	261566.07194,	261570.85151,	261575.63108,	261580.41067,	261585.19026,	261589.96985,
261594.74946,	261599.52907,	261604.30868,	261609.08831,	261613.86794,	261618.64758,	261623.42723,	261628.20688,	261632.98654,	261637.76621,
261642.54589,	261647.32557,	261652.10526,	261656.88496,	261661.66466,	261666.44438,	261671.22410,	261676.00382,	261680.78356,	261685.56330,
261690.34304,	261695.12280,	261699.90256,	261704.68233,	261709.46211,	261714.24189,	261719.02168,	261723.80148,	261728.58129,	261733.36110,
261738.14092,	261742.92075,	261747.70058,	261752.48042,	261757.26027,	261762.04013,	261766.81999,	261771.59986,	261776.37974,	261781.15963,
261785.93952,	261790.71942,	261795.49932,	261800.27924,	261805.05916,	261809.83909,	261814.61902,	261819.39897,	261824.17891,	261828.95887,
261833.73884,	261838.51881,	261843.29879,	261848.07877,	261852.85877,	261857.63877,	261862.41877,	261867.19879,	261871.97881,	261876.75884,
261881.53888,	261886.31892,	261891.09897,	261895.87903,	261900.65909,	261905.43917,	261910.21924,	261914.99933,	261919.77943,	261924.55953,
261929.33963,	261934.11975,	261938.89987,	261943.68000,	261948.46014,	261953.24029,	261958.02044,	261962.80060,	261967.58076,	261972.36093,
261977.14112,	261981.92130,	261986.70150,	261991.48170,	261996.26191,	262001.04213,	262005.82235,	262010.60258,	262015.38282,	262020.16306,
262024.94332,	262029.72358,	262034.50384,	262039.28412,	262044.06440,	262048.84469,	262053.62498,	262058.40529,	262063.18560,	262067.96591,
262072.74624,	262077.52657,	262082.30691,	262087.08725,	262091.86761,	262096.64797,	262101.42834,	262106.20871,	262110.98909,	262115.76948,
262120.54988,	262125.33028,	262130.11069,	262134.89111,	262139.67154,	262144.45197,	262149.23241,	262154.01286,	262158.79331,	262163.57377,
262168.35424,	262173.13472,	262177.91520,	262182.69569,	262187.47619,	262192.25669,	262197.03720,	262201.81772,	262206.59825,	262211.37878,
262216.15932,	262220.93987,	262225.72042,	262230.50099,	262235.28155,	262240.06213,	262244.84272,	262249.62331,	262254.40390,	262259.18451,
262263.96512,	262268.74574,	262273.52637,	262278.30700,	262283.08764,	262287.86829,	262292.64895,	262297.42961,	262302.21028,	262306.99096,
262311.77164,	262316.55233,	262321.33303,	262326.11374,	262330.89445,	262335.67517,	262340.45590,	262345.23664,	262350.01738,	262354.79813,
262359.57888,	262364.35965,	262369.14042,	262373.92120,	262378.70198,	262383.48277,	262388.26357,	262393.04438,	262397.82519,	262402.60601,
262407.38684,	262412.16768,	262416.94852,	262421.72937,	262426.51023,	262431.29109,	262436.07196,	262440.85284,	262445.63373,	262450.41462,
262455.19552,	262459.97643,	262464.75734,	262469.53827,	262474.31920,	262479.10013,	262483.88108,	262488.66203,	262493.44298,	262498.22395,
262503.00492,	262507.78590,	262512.56689,	262517.34788,	262522.12888,	262526.90989,	262531.69091,	262536.47193,	262541.25296,	262546.03399,
262550.81504,	262555.59609,	262560.37715,	262565.15821,	262569.93929,	262574.72037,	262579.50145,	262584.28255,	262589.06365,	262593.84476,
262598.62588,	262603.40700,	262608.18813,	262612.96927,	262617.75041,	262622.53156,	262627.31272,	262632.09389,	262636.87506,	262641.65624,
262646.43743,	262651.21863,	262655.99983,	262660.78104,	262665.56225,	262670.34348,	262675.12471,	262679.90595,	262684.68719,	262689.46845,
262694.24971,	262699.03097,	262703.81225,	262708.59353,	262713.37482,	262718.15611,	262722.93742,	262727.71873,	262732.50004,	262737.28137,
262742.06270,	262746.84404,	262751.62538,	262756.40674,	262761.18810,	262765.96946,	262770.75084,	262775.53222,	262780.31361,	262785.09501,
262789.87641,	262794.65782,	262799.43924,	262804.22066,	262809.00210,	262813.78354,	262818.56498,	262823.34644,	262828.12790,	262832.90936,
262837.69084,	262842.47232,	262847.25381,	262852.03531,	262856.81681,	262861.59832,	262866.37984,	262871.16137,	262875.94290,	262880.72444,
262885.50599,	262890.28754,	262895.06910,	262899.85067,	262904.63225,	262909.41383,	262914.19542,	262918.97702,	262923.75862,	262928.54024,
262933.32186,	262938.10348,	262942.88511,	262947.66676,	262952.44840,	262957.23006,	262962.01172,	262966.79339,	262971.57507,	262976.35675,
262981.13844,	262985.92014,	262990.70184,	262995.48355,	263000.26527,	263005.04700,	263009.82873,	263014.61048,	263019.39222,	263024.17398,
263028.95574,	263033.73751,	263038.51929,	263043.30107,	263048.08286,	263052.86466,	263057.64647,	263062.42828,	263067.21010,	263071.99193,
263076.77376,	263081.55560,	263086.33745,	263091.11931,	263095.90117,	263100.68304,	263105.46492,	263110.24680,	263115.02870,	263119.81059,
263124.59250,	263129.37441,	263134.15633,	263138.93826,	263143.72020,	263148.50214,	263153.28409,	263158.06604,	263162.84801,	263167.62998,
263172.41196,	263177.19394,	263181.97593,	263186.75793,	263191.53994,	263196.32195,	263201.10397,	263205.88600,	263210.66804,	263215.45008,
263220.23213,	263225.01419,	263229.79625,	263234.57832,	263239.36040,	263244.14248,	263248.92458,	263253.70668,	263258.48878,	263263.27090,
263268.05302,	263272.83515,	263277.61728,	263282.39943,	263287.18158,	263291.96373,	263296.74590,	263301.52807,	263306.31025,	263311.09243,
263315.87463,	263320.65683,	263325.43903,	263330.22125,	263335.00347,	263339.78570,	263344.56794,	263349.35018,	263354.13243,	263358.91469,
263363.69695,	263368.47922,	263373.26150,	263378.04379,	263382.82608,	263387.60838,	263392.39069,	263397.17301,	263401.95533,	263406.73766,
263411.51999,	263416.30234,	263421.08469,	263425.86705,	263430.64941,	263435.43178,	263440.21416,	263444.99655,	263449.77894,	263454.56134,
263459.34375,	263464.12617,	263468.90859,	263473.69102,	263478.47346,	263483.25590,	263488.03835,	263492.82081,	263497.60328,	263502.38575,
263507.16823,	263511.95071,	263516.73321,	263521.51571,	263526.29822,	263531.08073,	263535.86326,	263540.64579,	263545.42832,	263550.21087,
263554.99342,	263559.77598,	263564.55854,	263569.34112,	263574.12370,	263578.90628,	263583.68888,	263588.47148,	263593.25409,	263598.03671,
263602.81933,	263607.60196,	263612.38460,	263617.16724,	263621.94989,	263626.73255,	263631.51522,	263636.29789,	263641.08057,	263645.86326,
263650.64595,	263655.42866,	263660.21136,	263664.99408,	263669.77680,	263674.55953,	263679.34227,	263684.12502,	263688.90777,	263693.69053,
263698.47329,	263703.25607,	263708.03885,	263712.82164,	263717.60443,	263722.38723,	263727.17004,	263731.95286,	263736.73568,	263741.51851,
263746.30135,	263751.08420,	263755.86705,	263760.64991,	263765.43278,	263770.21565,	263774.99853,	263779.78142,	263784.56431,	263789.34722,
263794.13013,	263798.91304,	263803.69597,	263808.47890,	263813.26184,	263818.04478,	263822.82773,	263827.61069,	263832.39366,	263837.17663,
263841.95961,	263846.74260,	263851.52560,	263856.30860,	263861.09161,	263865.87463,	263870.65765,	263875.44068,	263880.22372,	263885.00677,
263889.78982,	263894.57288,	263899.35595,	263904.13902,	263908.92210,	263913.70519,	263918.48829,	263923.27139,	263928.05450,	263932.83762,
263937.62074,	263942.40387,	263947.18701,	263951.97016,	263956.75331,	263961.53647,	263966.31964,	263971.10281,	263975.88599,	263980.66918,
263985.45238,	263990.23558,	263995.01879,	263999.80201,	264004.58523,	264009.36846,	264014.15170,	264018.93495,	264023.71820,	264028.50146,
264033.28473,	264038.06800,	264042.85129,	264047.63457,	264052.41787,	264057.20117,	264061.98448,	264066.76780,	264071.55113,	264076.33446,
264081.11780,	264085.90114,	264090.68450,	264095.46786,	264100.25122,	264105.03460,	264109.81798,	264114.60137,	264119.38477,	264124.16817,
264128.95158,	264133.73500,	264138.51842,	264143.30185,	264148.08529,	264152.86874,	264157.65219,	264162.43565,	264167.21912,	264172.00259,
264176.78608,	264181.56957,	264186.35306,	264191.13657,	264195.92008,	264200.70359,	264205.48712,	264210.27065,	264215.05419,	264219.83774,
264224.62129,	264229.40485,	264234.18842,	264238.97199,	264243.75557,	264248.53916,	264253.32276,	264258.10636,	264262.88997,	264267.67359,
264272.45722,	264277.24085,	264282.02449,	264286.80813,	264291.59179,	264296.37545,	264301.15912,	264305.94279,	264310.72647,	264315.51016,
264320.29386,	264325.07756,	264329.86127,	264334.64499,	264339.42872,	264344.21245,	264348.99619,	264353.77993,	264358.56369,	264363.34745,
264368.13122,	264372.91499,	264377.69877,	264382.48256,	264387.26636,	264392.05016,	264396.83397,	264401.61779,	264406.40162,	264411.18545,
264415.96929,	264420.75313,	264425.53699,	264430.32085,	264435.10472,	264439.88859,	264444.67247,	264449.45636,	264454.24026,	264459.02416,
264463.80807,	264468.59199,	264473.37592,	264478.15985,	264482.94379,	264487.72773,	264492.51169,	264497.29565,	264502.07962,	264506.86359,
264511.64757,	264516.43156,	264521.21556,	264525.99956,	264530.78357,	264535.56759,	264540.35162,	264545.13565,	264549.91969,	264554.70373,
264559.48779,	264564.27185,	264569.05592,	264573.83999,	264578.62407,	264583.40816,	264588.19226,	264592.97636,	264597.76047,	264602.54459,
264607.32872,	264612.11285,	264616.89699,	264621.68113,	264626.46529,	264631.24945,	264636.03362,	264640.81779,	264645.60197,	264650.38616,
264655.17036,	264659.95456,	264664.73877,	264669.52299,	264674.30721,	264679.09145,	264683.87569,	264688.65993,	264693.44419,	264698.22845,
264703.01271,	264707.79699,	264712.58127,	264717.36556,	264722.14986,	264726.93416,	264731.71847,	264736.50279,	264741.28711,	264746.07144,
264750.85578,	264755.64013,	264760.42448,	264765.20884,	264769.99321,	264774.77759,	264779.56197,	264784.34636,	264789.13075,	264793.91516,
264798.69957,	264803.48398,	264808.26841,	264813.05284,	264817.83728,	264822.62173,	264827.40618,	264832.19064,	264836.97511,	264841.75958,
264846.54406,	264851.32855,	264856.11305,	264860.89755,	264865.68206,	264870.46658,	264875.25110,	264880.03564,	264884.82017,	264889.60472,
264894.38927,	264899.17383,	264903.95840,	264908.74298,	264913.52756,	264918.31215,	264923.09674,	264927.88135,	264932.66596,	264937.45057,
264942.23520,	264947.01983,	264951.80447,	264956.58911,	264961.37377,	264966.15843,	264970.94309,	264975.72777,	264980.51245,	264985.29714,
264990.08183,	264994.86654,	264999.65125,	265004.43596,	265009.22069,	265014.00542,	265018.79016,	265023.57490,	265028.35966,	265033.14442,
265037.92918,	265042.71396,	265047.49874,	265052.28353,	265057.06832,	265061.85312,	265066.63793,	265071.42275,	265076.20758,	265080.99241,
265085.77725,	265090.56209,	265095.34694,	265100.13180,	265104.91667,	265109.70154,	265114.48642,	265119.27131,	265124.05621,	265128.84111,
265133.62602,	265138.41094,	265143.19586,	265147.98079,	265152.76573,	265157.55068,	265162.33563,	265167.12059,	265171.90555,	265176.69053,
265181.47551,	265186.26050,	265191.04549,	265195.83049,	265200.61550,	265205.40052,	265210.18554,	265214.97057,	265219.75561,	265224.54066,
265229.32571,	265234.11077,	265238.89583,	265243.68091,	265248.46599,	265253.25108,	265258.03617,	265262.82127,	265267.60638,	265272.39150,
265277.17662,	265281.96175,	265286.74689,	265291.53203,	265296.31719,	265301.10234,	265305.88751,	265310.67268,	265315.45786,	265320.24305,
265325.02825,	265329.81345,	265334.59866,	265339.38387,	265344.16910,	265348.95433,	265353.73956,	265358.52481,	265363.31006,	265368.09532,
265372.88058,	265377.66586,	265382.45114,	265387.23642,	265392.02172,	265396.80702,	265401.59233,	265406.37764,	265411.16297,	265415.94830,
265420.73363,	265425.51898,	265430.30433,	265435.08969,	265439.87505,	265444.66042,	265449.44580,	265454.23119,	265459.01658,	265463.80198,
265468.58739,	265473.37281,	265478.15823,	265482.94366,	265487.72910,	265492.51454,	265497.29999,	265502.08545,	265506.87091,	265511.65639,
265516.44187,	265521.22735,	265526.01285,	265530.79835,	265535.58385,	265540.36937,	265545.15489,	265549.94042,	265554.72596,	265559.51150,
265564.29705,	265569.08261,	265573.86817,	265578.65374,	265583.43932,	265588.22491,	265593.01050,	265597.79610,	265602.58171,	265607.36733,
265612.15295,	265616.93858,	265621.72421,	265626.50985,	265631.29550,	265636.08116,	265640.86683,	265645.65250,	265650.43818,	265655.22386,
265660.00955,	265664.79525,	265669.58096,	265674.36668,	265679.15240,	265683.93813,	265688.72386,	265693.50960,	265698.29535,	265703.08111,
265707.86687,	265712.65264,	265717.43842,	265722.22421,	265727.01000,	265731.79580,	265736.58161,	265741.36742,	265746.15324,	265750.93907,
265755.72490,	265760.51075,	265765.29660,	265770.08245,	265774.86832,	265779.65419,	265784.44006,	265789.22595,	265794.01184,	265798.79774,
265803.58365,	265808.36956,	265813.15548,	265817.94141,	265822.72734,	265827.51328,	265832.29923,	265837.08519,	265841.87115,	265846.65712,
265851.44310,	265856.22908,	265861.01507,	265865.80107,	265870.58708,	265875.37309,	265880.15911,	265884.94514,	265889.73117,	265894.51721,
265899.30326,	265904.08932,	265908.87538,	265913.66145,	265918.44753,	265923.23361,	265928.01970,	265932.80580,	265937.59190,	265942.37802,
265947.16414,	265951.95026,	265956.73640,	265961.52254,	265966.30868,	265971.09484,	265975.88100,	265980.66717,	265985.45335,	265990.23953,
265995.02572,	265999.81192,	266004.59812,	266009.38433,	266014.17055,	266018.95678,	266023.74301,	266028.52925,	266033.31550,	266038.10175,
266042.88802,	266047.67428,	266052.46056,	266057.24684,	266062.03313,	266066.81943,	266071.60573,	266076.39204,	266081.17836,	266085.96469,
266090.75102,	266095.53736,	266100.32371,	266105.11006,	266109.89642,	266114.68279,	266119.46917,	266124.25555,	266129.04194,	266133.82833,
266138.61474,	266143.40115,	266148.18757,	266152.97399,	266157.76042,	266162.54686,	266167.33331,	266172.11976,	266176.90622,	266181.69269,
266186.47916,	266191.26564,	266196.05213,	266200.83863,	266205.62513,	266210.41164,	266215.19816,	266219.98468,	266224.77122,	266229.55775,
266234.34430,	266239.13085,	266243.91741,	266248.70398,	266253.49055,	266258.27713,	266263.06372,	266267.85032,	266272.63692,	266277.42353,
266282.21015,	266286.99677,	266291.78340,	266296.57004,	266301.35668,	266306.14333,	266310.92999,	266315.71666,	266320.50333,	266325.29001,
266330.07670,	266334.86340,	266339.65010,	266344.43681,	266349.22352,	266354.01025,	266358.79698,	266363.58371,	266368.37046,	266373.15721,
266377.94397,	266382.73073,	266387.51751,	266392.30429,	266397.09107,	266401.87787,	266406.66467,	266411.45148,	266416.23829,	266421.02511,
266425.81194,	266430.59878,	266435.38562,	266440.17247,	266444.95933,	266449.74620,	266454.53307,	266459.31995,	266464.10683,	266468.89373,
266473.68063,	266478.46754,	266483.25445,	266488.04137,	266492.82830,	266497.61524,	266502.40218,	266507.18913,	266511.97609,	266516.76305,
266521.55002,	266526.33700,	266531.12399,	266535.91098,	266540.69798,	266545.48499,	266550.27200,	266555.05902,	266559.84605,	266564.63308,
266569.42013,	266574.20718,	266578.99423,	266583.78130,	266588.56837,	266593.35544,	266598.14253,	266602.92962,	266607.71672,	266612.50383,
266617.29094,	266622.07806,	266626.86519,	266631.65232,	266636.43946,	266641.22661,	266646.01377,	266650.80093,	266655.58810,	266660.37528,
266665.16246,	266669.94965,	266674.73685,	266679.52406,	266684.31127,	266689.09849,	266693.88571,	266698.67295,	266703.46019,	266708.24744,
266713.03469,	266717.82195,	266722.60922,	266727.39650,	266732.18378,	266736.97107,	266741.75837,	266746.54567,	266751.33299,	266756.12030,
266760.90763,	266765.69496,	266770.48230,	266775.26965,	266780.05700,	266784.84437,	266789.63173,	266794.41911,	266799.20649,	266803.99388,
266808.78128,	266813.56868,	266818.35609,	266823.14351,	266827.93094,	266832.71837,	266837.50581,	266842.29325,	266847.08071,	266851.86817,
266856.65564,	266861.44311,	266866.23059,	266871.01808,	266875.80558,	266880.59308,	266885.38059,	266890.16811,	266894.95563,	266899.74316,
266904.53070,	266909.31825,	266914.10580,	266918.89336,	266923.68093,	266928.46850,	266933.25608,	266938.04367,	266942.83126,	266947.61887,
266952.40647,	266957.19409,	266961.98171,	266966.76934,	266971.55698,	266976.34463,	266981.13228,	266985.91994,	266990.70760,	266995.49528,
267000.28296,	267005.07064,	267009.85834,	267014.64604,	267019.43375,	267024.22146,	267029.00919,	267033.79691,	267038.58465,	267043.37240,
267048.16015,	267052.94790,	267057.73567,	267062.52344,	267067.31122,	267072.09901,	267076.88680,	267081.67460,	267086.46241,	267091.25022,
267096.03804,	267100.82587,	267105.61371,	267110.40155,	267115.18940,	267119.97726,	267124.76512,	267129.55299,	267134.34087,	267139.12876,
267143.91665,	267148.70455,	267153.49246,	267158.28037,	267163.06829,	267167.85622,	267172.64415,	267177.43209,	267182.22004,	267187.00800,
267191.79596,	267196.58393,	267201.37191,	267206.15990,	267210.94789,	267215.73589,	267220.52389,	267225.31190,	267230.09992,	267234.88795,
267239.67598,	267244.46403,	267249.25207,	267254.04013,	267258.82819,	267263.61626,	267268.40434,	267273.19242,	267277.98051,	267282.76861,
267287.55671,	267292.34483,	267297.13294,	267301.92107,	267306.70920,	267311.49734,	267316.28549,	267321.07364,	267325.86181,	267330.64997,
267335.43815,	267340.22633,	267345.01452,	267349.80272,	267354.59092,	267359.37913,	267364.16735,	267368.95558,	267373.74381,	267378.53205,
267383.32029,	267388.10855,	267392.89681,	267397.68507,	267402.47335,	267407.26163,	267412.04992,	267416.83821,	267421.62652,	267426.41483,
267431.20314,	267435.99147,	267440.77980,	267445.56814,	267450.35648,	267455.14483,	267459.93319,	267464.72156,	267469.50993,	267474.29831,
267479.08670,	267483.87510,	267488.66350,	267493.45191,	267498.24032,	267503.02875,	267507.81718,	267512.60561,	267517.39406,	267522.18251,
267526.97097,	267531.75943,	267536.54790,	267541.33638,	267546.12487,	267550.91336,	267555.70186,	267560.49037,	267565.27889,	267570.06741,
267574.85594,	267579.64447,	267584.43302,	267589.22157,	267594.01012,	267598.79869,	267603.58726,	267608.37584,	267613.16442,	267617.95302,
267622.74162,	267627.53022,	267632.31884,	267637.10746,	267641.89608,	267646.68472,	267651.47336,	267656.26201,	267661.05067,	267665.83933,
267670.62800,	267675.41668,	267680.20536,	267684.99405,	267689.78275,	267694.57146,	267699.36017,	267704.14889,	267708.93762,	267713.72635,
267718.51509,	267723.30384,	267728.09259,	267732.88136,	267737.67013,	267742.45890,	267747.24769,	267752.03648,	267756.82527,	267761.61408,
267766.40289,	267771.19171,	267775.98053,	267780.76937,	267785.55821,	267790.34705,	267795.13591,	267799.92477,	267804.71364,	267809.50251,
267814.29139,	267819.08028,	267823.86918,	267828.65808,	267833.44699,	267838.23591,	267843.02483,	267847.81377,	267852.60271,	267857.39165,
267862.18060,	267866.96956,	267871.75853,	267876.54750,	267881.33649,	267886.12547,	267890.91447,	267895.70347,	267900.49248,	267905.28150,
267910.07052,	267914.85955,	267919.64859,	267924.43763,	267929.22668,	267934.01574,	267938.80481,	267943.59388,	267948.38296,	267953.17205,
267957.96114,	267962.75024,	267967.53935,	267972.32847,	267977.11759,	267981.90672,	267986.69585,	267991.48500,	267996.27415,	268001.06331,
268005.85247,	268010.64164,	268015.43082,	268020.22001,	268025.00920,	268029.79840,	268034.58761,	268039.37682,	268044.16604,	268048.95527,
268053.74450,	268058.53375,	268063.32299,	268068.11225,	268072.90151,	268077.69078,	268082.48006,	268087.26935,	268092.05864,	268096.84794,
268101.63724,	268106.42656,	268111.21587,	268116.00520,	268120.79454,	268125.58388,	268130.37322,	268135.16258,	268139.95194,	268144.74131,
268149.53069,	268154.32007,	268159.10946,	268163.89886,	268168.68826,	268173.47767,	268178.26709,	268183.05652,	268187.84595,	268192.63539,
268197.42484,	268202.21429,	268207.00375,	268211.79322,	268216.58269,	268221.37218,	268226.16167,	268230.95116,	268235.74066,	268240.53018,
268245.31969,	268250.10922,	268254.89875,	268259.68829,	268264.47783,	268269.26738,	268274.05694,	268278.84651,	268283.63608,	268288.42566,
268293.21525,	268298.00485,	268302.79445,	268307.58406,	268312.37367,	268317.16330,	268321.95293,	268326.74256,	268331.53221,	268336.32186,
268341.11152,	268345.90118,	268350.69086,	268355.48054,	268360.27022,	268365.05992,	268369.84962,	268374.63932,	268379.42904,	268384.21876,
268389.00849,	268393.79822,	268398.58797,	268403.37772,	268408.16747,	268412.95724,	268417.74701,	268422.53679,	268427.32657,	268432.11636,
268436.90616,	268441.69597,	268446.48578,	268451.27560,	268456.06543,	268460.85527,	268465.64511,	268470.43496,	268475.22481,	268480.01467,
268484.80454,	268489.59442,	268494.38430,	268499.17419,	268503.96409,	268508.75400,	268513.54391,	268518.33383,	268523.12375,	268527.91369,
268532.70363,	268537.49357,	268542.28353,	268547.07349,	268551.86346,	268556.65343,	268561.44342,	268566.23341,	268571.02340,	268575.81341,
268580.60342,	268585.39343,	268590.18346,	268594.97349,	268599.76353,	268604.55357,	268609.34363,	268614.13369,	268618.92375,	268623.71383,
268628.50391,	268633.29400,	268638.08409,	268642.87419,	268647.66430,	268652.45442,	268657.24454,	268662.03467,	268666.82481,	268671.61495,
268676.40511,	268681.19526,	268685.98543,	268690.77560,	268695.56578,	268700.35597,	268705.14616,	268709.93636,	268714.72657,	268719.51679,
268724.30701,	268729.09724,	268733.88747,	268738.67772,	268743.46797,	268748.25822,	268753.04849,	268757.83876,	268762.62904,	268767.41932,
268772.20961,	268776.99991,	268781.79022,	268786.58053,	268791.37085,	268796.16118,	268800.95151,	268805.74186,	268810.53220,	268815.32256,
268820.11292,	268824.90329,	268829.69367,	268834.48405,	268839.27444,	268844.06484,	268848.85525,	268853.64566,	268858.43608,	268863.22650,
268868.01693,	268872.80737,	268877.59782,	268882.38828,	268887.17874,	268891.96921,	268896.75968,	268901.55016,	268906.34065,	268911.13115,
268915.92165,	268920.71216,	268925.50268,	268930.29320,	268935.08373,	268939.87427,	268944.66482,	268949.45537,	268954.24593,	268959.03650,
268963.82707,	268968.61765,	268973.40824,	268978.19883,	268982.98944,	268987.78005,	268992.57066,	268997.36128,	269002.15191,	269006.94255,
269011.73319,	269016.52385,	269021.31450,	269026.10517,	269030.89584,	269035.68652,	269040.47721,	269045.26790,	269050.05860,	269054.84931,
269059.64002,	269064.43074,	269069.22147,	269074.01221,	269078.80295,	269083.59370,	269088.38446,	269093.17522,	269097.96599,	269102.75677,
269107.54755,	269112.33834,	269117.12914,	269121.91995,	269126.71076,	269131.50158,	269136.29241,	269141.08324,	269145.87408,	269150.66493,
269155.45578,	269160.24665,	269165.03752,	269169.82839,	269174.61927,	269179.41016,	269184.20106,	269188.99197,	269193.78288,	269198.57380,
269203.36472,	269208.15565,	269212.94659,	269217.73754,	269222.52849,	269227.31945,	269232.11042,	269236.90139,	269241.69238,	269246.48336,
269251.27436,	269256.06536,	269260.85637,	269265.64739,	269270.43841,	269275.22944,	269280.02048,	269284.81152,	269289.60258,	269294.39363,
269299.18470,	269303.97577,	269308.76685,	269313.55794,	269318.34903,	269323.14013,	269327.93124,	269332.72236,	269337.51348,	269342.30461,
269347.09574,	269351.88689,	269356.67804,	269361.46919,	269366.26036,	269371.05153,	269375.84271,	269380.63389,	269385.42509,	269390.21629,
269395.00749,	269399.79870,	269404.58992,	269409.38115,	269414.17239,	269418.96363,	269423.75488,	269428.54613,	269433.33739,	269438.12866,
269442.91994,	269447.71122,	269452.50251,	269457.29381,	269462.08512,	269466.87643,	269471.66775,	269476.45907,	269481.25041,	269486.04174,
269490.83309,	269495.62445,	269500.41581,	269505.20717,	269509.99855,	269514.78993,	269519.58132,	269524.37272,	269529.16412,	269533.95553,
269538.74695,	269543.53837,	269548.32980,	269553.12124,	269557.91268,	269562.70414,	269567.49559,	269572.28706,	269577.07853,	269581.87001,
269586.66150,	269591.45299,	269596.24450,	269601.03600,	269605.82752,	269610.61904,	269615.41057,	269620.20211,	269624.99365,	269629.78520,
269634.57676,	269639.36832,	269644.15989,	269648.95147,	269653.74306,	269658.53465,	269663.32625,	269668.11786,	269672.90947,	269677.70109,
269682.49272,	269687.28435,	269692.07599,	269696.86764,	269701.65930,	269706.45096,	269711.24263,	269716.03431,	269720.82599,	269725.61768,
269730.40938,	269735.20108,	269739.99279,	269744.78451,	269749.57624,	269754.36797,	269759.15971,	269763.95146,	269768.74321,	269773.53497,
269778.32674,	269783.11852,	269787.91030,	269792.70209,	269797.49388,	269802.28568,	269807.07749,	269811.86931,	269816.66114,	269821.45297,
269826.24480,	269831.03665,	269835.82850,	269840.62036,	269845.41223,	269850.20410,	269854.99598,	269859.78787,	269864.57976,	269869.37166,
269874.16357,	269878.95548,	269883.74741,	269888.53934,	269893.33127,	269898.12322,	269902.91517,	269907.70712,	269912.49909,	269917.29106,
269922.08304,	269926.87502,	269931.66701,	269936.45901,	269941.25102,	269946.04303,	269950.83505,	269955.62708,	269960.41911,	269965.21116,
269970.00320,	269974.79526,	269979.58732,	269984.37939,	269989.17147,	269993.96355,	269998.75564,	270003.54774,	270008.33984,	270013.13195,
270017.92407,	270022.71620,	270027.50833,	270032.30047,	270037.09262,	270041.88477,	270046.67693,	270051.46910,	270056.26127,	270061.05345,
270065.84564,	270070.63784,	270075.43004,	270080.22225,	270085.01447,	270089.80669,	270094.59892,	270099.39116,	270104.18340,	270108.97565,
270113.76791,	270118.56018,	270123.35245,	270128.14473,	270132.93702,	270137.72931,	270142.52161,	270147.31392,	270152.10623,	270156.89856,
270161.69088,	270166.48322,	270171.27556,	270176.06791,	270180.86027,	270185.65263,	270190.44500,	270195.23738,	270200.02977,	270204.82216,
270209.61456,	270214.40696,	270219.19937,	270223.99179,	270228.78422,	270233.57665,	270238.36910,	270243.16154,	270247.95400,	270252.74646,
270257.53893,	270262.33140,	270267.12389,	270271.91638,	270276.70887,	270281.50138,	270286.29389,	270291.08641,	270295.87893,	270300.67146,
270305.46400,	270310.25655,	270315.04910,	270319.84166,	270324.63423,	270329.42680,	270334.21938,	270339.01197,	270343.80456,	270348.59716,
270353.38977,	270358.18239,	270362.97501,	270367.76764,	270372.56028,	270377.35292,	270382.14557,	270386.93823,	270391.73090,	270396.52357,
270401.31625,	270406.10893,	270410.90162,	270415.69432,	270420.48703,	270425.27975,	270430.07247,	270434.86519,	270439.65793,	270444.45067,
270449.24342,	270454.03617,	270458.82894,	270463.62171,	270468.41448,	270473.20727,	270478.00006,	270482.79286,	270487.58566,	270492.37847,
270497.17129,	270501.96412,	270506.75695,	270511.54979,	270516.34264,	270521.13549,	270525.92835,	270530.72122,	270535.51409,	270540.30698,
270545.09986,	270549.89276,	270554.68566,	270559.47857,	270564.27149,	270569.06441,	270573.85734,	270578.65028,	270583.44323,	270588.23618,
270593.02914,	270597.82210,	270602.61508,	270607.40805,	270612.20104,	270616.99404,	270621.78704,	270626.58004,	270631.37306,	270636.16608,
270640.95911,	270645.75214,	270650.54519,	270655.33824,	270660.13129,	270664.92436,	270669.71743,	270674.51050,	270679.30359,	270684.09668,
270688.88978,	270693.68289,	270698.47600,	270703.26912,	270708.06224,	270712.85538,	270717.64852,	270722.44167,	270727.23482,	270732.02798,
270736.82115,	270741.61433,	270746.40751,	270751.20070,	270755.99389,	270760.78710,	270765.58031,	270770.37353,	270775.16675,	270779.95998,
270784.75322,	270789.54647,	270794.33972,	270799.13298,	270803.92624,	270808.71952,	270813.51280,	270818.30608,	270823.09938,	270827.89268,
270832.68599,	270837.47930,	270842.27263,	270847.06596,	270851.85929,	270856.65264,	270861.44599,	270866.23934,	270871.03271,	270875.82608,
270880.61946,	270885.41284,	270890.20623,	270894.99963,	270899.79304,	270904.58645,	270909.37987,	270914.17330,	270918.96673,	270923.76018,
270928.55362,	270933.34708,	270938.14054,	270942.93401,	270947.72749,	270952.52097,	270957.31446,	270962.10796,	270966.90146,	270971.69497,
270976.48849,	270981.28201,	270986.07555,	270990.86908,	270995.66263,	271000.45618,	271005.24974,	271010.04331,	271014.83688,	271019.63047,
271024.42405,	271029.21765,	271034.01125,	271038.80486,	271043.59847,	271048.39210,	271053.18573,	271057.97936,	271062.77301,	271067.56666,
271072.36032,	271077.15398,	271081.94765,	271086.74133,	271091.53502,	271096.32871,	271101.12241,	271105.91612,	271110.70983,	271115.50355,
271120.29728,	271125.09101,	271129.88475,	271134.67850,	271139.47226,	271144.26602,	271149.05979,	271153.85357,	271158.64735,	271163.44114,
271168.23494,	271173.02874,	271177.82255,	271182.61637,	271187.41020,	271192.20403,	271196.99787,	271201.79171,	271206.58557,	271211.37943,
271216.17329,	271220.96717,	271225.76105,	271230.55494,	271235.34883,	271240.14273,	271244.93664,	271249.73056,	271254.52448,	271259.31841,
271264.11235,	271268.90629,	271273.70024,	271278.49420,	271283.28817,	271288.08214,	271292.87612,	271297.67010,	271302.46410,	271307.25810,
271312.05210,	271316.84612,	271321.64014,	271326.43417,	271331.22820,	271336.02224,	271340.81629,	271345.61035,	271350.40441,	271355.19848,
271359.99256,	271364.78664,	271369.58073,	271374.37483,	271379.16893,	271383.96304,	271388.75716,	271393.55129,	271398.34542,	271403.13956,
271407.93370,	271412.72786,	271417.52202,	271422.31619,	271427.11036,	271431.90454,	271436.69873,	271441.49292,	271446.28713,	271451.08134,
271455.87555,	271460.66977,	271465.46400,	271470.25824,	271475.05249,	271479.84674,	271484.64099,	271489.43526,	271494.22953,	271499.02381,
271503.81810,	271508.61239,	271513.40669,	271518.20100,	271522.99531,	271527.78963,	271532.58396,	271537.37829,	271542.17263,	271546.96698,
271551.76134,	271556.55570,	271561.35007,	271566.14445,	271570.93883,	271575.73322,	271580.52762,	271585.32202,	271590.11643,	271594.91085,
271599.70528,	271604.49971,	271609.29415,	271614.08860,	271618.88305,	271623.67751,	271628.47198,	271633.26645,	271638.06093,	271642.85542,
271647.64991,	271652.44442,	271657.23892,	271662.03344,	271666.82796,	271671.62249,	271676.41703,	271681.21157,	271686.00612,	271690.80068,
271695.59525,	271700.38982,	271705.18440,	271709.97898,	271714.77358,	271719.56818,	271724.36278,	271729.15740,	271733.95202,	271738.74664,
271743.54128,	271748.33592,	271753.13057,	271757.92522,	271762.71989,	271767.51455,	271772.30923,	271777.10391,	271781.89860,	271786.69330,
271791.48801,	271796.28272,	271801.07743,	271805.87216,	271810.66689,	271815.46163,	271820.25638,	271825.05113,	271829.84589,	271834.64066,
271839.43543,	271844.23021,	271849.02500,	271853.81979,	271858.61459,	271863.40940,	271868.20422,	271872.99904,	271877.79387,	271882.58871,
271887.38355,	271892.17840,	271896.97326,	271901.76812,	271906.56299,	271911.35787,	271916.15276,	271920.94765,	271925.74255,	271930.53745,
271935.33237,	271940.12729,	271944.92221,	271949.71715,	271954.51209,	271959.30704,	271964.10199,	271968.89695,	271973.69192,	271978.48690,
271983.28188,	271988.07687,	271992.87187,	271997.66687,	272002.46188,	272007.25690,	272012.05192,	272016.84696,	272021.64199,	272026.43704,
272031.23209,	272036.02715,	272040.82222,	272045.61729,	272050.41237,	272055.20746,	272060.00255,	272064.79765,	272069.59276,	272074.38788,
272079.18300,	272083.97813,	272088.77326,	272093.56841,	272098.36355,	272103.15871,	272107.95388,	272112.74905,	272117.54422,	272122.33941,
272127.13460,	272131.92980,	272136.72500,	272141.52022,	272146.31544,	272151.11066,	272155.90590,	272160.70114,	272165.49638,	272170.29164,
272175.08690,	272179.88217,	272184.67744,	272189.47272,	272194.26801,	272199.06331,	272203.85861,	272208.65392,	272213.44924,	272218.24456,
272223.03989,	272227.83523,	272232.63057,	272237.42593,	272242.22128,	272247.01665,	272251.81202,	272256.60740,	272261.40279,	272266.19818,
272270.99358,	272275.78899,	272280.58440,	272285.37982,	272290.17525,	272294.97069,	272299.76613,	272304.56158,	272309.35703,	272314.15250,
272318.94797,	272323.74344,	272328.53893,	272333.33442,	272338.12992,	272342.92542,	272347.72093,	272352.51645,	272357.31198,	272362.10751,
272366.90305,	272371.69859,	272376.49415,	272381.28971,	272386.08528,	272390.88085,	272395.67643,	272400.47202,	272405.26761,	272410.06322,
272414.85882,	272419.65444,	272424.45006,	272429.24569,	272434.04133,	272438.83697,	272443.63262,	272448.42828,	272453.22395,	272458.01962,
272462.81530,	272467.61098,	272472.40667,	272477.20237,	272481.99808,	272486.79379,	272491.58951,	272496.38524,	272501.18097,	272505.97672,
272510.77246,	272515.56822,	272520.36398,	272525.15975,	272529.95552,	272534.75131,	272539.54710,	272544.34289,	272549.13870,	272553.93451,
272558.73033,	272563.52615,	272568.32198,	272573.11782,	272577.91366,	272582.70952,	272587.50538,	272592.30124,	272597.09712,	272601.89300,
272606.68888,	272611.48478,	272616.28068,	272621.07659,	272625.87250,	272630.66842,	272635.46435,	272640.26029,	272645.05623,	272649.85218,
272654.64813,	272659.44410,	272664.24007,	272669.03605,	272673.83203,	272678.62802,	272683.42402,	272688.22002,	272693.01604,	272697.81205,
272702.60808,	272707.40411,	272712.20015,	272716.99620,	272721.79225,	272726.58831,	272731.38438,	272736.18046,	272740.97654,	272745.77263,
272750.56872,	272755.36482,	272760.16093,	272764.95705,	272769.75317,	272774.54930,	272779.34544,	272784.14158,	272788.93774,	272793.73389,
272798.53006,	272803.32623,	272808.12241,	272812.91859,	272817.71479,	272822.51099,	272827.30719,	272832.10341,	272836.89963,	272841.69585,
272846.49209,	272851.28833,	272856.08458,	272860.88083,	272865.67709,	272870.47336,	272875.26964,	272880.06592,	272884.86221,	272889.65851,
272894.45481,	272899.25112,	272904.04744,	272908.84377,	272913.64010,	272918.43643,	272923.23278,	272928.02913,	272932.82549,	272937.62186,
272942.41823,	272947.21461,	272952.01100,	272956.80739,	272961.60379,	272966.40020,	272971.19662,	272975.99304,	272980.78947,	272985.58590,
272990.38234,	272995.17879,	272999.97525,	273004.77171,	273009.56818,	273014.36466,	273019.16114,	273023.95764,	273028.75413,	273033.55064,
273038.34715,	273043.14367,	273047.94019,	273052.73673,	273057.53327,	273062.32981,	273067.12637,	273071.92293,	273076.71950,	273081.51607,
273086.31265,	273091.10924,	273095.90583,	273100.70244,	273105.49905,	273110.29566,	273115.09228,	273119.88891,	273124.68555,	273129.48219,
273134.27885,	273139.07550,	273143.87217,	273148.66884,	273153.46552,	273158.26220,	273163.05889,	273167.85559,	273172.65230,	273177.44901,
273182.24573,	273187.04246,	273191.83919,	273196.63593,	273201.43268,	273206.22944,	273211.02620,	273215.82297,	273220.61974,	273225.41652,
273230.21331,	273235.01011,	273239.80691,	273244.60372,	273249.40054,	273254.19737,	273258.99420,	273263.79103,	273268.58788,	273273.38473,
273278.18159,	273282.97845,	273287.77533,	273292.57221,	273297.36909,	273302.16599,	273306.96289,	273311.75979,	273316.55671,	273321.35363,
273326.15056,	273330.94749,	273335.74443,	273340.54138,	273345.33834,	273350.13530,	273354.93227,	273359.72925,	273364.52623,	273369.32322,
273374.12022,	273378.91722,	273383.71423,	273388.51125,	273393.30828,	273398.10531,	273402.90235,	273407.69939,	273412.49645,	273417.29351,
273422.09057,	273426.88765,	273431.68473,	273436.48181,	273441.27891,	273446.07601,	273450.87312,	273455.67023,	273460.46736,	273465.26448,
273470.06162,	273474.85876,	273479.65591,	273484.45307,	273489.25023,	273494.04740,	273498.84458,	273503.64177,	273508.43896,	273513.23616,
273518.03336,	273522.83057,	273527.62779,	273532.42502,	273537.22225,	273542.01949,	273546.81674,	273551.61399,	273556.41125,	273561.20852,
273566.00579,	273570.80307,	273575.60036,	273580.39766,	273585.19496,	273589.99227,	273594.78959,	273599.58691,	273604.38424,	273609.18158,
273613.97892,	273618.77627,	273623.57363,	273628.37099,	273633.16836,	273637.96574,	273642.76313,	273647.56052,	273652.35792,	273657.15532,
273661.95274,	273666.75016,	273671.54758,	273676.34502,	273681.14246,	273685.93991,	273690.73736,	273695.53482,	273700.33229,	273705.12977,
273709.92725,	273714.72474,	273719.52223,	273724.31974,	273729.11725,	273733.91476,	273738.71229,	273743.50982,	273748.30735,	273753.10490,
273757.90245,	273762.70001,	273767.49757,	273772.29515,	273777.09273,	273781.89031,	273786.68790,	273791.48550,	273796.28311,	273801.08073,
273805.87835,	273810.67597,	273815.47361,	273820.27125,	273825.06890,	273829.86655,	273834.66421,	273839.46188,	273844.25956,	273849.05724,
273853.85493,	273858.65263,	273863.45033,	273868.24804,	273873.04576,	273877.84349,	273882.64122,	273887.43896,	273892.23670,	273897.03445,
273901.83221,	273906.62998,	273911.42775,	273916.22553,	273921.02332,	273925.82111,	273930.61891,	273935.41672,	273940.21453,	273945.01235,
273949.81018,	273954.60802,	273959.40586,	273964.20371,	273969.00157,	273973.79943,	273978.59730,	273983.39517,	273988.19306,	273992.99095,
273997.78885,	274002.58675,	274007.38466,	274012.18258,	274016.98050,	274021.77844,	274026.57638,	274031.37432,	274036.17227,	274040.97023,
274045.76820,	274050.56617,	274055.36415,	274060.16214,	274064.96014,	274069.75814,	274074.55614,	274079.35416,	274084.15218,	274088.95021,
274093.74825,	274098.54629,	274103.34434,	274108.14239,	274112.94046,	274117.73853,	274122.53661,	274127.33469,	274132.13278,	274136.93088,
274141.72898,	274146.52710,	274151.32521,	274156.12334,	274160.92147,	274165.71961,	274170.51776,	274175.31591,	274180.11407,	274184.91224,
274189.71041,	274194.50859,	274199.30678,	274204.10498,	274208.90318,	274213.70139,	274218.49960,	274223.29782,	274228.09605,	274232.89429,
274237.69253,	274242.49078,	274247.28904,	274252.08730,	274256.88557,	274261.68385,	274266.48214,	274271.28043,	274276.07873,	274280.87703,
274285.67534,	274290.47366,	274295.27199,	274300.07032,	274304.86866,	274309.66701,	274314.46536,	274319.26372,	274324.06209,	274328.86046,
274333.65884,	274338.45723,	274343.25563,	274348.05403,	274352.85244,	274357.65085,	274362.44928,	274367.24771,	274372.04614,	274376.84459,
274381.64304,	274386.44149,	274391.23996,	274396.03843,	274400.83691,	274405.63539,	274410.43388,	274415.23238,	274420.03089,	274424.82940,
274429.62792,	274434.42645,	274439.22498,	274444.02352,	274448.82207,	274453.62062,	274458.41918,	274463.21775,	274468.01633,	274472.81491,
274477.61350,	274482.41209,	274487.21069,	274492.00930,	274496.80792,	274501.60654,	274506.40517,	274511.20381,	274516.00245,	274520.80110,
274525.59976,	274530.39842,	274535.19710,	274539.99577,	274544.79446,	274549.59315,	274554.39185,	274559.19056,	274563.98927,	274568.78799,
274573.58672,	274578.38545,	274583.18419,	274587.98294,	274592.78169,	274597.58045,	274602.37922,	274607.17799,	274611.97678,	274616.77557,
274621.57436,	274626.37316,	274631.17197,	274635.97079,	274640.76961,	274645.56844,	274650.36728,	274655.16612,	274659.96497,	274664.76383,
274669.56270,	274674.36157,	274679.16045,	274683.95933,	274688.75822,	274693.55712,	274698.35603,	274703.15494,	274707.95386,	274712.75279,
274717.55172,	274722.35066,	274727.14961,	274731.94856,	274736.74753,	274741.54649,	274746.34547,	274751.14445,	274755.94344,	274760.74244,
274765.54144,	274770.34045,	274775.13946,	274779.93849,	274784.73752,	274789.53656,	274794.33560,	274799.13465,	274803.93371,	274808.73277,
274813.53184,	274818.33092,	274823.13001,	274827.92910,	274832.72820,	274837.52731,	274842.32642,	274847.12554,	274851.92467,	274856.72380,
274861.52294,	274866.32209,	274871.12124,	274875.92040,	274880.71957,	274885.51875,	274890.31793,	274895.11712,	274899.91631,	274904.71552,
274909.51472,	274914.31394,	274919.11316,	274923.91239,	274928.71163,	274933.51088,	274938.31013,	274943.10938,	274947.90865,	274952.70792,
274957.50720,	274962.30649,	274967.10578,	274971.90508,	274976.70438,	274981.50370,	274986.30302,	274991.10234,	274995.90168,	275000.70102,
275005.50036,	275010.29972,	275015.09908,	275019.89845,	275024.69782,	275029.49720,	275034.29659,	275039.09599,	275043.89539,	275048.69480,
275053.49422,	275058.29364,	275063.09307,	275067.89251,	275072.69195,	275077.49140,	275082.29086,	275087.09033,	275091.88980,	275096.68927,
275101.48876,	275106.28825,	275111.08775,	275115.88726,	275120.68677,	275125.48629,	275130.28582,	275135.08535,	275139.88489,	275144.68444,
275149.48399,	275154.28355,	275159.08312,	275163.88270,	275168.68228,	275173.48187,	275178.28146,	275183.08106,	275187.88067,	275192.68029,
275197.47991,	275202.27954,	275207.07918,	275211.87882,	275216.67847,	275221.47813,	275226.27780,	275231.07747,	275235.87715,	275240.67683,
275245.47652,	275250.27622,	275255.07593,	275259.87564,	275264.67536,	275269.47509,	275274.27482,	275279.07456,	275283.87431,	275288.67406,
275293.47382,	275298.27359,	275303.07336,	275307.87315,	275312.67293,	275317.47273,	275322.27253,	275327.07234,	275331.87216,	275336.67198,
275341.47181,	275346.27165,	275351.07149,	275355.87134,	275360.67120,	275365.47106,	275370.27093,	275375.07081,	275379.87069,	275384.67059,
275389.47048,	275394.27039,	275399.07030,	275403.87022,	275408.67015,	275413.47008,	275418.27002,	275423.06997,	275427.86992,	275432.66988,
275437.46985,	275442.26982,	275447.06980,	275451.86979,	275456.66979,	275461.46979,	275466.26980,	275471.06981,	275475.86984,	275480.66987,
275485.46990,	275490.26994,	275495.06999,	275499.87005,	275504.67012,	275509.47019,	275514.27026,	275519.07035,	275523.87044,	275528.67054,
275533.47064,	275538.27075,	275543.07087,	275547.87100,	275552.67113,	275557.47127,	275562.27142,	275567.07157,	275571.87173,	275576.67190,
275581.47207,	275586.27225,	275591.07244,	275595.87263,	275600.67284,	275605.47304,	275610.27326,	275615.07348,	275619.87371,	275624.67395,
275629.47419,	275634.27444,	275639.07469,	275643.87496,	275648.67523,	275653.47551,	275658.27579,	275663.07608,	275667.87638,	275672.67668,
275677.47699,	275682.27731,	275687.07764,	275691.87797,	275696.67831,	275701.47865,	275706.27901,	275711.07937,	275715.87973,	275720.68011,
275725.48049,	275730.28087,	275735.08127,	275739.88167,	275744.68208,	275749.48249,	275754.28291,	275759.08334,	275763.88378,	275768.68422,
275773.48467,	275778.28512,	275783.08559,	275787.88606,	275792.68653,	275797.48702,	275802.28751,	275807.08800,	275811.88851,	275816.68902,
275821.48954,	275826.29006,	275831.09059,	275835.89113,	275840.69168,	275845.49223,	275850.29279,	275855.09335,	275859.89392,	275864.69450,
275869.49509,	275874.29568,	275879.09628,	275883.89689,	275888.69751,	275893.49813,	275898.29875,	275903.09939,	275907.90003,	275912.70068,
275917.50133,	275922.30200,	275927.10266,	275931.90334,	275936.70402,	275941.50471,	275946.30541,	275951.10611,	275955.90682,	275960.70754,
275965.50826,	275970.30899,	275975.10973,	275979.91048,	275984.71123,	275989.51199,	275994.31275,	275999.11352,	276003.91430,	276008.71509,
276013.51588,	276018.31668,	276023.11749,	276027.91830,	276032.71912,	276037.51995,	276042.32078,	276047.12162,	276051.92247,	276056.72332,
276061.52419,	276066.32505,	276071.12593,	276075.92681,	276080.72770,	276085.52860,	276090.32950,	276095.13041,	276099.93132,	276104.73225,
276109.53318,	276114.33411,	276119.13506,	276123.93601,	276128.73697,	276133.53793,	276138.33890,	276143.13988,	276147.94087,	276152.74186,
276157.54286,	276162.34386,	276167.14487,	276171.94589,	276176.74692,	276181.54795,	276186.34899,	276191.15004,	276195.95109,	276200.75215,
276205.55322,	276210.35429,	276215.15538,	276219.95646,	276224.75756,	276229.55866,	276234.35977,	276239.16088,	276243.96201,	276248.76314,
276253.56427,	276258.36542,	276263.16656,	276267.96772,	276272.76889,	276277.57006,	276282.37123,	276287.17242,	276291.97361,	276296.77481,
276301.57601,	276306.37722,	276311.17844,	276315.97967,	276320.78090,	276325.58214,	276330.38338,	276335.18464,	276339.98590,	276344.78716,
276349.58843,	276354.38972,	276359.19100,	276363.99230,	276368.79360,	276373.59490,	276378.39622,	276383.19754,	276387.99887,	276392.80020,
276397.60155,	276402.40289,	276407.20425,	276412.00561,	276416.80698,	276421.60836,	276426.40974,	276431.21113,	276436.01253,	276440.81393,
276445.61534,	276450.41676,	276455.21818,	276460.01962,	276464.82105,	276469.62250,	276474.42395,	276479.22541,	276484.02687,	276488.82835,
276493.62983,	276498.43131,	276503.23280,	276508.03430,	276512.83581,	276517.63732,	276522.43884,	276527.24037,	276532.04191,	276536.84345,
276541.64499,	276546.44655,	276551.24811,	276556.04968,	276560.85125,	276565.65284,	276570.45443,	276575.25602,	276580.05762,	276584.85923,
276589.66085,	276594.46247,	276599.26410,	276604.06574,	276608.86738,	276613.66903,	276618.47069,	276623.27236,	276628.07403,	276632.87571,
276637.67739,	276642.47908,	276647.28078,	276652.08249,	276656.88420,	276661.68592,	276666.48764,	276671.28938,	276676.09112,	276680.89286,
276685.69462,	276690.49638,	276695.29814,	276700.09992,	276704.90170,	276709.70349,	276714.50528,	276719.30708,	276724.10889,	276728.91071,
276733.71253,	276738.51436,	276743.31619,	276748.11804,	276752.91988,	276757.72174,	276762.52360,	276767.32547,	276772.12735,	276776.92923,
276781.73113,	276786.53302,	276791.33493,	276796.13684,	276800.93876,	276805.74068,	276810.54261,	276815.34455,	276820.14650,	276824.94845,
276829.75041,	276834.55237,	276839.35435,	276844.15633,	276848.95831,	276853.76031,	276858.56231,	276863.36431,	276868.16633,	276872.96835,
276877.77038,	276882.57241,	276887.37445,	276892.17650,	276896.97855,	276901.78062,	276906.58268,	276911.38476,	276916.18684,	276920.98893,
276925.79103,	276930.59313,	276935.39524,	276940.19736,	276944.99948,	276949.80161,	276954.60375,	276959.40589,	276964.20804,	276969.01020,
276973.81237,	276978.61454,	276983.41672,	276988.21890,	276993.02109,	276997.82329,	277002.62550,	277007.42771,	277012.22993,	277017.03216,
277021.83439,	277026.63663,	277031.43888,	277036.24113,	277041.04339,	277045.84566,	277050.64793,	277055.45021,	277060.25250,	277065.05479,
277069.85710,	277074.65940,	277079.46172,	277084.26404,	277089.06637,	277093.86871,	277098.67105,	277103.47340,	277108.27576,	277113.07812,
277117.88049,	277122.68287,	277127.48525,	277132.28764,	277137.09004,	277141.89244,	277146.69485,	277151.49727,	277156.29969,	277161.10213,
277165.90457,	277170.70701,	277175.50946,	277180.31192,	277185.11439,	277189.91686,	277194.71934,	277199.52183,	277204.32432,	277209.12682,
277213.92933,	277218.73184,	277223.53436,	277228.33689,	277233.13942,	277237.94196,	277242.74451,	277247.54707,	277252.34963,	277257.15220,
277261.95477,	277266.75735,	277271.55994,	277276.36254,	277281.16514,	277285.96775,	277290.77037,	277295.57299,	277300.37562,	277305.17826,
277309.98090,	277314.78355,	277319.58621,	277324.38887,	277329.19154,	277333.99422,	277338.79691,	277343.59960,	277348.40230,	277353.20500,
277358.00772,	277362.81043,	277367.61316,	277372.41589,	277377.21863,	277382.02138,	277386.82413,	277391.62689,	277396.42966,	277401.23243,
277406.03521,	277410.83800,	277415.64079,	277420.44360,	277425.24640,	277430.04922,	277434.85204,	277439.65487,	277444.45770,	277449.26055,
277454.06339,	277458.86625,	277463.66911,	277468.47198,	277473.27486,	277478.07774,	277482.88063,	277487.68353,	277492.48643,	277497.28934,
277502.09226,	277506.89518,	277511.69812,	277516.50105,	277521.30400,	277526.10695,	277530.90991,	277535.71287,	277540.51585,	277545.31882,
277550.12181,	277554.92480,	277559.72780,	277564.53081,	277569.33382,	277574.13684,	277578.93987,	277583.74290,	277588.54594,	277593.34899,
277598.15204,	277602.95510,	277607.75817,	277612.56125,	277617.36433,	277622.16742,	277626.97051,	277631.77361,	277636.57672,	277641.37984,
277646.18296,	277650.98609,	277655.78922,	277660.59237,	277665.39552,	277670.19867,	277675.00184,	277679.80501,	277684.60818,	277689.41137,
277694.21456,	277699.01776,	277703.82096,	277708.62417,	277713.42739,	277718.23061,	277723.03385,	277727.83709,	277732.64033,	277737.44358,
277742.24684,	277747.05011,	277751.85338,	277756.65666,	277761.45995,	277766.26324,	277771.06654,	277775.86985,	277780.67316,	277785.47648,
277790.27981,	277795.08314,	277799.88648,	277804.68983,	277809.49319,	277814.29655,	277819.09992,	277823.90329,	277828.70667,	277833.51006,
277838.31346,	277843.11686,	277847.92027,	277852.72368,	277857.52711,	277862.33054,	277867.13397,	277871.93742,	277876.74087,	277881.54433,
277886.34779,	277891.15126,	277895.95474,	277900.75822,	277905.56171,	277910.36521,	277915.16872,	277919.97223,	277924.77575,	277929.57927,
277934.38280,	277939.18634,	277943.98989,	277948.79344,	277953.59700,	277958.40057,	277963.20414,	277968.00772,	277972.81131,	277977.61490,
277982.41850,	277987.22211,	277992.02572,	277996.82934,	278001.63297,	278006.43661,	278011.24025,	278016.04390,	278020.84755,	278025.65121,
278030.45488,	278035.25856,	278040.06224,	278044.86593,	278049.66963,	278054.47333,	278059.27704,	278064.08075,	278068.88448,	278073.68821,
278078.49195,	278083.29569,	278088.09944,	278092.90320,	278097.70696,	278102.51073,	278107.31451,	278112.11830,	278116.92209,	278121.72589,
278126.52969,	278131.33350,	278136.13732,	278140.94115,	278145.74498,	278150.54882,	278155.35267,	278160.15652,	278164.96038,	278169.76424,
278174.56812,	278179.37200,	278184.17589,	278188.97978,	278193.78368,	278198.58759,	278203.39150,	278208.19542,	278212.99935,	278217.80329,
278222.60723,	278227.41118,	278232.21513,	278237.01909,	278241.82306,	278246.62704,	278251.43102,	278256.23501,	278261.03901,	278265.84301,
278270.64702,	278275.45104,	278280.25506,	278285.05909,	278289.86313,	278294.66717,	278299.47122,	278304.27528,	278309.07934,	278313.88342,
278318.68749,	278323.49158,	278328.29567,	278333.09977,	278337.90387,	278342.70799,	278347.51210,	278352.31623,	278357.12036,	278361.92450,
278366.72865,	278371.53280,	278376.33696,	278381.14113,	278385.94530,	278390.74948,	278395.55367,	278400.35786,	278405.16206,	278409.96627,
278414.77049,	278419.57471,	278424.37894,	278429.18317,	278433.98741,	278438.79166,	278443.59592,	278448.40018,	278453.20445,	278458.00872,
278462.81301,	278467.61729,	278472.42159,	278477.22589,	278482.03020,	278486.83452,	278491.63884,	278496.44317,	278501.24751,	278506.05186,
278510.85621,	278515.66056,	278520.46493,	278525.26930,	278530.07368,	278534.87806,	278539.68245,	278544.48685,	278549.29126,	278554.09567,
278558.90009,	278563.70451,	278568.50895,	278573.31339,	278578.11783,	278582.92228,	278587.72674,	278592.53121,	278597.33568,	278602.14016,
278606.94465,	278611.74915,	278616.55365,	278621.35815,	278626.16267,	278630.96719,	278635.77172,	278640.57625,	278645.38079,	278650.18534,
278654.98990,	278659.79446,	278664.59903,	278669.40360,	278674.20819,	278679.01277,	278683.81737,	278688.62197,	278693.42658,	278698.23120,
278703.03582,	278707.84045,	278712.64509,	278717.44973,	278722.25438,	278727.05904,	278731.86370,	278736.66838,	278741.47305,	278746.27774,
278751.08243,	278755.88713,	278760.69183,	278765.49654,	278770.30126,	278775.10599,	278779.91072,	278784.71546,	278789.52020,	278794.32496,
278799.12972,	278803.93448,	278808.73926,	278813.54404,	278818.34882,	278823.15362,	278827.95842,	278832.76322,	278837.56804,	278842.37286,
278847.17769,	278851.98252,	278856.78736,	278861.59221,	278866.39706,	278871.20192,	278876.00679,	278880.81167,	278885.61655,	278890.42144,
278895.22633,	278900.03124,	278904.83615,	278909.64106,	278914.44598,	278919.25091,	278924.05585,	278928.86079,	278933.66574,	278938.47070,
278943.27566,	278948.08063,	278952.88561,	278957.69060,	278962.49559,	278967.30058,	278972.10559,	278976.91060,	278981.71562,	278986.52064,
278991.32567,	278996.13071,	279000.93576,	279005.74081,	279010.54587,	279015.35093,	279020.15601,	279024.96109,	279029.76617,	279034.57127,
279039.37637,	279044.18147,	279048.98659,	279053.79171,	279058.59683,	279063.40197,	279068.20711,	279073.01225,	279077.81741,	279082.62257,
279087.42774,	279092.23291,	279097.03809,	279101.84328,	279106.64848,	279111.45368,	279116.25889,	279121.06410,	279125.86932,	279130.67455,
279135.47979,	279140.28503,	279145.09028,	279149.89554,	279154.70080,	279159.50607,	279164.31134,	279169.11663,	279173.92192,	279178.72721,
279183.53252,	279188.33783,	279193.14315,	279197.94847,	279202.75380,	279207.55914,	279212.36448,	279217.16983,	279221.97519,	279226.78056,
279231.58593,	279236.39131,	279241.19669,	279246.00209,	279250.80748,	279255.61289,	279260.41830,	279265.22372,	279270.02915,	279274.83458,
279279.64002,	279284.44547,	279289.25092,	279294.05638,	279298.86185,	279303.66732,	279308.47280,	279313.27829,	279318.08378,	279322.88928,
279327.69479,	279332.50031,	279337.30583,	279342.11136,	279346.91689,	279351.72243,	279356.52798,	279361.33354,	279366.13910,	279370.94467,
279375.75024,	279380.55582,	279385.36141,	279390.16701,	279394.97261,	279399.77822,	279404.58384,	279409.38946,	279414.19509,	279419.00073,
279423.80637,	279428.61202,	279433.41768,	279438.22334,	279443.02901,	279447.83469,	279452.64038,	279457.44607,	279462.25176,	279467.05747,
279471.86318,	279476.66890,	279481.47462,	279486.28036,	279491.08609,	279495.89184,	279500.69759,	279505.50335,	279510.30912,	279515.11489,
279519.92067,	279524.72646,	279529.53225,	279534.33805,	279539.14385,	279543.94967,	279548.75549,	279553.56132,	279558.36715,	279563.17299,
279567.97884,	279572.78469,	279577.59055,	279582.39642,	279587.20229,	279592.00818,	279596.81406,	279601.61996,	279606.42586,	279611.23177,
279616.03768,	279620.84361,	279625.64953,	279630.45547,	279635.26141,	279640.06736,	279644.87332,	279649.67928,	279654.48525,	279659.29123,
279664.09721,	279668.90320,	279673.70920,	279678.51520,	279683.32121,	279688.12723,	279692.93325,	279697.73928,	279702.54532,	279707.35136,
279712.15741,	279716.96347,	279721.76954,	279726.57561,	279731.38169,	279736.18777,	279740.99386,	279745.79996,	279750.60607,	279755.41218,
279760.21830,	279765.02442,	279769.83056,	279774.63670,	279779.44284,	279784.24899,	279789.05515,	279793.86132,	279798.66749,	279803.47367,
279808.27986,	279813.08605,	279817.89225,	279822.69846,	279827.50468,	279832.31090,	279837.11712,	279841.92336,	279846.72960,	279851.53585,
279856.34210,	279861.14836,	279865.95463,	279870.76091,	279875.56719,	279880.37348,	279885.17977,	279889.98607,	279894.79238,	279899.59870,
279904.40502,	279909.21135,	279914.01769,	279918.82403,	279923.63038,	279928.43673,	279933.24310,	279938.04947,	279942.85584,	279947.66223,
279952.46862,	279957.27502,	279962.08142,	279966.88783,	279971.69425,	279976.50067,	279981.30710,	279986.11354,	279990.91998,	279995.72644,
280000.53289,	280005.33936,	280010.14583,	280014.95231,	280019.75879,	280024.56529,	280029.37178,	280034.17829,	280038.98480,	280043.79132,
280048.59785,	280053.40438,	280058.21092,	280063.01747,	280067.82402,	280072.63058,	280077.43715,	280082.24372,	280087.05030,	280091.85689,
280096.66348,	280101.47008,	280106.27669,	280111.08330,	280115.88992,	280120.69655,	280125.50318,	280130.30983,	280135.11647,	280139.92313,
280144.72979,	280149.53646,	280154.34313,	280159.14982,	280163.95650,	280168.76320,	280173.56990,	280178.37661,	280183.18333,	280187.99005,
280192.79678,	280197.60351,	280202.41026,	280207.21701,	280212.02376,	280216.83053,	280221.63730,	280226.44407,	280231.25086,	280236.05765,
280240.86444,	280245.67125,	280250.47806,	280255.28488,	280260.09170,	280264.89853,	280269.70537,	280274.51221,	280279.31906,	280284.12592,
280288.93279,	280293.73966,	280298.54654,	280303.35342,	280308.16031,	280312.96721,	280317.77412,	280322.58103,	280327.38795,	280332.19487,
280337.00181,	280341.80875,	280346.61569,	280351.42265,	280356.22961,	280361.03657,	280365.84354,	280370.65052,	280375.45751,	280380.26450,
280385.07151,	280389.87851,	280394.68553,	280399.49255,	280404.29957,	280409.10661,	280413.91365,	280418.72070,	280423.52775,	280428.33481,
280433.14188,	280437.94896,	280442.75604,	280447.56313,	280452.37022,	280457.17732,	280461.98443,	280466.79155,	280471.59867,	280476.40580,
280481.21293,	280486.02008,	280490.82722,	280495.63438,	280500.44154,	280505.24871,	280510.05589,	280514.86307,	280519.67026,	280524.47746,
280529.28466,	280534.09187,	280538.89909,	280543.70631,	280548.51354,	280553.32078,	280558.12803,	280562.93528,	280567.74253,	280572.54980,
280577.35707,	280582.16435,	280586.97163,	280591.77892,	280596.58622,	280601.39353,	280606.20084,	280611.00816,	280615.81548,	280620.62281,
280625.43015,	280630.23750,	280635.04485,	280639.85221,	280644.65958,	280649.46695,	280654.27433,	280659.08171,	280663.88911,	280668.69651,
280673.50391,	280678.31133,	280683.11875,	280687.92617,	280692.73361,	280697.54105,	280702.34849,	280707.15595,	280711.96341,	280716.77088,
280721.57835,	280726.38583,	280731.19332,	280736.00081,	280740.80831,	280745.61582,	280750.42334,	280755.23086,	280760.03839,	280764.84592,
280769.65346,	280774.46101,	280779.26857,	280784.07613,	280788.88370,	280793.69127,	280798.49886,	280803.30645,	280808.11404,	280812.92164,
280817.72925,	280822.53687,	280827.34449,	280832.15212,	280836.95976,	280841.76740,	280846.57505,	280851.38271,	280856.19037,	280860.99804,
280865.80572,	280870.61340,	280875.42109,	280880.22879,	280885.03650,	280889.84421,	280894.65192,	280899.45965,	280904.26738,	280909.07512,
280913.88286,	280918.69061,	280923.49837,	280928.30614,	280933.11391,	280937.92169,	280942.72947,	280947.53726,	280952.34506,	280957.15287,
280961.96068,	280966.76850,	280971.57633,	280976.38416,	280981.19200,	280985.99984,	280990.80770,	280995.61556,	281000.42342,	281005.23130,
281010.03918,	281014.84706,	281019.65496,	281024.46286,	281029.27076,	281034.07868,	281038.88660,	281043.69452,	281048.50246,	281053.31040,
281058.11835,	281062.92630,	281067.73426,	281072.54223,	281077.35020,	281082.15819,	281086.96617,	281091.77417,	281096.58217,	281101.39018,
281106.19819,	281111.00621,	281115.81424,	281120.62228,	281125.43032,	281130.23837,	281135.04643,	281139.85449,	281144.66256,	281149.47063,
281154.27872,	281159.08680,	281163.89490,	281168.70300,	281173.51111,	281178.31923,	281183.12735,	281187.93548,	281192.74362,	281197.55176,
281202.35991,	281207.16807,	281211.97623,	281216.78440,	281221.59258,	281226.40077,	281231.20896,	281236.01715,	281240.82536,	281245.63357,
281250.44179,	281255.25001,	281260.05824,	281264.86648,	281269.67472,	281274.48298,	281279.29123,	281284.09950,	281288.90777,	281293.71605,
281298.52434,	281303.33263,	281308.14093,	281312.94923,	281317.75754,	281322.56586,	281327.37419,	281332.18252,	281336.99086,	281341.79921,
281346.60756,	281351.41592,	281356.22428,	281361.03266,	281365.84104,	281370.64942,	281375.45782,	281380.26622,	281385.07462,	281389.88304,
281394.69146,	281399.49989,	281404.30832,	281409.11676,	281413.92521,	281418.73366,	281423.54212,	281428.35059,	281433.15906,	281437.96754,
281442.77603,	281447.58453,	281452.39303,	281457.20154,	281462.01005,	281466.81857,	281471.62710,	281476.43564,	281481.24418,	281486.05273,
281490.86128,	281495.66984,	281500.47841,	281505.28699,	281510.09557,	281514.90416,	281519.71276,	281524.52136,	281529.32997,	281534.13858,
281538.94721,	281543.75584,	281548.56447,	281553.37311,	281558.18176,	281562.99042,	281567.79908,	281572.60775,	281577.41643,	281582.22511,
281587.03381,	281591.84250,	281596.65121,	281601.45992,	281606.26863,	281611.07736,	281615.88609,	281620.69483,	281625.50357,	281630.31232,
281635.12108,	281639.92984,	281644.73861,	281649.54739,	281654.35618,	281659.16497,	281663.97377,	281668.78257,	281673.59138,	281678.40020,
281683.20903,	281688.01786,	281692.82670,	281697.63554,	281702.44439,	281707.25325,	281712.06212,	281716.87099,	281721.67987,	281726.48876,
281731.29765,	281736.10655,	281740.91545,	281745.72437,	281750.53329,	281755.34221,	281760.15115,	281764.96009,	281769.76903,	281774.57799,
281779.38695,	281784.19591,	281789.00489,	281793.81387,	281798.62285,	281803.43185,	281808.24085,	281813.04986,	281817.85887,	281822.66789,
281827.47692,	281832.28595,	281837.09499,	281841.90404,	281846.71309,	281851.52216,	281856.33122,	281861.14030,	281865.94938,	281870.75847,
281875.56756,	281880.37666,	281885.18577,	281889.99489,	281894.80401,	281899.61314,	281904.42227,	281909.23142,	281914.04056,	281918.84972,
281923.65888,	281928.46805,	281933.27723,	281938.08641,	281942.89560,	281947.70479,	281952.51400,	281957.32321,	281962.13242,	281966.94165,
281971.75088,	281976.56011,	281981.36936,	281986.17861,	281990.98786,	281995.79713,	282000.60640,	282005.41567,	282010.22496,	282015.03425,
282019.84354,	282024.65285,	282029.46216,	282034.27147,	282039.08080,	282043.89013,	282048.69947,	282053.50881,	282058.31816,	282063.12752,
282067.93688,	282072.74626,	282077.55563,	282082.36502,	282087.17441,	282091.98381,	282096.79321,	282101.60262,	282106.41204,	282111.22147,
282116.03090,	282120.84034,	282125.64978,	282130.45923,	282135.26869,	282140.07816,	282144.88763,	282149.69711,	282154.50660,	282159.31609,
282164.12559,	282168.93509,	282173.74460,	282178.55412,	282183.36365,	282188.17318,	282192.98272,	282197.79227,	282202.60182,	282207.41138,
282212.22095,	282217.03052,	282221.84010,	282226.64969,	282231.45928,	282236.26888,	282241.07849,	282245.88810,	282250.69772,	282255.50735,
282260.31698,	282265.12662,	282269.93627,	282274.74592,	282279.55559,	282284.36525,	282289.17493,	282293.98461,	282298.79430,	282303.60399,
282308.41369,	282313.22340,	282318.03311,	282322.84283,	282327.65256,	282332.46230,	282337.27204,	282342.08179,	282346.89154,	282351.70130,
282356.51107,	282361.32085,	282366.13063,	282370.94042,	282375.75021,	282380.56001,	282385.36982,	282390.17964,	282394.98946,	282399.79929,
282404.60913,	282409.41897,	282414.22882,	282419.03867,	282423.84854,	282428.65841,	282433.46828,	282438.27816,	282443.08805,	282447.89795,
282452.70785,	282457.51776,	282462.32768,	282467.13760,	282471.94753,	282476.75747,	282481.56741,	282486.37736,	282491.18732,	282495.99728,
282500.80725,	282505.61723,	282510.42721,	282515.23720,	282520.04720,	282524.85720,	282529.66722,	282534.47723,	282539.28726,	282544.09729,
282548.90733,	282553.71737,	282558.52742,	282563.33748,	282568.14754,	282572.95761,	282577.76769,	282582.57778,	282587.38787,	282592.19797,
282597.00807,	282601.81818,	282606.62830,	282611.43842,	282616.24856,	282621.05869,	282625.86884,	282630.67899,	282635.48915,	282640.29932,
282645.10949,	282649.91967,	282654.72985,	282659.54004,	282664.35024,	282669.16045,	282673.97066,	282678.78088,	282683.59111,	282688.40134,
282693.21158,	282698.02182,	282702.83208,	282707.64234,	282712.45260,	282717.26287,	282722.07315,	282726.88344,	282731.69373,	282736.50403,
282741.31434,	282746.12465,	282750.93497,	282755.74530,	282760.55563,	282765.36597,	282770.17632,	282774.98667,	282779.79703,	282784.60740,
282789.41777,	282794.22815,	282799.03854,	282803.84894,	282808.65934,	282813.46974,	282818.28016,	282823.09058,	282827.90101,	282832.71144,
282837.52188,	282842.33233,	282847.14278,	282851.95324,	282856.76371,	282861.57419,	282866.38467,	282871.19515,	282876.00565,	282880.81615,
282885.62666,	282890.43717,	282895.24769,	282900.05822,	282904.86876,	282909.67930,	282914.48985,	282919.30040,	282924.11097,	282928.92153,
282933.73211,	282938.54269,	282943.35328,	282948.16387,	282952.97448,	282957.78509,	282962.59570,	282967.40632,	282972.21695,	282977.02759,
282981.83823,	282986.64888,	282991.45954,	282996.27020,	283001.08087,	283005.89154,	283010.70223,	283015.51292,	283020.32361,	283025.13431,
283029.94502,	283034.75574,	283039.56646,	283044.37719,	283049.18793,	283053.99867,	283058.80942,	283063.62018,	283068.43094,	283073.24171,
283078.05249,	283082.86327,	283087.67406,	283092.48486,	283097.29566,	283102.10647,	283106.91729,	283111.72811,	283116.53894,	283121.34978,
283126.16063,	283130.97148,	283135.78233,	283140.59320,	283145.40407,	283150.21495,	283155.02583,	283159.83672,	283164.64762,	283169.45852,
283174.26943,	283179.08035,	283183.89128,	283188.70221,	283193.51314,	283198.32409,	283203.13504,	283207.94600,	283212.75696,	283217.56793,
283222.37891,	283227.18990,	283232.00089,	283236.81189,	283241.62289,	283246.43390,	283251.24492,	283256.05595,	283260.86698,	283265.67802,
283270.48906,	283275.30011,	283280.11117,	283284.92224,	283289.73331,	283294.54439,	283299.35548,	283304.16657,	283308.97767,	283313.78877,
283318.59988,	283323.41100,	283328.22213,	283333.03326,	283337.84440,	283342.65555,	283347.46670,	283352.27786,	283357.08902,	283361.90020,
283366.71138,	283371.52256,	283376.33376,	283381.14495,	283385.95616,	283390.76737,	283395.57859,	283400.38982,	283405.20105,	283410.01229,
283414.82354,	283419.63479,	283424.44605,	283429.25732,	283434.06859,	283438.87987,	283443.69116,	283448.50245,	283453.31375,	283458.12506,
283462.93637,	283467.74769,	283472.55902,	283477.37035,	283482.18169,	283486.99304,	283491.80440,	283496.61576,	283501.42712,	283506.23850,
283511.04988,	283515.86126,	283520.67266,	283525.48406,	283530.29547,	283535.10688,	283539.91830,	283544.72973,	283549.54116,	283554.35260,
283559.16405,	283563.97551,	283568.78697,	283573.59844,	283578.40991,	283583.22139,	283588.03288,	283592.84437,	283597.65587,	283602.46738,
283607.27890,	283612.09042,	283616.90195,	283621.71348,	283626.52502,	283631.33657,	283636.14813,	283640.95969,	283645.77126,	283650.58283,
283655.39441,	283660.20600,	283665.01760,	283669.82920,	283674.64081,	283679.45242,	283684.26404,	283689.07567,	283693.88731,	283698.69895,
283703.51060,	283708.32225,	283713.13392,	283717.94558,	283722.75726,	283727.56894,	283732.38063,	283737.19233,	283742.00403,	283746.81574,
283751.62745,	283756.43918,	283761.25091,	283766.06264,	283770.87438,	283775.68613,	283780.49789,	283785.30965,	283790.12142,	283794.93320,
283799.74498,	283804.55677,	283809.36857,	283814.18037,	283818.99218,	283823.80399,	283828.61582,	283833.42765,	283838.23948,	283843.05133,
283847.86318,	283852.67503,	283857.48690,	283862.29876,	283867.11064,	283871.92252,	283876.73441,	283881.54631,	283886.35821,	283891.17012,
283895.98204,	283900.79396,	283905.60589,	283910.41783,	283915.22977,	283920.04172,	283924.85368,	283929.66565,	283934.47762,	283939.28959,
283944.10158,	283948.91357,	283953.72556,	283958.53757,	283963.34958,	283968.16159,	283972.97362,	283977.78565,	283982.59769,	283987.40973,
283992.22178,	283997.03384,	284001.84590,	284006.65797,	284011.47005,	284016.28213,	284021.09422,	284025.90632,	284030.71843,	284035.53054,
284040.34265,	284045.15478,	284049.96691,	284054.77905,	284059.59119,	284064.40334,	284069.21550,	284074.02766,	284078.83984,	284083.65201,
284088.46420,	284093.27639,	284098.08859,	284102.90079,	284107.71300,	284112.52522,	284117.33745,	284122.14968,	284126.96191,	284131.77416,
284136.58641,	284141.39867,	284146.21093,	284151.02321,	284155.83548,	284160.64777,	284165.46006,	284170.27236,	284175.08466,	284179.89697,
284184.70929,	284189.52162,	284194.33395,	284199.14629,	284203.95863,	284208.77098,	284213.58334,	284218.39571,	284223.20808,	284228.02046,
284232.83284,	284237.64524,	284242.45763,	284247.27004,	284252.08245,	284256.89487,	284261.70730,	284266.51973,	284271.33217,	284276.14461,
284280.95706,	284285.76952,	284290.58199,	284295.39446,	284300.20694,	284305.01942,	284309.83192,	284314.64442,	284319.45692,	284324.26943,
284329.08195,	284333.89448,	284338.70701,	284343.51955,	284348.33210,	284353.14465,	284357.95721,	284362.76977,	284367.58235,	284372.39492,
284377.20751,	284382.02010,	284386.83270,	284391.64531,	284396.45792,	284401.27054,	284406.08317,	284410.89580,	284415.70844,	284420.52108,
284425.33374,	284430.14640,	284434.95906,	284439.77173,	284444.58441,	284449.39710,	284454.20979,	284459.02249,	284463.83520,	284468.64791,
284473.46063,	284478.27336,	284483.08609,	284487.89883,	284492.71158,	284497.52433,	284502.33709,	284507.14985,	284511.96263,	284516.77541,
284521.58819,	284526.40099,	284531.21379,	284536.02659,	284540.83941,	284545.65223,	284550.46505,	284555.27789,	284560.09073,	284564.90357,
284569.71643,	284574.52929,	284579.34215,	284584.15503,	284588.96791,	284593.78079,	284598.59369,	284603.40659,	284608.21949,	284613.03241,
284617.84533,	284622.65825,	284627.47119,	284632.28413,	284637.09707,	284641.91003,	284646.72299,	284651.53595,	284656.34893,	284661.16191,
284665.97489,	284670.78789,	284675.60089,	284680.41389,	284685.22691,	284690.03993,	284694.85295,	284699.66599,	284704.47903,	284709.29208,
284714.10513,	284718.91819,	284723.73126,	284728.54433,	284733.35741,	284738.17050,	284742.98359,	284747.79669,	284752.60980,	284757.42291,
284762.23603,	284767.04916,	284771.86229,	284776.67543,	284781.48858,	284786.30174,	284791.11490,	284795.92806,	284800.74124,	284805.55442,
284810.36760,	284815.18080,	284819.99400,	284824.80721,	284829.62042,	284834.43364,	284839.24687,	284844.06010,	284848.87334,	284853.68659,
284858.49984,	284863.31310,	284868.12637,	284872.93965,	284877.75293,	284882.56621,	284887.37951,	284892.19281,	284897.00612,	284901.81943,
284906.63275,	284911.44608,	284916.25941,	284921.07275,	284925.88610,	284930.69945,	284935.51282,	284940.32618,	284945.13956,	284949.95294,
284954.76633,	284959.57972,	284964.39312,	284969.20653,	284974.01994,	284978.83336,	284983.64679,	284988.46022,	284993.27367,	284998.08711,
285002.90057,	285007.71403,	285012.52750,	285017.34097,	285022.15445,	285026.96794,	285031.78143,	285036.59493,	285041.40844,	285046.22196,
285051.03548,	285055.84900,	285060.66254,	285065.47608,	285070.28963,	285075.10318,	285079.91674,	285084.73031,	285089.54388,	285094.35746,
285099.17105,	285103.98465,	285108.79825,	285113.61186,	285118.42547,	285123.23909,	285128.05272,	285132.86635,	285137.67999,	285142.49364,
285147.30730,	285152.12096,	285156.93462,	285161.74830,	285166.56198,	285171.37567,	285176.18936,	285181.00306,	285185.81677,	285190.63049,
285195.44421,	285200.25793,	285205.07167,	285209.88541,	285214.69916,	285219.51291,	285224.32667,	285229.14044,	285233.95422,	285238.76800,
285243.58178,	285248.39558,	285253.20938,	285258.02319,	285262.83700,	285267.65082,	285272.46465,	285277.27848,	285282.09233,	285286.90617,
285291.72003,	285296.53389,	285301.34776,	285306.16163,	285310.97551,	285315.78940,	285320.60329,	285325.41720,	285330.23110,	285335.04502,
285339.85894,	285344.67287,	285349.48680,	285354.30074,	285359.11469,	285363.92864,	285368.74261,	285373.55657,	285378.37055,	285383.18453,
285387.99852,	285392.81251,	285397.62651,	285402.44052,	285407.25453,	285412.06856,	285416.88258,	285421.69662,	285426.51066,	285431.32471,
285436.13876,	285440.95282,	285445.76689,	285450.58096,	285455.39504,	285460.20913,	285465.02323,	285469.83733,	285474.65144,	285479.46555,
285484.27967,	285489.09380,	285493.90793,	285498.72207,	285503.53622,	285508.35038,	285513.16454,	285517.97870,	285522.79288,	285527.60706,
285532.42125,	285537.23544,	285542.04964,	285546.86385,	285551.67806,	285556.49229,	285561.30651,	285566.12075,	285570.93499,	285575.74924,
285580.56349,	285585.37775,	285590.19202,	285595.00629,	285599.82057,	285604.63486,	285609.44916,	285614.26346,	285619.07776,	285623.89208,
285628.70640,	285633.52073,	285638.33506,	285643.14940,	285647.96375,	285652.77810,	285657.59246,	285662.40683,	285667.22121,	285672.03559,
285676.84997,	285681.66437,	285686.47877,	285691.29318,	285696.10759,	285700.92201,	285705.73644,	285710.55087,	285715.36531,	285720.17976,
285724.99421,	285729.80868,	285734.62314,	285739.43762,	285744.25210,	285749.06658,	285753.88108,	285758.69558,	285763.51009,	285768.32460,
285773.13912,	285777.95365,	285782.76818,	285787.58272,	285792.39727,	285797.21182,	285802.02638,	285806.84095,	285811.65553,	285816.47011,
285821.28469,	285826.09929,	285830.91389,	285835.72849,	285840.54311,	285845.35773,	285850.17236,	285854.98699,	285859.80163,	285864.61628,
285869.43093,	285874.24559,	285879.06026,	285883.87493,	285888.68961,	285893.50430,	285898.31899,	285903.13369,	285907.94840,	285912.76311,
285917.57783,	285922.39256,	285927.20729,	285932.02204,	285936.83678,	285941.65154,	285946.46630,	285951.28106,	285956.09584,	285960.91062,
285965.72540,	285970.54020,	285975.35500,	285980.16980,	285984.98462,	285989.79944,	285994.61426,	285999.42910,	286004.24394,	286009.05878,
286013.87364,	286018.68850,	286023.50336,	286028.31824,	286033.13312,	286037.94800,	286042.76290,	286047.57780,	286052.39270,	286057.20762,
286062.02254,	286066.83746,	286071.65240,	286076.46734,	286081.28228,	286086.09723,	286090.91219,	286095.72716,	286100.54213,	286105.35711,
286110.17210,	286114.98709,	286119.80209,	286124.61710,	286129.43211,	286134.24713,	286139.06216,	286143.87719,	286148.69223,	286153.50728,
286158.32233,	286163.13739,	286167.95245,	286172.76753,	286177.58261,	286182.39769,	286187.21279,	286192.02788,	286196.84299,	286201.65810,
286206.47322,	286211.28835,	286216.10348,	286220.91862,	286225.73377,	286230.54892,	286235.36408,	286240.17924,	286244.99442,	286249.80960,
286254.62478,	286259.43997,	286264.25517,	286269.07038,	286273.88559,	286278.70081,	286283.51604,	286288.33127,	286293.14651,	286297.96175,
286302.77700,	286307.59226,	286312.40753,	286317.22280,	286322.03808,	286326.85337,	286331.66866,	286336.48396,	286341.29926,	286346.11457,
286350.92989,	286355.74522,	286360.56055,	286365.37589,	286370.19123,	286375.00659,	286379.82194,	286384.63731,	286389.45268,	286394.26806,
286399.08345,	286403.89884,	286408.71424,	286413.52964,	286418.34505,	286423.16047,	286427.97590,	286432.79133,	286437.60677,	286442.42221,
286447.23766,	286452.05312,	286456.86858,	286461.68406,	286466.49953,	286471.31502,	286476.13051,	286480.94601,	286485.76151,	286490.57702,
286495.39254,	286500.20807,	286505.02360,	286509.83914,	286514.65468,	286519.47023,	286524.28579,	286529.10135,	286533.91693,	286538.73250,
286543.54809,	286548.36368,	286553.17928,	286557.99488,	286562.81049,	286567.62611,	286572.44173,	286577.25736,	286582.07300,	286586.88865,
286591.70430,	286596.51995,	286601.33562,	286606.15129,	286610.96697,	286615.78265,	286620.59834,	286625.41404,	286630.22974,	286635.04545,
286639.86117,	286644.67689,	286649.49262,	286654.30836,	286659.12410,	286663.93986,	286668.75561,	286673.57138,	286678.38715,	286683.20292,
286688.01871,	286692.83450,	286697.65029,	286702.46610,	286707.28191,	286712.09772,	286716.91355,	286721.72938,	286726.54521,	286731.36106,
286736.17691,	286740.99276,	286745.80863,	286750.62450,	286755.44037,	286760.25626,	286765.07215,	286769.88804,	286774.70395,	286779.51986,
286784.33577,	286789.15169,	286793.96762,	286798.78356,	286803.59950,	286808.41545,	286813.23141,	286818.04737,	286822.86334,	286827.67932,
286832.49530,	286837.31129,	286842.12728,	286846.94329,	286851.75930,	286856.57531,	286861.39133,	286866.20736,	286871.02340,	286875.83944,
286880.65549,	286885.47155,	286890.28761,	286895.10368,	286899.91975,	286904.73583,	286909.55192,	286914.36802,	286919.18412,	286924.00023,
286928.81635,	286933.63247,	286938.44860,	286943.26473,	286948.08087,	286952.89702,	286957.71318,	286962.52934,	286967.34551,	286972.16168,
286976.97786,	286981.79405,	286986.61025,	286991.42645,	286996.24266,	287001.05887,	287005.87509,	287010.69132,	287015.50755,	287020.32380,
287025.14004,	287029.95630,	287034.77256,	287039.58883,	287044.40510,	287049.22138,	287054.03767,	287058.85397,	287063.67027,	287068.48657,
287073.30289,	287078.11921,	287082.93554,	287087.75187,	287092.56821,	287097.38456,	287102.20091,	287107.01727,	287111.83364,	287116.65001,
287121.46639,	287126.28278,	287131.09918,	287135.91558,	287140.73198,	287145.54840,	287150.36482,	287155.18124,	287159.99768,	287164.81412,
287169.63056,	287174.44702,	287179.26348,	287184.07994,	287188.89642,	287193.71290,	287198.52938,	287203.34588,	287208.16238,	287212.97888,
287217.79540,	287222.61192,	287227.42844,	287232.24498,	287237.06152,	287241.87806,	287246.69461,	287251.51117,	287256.32774,	287261.14431,
287265.96089,	287270.77748,	287275.59407,	287280.41067,	287285.22728,	287290.04389,	287294.86051,	287299.67713,	287304.49376,	287309.31040,
287314.12705,	287318.94370,	287323.76036,	287328.57703,	287333.39370,	287338.21038,	287343.02706,	287347.84375,	287352.66045,	287357.47716,
287362.29387,	287367.11059,	287371.92731,	287376.74404,	287381.56078,	287386.37753,	287391.19428,	287396.01104,	287400.82780,	287405.64457,
287410.46135,	287415.27814,	287420.09493,	287424.91173,	287429.72853,	287434.54534,	287439.36216,	287444.17898,	287448.99581,	287453.81265,
287458.62950,	287463.44635,	287468.26320,	287473.08007,	287477.89694,	287482.71382,	287487.53070,	287492.34759,	287497.16449,	287501.98139,
287506.79830,	287511.61522,	287516.43214,	287521.24907,	287526.06601,	287530.88295,	287535.69990,	287540.51686,	287545.33383,	287550.15080,
287554.96777,	287559.78476,	287564.60174,	287569.41874,	287574.23574,	287579.05275,	287583.86977,	287588.68679,	287593.50382,	287598.32086,
287603.13790,	287607.95495,	287612.77201,	287617.58907,	287622.40614,	287627.22322,	287632.04030,	287636.85739,	287641.67448,	287646.49159,
287651.30869,	287656.12581,	287660.94293,	287665.76006,	287670.57720,	287675.39434,	287680.21149,	287685.02864,	287689.84581,	287694.66297,
287699.48015,	287704.29733,	287709.11452,	287713.93171,	287718.74892,	287723.56612,	287728.38334,	287733.20056,	287738.01779,	287742.83502,
287747.65226,	287752.46951,	287757.28677,	287762.10403,	287766.92130,	287771.73857,	287776.55585,	287781.37314,	287786.19043,	287791.00773,
287795.82504,	287800.64236,	287805.45968,	287810.27700,	287815.09434,	287819.91168,	287824.72903,	287829.54638,	287834.36374,	287839.18111,
287843.99848,	287848.81586,	287853.63325,	287858.45064,	287863.26804,	287868.08545,	287872.90286,	287877.72028,	287882.53771,	287887.35514,
287892.17258,	287896.99003,	287901.80748,	287906.62494,	287911.44241,	287916.25988,	287921.07736,	287925.89484,	287930.71234,	287935.52984,
287940.34734,	287945.16485,	287949.98237,	287954.79990,	287959.61743,	287964.43497,	287969.25252,	287974.07007,	287978.88763,	287983.70519,
287988.52276,	287993.34034,	287998.15793,	288002.97552,	288007.79312,	288012.61072,	288017.42833,	288022.24595,	288027.06358,	288031.88121,
288036.69885,	288041.51649,	288046.33414,	288051.15180,	288055.96947,	288060.78714,	288065.60481,	288070.42250,	288075.24019,	288080.05789,
288084.87559,	288089.69330,	288094.51102,	288099.32874,	288104.14647,	288108.96421,	288113.78196,	288118.59971,	288123.41746,	288128.23523,
288133.05300,	288137.87077,	288142.68856,	288147.50635,	288152.32414,	288157.14195,	288161.95976,	288166.77757,	288171.59540,	288176.41323,
288181.23106,	288186.04891,	288190.86676,	288195.68461,	288200.50247,	288205.32034,	288210.13822,	288214.95610,	288219.77399,	288224.59189,
288229.40979,	288234.22770,	288239.04561,	288243.86354,	288248.68146,	288253.49940,	288258.31734,	288263.13529,	288267.95325,	288272.77121,
288277.58918,	288282.40715,	288287.22513,	288292.04312,	288296.86112,	288301.67912,	288306.49712,	288311.31514,	288316.13316,	288320.95119,
288325.76922,	288330.58726,	288335.40531,	288340.22337,	288345.04143,	288349.85949,	288354.67757,	288359.49565,	288364.31374,	288369.13183,
288373.94993,	288378.76804,	288383.58615,	288388.40427,	288393.22240,	288398.04053,	288402.85867,	288407.67682,	288412.49497,	288417.31313,
288422.13130,	288426.94947,	288431.76765,	288436.58584,	288441.40403,	288446.22223,	288451.04044,	288455.85865,	288460.67687,	288465.49509,
288470.31333,	288475.13157,	288479.94981,	288484.76806,	288489.58632,	288494.40459,	288499.22286,	288504.04114,	288508.85942,	288513.67772,
288518.49601,	288523.31432,	288528.13263,	288532.95095,	288537.76927,	288542.58761,	288547.40594,	288552.22429,	288557.04264,	288561.86100,
288566.67936,	288571.49773,	288576.31611,	288581.13450,	288585.95289,	288590.77128,	288595.58969,	288600.40810,	288605.22652,	288610.04494,
288614.86337,	288619.68181,	288624.50025,	288629.31870,	288634.13716,	288638.95562,	288643.77409,	288648.59257,	288653.41105,	288658.22954,
288663.04804,	288667.86654,	288672.68505,	288677.50357,	288682.32209,	288687.14062,	288691.95915,	288696.77770,	288701.59625,	288706.41480,
288711.23336,	288716.05193,	288720.87051,	288725.68909,	288730.50768,	288735.32627,	288740.14488,	288744.96349,	288749.78210,	288754.60072,
288759.41935,	288764.23799,	288769.05663,	288773.87528,	288778.69393,	288783.51259,	288788.33126,	288793.14993,	288797.96861,	288802.78730,
288807.60600,	288812.42470,	288817.24340,	288822.06212,	288826.88084,	288831.69957,	288836.51830,	288841.33704,	288846.15579,	288850.97454,
288855.79330,	288860.61207,	288865.43084,	288870.24962,	288875.06841,	288879.88720,	288884.70600,	288889.52481,	288894.34362,	288899.16244,
288903.98127,	288908.80010,	288913.61894,	288918.43778,	288923.25664,	288928.07550,	288932.89436,	288937.71323,	288942.53211,	288947.35100,
288952.16989,	288956.98879,	288961.80769,	288966.62661,	288971.44552,	288976.26445,	288981.08338,	288985.90232,	288990.72126,	288995.54021,
289000.35917,	289005.17814,	289009.99711,	289014.81609,	289019.63507,	289024.45406,	289029.27306,	289034.09206,	289038.91107,	289043.73009,
289048.54911,	289053.36814,	289058.18718,	289063.00622,	289067.82527,	289072.64433,	289077.46339,	289082.28246,	289087.10154,	289091.92062,
289096.73971,	289101.55881,	289106.37791,	289111.19702,	289116.01614,	289120.83526,	289125.65439,	289130.47353,	289135.29267,	289140.11182,
289144.93097,	289149.75013,	289154.56930,	289159.38848,	289164.20766,	289169.02685,	289173.84604,	289178.66525,	289183.48445,	289188.30367,
289193.12289,	289197.94212,	289202.76135,	289207.58059,	289212.39984,	289217.21910,	289222.03836,	289226.85762,	289231.67690,	289236.49618,
289241.31547,	289246.13476,	289250.95406,	289255.77337,	289260.59268,	289265.41200,	289270.23133,	289275.05066,	289279.87000,	289284.68935,
289289.50870,	289294.32806,	289299.14743,	289303.96680,	289308.78618,	289313.60556,	289318.42496,	289323.24436,	289328.06376,	289332.88317,
289337.70259,	289342.52202,	289347.34145,	289352.16089,	289356.98033,	289361.79979,	289366.61924,	289371.43871,	289376.25818,	289381.07766,
289385.89714,	289390.71664,	289395.53613,	289400.35564,	289405.17515,	289409.99467,	289414.81419,	289419.63372,	289424.45326,	289429.27280,
289434.09235,	289438.91191,	289443.73147,	289448.55104,	289453.37062,	289458.19020,	289463.00979,	289467.82939,	289472.64899,	289477.46860,
289482.28822,	289487.10784,	289491.92747,	289496.74711,	289501.56675,	289506.38640,	289511.20606,	289516.02572,	289520.84539,	289525.66506,
289530.48475,	289535.30443,	289540.12413,	289544.94383,	289549.76354,	289554.58325,	289559.40298,	289564.22270,	289569.04244,	289573.86218,
289578.68193,	289583.50168,	289588.32144,	289593.14121,	289597.96099,	289602.78077,	289607.60055,	289612.42035,	289617.24015,	289622.05995,
289626.87977,	289631.69959,	289636.51942,	289641.33925,	289646.15909,	289650.97894,	289655.79879,	289660.61865,	289665.43851,	289670.25839,
289675.07827,	289679.89815,	289684.71804,	289689.53794,	289694.35785,	289699.17776,	289703.99768,	289708.81761,	289713.63754,	289718.45748,
289723.27742,	289728.09737,	289732.91733,	289737.73730,	289742.55727,	289747.37725,	289752.19723,	289757.01722,	289761.83722,	289766.65722,
289771.47723,	289776.29725,	289781.11728,	289785.93731,	289790.75734,	289795.57739,	289800.39744,	289805.21750,	289810.03756,	289814.85763,
289819.67771,	289824.49779,	289829.31788,	289834.13797,	289838.95808,	289843.77819,	289848.59830,	289853.41843,	289858.23855,	289863.05869,
289867.87883,	289872.69898,	289877.51914,	289882.33930,	289887.15947,	289891.97964,	289896.79982,	289901.62001,	289906.44021,	289911.26041,
289916.08062,	289920.90083,	289925.72105,	289930.54128,	289935.36152,	289940.18176,	289945.00200,	289949.82226,	289954.64252,	289959.46279,
289964.28306,	289969.10334,	289973.92363,	289978.74392,	289983.56422,	289988.38453,	289993.20484,	289998.02516,	290002.84549,	290007.66582,
290012.48616,	290017.30650,	290022.12686,	290026.94722,	290031.76758,	290036.58795,	290041.40833,	290046.22872,	290051.04911,	290055.86951,
290060.68991,	290065.51032,	290070.33074,	290075.15117,	290079.97160,	290084.79204,	290089.61248,	290094.43293,	290099.25339,	290104.07385,
290108.89433,	290113.71480,	290118.53529,	290123.35578,	290128.17627,	290132.99678,	290137.81729,	290142.63780,	290147.45833,	290152.27886,
290157.09939,	290161.91994,	290166.74049,	290171.56104,	290176.38161,	290181.20217,	290186.02275,	290190.84333,	290195.66392,	290200.48452,
290205.30512,	290210.12573,	290214.94634,	290219.76696,	290224.58759,	290229.40823,	290234.22887,	290239.04952,	290243.87017,	290248.69083,
290253.51150,	290258.33217,	290263.15286,	290267.97354,	290272.79424,	290277.61494,	290282.43564,	290287.25636,	290292.07708,	290296.89781,
290301.71854,	290306.53928,	290311.36002,	290316.18078,	290321.00154,	290325.82230,	290330.64308,	290335.46386,	290340.28464,	290345.10543,
290349.92623,	290354.74704,	290359.56785,	290364.38867,	290369.20949,	290374.03033,	290378.85116,	290383.67201,	290388.49286,	290393.31372,
290398.13458,	290402.95545,	290407.77633,	290412.59722,	290417.41811,	290422.23900,	290427.05991,	290431.88082,	290436.70174,	290441.52266,
290446.34359,	290451.16453,	290455.98547,	290460.80642,	290465.62738,	290470.44834,	290475.26931,	290480.09028,	290484.91127,	290489.73226,
290494.55325,	290499.37425,	290504.19526,	290509.01628,	290513.83730,	290518.65833,	290523.47936,	290528.30041,	290533.12145,	290537.94251,
290542.76357,	290547.58464,	290552.40571,	290557.22679,	290562.04788,	290566.86897,	290571.69008,	290576.51118,	290581.33230,	290586.15342,
290590.97454,	290595.79568,	290600.61682,	290605.43796,	290610.25912,	290615.08028,	290619.90144,	290624.72261,	290629.54379,	290634.36498,
290639.18617,	290644.00737,	290648.82858,	290653.64979,	290658.47101,	290663.29223,	290668.11346,	290672.93470,	290677.75595,	290682.57720,
290687.39846,	290692.21972,	290697.04099,	290701.86227,	290706.68355,	290711.50485,	290716.32614,	290721.14745,	290725.96876,	290730.79007,
290735.61140,	290740.43273,	290745.25406,	290750.07541,	290754.89676,	290759.71811,	290764.53948,	290769.36085,	290774.18222,	290779.00360,
290783.82499,	290788.64639,	290793.46779,	290798.28920,	290803.11062,	290807.93204,	290812.75347,	290817.57490,	290822.39634,	290827.21779,
290832.03924,	290836.86071,	290841.68217,	290846.50365,	290851.32513,	290856.14662,	290860.96811,	290865.78961,	290870.61112,	290875.43263,
290880.25415,	290885.07568,	290889.89721,	290894.71875,	290899.54030,	290904.36185,	290909.18341,	290914.00497,	290918.82655,	290923.64813,
290928.46971,	290933.29130,	290938.11290,	290942.93451,	290947.75612,	290952.57774,	290957.39936,	290962.22099,	290967.04263,	290971.86428,
290976.68593,	290981.50758,	290986.32925,	290991.15092,	290995.97260,	291000.79428,	291005.61597,	291010.43767,	291015.25937,	291020.08108,
291024.90280,	291029.72452,	291034.54625,	291039.36799,	291044.18973,	291049.01148,	291053.83323,	291058.65500,	291063.47677,	291068.29854,
291073.12032,	291077.94211,	291082.76391,	291087.58571,	291092.40752,	291097.22933,	291102.05115,	291106.87298,	291111.69482,	291116.51666,
291121.33850,	291126.16036,	291130.98222,	291135.80409,	291140.62596,	291145.44784,	291150.26973,	291155.09162,	291159.91352,	291164.73543,
291169.55734,	291174.37926,	291179.20118,	291184.02312,	291188.84506,	291193.66700,	291198.48895,	291203.31091,	291208.13288,	291212.95485,
291217.77683,	291222.59881,	291227.42080,	291232.24280,	291237.06481,	291241.88682,	291246.70884,	291251.53086,	291256.35289,	291261.17493,
291265.99697,	291270.81902,	291275.64108,	291280.46314,	291285.28521,	291290.10729,	291294.92937,	291299.75146,	291304.57356,	291309.39566,
291314.21777,	291319.03988,	291323.86201,	291328.68414,	291333.50627,	291338.32841,	291343.15056,	291347.97272,	291352.79488,	291357.61705,
291362.43922,	291367.26140,	291372.08359,	291376.90578,	291381.72798,	291386.55019,	291391.37241,	291396.19463,	291401.01685,	291405.83909,
291410.66133,	291415.48357,	291420.30583,	291425.12809,	291429.95035,	291434.77262,	291439.59490,	291444.41719,	291449.23948,	291454.06178,
291458.88409,	291463.70640,	291468.52872,	291473.35104,	291478.17337,	291482.99571,	291487.81806,	291492.64041,	291497.46277,	291502.28513,
291507.10750,	291511.92988,	291516.75226,	291521.57465,	291526.39705,	291531.21945,	291536.04186,	291540.86428,	291545.68670,	291550.50913,
291555.33157,	291560.15401,	291564.97646,	291569.79892,	291574.62138,	291579.44385,	291584.26632,	291589.08880,	291593.91129,	291598.73379,
291603.55629,	291608.37880,	291613.20131,	291618.02383,	291622.84636,	291627.66889,	291632.49144,	291637.31398,	291642.13654,	291646.95910,
291651.78166,	291656.60424,	291661.42682,	291666.24940,	291671.07200,	291675.89460,	291680.71720,	291685.53981,	291690.36243,	291695.18506,
291700.00769,	291704.83033,	291709.65298,	291714.47563,	291719.29829,	291724.12095,	291728.94362,	291733.76630,	291738.58898,	291743.41168,
291748.23437,	291753.05708,	291757.87979,	291762.70250,	291767.52523,	291772.34796,	291777.17070,	291781.99344,	291786.81619,	291791.63894,
291796.46171,	291801.28448,	291806.10725,	291810.93004,	291815.75282,	291820.57562,	291825.39842,	291830.22123,	291835.04405,	291839.86687,
291844.68970,	291849.51253,	291854.33537,	291859.15822,	291863.98107,	291868.80393,	291873.62680,	291878.44968,	291883.27256,	291888.09544,
291892.91834,	291897.74124,	291902.56414,	291907.38706,	291912.20998,	291917.03290,	291921.85583,	291926.67877,	291931.50172,	291936.32467,
291941.14763,	291945.97060,	291950.79357,	291955.61655,	291960.43953,	291965.26252,	291970.08552,	291974.90852,	291979.73154,	291984.55455,
291989.37758,	291994.20061,	291999.02364,	292003.84669,	292008.66974,	292013.49280,	292018.31586,	292023.13893,	292027.96200,	292032.78509,
292037.60818,	292042.43127,	292047.25437,	292052.07748,	292056.90060,	292061.72372,	292066.54685,	292071.36998,	292076.19313,	292081.01627,
292085.83943,	292090.66259,	292095.48576,	292100.30893,	292105.13211,	292109.95530,	292114.77849,	292119.60169,	292124.42490,	292129.24811,
292134.07133,	292138.89456,	292143.71779,	292148.54103,	292153.36428,	292158.18753,	292163.01079,	292167.83406,	292172.65733,	292177.48061,
292182.30389,	292187.12718,	292191.95048,	292196.77379,	292201.59710,	292206.42041,	292211.24374,	292216.06707,	292220.89041,	292225.71375,
292230.53710,	292235.36046,	292240.18382,	292245.00719,	292249.83057,	292254.65395,	292259.47734,	292264.30074,	292269.12414,	292273.94755,
292278.77096,	292283.59438,	292288.41781,	292293.24125,	292298.06469,	292302.88814,	292307.71159,	292312.53505,	292317.35852,	292322.18200,
292327.00548,	292331.82896,	292336.65246,	292341.47596,	292346.29946,	292351.12298,	292355.94650,	292360.77002,	292365.59356,	292370.41710,
292375.24064,	292380.06419,	292384.88775,	292389.71132,	292394.53489,	292399.35847,	292404.18206,	292409.00565,	292413.82924,	292418.65285,
292423.47646,	292428.30008,	292433.12370,	292437.94733,	292442.77097,	292447.59461,	292452.41826,	292457.24192,	292462.06558,	292466.88925,
292471.71293,	292476.53661,	292481.36030,	292486.18400,	292491.00770,	292495.83141,	292500.65513,	292505.47885,	292510.30258,	292515.12631,
292519.95005,	292524.77380,	292529.59755,	292534.42132,	292539.24508,	292544.06886,	292548.89264,	292553.71643,	292558.54022,	292563.36402,
292568.18783,	292573.01164,	292577.83546,	292582.65928,	292587.48312,	292592.30696,	292597.13080,	292601.95465,	292606.77851,	292611.60238,
292616.42625,	292621.25013,	292626.07401,	292630.89791,	292635.72180,	292640.54571,	292645.36962,	292650.19354,	292655.01746,	292659.84139,
292664.66533,	292669.48927,	292674.31322,	292679.13718,	292683.96114,	292688.78511,	292693.60909,	292698.43307,	292703.25706,	292708.08105,
292712.90506,	292717.72906,	292722.55308,	292727.37710,	292732.20113,	292737.02516,	292741.84920,	292746.67325,	292751.49731,	292756.32137,
292761.14543,	292765.96951,	292770.79359,	292775.61768,	292780.44177,	292785.26587,	292790.08997,	292794.91409,	292799.73821,	292804.56233,
292809.38647,	292814.21060,	292819.03475,	292823.85890,	292828.68306,	292833.50722,	292838.33140,	292843.15557,	292847.97976,	292852.80395,
292857.62815,	292862.45235,	292867.27656,	292872.10078,	292876.92500,	292881.74923,	292886.57347,	292891.39771,	292896.22196,	292901.04622,
292905.87048,	292910.69475,	292915.51902,	292920.34331,	292925.16759,	292929.99189,	292934.81619,	292939.64050,	292944.46481,	292949.28913,
292954.11346,	292958.93780,	292963.76214,	292968.58648,	292973.41084,	292978.23520,	292983.05957,	292987.88394,	292992.70832,	292997.53270,
293002.35710,	293007.18150,	293012.00590,	293016.83031,	293021.65473,	293026.47916,	293031.30359,	293036.12803,	293040.95247,	293045.77692,
293050.60138,	293055.42585,	293060.25032,	293065.07479,	293069.89928,	293074.72377,	293079.54827,	293084.37277,	293089.19728,	293094.02179,
293098.84632,	293103.67085,	293108.49538,	293113.31992,	293118.14447,	293122.96903,	293127.79359,	293132.61816,	293137.44273,	293142.26732,
293147.09190,	293151.91650,	293156.74110,	293161.56571,	293166.39032,	293171.21494,	293176.03957,	293180.86420,	293185.68884,	293190.51349,
293195.33814,	293200.16280,	293204.98747,	293209.81214,	293214.63682,	293219.46150,	293224.28619,	293229.11089,	293233.93560,	293238.76031,
293243.58503,	293248.40975,	293253.23448,	293258.05922,	293262.88396,	293267.70871,	293272.53347,	293277.35823,	293282.18300,	293287.00778,
293291.83256,	293296.65735,	293301.48215,	293306.30695,	293311.13176,	293315.95658,	293320.78140,	293325.60623,	293330.43106,	293335.25590,
293340.08075,	293344.90561,	293349.73047,	293354.55533,	293359.38021,	293364.20509,	293369.02998,	293373.85487,	293378.67977,	293383.50468,
293388.32959,	293393.15451,	293397.97943,	293402.80437,	293407.62931,	293412.45425,	293417.27920,	293422.10416,	293426.92913,	293431.75410,
293436.57908,	293441.40406,	293446.22905,	293451.05405,	293455.87905,	293460.70406,	293465.52908,	293470.35410,	293475.17913,	293480.00417,
293484.82921,	293489.65426,	293494.47932,	293499.30438,	293504.12945,	293508.95452,	293513.77961,	293518.60469,	293523.42979,	293528.25489,
293533.08000,	293537.90511,	293542.73023,	293547.55536,	293552.38050,	293557.20564,	293562.03078,	293566.85594,	293571.68110,	293576.50626,
293581.33144,	293586.15661,	293590.98180,	293595.80699,	293600.63219,	293605.45740,	293610.28261,	293615.10783,	293619.93305,	293624.75828,
293629.58352,	293634.40877,	293639.23402,	293644.05927,	293648.88454,	293653.70981,	293658.53508,	293663.36037,	293668.18566,	293673.01095,
293677.83626,	293682.66157,	293687.48688,	293692.31220,	293697.13753,	293701.96287,	293706.78821,	293711.61356,	293716.43891,	293721.26427,
293726.08964,	293730.91502,	293735.74040,	293740.56578,	293745.39118,	293750.21658,	293755.04198,	293759.86740,	293764.69282,	293769.51824,
293774.34368,	293779.16911,	293783.99456,	293788.82001,	293793.64547,	293798.47094,	293803.29641,	293808.12189,	293812.94737,	293817.77286,
293822.59836,	293827.42386,	293832.24937,	293837.07489,	293841.90041,	293846.72594,	293851.55148,	293856.37702,	293861.20257,	293866.02813,
293870.85369,	293875.67926,	293880.50484,	293885.33042,	293890.15601,	293894.98160,	293899.80720,	293904.63281,	293909.45842,	293914.28404,
293919.10967,	293923.93531,	293928.76095,	293933.58659,	293938.41225,	293943.23791,	293948.06357,	293952.88924,	293957.71492,	293962.54061,
293967.36630,	293972.19200,	293977.01771,	293981.84342,	293986.66914,	293991.49486,	293996.32059,	294001.14633,	294005.97207,	294010.79782,
294015.62358,	294020.44934,	294025.27511,	294030.10089,	294034.92667,	294039.75246,	294044.57826,	294049.40406,	294054.22987,	294059.05569,
294063.88151,	294068.70734,	294073.53317,	294078.35901,	294083.18486,	294088.01072,	294092.83658,	294097.66244,	294102.48832,	294107.31420,
294112.14008,	294116.96598,	294121.79188,	294126.61778,	294131.44370,	294136.26962,	294141.09554,	294145.92147,	294150.74741,	294155.57336,
294160.39931,	294165.22527,	294170.05123,	294174.87720,	294179.70318,	294184.52916,	294189.35515,	294194.18115,	294199.00716,	294203.83316,
294208.65918,	294213.48520,	294218.31123,	294223.13727,	294227.96331,	294232.78936,	294237.61542,	294242.44148,	294247.26755,	294252.09362,
294256.91970,	294261.74579,	294266.57188,	294271.39799,	294276.22409,	294281.05021,	294285.87633,	294290.70245,	294295.52859,	294300.35473,
294305.18087,	294310.00702,	294314.83318,	294319.65935,	294324.48552,	294329.31170,	294334.13788,	294338.96408,	294343.79027,	294348.61648,
294353.44269,	294358.26891,	294363.09513,	294367.92136,	294372.74760,	294377.57384,	294382.40009,	294387.22635,	294392.05261,	294396.87888,
294401.70515,	294406.53144,	294411.35773,	294416.18402,	294421.01032,	294425.83663,	294430.66295,	294435.48927,	294440.31559,	294445.14193,
294449.96827,	294454.79462,	294459.62097,	294464.44733,	294469.27369,	294474.10007,	294478.92645,	294483.75283,	294488.57923,	294493.40562,
294498.23203,	294503.05844,	294507.88486,	294512.71128,	294517.53771,	294522.36415,	294527.19060,	294532.01705,	294536.84350,	294541.66997,
294546.49644,	294551.32291,	294556.14940,	294560.97589,	294565.80238,	294570.62889,	294575.45539,	294580.28191,	294585.10843,	294589.93496,
294594.76149,	294599.58804,	294604.41458,	294609.24114,	294614.06770,	294618.89427,	294623.72084,	294628.54742,	294633.37401,	294638.20060,
294643.02720,	294647.85380,	294652.68042,	294657.50704,	294662.33366,	294667.16029,	294671.98693,	294676.81358,	294681.64023,	294686.46689,
294691.29355,	294696.12022,	294700.94690,	294705.77358,	294710.60027,	294715.42697,	294720.25367,	294725.08038,	294729.90710,	294734.73382,
294739.56055,	294744.38728,	294749.21403,	294754.04077,	294758.86753,	294763.69429,	294768.52106,	294773.34783,	294778.17461,	294783.00140,
294787.82819,	294792.65499,	294797.48180,	294802.30861,	294807.13543,	294811.96226,	294816.78909,	294821.61593,	294826.44278,	294831.26963,
294836.09649,	294840.92335,	294845.75022,	294850.57710,	294855.40399,	294860.23088,	294865.05777,	294869.88468,	294874.71159,	294879.53850,
294884.36543,	294889.19236,	294894.01929,	294898.84624,	294903.67318,	294908.50014,	294913.32710,	294918.15407,	294922.98105,	294927.80803,
294932.63501,	294937.46201,	294942.28901,	294947.11602,	294951.94303,	294956.77005,	294961.59708,	294966.42411,	294971.25115,	294976.07820,
294980.90525,	294985.73231,	294990.55937,	294995.38644,	295000.21352,	295005.04061,	295009.86770,	295014.69480,	295019.52190,	295024.34901,
295029.17613,	295034.00325,	295038.83038,	295043.65752,	295048.48466,	295053.31181,	295058.13897,	295062.96613,	295067.79330,	295072.62047,
295077.44766,	295082.27484,	295087.10204,	295091.92924,	295096.75645,	295101.58366,	295106.41088,	295111.23811,	295116.06534,	295120.89258,
295125.71983,	295130.54708,	295135.37434,	295140.20161,	295145.02888,	295149.85616,	295154.68344,	295159.51074,	295164.33803,	295169.16534,
295173.99265,	295178.81997,	295183.64729,	295188.47462,	295193.30196,	295198.12930,	295202.95665,	295207.78401,	295212.61137,	295217.43874,
295222.26612,	295227.09350,	295231.92089,	295236.74828,	295241.57568,	295246.40309,	295251.23051,	295256.05793,	295260.88535,	295265.71279,
295270.54023,	295275.36768,	295280.19513,	295285.02259,	295289.85005,	295294.67753,	295299.50501,	295304.33249,	295309.15998,	295313.98748,
295318.81499,	295323.64250,	295328.47002,	295333.29754,	295338.12507,	295342.95261,	295347.78015,	295352.60770,	295357.43526,	295362.26282,
295367.09039,	295371.91797,	295376.74555,	295381.57314,	295386.40074,	295391.22834,	295396.05595,	295400.88356,	295405.71118,	295410.53881,
295415.36644,	295420.19408,	295425.02173,	295429.84939,	295434.67705,	295439.50471,	295444.33238,	295449.16006,	295453.98775,	295458.81544,
295463.64314,	295468.47085,	295473.29856,	295478.12628,	295482.95400,	295487.78173,	295492.60947,	295497.43721,	295502.26496,	295507.09272,
295511.92048,	295516.74825,	295521.57603,	295526.40381,	295531.23160,	295536.05940,	295540.88720,	295545.71501,	295550.54282,	295555.37064,
295560.19847,	295565.02631,	295569.85415,	295574.68199,	295579.50985,	295584.33771,	295589.16557,	295593.99345,	295598.82133,	295603.64921,
295608.47711,	295613.30500,	295618.13291,	295622.96082,	295627.78874,	295632.61666,	295637.44460,	295642.27253,	295647.10048,	295651.92843,
295656.75638,	295661.58435,	295666.41232,	295671.24029,	295676.06828,	295680.89627,	295685.72426,	295690.55226,	295695.38027,	295700.20829,
295705.03631,	295709.86434,	295714.69237,	295719.52041,	295724.34846,	295729.17651,	295734.00457,	295738.83264,	295743.66071,	295748.48879,
295753.31688,	295758.14497,	295762.97307,	295767.80118,	295772.62929,	295777.45741,	295782.28553,	295787.11366,	295791.94180,	295796.76994,
295801.59810,	295806.42625,	295811.25442,	295816.08259,	295820.91076,	295825.73894,	295830.56713,	295835.39533,	295840.22353,	295845.05174,
295849.87996,	295854.70818,	295859.53640,	295864.36464,	295869.19288,	295874.02113,	295878.84938,	295883.67764,	295888.50591,	295893.33418,
295898.16246,	295902.99075,	295907.81904,	295912.64734,	295917.47564,	295922.30396,	295927.13227,	295931.96060,	295936.78893,	295941.61727,
295946.44561,	295951.27396,	295956.10232,	295960.93068,	295965.75905,	295970.58743,	295975.41581,	295980.24420,	295985.07260,	295989.90100,
295994.72941,	295999.55782,	296004.38624,	296009.21467,	296014.04310,	296018.87155,	296023.69999,	296028.52845,	296033.35691,	296038.18537,
296043.01385,	296047.84233,	296052.67081,	296057.49930,	296062.32780,	296067.15631,	296071.98482,	296076.81334,	296081.64186,	296086.47039,
296091.29893,	296096.12747,	296100.95602,	296105.78458,	296110.61314,	296115.44171,	296120.27029,	296125.09887,	296129.92746,	296134.75606,
296139.58466,	296144.41327,	296149.24188,	296154.07050,	296158.89913,	296163.72777,	296168.55641,	296173.38505,	296178.21371,	296183.04237,
296187.87103,	296192.69971,	296197.52838,	296202.35707,	296207.18576,	296212.01446,	296216.84317,	296221.67188,	296226.50060,	296231.32932,
296236.15805,	296240.98679,	296245.81553,	296250.64428,	296255.47304,	296260.30180,	296265.13057,	296269.95935,	296274.78813,	296279.61692,
296284.44571,	296289.27451,	296294.10332,	296298.93214,	296303.76096,	296308.58979,	296313.41862,	296318.24746,	296323.07631,	296327.90516,
296332.73402,	296337.56288,	296342.39176,	296347.22064,	296352.04952,	296356.87841,	296361.70731,	296366.53622,	296371.36513,	296376.19405,
296381.02297,	296385.85190,	296390.68084,	296395.50978,	296400.33873,	296405.16769,	296409.99665,	296414.82562,	296419.65459,	296424.48357,
296429.31256,	296434.14156,	296438.97056,	296443.79957,	296448.62858,	296453.45760,	296458.28663,	296463.11566,	296467.94470,	296472.77375,
296477.60280,	296482.43186,	296487.26093,	296492.09000,	296496.91908,	296501.74816,	296506.57725,	296511.40635,	296516.23546,	296521.06457,
296525.89368,	296530.72281,	296535.55194,	296540.38107,	296545.21022,	296550.03937,	296554.86852,	296559.69768,	296564.52685,	296569.35603,
296574.18521,	296579.01440,	296583.84359,	296588.67279,	296593.50200,	296598.33121,	296603.16043,	296607.98966,	296612.81889,	296617.64813,
296622.47738,	296627.30663,	296632.13589,	296636.96515,	296641.79443,	296646.62370,	296651.45299,	296656.28228,	296661.11158,	296665.94088,
296670.77019,	296675.59951,	296680.42883,	296685.25816,	296690.08750,	296694.91684,	296699.74619,	296704.57554,	296709.40490,	296714.23427,
296719.06365,	296723.89303,	296728.72241,	296733.55181,	296738.38121,	296743.21062,	296748.04003,	296752.86945,	296757.69887,	296762.52831,
296767.35775,	296772.18719,	296777.01664,	296781.84610,	296786.67557,	296791.50504,	296796.33451,	296801.16400,	296805.99349,	296810.82298,
296815.65249,	296820.48200,	296825.31151,	296830.14104,	296834.97056,	296839.80010,	296844.62964,	296849.45919,	296854.28874,	296859.11831,
296863.94787,	296868.77745,	296873.60703,	296878.43661,	296883.26621,	296888.09581,	296892.92541,	296897.75503,	296902.58464,	296907.41427,
296912.24390,	296917.07354,	296921.90318,	296926.73284,	296931.56249,	296936.39216,	296941.22183,	296946.05150,	296950.88119,	296955.71088,
296960.54057,	296965.37028,	296970.19998,	296975.02970,	296979.85942,	296984.68915,	296989.51888,	296994.34863,	296999.17837,	297004.00813,
297008.83789,	297013.66765,	297018.49743,	297023.32721,	297028.15699,	297032.98679,	297037.81658,	297042.64639,	297047.47620,	297052.30602,
297057.13584,	297061.96568,	297066.79551,	297071.62536,	297076.45521,	297081.28506,	297086.11493,	297090.94480,	297095.77467,	297100.60455,
297105.43444,	297110.26434,	297115.09424,	297119.92415,	297124.75406,	297129.58398,	297134.41391,	297139.24385,	297144.07379,	297148.90373,
297153.73369,	297158.56365,	297163.39361,	297168.22358,	297173.05356,	297177.88355,	297182.71354,	297187.54354,	297192.37354,	297197.20355,
297202.03357,	297206.86359,	297211.69362,	297216.52366,	297221.35370,	297226.18375,	297231.01381,	297235.84387,	297240.67394,	297245.50402,
297250.33410,	297255.16419,	297259.99428,	297264.82438,	297269.65449,	297274.48460,	297279.31472,	297284.14485,	297288.97498,	297293.80512,
297298.63527,	297303.46542,	297308.29558,	297313.12574,	297317.95591,	297322.78609,	297327.61628,	297332.44647,	297337.27666,	297342.10687,
297346.93708,	297351.76729,	297356.59752,	297361.42775,	297366.25798,	297371.08822,	297375.91847,	297380.74873,	297385.57899,	297390.40926,
297395.23953,	297400.06981,	297404.90010,	297409.73039,	297414.56069,	297419.39100,	297424.22131,	297429.05163,	297433.88196,	297438.71229,
297443.54263,	297448.37297,	297453.20332,	297458.03368,	297462.86404,	297467.69441,	297472.52479,	297477.35517,	297482.18556,	297487.01596,
297491.84636,	297496.67677,	297501.50719,	297506.33761,	297511.16804,	297515.99847,	297520.82891,	297525.65936,	297530.48982,	297535.32028,
297540.15074,	297544.98122,	297549.81170,	297554.64218,	297559.47267,	297564.30317,	297569.13368,	297573.96419,	297578.79471,	297583.62523,
297588.45576,	297593.28630,	297598.11684,	297602.94739,	297607.77795,	297612.60851,	297617.43908,	297622.26966,	297627.10024,	297631.93083,
297636.76143,	297641.59203,	297646.42263,	297651.25325,	297656.08387,	297660.91450,	297665.74513,	297670.57577,	297675.40642,	297680.23707,
297685.06773,	297689.89839,	297694.72907,	297699.55974,	297704.39043,	297709.22112,	297714.05182,	297718.88252,	297723.71323,	297728.54395,
297733.37467,	297738.20540,	297743.03614,	297747.86688,	297752.69763,	297757.52839,	297762.35915,	297767.18992,	297772.02069,	297776.85147,
297781.68226,	297786.51305,	297791.34385,	297796.17466,	297801.00547,	297805.83629,	297810.66712,	297815.49795,	297820.32879,	297825.15964,
297829.99049,	297834.82135,	297839.65221,	297844.48308,	297849.31396,	297854.14484,	297858.97573,	297863.80663,	297868.63753,	297873.46844,
297878.29936,	297883.13028,	297887.96121,	297892.79214,	297897.62308,	297902.45403,	297907.28499,	297912.11595,	297916.94691,	297921.77789,
297926.60887,	297931.43985,	297936.27084,	297941.10184,	297945.93285,	297950.76386,	297955.59488,	297960.42590,	297965.25693,	297970.08797,
297974.91902,	297979.75007,	297984.58112,	297989.41219,	297994.24326,	297999.07433,	298003.90541,	298008.73650,	298013.56760,	298018.39870,
298023.22981,	298028.06092,	298032.89204,	298037.72317,	298042.55430,	298047.38544,	298052.21659,	298057.04774,	298061.87890,	298066.71007,
298071.54124,	298076.37242,	298081.20360,	298086.03479,	298090.86599,	298095.69720,	298100.52841,	298105.35962,	298110.19085,	298115.02208,
298119.85331,	298124.68456,	298129.51580,	298134.34706,	298139.17832,	298144.00959,	298148.84086,	298153.67214,	298158.50343,	298163.33473,
298168.16603,	298172.99733,	298177.82865,	298182.65996,	298187.49129,	298192.32262,	298197.15396,	298201.98531,	298206.81666,	298211.64802,
298216.47938,	298221.31075,	298226.14213,	298230.97351,	298235.80490,	298240.63630,	298245.46770,	298250.29911,	298255.13052,	298259.96195,
298264.79337,	298269.62481,	298274.45625,	298279.28770,	298284.11915,	298288.95061,	298293.78208,	298298.61355,	298303.44503,	298308.27652,
298313.10801,	298317.93951,	298322.77101,	298327.60252,	298332.43404,	298337.26557,	298342.09710,	298346.92863,	298351.76018,	298356.59173,
298361.42328,	298366.25485,	298371.08641,	298375.91799,	298380.74957,	298385.58116,	298390.41275,	298395.24436,	298400.07596,	298404.90758,
298409.73920,	298414.57082,	298419.40246,	298424.23410,	298429.06574,	298433.89739,	298438.72905,	298443.56072,	298448.39239,	298453.22407,
298458.05575,	298462.88744,	298467.71914,	298472.55084,	298477.38255,	298482.21427,	298487.04599,	298491.87772,	298496.70946,	298501.54120,
298506.37295,	298511.20470,	298516.03646,	298520.86823,	298525.70000,	298530.53178,	298535.36357,	298540.19536,	298545.02716,	298549.85897,
298554.69078,	298559.52260,	298564.35442,	298569.18626,	298574.01809,	298578.84994,	298583.68179,	298588.51364,	298593.34551,	298598.17738,
298603.00925,	298607.84114,	298612.67303,	298617.50492,	298622.33682,	298627.16873,	298632.00065,	298636.83257,	298641.66449,	298646.49643,
298651.32837,	298656.16031,	298660.99227,	298665.82423,	298670.65619,	298675.48816,	298680.32014,	298685.15213,	298689.98412,	298694.81612,
298699.64812,	298704.48013,	298709.31215,	298714.14417,	298718.97620,	298723.80824,	298728.64028,	298733.47233,	298738.30438,	298743.13644,
298747.96851,	298752.80059,	298757.63267,	298762.46476,	298767.29685,	298772.12895,	298776.96106,	298781.79317,	298786.62529,	298791.45741,
298796.28954,	298801.12168,	298805.95383,	298810.78598,	298815.61814,	298820.45030,	298825.28247,	298830.11465,	298834.94683,	298839.77902,
298844.61122,	298849.44342,	298854.27563,	298859.10784,	298863.94006,	298868.77229,	298873.60452,	298878.43677,	298883.26901,	298888.10127,
298892.93353,	298897.76579,	298902.59806,	298907.43034,	298912.26263,	298917.09492,	298921.92722,	298926.75952,	298931.59183,	298936.42415,
298941.25647,	298946.08880,	298950.92114,	298955.75348,	298960.58583,	298965.41819,	298970.25055,	298975.08292,	298979.91529,	298984.74767,
298989.58006,	298994.41246,	298999.24486,	299004.07726,	299008.90968,	299013.74210,	299018.57452,	299023.40695,	299028.23939,	299033.07184,
299037.90429,	299042.73675,	299047.56921,	299052.40168,	299057.23416,	299062.06664,	299066.89913,	299071.73163,	299076.56413,	299081.39664,
299086.22915,	299091.06168,	299095.89420,	299100.72674,	299105.55928,	299110.39183,	299115.22438,	299120.05694,	299124.88951,	299129.72208,
299134.55466,	299139.38724,	299144.21984,	299149.05243,	299153.88504,	299158.71765,	299163.55027,	299168.38289,	299173.21552,	299178.04816,
299182.88080,	299187.71345,	299192.54611,	299197.37877,	299202.21144,	299207.04411,	299211.87679,	299216.70948,	299221.54218,	299226.37488,
299231.20758,	299236.04030,	299240.87302,	299245.70574,	299250.53847,	299255.37121,	299260.20396,	299265.03671,	299269.86947,	299274.70223,
299279.53500,	299284.36778,	299289.20056,	299294.03335,	299298.86615,	299303.69895,	299308.53176,	299313.36458,	299318.19740,	299323.03023,
299327.86306,	299332.69590,	299337.52875,	299342.36160,	299347.19446,	299352.02733,	299356.86020,	299361.69308,	299366.52597,	299371.35886,
299376.19176,	299381.02466,	299385.85757,	299390.69049,	299395.52341,	299400.35634,	299405.18928,	299410.02222,	299414.85517,	299419.68813,
299424.52109,	299429.35406,	299434.18703,	299439.02002,	299443.85300,	299448.68600,	299453.51900,	299458.35200,	299463.18502,	299468.01804,
299472.85106,	299477.68410,	299482.51713,	299487.35018,	299492.18323,	299497.01629,	299501.84935,	299506.68242,	299511.51550,	299516.34858,
299521.18167,	299526.01477,	299530.84787,	299535.68098,	299540.51410,	299545.34722,	299550.18035,	299555.01348,	299559.84662,	299564.67977,
299569.51292,	299574.34608,	299579.17925,	299584.01242,	299588.84560,	299593.67878,	299598.51198,	299603.34517,	299608.17838,	299613.01159,
299617.84481,	299622.67803,	299627.51126,	299632.34450,	299637.17774,	299642.01099,	299646.84424,	299651.67751,	299656.51077,	299661.34405,
299666.17733,	299671.01062,	299675.84391,	299680.67721,	299685.51052,	299690.34383,	299695.17715,	299700.01048,	299704.84381,	299709.67715,
299714.51049,	299719.34384,	299724.17720,	299729.01056,	299733.84393,	299738.67731,	299743.51069,	299748.34408,	299753.17748,	299758.01088,
299762.84429,	299767.67770,	299772.51113,	299777.34455,	299782.17799,	299787.01143,	299791.84487,	299796.67833,	299801.51179,	299806.34525,
299811.17872,	299816.01220,	299820.84569,	299825.67918,	299830.51268,	299835.34618,	299840.17969,	299845.01321,	299849.84673,	299854.68026,
299859.51380,	299864.34734,	299869.18089,	299874.01444,	299878.84800,	299883.68157,	299888.51515,	299893.34873,	299898.18231,	299903.01591,
299907.84951,	299912.68311,	299917.51673,	299922.35034,	299927.18397,	299932.01760,	299936.85124,	299941.68488,	299946.51853,	299951.35219,
299956.18585,	299961.01952,	299965.85320,	299970.68688,	299975.52057,	299980.35427,	299985.18797,	299990.02168,	299994.85539,	299999.68911,
300004.52284,	300009.35657,	300014.19031,	300019.02406,	300023.85781,	300028.69157,	300033.52533,	300038.35911,	300043.19288,	300048.02667,
300052.86046,	300057.69426,	300062.52806,	300067.36187,	300072.19569,	300077.02951,	300081.86334,	300086.69717,	300091.53101,	300096.36486,
300101.19872,	300106.03258,	300110.86644,	300115.70032,	300120.53420,	300125.36808,	300130.20198,	300135.03588,	300139.86978,	300144.70369,
300149.53761,	300154.37154,	300159.20547,	300164.03940,	300168.87335,	300173.70730,	300178.54125,	300183.37522,	300188.20918,	300193.04316,
300197.87714,	300202.71113,	300207.54512,	300212.37913,	300217.21313,	300222.04715,	300226.88117,	300231.71519,	300236.54923,	300241.38326,
300246.21731,	300251.05136,	300255.88542,	300260.71948,	300265.55355,	300270.38763,	300275.22172,	300280.05581,	300284.88990,	300289.72400,
300294.55811,	300299.39223,	300304.22635,	300309.06048,	300313.89461,	300318.72875,	300323.56290,	300328.39705,	300333.23121,	300338.06538,
300342.89955,	300347.73373,	300352.56792,	300357.40211,	300362.23631,	300367.07051,	300371.90472,	300376.73894,	300381.57316,	300386.40739,
300391.24163,	300396.07587,	300400.91012,	300405.74438,	300410.57864,	300415.41291,	300420.24718,	300425.08146,	300429.91575,	300434.75004,
300439.58434,	300444.41865,	300449.25296,	300454.08728,	300458.92161,	300463.75594,	300468.59028,	300473.42462,	300478.25897,	300483.09333,
300487.92769,	300492.76206,	300497.59644,	300502.43082,	300507.26521,	300512.09960,	300516.93401,	300521.76841,	300526.60283,	300531.43725,
300536.27168,	300541.10611,	300545.94055,	300550.77499,	300555.60945,	300560.44391,	300565.27837,	300570.11284,	300574.94732,	300579.78181,
300584.61630,	300589.45079,	300594.28530,	300599.11981,	300603.95432,	300608.78884,	300613.62337,	300618.45791,	300623.29245,	300628.12700,
300632.96155,	300637.79611,	300642.63068,	300647.46525,	300652.29983,	300657.13442,	300661.96901,	300666.80361,	300671.63821,	300676.47283,
300681.30744,	300686.14207,	300690.97670,	300695.81133,	300700.64598,	300705.48063,	300710.31528,	300715.14995,	300719.98461,	300724.81929,
300729.65397,	300734.48866,	300739.32335,	300744.15805,	300748.99276,	300753.82747,	300758.66219,	300763.49692,	300768.33165,	300773.16639,
300778.00113,	300782.83588,	300787.67064,	300792.50541,	300797.34018,	300802.17495,	300807.00974,	300811.84453,	300816.67932,	300821.51412,
300826.34893,	300831.18375,	300836.01857,	300840.85340,	300845.68823,	300850.52307,	300855.35792,	300860.19277,	300865.02763,	300869.86249,
300874.69737,	300879.53224,	300884.36713,	300889.20202,	300894.03692,	300898.87182,	300903.70673,	300908.54165,	300913.37657,	300918.21150,
300923.04643,	300927.88138,	300932.71632,	300937.55128,	300942.38624,	300947.22121,	300952.05618,	300956.89116,	300961.72615,	300966.56114,
300971.39614,	300976.23114,	300981.06615,	300985.90117,	300990.73620,	300995.57123,	301000.40626,	301005.24131,	301010.07636,	301014.91141,
301019.74648,	301024.58155,	301029.41662,	301034.25170,	301039.08679,	301043.92188,	301048.75698,	301053.59209,	301058.42720,	301063.26232,
301068.09745,	301072.93258,	301077.76772,	301082.60287,	301087.43802,	301092.27318,	301097.10834,	301101.94351,	301106.77869,	301111.61387,
301116.44906,	301121.28425,	301126.11946,	301130.95467,	301135.78988,	301140.62510,	301145.46033,	301150.29556,	301155.13080,	301159.96605,
301164.80130,	301169.63656,	301174.47183,	301179.30710,	301184.14238,	301188.97766,	301193.81295,	301198.64825,	301203.48355,	301208.31886,
301213.15418,	301217.98950,	301222.82483,	301227.66017,	301232.49551,	301237.33086,	301242.16621,	301247.00157,	301251.83694,	301256.67231,
301261.50769,	301266.34308,	301271.17847,	301276.01387,	301280.84927,	301285.68469,	301290.52010,	301295.35553,	301300.19096,	301305.02640,
301309.86184,	301314.69729,	301319.53274,	301324.36821,	301329.20368,	301334.03915,	301338.87463,	301343.71012,	301348.54561,	301353.38111,
301358.21662,	301363.05213,	301367.88765,	301372.72318,	301377.55871,	301382.39425,	301387.22979,	301392.06534,	301396.90090,	301401.73647,
301406.57204,	301411.40761,	301416.24320,	301421.07878,	301425.91438,	301430.74998,	301435.58559,	301440.42120,	301445.25683,	301450.09245,
301454.92809,	301459.76373,	301464.59937,	301469.43502,	301474.27068,	301479.10635,	301483.94202,	301488.77770,	301493.61338,	301498.44907,
301503.28477,	301508.12047,	301512.95618,	301517.79190,	301522.62762,	301527.46335,	301532.29908,	301537.13483,	301541.97057,	301546.80633,
301551.64209,	301556.47785,	301561.31363,	301566.14941,	301570.98519,	301575.82098,	301580.65678,	301585.49259,	301590.32840,	301595.16422,
301600.00004,	301604.83587,	301609.67171,	301614.50755,	301619.34340,	301624.17925,	301629.01511,	301633.85098,	301638.68686,	301643.52274,
301648.35862,	301653.19452,	301658.03042,	301662.86632,	301667.70224,	301672.53815,	301677.37408,	301682.21001,	301687.04595,	301691.88189,
301696.71784,	301701.55380,	301706.38976,	301711.22573,	301716.06171,	301720.89769,	301725.73368,	301730.56967,	301735.40568,	301740.24168,
301745.07770,	301749.91372,	301754.74974,	301759.58578,	301764.42182,	301769.25786,	301774.09391,	301778.92997,	301783.76603,	301788.60211,
301793.43818,	301798.27427,	301803.11036,	301807.94645,	301812.78255,	301817.61866,	301822.45478,	301827.29090,	301832.12703,	301836.96316,
301841.79930,	301846.63545,	301851.47160,	301856.30776,	301861.14393,	301865.98010,	301870.81628,	301875.65246,	301880.48865,	301885.32485,
301890.16106,	301894.99727,	301899.83348,	301904.66971,	301909.50593,	301914.34217,	301919.17841,	301924.01466,	301928.85091,	301933.68718,
301938.52344,	301943.35972,	301948.19600,	301953.03228,	301957.86857,	301962.70487,	301967.54118,	301972.37749,	301977.21381,	301982.05013,
301986.88646,	301991.72280,	301996.55914,	302001.39549,	302006.23185,	302011.06821,	302015.90458,	302020.74095,	302025.57733,	302030.41372,
302035.25011,	302040.08651,	302044.92292,	302049.75933,	302054.59575,	302059.43218,	302064.26861,	302069.10505,	302073.94149,	302078.77794,
302083.61440,	302088.45086,	302093.28733,	302098.12381,	302102.96029,	302107.79678,	302112.63328,	302117.46978,	302122.30628,	302127.14280,
302131.97932,	302136.81585,	302141.65238,	302146.48892,	302151.32546,	302156.16202,	302160.99857,	302165.83514,	302170.67171,	302175.50829,
302180.34487,	302185.18146,	302190.01806,	302194.85466,	302199.69127,	302204.52788,	302209.36450,	302214.20113,	302219.03777,	302223.87441,
302228.71105,	302233.54771,	302238.38437,	302243.22103,	302248.05770,	302252.89438,	302257.73107,	302262.56776,	302267.40446,	302272.24116,
302277.07787,	302281.91459,	302286.75131,	302291.58804,	302296.42477,	302301.26152,	302306.09826,	302310.93502,	302315.77178,	302320.60855,
302325.44532,	302330.28210,	302335.11889,	302339.95568,	302344.79248,	302349.62928,	302354.46609,	302359.30291,	302364.13973,	302368.97656,
302373.81340,	302378.65024,	302383.48709,	302388.32395,	302393.16081,	302397.99768,	302402.83455,	302407.67143,	302412.50832,	302417.34522,
302422.18212,	302427.01902,	302431.85593,	302436.69285,	302441.52978,	302446.36671,	302451.20365,	302456.04059,	302460.87754,	302465.71450,
302470.55146,	302475.38843,	302480.22541,	302485.06239,	302489.89938,	302494.73637,	302499.57337,	302504.41038,	302509.24739,	302514.08441,
302518.92144,	302523.75847,	302528.59551,	302533.43256,	302538.26961,	302543.10667,	302547.94373,	302552.78080,	302557.61788,	302562.45496,
302567.29205,	302572.12915,	302576.96625,	302581.80336,	302586.64047,	302591.47759,	302596.31472,	302601.15185,	302605.98899,	302610.82614,
302615.66329,	302620.50045,	302625.33762,	302630.17479,	302635.01197,	302639.84915,	302644.68634,	302649.52354,	302654.36074,	302659.19795,
302664.03517,	302668.87239,	302673.70962,	302678.54685,	302683.38409,	302688.22134,	302693.05859,	302697.89585,	302702.73312,	302707.57039,
302712.40767,	302717.24496,	302722.08225,	302726.91955,	302731.75685,	302736.59416,	302741.43148,	302746.26880,	302751.10613,	302755.94347,
302760.78081,	302765.61816,	302770.45551,	302775.29287,	302780.13024,	302784.96762,	302789.80500,	302794.64238,	302799.47977,	302804.31717,
302809.15458,	302813.99199,	302818.82941,	302823.66683,	302828.50426,	302833.34170,	302838.17914,	302843.01659,	302847.85405,	302852.69151,
302857.52898,	302862.36645,	302867.20394,	302872.04142,	302876.87892,	302881.71642,	302886.55392,	302891.39144,	302896.22895,	302901.06648,
302905.90401,	302910.74155,	302915.57909,	302920.41664,	302925.25420,	302930.09176,	302934.92933,	302939.76691,	302944.60449,	302949.44208,
302954.27968,	302959.11728,	302963.95488,	302968.79250,	302973.63012,	302978.46774,	302983.30538,	302988.14302,	302992.98066,	302997.81831,
303002.65597,	303007.49363,	303012.33130,	303017.16898,	303022.00666,	303026.84435,	303031.68205,	303036.51975,	303041.35746,	303046.19517,
303051.03290,	303055.87062,	303060.70836,	303065.54610,	303070.38384,	303075.22160,	303080.05935,	303084.89712,	303089.73489,	303094.57267,
303099.41045,	303104.24824,	303109.08604,	303113.92384,	303118.76165,	303123.59947,	303128.43729,	303133.27512,	303138.11295,	303142.95079,
303147.78864,	303152.62649,	303157.46435,	303162.30222,	303167.14009,	303171.97797,	303176.81586,	303181.65375,	303186.49164,	303191.32955,
303196.16746,	303201.00538,	303205.84330,	303210.68123,	303215.51916,	303220.35710,	303225.19505,	303230.03301,	303234.87097,	303239.70893,
303244.54691,	303249.38489,	303254.22287,	303259.06087,	303263.89886,	303268.73687,	303273.57488,	303278.41290,	303283.25092,	303288.08895,
303292.92699,	303297.76503,	303302.60308,	303307.44114,	303312.27920,	303317.11726,	303321.95534,	303326.79342,	303331.63151,	303336.46960,
303341.30770,	303346.14580,	303350.98392,	303355.82204,	303360.66016,	303365.49829,	303370.33643,	303375.17457,	303380.01272,	303384.85088,
303389.68904,	303394.52721,	303399.36538,	303404.20357,	303409.04175,	303413.87995,	303418.71815,	303423.55635,	303428.39457,	303433.23279,
303438.07101,	303442.90924,	303447.74748,	303452.58573,	303457.42398,	303462.26223,	303467.10050,	303471.93877,	303476.77704,	303481.61533,
303486.45361,	303491.29191,	303496.13021,	303500.96852,	303505.80683,	303510.64515,	303515.48348,	303520.32181,	303525.16015,	303529.99849,
303534.83685,	303539.67520,	303544.51357,	303549.35194,	303554.19032,	303559.02870,	303563.86709,	303568.70548,	303573.54389,	303578.38229,
303583.22071,	303588.05913,	303592.89756,	303597.73599,	303602.57443,	303607.41288,	303612.25133,	303617.08979,	303621.92825,	303626.76672,
303631.60520,	303636.44368,	303641.28217,	303646.12067,	303650.95917,	303655.79768,	303660.63620,	303665.47472,	303670.31325,	303675.15178,
303679.99032,	303684.82887,	303689.66742,	303694.50598,	303699.34455,	303704.18312,	303709.02170,	303713.86028,	303718.69887,	303723.53747,
303728.37607,	303733.21468,	303738.05330,	303742.89192,	303747.73055,	303752.56919,	303757.40783,	303762.24648,	303767.08513,	303771.92379,
303776.76246,	303781.60113,	303786.43981,	303791.27849,	303796.11719,	303800.95588,	303805.79459,	303810.63330,	303815.47202,	303820.31074,
303825.14947,	303829.98820,	303834.82695,	303839.66569,	303844.50445,	303849.34321,	303854.18198,	303859.02075,	303863.85953,	303868.69832,
303873.53711,	303878.37591,	303883.21471,	303888.05352,	303892.89234,	303897.73117,	303902.57000,	303907.40883,	303912.24768,	303917.08652,
303921.92538,	303926.76424,	303931.60311,	303936.44198,	303941.28086,	303946.11975,	303950.95864,	303955.79754,	303960.63645,	303965.47536,
303970.31428,	303975.15320,	303979.99214,	303984.83107,	303989.67002,	303994.50897,	303999.34792,	304004.18688,	304009.02585,	304013.86483,
304018.70381,	304023.54280,	304028.38179,	304033.22079,	304038.05980,	304042.89881,	304047.73783,	304052.57685,	304057.41589,	304062.25492,
304067.09397,	304071.93302,	304076.77207,	304081.61114,	304086.45021,	304091.28928,	304096.12836,	304100.96745,	304105.80655,	304110.64565,
304115.48476,	304120.32387,	304125.16299,	304130.00211,	304134.84125,	304139.68039,	304144.51953,	304149.35868,	304154.19784,	304159.03700,
304163.87617,	304168.71535,	304173.55453,	304178.39372,	304183.23291,	304188.07212,	304192.91132,	304197.75054,	304202.58976,	304207.42898,
304212.26822,	304217.10746,	304221.94670,	304226.78595,	304231.62521,	304236.46448,	304241.30375,	304246.14302,	304250.98231,	304255.82160,
304260.66089,	304265.50019,	304270.33950,	304275.17882,	304280.01814,	304284.85747,	304289.69680,	304294.53614,	304299.37548,	304304.21484,
304309.05420,	304313.89356,	304318.73293,	304323.57231,	304328.41169,	304333.25108,	304338.09048,	304342.92988,	304347.76929,	304352.60871,
304357.44813,	304362.28756,	304367.12699,	304371.96643,	304376.80588,	304381.64533,	304386.48479,	304391.32425,	304396.16373,	304401.00320,
304405.84269,	304410.68218,	304415.52168,	304420.36118,	304425.20069,	304430.04020,	304434.87973,	304439.71925,	304444.55879,	304449.39833,
304454.23788,	304459.07743,	304463.91699,	304468.75656,	304473.59613,	304478.43571,	304483.27529,	304488.11488,	304492.95448,	304497.79408,
304502.63369,	304507.47331,	304512.31293,	304517.15256,	304521.99220,	304526.83184,	304531.67149,	304536.51114,	304541.35080,	304546.19047,
304551.03014,	304555.86982,	304560.70950,	304565.54920,	304570.38889,	304575.22860,	304580.06831,	304584.90803,	304589.74775,	304594.58748,
304599.42721,	304604.26696,	304609.10670,	304613.94646,	304618.78622,	304623.62599,	304628.46576,	304633.30554,	304638.14533,	304642.98512,
304647.82492,	304652.66472,	304657.50453,	304662.34435,	304667.18417,	304672.02400,	304676.86384,	304681.70368,	304686.54353,	304691.38338,
304696.22325,	304701.06311,	304705.90299,	304710.74287,	304715.58275,	304720.42265,	304725.26255,	304730.10245,	304734.94236,	304739.78228,
304744.62220,	304749.46213,	304754.30207,	304759.14201,	304763.98196,	304768.82192,	304773.66188,	304778.50185,	304783.34182,	304788.18180,
304793.02179,	304797.86178,	304802.70178,	304807.54179,	304812.38180,	304817.22182,	304822.06184,	304826.90187,	304831.74191,	304836.58195,
304841.42200,	304846.26206,	304851.10212,	304855.94219,	304860.78226,	304865.62235,	304870.46243,	304875.30253,	304880.14263,	304884.98273,
304889.82284,	304894.66296,	304899.50309,	304904.34322,	304909.18336,	304914.02350,	304918.86365,	304923.70381,	304928.54397,	304933.38414,
304938.22431,	304943.06449,	304947.90468,	304952.74488,	304957.58508,	304962.42528,	304967.26550,	304972.10571,	304976.94594,	304981.78617,
304986.62641,	304991.46665,	304996.30690,	305001.14716,	305005.98742,	305010.82769,	305015.66797,	305020.50825,	305025.34854,	305030.18883,
305035.02913,	305039.86944,	305044.70975,	305049.55007,	305054.39040,	305059.23073,	305064.07107,	305068.91141,	305073.75176,	305078.59212,
305083.43248,	305088.27285,	305093.11323,	305097.95361,	305102.79400,	305107.63440,	305112.47480,	305117.31520,	305122.15562,	305126.99604,
305131.83646,	305136.67690,	305141.51733,	305146.35778,	305151.19823,	305156.03869,	305160.87915,	305165.71962,	305170.56010,	305175.40058,
305180.24107,	305185.08156,	305189.92206,	305194.76257,	305199.60309,	305204.44361,	305209.28413,	305214.12467,	305218.96520,	305223.80575,
305228.64630,	305233.48686,	305238.32742,	305243.16799,	305248.00857,	305252.84915,	305257.68974,	305262.53034,	305267.37094,	305272.21155,
305277.05216,	305281.89278,	305286.73341,	305291.57404,	305296.41468,	305301.25532,	305306.09598,	305310.93663,	305315.77730,	305320.61797,
305325.45865,	305330.29933,	305335.14002,	305339.98071,	305344.82142,	305349.66212,	305354.50284,	305359.34356,	305364.18429,	305369.02502,
305373.86576,	305378.70651,	305383.54726,	305388.38802,	305393.22878,	305398.06955,	305402.91033,	305407.75111,	305412.59190,	305417.43270,
305422.27350,	305427.11431,	305431.95512,	305436.79594,	305441.63677,	305446.47760,	305451.31844,	305456.15929,	305461.00014,	305465.84100,
305470.68187,	305475.52274,	305480.36361,	305485.20450,	305490.04539,	305494.88628,	305499.72719,	305504.56809,	305509.40901,	305514.24993,
305519.09086,	305523.93179,	305528.77273,	305533.61368,	305538.45463,	305543.29559,	305548.13655,	305552.97753,	305557.81850,	305562.65949,
305567.50048,	305572.34147,	305577.18248,	305582.02348,	305586.86450,	305591.70552,	305596.54655,	305601.38758,	305606.22862,	305611.06967,
305615.91072,	305620.75178,	305625.59285,	305630.43392,	305635.27500,	305640.11608,	305644.95717,	305649.79827,	305654.63937,	305659.48048,
305664.32159,	305669.16272,	305674.00384,	305678.84498,	305683.68612,	305688.52726,	305693.36842,	305698.20958,	305703.05074,	305707.89191,
305712.73309,	305717.57428,	305722.41547,	305727.25666,	305732.09787,	305736.93908,	305741.78029,	305746.62151,	305751.46274,	305756.30398,
305761.14522,	305765.98646,	305770.82772,	305775.66898,	305780.51024,	305785.35151,	305790.19279,	305795.03408,	305799.87537,	305804.71666,
305809.55797,	305814.39928,	305819.24059,	305824.08191,	305828.92324,	305833.76458,	305838.60592,	305843.44726,	305848.28862,	305853.12998,
305857.97134,	305862.81271,	305867.65409,	305872.49548,	305877.33687,	305882.17826,	305887.01967,	305891.86108,	305896.70249,	305901.54391,
305906.38534,	305911.22678,	305916.06822,	305920.90967,	305925.75112,	305930.59258,	305935.43404,	305940.27552,	305945.11699,	305949.95848,
305954.79997,	305959.64147,	305964.48297,	305969.32448,	305974.16600,	305979.00752,	305983.84905,	305988.69058,	305993.53212,	305998.37367,
306003.21522,	306008.05678,	306012.89835,	306017.73992,	306022.58150,	306027.42308,	306032.26467,	306037.10627,	306041.94788,	306046.78948,
306051.63110,	306056.47272,	306061.31435,	306066.15599,	306070.99763,	306075.83927,	306080.68093,	306085.52259,	306090.36425,	306095.20593,
306100.04760,	306104.88929,	306109.73098,	306114.57268,	306119.41438,	306124.25609,	306129.09781,	306133.93953,	306138.78126,	306143.62299,
306148.46473,	306153.30648,	306158.14823,	306162.98999,	306167.83176,	306172.67353,	306177.51531,	306182.35710,	306187.19889,	306192.04068,
306196.88249,	306201.72430,	306206.56611,	306211.40794,	306216.24976,	306221.09160,	306225.93344,	306230.77529,	306235.61714,	306240.45900,
306245.30087,	306250.14274,	306254.98462,	306259.82650,	306264.66839,	306269.51029,	306274.35219,	306279.19410,	306284.03602,	306288.87794,
306293.71987,	306298.56181,	306303.40375,	306308.24569,	306313.08765,	306317.92961,	306322.77157,	306327.61355,	306332.45552,	306337.29751,
306342.13950,	306346.98150,	306351.82350,	306356.66551,	306361.50753,	306366.34955,	306371.19158,	306376.03361,	306380.87565,	306385.71770,
306390.55975,	306395.40181,	306400.24388,	306405.08595,	306409.92803,	306414.77012,	306419.61221,	306424.45430,	306429.29641,	306434.13852,
306438.98063,	306443.82276,	306448.66488,	306453.50702,	306458.34916,	306463.19131,	306468.03346,	306472.87562,	306477.71779,	306482.55996,
306487.40214,	306492.24432,	306497.08651,	306501.92871,	306506.77091,	306511.61312,	306516.45534,	306521.29756,	306526.13979,	306530.98202,
306535.82427,	306540.66651,	306545.50877,	306550.35103,	306555.19329,	306560.03556,	306564.87784,	306569.72013,	306574.56242,	306579.40472,
306584.24702,	306589.08933,	306593.93164,	306598.77397,	306603.61629,	306608.45863,	306613.30097,	306618.14332,	306622.98567,	306627.82803,
306632.67040,	306637.51277,	306642.35515,	306647.19753,	306652.03992,	306656.88232,	306661.72472,	306666.56713,	306671.40955,	306676.25197,
306681.09440,	306685.93683,	306690.77927,	306695.62172,	306700.46417,	306705.30663,	306710.14910,	306714.99157,	306719.83405,	306724.67653,
306729.51902,	306734.36152,	306739.20402,	306744.04653,	306748.88905,	306753.73157,	306758.57410,	306763.41663,	306768.25917,	306773.10172,
306777.94427,	306782.78683,	306787.62940,	306792.47197,	306797.31455,	306802.15713,	306806.99972,	306811.84232,	306816.68492,	306821.52753,
306826.37015,	306831.21277,	306836.05540,	306840.89803,	306845.74067,	306850.58332,	306855.42597,	306860.26863,	306865.11130,	306869.95397,
306874.79664,	306879.63933,	306884.48202,	306889.32472,	306894.16742,	306899.01013,	306903.85284,	306908.69556,	306913.53829,	306918.38103,
306923.22377,	306928.06651,	306932.90927,	306937.75202,	306942.59479,	306947.43756,	306952.28034,	306957.12312,	306961.96591,	306966.80871,
306971.65151,	306976.49432,	306981.33714,	306986.17996,	306991.02279,	306995.86562,	307000.70846,	307005.55131,	307010.39416,	307015.23702,
307020.07988,	307024.92275,	307029.76563,	307034.60851,	307039.45140,	307044.29430,	307049.13720,	307053.98011,	307058.82303,	307063.66595,
307068.50887,	307073.35181,	307078.19475,	307083.03769,	307087.88065,	307092.72361,	307097.56657,	307102.40954,	307107.25252,	307112.09550,
307116.93849,	307121.78149,	307126.62449,	307131.46750,	307136.31051,	307141.15353,	307145.99656,	307150.83959,	307155.68263,	307160.52568,
307165.36873,	307170.21179,	307175.05485,	307179.89792,	307184.74100,	307189.58408,	307194.42717,	307199.27027,	307204.11337,	307208.95648,
307213.79959,	307218.64272,	307223.48584,	307228.32897,	307233.17211,	307238.01526,	307242.85841,	307247.70157,	307252.54473,	307257.38790,
307262.23108,	307267.07426,	307271.91745,	307276.76065,	307281.60385,	307286.44706,	307291.29027,	307296.13349,	307300.97672,	307305.81995,
307310.66319,	307315.50644,	307320.34969,	307325.19295,	307330.03621,	307334.87948,	307339.72276,	307344.56604,	307349.40933,	307354.25262,
307359.09592,	307363.93923,	307368.78254,	307373.62586,	307378.46919,	307383.31252,	307388.15586,	307392.99921,	307397.84256,	307402.68592,
307407.52928,	307412.37265,	307417.21603,	307422.05941,	307426.90280,	307431.74619,	307436.58959,	307441.43300,	307446.27641,	307451.11983,
307455.96326,	307460.80669,	307465.65013,	307470.49357,	307475.33702,	307480.18048,	307485.02394,	307489.86741,	307494.71089,	307499.55437,
307504.39786,	307509.24135,	307514.08485,	307518.92836,	307523.77187,	307528.61539,	307533.45892,	307538.30245,	307543.14599,	307547.98953,
307552.83308,	307557.67664,	307562.52020,	307567.36377,	307572.20735,	307577.05093,	307581.89452,	307586.73811,	307591.58171,	307596.42532,
307601.26893,	307606.11255,	307610.95617,	307615.79981,	307620.64344,	307625.48709,	307630.33074,	307635.17439,	307640.01806,	307644.86172,
307649.70540,	307654.54908,	307659.39277,	307664.23646,	307669.08016,	307673.92387,	307678.76758,	307683.61130,	307688.45502,	307693.29875,
307698.14249,	307702.98623,	307707.82998,	307712.67374,	307717.51750,	307722.36127,	307727.20505,	307732.04883,	307736.89261,	307741.73641,
307746.58021,	307751.42401,	307756.26782,	307761.11164,	307765.95547,	307770.79930,	307775.64313,	307780.48698,	307785.33082,	307790.17468,
307795.01854,	307799.86241,	307804.70628,	307809.55016,	307814.39405,	307819.23794,	307824.08184,	307828.92575,	307833.76966,	307838.61358,
307843.45750,	307848.30143,	307853.14537,	307857.98931,	307862.83326,	307867.67721,	307872.52117,	307877.36514,	307882.20912,	307887.05310,
307891.89708,	307896.74107,	307901.58507,	307906.42908,	307911.27309,	307916.11711,	307920.96113,	307925.80516,	307930.64919,	307935.49324,
307940.33728,	307945.18134,	307950.02540,	307954.86947,	307959.71354,	307964.55762,	307969.40170,	307974.24580,	307979.08989,	307983.93400,
307988.77811,	307993.62223,	307998.46635,	308003.31048,	308008.15461,	308012.99875,	308017.84290,	308022.68706,	308027.53122,	308032.37538,
308037.21956,	308042.06373,	308046.90792,	308051.75211,	308056.59631,	308061.44051,	308066.28472,	308071.12894,	308075.97316,	308080.81739,
308085.66162,	308090.50586,	308095.35011,	308100.19437,	308105.03862,	308109.88289,	308114.72716,	308119.57144,	308124.41573,	308129.26002,
308134.10431,	308138.94862,	308143.79293,	308148.63724,	308153.48156,	308158.32589,	308163.17023,	308168.01457,	308172.85891,	308177.70327,
308182.54762,	308187.39199,	308192.23636,	308197.08074,	308201.92512,	308206.76951,	308211.61391,	308216.45831,	308221.30272,	308226.14714,
308230.99156,	308235.83599,	308240.68042,	308245.52486,	308250.36930,	308255.21376,	308260.05822,	308264.90268,	308269.74715,	308274.59163,
308279.43611,	308284.28060,	308289.12510,	308293.96960,	308298.81411,	308303.65862,	308308.50314,	308313.34767,	308318.19220,	308323.03674,
308327.88129,	308332.72584,	308337.57040,	308342.41496,	308347.25953,	308352.10411,	308356.94869,	308361.79328,	308366.63788,	308371.48248,
308376.32708,	308381.17170,	308386.01632,	308390.86094,	308395.70558,	308400.55022,	308405.39486,	308410.23951,	308415.08417,	308419.92883,
308424.77350,	308429.61818,	308434.46286,	308439.30755,	308444.15224,	308448.99694,	308453.84165,	308458.68636,	308463.53108,	308468.37581,
308473.22054,	308478.06528,	308482.91002,	308487.75477,	308492.59953,	308497.44429,	308502.28906,	308507.13384,	308511.97862,	308516.82341,
308521.66820,	308526.51300,	308531.35781,	308536.20262,	308541.04744,	308545.89226,	308550.73710,	308555.58193,	308560.42678,	308565.27163,
308570.11648,	308574.96134,	308579.80621,	308584.65109,	308589.49597,	308594.34085,	308599.18575,	308604.03065,	308608.87555,	308613.72047,
308618.56538,	308623.41031,	308628.25524,	308633.10017,	308637.94512,	308642.79007,	308647.63502,	308652.47998,	308657.32495,	308662.16993,
308667.01491,	308671.85989,	308676.70488,	308681.54988,	308686.39489,	308691.23990,	308696.08492,	308700.92994,	308705.77497,	308710.62001,
308715.46505,	308720.31010,	308725.15515,	308730.00021,	308734.84528,	308739.69035,	308744.53543,	308749.38052,	308754.22561,	308759.07071,
308763.91581,	308768.76092,	308773.60604,	308778.45116,	308783.29629,	308788.14143,	308792.98657,	308797.83171,	308802.67687,	308807.52203,
308812.36720,	308817.21237,	308822.05755,	308826.90273,	308831.74792,	308836.59312,	308841.43832,	308846.28353,	308851.12875,	308855.97397,
308860.81920,	308865.66443,	308870.50967,	308875.35492,	308880.20017,	308885.04543,	308889.89070,	308894.73597,	308899.58125,	308904.42653,
308909.27182,	308914.11712,	308918.96242,	308923.80773,	308928.65305,	308933.49837,	308938.34370,	308943.18903,	308948.03437,	308952.87972,
308957.72507,	308962.57043,	308967.41579,	308972.26116,	308977.10654,	308981.95192,	308986.79731,	308991.64271,	308996.48811,	309001.33352,
309006.17893,	309011.02435,	309015.86978,	309020.71521,	309025.56065,	309030.40610,	309035.25155,	309040.09701,	309044.94247,	309049.78794,
309054.63342,	309059.47890,	309064.32439,	309069.16988,	309074.01538,	309078.86089,	309083.70640,	309088.55192,	309093.39745,	309098.24298,
309103.08852,	309107.93407,	309112.77962,	309117.62517,	309122.47074,	309127.31631,	309132.16188,	309137.00746,	309141.85305,	309146.69864,
309151.54424,	309156.38985,	309161.23546,	309166.08108,	309170.92671,	309175.77234,	309180.61798,	309185.46362,	309190.30927,	309195.15493,
309200.00059,	309204.84626,	309209.69193,	309214.53761,	309219.38330,	309224.22899,	309229.07469,	309233.92040,	309238.76611,	309243.61183,
309248.45755,	309253.30328,	309258.14902,	309262.99476,	309267.84051,	309272.68627,	309277.53203,	309282.37779,	309287.22357,	309292.06935,
309296.91513,	309301.76093,	309306.60673,	309311.45253,	309316.29834,	309321.14416,	309325.98998,	309330.83581,	309335.68165,	309340.52749,
309345.37334,	309350.21919,	309355.06505,	309359.91092,	309364.75679,	309369.60267,	309374.44856,	309379.29445,	309384.14034,	309388.98625,
309393.83216,	309398.67807,	309403.52400,	309408.36993,	309413.21586,	309418.06180,	309422.90775,	309427.75370,	309432.59966,	309437.44563,
309442.29160,	309447.13758,	309451.98356,	309456.82955,	309461.67555,	309466.52155,	309471.36756,	309476.21358,	309481.05960,	309485.90563,
309490.75166,	309495.59770,	309500.44375,	309505.28980,	309510.13586,	309514.98192,	309519.82799,	309524.67407,	309529.52015,	309534.36624,
309539.21234,	309544.05844,	309548.90455,	309553.75066,	309558.59678,	309563.44291,	309568.28904,	309573.13518,	309577.98133,	309582.82748,
309587.67364,	309592.51980,	309597.36597,	309602.21215,	309607.05833,	309611.90452,	309616.75071,	309621.59691,	309626.44312,	309631.28933,
309636.13555,	309640.98178,	309645.82801,	309650.67425,	309655.52049,	309660.36674,	309665.21300,	309670.05926,	309674.90553,	309679.75181,
309684.59809,	309689.44438,	309694.29067,	309699.13697,	309703.98328,	309708.82959,	309713.67591,	309718.52223,	309723.36856,	309728.21490,
309733.06124,	309737.90759,	309742.75395,	309747.60031,	309752.44668,	309757.29305,	309762.13943,	309766.98582,	309771.83221,	309776.67861,
309781.52502,	309786.37143,	309791.21785,	309796.06427,	309800.91070,	309805.75714,	309810.60358,	309815.45003,	309820.29648,	309825.14294,
309829.98941,	309834.83588,	309839.68236,	309844.52885,	309849.37534,	309854.22184,	309859.06834,	309863.91485,	309868.76137,	309873.60789,
309878.45442,	309883.30095,	309888.14750,	309892.99404,	309897.84060,	309902.68716,	309907.53372,	309912.38029,	309917.22687,	309922.07346,
309926.92005,	309931.76664,	309936.61325,	309941.45986,	309946.30647,	309951.15309,	309955.99972,	309960.84636,	309965.69300,	309970.53964,
309975.38629,	309980.23295,	309985.07962,	309989.92629,	309994.77297,	309999.61965,	310004.46634,	310009.31304,	310014.15974,	310019.00645,
310023.85316,	310028.69988,	310033.54661,	310038.39334,	310043.24008,	310048.08682,	310052.93358,	310057.78033,	310062.62710,	310067.47387,
310072.32064,	310077.16743,	310082.01421,	310086.86101,	310091.70781,	310096.55462,	310101.40143,	310106.24825,	310111.09507,	310115.94191,
310120.78874,	310125.63559,	310130.48244,	310135.32930,	310140.17616,	310145.02303,	310149.86990,	310154.71678,	310159.56367,	310164.41056,
310169.25746,	310174.10437,	310178.95128,	310183.79820,	310188.64512,	310193.49205,	310198.33899,	310203.18593,	310208.03288,	310212.87984,
310217.72680,	310222.57377,	310227.42074,	310232.26772,	310237.11471,	310241.96170,	310246.80870,	310251.65570,	310256.50272,	310261.34973,
310266.19676,	310271.04378,	310275.89082,	310280.73786,	310285.58491,	310290.43196,	310295.27902,	310300.12609,	310304.97316,	310309.82024,
310314.66733,	310319.51442,	310324.36152,	310329.20862,	310334.05573,	310338.90285,	310343.74997,	310348.59710,	310353.44423,	310358.29137,
310363.13852,	310367.98567,	310372.83283,	310377.68000,	310382.52717,	310387.37434,	310392.22153,	310397.06872,	310401.91591,	310406.76312,
310411.61033,	310416.45754,	310421.30476,	310426.15199,	310430.99922,	310435.84646,	310440.69371,	310445.54096,	310450.38822,	310455.23548,
310460.08275,	310464.93003,	310469.77731,	310474.62460,	310479.47189,	310484.31919,	310489.16650,	310494.01382,	310498.86113,	310503.70846,
310508.55579,	310513.40313,	310518.25048,	310523.09783,	310527.94518,	310532.79255,	310537.63991,	310542.48729,	310547.33467,	310552.18206,
310557.02945,	310561.87685,	310566.72426,	310571.57167,	310576.41909,	310581.26651,	310586.11394,	310590.96138,	310595.80882,	310600.65627,
310605.50373,	310610.35119,	310615.19866,	310620.04613,	310624.89361,	310629.74110,	310634.58859,	310639.43609,	310644.28359,	310649.13111,
310653.97862,	310658.82615,	310663.67368,	310668.52121,	310673.36875,	310678.21630,	310683.06385,	310687.91142,	310692.75898,	310697.60655,
310702.45413,	310707.30172,	310712.14931,	310716.99691,	310721.84451,	310726.69212,	310731.53974,	310736.38736,	310741.23499,	310746.08262,
310750.93026,	310755.77791,	310760.62556,	310765.47322,	310770.32088,	310775.16856,	310780.01623,	310784.86392,	310789.71161,	310794.55930,
310799.40701,	310804.25471,	310809.10243,	310813.95015,	310818.79788,	310823.64561,	310828.49335,	310833.34109,	310838.18884,	310843.03660,
310847.88437,	310852.73214,	310857.57991,	310862.42769,	310867.27548,	310872.12328,	310876.97108,	310881.81889,	310886.66670,	310891.51452,
310896.36234,	310901.21018,	310906.05801,	310910.90586,	310915.75371,	310920.60156,	310925.44943,	310930.29730,	310935.14517,	310939.99305,
310944.84094,	310949.68883,	310954.53673,	310959.38464,	310964.23255,	310969.08047,	310973.92839,	310978.77632,	310983.62426,	310988.47220,
310993.32015,	310998.16810,	311003.01606,	311007.86403,	311012.71201,	311017.55999,	311022.40797,	311027.25596,	311032.10396,	311036.95197,
311041.79998,	311046.64799,	311051.49602,	311056.34404,	311061.19208,	311066.04012,	311070.88817,	311075.73622,	311080.58428,	311085.43235,
311090.28042,	311095.12850,	311099.97658,	311104.82467,	311109.67277,	311114.52087,	311119.36898,	311124.21710,	311129.06522,	311133.91334,
311138.76148,	311143.60962,	311148.45776,	311153.30592,	311158.15407,	311163.00224,	311167.85041,	311172.69859,	311177.54677,	311182.39496,
311187.24315,	311192.09136,	311196.93956,	311201.78778,	311206.63600,	311211.48422,	311216.33246,	311221.18069,	311226.02894,	311230.87719,
311235.72545,	311240.57371,	311245.42198,	311250.27025,	311255.11853,	311259.96682,	311264.81512,	311269.66342,	311274.51172,	311279.36003,
311284.20835,	311289.05668,	311293.90501,	311298.75335,	311303.60169,	311308.45004,	311313.29839,	311318.14675,	311322.99512,	311327.84350,
311332.69188,	311337.54026,	311342.38865,	311347.23705,	311352.08546,	311356.93387,	311361.78229,	311366.63071,	311371.47914,	311376.32757,
311381.17602,	311386.02446,	311390.87292,	311395.72138,	311400.56984,	311405.41832,	311410.26679,	311415.11528,	311419.96377,	311424.81227,
311429.66077,	311434.50928,	311439.35779,	311444.20632,	311449.05484,	311453.90338,	311458.75192,	311463.60046,	311468.44902,	311473.29758,
311478.14614,	311482.99471,	311487.84329,	311492.69187,	311497.54046,	311502.38906,	311507.23766,	311512.08627,	311516.93488,	311521.78350,
311526.63213,	311531.48076,	311536.32940,	311541.17804,	311546.02669,	311550.87535,	311555.72401,	311560.57268,	311565.42136,	311570.27004,
311575.11873,	311579.96742,	311584.81612,	311589.66483,	311594.51354,	311599.36226,	311604.21098,	311609.05971,	311613.90845,	311618.75719,
311623.60594,	311628.45470,	311633.30346,	311638.15223,	311643.00100,	311647.84978,	311652.69857,	311657.54736,	311662.39616,	311667.24496,
311672.09378,	311676.94259,	311681.79142,	311686.64025,	311691.48908,	311696.33792,	311701.18677,	311706.03562,	311710.88448,	311715.73335,
311720.58222,	311725.43110,	311730.27999,	311735.12888,	311739.97777,	311744.82668,	311749.67559,	311754.52450,	311759.37342,	311764.22235,
311769.07128,	311773.92022,	311778.76917,	311783.61812,	311788.46708,	311793.31605,	311798.16502,	311803.01399,	311807.86298,	311812.71197,
311817.56096,	311822.40996,	311827.25897,	311832.10798,	311836.95700,	311841.80603,	311846.65506,	311851.50410,	311856.35315,	311861.20220,
311866.05125,	311870.90032,	311875.74938,	311880.59846,	311885.44754,	311890.29663,	311895.14572,	311899.99482,	311904.84393,	311909.69304,
311914.54216,	311919.39128,	311924.24041,	311929.08955,	311933.93869,	311938.78784,	311943.63700,	311948.48616,	311953.33533,	311958.18450,
311963.03368,	311967.88287,	311972.73206,	311977.58126,	311982.43046,	311987.27967,	311992.12889,	311996.97811,	312001.82734,	312006.67658,
312011.52582,	312016.37506,	312021.22432,	312026.07358,	312030.92284,	312035.77211,	312040.62139,	312045.47068,	312050.31997,	312055.16926,
312060.01857,	312064.86788,	312069.71719,	312074.56651,	312079.41584,	312084.26517,	312089.11451,	312093.96386,	312098.81321,	312103.66257,
312108.51193,	312113.36130,	312118.21068,	312123.06006,	312127.90945,	312132.75884,	312137.60825,	312142.45765,	312147.30707,	312152.15649,
312157.00591,	312161.85534,	312166.70478,	312171.55422,	312176.40367,	312181.25313,	312186.10259,	312190.95206,	312195.80154,	312200.65102,
312205.50050,	312210.35000,	312215.19950,	312220.04900,	312224.89851,	312229.74803,	312234.59755,	312239.44708,	312244.29662,	312249.14616,
312253.99571,	312258.84527,	312263.69483,	312268.54439,	312273.39397,	312278.24355,	312283.09313,	312287.94272,	312292.79232,	312297.64192,
312302.49153,	312307.34115,	312312.19077,	312317.04040,	312321.89003,	312326.73967,	312331.58932,	312336.43897,	312341.28863,	312346.13830,
312350.98797,	312355.83765,	312360.68733,	312365.53702,	312370.38672,	312375.23642,	312380.08612,	312384.93584,	312389.78556,	312394.63529,
312399.48502,	312404.33476,	312409.18450,	312414.03425,	312418.88401,	312423.73377,	312428.58354,	312433.43332,	312438.28310,	312443.13289,
312447.98268,	312452.83248,	312457.68229,	312462.53210,	312467.38192,	312472.23174,	312477.08157,	312481.93141,	312486.78125,	312491.63110,
312496.48096,	312501.33082,	312506.18069,	312511.03056,	312515.88044,	312520.73033,	312525.58022,	312530.43012,	312535.28002,	312540.12993,
312544.97985,	312549.82977,	312554.67970,	312559.52964,	312564.37958,	312569.22953,	312574.07948,	312578.92944,	312583.77940,	312588.62938,
312593.47935,	312598.32934,	312603.17933,	312608.02933,	312612.87933,	312617.72934,	312622.57935,	312627.42937,	312632.27940,	312637.12943,
312641.97947,	312646.82952,	312651.67957,	312656.52963,	312661.37969,	312666.22976,	312671.07984,	312675.92992,	312680.78001,	312685.63010,
312690.48020,	312695.33031,	312700.18042,	312705.03054,	312709.88067,	312714.73080,	312719.58094,	312724.43108,	312729.28123,	312734.13139,
312738.98155,	312743.83172,	312748.68189,	312753.53207,	312758.38226,	312763.23245,	312768.08265,	312772.93285,	312777.78307,	312782.63328,
312787.48351,	312792.33374,	312797.18397,	312802.03421,	312806.88446,	312811.73471,	312816.58497,	312821.43524,	312826.28551,	312831.13579,
312835.98608,	312840.83637,	312845.68666,	312850.53697,	312855.38728,	312860.23759,	312865.08791,	312869.93824,	312874.78857,	312879.63891,
312884.48926,	312889.33961,	312894.18997,	312899.04034,	312903.89071,	312908.74108,	312913.59147,	312918.44185,	312923.29225,	312928.14265,
312932.99306,	312937.84347,	312942.69389,	312947.54432,	312952.39475,	312957.24519,	312962.09563,	312966.94608,	312971.79654,	312976.64700,
312981.49747,	312986.34794,	312991.19842,	312996.04891,	313000.89940,	313005.74990,	313010.60041,	313015.45092,	313020.30144,	313025.15196,
313030.00249,	313034.85303,	313039.70357,	313044.55412,	313049.40467,	313054.25523,	313059.10580,	313063.95637,	313068.80695,	313073.65753,
313078.50813,	313083.35872,	313088.20933,	313093.05994,	313097.91055,	313102.76117,	313107.61180,	313112.46243,	313117.31307,	313122.16372,
313127.01437,	313131.86503,	313136.71570,	313141.56637,	313146.41704,	313151.26773,	313156.11842,	313160.96911,	313165.81981,	313170.67052,
313175.52123,	313180.37195,	313185.22268,	313190.07341,	313194.92415,	313199.77489,	313204.62564,	313209.47640,	313214.32716,	313219.17793,
313224.02871,	313228.87949,	313233.73027,	313238.58107,	313243.43187,	313248.28267,	313253.13348,	313257.98430,	313262.83513,	313267.68596,
313272.53679,	313277.38763,	313282.23848,	313287.08934,	313291.94020,	313296.79106,	313301.64194,	313306.49282,	313311.34370,	313316.19459,
313321.04549,	313325.89639,	313330.74730,	313335.59822,	313340.44914,	313345.30007,	313350.15100,	313355.00194,	313359.85289,	313364.70384,
313369.55480,	313374.40576,	313379.25673,	313384.10771,	313388.95869,	313393.80968,	313398.66068,	313403.51168,	313408.36269,	313413.21370,
313418.06472,	313422.91575,	313427.76678,	313432.61782,	313437.46886,	313442.31991,	313447.17097,	313452.02203,	313456.87310,	313461.72417,
313466.57526,	313471.42634,	313476.27744,	313481.12853,	313485.97964,	313490.83075,	313495.68187,	313500.53299,	313505.38412,	313510.23526,
313515.08640,	313519.93755,	313524.78870,	313529.63986,	313534.49103,	313539.34220,	313544.19338,	313549.04457,	313553.89576,	313558.74696,
313563.59816,	313568.44937,	313573.30058,	313578.15181,	313583.00303,	313587.85427,	313592.70551,	313597.55675,	313602.40801,	313607.25926,
313612.11053,	313616.96180,	313621.81308,	313626.66436,	313631.51565,	313636.36694,	313641.21824,	313646.06955,	313650.92086,	313655.77218,
313660.62351,	313665.47484,	313670.32618,	313675.17752,	313680.02887,	313684.88023,	313689.73159,	313694.58296,	313699.43433,	313704.28571,
313709.13710,	313713.98849,	313718.83989,	313723.69130,	313728.54271,	313733.39413,	313738.24555,	313743.09698,	313747.94842,	313752.79986,
313757.65131,	313762.50276,	313767.35422,	313772.20569,	313777.05716,	313781.90864,	313786.76012,	313791.61161,	313796.46311,	313801.31461,
313806.16612,	313811.01764,	313815.86916,	313820.72069,	313825.57222,	313830.42376,	313835.27530,	313840.12686,	313844.97841,	313849.82998,
313854.68155,	313859.53312,	313864.38471,	313869.23630,	313874.08789,	313878.93949,	313883.79110,	313888.64271,	313893.49433,	313898.34596,
313903.19759,	313908.04922,	313912.90087,	313917.75252,	313922.60417,	313927.45583,	313932.30750,	313937.15918,	313942.01086,	313946.86254,
313951.71424,	313956.56593,	313961.41764,	313966.26935,	313971.12107,	313975.97279,	313980.82452,	313985.67625,	313990.52800,	313995.37974,
314000.23150,	314005.08326,	314009.93502,	314014.78679,	314019.63857,	314024.49036,	314029.34215,	314034.19394,	314039.04574,	314043.89755,
314048.74937,	314053.60119,	314058.45301,	314063.30485,	314068.15669,	314073.00853,	314077.86038,	314082.71224,	314087.56410,	314092.41597,
314097.26785,	314102.11973,	314106.97162,	314111.82351,	314116.67541,	314121.52732,	314126.37923,	314131.23115,	314136.08308,	314140.93501,
314145.78694,	314150.63889,	314155.49083,	314160.34279,	314165.19475,	314170.04672,	314174.89869,	314179.75067,	314184.60266,	314189.45465,
314194.30665,	314199.15865,	314204.01066,	314208.86268,	314213.71470,	314218.56673,	314223.41876,	314228.27080,	314233.12285,	314237.97490,
314242.82696,	314247.67903,	314252.53110,	314257.38317,	314262.23526,	314267.08735,	314271.93944,	314276.79154,	314281.64365,	314286.49577,
314291.34789,	314296.20001,	314301.05214,	314305.90428,	314310.75643,	314315.60858,	314320.46073,	314325.31290,	314330.16507,	314335.01724,
314339.86942,	314344.72161,	314349.57380,	314354.42600,	314359.27821,	314364.13042,	314368.98264,	314373.83486,	314378.68709,	314383.53932,
314388.39157,	314393.24381,	314398.09607,	314402.94833,	314407.80060,	314412.65287,	314417.50515,	314422.35743,	314427.20972,	314432.06202,
314436.91432,	314441.76663,	314446.61895,	314451.47127,	314456.32360,	314461.17593,	314466.02827,	314470.88062,	314475.73297,	314480.58533,
314485.43769,	314490.29006,	314495.14244,	314499.99482,	314504.84721,	314509.69960,	314514.55200,	314519.40441,	314524.25682,	314529.10924,
314533.96167,	314538.81410,	314543.66653,	314548.51898,	314553.37143,	314558.22388,	314563.07634,	314567.92881,	314572.78129,	314577.63377,
314582.48625,	314587.33874,	314592.19124,	314597.04375,	314601.89626,	314606.74877,	314611.60130,	314616.45383,	314621.30636,	314626.15890,
314631.01145,	314635.86400,	314640.71656,	314645.56913,	314650.42170,	314655.27428,	314660.12686,	314664.97945,	314669.83204,	314674.68465,
314679.53725,	314684.38987,	314689.24249,	314694.09512,	314698.94775,	314703.80039,	314708.65303,	314713.50568,	314718.35834,	314723.21100,
314728.06367,	314732.91635,	314737.76903,	314742.62171,	314747.47441,	314752.32711,	314757.17981,	314762.03252,	314766.88524,	314771.73797,
314776.59070,	314781.44343,	314786.29617,	314791.14892,	314796.00168,	314800.85444,	314805.70720,	314810.55998,	314815.41276,	314820.26554,
314825.11833,	314829.97113,	314834.82393,	314839.67674,	314844.52956,	314849.38238,	314854.23521,	314859.08804,	314863.94088,	314868.79372,
314873.64658,	314878.49943,	314883.35230,	314888.20517,	314893.05805,	314897.91093,	314902.76382,	314907.61671,	314912.46961,	314917.32252,
314922.17543,	314927.02835,	314931.88127,	314936.73421,	314941.58714,	314946.44009,	314951.29304,	314956.14599,	314960.99895,	314965.85192,
314970.70489,	314975.55787,	314980.41086,	314985.26385,	314990.11685,	314994.96985,	314999.82287,	315004.67588,	315009.52890,	315014.38193,
315019.23497,	315024.08801,	315028.94106,	315033.79411,	315038.64717,	315043.50023,	315048.35330,	315053.20638,	315058.05946,	315062.91255,
315067.76565,	315072.61875,	315077.47186,	315082.32497,	315087.17809,	315092.03122,	315096.88435,	315101.73749,	315106.59063,	315111.44378,
315116.29694,	315121.15010,	315126.00327,	315130.85645,	315135.70963,	315140.56281,	315145.41601,	315150.26921,	315155.12241,	315159.97562,
315164.82884,	315169.68206,	315174.53529,	315179.38853,	315184.24177,	315189.09502,	315193.94827,	315198.80153,	315203.65480,	315208.50807,
315213.36135,	315218.21463,	315223.06792,	315227.92122,	315232.77452,	315237.62783,	315242.48115,	315247.33447,	315252.18780,	315257.04113,
315261.89447,	315266.74781,	315271.60116,	315276.45452,	315281.30789,	315286.16126,	315291.01463,	315295.86801,	315300.72140,	315305.57479,
315310.42819,	315315.28160,	315320.13501,	315324.98843,	315329.84186,	315334.69529,	315339.54872,	315344.40217,	315349.25561,	315354.10907,
315358.96253,	315363.81600,	315368.66947,	315373.52295,	315378.37643,	315383.22993,	315388.08342,	315392.93693,	315397.79044,	315402.64395,
315407.49747,	315412.35100,	315417.20454,	315422.05808,	315426.91162,	315431.76517,	315436.61873,	315441.47230,	315446.32587,	315451.17944,
315456.03303,	315460.88662,	315465.74021,	315470.59381,	315475.44742,	315480.30103,	315485.15465,	315490.00828,	315494.86191,	315499.71554,
315504.56919,	315509.42284,	315514.27649,	315519.13015,	315523.98382,	315528.83750,	315533.69118,	315538.54486,	315543.39855,	315548.25225,
315553.10596,	315557.95967,	315562.81338,	315567.66711,	315572.52083,	315577.37457,	315582.22831,	315587.08206,	315591.93581,	315596.78957,
315601.64333,	315606.49711,	315611.35088,	315616.20467,	315621.05846,	315625.91225,	315630.76605,	315635.61986,	315640.47367,	315645.32749,
315650.18132,	315655.03515,	315659.88899,	315664.74283,	315669.59668,	315674.45054,	315679.30440,	315684.15827,	315689.01215,	315693.86603,
315698.71991,	315703.57381,	315708.42771,	315713.28161,	315718.13552,	315722.98944,	315727.84336,	315732.69729,	315737.55123,	315742.40517,
315747.25912,	315752.11307,	315756.96703,	315761.82099,	315766.67497,	315771.52894,	315776.38293,	315781.23692,	315786.09091,	315790.94492,
315795.79892,	315800.65294,	315805.50696,	315810.36099,	315815.21502,	315820.06906,	315824.92310,	315829.77715,	315834.63121,	315839.48527,
315844.33934,	315849.19342,	315854.04750,	315858.90159,	315863.75568,	315868.60978,	315873.46388,	315878.31800,	315883.17211,	315888.02624,
315892.88037,	315897.73450,	315902.58865,	315907.44279,	315912.29695,	315917.15111,	315922.00527,	315926.85945,	315931.71362,	315936.56781,
315941.42200,	315946.27620,	315951.13040,	315955.98461,	315960.83882,	315965.69304,	315970.54727,	315975.40150,	315980.25574,	315985.10999,
315989.96424,	315994.81850,	315999.67276,	316004.52703,	316009.38131,	316014.23559,	316019.08988,	316023.94417,	316028.79847,	316033.65278,
316038.50709,	316043.36141,	316048.21573,	316053.07006,	316057.92440,	316062.77874,	316067.63309,	316072.48744,	316077.34180,	316082.19617,
316087.05054,	316091.90492,	316096.75931,	316101.61370,	316106.46810,	316111.32250,	316116.17691,	316121.03132,	316125.88574,	316130.74017,
316135.59461,	316140.44905,	316145.30349,	316150.15794,	316155.01240,	316159.86686,	316164.72133,	316169.57581,	316174.43029,	316179.28478,
316184.13928,	316188.99378,	316193.84828,	316198.70280,	316203.55731,	316208.41184,	316213.26637,	316218.12091,	316222.97545,	316227.83000,
316232.68455,	316237.53911,	316242.39368,	316247.24825,	316252.10283,	316256.95742,	316261.81201,	316266.66661,	316271.52121,	316276.37582,
316281.23044,	316286.08506,	316290.93969,	316295.79432,	316300.64896,	316305.50361,	316310.35826,	316315.21292,	316320.06758,	316324.92225,
316329.77693,	316334.63161,	316339.48630,	316344.34099,	316349.19569,	316354.05040,	316358.90511,	316363.75983,	316368.61456,	316373.46929,
316378.32403,	316383.17877,	316388.03352,	316392.88827,	316397.74303,	316402.59780,	316407.45258,	316412.30735,	316417.16214,	316422.01693,
316426.87173,	316431.72653,	316436.58134,	316441.43616,	316446.29098,	316451.14581,	316456.00064,	316460.85548,	316465.71033,	316470.56518,
316475.42004,	316480.27491,	316485.12978,	316489.98465,	316494.83954,	316499.69442,	316504.54932,	316509.40422,	316514.25913,	316519.11404,
316523.96896,	316528.82388,	316533.67882,	316538.53375,	316543.38870,	316548.24365,	316553.09860,	316557.95356,	316562.80853,	316567.66350,
316572.51848,	316577.37347,	316582.22846,	316587.08346,	316591.93846,	316596.79347,	316601.64849,	316606.50351,	316611.35854,	316616.21357,
316621.06861,	316625.92366,	316630.77871,	316635.63377,	316640.48884,	316645.34391,	316650.19898,	316655.05407,	316659.90916,	316664.76425,
316669.61935,	316674.47446,	316679.32957,	316684.18469,	316689.03982,	316693.89495,	316698.75009,	316703.60523,	316708.46038,	316713.31553,
316718.17070,	316723.02586,	316727.88104,	316732.73622,	316737.59140,	316742.44659,	316747.30179,	316752.15700,	316757.01221,	316761.86742,
316766.72265,	316771.57787,	316776.43311,	316781.28835,	316786.14359,	316790.99885,	316795.85411,	316800.70937,	316805.56464,	316810.41992,
316815.27520,	316820.13049,	316824.98578,	316829.84109,	316834.69639,	316839.55171,	316844.40703,	316849.26235,	316854.11768,	316858.97302,
316863.82836,	316868.68371,	316873.53907,	316878.39443,	316883.24980,	316888.10517,	316892.96055,	316897.81594,	316902.67133,	316907.52673,
316912.38213,	316917.23754,	316922.09296,	316926.94838,	316931.80381,	316936.65924,	316941.51468,	316946.37013,	316951.22558,	316956.08104,
316960.93650,	316965.79198,	316970.64745,	316975.50293,	316980.35842,	316985.21392,	316990.06942,	316994.92493,	316999.78044,	317004.63596,
317009.49148,	317014.34702,	317019.20255,	317024.05810,	317028.91365,	317033.76920,	317038.62476,	317043.48033,	317048.33590,	317053.19148,
317058.04707,	317062.90266,	317067.75826,	317072.61386,	317077.46947,	317082.32509,	317087.18071,	317092.03634,	317096.89197,	317101.74761,
317106.60326,	317111.45891,	317116.31457,	317121.17024,	317126.02591,	317130.88158,	317135.73727,	317140.59295,	317145.44865,	317150.30435,
317155.16006,	317160.01577,	317164.87149,	317169.72721,	317174.58294,	317179.43868,	317184.29443,	317189.15017,	317194.00593,	317198.86169,
317203.71746,	317208.57323,	317213.42901,	317218.28480,	317223.14059,	317227.99639,	317232.85219,	317237.70800,	317242.56382,	317247.41964,
317252.27547,	317257.13130,	317261.98714,	317266.84299,	317271.69884,	317276.55470,	317281.41056,	317286.26643,	317291.12231,	317295.97819,
317300.83408,	317305.68997,	317310.54587,	317315.40178,	317320.25769,	317325.11361,	317329.96954,	317334.82547,	317339.68140,	317344.53735,
317349.39330,	317354.24925,	317359.10521,	317363.96118,	317368.81715,	317373.67313,	317378.52912,	317383.38511,	317388.24111,	317393.09711,
317397.95312,	317402.80913,	317407.66516,	317412.52118,	317417.37722,	317422.23326,	317427.08930,	317431.94535,	317436.80141,	317441.65748,
317446.51355,	317451.36962,	317456.22570,	317461.08179,	317465.93789,	317470.79399,	317475.65009,	317480.50621,	317485.36232,	317490.21845,
317495.07458,	317499.93072,	317504.78686,	317509.64301,	317514.49916,	317519.35532,	317524.21149,	317529.06766,	317533.92384,	317538.78003,
317543.63622,	317548.49241,	317553.34862,	317558.20483,	317563.06104,	317567.91726,	317572.77349,	317577.62972,	317582.48596,	317587.34221,
317592.19846,	317597.05472,	317601.91098,	317606.76725,	317611.62353,	317616.47981,	317621.33609,	317626.19239,	317631.04869,	317635.90499,
317640.76131,	317645.61762,	317650.47395,	317655.33028,	317660.18661,	317665.04296,	317669.89930,	317674.75566,	317679.61202,	317684.46839,
317689.32476,	317694.18114,	317699.03752,	317703.89391,	317708.75031,	317713.60671,	317718.46312,	317723.31953,	317728.17595,	317733.03238,
317737.88881,	317742.74525,	317747.60170,	317752.45815,	317757.31461,	317762.17107,	317767.02754,	317771.88401,	317776.74049,	317781.59698,
317786.45347,	317791.30997,	317796.16648,	317801.02299,	317805.87951,	317810.73603,	317815.59256,	317820.44910,	317825.30564,	317830.16219,
317835.01874,	317839.87530,	317844.73186,	317849.58844,	317854.44501,	317859.30160,	317864.15819,	317869.01478,	317873.87139,	317878.72799,
317883.58461,	317888.44123,	317893.29785,	317898.15449,	317903.01113,	317907.86777,	317912.72442,	317917.58108,	317922.43774,	317927.29441,
317932.15108,	317937.00776,	317941.86445,	317946.72114,	317951.57784,	317956.43455,	317961.29126,	317966.14797,	317971.00470,	317975.86142,
317980.71816,	317985.57490,	317990.43165,	317995.28840,	318000.14516,	318005.00192,	318009.85870,	318014.71547,	318019.57226,	318024.42905,
318029.28584,	318034.14264,	318038.99945,	318043.85626,	318048.71308,	318053.56991,	318058.42674,	318063.28358,	318068.14042,	318072.99727,
318077.85413,	318082.71099,	318087.56786,	318092.42473,	318097.28161,	318102.13850,	318106.99539,	318111.85229,	318116.70919,	318121.56610,
318126.42302,	318131.27994,	318136.13687,	318140.99380,	318145.85074,	318150.70769,	318155.56464,	318160.42160,	318165.27856,	318170.13553,
318174.99251,	318179.84949,	318184.70648,	318189.56347,	318194.42047,	318199.27748,	318204.13449,	318208.99151,	318213.84854,	318218.70557,
318223.56261,	318228.41965,	318233.27670,	318238.13375,	318242.99081,	318247.84788,	318252.70495,	318257.56203,	318262.41912,	318267.27621,
318272.13331,	318276.99041,	318281.84752,	318286.70463,	318291.56175,	318296.41888,	318301.27602,	318306.13316,	318310.99030,	318315.84745,
318320.70461,	318325.56177,	318330.41894,	318335.27612,	318340.13330,	318344.99049,	318349.84768,	318354.70488,	318359.56209,	318364.41930,
318369.27652,	318374.13374,	318378.99097,	318383.84821,	318388.70545,	318393.56270,	318398.41995,	318403.27721,	318408.13448,	318412.99175,
318417.84903,	318422.70631,	318427.56360,	318432.42090,	318437.27820,	318442.13551,	318446.99282,	318451.85014,	318456.70747,	318461.56480,
318466.42214,	318471.27949,	318476.13684,	318480.99419,	318485.85156,	318490.70892,	318495.56630,	318500.42368,	318505.28107,	318510.13846,
318514.99586,	318519.85326,	318524.71067,	318529.56809,	318534.42551,	318539.28294,	318544.14038,	318548.99782,	318553.85527,	318558.71272,
318563.57018,	318568.42764,	318573.28511,	318578.14259,	318583.00008,	318587.85756,	318592.71506,	318597.57256,	318602.43007,	318607.28758,
318612.14510,	318617.00263,	318621.86016,	318626.71770,	318631.57524,	318636.43279,	318641.29034,	318646.14791,	318651.00547,	318655.86305,
318660.72063,	318665.57821,	318670.43581,	318675.29340,	318680.15101,	318685.00862,	318689.86623,	318694.72385,	318699.58148,	318704.43912,
318709.29676,	318714.15440,	318719.01205,	318723.86971,	318728.72738,	318733.58505,	318738.44272,	318743.30041,	318748.15809,	318753.01579,
318757.87349,	318762.73119,	318767.58891,	318772.44663,	318777.30435,	318782.16208,	318787.01982,	318791.87756,	318796.73531,	318801.59306,
318806.45082,	318811.30859,	318816.16636,	318821.02414,	318825.88192,	318830.73972,	318835.59751,	318840.45531,	318845.31312,	318850.17094,
318855.02876,	318859.88659,	318864.74442,	318869.60226,	318874.46010,	318879.31795,	318884.17581,	318889.03367,	318893.89154,	318898.74942,
318903.60730,	318908.46519,	318913.32308,	318918.18098,	318923.03888,	318927.89679,	318932.75471,	318937.61263,	318942.47056,	318947.32850,
318952.18644,	318957.04439,	318961.90234,	318966.76030,	318971.61827,	318976.47624,	318981.33421,	318986.19220,	318991.05019,	318995.90818,
319000.76618,	319005.62419,	319010.48221,	319015.34023,	319020.19825,	319025.05628,	319029.91432,	319034.77236,	319039.63041,	319044.48847,
319049.34653,	319054.20460,	319059.06267,	319063.92075,	319068.77884,	319073.63693,	319078.49503,	319083.35313,	319088.21124,	319093.06936,
319097.92748,	319102.78561,	319107.64374,	319112.50188,	319117.36003,	319122.21818,	319127.07634,	319131.93450,	319136.79267,	319141.65085,
319146.50903,	319151.36722,	319156.22541,	319161.08361,	319165.94182,	319170.80003,	319175.65825,	319180.51647,	319185.37470,	319190.23294,
319195.09118,	319199.94943,	319204.80769,	319209.66595,	319214.52421,	319219.38248,	319224.24076,	319229.09905,	319233.95734,	319238.81563,
319243.67394,	319248.53225,	319253.39056,	319258.24888,	319263.10721,	319267.96554,	319272.82388,	319277.68222,	319282.54057,	319287.39893,
319292.25729,	319297.11566,	319301.97404,	319306.83242,	319311.69080,	319316.54920,	319321.40760,	319326.26600,	319331.12441,	319335.98283,
319340.84125,	319345.69968,	319350.55812,	319355.41656,	319360.27500,	319365.13346,	319369.99192,	319374.85038,	319379.70885,	319384.56733,
319389.42581,	319394.28430,	319399.14280,	319404.00130,	319408.85980,	319413.71832,	319418.57684,	319423.43536,	319428.29389,	319433.15243,
319438.01097,	319442.86952,	319447.72808,	319452.58664,	319457.44521,	319462.30378,	319467.16236,	319472.02094,	319476.87954,	319481.73813,
319486.59674,	319491.45535,	319496.31396,	319501.17258,	319506.03121,	319510.88984,	319515.74848,	319520.60713,	319525.46578,	319530.32444,
319535.18310,	319540.04177,	319544.90045,	319549.75913,	319554.61781,	319559.47651,	319564.33521,	319569.19391,	319574.05263,	319578.91134,
319583.77007,	319588.62880,	319593.48753,	319598.34627,	319603.20502,	319608.06377,	319612.92253,	319617.78130,	319622.64007,	319627.49885,
319632.35763,	319637.21642,	319642.07522,	319646.93402,	319651.79283,	319656.65164,	319661.51046,	319666.36929,	319671.22812,	319676.08696,
319680.94580,	319685.80465,	319690.66351,	319695.52237,	319700.38124,	319705.24011,	319710.09899,	319714.95788,	319719.81677,	319724.67567,
319729.53457,	319734.39348,	319739.25240,	319744.11132,	319748.97025,	319753.82918,	319758.68812,	319763.54707,	319768.40602,	319773.26498,
319778.12394,	319782.98291,	319787.84189,	319792.70087,	319797.55986,	319802.41885,	319807.27785,	319812.13686,	319816.99587,	319821.85489,
319826.71391,	319831.57294,	319836.43198,	319841.29102,	319846.15007,	319851.00912,	319855.86818,	319860.72725,	319865.58632,	319870.44540,
319875.30448,	319880.16357,	319885.02267,	319889.88177,	319894.74088,	319899.60000,	319904.45912,	319909.31824,	319914.17737,	319919.03651,
319923.89566,	319928.75481,	319933.61396,	319938.47313,	319943.33229,	319948.19147,	319953.05065,	319957.90983,	319962.76903,	319967.62823,
319972.48743,	319977.34664,	319982.20586,	319987.06508,	319991.92431,	319996.78354,	320001.64278,	320006.50203,	320011.36128,	320016.22054,
320021.07980,	320025.93907,	320030.79835,	320035.65763,	320040.51692,	320045.37622,	320050.23552,	320055.09482,	320059.95414,	320064.81345,
320069.67278,	320074.53211,	320079.39145,	320084.25079,	320089.11014,	320093.96949,	320098.82885,	320103.68822,	320108.54759,	320113.40697,
320118.26635,	320123.12574,	320127.98514,	320132.84454,	320137.70395,	320142.56337,	320147.42279,	320152.28221,	320157.14165,	320162.00108,
320166.86053,	320171.71998,	320176.57944,	320181.43890,	320186.29837,	320191.15784,	320196.01732,	320200.87681,	320205.73630,	320210.59580,
320215.45530,	320220.31481,	320225.17433,	320230.03385,	320234.89338,	320239.75292,	320244.61246,	320249.47200,	320254.33156,	320259.19112,
320264.05068,	320268.91025,	320273.76983,	320278.62941,	320283.48900,	320288.34859,	320293.20819,	320298.06780,	320302.92741,	320307.78703,
320312.64666,	320317.50629,	320322.36592,	320327.22557,	320332.08521,	320336.94487,	320341.80453,	320346.66420,	320351.52387,	320356.38355,
320361.24323,	320366.10292,	320370.96262,	320375.82232,	320380.68203,	320385.54174,	320390.40146,	320395.26119,	320400.12092,	320404.98066,
320409.84041,	320414.70016,	320419.55991,	320424.41968,	320429.27945,	320434.13922,	320438.99900,	320443.85879,	320448.71858,	320453.57838,
320458.43818,	320463.29799,	320468.15781,	320473.01763,	320477.87746,	320482.73730,	320487.59714,	320492.45698,	320497.31683,	320502.17669,
320507.03656,	320511.89643,	320516.75631,	320521.61619,	320526.47608,	320531.33597,	320536.19587,	320541.05578,	320545.91569,	320550.77561,
320555.63553,	320560.49546,	320565.35540,	320570.21534,	320575.07529,	320579.93525,	320584.79521,	320589.65517,	320594.51514,	320599.37512,
320604.23511,	320609.09510,	320613.95509,	320618.81510,	320623.67511,	320628.53512,	320633.39514,	320638.25517,	320643.11520,	320647.97524,
320652.83528,	320657.69533,	320662.55539,	320667.41545,	320672.27552,	320677.13559,	320681.99567,	320686.85576,	320691.71585,	320696.57595,
320701.43606,	320706.29617,	320711.15628,	320716.01640,	320720.87653,	320725.73667,	320730.59681,	320735.45695,	320740.31711,	320745.17726,
320750.03743,	320754.89760,	320759.75777,	320764.61796,	320769.47814,	320774.33834,	320779.19854,	320784.05875,	320788.91896,	320793.77918,
320798.63940,	320803.49963,	320808.35987,	320813.22011,	320818.08036,	320822.94061,	320827.80087,	320832.66114,	320837.52141,	320842.38169,
320847.24197,	320852.10226,	320856.96256,	320861.82286,	320866.68317,	320871.54348,	320876.40380,	320881.26413,	320886.12446,	320890.98480,
320895.84514,	320900.70549,	320905.56585,	320910.42621,	320915.28658,	320920.14695,	320925.00733,	320929.86772,	320934.72811,	320939.58851,
320944.44891,	320949.30932,	320954.16974,	320959.03016,	320963.89059,	320968.75102,	320973.61146,	320978.47191,	320983.33236,	320988.19282,
320993.05328,	320997.91375,	321002.77423,	321007.63471,	321012.49519,	321017.35569,	321022.21619,	321027.07669,	321031.93721,	321036.79772,
321041.65825,	321046.51878,	321051.37931,	321056.23985,	321061.10040,	321065.96095,	321070.82151,	321075.68208,	321080.54265,	321085.40323,
321090.26381,	321095.12440,	321099.98500,	321104.84560,	321109.70621,	321114.56682,	321119.42744,	321124.28807,	321129.14870,	321134.00933,
321138.86998,	321143.73063,	321148.59128,	321153.45194,	321158.31261,	321163.17328,	321168.03396,	321172.89465,	321177.75534,	321182.61604,
321187.47674,	321192.33745,	321197.19817,	321202.05889,	321206.91961,	321211.78035,	321216.64109,	321221.50183,	321226.36258,	321231.22334,
321236.08410,	321240.94487,	321245.80565,	321250.66643,	321255.52721,	321260.38801,	321265.24881,	321270.10961,	321274.97042,	321279.83124,
321284.69206,	321289.55289,	321294.41373,	321299.27457,	321304.13541,	321308.99627,	321313.85713,	321318.71799,	321323.57886,	321328.43974,
321333.30062,	321338.16151,	321343.02240,	321347.88331,	321352.74421,	321357.60512,	321362.46604,	321367.32697,	321372.18790,	321377.04884,
321381.90978,	321386.77073,	321391.63168,	321396.49264,	321401.35361,	321406.21458,	321411.07556,	321415.93654,	321420.79753,	321425.65853,
321430.51953,	321435.38054,	321440.24156,	321445.10258,	321449.96360,	321454.82463,	321459.68567,	321464.54672,	321469.40777,	321474.26882,
321479.12989,	321483.99095,	321488.85203,	321493.71311,	321498.57419,	321503.43529,	321508.29639,	321513.15749,	321518.01860,	321522.87972,
321527.74084,	321532.60197,	321537.46310,	321542.32424,	321547.18539,	321552.04654,	321556.90769,	321561.76886,	321566.63003,	321571.49120,
321576.35239,	321581.21357,	321586.07477,	321590.93597,	321595.79717,	321600.65839,	321605.51960,	321610.38083,	321615.24206,	321620.10329,
321624.96453,	321629.82578,	321634.68703,	321639.54829,	321644.40956,	321649.27083,	321654.13211,	321658.99339,	321663.85468,	321668.71598,
321673.57728,	321678.43859,	321683.29990,	321688.16122,	321693.02254,	321697.88387,	321702.74521,	321707.60656,	321712.46790,	321717.32926,
321722.19062,	321727.05199,	321731.91336,	321736.77474,	321741.63612,	321746.49752,	321751.35891,	321756.22032,	321761.08172,	321765.94314,
321770.80456,	321775.66599,	321780.52742,	321785.38886,	321790.25030,	321795.11175,	321799.97321,	321804.83467,	321809.69614,	321814.55762,
321819.41910,	321824.28058,	321829.14208,	321834.00358,	321838.86508,	321843.72659,	321848.58811,	321853.44963,	321858.31116,	321863.17269,
321868.03423,	321872.89578,	321877.75733,	321882.61889,	321887.48045,	321892.34202,	321897.20360,	321902.06518,	321906.92677,	321911.78837,
321916.64997,	321921.51157,	321926.37318,	321931.23480,	321936.09643,	321940.95806,	321945.81969,	321950.68133,	321955.54298,	321960.40464,
321965.26630,	321970.12796,	321974.98963,	321979.85131,	321984.71299,	321989.57468,	321994.43638,	321999.29808,	322004.15979,	322009.02150,
322013.88322,	322018.74495,	322023.60668,	322028.46842,	322033.33016,	322038.19191,	322043.05366,	322047.91543,	322052.77719,	322057.63897,
322062.50075,	322067.36253,	322072.22432,	322077.08612,	322081.94792,	322086.80973,	322091.67155,	322096.53337,	322101.39520,	322106.25703,
322111.11887,	322115.98071,	322120.84256,	322125.70442,	322130.56628,	322135.42815,	322140.29003,	322145.15191,	322150.01379,	322154.87569,
322159.73759,	322164.59949,	322169.46140,	322174.32332,	322179.18524,	322184.04717,	322188.90910,	322193.77104,	322198.63299,	322203.49494,
322208.35690,	322213.21886,	322218.08083,	322222.94281,	322227.80479,	322232.66678,	322237.52878,	322242.39078,	322247.25278,	322252.11479,
322256.97681,	322261.83884,	322266.70087,	322271.56290,	322276.42494,	322281.28699,	322286.14904,	322291.01110,	322295.87317,	322300.73524,
322305.59732,	322310.45940,	322315.32149,	322320.18359,	322325.04569,	322329.90780,	322334.76991,	322339.63203,	322344.49416,	322349.35629,
322354.21842,	322359.08057,	322363.94272,	322368.80487,	322373.66703,	322378.52920,	322383.39137,	322388.25355,	322393.11574,	322397.97793,
322402.84013,	322407.70233,	322412.56454,	322417.42675,	322422.28897,	322427.15120,	322432.01343,	322436.87567,	322441.73792,	322446.60017,
322451.46242,	322456.32469,	322461.18696,	322466.04923,	322470.91151,	322475.77380,	322480.63609,	322485.49839,	322490.36069,	322495.22300,
322500.08532,	322504.94764,	322509.80997,	322514.67230,	322519.53464,	322524.39699,	322529.25934,	322534.12170,	322538.98406,	322543.84643,
322548.70881,	322553.57119,	322558.43358,	322563.29597,	322568.15837,	322573.02078,	322577.88319,	322582.74561,	322587.60803,	322592.47046,
322597.33290,	322602.19534,	322607.05779,	322611.92024,	322616.78270,	322621.64516,	322626.50763,	322631.37011,	322636.23260,	322641.09508,
322645.95758,	322650.82008,	322655.68259,	322660.54510,	322665.40762,	322670.27014,	322675.13268,	322679.99521,	322684.85776,	322689.72030,
322694.58286,	322699.44542,	322704.30799,	322709.17056,	322714.03314,	322718.89572,	322723.75831,	322728.62091,	322733.48351,	322738.34612,
322743.20873,	322748.07135,	322752.93398,	322757.79661,	322762.65925,	322767.52189,	322772.38454,	322777.24720,	322782.10986,	322786.97253,
322791.83520,	322796.69788,	322801.56057,	322806.42326,	322811.28596,	322816.14866,	322821.01137,	322825.87409,	322830.73681,	322835.59954,
322840.46227,	322845.32501,	322850.18776,	322855.05051,	322859.91326,	322864.77603,	322869.63880,	322874.50157,	322879.36435,	322884.22714,
322889.08993,	322893.95273,	322898.81554,	322903.67835,	322908.54117,	322913.40399,	322918.26682,	322923.12965,	322927.99249,	322932.85534,
322937.71819,	322942.58105,	322947.44392,	322952.30679,	322957.16966,	322962.03254,	322966.89543,	322971.75833,	322976.62123,	322981.48413,
322986.34705,	322991.20996,	322996.07289,	323000.93582,	323005.79875,	323010.66170,	323015.52464,	323020.38760,	323025.25056,	323030.11352,
323034.97649,	323039.83947,	323044.70246,	323049.56545,	323054.42844,	323059.29144,	323064.15445,	323069.01746,	323073.88048,	323078.74351,
323083.60654,	323088.46958,	323093.33262,	323098.19567,	323103.05872,	323107.92178,	323112.78485,	323117.64792,	323122.51100,	323127.37409,
323132.23718,	323137.10028,	323141.96338,	323146.82649,	323151.68960,	323156.55272,	323161.41585,	323166.27898,	323171.14212,	323176.00526,
323180.86841,	323185.73157,	323190.59473,	323195.45790,	323200.32108,	323205.18426,	323210.04744,	323214.91063,	323219.77383,	323224.63703,
323229.50024,	323234.36346,	323239.22668,	323244.08991,	323248.95314,	323253.81638,	323258.67963,	323263.54288,	323268.40614,	323273.26940,
323278.13267,	323282.99595,	323287.85923,	323292.72251,	323297.58581,	323302.44911,	323307.31241,	323312.17572,	323317.03904,	323321.90236,
323326.76569,	323331.62903,	323336.49237,	323341.35571,	323346.21907,	323351.08242,	323355.94579,	323360.80916,	323365.67254,	323370.53592,
323375.39931,	323380.26270,	323385.12610,	323389.98951,	323394.85292,	323399.71634,	323404.57976,	323409.44319,	323414.30663,	323419.17007,
323424.03352,	323428.89697,	323433.76043,	323438.62389,	323443.48737,	323448.35084,	323453.21433,	323458.07782,	323462.94131,	323467.80481,
323472.66832,	323477.53183,	323482.39535,	323487.25888,	323492.12241,	323496.98595,	323501.84949,	323506.71304,	323511.57659,	323516.44015,
323521.30372,	323526.16729,	323531.03087,	323535.89446,	323540.75805,	323545.62164,	323550.48525,	323555.34885,	323560.21247,	323565.07609,
323569.93971,	323574.80335,	323579.66698,	323584.53063,	323589.39428,	323594.25793,	323599.12160,	323603.98526,	323608.84894,	323613.71262,
323618.57630,	323623.43999,	323628.30369,	323633.16740,	323638.03110,	323642.89482,	323647.75854,	323652.62227,	323657.48600,	323662.34974,
323667.21349,	323672.07724,	323676.94099,	323681.80476,	323686.66853,	323691.53230,	323696.39608,	323701.25987,	323706.12366,	323710.98746,
323715.85126,	323720.71507,	323725.57889,	323730.44271,	323735.30654,	323740.17038,	323745.03422,	323749.89806,	323754.76191,	323759.62577,
323764.48964,	323769.35350,	323774.21738,	323779.08126,	323783.94515,	323788.80904,	323793.67294,	323798.53685,	323803.40076,	323808.26468,
323813.12860,	323817.99253,	323822.85647,	323827.72041,	323832.58435,	323837.44831,	323842.31227,	323847.17623,	323852.04020,	323856.90418,
323861.76816,	323866.63215,	323871.49614,	323876.36014,	323881.22415,	323886.08816,	323890.95218,	323895.81621,	323900.68024,	323905.54427,
323910.40831,	323915.27236,	323920.13642,	323925.00048,	323929.86454,	323934.72861,	323939.59269,	323944.45678,	323949.32087,	323954.18496,
323959.04906,	323963.91317,	323968.77728,	323973.64140,	323978.50553,	323983.36966,	323988.23380,	323993.09794,	323997.96209,	324002.82624,
324007.69040,	324012.55457,	324017.41874,	324022.28292,	324027.14711,	324032.01130,	324036.87549,	324041.73970,	324046.60391,	324051.46812,
324056.33234,	324061.19657,	324066.06080,	324070.92504,	324075.78928,	324080.65353,	324085.51779,	324090.38205,	324095.24632,	324100.11059,
324104.97487,	324109.83915,	324114.70345,	324119.56774,	324124.43205,	324129.29636,	324134.16067,	324139.02499,	324143.88932,	324148.75365,
324153.61799,	324158.48234,	324163.34669,	324168.21104,	324173.07541,	324177.93978,	324182.80415,	324187.66853,	324192.53292,	324197.39731,
324202.26171,	324207.12611,	324211.99052,	324216.85494,	324221.71936,	324226.58379,	324231.44822,	324236.31266,	324241.17711,	324246.04156,
324250.90602,	324255.77048,	324260.63495,	324265.49943,	324270.36391,	324275.22840,	324280.09289,	324284.95739,	324289.82189,	324294.68640,
324299.55092,	324304.41544,	324309.27997,	324314.14451,	324319.00905,	324323.87360,	324328.73815,	324333.60271,	324338.46727,	324343.33184,
324348.19642,	324353.06100,	324357.92559,	324362.79018,	324367.65478,	324372.51939,	324377.38400,	324382.24862,	324387.11324,	324391.97787,
324396.84251,	324401.70715,	324406.57180,	324411.43645,	324416.30111,	324421.16577,	324426.03045,	324430.89512,	324435.75981,	324440.62450,
324445.48919,	324450.35389,	324455.21860,	324460.08331,	324464.94803,	324469.81275,	324474.67748,	324479.54222,	324484.40696,	324489.27171,
324494.13647,	324499.00123,	324503.86599,	324508.73076,	324513.59554,	324518.46033,	324523.32512,	324528.18991,	324533.05471,	324537.91952,
324542.78433,	324547.64915,	324552.51398,	324557.37881,	324562.24365,	324567.10849,	324571.97334,	324576.83820,	324581.70306,	324586.56792,
324591.43280,	324596.29767,	324601.16256,	324606.02745,	324610.89235,	324615.75725,	324620.62216,	324625.48707,	324630.35199,	324635.21692,
324640.08185,	324644.94679,	324649.81173,	324654.67668,	324659.54164,	324664.40660,	324669.27157,	324674.13654,	324679.00152,	324683.86651,
324688.73150,	324693.59650,	324698.46150,	324703.32651,	324708.19152,	324713.05654,	324717.92157,	324722.78660,	324727.65164,	324732.51669,
324737.38174,	324742.24679,	324747.11186,	324751.97693,	324756.84200,	324761.70708,	324766.57217,	324771.43726,	324776.30236,	324781.16746,
324786.03257,	324790.89769,	324795.76281,	324800.62794,	324805.49307,	324810.35821,	324815.22335,	324820.08851,	324824.95366,	324829.81883,
324834.68399,	324839.54917,	324844.41435,	324849.27954,	324854.14473,	324859.00993,	324863.87513,	324868.74034,	324873.60556,	324878.47078,
324883.33601,	324888.20125,	324893.06649,	324897.93173,	324902.79698,	324907.66224,	324912.52751,	324917.39278,	324922.25805,	324927.12333,
324931.98862,	324936.85392,	324941.71921,	324946.58452,	324951.44983,	324956.31515,	324961.18047,	324966.04580,	324970.91114,	324975.77648,
324980.64182,	324985.50718,	324990.37253,	324995.23790,	325000.10327,	325004.96865,	325009.83403,	325014.69942,	325019.56481,	325024.43021,
325029.29562,	325034.16103,	325039.02645,	325043.89187,	325048.75730,	325053.62274,	325058.48818,	325063.35363,	325068.21908,	325073.08454,
325077.95000,	325082.81547,	325087.68095,	325092.54643,	325097.41192,	325102.27742,	325107.14292,	325112.00843,	325116.87394,	325121.73946,
325126.60498,	325131.47051,	325136.33605,	325141.20159,	325146.06714,	325150.93269,	325155.79825,	325160.66382,	325165.52939,	325170.39497,
325175.26055,	325180.12614,	325184.99174,	325189.85734,	325194.72295,	325199.58856,	325204.45418,	325209.31980,	325214.18543,	325219.05107,
325223.91671,	325228.78236,	325233.64802,	325238.51368,	325243.37934,	325248.24502,	325253.11069,	325257.97638,	325262.84207,	325267.70776,
325272.57347,	325277.43917,	325282.30489,	325287.17061,	325292.03633,	325296.90207,	325301.76780,	325306.63355,	325311.49930,	325316.36505,
325321.23081,	325326.09658,	325330.96235,	325335.82813,	325340.69392,	325345.55971,	325350.42550,	325355.29131,	325360.15711,	325365.02293,
325369.88875,	325374.75457,	325379.6