(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16417,        473]
NotebookOptionsPosition[     14794,        432]
NotebookOutlinePosition[     15395,        454]
CellTagsIndexPosition[     15352,        451]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Structure of SO(3) hypothesis mixing matrix", "Subsection",
 CellChangeTimes->{{3.967524018359811*^9, 3.967524068906576*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"103c0d57-5c3e-46f5-bfcf-91c10c8b850d"],

Cell["\<\
CP-conserving SO(3) parameterization of the neutrino mixing matrix\
\[LineSeparator]Jaros\[LSlash]aw Duda(Jagiellonian U. (main)), Janusz \
Gluza(Silesia U.), Biswajit Karmakar(Silesia U.)\[LineSeparator]Supporting \
Mathematica file for : https://arxiv.org/abs/2509.25328 \[LineSeparator]\
\>", "Text",
 CellChangeTimes->{{3.969008095278294*^9, 3.969008157019238*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"60c1ef1e-6ff2-437f-9ac2-64dd278b5ca2"],

Cell[CellGroupData[{

Cell["SO3 Generators", "Subsubsection",
 CellChangeTimes->{{3.9675239902413673`*^9, 3.9675239960217266`*^9}},
 Background->RGBColor[
  0.9, 1, 1],ExpressionUUID->"94dd8331-9e89-49a0-ac12-57cd223888aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gx", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0", "0"},
      {"0", "0", 
       RowBox[{"-", "1"}]},
      {"0", "1", "0"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"Gy", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0", "1"},
      {"0", "0", "0"},
      {
       RowBox[{"-", "1"}], "0", "0"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"Gz", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "1"}], "0"},
      {"1", "0", "0"},
      {"0", "0", "0"}
     }], "\[NoBreak]", ")"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"274e077c-0ee2-4e8e-ba2f-84852aee4b03"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotation vector and matrix exponent", "Subsubsection",
 CellChangeTimes->{{3.9675239902413673`*^9, 3.9675239960217266`*^9}, {
  3.967524130290739*^9, 3.9675241554505234`*^9}},
 Background->RGBColor[
  0.9, 1, 1],ExpressionUUID->"49748819-12e2-481f-aaf2-c100dd15fb55"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Theta]", "x"]}], "*", "Gx"}], "-", 
    RowBox[{
     SubscriptBox["\[Theta]", "y"], "*", "Gy"}], "-", 
    RowBox[{
     SubscriptBox["\[Theta]", "z"], "*", "Gz"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"A", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UExpA", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MatrixExp", "[", "A", "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
          SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
          SubsuperscriptBox["\[Theta]", "z", "2"]}], ")"}], "->", 
        SuperscriptBox["\[Theta]", "2"]}], "}"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SubscriptBox["\[Theta]", "x"], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         SubscriptBox["\[Theta]", "y"], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         SubscriptBox["\[Theta]", "z"], ")"}], "2"]}], ">", "1"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.962779550518211*^9, 3.96277960386268*^9}, {
  3.9675187001586485`*^9, 3.9675187318180957`*^9}, {3.9675241128048487`*^9, 
  3.967524113722704*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"3a2e116c-7bb0-4623-8d58-fcced4c75503"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      SubscriptBox["\[Theta]", "z"], 
      RowBox[{"-", 
       SubscriptBox["\[Theta]", "y"]}]},
     {
      RowBox[{"-", 
       SubscriptBox["\[Theta]", "z"]}], "0", 
      SubscriptBox["\[Theta]", "x"]},
     {
      SubscriptBox["\[Theta]", "y"], 
      RowBox[{"-", 
       SubscriptBox["\[Theta]", "x"]}], "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9627796048990107`*^9, 3.962781399272275*^9, 
  3.96278146522173*^9, 3.9675187375687647`*^9, 3.967522741493126*^9, 
  3.9675227746539693`*^9, 3.9675238552076406`*^9, 3.967524160319933*^9},
 CellLabel->
  "Out[8]//MatrixForm=",ExpressionUUID->"5a816187-77e7-42c5-ad89-\
04812805f23c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SO(3) mixing matrix", "Subsubsection",
 CellChangeTimes->{{3.9675239902413673`*^9, 3.9675239960217266`*^9}, {
  3.967524130290739*^9, 3.967524192089861*^9}},
 Background->RGBColor[
  0.9, 1, 1],ExpressionUUID->"55133253-85b4-44db-9430-d6d136e26e7e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"USO3", "=", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", "\[Theta]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", "\[Theta]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "3"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", 
          "\[Theta]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", "\[Theta]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", "\[Theta]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", 
          "\[Theta]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "1"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", "\[Theta]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "2"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", "\[Theta]"}]}], 
        ",", 
        RowBox[{
         RowBox[{"UExpA", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "3"}], "]"}], "]"}], "/.", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}]], "->", 
          "\[Theta]"}]}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"USO3", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.9675228553375664`*^9, 3.9675228837671337`*^9}, {
  3.9675235021105843`*^9, 3.9675235047733297`*^9}, {3.967523540178934*^9, 
  3.9675235737577972`*^9}, {3.967523610317406*^9, 3.9675237066764975`*^9}, {
  3.967523804358536*^9, 3.9675238381151123`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"17d91794-60f3-49fa-a3dc-a3c10438acfc"],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox[
        RowBox[{
         SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}], ")"}]}]}], 
        SuperscriptBox["\[Theta]", "2"]], 
       FractionBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], " ", 
            SubscriptBox["\[Theta]", "x"], " ", 
            SubscriptBox["\[Theta]", "y"]}], ")"}]}], "+", 
         RowBox[{"\[Theta]", " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
          SubscriptBox["\[Theta]", "z"]}]}], 
        SuperscriptBox["\[Theta]", "2"]], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"\[Theta]", " ", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
           SubscriptBox["\[Theta]", "y"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], " ", 
           SubscriptBox["\[Theta]", "x"], " ", 
           SubscriptBox["\[Theta]", "z"]}]}], 
         SuperscriptBox["\[Theta]", "2"]]}]},
      {
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], " ", 
           SubscriptBox["\[Theta]", "x"], " ", 
           SubscriptBox["\[Theta]", "y"]}], "+", 
          RowBox[{"\[Theta]", " ", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
           SubscriptBox["\[Theta]", "z"]}]}], 
         SuperscriptBox["\[Theta]", "2"]]}], 
       FractionBox[
        RowBox[{
         SubsuperscriptBox["\[Theta]", "y", "2"], "+", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "z", "2"]}], ")"}]}]}], 
        SuperscriptBox["\[Theta]", "2"]], 
       FractionBox[
        RowBox[{
         RowBox[{"\[Theta]", " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
          SubscriptBox["\[Theta]", "x"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], " ", 
          SubscriptBox["\[Theta]", "y"], " ", 
          SubscriptBox["\[Theta]", "z"]}]}], 
        SuperscriptBox["\[Theta]", "2"]]},
      {
       FractionBox[
        RowBox[{
         RowBox[{"\[Theta]", " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
          SubscriptBox["\[Theta]", "y"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], " ", 
          SubscriptBox["\[Theta]", "x"], " ", 
          SubscriptBox["\[Theta]", "z"]}]}], 
        SuperscriptBox["\[Theta]", "2"]], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"\[Theta]", " ", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
           SubscriptBox["\[Theta]", "x"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], " ", 
           SubscriptBox["\[Theta]", "y"], " ", 
           SubscriptBox["\[Theta]", "z"]}]}], 
         SuperscriptBox["\[Theta]", "2"]]}], 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Theta]", "x", "2"], "+", 
            SubsuperscriptBox["\[Theta]", "y", "2"]}], ")"}]}], "+", 
         SubsuperscriptBox["\[Theta]", "z", "2"]}], 
        SuperscriptBox["\[Theta]", "2"]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9675228846742554`*^9, 3.9675234376948743`*^9, {3.9675235056548696`*^9, 
   3.96752354260402*^9}, 3.9675235747564497`*^9, {3.9675237075295916`*^9, 
   3.967523743823395*^9}, {3.9675238238784494`*^9, 3.967523860377657*^9}},
 CellLabel->
  "Out[6]//MatrixForm=",ExpressionUUID->"bd23c542-a2a9-4847-85a6-\
e63996f6b45f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 472},
WindowMargins->{{54, Automatic}, {Automatic, 64}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{Automatic, Automatic},
"PostScriptOutputFile"->"/home/biswate/Dropbox/US_Projects/SO3/submit/SO3/SO3.\
pdf"},
Magnification:>0.75 Inherited,
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 219, 3, 54, "Subsection",ExpressionUUID->"103c0d57-5c3e-46f5-bfcf-91c10c8b850d"],
Cell[802, 27, 467, 8, 98, "Text",ExpressionUUID->"60c1ef1e-6ff2-437f-9ac2-64dd278b5ca2"],
Cell[CellGroupData[{
Cell[1294, 39, 201, 3, 48, "Subsubsection",ExpressionUUID->"94dd8331-9e89-49a0-ac12-57cd223888aa"],
Cell[1498, 44, 685, 23, 50, "Input",ExpressionUUID->"274e077c-0ee2-4e8e-ba2f-84852aee4b03"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2220, 72, 273, 4, 48, "Subsubsection",ExpressionUUID->"49748819-12e2-481f-aaf2-c100dd15fb55"],
Cell[CellGroupData[{
Cell[2518, 80, 1464, 42, 64, "Input",ExpressionUUID->"3a2e116c-7bb0-4623-8d58-fcced4c75503"],
Cell[3985, 124, 1085, 31, 73, "Output",ExpressionUUID->"5a816187-77e7-42c5-ad89-04812805f23c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5119, 161, 255, 4, 48, "Subsubsection",ExpressionUUID->"55133253-85b4-44db-9430-d6d136e26e7e"],
Cell[CellGroupData[{
Cell[5399, 169, 4281, 117, 108, "Input",ExpressionUUID->"17d91794-60f3-49fa-a3dc-a3c10438acfc"],
Cell[9683, 288, 5071, 139, 117, "Output",ExpressionUUID->"bd23c542-a2a9-4847-85a6-e63996f6b45f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

