# Contributing to the Health-RI metadata schema
Thanks for taking the time to contribute! ❤️ All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details on how the issues are handled. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. We look forward to your contributions. 🎉
Please note: this GitHub page is about the Health-RI metadata model. If you have a question or an issue with the implementation of FAIR Data Points, please contact servicedesk@health-ri.nl. 
## Table of Contents
- [I want to add feedback for Draft version 2](#i-want-to-add-feedback-for-draft-version-2)
- [I have a question](#i-have-a-question)
- [I want to report a bug](#i-want-to-report-a-bug)
- [I want to suggest enhancements](#i-want-to-suggest-enhancements)
- [I want to join the modeling team](#i-want-to-join-the-modeling-team)

## I want to add feedback for Draft version 2
If you would like to submit feedback for the Draft version 2 of the core metadata schema, please follow the issue template [Issue: Draft version 2 feedback](https://github.com/Health-RI/health-ri-metadata/issues/new?assignees=&labels=draft-v2-feedback&projects=&template=feedback_template.yml&title=feedback%3A+).
## I Have a Question
If you want to ask a general question, we assume that you have read the available [Documentation](https://github.com/Health-RI/health-ri-metadata/blob/master/README.md).
If you then still feel the need to ask a question or need clarification, please direct your question to servicedesk@health-ri.nl. This will create a ticket in Topdesk and we will then take care of it as soon as possible.
## I want to report a bug
#### Before Submitting a Bug Report
A good bug report shouldn't leave others needing to chase you up for more information. Therefore, we ask you to investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.
- Make sure that you are using the [latest version](https://github.com/Health-RI/health-ri-metadata/releases).
- Determine if your bug is really a bug and not an error on your side e.g. using incompatible environment
  components/versions (Make sure that you have read  the [documentation](https://github.com/Health-RI/health-ri-metadata/blob/master/README.md)). If you are looking for support, you might want to check [this section](#i-have-a-question).
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there is not already a bug report existing for your bug or error in the [bug tracker](https://github.com/Health-RI/health-ri-metadata/issues).
- Collect information about the bug:
  - Stack trace (Traceback)
  - OS, Platform and Version
  - Version of the interpreter, compiler, SDK, runtime environment, package manager, depending on what seems relevant
  - Possibly your input and the output
  - Can you reliably reproduce the issue? And can you also reproduce it with older versions?
#### How Do I Submit a Good Bug Report?
You must never report security related issues, vulnerabilities or bugs including sensitive information to the issue tracker, or elsewhere in public. Instead sensitive bugs must be sent by email to servicedesk@health-ri.nl.
We use GitHub issues to track bugs and errors. If you run into an issue with the model:
- Open an [Issue](https://github.com/Health-RI/health-ri-metadata/issues/new/). Since we can't be sure at this point whether it is a bug or not, we ask you not to talk about a bug yet and not to label the issue.
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe why you believe there is a bug in the model.
- Provide the information you collected in the previous section.
Once it's filed:
- The project team will label the issue accordingly.

## I want to suggest enhancements
This section guides you through submitting an enhancement suggestion or new feature request for the Health-RI metadata model, **including completely new features and minor improvements to existing functionality**. Following these guidelines will help maintainers and the community to understand your suggestion and find related suggestions.
#### Before Submitting an Enhancement
- Make sure that you are using the latest version.
- Read the [documentation](https://github.com/Health-RI/health-ri-metadata/blob/master/README.md) carefully and find out if the functionality is already covered, maybe by an individual configuration.
- Perform a [search](https://github.com/Health-RI/health-ri-metadata/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to
  convince the metadata modeling group of the merits of this feature. Keep in mind that we want features that will be
  useful to the majority of our users and not just a small subset. 
#### How Do I Submit a Good Enhancement Suggestion?
Enhancement suggestions are tracked as [GitHub issues](https://github.com/Health-RI/health-ri-metadata/issues).
- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- **Explain why this enhancement would be useful** to catalogue users. You may also want to point out the other projects that solved it better and which could serve as inspiration.
Once it's filed:
- The project team will label the issue accordingly,
- The request is added to our metadata requirements document,
- The request is discussed within the metadata modeling group,
- This group decides what to do, when and if it is a model enhancement or new feature request,
- The Github issue is labeled with ‘modeling’ or ‘enhancement’ or ‘wontfix’,
- The decision is communicated with the person in question via Github issues.
## I want to join the modeling team
If you would like to be a part of the HRI core modeling group, please contact servicedesk@health-ri.nl. Please provide information on who you are, which node you are from and what experience you have with modeling and we will get back to you with more information.

## Attribution
This guide is based on [GDI user portal contributing page](https://github.com/GenomicDataInfrastructure/gdi-userportal-frontend/blob/9c2b4f50bb2d5c2c48ec0dcd9017bf8bc6e6df8b/CONTRIBUTING.md).
