(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    147419,       3265]
NotebookOptionsPosition[    144214,       3161]
NotebookOutlinePosition[    144644,       3178]
CellTagsIndexPosition[    144601,       3175]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Algorithm", "Section",
 CellChangeTimes->{{3.8291847708012285`*^9, 3.829184772301219*^9}, {
  3.829184844993986*^9, 
  3.829184863738164*^9}},ExpressionUUID->"6956064d-7071-4331-a9de-\
1bc33cc9e3ac"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ps", "[", 
    RowBox[{"T1_", ",", "T2_", ",", "T_", ",", "mn_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "T1"}], " ", "T", " ", "mn"}], "]"}], "-", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "T2"}], " ", "T", " ", "mn"}], "]"}], "+", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "mn"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"T1", " ", "T"}], "+", 
        RowBox[{"T2", " ", "T"}], "-", 
        RowBox[{"T1", " ", "T2", " ", 
         SuperscriptBox["T", "2"]}]}], ")"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pe", "[", 
   RowBox[{"T1_", ",", "T2_", ",", "T_", ",", "mn_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "T1"}], " ", "T", " ", "mn"}], "]"}], "-", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "-", "T1"}], ")"}]}], " ", "T", " ", "mn"}], "]"}], "+", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "T"}], " ", "mn"}], "]"}], "+", "1", "-", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "T2"}], " ", "T", " ", "mn"}], "]"}], "-", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "-", "T2"}], ")"}]}], " ", "T", " ", "mn"}], "]"}], "+", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "T"}], " ", "mn"}], "]"}]}], ")"}], "/", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"getPe", "[", 
   RowBox[{"T1_", ",", "T2_", ",", "T_", ",", "qs_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "step", ",", "mn"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"i", "=", "0"}], ";", 
     RowBox[{"mn", "=", 
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]]}], ";", 
     RowBox[{"step", "=", "0.4"}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "<", "50"}], "&&", 
        RowBox[{"step", ">", "0.000001"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ps", "[", 
               RowBox[{"T1", ",", "T2", ",", "T", ",", "mn"}], "]"}], "-", 
              "qs"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ps", "[", 
               RowBox[{"T1", ",", "T2", ",", "T", ",", 
                RowBox[{"mn", "+", "step"}]}], "]"}], "-", "qs"}], ")"}]}], 
           "<", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"step", "/=", "3"}], ",", "\[IndentingNewLine]", 
          RowBox[{"mn", "+=", "step"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"i", "++"}], ";"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"mn", "+=", 
      RowBox[{"3", 
       RowBox[{"step", "/", "2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pe", "[", 
      RowBox[{"T1", ",", "T2", ",", "T", ",", "mn"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.829184057824643*^9, 3.829184081777382*^9}, {
   3.8291841299250603`*^9, 3.8291841341605883`*^9}, {3.829184177336093*^9, 
   3.8291842362243814`*^9}, {3.829184301458042*^9, 3.82918438082157*^9}, {
   3.8291845715060215`*^9, 3.829184715552763*^9}, {3.829184754968009*^9, 
   3.829184759776782*^9}, {3.829184816735138*^9, 3.829184826731708*^9}, {
   3.8305108186689816`*^9, 3.830510880610998*^9}, {3.8305109709736605`*^9, 
   3.8305110215253325`*^9}, {3.830511281674576*^9, 3.830511281983837*^9}, {
   3.846007200635158*^9, 3.8460072659833527`*^9}, {3.8460073357091346`*^9, 
   3.8460074034756126`*^9}, 3.8460525972921114`*^9},
 ExpressionUUID -> "53e3cc44-f4f3-498d-83f1-0038f6d94174"],

Cell[CellGroupData[{

Cell["See Fig. 1 in paper Quantum non-Gaussian coincidences", "Item",
 CellChangeTimes->{{3.82918523594725*^9, 3.8291852799796553`*^9}, {
  3.8291853885702977`*^9, 
  3.829185406773877*^9}},ExpressionUUID->"d2f77127-da9e-4bb7-9edf-\
014c1f4c659e"],

Cell["\<\
T1, T2 are transmission in the mode 1 and mode 2 respectively\
\>", "Item",
 CellChangeTimes->{{3.8291849902920885`*^9, 3.8291850055887494`*^9}, {
  3.8291850889620185`*^9, 
  3.8291851311292953`*^9}},ExpressionUUID->"0ec8cd29-40e3-4230-ad9f-\
fdac97b0dd48"],

Cell[BoxData[
 RowBox[{"T1", "=", 
  RowBox[{
   SubscriptBox["R", 
    RowBox[{"a", ",", "1"}]], "/", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["R", 
      RowBox[{"a", ",", "1"}]], "+", 
     SubscriptBox["R", 
      RowBox[{"b", ",", "1"}]]}], ")"}]}]}]], "Item",
 CellChangeTimes->{{3.829185140488172*^9, 
  3.829185211501289*^9}},ExpressionUUID->"16672cae-48aa-412f-bc4a-\
f770967e4c31"],

Cell[BoxData[
 RowBox[{"T2", "=", 
  RowBox[{
   SubscriptBox["R", 
    RowBox[{"a", ",", "2"}]], "/", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["R", 
      RowBox[{"a", ",", "2"}]], "+", 
     SubscriptBox["R", 
      RowBox[{"b", ",", "2"}]]}], ")"}]}]}]], "Item",
 CellChangeTimes->{
  3.8291852204289217`*^9},ExpressionUUID->"d0d392fc-4157-4bf3-a18c-\
2bc8de20eea7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["R", 
    RowBox[{"a", ",", "1"}]], " ", "denotes", " ", "click", " ", 
   "probability", " ", "of", " ", 
   SubscriptBox["SPAD", 
    RowBox[{"a", ",", "1"}]]}], ",", " ", 
  RowBox[{
   SubscriptBox["R", 
    RowBox[{"b", ",", "1"}]], " ", "denotes", " ", "click", " ", 
   "probability", " ", "of", " ", 
   SubscriptBox["SPAD", 
    RowBox[{"b", ",", "1"}]], " ", 
   RowBox[{"etc", "."}]}]}]], "Item",
 CellChangeTimes->{{3.829185294316625*^9, 3.8291853616637726`*^9}, {
  3.8305113560203543`*^9, 
  3.8305113560283604`*^9}},ExpressionUUID->"a2ef1265-666f-4584-add9-\
3233b05831d6"],

Cell["\<\
T denotes transmission of the light before it reaches the detection part of \
the experiment, i. e. 1-T stands for the losses\
\>", "Item",
 CellChangeTimes->{{3.829185294316625*^9, 3.8291853616637726`*^9}, {
  3.8305113560203543`*^9, 3.8305114019834757`*^9}, {3.8305114470318136`*^9, 
  3.830511459136139*^9}, {3.830511511432361*^9, 3.830511546567534*^9}, {
  3.8460586574883337`*^9, 
  3.8460586574923334`*^9}},ExpressionUUID->"db96adc6-64fb-4ccc-9e05-\
6e0607b6a4b4"],

Cell["Rs corresponds to success probability", "Item",
 CellChangeTimes->{{3.829185294316625*^9, 3.8291853616637726`*^9}, {
  3.8305113560203543`*^9, 3.8305114019834757`*^9}, {3.8305114470318136`*^9, 
  3.830511459136139*^9}, {3.830511511432361*^9, 3.830511546567534*^9}, {
  3.846058659567478*^9, 
  3.8460586755316467`*^9}},ExpressionUUID->"483b9844-e9ba-4aa5-9061-\
2dd986c20e23"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"T1", "=", "0.5"}], ";", 
  RowBox[{"T2", "=", "0.5"}], ";", 
  RowBox[{"T", "=", "1"}], ";", 
  RowBox[{"Rs", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"getPe", "[", 
  RowBox[{"T1", ",", "T2", ",", "T", ",", "Rs"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "T1", "]"}], ";", 
  RowBox[{"Clear", "[", "T2", "]"}], ";", 
  RowBox[{"Clear", "[", "T", "]"}], ";", 
  RowBox[{"Clear", "[", "Ts", "]"}], ";", 
  RowBox[{"Clear", "[", "Rs", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.830511255655175*^9, 3.830511295099326*^9}, 
   3.8305113258695364`*^9, {3.8305115567112455`*^9, 3.8305115946427917`*^9}, {
   3.8305116704214907`*^9, 3.830511690042183*^9}, {3.846058268767697*^9, 
   3.84605828203852*^9}, {3.846058350207817*^9, 3.846058377999962*^9}, {
   3.846058447326123*^9, 3.846058457054192*^9}, 3.864972067400807*^9, 
   3.864972139114244*^9, {3.886665792279783*^9, 3.8866658500646915`*^9}, {
   3.8866660104102626`*^9, 3.8866660198004556`*^9}, {3.8870911631998215`*^9, 
   3.887091194980689*^9}},
 ExpressionUUID -> "d1d18080-cdc3-4e95-a4f5-23693f763d1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log10", "[", 
     RowBox[{"{", 
      RowBox[{"#1", ",", 
       RowBox[{"getPe", "[", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "2"}], ",", "0.5", ",", "#1"}], "]"}]}], "}"}], 
     "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.01", ",", "0.02", ",", "0.03", ",", "0.04", ",", "0.05", ",", "0.06", 
     ",", "0.07", ",", "0.08", ",", "0.09", ",", "0.1", ",", "0.11", ",", 
     "0.12", ",", "0.13", ",", "0.14", ",", "0.15", ",", "0.16", ",", "0.17", 
     ",", "0.18", ",", "0.19", ",", "0.2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.846058795202472*^9, 3.8460587954466925`*^9}},
 ExpressionUUID -> "7faf9294-1cf7-4492-9f96-7f70fb558c57"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.`"}], ",", 
     RowBox[{"-", "2.8755785947103227`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.6989700043360187`"}], ",", 
     RowBox[{"-", "2.336938649648952`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5228787452803376`"}], ",", 
     RowBox[{"-", "2.037809968682972`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3979400086720375`"}], ",", 
     RowBox[{"-", "1.8337124283299107`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3010299956639813`"}], ",", 
     RowBox[{"-", "1.6802741057191322`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2218487496163564`"}], ",", 
     RowBox[{"-", "1.5581009350755461`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.154901959985743`"}], ",", 
     RowBox[{"-", "1.4570474930218236`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0969100130080565`"}], ",", 
     RowBox[{"-", "1.3711546403250343`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0457574905606752`"}], ",", 
     RowBox[{"-", "1.296641393466932`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "1.2309671074816828`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.958607314841775`"}], ",", 
     RowBox[{"-", "1.1723406407892352`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9208187539523752`"}], ",", 
     RowBox[{"-", "1.1194594740953459`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8860566476931632`"}], ",", 
     RowBox[{"-", "1.0713444552703726`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8538719643217619`"}], ",", 
     RowBox[{"-", "1.027245191021152`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8239087409443188`"}], ",", 
     RowBox[{"-", "0.9865700673253592`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7958800173440752`"}], ",", 
     RowBox[{"-", "0.9488494557570922`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.769551078621726`"}], ",", 
     RowBox[{"-", "0.913702213514349`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.744727494896694`"}], ",", 
     RowBox[{"-", "0.8808126313091147`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.721246399047171`"}], ",", 
     RowBox[{"-", "0.8499233928247931`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6989700043360187`"}], ",", 
     RowBox[{"-", "0.820814376019068`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9684843045938597`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`"}], ",", 
       RowBox[{"-", "2.8755785947103227`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.6989700043360187`"}], ",", 
       RowBox[{"-", "2.336938649648952`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5228787452803376`"}], ",", 
       RowBox[{"-", "2.037809968682972`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3979400086720375`"}], ",", 
       RowBox[{"-", "1.8337124283299107`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3010299956639813`"}], ",", 
       RowBox[{"-", "1.6802741057191322`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2218487496163564`"}], ",", 
       RowBox[{"-", "1.5581009350755461`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.154901959985743`"}], ",", 
       RowBox[{"-", "1.4570474930218236`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.0969100130080565`"}], ",", 
       RowBox[{"-", "1.3711546403250343`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.0457574905606752`"}], ",", 
       RowBox[{"-", "1.296641393466932`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`"}], ",", 
       RowBox[{"-", "1.2309671074816828`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.958607314841775`"}], ",", 
       RowBox[{"-", "1.1723406407892352`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9208187539523752`"}], ",", 
       RowBox[{"-", "1.1194594740953459`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8860566476931632`"}], ",", 
       RowBox[{"-", "1.0713444552703726`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8538719643217619`"}], ",", 
       RowBox[{"-", "1.027245191021152`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8239087409443188`"}], ",", 
       RowBox[{"-", "0.9865700673253592`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7958800173440752`"}], ",", 
       RowBox[{"-", "0.9488494557570922`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.769551078621726`"}], ",", 
       RowBox[{"-", "0.913702213514349`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.744727494896694`"}], ",", 
       RowBox[{"-", "0.8808126313091147`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.721246399047171`"}], ",", 
       RowBox[{"-", "0.8499233928247931`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6989700043360187`"}], ",", 
       RowBox[{"-", "0.820814376019068`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(log\), \(10\)]\) \!\(\*SubscriptBox[\(P\), \(s\
\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(log\), \(10\)]\) (\!\(\*SubscriptBox[\(P\), \
\(e1\)]\)+\!\(\*SubscriptBox[\(P\), \(e2\)]\))/2\>\""}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "3"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8460584132176914`*^9, 3.8460584188699813`*^9}, 
   3.846058704746663*^9, {3.846058807120249*^9, 3.846058855236289*^9}, {
   3.846058917511284*^9, 3.846058927680457*^9}},
 ExpressionUUID -> "db19cd74-ad79-4317-9221-288303d64961"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAAAAAAAAAAMAo3qpZLwEHwIAh2Cv7
Lvu/VQEI5AyyAsCBCmwatl34vzGmF1BvTQDAAEOwV/Zd9r+hId/X4lb9v4De
J9QE0fS/sRHGGWfi+r8BLERGsYzzv4tDAD/77fi/4JlDenp68r/Y9TMIEVD3
v4FkiIPxjPG/T0Yf2T/w9b8CFdg0bLvwvxRJuQsLv/S/AAAAAAAA8L9kXtGQ
CrLzvyN1Xj/prO6/GGJ/QujB8r8DmzjkWHftv2v9ZlZO6fG/YduHeJNa7L/p
MWIVOiTxv8F2N0zrUuu/wotGp5hv8L8B0ifddV3qv3r/y2P7ke+/AgzBXtl3
6b9Fu6mI+Vzuv9EEaZUpoOi/R3aqbAw97b8EbWDBztTnvxYLrPidL+y/330I
VHMU578MNgmLkjLrvwBDsFf2Xea/WtWighxE6r8op6gU
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(log\\), \\(10\\)]\\) \
\\!\\(\\*SubscriptBox[\\(P\\), \\(s\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(log\\), \\(10\\)]\\) \
(\\!\\(\\*SubscriptBox[\\(P\\), \\(e1\\)]\\)+\\!\\(\\*SubscriptBox[\\(P\\), \
\\(e2\\)]\\))/2\"", TraditionalForm]},
  AxesOrigin->{-2, -3},
  AxesStyle->Directive[Large],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  Method->{},
  PlotRange->{{-2., -0.6989700043360187}, {-3., -0.820814376019068}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.968484307549823*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"this", " ", "is", " ", "a", " ", "4", " ", "detector", " ", 
      RowBox[{"scheme", ".", " ", "the"}], " ", "Rs", " ", "is", " ", "the", 
      " ", "probability", " ", "of", " ", "success", " ", "of", " ", "XX1"}], 
     "-", "X1"}], ",", " ", 
    RowBox[{"T1", 
     RowBox[{"(", "T2", ")"}], " ", "is", " ", "the", " ", "BS", " ", 
     "transmission", " ", "to", " ", "XX1", " ", 
     RowBox[{"(", "X1", ")"}], " ", "and", " ", "T", " ", "are", " ", "the", 
     " ", "losses", " ", "before", " ", "I", " ", "reach", " ", "the", " ", 
     "fiber", " ", 
     RowBox[{"BSs", "."}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.864289620805925*^9, 3.8642896840826902`*^9}, {
  3.864289756404172*^9, 3.8642897951188097`*^9}},
 ExpressionUUID -> "50a71169-9e9e-41c7-803f-80f6f56ec624"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lrate", "=", "80000000"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"blink", "=", "0.693598"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rabi", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"drivingrate", "=", 
    RowBox[{"lrate", "*", "blink", "*", "rabi"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8866646063453646`*^9, 3.8866647049794674`*^9}, {
   3.88666476345429*^9, 3.886664850724818*^9}, 3.8873464041584463`*^9},
 ExpressionUUID -> "ad425593-76af-43ae-9370-f0e33a68706e"],

Cell[BoxData["2.7743920000000004`*^7"], "Output",
 CellChangeTimes->{3.9684843118954115`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cc", "=", 
   RowBox[{"219880", "/", "1200"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"scc", " ", "=", " ", 
   RowBox[{
    RowBox[{"Sqrt", "[", "219880", "]"}], "/", "1200."}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"succ", "=", 
  RowBox[{"cc", "/", "drivingrate"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errcc", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"348", "+", "285"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1200", "*", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"serrcc", "=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"348", "^", "2"}], "+", 
      RowBox[{"285", "^", "2"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1200", "*", "2."}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rater", "=", 
  RowBox[{"errcc", "/", "drivingrate"}]}]}], "Input",
 CellChangeTimes->{{3.8866647520837736`*^9, 3.8866647571796293`*^9}, {
  3.8866648629320326`*^9, 3.886664917700817*^9}, {3.886665954470433*^9, 
  3.8866659785433297`*^9}, {3.8873482426806264`*^9, 3.887348271151847*^9}, {
  3.887348327489011*^9, 3.8873484412367544`*^9}, {3.88734848133279*^9, 
  3.8873484868792653`*^9}, {3.8873485642184296`*^9, 3.887348662756156*^9}},
 ExpressionUUID -> "e59f9f06-d7b3-48d3-a0d1-4eb0436db663"],

Cell[BoxData["6.60445003205507`*^-6"], "Output",
 CellChangeTimes->{3.9684843146024714`*^9}],

Cell[BoxData["9.50658738923699`*^-9"], "Output",
 CellChangeTimes->{3.9684843146024714`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis", "Section",
 CellChangeTimes->{{3.8872698165266867`*^9, 
  3.8872698181162677`*^9}},ExpressionUUID->"354b302e-7c5d-4863-9f5e-\
d49c1a914a62"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\\
rawdata\\\\Gaussianity_post_matlab_conv2_square11x11.txt\>\"", ",", 
       "\"\<Data\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", " ", "=", " ", 
     RowBox[{"Drop", "[", 
      RowBox[{"data", ",", " ", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tsetup", " ", "=", " ", "0.424"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tdet", " ", "=", " ", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tcoupling", " ", "=", " ", "0.6919683881639405"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]Tcoupling", " ", "=", " ", "0.002182593342891458"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T1", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"0.5195725089060644", "*", "0.513736362870924"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T2", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"0.5788552646262161", "*", "0.5713013418201311"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{"Tsetup", "*", "Tdet", "*", "Tcoupling"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"T", "=", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"0.805161577205266", "*", "0.7795365625998585", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"0.5774423076712294", "*", "0.4384193141710676"}], "]"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"0.4615952846023682", "*", "0.5988890982383565"}], "]"}]}], 
       "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lrate", "=", "80000000"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"blink", "=", "0.5660980066507492"}], 
    RowBox[{"(*", "0.693598", "*)"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]blink", " ", "=", " ", "0.006212197431842366"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rabi", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"drivingrate", "=", 
     RowBox[{"lrate", "*", "blink", "*", "rabi", "*", "0.5"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intT", " ", "=", " ", "1200"}], ";"}], "  ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"results", " ", "=", " ", 
     RowBox[{"MapIndexed", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"drivingrate", "*", "intT"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "+", 
             RowBox[{"#", "[", 
              RowBox[{"[", "5", "]"}], "]"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], ",", 
          RowBox[{"getPe", "[", 
           RowBox[{"T1", ",", "T2", ",", "T", ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "+", 
              RowBox[{"#", "[", 
               RowBox[{"[", "5", "]"}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "/", 
           RowBox[{"getPe", "[", 
            RowBox[{"T1", ",", "T2", ",", "T", ",", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "/", 
              RowBox[{"(", 
               RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}]}], " ", 
          ",", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "4", "]"}], "]"}], "+", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "5", "]"}], "]"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "-", 
              RowBox[{"getPe", "[", 
               RowBox[{"T1", ",", "T2", ",", "T", ",", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}]}], 
             ")"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "5", "]"}], "]"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "*", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "4", "]"}], "]"}], "+", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "5", "]"}], "]"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"intT", "*", "2"}], ")"}]}], "*", "intT", "*", 
                  "2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}],
               "]"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "+", 
              RowBox[{"#", "[", 
               RowBox[{"[", "5", "]"}], "]"}], " ", "-", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "6", "]"}], "]"}], "+", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "7", "]"}], "]"}]}], " ", ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "/", 
           RowBox[{"getPe", "[", 
            RowBox[{"T1", ",", "T2", ",", "T", ",", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "/", 
              RowBox[{"(", 
               RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}]}]}], 
         " ", " ", "}"}], "&"}], ",", "data"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "T1", "]"}], ";", 
    RowBox[{"Clear", "[", "T2", "]"}], ";", 
    RowBox[{"Clear", "[", "T", "]"}], ";", 
    RowBox[{"Clear", "[", "Ts", "]"}], ";", 
    RowBox[{"Clear", "[", "Rs", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.887269829035657*^9, 3.88726985271607*^9}, 
   3.887358443534589*^9, {3.8873624035612316`*^9, 3.8873624071893063`*^9}, {
   3.8873630876586847`*^9, 3.8873630990486994`*^9}, {3.8873647279269824`*^9, 
   3.8873647284493375`*^9}, {3.8873653237590075`*^9, 
   3.8873653306164007`*^9}, {3.8873671016042266`*^9, 3.887367117107402*^9}, {
   3.8873675684625015`*^9, 3.8873675813491898`*^9}, {3.887367644147151*^9, 
   3.8873676854756145`*^9}, {3.887367731583333*^9, 3.887367753434393*^9}, 
   3.8873678839505024`*^9, {3.8873681279391546`*^9, 3.8873683014136777`*^9}, {
   3.8874281071294327`*^9, 3.8874281090883255`*^9}, {3.887428252036001*^9, 
   3.8874282591229906`*^9}, {3.8874285625932617`*^9, 
   3.8874285631504583`*^9}, {3.887429061737112*^9, 3.8874290632353315`*^9}, {
   3.887429106716096*^9, 3.8874291130829124`*^9}, {3.887693814382931*^9, 
   3.887693836534712*^9}, {3.8876938724332137`*^9, 3.887693879104092*^9}, {
   3.8876939558667755`*^9, 3.887693985445306*^9}, {3.8876940245837035`*^9, 
   3.8876940247525616`*^9}, {3.8876940611401296`*^9, 
   3.8876940832073154`*^9}, {3.8880385901678753`*^9, 
   3.8880385918713107`*^9}, {3.8882981835823784`*^9, 3.8882982533558064`*^9}, 
   3.888298359151672*^9, {3.8882984164864874`*^9, 3.8882984184462214`*^9}, {
   3.8882984519881077`*^9, 3.8882984984144998`*^9}, {3.888301590708249*^9, 
   3.8883015916452827`*^9}, {3.8883031808160763`*^9, 
   3.8883031967240715`*^9}, {3.8883032736082506`*^9, 
   3.8883032788449383`*^9}, {3.8913216024601088`*^9, 
   3.8913216193157253`*^9}, {3.891321697286784*^9, 3.891321730632518*^9}, 
   3.8913263513876896`*^9, 3.8913263943710337`*^9, 3.891326711446417*^9, {
   3.891328152537912*^9, 3.8913281544285936`*^9}, {3.8913282138889475`*^9, 
   3.891328215323677*^9}, {3.891329749423899*^9, 3.891329772022976*^9}, {
   3.891332481990656*^9, 3.8913325176173873`*^9}, {3.891332555452719*^9, 
   3.8913325781259375`*^9}, 3.8913353597456956`*^9, 3.891491040251529*^9, {
   3.89149156203461*^9, 3.891491562081212*^9}, 3.8914916237309265`*^9, {
   3.8914920979892044`*^9, 3.891492147190007*^9}, {3.891492182192693*^9, 
   3.891492198140875*^9}, {3.891492246055253*^9, 3.8914922681940928`*^9}, 
   3.891498625581402*^9, {3.891502723730392*^9, 3.8915027462700233`*^9}, {
   3.8915027814222574`*^9, 3.8915028069582567`*^9}, 3.891502838785904*^9, 
   3.8915030218864183`*^9, {3.8915030690672207`*^9, 3.891503097304002*^9}, {
   3.891503302865059*^9, 3.8915033039894543`*^9}, {3.8915034037913685`*^9, 
   3.891503442902485*^9}, {3.8915034989855843`*^9, 3.8915035056127763`*^9}, {
   3.8915035900896177`*^9, 3.891503593597371*^9}, {3.891504064216433*^9, 
   3.8915040865553827`*^9}, {3.8915831736306686`*^9, 3.891583191004345*^9}, {
   3.8927852164565945`*^9, 3.89278527756281*^9}, 3.892795540723666*^9, 
   3.892795988168147*^9, {3.9684853656603756`*^9, 3.9684853831630344`*^9}},
 ExpressionUUID -> "9aa85b12-4bbc-4493-924f-333db86c1362"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{"results", ",", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "6", "]"}], "]"}], "&"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<tx(ps)\>\"", ",", "\"\<ty(ps)\>\"", ",", "\"\<success rate\>\"", 
        ",", "\"\<error rate exp\>\"", ",", "\"\<error rate Theory\>\"", ",", 
        "\"\<errExp/errTeo\>\"", ",", " ", "\"\<distance std\>\"", ",", " ", 
        "\"\<Estimation no Background - Gaussianity_Jan.mat\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8890655730010786`*^9, 3.8890656066950827`*^9}, {
  3.8913325850542912`*^9, 3.891332586722636*^9}, {3.891503105326276*^9, 
  3.891503114205388*^9}},
 ExpressionUUID -> "f3f181e5-220e-48df-bf13-a12607538b6b"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"tx(ps)\"\>",
       HoldForm], 
      TagBox["\<\"ty(ps)\"\>",
       HoldForm], 
      TagBox["\<\"success rate\"\>",
       HoldForm], 
      TagBox["\<\"error rate exp\"\>",
       HoldForm], 
      TagBox["\<\"error rate Theory\"\>",
       HoldForm], 
      TagBox["\<\"errExp/errTeo\"\>",
       HoldForm], 
      TagBox["\<\"distance std\"\>",
       HoldForm], 
      TagBox["\<\"Estimation no Background - Gaussianity_Jan.mat\"\>",
       HoldForm]},
     {"2176", "2432", "0.000017967516014016228`", "2.925730139554817`*^-8", 
      "4.177131818217106`*^-8", "0.7004160430837408`", "11.521077712149406`", 
      "0.5400369929976693`"},
     {"2048", "2432", "0.000018032213291819214`", "3.032454886783861`*^-8", 
      "4.210841808571786`*^-8", "0.7201540748006383`", "10.639305263036324`", 
      "0.5652795948555743`"},
     {"2304", "2432", "0.000016341840502259065`", "2.5282724602190682`*^-8", 
      "3.457526892569618`*^-8", "0.7312372510109583`", "9.258252346714809`", 
      "0.5409058026569686`"},
     {"1920", "2432", "0.00001789023257636761`", "3.061896196364286`*^-8", 
      "4.14355728617366`*^-8", "0.7389535090009033`", "9.714675051350193`", 
      "0.586329888349348`"},
     {"1792", "2432", "0.00001765602695865532`", "3.006693740900988`*^-8", 
      "4.0370289555724526`*^-8", "0.7447788395846761`", "9.345941598314017`", 
      "0.5935084919381902`"},
     {"2176", "2304", "0.00001930974531778784`", "3.6249612420899306`*^-8", 
      "4.826307459238066`*^-8", "0.7510837783762344`", "9.83427636322047`", 
      "0.6047075278448448`"},
     {"2176", "2560", "0.000015506664152736334`", "2.3516246027365132`*^-8", 
      "3.11158596111305`*^-8", "0.7557639840666044`", "7.871838808781213`", 
      "0.5596617067398065`"},
     {"1664", "2432", "0.000017260188551346497`", "2.9146896484621572`*^-8", 
      "3.853941882292489`*^-8", "0.7562879092323975`", "8.665052309961887`", 
      "0.6034675373295771`"},
     {"2048", "2304", "0.00001941823654359171`", "3.746406644109187`*^-8", 
      "4.877066350772452`*^-8", "0.7681680696256704`", "9.08825085390581`", 
      "0.6269593506117509`"},
     {"2304", "2560", "0.000014273441297686246`", "2.0461710158395954`*^-8", 
      "2.637533924598756`*^-8", "0.7757894587653034`", "6.597456383280056`", 
      "0.5489333203142812`"},
     {"2048", "2560", "0.000015533382141180572`", "2.4325882040826843`*^-8", 
      "3.12321152828865`*^-8", "0.7788739834139926`", "7.024931561896517`", 
      "0.5891921159355841`"},
     {"1792", "2304", "0.000019065308844996355`", "3.680163697553229`*^-8", 
      "4.7041410655701554`*^-8", "0.7823242641443157`", "8.312512878739925`", 
      "0.6447401395927889`"},
     {"1920", "2304", "0.000019287369922506716`", "3.7758479536896125`*^-8", 
      "4.811853682173961`*^-8", "0.7846971672637625`", "8.291335434845298`", 
      "0.6456785860097048`"},
     {"1536", "2432", "0.000016616454317370486`", "2.8484467019061992`*^-8", 
      "3.574815832241285`*^-8", "0.7968093562236247`", "6.785292491810398`", 
      "0.6421378482404667`"},
     {"1664", "2304", "0.000018685000728491203`", "3.602880259904611`*^-8", 
      "4.520326851720213`*^-8", "0.797039766833129`", "7.535673773208068`", 
      "0.6586663241669776`"},
     {"1920", "2560", "0.000015387058832565854`", "2.4657096773606633`*^-8", 
      "3.065300413496175`*^-8", "0.804394135891027`", "6.0548197040494385`", 
      "0.6175708891860855`"},
     {"2304", "2304", "0.000017334822271132877`", "3.172301107290883`*^-8", 
      "3.8863244677944664`*^-8", "0.8162728391773217`", "6.28992763639729`", 
      "0.6375413761595609`"},
     {"1792", "2560", "0.00001514895224133416`", "2.443628695175344`*^-8", 
      "2.9737696471965336`*^-8", "0.8217276336380088`", "5.379429840951766`", 
      "0.6364585984018167`"},
     {"1536", "2304", "0.00001805768002460628`", "3.492475348978014`*^-8", 
      "4.2176000747407016`*^-8", "0.8280717201933214`", "6.059197906151278`", 
      "0.6883110739030152`"},
     {"1664", "2560", "0.000014752304198011873`", "2.381065912316939`*^-8", 
      "2.8169285792856158`*^-8", "0.8452702456946163`", "4.484752512494986`", 
      "0.657397008290633`"},
     {"2176", "2176", "0.000019327557310083997`", "4.099702359074297`*^-8", 
      "4.8335424718271014`*^-8", "0.8481775805157228`", "5.609916047307339`", 
      "0.6982413851948847`"},
     {"1408", "2432", "0.000015506075326544725`", "2.6460376985407715`*^-8", 
      "3.11158596111305`*^-8", "0.8503823232298725`", "4.525864372239742`", 
      "0.6836319239819244`"},
     {"1408", "2304", "0.000016964818612980874`", "3.187021762081096`*^-8", 
      "3.7257660567835416`*^-8", "0.8554003964576498`", "4.733864895058546`", 
      "0.7063329162266548`"},
     {"2048", "2176", "0.000019458939154086648`", "4.213787433698447`*^-8", 
      "4.898901417860202`*^-8", "0.8601494650078084`", "5.157556870610435`", 
      "0.7158415049183099`"},
     {"1792", "2176", "0.000019142518679371023`", "4.099702359074297`*^-8", 
      "4.7399098201950096`*^-8", "0.8649325650895245`", "4.894131633489464`", 
      "0.724532993395043`"},
     {"1920", "2176", "0.000019343308410709525`", "4.2101072700008936`*^-8", 
      "4.840782918957842`*^-8", "0.8697161885762221`", "4.750069555951867`", 
      "0.7277550095778518`"},
     {"1664", "2176", "0.00001879040061678913`", "4.00033793924036`*^-8", 
      "4.569455008818224`*^-8", "0.8754518715077464`", "4.410702499801914`", 
      "0.7345686883800161`"},
     {"2304", "2688", "0.000011840558680507759`", "1.622952190620974`*^-8", 
      "1.8157419456876767`*^-8", "0.8938231528304055`", "2.430868240967639`", 
      "0.5901229957918798`"},
     {"1536", "2560", "0.000014109305996775373`", "2.3111428020634277`*^-8", 
      "2.5790470092879048`*^-8", "0.8961227902168222`", "2.8009288594210644`",
       "0.7048944745866242`"},
     {"2176", "2688", "0.000012740285101285572`", "1.884243813147253`*^-8", 
      "2.1012159512334705`*^-8", "0.8967397244634238`", "2.528773244275118`", 
      "0.6286618785759325`"},
     {"1536", "2176", "0.00001819649579927799`", "3.853131391338231`*^-8", 
      "4.2854805815117913`*^-8", "0.8991130208269337`", "3.4214414835855345`",
       "0.7573037933591689`"},
     {"2176", "2048", "0.000018675432302877567`", "4.165945305630255`*^-8", 
      "4.51333020956568`*^-8", "0.9230313564916726`", "2.6319074899979933`", 
      "0.7638794468492393`"},
     {"1408", "2176", "0.00001714418979159962`", "3.514556331163333`*^-8", 
      "3.8024114801249453`*^-8", "0.9242966863354427`", "2.3969947715741737`",
       "0.7734301272147733`"},
     {"2048", "2688", "0.000012738371416162844`", "1.9541669234007646`*^-8", 
      "2.1012159512334705`*^-8", "0.9300171751759336`", "1.6810797474120507`",
       "0.6703975260035605`"},
     {"2048", "2048", "0.000018815720143028294`", "4.2837105439519585`*^-8", 
      "4.583540391678298`*^-8", "0.9345855338657647`", "2.2363826551567274`", 
      "0.7817489569012318`"},
     {"1792", "2048", "0.000018550233133886806`", "4.165945305630255`*^-8", 
      "4.450604274008896`*^-8", "0.9360403776985922`", "2.1566742321943657`", 
      "0.7879563375095912`"},
     {"2304", "2176", "0.000017248264820966423`", "3.6286414057874834`*^-8", 
      "3.853941882292489`*^-8", "0.9415402506352828`", "1.8432855400967232`", 
      "0.7565673947864376`"},
     {"1920", "2048", "0.000018721581555644884`", "4.2763502165568516`*^-8", 
      "4.53433637859213`*^-8", "0.943103876621659`", "1.92613606493789`", 
      "0.7929638457195773`"},
     {"1664", "2048", "0.000018237124806498976`", "4.066580885796318`*^-8", 
      "4.305950368488354`*^-8", "0.9444096048008865`", "1.838199988193731`", 
      "0.7963954695202623`"},
     {"1536", "2048", "0.000017693638231644314`", "3.904653683103976`*^-8", 
      "4.050269153399455`*^-8", "0.964047952177879`", "1.1438597390366683`", 
      "0.8155879804153991`"},
     {"1920", "2688", "0.000012593004950109492`", "1.9983288877714033`*^-8", 
      "2.0537628264705177`*^-8", "0.9730085976897439`", "0.6262597613169986`",
       "0.7170054597044021`"},
     {"1408", "2560", "0.000013012690818178463`", "2.1381751082784258`*^-8", 
      "2.1928698024087367`*^-8", "0.975057938200329`", "0.5960807899019274`", 
      "0.7656871580527842`"},
     {"1408", "2048", "0.000016707575170521902`", "3.5623984592315254`*^-8", 
      "3.612260807139833`*^-8", "0.9861963599611213`", "0.41212138458365405`",
       "0.829164816502789`"},
     {"1792", "2688", "0.00001235924095204091`", "1.976247905586084`*^-8", 
      "1.9789649641221985`*^-8", "0.9986270305006032`", 
      "0.03087719598743166`", "0.7439242967141593`"},
     {"2176", "1920", "0.000017765401423746603`", "4.1696254693278084`*^-8", 
      "4.083464438808804`*^-8", "1.0210999830683327`", "0.65246288229695`", 
      "0.8487001990456663`"},
     {"1792", "1920", "0.000017698422444451133`", "4.1696254693278084`*^-8", 
      "4.0568973735943814`*^-8", "1.0277867752995564`", "0.8536445979700191`",
       "0.8688607122470795`"},
     {"1664", "1920", "0.000017435511549897932`", "4.0629007220987645`*^-8", 
      "3.931887637698139`*^-8", "1.03332065828751`", "1.0066032561923821`", 
      "0.8748662863987329`"},
     {"2304", "2048", "0.00001662300500875213`", "3.6948843523434414`*^-8", 
      "3.574815832241285`*^-8", "1.0335873302952443`", "0.97254776288506`", 
      "0.8359668589346207`"},
     {"2048", "1920", "0.000017908486188307474`", "4.291070871347065`*^-8", 
      "4.150261356805629`*^-8", "1.0339278668102516`", "1.049263590062592`", 
      "0.8685850533189666`"},
     {"1664", "2688", "0.000011964727403663203`", "1.9247256138203387`*^-8", 
      "1.8558892922460046`*^-8", "1.0370907477412232`", "0.7932990617106982`",
       "0.7772014070245571`"},
     {"1920", "1920", "0.0000178342940881648`", "4.2763502165568516`*^-8", 
      "4.116795171427157`*^-8", "1.0387571007265788`", "1.1912450045482406`", 
      "0.8768669308576642`"},
     {"1536", "1920", "0.000016959960796900104`", "3.908333846801529`*^-8", 
      "3.7257660567835416`*^-8", "1.0490014099746237`", "1.4333810659807442`",
       "0.8914536464238209`"},
     {"2432", "2560", "0.000011009945733969994`", "1.659753827596506`*^-8", 
      "1.5716687840061638`*^-8", "1.056045551382534`", "1.097646508002454`", 
      "0.7023551019902883`"},
     {"1408", "1920", "0.00001606376733327194`", "3.551357968138866`*^-8", 
      "3.3421939438227355`*^-8", "1.0625828506160515`", "1.7317440584906554`",
       "0.8971459654954931`"},
     {"2432", "2432", "0.000012157567981414994`", "2.0498511795371485`*^-8", 
      "1.9146548235760008`*^-8", "1.070611346910375`", "1.5068593714528973`", 
      "0.7490810266938496`"},
     {"1536", "2688", "0.000011333432122984923`", "1.851122339869274`*^-8", 
      "1.6637860866808296`*^-8", "1.112596357601578`", "2.203943856182215`", 
      "0.8443604515745666`"},
     {"1664", "1792", "0.00001636657120230662`", "3.937775156381955`*^-8", 
      "3.469780990306148`*^-8", "1.1348771485529736`", "3.6590042839214725`", 
      "0.9593036083836318`"},
     {"1792", "1792", "0.00001656824417293254`", "4.0444999036109986`*^-8", 
      "3.5561664946115457`*^-8", "1.137320176020835`", "3.7615013541367306`", 
      "0.959903377662007`"},
     {"2176", "1792", "0.000016582228794983242`", "4.0629007220987645`*^-8", 
      "3.5623775263005086`*^-8", "1.1405025694505893`", "3.8456332891887657`",
       "0.9467652891283561`"},
     {"1536", "1792", "0.000015977577899475245`", "3.7832082810847194`*^-8", 
      "3.306179380269114`*^-8", "1.1442840348174865`", "3.813621615720292`", 
      "0.9709228859058644`"},
     {"2304", "1920", "0.00001576854460145422`", "3.702244679738548`*^-8", 
      "3.2169963470884966`*^-8", "1.1508389442497253`", "3.9261514339511234`",
       "0.9356879211417959`"},
     {"2048", "1792", "0.000016726564815201278`", "4.173305633025361`*^-8", 
      "3.6247858103966024`*^-8", "1.1513247544325227`", "4.151668524393403`", 
      "0.9658261151359683`"},
     {"1408", "1792", "0.000015193408618800603`", "3.444633220909822`*^-8", 
      "2.990826009074965`*^-8", "1.151733069880322`", "3.820975831747795`", 
      "0.971482162602304`"},
     {"2432", "2688", "9.398770067181192`*^-6", "1.3211787674216092`*^-8", 
      "1.1468976435224931`*^-8", "1.1519587426859144`", "2.4470656221930773`",
       "0.7081662261834031`"},
     {"1920", "1792", "0.000016669080658245497`", "4.151224650840042`*^-8", 
      "3.599757475436505`*^-8", "1.1531956469752636`", "4.186393797816222`", 
      "0.9718929841756364`"},
     {"2176", "2816", "0.000010111323362301447`", "1.530948098182143`*^-8", 
      "1.3261771902861597`*^-8", "1.1544068993162206`", "2.6621959009180434`",
       "0.759068560965726`"},
     {"2304", "2816", "9.46302572534047`*^-6", "1.3469399133044818`*^-8", 
      "1.1610449435206505`*^-8", "1.1601100550165955`", "2.5840100249288303`",
       "0.7187487126142417`"},
     {"2048", "2816", "0.000010089831206307737`", "1.589830717342995`*^-8", 
      "1.3186049474533945`*^-8", "1.205691454755585`", "3.4570800158590202`", 
      "0.8215610979813215`"},
     {"1408", "2688", "0.000010290105714728583`", "1.7112761193622513`*^-8", 
      "1.3720659053362283`*^-8", "1.247225889592307`", "4.1595283262365665`", 
      "0.9467860837726024`"},
     {"2432", "2304", "0.000012522345807116469`", "2.5687542608921538`*^-8", 
      "2.030239470984796`*^-8", "1.265246931509091`", "5.319577774264318`", 
      "0.9440277135036643`"},
     {"1920", "2816", "9.949322556335155`*^-6", "1.6303125180160805`*^-8", 
      "1.284798095690931`*^-8", "1.2689250735068538`", "4.34621717990209`", 
      "0.8900570080095435`"},
     {"2304", "1792", "0.000014655147876396467`", "3.6102405872997175`*^-8", 
      "2.783872465883519`*^-8", "1.296841228017223`", "6.779925419678233`", 
      "1.053181717807975`"},
     {"1408", "1664", "0.000014025030248101404`", "3.3047870004027996`*^-8", 
      "2.5474214071508072`*^-8", "1.2973067554217803`", "6.5238367661555`", 
      "1.095952541345574`"},
     {"1664", "1664", "0.000014951989880241111`", "3.7758479536896125`*^-8", 
      "2.894818101895069`*^-8", "1.3043472234810831`", "7.051036329719443`", 
      "1.1029402109264936`"},
     {"1536", "1664", "0.000014662140187421819`", "3.63600173318259`*^-8", 
      "2.783872465883519`*^-8", "1.3060949370856436`", "6.963847146618089`", 
      "1.1096067731032229`"},
     {"1792", "2816", "9.722550869291923`*^-6", "1.6082315358307608`*^-8", 
      "1.2257809267612885`*^-8", "1.3120056779476645`", "4.84541240494307`", 
      "0.9326173083854143`"},
     {"1792", "1664", "0.000015092204117117889`", "3.8899330283137626`*^-8", 
      "2.9511036947482694`*^-8", "1.318128209197195`", "7.390347727325615`", 
      "1.1132019611997308`"},
     {"2176", "1664", "0.000015069681515288864`", "3.934094992684401`*^-8", 
      "2.939803228629856`*^-8", "1.3382171141154748`", "7.777903002645346`", 
      "1.1123515661524996`"},
     {"2048", "1664", "0.000015212692676575782`", "4.026099085123232`*^-8", 
      "2.9965222914096756`*^-8", "1.3435905671935466`", "7.950770397180923`", 
      "1.127931310750198`"},
     {"1920", "1664", "0.000015166543423808465`", "4.007698266635466`*^-8", 
      "2.9794496758661637`*^-8", "1.3451135956744689`", "7.9608395141879145`",
       "1.1348463928029608`"},
     {"1664", "2816", "9.340255464390095`*^-6", "1.564069571460122`*^-8", 
      "1.1328370352892136`*^-8", "1.3806659940816772`", "5.543850035611277`", 
      "0.9893254291020835`"},
     {"2432", "2816", "7.67225807011107`*^-6", "1.0966887818708622`*^-8", 
      "7.628002063331252`*^-9", "1.4377143225259215`", "5.1638109625422075`", 
      "0.8215846619639883`"},
     {"1536", "2816", "8.74186084716794`*^-6", "1.4831059701139512`*^-8", 
      "9.904360220858166`*^-9", "1.4974273320457312`", "6.512472990065922`", 
      "1.086208030517104`"},
     {"2432", "2176", "0.000012281221481652783`", "2.977252431320562`*^-8", 
      "1.9558751285231324`*^-8", "1.5222098731674474`", "9.31446746754478`", 
      "1.1794384437397387`"},
     {"2304", "1664", "0.000013234604689140922`", "3.499835676373121`*^-8", 
      "2.2715692549191147`*^-8", "1.5407127336286044`", "10.251582722603091`",
       "1.2536196001829725`"},
     {"2176", "2944", "7.873268611271427`*^-6", "1.2512556571680977`*^-8", 
      "8.03590138875876`*^-9", "1.5570818961497597`", "6.465966436466636`", 
      "0.9574824974028497`"},
     {"2304", "2944", "7.401692435066956`*^-6", "1.1150896003586283`*^-8", 
      "7.119169198599451`*^-9", "1.5663198461106937`", "6.181879123132215`", 
      "0.9061531621989507`"},
     {"1408", "1536", "0.000012450656218288133`", "3.1575804525006705`*^-8", 
      "2.0068516071169995`*^-8", "1.573400066702881`", "10.162744301939378`", 
      "1.3301085304350337`"},
     {"1536", "1536", "0.000012903537162909032`", "3.485115021582908`*^-8", 
      "2.1588750009904345`*^-8", "1.6143199675683073`", "11.095058828450822`",
       "1.3723819375562036`"},
     {"2048", "2944", "7.839190295432084`*^-6", "1.28805729414363`*^-8", 
      "7.976979743418156`*^-9", "1.6147180205721499`", "6.976676874276369`", 
      "1.0329694375506848`"},
     {"1664", "1536", "0.000013090121462374982`", "3.639681896880143`*^-8", 
      "2.2222195195098493`*^-8", "1.6378588455936796`", "11.577432228423417`",
       "1.3865998515613862`"},
     {"1792", "1536", "0.000013181831141718009`", "3.753766971504293`*^-8", 
      "2.2517643361030792`*^-8", "1.6670336728045845`", "12.059972170523226`",
       "1.4094247509848896`"},
     {"2432", "2048", "0.000011745389647289032`", "3.028774723086307`*^-8", 
      "1.7892209103198553`*^-8", "1.6927896972458587`", "11.198973575821356`",
       "1.3216783027232544`"},
     {"1920", "1536", "0.00001323725440700316`", "3.860491718733337`*^-8", 
      "2.2715692549191147`*^-8", "1.6994822897754005`", "12.560771942726497`",
       "1.4345568320386666`"},
     {"2176", "1536", "0.000013138258003538978`", "3.8089694269675915`*^-8", 
      "2.236967544533286`*^-8", "1.702737903496174`", "12.520150006924144`", 
      "1.4169419634077676`"},
     {"2048", "1536", "0.000013274203250526595`", "3.893613192011316`*^-8", 
      "2.2815042355350812`*^-8", "1.7065991512823762`", "12.683644984442253`",
       "1.43417198029582`"},
     {"1920", "2944", "7.70339225499237`*^-6", "1.3174986037240559`*^-8", 
      "7.714514860257538`*^-9", "1.7078178311786585`", "7.678142378095891`", 
      "1.1318743603832944`"},
     {"1408", "2816", "7.81880218854764`*^-6", "1.3800613865824608`*^-8", 
      "7.947600189073256`*^-9", "1.7364504425874816`", "8.03351688931095`", 
      "1.266846478992116`"},
     {"1792", "2944", "7.484643324809805`*^-6", "1.2843771304460769`*^-8", 
      "7.258750212013609`*^-9", "1.7694191051241381`", "7.958026750629452`", 
      "1.1872382995525086`"},
     {"2560", "2688", "6.582782409087411`*^-6", "1.0488466538026703`*^-8", 
      "5.623716048397398`*^-9", "1.8650419842971309`", "7.6991620763045665`", 
      "1.0574157591757358`"},
     {"2432", "2944", "6.081249700384858`*^-6", "8.942797785054346`*^-9", 
      "4.792717556156845`*^-9", "1.865913791136347`", "7.130551385889695`", 
      "0.9738785219220124`"},
     {"2560", "2560", "7.3537767037248125`*^-6", "1.3138184400265026`*^-8", 
      "7.008479963044323`*^-9", "1.874612536461915`", "8.63173406297377`", 
      "1.1596419492651773`"},
     {"1664", "2944", "7.127152223229485`*^-6", "1.2512556571680977`*^-8", 
      "6.601118762716851`*^-9", "1.8955205960468329`", "8.538329824874081`", 
      "1.2882469244582282`"},
     {"2432", "1920", "0.00001103865101081091`", "3.061896196364286`*^-8", 
      "1.57993469973583`*^-8", "1.9379890807362135`", "13.30987544434576`", 
      "1.5267799764219347`"},
     {"2304", "1536", "0.000011444205050281275`", "3.3967910928416304`*^-8", 
      "1.6979336048272842`*^-8", "2.0005441220931344`", "14.414601542962053`",
       "1.6309961558776633`"},
     {"1408", "1408", "0.000010407282126858678`", "2.9036491573694976`*^-8", 
      "1.4030919148755316`*^-8", "2.0694646776772854`", "13.871941166642294`",
       "1.7517424506630275`"},
     {"2560", "2432", "7.740414701789754`*^-6", "1.6303125180160805`*^-8", 
      "7.772460952626403`*^-9", "2.0975499625574567`", "10.730700956614596`", 
      "1.3760010903414674`"},
     {"1536", "2944", "6.599416749000352`*^-6", "1.1886928743096928`*^-8", 
      "5.648434331373409`*^-9", "2.104464360517163`", "9.2539098589345`", 
      "1.4585687633471853`"},
     {"1536", "1408", "0.000010674756424396847`", "3.2164630716615217`*^-8", 
      "1.4781687596165938`*^-8", "2.1759782506131473`", "15.197437185638515`",
       "1.8513485769016476`"},
     {"2560", "2816", "5.564554717248384`*^-6", "8.795591237152217`*^-9", 
      "4.028115729859394`*^-9", "2.183549785313452`", "8.261538400832219`", 
      "1.1528313924195466`"},
     {"1664", "1408", "0.000010782069997817499`", "3.3636696195636514`*^-8", 
      "1.506321811728384`*^-8", "2.2330351943215305`", "15.844501842016653`", 
      "1.8905478756642478`"},
     {"2432", "1792", "0.000010118536483148652`", "2.991973086110775`*^-8", 
      "1.3261771902861597`*^-8", "2.256088483519441`", "15.150512082049728`", 
      "1.7766197643146961`"},
     {"1792", "1408", "0.00001084235107918342`", "3.466714203095142`*^-8", 
      "1.522528492170494`*^-8", "2.2769453714150503`", "16.312185813301078`", 
      "1.923836669066896`"},
     {"2176", "3072", "6.023471130333272`*^-6", "1.0819681270806493`*^-8", 
      "4.70197403235062`*^-9", "2.30109336979845`", "9.527806539148669`", 
      "1.3267462186908237`"},
     {"2304", "3072", "5.689680282965194`*^-6", "9.752433798516056`*^-9", 
      "4.197028058428032`*^-9", "2.3236522755506104`", "9.1286045052978`", 
      "1.2603113538720423`"},
     {"1920", "1408", "0.000010885188184622941`", "3.5918397688119516`*^-8", 
      "1.5347404069832038`*^-8", "2.3403565531139763`", "16.92517587770125`", 
      "1.9759040376019361`"},
     {"2048", "1408", "0.000010913231031998296`", "3.639681896880143`*^-8", 
      "1.5429087729668112`*^-8", "2.358974140694989`", "17.12585048325742`", 
      "1.9836523900058551`"},
     {"2176", "1408", "0.000010788767895747046`", "3.580799277719291`*^-8", 
      "1.5103653661086014`*^-8", "2.3708165971423747`", "17.06388796224192`", 
      "1.9756408780262844`"},
     {"2048", "3072", "5.98048681834585`*^-6", "1.1187697640561816`*^-8", 
      "4.634485406551647`*^-9", "2.414010760449492`", "10.030970223216562`", 
      "1.4638232772366193`"},
     {"1408", "2944", "5.853005947862606`*^-6", "1.0966887818708622`*^-8", 
      "4.456900792870755`*^-9", "2.46065333925566`", "10.068131955664864`", 
      "1.7185099806734774`"},
     {"1920", "3072", "5.8516074856575355`*^-6", "1.1371705825439476`*^-8", 
      "4.4349466321591535`*^-9", "2.5641133408415246`", "10.52874931463158`", 
      "1.6157010655882778`"},
     {"2560", "2304", "7.716052018111952`*^-6", "2.0240900336542757`*^-8", 
      "7.714514860257538`*^-9", "2.623742478067771`", "14.055664101406624`", 
      "1.8494184784428944`"},
     {"2432", "3072", "4.7204723715775755`*^-6", "7.654740490910716`*^-9", 
      "2.889519346016556`*^-9", "2.649139726807303`", "8.867724347825805`", 
      "1.2515694136147542`"},
     {"2560", "2944", "4.5196826402390715`*^-6", "7.029112662326667`*^-9", 
      "2.647041918990567`*^-9", "2.655459519510434`", "8.518391641796196`", 
      "1.247364045782037`"},
     {"1792", "3072", "5.6475056069912335`*^-6", "1.1114094366610752`*^-8", 
      "4.133279496443265`*^-9", "2.6889288218168064`", "10.722069219689802`", 
      "1.7238505078001782`"},
     {"2432", "1664", "8.965025973787567`*^-6", "2.9183698121597103`*^-8", 
      "1.043556752122754`*^-8", "2.7965607104963865`", "17.284190658796877`", 
      "2.212313220998441`"},
     {"2304", "1408", "9.275484583313158`*^-6", "3.220143235359075`*^-8", 
      "1.1153832302213118`*^-8", "2.8870285549480084`", "18.389827792494312`",
       "2.362534935244212`"},
     {"1664", "3072", "5.333882056685748`*^-6", "1.0893284544757557`*^-8", 
      "3.7006980813103496`*^-9", "2.943575591797654`", "11.162632746537707`", 
      "1.9243843725545968`"},
     {"2560", "2176", "7.458219749461373`*^-6", "2.333223784248747`*^-8", 
      "7.230725740381416`*^-9", "3.226818258668557`", "16.748602825373457`", 
      "2.3754243590348625`"},
     {"1536", "3072", "4.903597317167825`*^-6", "1.0194053442222444`*^-8", 
      "3.1241897402445318`*^-9", "3.2629431275913965`", "11.354782671717524`",
       "2.171033701122161`"},
     {"2688", "2688", "4.29902002493378`*^-6", "8.501178141347958`*^-9", 
      "2.399033971478559`*^-9", "3.543583893523842`", "10.760967455166702`", 
      "1.8499895007421163`"},
     {"2176", "3200", "4.573413030223348`*^-6", "9.678830524564992`*^-9", 
      "2.7152369797001086`*^-9", "3.5646356457748287`", "11.487294961339627`",
       "1.966450444114962`"},
     {"2304", "3200", "4.329565383623472`*^-6", "8.83239287412775`*^-9", 
      "2.431397139179836`*^-9", "3.6326409749363737`", "11.068478005387956`", 
      "1.896615143164189`"},
     {"2048", "3200", "4.527779000373688`*^-6", "9.826037072467121`*^-9", 
      "2.6640093464536108`*^-9", "3.6884394139036196`", "11.723066734995074`",
       "2.1262352170858496`"},
     {"2688", "2816", "3.8074973614885703`*^-6", "6.992311025351135`*^-9", 
      "1.8820355274229428`*^-9", "3.7152917272107264`", "9.960656853414058`", 
      "1.7636904758954122`"},
     {"2560", "2048", "7.036988212639431`*^-6", "2.3921064034095988`*^-8", 
      "6.415190101360935`*^-9", "3.7288160843466374`", "17.967816472049066`", 
      "2.779192265792765`"},
     {"2560", "3072", "3.5668882589425402`*^-6", "6.145873374913892`*^-9", 
      "1.6470343422447797`*^-9", "3.7314785838269438`", "9.365942013899728`", 
      "1.612323556338837`"},
     {"2432", "1536", "7.536975252589013`*^-6", "2.8226855560233264`*^-8", 
      "7.371390664534516`*^-9", "3.829244283041362`", "19.578137391576423`", 
      "3.0356201022062392`"},
     {"1408", "3072", "4.334349596430291`*^-6", "9.384417428760733`*^-9", 
      "2.4476599636003016`*^-9", "3.834036413684295`", "11.626567590245154`", 
      "2.57949422609807`"},
     {"2688", "2560", "4.564801447171074`*^-6", "1.0562069811977767`*^-8", 
      "2.698106904563957`*^-9", "3.9146224317915634`", "12.40095901414608`", 
      "2.234931035673975`"},
     {"1920", "3200", "4.4085416965729634`*^-6", "1.0046846894320315`*^-8", 
      "2.529787102023562`*^-9", "3.9714199215751793`", "12.16397714754237`", 
      "2.404389091267238`"},
     {"2432", "3200", "3.618116137612481`*^-6", "6.8819061144245375`*^-9", 
      "1.700919349811869`*^-9", "4.045992019072341`", "10.180962832801004`", 
      "1.814020811994413`"},
     {"1792", "3200", "4.228213675392856`*^-6", "9.678830524564992`*^-9", 
      "2.319074876577787`*^-9", "4.173573963617704`", "12.14081255994023`", 
      "2.557828390852972`"},
     {"2688", "2944", "3.207189059143688`*^-6", "5.6674520942319726`*^-9", 
      "1.3419373390277656`*^-9", "4.2233358662916745`", "9.384695363023907`", 
      "1.80264335756352`"},
     {"2560", "1920", "6.497917834221834`*^-6", "2.410507221897365`*^-8", 
      "5.476543607496609`*^-9", "4.401511965681646`", "19.041662615678362`", 
      "3.315270276887934`"},
     {"1664", "3200", "3.972221488591053`*^-6", "9.49482233968733`*^-9", 
      "2.0424427704668346`*^-9", "4.64875808369266`", "12.41578308941593`", 
      "2.9205257936452624`"},
     {"2688", "2432", "4.631559616644689`*^-6", "1.3469399133044818`*^-8", 
      "2.78429945765879`*^-9", "4.837625886825664`", "14.852690586877177`", 
      "2.995388573066812`"},
     {"1536", "3200", "3.6366641626481497`*^-6", "8.979599422029879`*^-9", 
      "1.7145261876905238`*^-9", "5.237364985439767`", "12.456310834731724`", 
      "3.388790838739665`"},
     {"2560", "1792", "5.819663664762774`*^-6", "2.362665093829173`*^-8", 
      "4.3912010139202096`*^-9", "5.380453061336681`", "19.874541370333695`", 
      "4.057211556414449`"},
     {"2560", "3200", "2.7749170312290855`*^-6", "5.557047183305376`*^-9", 
      "1.0044736153957956`*^-9", "5.532297810645545`", "9.976731274198903`", 
      "2.298347596346363`"},
     {"2688", "3072", "2.5956194558842924`*^-6", "5.005022628672391`*^-9", 
      "8.733903045232694`*^-10", "5.730568112276365`", "9.548992799915839`", 
      "2.28256667456345`"},
     {"2432", "1408", "5.855066839533236`*^-6", "2.6754790081211973`*^-8", 
      "4.456900792870755`*^-9", "6.003003280667332`", "21.547921231748724`", 
      "4.785666637261629`"},
     {"1408", "3200", "3.209323554088269`*^-6", "8.133161771592635`*^-9", 
      "1.3419373390277656`*^-9", "6.060761210717272`", "12.251276899517554`", 
      "3.952772141566463`"},
     {"2688", "2304", "4.532784023002361`*^-6", "1.6523935002013998`*^-8", 
      "2.6640093464536108`*^-9", "6.202656542482117`", "17.31154934742495`", 
      "4.140102247039442`"},
     {"2560", "1664", "4.986401000362772`*^-6", "2.3111428020634277`*^-8", 
      "3.2355887413793027`*^-9", "7.142881827058799`", "20.780118542831776`", 
      "5.427902199325486`"},
     {"2816", "2816", "2.483521669656821`*^-6", "6.10907173793836`*^-9", 
      "7.972770776909499`*^-10", "7.66241988999768`", "11.092312980866044`", 
      "3.526109182408571`"},
     {"2816", "2688", "2.6667938217949717`*^-6", "7.102715936277732`*^-9", 
      "9.227228425778833`*^-10", "7.697561617131224`", "11.949593200111497`", 
      "3.700919142218594`"},
     {"2688", "2176", "4.323161898789729`*^-6", "1.898964467937466`*^-8", 
      "2.431397139179836`*^-9", "7.810178096113203`", "19.219050106698234`", 
      "5.475172591390386`"},
     {"2816", "2944", "2.1900654164139263`*^-6", "4.931419354721326`*^-9", 
      "6.221723691801628`*^-10", "7.926130440699998`", "10.03473257440892`", 
      "3.30808465608393`"},
     {"2688", "3200", "2.0625845459306826`*^-6", "4.4897997110149395`*^-9", 
      "5.504494082764211`*^-10", "8.156607389357536`", "9.620785488611181`", 
      "3.1251775413242138`"},
     {"2816", "2560", "2.7397346662804767`*^-6", "8.942797785054346`*^-9", 
      "9.734105188563547`*^-10", "9.187077406520226`", "13.69277755644161`", 
      "4.916741617140015`"},
     {"2688", "2048", "4.007551060087564`*^-6", "1.946806596005658`*^-8", 
      "2.087328476729766`*^-9", "9.326785974077904`", "19.909618767140604`", 
      "6.637632205398114`"},
     {"2816", "3072", "1.8394930225850059`*^-6", "4.268989889161745`*^-9", 
      "4.4066883475579743`*^-10", "9.687523946474371`", "9.591794862757865`", 
      "3.7051316355418176`"},
     {"2560", "1536", "3.980906674917279`*^-6", "2.2485800192050228`*^-8", 
      "2.057350567685745`*^-9", "10.929493760192685`", "21.673589714112534`", 
      "8.352330387814016`"},
     {"2688", "1920", "3.6118598593266407`*^-6", "1.9615272507958708`*^-8", 
      "1.700919349811869`*^-9", "11.532159070404052`", "20.43910129330856`", 
      "8.31626297490035`"},
     {"2816", "2432", "2.7407651121157917`*^-6", "1.126130091451288`*^-8", 
      "9.734105188563547`*^-10", "11.568912289692136`", "15.694253716255206`",
       "6.684905917752532`"},
     {"2816", "3200", "1.5006971525882556`*^-6", "3.790568608479826`*^-9", 
      "2.903898232986535`*^-10", "13.053379644717744`", "9.313816098981066`", 
      "4.80808241471903`"},
     {"2944", "2944", "1.448733241178804`*^-6", "4.048180067308552`*^-9", 
      "2.7380042677549454`*^-10", "14.78514885817873`", "9.714591722864236`", 
      "5.4993541484689175`"},
     {"2688", "1792", "3.131156877152238`*^-6", "1.9026446316350194`*^-8", 
      "1.2705416718716833`*^-9", "14.975066727501831`", "20.58805469344566`", 
      "10.778628723946568`"},
     {"2816", "2304", "2.651116324443395`*^-6", "1.4021423687677801`*^-8", 
      "9.127478217685336`*^-10", "15.361771732864826`", "17.843830026723577`",
       "9.752920501932453`"},
     {"2944", "2816", "1.5657624467609967`*^-6", "5.041824265647924`*^-9", 
      "3.191230057986161`*^-10", "15.798999677351961`", "10.874513032904352`",
       "6.501582295566855`"},
     {"2944", "3072", "1.2748823081063895`*^-6", "3.4225522387245028`*^-9", 
      "2.123218267868765`*^-10", "16.119643893983532`", "8.995166718319803`", 
      "5.2611845859067605`"},
     {"2944", "2688", "1.6290612623589123`*^-6", "5.814658642134101`*^-9", 
      "3.43085226894857`*^-10", "16.948146368062883`", "11.717197778696445`", 
      "7.163325834479192`"},
     {"2944", "3200", "1.078214360109145`*^-6", "2.9073293210670506`*^-9", 
      "1.5046303092347557`*^-10", "19.322549221713455`", "8.388397132020035`",
       "5.607655532081088`"},
     {"2816", "2176", "2.49176523633934`*^-6", "1.5861505536454415`*^-8", 
      "8.066015078078692`*^-10", "19.664611810064446`", "19.212530430000776`",
       "13.091194235391209`"},
     {"2560", "1408", "2.8636089763401184`*^-6", "2.123454453488213`*^-8", 
      "1.0680635265103433`*^-9", "19.881349758530952`", "22.059110142987734`",
       "15.314614560160187`"},
     {"2944", "2560", "1.6491549561475528`*^-6", "7.286724121155393`*^-9", 
      "3.5539166054476823`*^-10", "20.50336271252345`", "13.228182595390194`",
       "9.737708171733694`"},
     {"2688", "1664", "2.5650740971946005`*^-6", "1.865842994659487`*^-8", 
      "8.5403673022455`*^-10", "21.847338980009738`", "20.858702306497808`", 
      "15.910710595510542`"},
     {"2816", "2048", "2.262638244529676`*^-6", "1.6155918632258674`*^-8", 
      "6.639157001941953`*^-10", "24.334292181271007`", "19.580408148796252`",
       "16.444811542135113`"},
     {"2944", "2432", "1.6370840192195784`*^-6", "9.200409243883072`*^-9", 
      "3.492114375447386`*^-10", "26.346242576045004`", "14.987321770895216`",
       "13.67948321850841`"},
     {"3072", "3072", "8.477625093683618`*^-7", "2.6129162252627925`*^-9", 
      "9.277778545424553`*^-11", "28.16316656481721`", "8.092437850201629`", 
      "7.091584023363459`"},
     {"3072", "2944", "9.244571208253711`*^-7", "3.2753456908223738`*^-9", 
      "1.1278344924647854`*^-10", "29.041013665616727`", "9.060705788445109`",
       "9.606057411455016`"},
     {"3072", "3200", "7.456011651242842`*^-7", "2.171296581556405`*^-9", 
      "7.19045378794192`*^-11", "30.196933957041427`", "7.400533776596214`", 
      "6.372689038887851`"},
     {"2816", "1920", "1.981179324940805`*^-6", "1.6155918632258674`*^-8", 
      "5.125006530271037`*^-10", "31.523703505221224`", "19.771782268488973`",
       "21.582676720642347`"},
     {"3072", "2816", "9.707535801405908`*^-7", "4.084981704284084`*^-9", 
      "1.2351814016042795`*^-10", "33.07191720162257`", "10.149477502372356`",
       "11.88874017619304`"},
     {"2944", "2304", "1.5648792074735839`*^-6", "1.093008618173309`*^-8", 
      "3.191230057986161`*^-10", "34.2503861618506`", "16.43912643134529`", 
      "19.24457108642377`"},
     {"3072", "2688", "1.0013725421042335`*^-6", "4.894617717745794`*^-9", 
      "1.3094558770632148`*^-10", "37.37901981640809`", "11.135214656912739`",
       "14.418992881682447`"},
     {"2688", "1536", "1.9131698998100213`*^-6", "1.8106405391961886`*^-8", 
      "4.75907091512795`*^-10", "38.04609285061491`", "20.985344837355363`", 
      "27.911218771060135`"},
     {"2816", "1792", "1.6512158478181827`*^-6", "1.564069571460122`*^-8", 
      "3.5539166054476823`*^-10", "44.00974319607306`", "19.650519456821705`",
       "30.063011378069266`"},
     {"2944", "2176", "1.4456419036728593`*^-6", "1.2512556571680977`*^-8", 
      "2.7380042677549454`*^-10", "45.69955101618879`", "17.677346863557535`",
       "27.542666991571792`"},
     {"3072", "2560", "1.009836918608606`*^-6", "6.366683196767086`*^-9", 
      "1.3094558770632148`*^-10", "48.62083028750827`", "12.750296312954482`",
       "22.079189955740045`"},
     {"2944", "2048", "1.2819482224056917`*^-6", "1.2770168030509703`*^-8", 
      "2.123218267868765`*^-10", "60.14533797002458`", "17.947084530371484`", 
      "37.03332822221244`"},
     {"3200", "3072", "5.364206605553587`*^-7", "2.3553047664340664`*^-9", 
      "3.81270570670722`*^-11", "61.77515254562321`", "7.84034319155461`", 
      "16.197143655254866`"},
     {"3072", "2432", "9.971035522150717`*^-7", "8.096360134617104`*^-9", 
      "1.3094558770632148`*^-10", "61.829957591050984`", 
      "14.402965653668733`", "30.72647282726008`"},
     {"3200", "3200", "4.916698699931114`*^-7", "2.024090033654276`*^-9", 
      "3.227140776829174`*^-11", "62.72084714082554`", "7.273908487724674`", 
      "16.36861132699597`"},
     {"2816", "1664", "1.2879100875957278`*^-6", "1.5162274433919304`*^-8", 
      "2.1714685605189743`*^-10", "69.82497794163581`", "19.528508229643972`",
       "48.20411912540764`"},
     {"3200", "2944", "5.694685305593866`*^-7", "3.05453586896918`*^-9", 
      "4.230188421772141`*^-11", "72.2080334116548`", "8.939699001052874`", 
      "25.526377958924737`"},
     {"3072", "2304", "9.412386672862138`*^-7", "9.310814154809669`*^-9", 
      "1.1630740814894125`*^-10", "80.05349188837913`", "15.473338360404433`",
       "41.89437778039785`"},
     {"2944", "1920", "1.0898436773934132`*^-6", "1.2622961482607576`*^-8", 
      "1.5452916724001398`*^-10", "81.68659488730468`", "17.927044773743628`",
       "50.85735486992788`"},
     {"2688", "1408", "1.257217522358134`*^-6", "1.7112761193622513`*^-8", 
      "2.0755097640545728`*^-10", "82.45088262168521`", "20.72983001452416`", 
      "61.25756763151638`"},
     {"3200", "2816", "5.910342898270486`*^-7", "3.86417188243089`*^-9", 
      "4.447059387402419`*^-11", "86.89274295228154`", "10.065587823443675`", 
      "32.94052415751997`"},
     {"3200", "2688", "6.095823148627168`*^-7", "4.600204621941536`*^-9", 
      "4.8970660859737336`*^-11", "93.93797308795824`", "10.978997885311056`",
       "36.9794850156011`"},
     {"3072", "2176", "8.554172498592725`*^-7", "1.0562069811977767`*^-8", 
      "9.597661554394676`*^-11", "110.04836701229057`", "16.504349562082602`",
       "61.90279096238228`"},
     {"3200", "2560", "6.16648229162019`*^-7", "5.851460279109634`*^-9", 
      "4.8970660859737336`*^-11", "119.48910176788289`", "12.38597569910866`",
       "52.953522780704645`"},
     {"2944", "1792", "8.714627635806046`*^-7", "1.2328548386803317`*^-8", 
      "9.922951349494724`*^-11", "124.24275754844939`", "17.800195279612236`",
       "77.62571706603705`"},
     {"2816", "1536", "9.056882859678496`*^-7", "1.4610249879286319`*^-8", 
      "1.0589806809235824`*^-10", "137.96521638661144`", 
      "19.323916147802578`", "95.9619830018444`"},
     {"3072", "2048", "7.417001916048778`*^-7", "1.0746077996855427`*^-8", 
      "7.19045378794192`*^-11", "149.44923246535757`", "16.68288868462917`", 
      "86.07811413839589`"},
     {"3200", "2432", "6.05166118425653`*^-7", "7.39712903208199`*^-9", 
      "4.669359343623114`*^-11", "158.41850000651922`", "13.920488533411438`",
       "75.8451876927219`"},
     {"3200", "2304", "5.647579210265185`*^-7", "8.721987963201153`*^-9", 
      "4.230188421772141`*^-11", "206.18438456099022`", "15.106090861535662`",
       "106.40234603077961`"},
     {"2944", "1664", "6.547011217947194`*^-7", "1.1923730380072461`*^-8", 
      "5.612743603222725`*^-11", "212.44031837168`", "17.575677264387803`", 
      "134.68626628472515`"},
     {"3072", "1920", "6.170162455317743`*^-7", "1.0709276359879896`*^-8", 
      "4.8970660859737336`*^-11", "218.6876013487668`", "16.69078830002712`", 
      "128.56213526613445`"},
     {"3200", "2176", "5.069057477009818`*^-7", "9.789235435491589`*^-9", 
      "3.416911198428352`*^-11", "286.49370343584764`", "15.9983654977002`", 
      "157.61619481157953`"},
     {"2816", "1408", "5.696157371072887`*^-7", "1.3690208954898011`*^-8", 
      "4.230188421772141`*^-11", "323.6311858931998`", "18.810981849088442`", 
      "228.51731290826226`"},
     {"3072", "1792", "4.848247655156624`*^-7", "1.0488466538026703`*^-8", 
      "3.042799345820413`*^-11", "344.69793588044683`", "16.551338845953577`",
       "204.1933343743649`"},
     {"3200", "2048", "4.3212482136670015`*^-7", "9.97324362036925`*^-9", 
      "2.3596291587324458`*^-11", "422.66148404975274`", 
      "16.161534594252675`", "238.7575199926446`"},
     {"2944", "1536", "4.5619309194869824`*^-7", "1.1371705825439476`*^-8", 
      "2.690370148883403`*^-11", "422.681831723383`", "17.219363431685043`", 
      "269.64358386521286`"},
     {"3072", "1664", "3.6676511409815477`*^-7", "1.0120450168271378`*^-8", 
      "1.7631951454433192`*^-11", "573.983554482099`", "16.286751792132353`", 
      "346.3500765338324`"},
     {"3200", "1920", "3.5712308521056533`*^-7", "9.899640346418185`*^-9", 
      "1.6276369141365876`*^-11", "608.2216654363389`", "16.115317112177717`",
       "350.40715043816283`"},
     {"2944", "1408", "3.047175541574073`*^-7", "1.0672474722904363`*^-8", 
      "1.2535028570681561`*^-11", "851.4120779801361`", "16.719939388634057`",
       "556.8192025545449`"},
     {"3200", "1792", "2.8572790947803267`*^-7", "9.642028887589459`*^-9", 
      "1.0311806963869685`*^-11", "935.0474578677644`", "15.919911626912612`",
       "541.5127755907059`"},
     {"3072", "1536", "2.7093365141386873`*^-7", "9.458020702711799`*^-9", 
      "9.28151999701754`*^-12", "1019.0163578542065`", "15.773267385431742`", 
      "613.1795783405712`"},
     {"3200", "1664", "2.2883257871385978`*^-7", "9.274012517834136`*^-9", 
      "6.516009953827506`*^-12", "1423.2655541581207`", "15.627999392695767`",
       "840.6386028116463`"},
     {"3072", "1408", "1.984344265720701`*^-7", "8.83239287412775`*^-9", 
      "4.943379039445972`*^-12", "1786.7116406913515`", "15.264254910623364`",
       "1110.6119664927492`"},
     {"3200", "1536", "1.8113765719356992`*^-7", "8.464376504372427`*^-9", 
      "4.238331907657766`*^-12", "1997.1009087511752`", "14.952500478904808`",
       "1159.6103951078537`"},
     {"3200", "1408", "1.3969901395912056`*^-7", "7.838748675788378`*^-9", 
      "2.4485968808107827`*^-12", "3201.3226583841765`", 
      "14.406368980401346`", "1925.082553590347`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     None, {"tx(ps)", "ty(ps)", "success rate", "error rate exp", 
       "error rate Theory", "errExp/errTeo", "distance std", 
       "Estimation no Background - Gaussianity_Jan.mat"}}]]]], "Output",
 CellChangeTimes->{3.968485405097227*^9}]
}, Open  ]],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{
  3.891503450050851*^9},ExpressionUUID->"b7e7b79f-6eb5-4c8a-a3a4-\
2260e957a583"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uncertainty Calculation", "Section",
 CellChangeTimes->{{3.8872699267529387`*^9, 
  3.887269940513857*^9}},ExpressionUUID->"d1a5018a-e4fd-45da-acf3-\
eab4d677f067"],

Cell[CellGroupData[{

Cell["\<\
Uncertainty of experimental error/success rate : \
rate*Sqrt[(DeltaN/N)**2+(Delta_blink/blink)**2]\
\>", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.8872703645957155`*^9}, {3.8872704222117653`*^9, 
   3.8872704584059315`*^9}, {3.8872706171771927`*^9, 3.887270619602538*^9}, {
   3.8873481558212566`*^9, 3.8873481558212566`*^9}, {3.887349360542349*^9, 
   3.887349449178747*^9}},ExpressionUUID->"5b02d5a9-f9d7-4f4f-a9e7-\
87a096444ff4"],

Cell["Uncertainty success: Sqrt[219880].;", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.8872703645957155`*^9}, {3.8872704222117653`*^9, 
   3.8872704584059315`*^9}, {3.8872706171771927`*^9, 3.887270619602538*^9}, {
   3.8873481576709185`*^9, 3.8873481576709185`*^9}, 3.8873487525842896`*^9, {
   3.8873487861093683`*^9, 
   3.887348845461692*^9}},ExpressionUUID->"4f512dd2-364f-4ad7-806c-\
5432ade81e91"],

Cell["Uncertainty experimental error: Sqrt[348^2+285^2]/2.;", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.8872703645957155`*^9}, {3.8872704222117653`*^9, 
   3.8872704584059315`*^9}, {3.8872706171771927`*^9, 3.887270619602538*^9}, {
   3.887348760449577*^9, 3.887348841806207*^9}, {3.8873494620549765`*^9, 
   3.8873494624241514`*^9}},ExpressionUUID->"3fd94025-384a-45da-a235-\
d13087d85959"],

Cell["Uncertainty (1 sigma) of  T1, T2, T, blinking", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.887270311786497*^9}, {3.887270519077286*^9, 3.88727059153549*^9}, {
   3.887345872947033*^9, 
   3.887345872947033*^9}},ExpressionUUID->"438be0fc-e12e-4959-9cfa-\
3967be7145a2"],

Cell["T1: 0.51665(26)", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.887270311786497*^9}, {3.887270519077286*^9, 3.88727059153549*^9}, {
   3.8873459103911037`*^9, 3.887345940028837*^9}, {3.8873460009796047`*^9, 
   3.8873460118031883`*^9}},ExpressionUUID->"bef9720e-b63a-41d8-a9d8-\
9d87e20119c0"],

Cell["T2: 0.57508(35)", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.887270311786497*^9}, {3.887270519077286*^9, 3.88727059153549*^9}, {
   3.8873459103911037`*^9, 3.887345940028837*^9}, {3.8873460009796047`*^9, 
   3.8873460302462997`*^9}},ExpressionUUID->"c116be2a-ad60-44ff-8aa3-\
9dc577334a2d"],

Cell["T: 0.424(16)", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.887270311786497*^9}, {3.887270519077286*^9, 3.88727059153549*^9}, {
   3.8873459103911037`*^9, 3.887345940028837*^9}, {3.8873460009796047`*^9, 
   3.887346032026154*^9}, {3.887346186120349*^9, 
   3.887346196174657*^9}},ExpressionUUID->"f7797b66-a2a2-4058-8585-\
1e4f4221ae86"],

Cell["blinking: 0.6936(56)", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.887270311786497*^9}, {3.887270519077286*^9, 3.88727059153549*^9}, {
   3.8873459103911037`*^9, 3.887345940028837*^9}, {3.8873460009796047`*^9, 
   3.887346032026154*^9}, {3.887346186120349*^9, 3.887346189700495*^9}, {
   3.887346392648101*^9, 3.8873464182939386`*^9}, {3.8873471115101776`*^9, 
   3.887347125725172*^9}, 3.8873471567366686`*^9, {3.887347299626429*^9, 
   3.887347299626429*^9}},ExpressionUUID->"19e94f0c-63d8-4452-bbac-\
9c28bca98474"],

Cell["\<\
Error estimation of  theoretical error using minimum and maximum values (3 \
sigma)\
\>", "Item",
 CellChangeTimes->{
  3.887269944607938*^9, {3.8872699893508053`*^9, 3.887270028208832*^9}, {
   3.88727026119736*^9, 3.8872702644928274`*^9}, {3.88727030997991*^9, 
   3.887270311786497*^9}, {3.887270519077286*^9, 3.88727059153549*^9}, {
   3.8873459103911037`*^9, 3.887345940028837*^9}, {3.8873460009796047`*^9, 
   3.887346032026154*^9}, {3.887346186120349*^9, 3.887346189700495*^9}, {
   3.887346392648101*^9, 3.8873464182939386`*^9}, {3.8873471115101776`*^9, 
   3.887347125725172*^9}, 3.8873471567366686`*^9, {3.8873473006448226`*^9, 
   3.887347364993651*^9}, {3.8873481425943117`*^9, 
   3.887348145904948*^9}},ExpressionUUID->"7a4660ee-8da0-4e6b-8a00-\
5a7e0ecb21b4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"T1", "=", 
     RowBox[{"0.51665", " ", "+", 
      RowBox[{"\[Sigma]T1", "*", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T2", "=", 
     RowBox[{"0.57508", " ", "+", " ", 
      RowBox[{"\[Sigma]T2", "*", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tsetup", "*", "Tdet", "*", "Tcoupling"}], "+", " ", 
       RowBox[{"3", "*", "\[Sigma]T"}]}], ")"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rs", "=", 
     RowBox[{"succ", " ", "-", " ", 
      RowBox[{"3", "*", " ", "succ", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"cc", "*", "intT"}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"errmin", " ", "=", " ", 
     RowBox[{"getPe", "[", 
      RowBox[{"T1", ",", "T2", ",", "T", ",", "Rs"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "T1", "]"}], ";", 
    RowBox[{"Clear", "[", "T2", "]"}], ";", 
    RowBox[{"Clear", "[", "T", "]"}], ";", 
    RowBox[{"Clear", "[", "Ts", "]"}], ";", 
    RowBox[{"Clear", "[", "Rs", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.8873487248309255`*^9, 3.8873487265513315`*^9}, {
   3.8873544939543896`*^9, 3.8873544982402315`*^9}, {3.8873546477336893`*^9, 
   3.887354673797309*^9}, {3.887354803903787*^9, 3.88735490636452*^9}, {
   3.8873577594685135`*^9, 3.887357825628615*^9}, {3.8873601947347455`*^9, 
   3.887360265909066*^9}, {3.8873608112603703`*^9, 3.8873608227478085`*^9}, {
   3.887362957079115*^9, 3.887362963619007*^9}, {3.8873631387377234`*^9, 
   3.8873631535583353`*^9}, {3.8874291851570053`*^9, 3.887429186172252*^9}, {
   3.8882980201264887`*^9, 3.888298032014264*^9}, {3.888298141264597*^9, 
   3.8882981414182167`*^9}, {3.8882985444723535`*^9, 3.888298551905633*^9}, 
   3.8882986348168736`*^9, 3.888298727650058*^9, {3.888301138120503*^9, 
   3.8883011393563056`*^9}, {3.891327861314063*^9, 3.891327864516475*^9}, 
   3.8913280903367577`*^9, {3.8914911128747115`*^9, 3.891491116618003*^9}, {
   3.8914911904186*^9, 3.8914911933241377`*^9}, {3.891491276475279*^9, 
   3.891491296189909*^9}, {3.891491341120162*^9, 3.891491365175513*^9}, {
   3.891491497650322*^9, 3.891491501007849*^9}, {3.891491578795513*^9, 
   3.89149158146434*^9}, {3.891491885349683*^9, 3.8914918877103453`*^9}, {
   3.8914922942861176`*^9, 3.8914923081742277`*^9}, {3.8916599707750406`*^9, 
   3.8916599738118877`*^9}, 3.8916600140611763`*^9},
 ExpressionUUID -> "eec6a64b-c95b-47b1-9e4e-87eabf5d1580"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"T1", "=", 
     RowBox[{"0.51665", " ", "-", " ", 
      RowBox[{"\[Sigma]T1", "*", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T2", "=", 
     RowBox[{"0.57508", " ", "-", 
      RowBox[{"\[Sigma]T2", "*", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tsetup", "*", "Tdet", "*", "Tcoupling"}], "-", " ", 
       RowBox[{"3", "*", "\[Sigma]T"}]}], ")"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rs", "=", 
     RowBox[{"succ", " ", "+", " ", 
      RowBox[{"3", "*", " ", "succ", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"cc", "*", "intT"}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"errmax", " ", "=", " ", 
     RowBox[{"getPe", "[", 
      RowBox[{"T1", ",", "T2", ",", "T", ",", "Rs"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "T1", "]"}], ";", 
    RowBox[{"Clear", "[", "T2", "]"}], ";", 
    RowBox[{"Clear", "[", "T", "]"}], ";", 
    RowBox[{"Clear", "[", "Ts", "]"}], ";", 
    RowBox[{"Clear", "[", "Rs", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.8873630095284004`*^9, 3.8873630233645315`*^9}, {
   3.8873631575714455`*^9, 3.887363163702366*^9}, {3.8874291883861866`*^9, 
   3.8874291889786453`*^9}, 3.8882980417275257`*^9, {3.888298142991866*^9, 
   3.888298143154733*^9}, 3.888298657888889*^9, 3.8882987297770042`*^9, {
   3.888301142565721*^9, 3.8883011445368333`*^9}, {3.8913278700404024`*^9, 
   3.8913278737842107`*^9}, {3.891328100638927*^9, 3.891328101256443*^9}, 
   3.891332395627634*^9, 3.8914911220793514`*^9, 3.8914913033330173`*^9, {
   3.891491335581279*^9, 3.89149133668248*^9}, {3.8914913710658617`*^9, 
   3.8914913739101644`*^9}, {3.8914914833027706`*^9, 3.891491493187667*^9}, {
   3.8914915836872425`*^9, 3.8914915881355586`*^9}, {3.891491889561491*^9, 
   3.89149189128202*^9}, {3.891492297806594*^9, 3.891492312271387*^9}, {
   3.8916599799352007`*^9, 3.891659983577832*^9}, 3.891660017639502*^9},
 ExpressionUUID -> "90b93ba8-cc34-411a-aab9-d8e208b2df2f"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"T1", "=", "0.51665"}], " ", ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T2", "=", "0.57508"}], " ", ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{"0.5", "*", "0.424"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rs", "=", "succ"}], " ", ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"errPe", " ", "=", " ", 
     RowBox[{"getPe", "[", 
      RowBox[{"T1", ",", "T2", ",", "T", ",", "Rs"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "T1", "]"}], ";", 
    RowBox[{"Clear", "[", "T2", "]"}], ";", 
    RowBox[{"Clear", "[", "T", "]"}], ";", 
    RowBox[{"Clear", "[", "Ts", "]"}], ";", 
    RowBox[{"Clear", "[", "Rs", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.887363048780034*^9, 3.8873630640189466`*^9}, {
   3.887363174110031*^9, 3.8873631831334753`*^9}, {3.8873646195875406`*^9, 
   3.8873646502337294`*^9}, 3.887367841354323*^9, {3.8874291908665695`*^9, 
   3.887429191939819*^9}, {3.8882986438978863`*^9, 3.888298645280406*^9}},
 ExpressionUUID -> "e3ceaa1e-19d5-46e4-bfa9-5c85c25ec7d7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"succmax", " ", "=", " ", "0.000017967516014016228`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errormax", " ", "=", "2.925730139554817`*^-8"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lrate", "=", "80000000"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"blink", "=", "0.5721948156679171"}], "*)"}], 
  RowBox[{"(*", "0.693598", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rabi", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"drivingrate", "=", 
  RowBox[{
  "lrate", "*", "blink", "*", "rabi", "*", "0.5"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Sigma]blink", " ", "=", " ", "0.006212197431842366"}]}], "Input",
 CellChangeTimes->{{3.8873487388452983`*^9, 3.8873487399708757`*^9}, {
   3.8873629451977577`*^9, 3.887362946630517*^9}, {3.887363188201909*^9, 
   3.8873631889348416`*^9}, {3.8873639798146825`*^9, 3.887363981486362*^9}, {
   3.887364054190754*^9, 3.887364054808305*^9}, {3.8873678240713577`*^9, 
   3.887367826162146*^9}, 3.887428581467632*^9, {3.8874288303504705`*^9, 
   3.8874288315846024`*^9}, {3.887429142846923*^9, 3.887429143409274*^9}, {
   3.8874295569825306`*^9, 3.8874295589196377`*^9}, 3.888298326266602*^9, {
   3.891322691592882*^9, 3.8913227404452505`*^9}, 3.891326725028307*^9, {
   3.8913278224229035`*^9, 3.89132784112904*^9}, 3.891327908664583*^9, {
   3.8913353690066843`*^9, 3.891335373719388*^9}, 3.891335445021217*^9, 
   3.8914916137529345`*^9, {3.891491782115364*^9, 3.891491826889438*^9}},
 ExpressionUUID -> "a5c7dcf3-1ac5-4cf2-89ef-8ce8e37fb1ea"],

Cell[BoxData["1.1321960133014983`*^7"], "Output",
 CellChangeTimes->{3.9684843504356365`*^9, 3.96848439275597*^9, 
  3.9684854814626703`*^9}],

Cell[BoxData["0.006212197431842366`"], "Output",
 CellChangeTimes->{3.9684843504356365`*^9, 3.96848439275597*^9, 
  3.9684854814678264`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"cc", " ", "=", " ", 
    RowBox[{"drivingrate", " ", "*", "succmax"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"cc", "=", 
     RowBox[{"219880", "/", "1200"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"succ", "=", 
  RowBox[{"cc", "/", "drivingrate"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]succ", " ", "=", " ", 
   RowBox[{"succ", "*", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"succ", "*", "drivingrate", "*", "1200"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"errcc", " ", "=", " ", 
    RowBox[{"drivingrate", "*", "errormax"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"errcc", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"348", "+", "285"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1200", "*", "2"}], ")"}]}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"rater", "=", 
  RowBox[{"errcc", "/", "drivingrate"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]rater", " ", "=", " ", 
   RowBox[{"rater", "*", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"rater", "*", "drivingrate", "*", "1200", "*", "2"}], ")"}]}],
       "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
     "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8873487449664564`*^9, 3.887348772125147*^9}, {
   3.8873496669228773`*^9, 3.8873499215536194`*^9}, {3.8873499686229296`*^9, 
   3.8873499920387697`*^9}, {3.88735299221649*^9, 3.8873530377965107`*^9}, {
   3.8873530857248154`*^9, 3.8873531393181877`*^9}, {3.8873532598917904`*^9, 
   3.8873532699484577`*^9}, {3.8873542601874833`*^9, 3.887354268758011*^9}, 
   3.887360115024269*^9, {3.8873631915112734`*^9, 3.8873632071942077`*^9}, {
   3.887363713270591*^9, 3.8873638603841543`*^9}, {3.887363904594302*^9, 
   3.8873639186235867`*^9}, {3.8873640655486116`*^9, 3.88736407662897*^9}, 
   3.887365438151948*^9, {3.887367802118432*^9, 3.8873678135151415`*^9}, {
   3.887368321302188*^9, 3.887368330246248*^9}, {3.887429319930366*^9, 
   3.8874293340821753`*^9}, {3.8882979734764423`*^9, 
   3.8882979865275993`*^9}, {3.888298275699559*^9, 3.8882982911935873`*^9}, {
   3.8882983753392863`*^9, 3.888298387716883*^9}, {3.8882985203368883`*^9, 
   3.888298531600177*^9}, {3.891322832604982*^9, 3.8913228575859566`*^9}, 
   3.891323162100964*^9, 3.8913232120609846`*^9, {3.891323673703277*^9, 
   3.8913236743742485`*^9}, {3.891327848889182*^9, 3.891327851080872*^9}, {
   3.891327936546726*^9, 3.891327948416996*^9}, 3.8913354254608183`*^9, 
   3.8913354583084354`*^9, {3.891491641650288*^9, 3.891491671889823*^9}, {
   3.8914917999874244`*^9, 3.891491836657343*^9}, {3.891600279561865*^9, 
   3.891600300018345*^9}, {3.891600416109995*^9, 3.891600419742803*^9}, {
   3.891600463341503*^9, 3.8916004689369073`*^9}},
 ExpressionUUID -> "417c8b04-14ac-4f9d-bd4c-b513489f2272"],

Cell[BoxData["0.000017967516014016228`"], "Output",
 CellChangeTimes->{3.968484355227234*^9, 3.968484396103957*^9, 
  3.9684854841707478`*^9}],

Cell[BoxData["2.925730139554817`*^-8"], "Output",
 CellChangeTimes->{3.968484355227234*^9, 3.968484396103957*^9, 
  3.9684854841707478`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"\[Sigma]Pe", " ", "=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"errmax", " ", "-", "errmin"}], ")"}], "/", "6"}], 
   ")"}]}], "\[IndentingNewLine]", "\[Sigma]rater", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rater", "/", "errPe"}], "*", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Sigma]rater", "/", "rater"}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Sigma]Pe", "/", "errPe"}], ")"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"clear", "[", 
   RowBox[{"rater", ",", "errPe", ",", "succ", ",", "errcc"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.887354708888056*^9, 3.88735473560389*^9}, {
   3.887354897916875*^9, 3.88735497870243*^9}, {3.887357816774293*^9, 
   3.88735783460458*^9}, {3.887358741949745*^9, 3.8873587893154383`*^9}, {
   3.887360134820262*^9, 3.8873601655421495`*^9}, {3.887363225032671*^9, 
   3.887363273087834*^9}, {3.88736359644858*^9, 3.887363666149655*^9}, {
   3.8873640080918436`*^9, 3.8873640086092434`*^9}, {3.887364081639079*^9, 
   3.8873640993600535`*^9}, {3.8873654625304985`*^9, 3.887365537520681*^9}, {
   3.887365733031812*^9, 3.887365736091488*^9}, {3.8873660339640226`*^9, 
   3.8873660840668583`*^9}, {3.8873678601819654`*^9, 
   3.8873678603827176`*^9}, {3.887428530259935*^9, 3.887428530447138*^9}, 
   3.8913327177083683`*^9},
 ExpressionUUID -> "73cb2dd6-865b-41ae-8abc-2ca6028f9712"],

Cell[BoxData["1.2268655350903637`*^-9"], "Output",
 CellChangeTimes->{3.9684843582934785`*^9, 3.9684843990112357`*^9, 
  3.9684854874115305`*^9}],

Cell[BoxData["1.086184565305587`*^-9"], "Output",
 CellChangeTimes->{3.9684843582934785`*^9, 3.9684843990112357`*^9, 
  3.9684854874115305`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tsetup", " ", "=", " ", "0.424"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tdet", " ", "=", " ", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tcoupling", " ", "=", " ", "0.6919683881639405"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]Tcoupling", " ", "=", " ", "0.002182593342891458"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T1", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"0.5195725089060644", "*", "0.513736362870924"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]T1", " ", "=", " ", "0.00025629615047562267"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T2", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"0.5788552646262161", "*", "0.5713013418201311"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]T2", " ", "=", " ", "0.00034834174650329576"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"Tsetup", "*", "Tdet", "*", "Tcoupling"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]T", " ", "=", " ", "0.0033658233299105156"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"criterion", " ", "=", " ", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#1", ",", 
        RowBox[{"getPe", "[", 
         RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}]}], "}"}], 
      "&"}], ",", 
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1", ",", "0.01"}], "]"}]}], "*", 
      "succmax"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"criterionlowerbound", " ", "=", " ", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#1", ",", 
        RowBox[{
         RowBox[{"getPe", "[", 
          RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"getPe", "[", 
             RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}], "-", 
            RowBox[{"getPe", "[", 
             RowBox[{
              RowBox[{"T1", "+", 
               RowBox[{"3", "*", "\[Sigma]T1"}]}], ",", 
              RowBox[{"T2", "+", 
               RowBox[{"3", "*", "\[Sigma]T2"}]}], ",", 
              RowBox[{"T", "+", 
               RowBox[{"3", "*", "\[Sigma]T"}]}], ",", 
              RowBox[{"#1", "*", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"3", "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{"#1", "*", "drivingrate", "*", "1200"}], ")"}]}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}]}], "]"}]}], ")"}], "/", 
          "3"}]}]}], "}"}], "&"}], ",", 
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1", ",", "0.01"}], "]"}]}], "*", 
      "succmax"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"criterionupperbound", " ", "=", " ", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#1", ",", 
        RowBox[{
         RowBox[{"getPe", "[", 
          RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"getPe", "[", 
             RowBox[{
              RowBox[{"T1", "-", 
               RowBox[{"3", "*", "\[Sigma]T1"}]}], ",", 
              RowBox[{"T2", "-", 
               RowBox[{"3", "*", "\[Sigma]T2"}]}], ",", 
              RowBox[{"T", "-", 
               RowBox[{"3", "*", "\[Sigma]T"}]}], ",", 
              RowBox[{"#1", "*", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"3", "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{"#1", "*", "drivingrate", "*", "1200"}], ")"}]}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}]}], "]"}], "-", 
            RowBox[{"getPe", "[", 
             RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}]}], ")"}], 
          "/", "3"}]}]}], "}"}], "&"}], ",", 
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1", ",", "0.01"}], "]"}]}], "*", 
      "succmax"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"clear", "[", 
   RowBox[{"T1", ",", "T2", ",", "T"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8882980821182528`*^9, 3.888298095059473*^9}, {
   3.8913279260468597`*^9, 3.8913279422959166`*^9}, 3.891333028741407*^9, {
   3.8915929578282156`*^9, 3.8915930454547386`*^9}, {3.891593114974182*^9, 
   3.8915931429483767`*^9}, 3.8915931858571463`*^9, {3.891593220686846*^9, 
   3.8915932230795164`*^9}, {3.891593285993731*^9, 3.8915933710526705`*^9}, {
   3.891593664886387*^9, 3.8915937980313835`*^9}, {3.8915940959672127`*^9, 
   3.8915941092435055`*^9}, {3.891594163903034*^9, 3.8915941926279488`*^9}, {
   3.8915942358688216`*^9, 3.891594266027343*^9}, {3.8915946569121113`*^9, 
   3.8915946706481256`*^9}, {3.89159470584868*^9, 3.8915947062966924`*^9}, {
   3.8915947405321903`*^9, 3.8915947644694524`*^9}, {3.891596201080435*^9, 
   3.8915962476440797`*^9}, {3.89165878248798*^9, 3.891658840346285*^9}, {
   3.891658922454248*^9, 3.891658972496006*^9}, {3.8916590053933773`*^9, 
   3.8916590626215224`*^9}},
 ExpressionUUID -> "2c8226f2-f663-476e-b4ab-a698d51640f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "criterionupperbound", ",", "criterion", ",", "criterionlowerbound", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"Log10", "[", 
       RowBox[{"{", 
        RowBox[{"0.000017967516014016228`", ",", "2.925730139554817`*^-8"}], 
        "}"}], "]"}], "}"}]}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(log\), \(10\)]\) \!\(\*SubscriptBox[\(P\), \(s\
\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(log\), \(10\)]\) (\!\(\*SubscriptBox[\(P\), \
\(e1\)]\)+\!\(\*SubscriptBox[\(P\), \(e2\)]\))/2\>\""}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6"}], ",", 
      RowBox[{"-", "10"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8915931047835746`*^9, 3.8915931529435062`*^9}, {
   3.8915932094456186`*^9, 3.891593239036853*^9}, {3.891593398004594*^9, 
   3.8915934159948416`*^9}, {3.891594509495782*^9, 3.89159453211307*^9}, {
   3.891594579223899*^9, 3.8915945825976677`*^9}, {3.891594686960477*^9, 
   3.8915946895446725`*^9}, {3.891594792981413*^9, 3.8915947994225807`*^9}, {
   3.8915950031996117`*^9, 3.8915950292737093`*^9}, {3.8915950646333957`*^9, 
   3.8915950904605064`*^9}, {3.89159519903708*^9, 3.8915952284382915`*^9}, {
   3.891595305715884*^9, 3.8915953741680565`*^9}, {3.8915956791988044`*^9, 
   3.8915957407199373`*^9}, 3.8915961576646805`*^9},
 ExpressionUUID -> "93f9a4b9-8ed2-42a9-b493-7ac68e46ee37"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011111111111111112`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwllAk0lPsbx8fYlwrZt8Z2aYpwrcmDkAzKOldcshWmyJIlRJElEbnIHilp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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.011111111111111112`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwl1Xk8VOsfB/AxlmyJiSyRoYSy9pMIX4RsTdeey1W2myVbUwkpUpGKRhdN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      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.011111111111111112`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwllXk41Gsbx+27QvZ1CFky6EUJt4TsHescKbKVLfvSJFFESJKIyFqJsZzk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      "]]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.011111111111111112`],
      AbsoluteThickness[1.6], 
     LineBox[{{-4.745511959394783, -7.533765734364876}, {-4.745511959394783, \
-7.533765734364876}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(log\\), \\(10\\)]\\) \
\\!\\(\\*SubscriptBox[\\(P\\), \\(s\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(log\\), \\(10\\)]\\) \
(\\!\\(\\*SubscriptBox[\\(P\\), \\(e1\\)]\\)+\\!\\(\\*SubscriptBox[\\(P\\), \
\\(e2\\)]\\))/2\"", TraditionalForm]},
  AxesOrigin->{-6, -10},
  AxesStyle->Directive[Large],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  Method->{},
  PlotRange->{{-6., 0.00017967516014016227`}, {-10., 2.103973530463247*^-6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9684844632239833`*^9, 3.9684855130432353`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\Codes\\\
\\CodeOutput\\\\criterion.dat\>\"", ",", "criterion"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\Codes\\\
\\CodeOutput\\\\criterionlowerbound.dat\>\"", ",", "criterionlowerbound"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\Codes\\\
\\CodeOutput\\\\criterionupperbound.dat\>\"", ",", "criterionupperbound"}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8915949827468495`*^9, 3.8915950153561954`*^9}, {
  3.8915951101428547`*^9, 3.8915952197442317`*^9}, {3.891595291236427*^9, 
  3.8915952965391445`*^9}, {3.891595378523192*^9, 3.8915953803453045`*^9}, {
  3.891595775077671*^9, 3.89159585352481*^9}, {3.89159603642625*^9, 
  3.891596041203273*^9}, {3.89159639636191*^9, 3.8915964242613*^9}, {
  3.891596485637451*^9, 3.891596496580744*^9}, {3.891596591494238*^9, 
  3.8915966193115673`*^9}, {3.9684860096196475`*^9, 3.9684860526464443`*^9}},
 ExpressionUUID -> "c568f820-62b6-4eba-bc00-0f141e13f079"],

Cell[BoxData[
 RowBox[{
  RowBox[{"results", " ", "=", " ", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"drivingrate", "*", "intT"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], ",", 
        RowBox[{"getPe", "[", 
         RowBox[{"T1", ",", "T2", ",", "T", ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "+", 
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "/", 
         RowBox[{"getPe", "[", 
          RowBox[{"T1", ",", "T2", ",", "T", ",", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}]}], " ", 
        ",", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "+", 
               RowBox[{"#", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "-", 
            RowBox[{"getPe", "[", 
             RowBox[{"T1", ",", "T2", ",", "T", ",", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}]}], 
           ")"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"intT", "*", "2"}], ")"}]}], "*", "intT", "*", 
                "2"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
            "]"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"drivingrate", "*", "1200"}], ")"}]}], ")"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "/", 
                RowBox[{"(", 
                 RowBox[{"drivingrate", "*", "1200"}], ")"}]}], ")"}], "*", 
              "drivingrate", "*", "1200"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
          "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "+", 
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "+", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "*", 
              "drivingrate", "*", "1200", "*", "2"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
          "]"}]}]}], "  ", "}"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"244113", ",", "365", ",", "430"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"197776", ",", "308", ",", "348"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"156550", ",", "240", " ", ",", " ", "275"}], "}"}], ",", 
       RowBox[{"{", " ", 
        RowBox[{"120180", ",", "180", ",", " ", "212"}], "}"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8915975642403727`*^9, 3.8915975643879223`*^9}, 
   3.8915978316515417`*^9, {3.891597862006404*^9, 3.8915978894038267`*^9}, {
   3.891598003567919*^9, 3.8915981265728264`*^9}, {3.8915982345905795`*^9, 
   3.8915982375483155`*^9}, {3.8915982698654947`*^9, 3.891598280908961*^9}, {
   3.891600400713317*^9, 3.891600403178166*^9}, {3.891600440681151*^9, 
   3.891600448586243*^9}, {3.891600855326527*^9, 3.891600891831215*^9}, {
   3.8916009807497854`*^9, 3.891601013520027*^9}, {3.8916011235296307`*^9, 
   3.891601184594534*^9}},
 ExpressionUUID -> "faea7044-d2c1-49ca-8864-ff29d32a1e82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{"results", ",", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "4", "]"}], "]"}], "&"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<success rate\>\"", ",", "\"\<error rate exp\>\"", ",", 
        "\"\<error rate Theory\>\"", ",", "\"\<errExp/errTeo\>\"", ",", " ", 
        "\"\<distance std\>\"", ",", " ", "\"\<\[Sigma] success rate\>\"", 
        ",", " ", "\"\<\[Sigma] error rate exp\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.891597840129529*^9, 3.891597841091592*^9}, {
   3.891597894369629*^9, 3.8915978972560806`*^9}, {3.89159808331686*^9, 
   3.891598086883748*^9}, {3.8915981457505426`*^9, 3.8915981866247416`*^9}, 
   3.891598300195224*^9, {3.891600329395946*^9, 3.8916003562790375`*^9}},
 ExpressionUUID -> "3d1a9564-0b32-47c1-ae95-26ba3655d0ff"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"success rate\"\>",
       HoldForm], 
      TagBox["\<\"error rate exp\"\>",
       HoldForm], 
      TagBox["\<\"error rate Theory\"\>",
       HoldForm], 
      TagBox["\<\"errExp/errTeo\"\>",
       HoldForm], 
      TagBox["\<\"distance std\"\>",
       HoldForm], 
      TagBox["\<\"\[Sigma] success rate\"\>",
       HoldForm], 
      TagBox["\<\"\[Sigma] error rate exp\"\>",
       HoldForm]},
     {"0.000017967516014016228`", "2.925730139554817`*^-8", 
      "4.177131818217106`*^-8", "0.7004160430837408`", "11.521077712149406`", 
      "2.0049594805283918`*^-7", "1.086184565305587`*^-9"},
     {"0.000014556961108945748`", "2.414187385594918`*^-8", 
      "2.7455535456244462`*^-8", "0.8793080686560922`", "3.384378768698876`", 
      "1.6306305820029612`*^-7", "9.791048303878876`*^-10"},
     {"0.00001152259253703916`", "1.8952843042399128`*^-8", 
      "1.719451897530533`*^-8", "1.102260730272193`", "2.0429715840053535`", 
      "1.297559177161065`*^-7", "8.606698599529771`*^-10"},
     {"8.845641463438942`*^-6", "1.4426241694408657`*^-8", 
      "1.0135056238702589`*^-8", "1.4234002609003176`", "5.755077023161598`", 
      "1.003671415844876`*^-7", "7.456347566567703`*^-10"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     None, {"success rate", "error rate exp", "error rate Theory", 
       "errExp/errTeo", "distance std", "\[Sigma] success rate", 
       "\[Sigma] error rate exp"}}]]]], "Output",
 CellChangeTimes->{3.9684844844960766`*^9, 3.9684855225530233`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ATdata", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\\
rawdata\\\\FullTransmissionData.dat\>\"", ",", "\"\<Data\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ATdata", " ", "=", " ", 
   RowBox[{"Drop", "[", 
    RowBox[{"ATdata", ",", " ", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", " ", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{
     RowBox[{"Length", "[", "ATdata", "]"}], "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AT", " ", "=", " ", 
     RowBox[{
      RowBox[{"ATdata", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "100."}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"succmax", " ", "=", " ", "0.000017967516014016228`"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"errormax", " ", "=", "2.925730139554817`*^-8"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Tsetup", " ", "=", " ", "0.424"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Tdet", " ", "=", " ", "0.5"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Tcoupling", " ", "=", " ", "0.6919683881639405"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]Tcoupling", " ", "=", " ", "0.002182593342891458"}], ";",
     "\[IndentingNewLine]", 
    RowBox[{"T1", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"0.5195725089060644", "*", "0.513736362870924"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]T1", " ", "=", " ", "0.00025629615047562267"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"T2", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"0.5788552646262161", "*", "0.5713013418201311"}], "]"}]}], ";",
     "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]T2", " ", "=", " ", "0.00034834174650329576"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"T", "=", 
     RowBox[{"Tsetup", "*", "Tdet", "*", "Tcoupling", "*", "AT"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]T", " ", "=", " ", 
     RowBox[{"0.0033658233299105156", "*", "AT"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"criterion", " ", "=", " ", 
     RowBox[{"MapIndexed", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#1", ",", 
          RowBox[{"getPe", "[", 
           RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}], ",", " ", 
          RowBox[{
           RowBox[{"getPe", "[", 
            RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"getPe", "[", 
               RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}], "-", 
              RowBox[{"getPe", "[", 
               RowBox[{
                RowBox[{"T1", "+", 
                 RowBox[{"3", "*", "\[Sigma]T1"}]}], ",", 
                RowBox[{"T2", "+", 
                 RowBox[{"3", "*", "\[Sigma]T2"}]}], ",", 
                RowBox[{"T", "+", 
                 RowBox[{"3", "*", "\[Sigma]T"}]}], ",", "#1"}], "]"}]}], 
             ")"}], "/", "3"}]}], ",", " ", 
          RowBox[{
           RowBox[{"getPe", "[", 
            RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"getPe", "[", 
               RowBox[{
                RowBox[{"T1", "-", 
                 RowBox[{"3", "*", "\[Sigma]T1"}]}], ",", 
                RowBox[{"T2", "-", 
                 RowBox[{"3", "*", "\[Sigma]T2"}]}], ",", 
                RowBox[{"T", "-", 
                 RowBox[{"3", "*", "\[Sigma]T"}]}], ",", "#1"}], "]"}], "-", 
              RowBox[{"getPe", "[", 
               RowBox[{"T1", ",", "T2", ",", "T", ",", "#1"}], "]"}]}], ")"}],
             "/", "3"}]}]}], "}"}], "&"}], ",", 
       RowBox[{
        RowBox[{"10", "^", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"-", "2.4"}], ",", "1", ",", "0.01"}], "]"}]}], "*", 
        "succmax"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\\
Codes\\\\CodeOutput\\\\result\>\"", ",", 
         RowBox[{"ToString", "[", "AT", "]"}], ",", "\"\<.dat\>\""}], "}"}], 
       "]"}], ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
          "\"\<success\>\"", ",", " ", "\"\<bound\>\"", ",", " ", 
           "\"\<lowerbound\>\"", ",", " ", "\"\<upperbound\>\""}], "}"}], 
         "}"}], ",", "criterion"}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"results", " ", "=", " ", 
     RowBox[{"MapIndexed", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"drivingrate", "*", "intT"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{"#", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], ",", 
          RowBox[{"getPe", "[", 
           RowBox[{"T1", ",", "T2", ",", "T", ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "/", 
           RowBox[{"getPe", "[", 
            RowBox[{"T1", ",", "T2", ",", "T", ",", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "/", 
              RowBox[{"(", 
               RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}]}], " ", 
          ",", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "+", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "-", 
              RowBox[{"getPe", "[", 
               RowBox[{"T1", ",", "T2", ",", "T", ",", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"drivingrate", "*", "intT"}], ")"}]}]}], "]"}]}], 
             ")"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "+", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "*", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"intT", "*", "2"}], ")"}]}], "*", "intT", "*", 
                  "2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}],
               "]"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"drivingrate", "*", "1200"}], ")"}]}], ")"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"drivingrate", "*", "1200"}], ")"}]}], ")"}], "*", 
                "drivingrate", "*", "1200"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
            "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"intT", "*", "2", "*", "drivingrate"}], ")"}]}], 
                "*", "drivingrate", "*", "1200", "*", "2"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"\[Sigma]blink", "/", "blink"}], ")"}], "^", "2"}]}], 
            "]"}]}]}], "  ", "}"}], "&"}], ",", "ATdata"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\\
Codes\\\\CodeOutput\\\\result\>\"", ",", 
         RowBox[{"ToString", "[", "AT", "]"}], ",", "\"\<.dat\>\""}], "}"}], 
       "]"}], ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Simulated Transmission\>\"", ",", "\"\<success rate\>\"", ",", 
           "\"\<error rate exp\>\"", ",", "\"\<error rate Theory\>\"", ",", 
           "\"\<errExp/errTeo\>\"", ",", " ", "\"\<distance std\>\"", ",", 
           " ", "\"\<\[Sigma] success rate\>\"", ",", " ", 
           "\"\<\[Sigma] error rate exp\>\""}], "}"}], "}"}], ",", 
        "results"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"clear", "[", 
     RowBox[{"T1", ",", "T2", ",", "T"}], "]"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.891655762401358*^9, 3.891655775673006*^9}, {
   3.891660047810161*^9, 3.891660077138191*^9}, {3.8916702779475203`*^9, 
   3.8916703602132473`*^9}, 3.8921978220782394`*^9, {3.892197866201339*^9, 
   3.8921979332369685`*^9}, {3.8921979659641385`*^9, 3.892198006988347*^9}, {
   3.89219803776633*^9, 3.8921981091377563`*^9}, {3.892198151357642*^9, 
   3.8921981592113476`*^9}, {3.892198214969577*^9, 3.892198283418741*^9}, {
   3.8921983194077387`*^9, 3.892198319661807*^9}, {3.89219841415194*^9, 
   3.8921985329769955`*^9}, {3.892198572855562*^9, 3.892198589707588*^9}, 
   3.8921986548546915`*^9, {3.892198745289319*^9, 3.89219881046729*^9}, {
   3.8921988667627764`*^9, 3.8921988692009554`*^9}, {3.8921990096994143`*^9, 
   3.892199066726507*^9}, {3.8921991238135386`*^9, 3.892199183094492*^9}, 
   3.8922048073001757`*^9, {3.892785325434939*^9, 3.8927853415550394`*^9}, {
   3.892785447232348*^9, 3.8927854634958057`*^9}, {3.8927855744689436`*^9, 
   3.8927855798182564`*^9}, {3.892795546222766*^9, 3.8927955468780537`*^9}, {
   3.8927956036849003`*^9, 3.8927956053993516`*^9}, {3.892795994095765*^9, 
   3.892795994258569*^9}, {3.9684840625288897`*^9, 3.968484066729847*^9}, 
   3.9684841877461386`*^9, 3.9684856048341684`*^9, {3.9684857576727095`*^9, 
   3.9684857838907356`*^9}, {3.9684858219801984`*^9, 3.9684858298711276`*^9}},
 ExpressionUUID -> "897f0bf3-6b85-4ce9-88d8-b719d75da0d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ATdata", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<D:\\\\Checchinato\\\\NonGaussianity\\\\DATA_NONGAUSSIANITY\\\\\
rawdata\\\\FullTransmissionData.dat\>\"", ",", "\"\<Data\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.892198729787794*^9, 3.8921987299729023`*^9}, 
   3.8922016179884624`*^9, {3.8927853129981475`*^9, 3.8927853154369593`*^9}, {
   3.8927853479758153`*^9, 3.8927853556314025`*^9}, {3.8927853977180805`*^9, 
   3.8927854392224407`*^9}, {3.892785514199897*^9, 3.8927855594728537`*^9}, {
   3.8927974791658134`*^9, 3.8927974887110357`*^9}, {3.8928105702818565`*^9, 
   3.8928105809377327`*^9}, 3.9684858550223145`*^9},
 ExpressionUUID -> "5f0ca1a5-265c-4407-8c1a-76639bdebf80"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "ATdata"}]], "Input",
 CellChangeTimes->{{3.8928105838146534`*^9, 3.8928106113281856`*^9}, {
  3.8928106700358915`*^9, 3.8928107053991284`*^9}, {3.8928919461885185`*^9, 
  3.8928919517683015`*^9}},
 ExpressionUUID -> "a184ef0d-863a-462f-9cfc-924dfea3130c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"successes\"\>", ",", "\<\"errors_X\"\>", 
     ",", "\<\"errors_XX\"\>", ",", "\<\"AT\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"244113", ",", "365", ",", "430", ",", "100.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"234322", ",", "352", ",", "415", ",", "98.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"224918", ",", "337", ",", "396", ",", "96.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"215592", ",", "327", ",", "388", ",", "94.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"206938", ",", "316", ",", "367", ",", "92.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"197776", ",", "308", ",", "348", ",", "90.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"188775", ",", "292", ",", "333", ",", "88.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180560", ",", "259", ",", "339", ",", "86.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"172554", ",", "269", ",", "299", ",", "84.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"164060", ",", "262", ",", "296", ",", "82.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156550", ",", "240", ",", "275", ",", "80.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148396", ",", "241", ",", "260", ",", "78.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"141378", ",", "217", ",", "242", ",", "76.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"133534", ",", "214", ",", "243", ",", "74.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"126481", ",", "187", ",", "224", ",", "72.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"120180", ",", "180", ",", "212", ",", "70.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"112748", ",", "169", ",", "187", ",", "68.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"106080", ",", "154", ",", "196", ",", "66.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99990", ",", "150", ",", "187", ",", "64.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93930", ",", "145", ",", "158", ",", "62.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87898", ",", "133", ",", "151", ",", "60.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"82233", ",", "130", ",", "139", ",", "58.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76609", ",", "111", ",", "129", ",", "56.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"71387", ",", "112", ",", "134", ",", "54.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"65725", ",", "89", ",", "120", ",", "52.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60982", ",", "90", ",", "107", ",", "50.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56100", ",", "94", ",", "100", ",", "48.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51747", ",", "78", ",", "93", ",", "46.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47304", ",", "72", ",", "83", ",", "44.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42996", ",", "84", ",", "85", ",", "42.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38786", ",", "59", ",", "74", ",", "40.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35415", ",", "51", ",", "63", ",", "38.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31503", ",", "43", ",", "54", ",", "36.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28222", ",", "41", ",", "55", ",", "34.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25166", ",", "43", ",", "42", ",", "32.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22098", ",", "34", ",", "63", ",", "30.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18941", ",", "25", ",", "36", ",", "28.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16586", ",", "22", ",", "36", ",", "26.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14126", ",", "15", ",", "35", ",", "24.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11712", ",", "19", ",", "18", ",", "22.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9624", ",", "13", ",", "16", ",", "20.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7776", ",", "22", ",", "9", ",", "18.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6217", ",", "8", ",", "18", ",", "16.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4835", ",", "6", ",", "9", ",", "14.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3498", ",", "7", ",", "6", ",", "12.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2417", ",", "6", ",", "3", ",", "10.`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.968485976595244*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{958, 981},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
Magnification:>1.3 Inherited,
FrontEndVersion->"10.3 for Microsoft Windows (64-bit) (October 9, 2015)",
StyleDefinitions->"Default.nb",
ExpressionUUID -> "3c798248-cb8e-47b0-9cc5-f80874567edf"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 205, 4, 91, "Section"],
Cell[788, 28, 4009, 104, 457, "Input"],
Cell[CellGroupData[{
Cell[4822, 136, 247, 4, 37, "Item"],
Cell[5072, 142, 268, 6, 37, "Item"],
Cell[5343, 150, 399, 13, 37, "Item"],
Cell[5745, 165, 377, 13, 37, "Item"],
Cell[6125, 180, 639, 18, 61, "Item"],
Cell[6767, 200, 480, 9, 59, "Item"],
Cell[7250, 211, 382, 6, 37, "Item"]
}, Open  ]],
Cell[7647, 220, 1134, 23, 190, "Input"],
Cell[CellGroupData[{
Cell[8806, 247, 785, 19, 90, "Input"],
Cell[9594, 268, 2794, 83, 190, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12425, 356, 3814, 103, 540, "Input"],
Cell[16242, 461, 1723, 42, 440, "Output"]
}, Open  ]],
Cell[17980, 506, 893, 18, 115, "Input"],
Cell[CellGroupData[{
Cell[18898, 528, 600, 13, 140, "Input"],
Cell[19501, 543, 93, 1, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19631, 549, 1331, 34, 165, "Input"],
Cell[20965, 585, 92, 1, 41, "Output"],
Cell[21060, 588, 92, 1, 41, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21201, 595, 157, 3, 91, "Section"],
Cell[21361, 600, 10525, 239, 990, "Input"],
Cell[CellGroupData[{
Cell[31911, 843, 904, 21, 140, "Input"],
Cell[32818, 866, 42998, 717, 5746, "Output"]
}, Open  ]],
Cell[75831, 1586, 129, 3, 39, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75997, 1594, 170, 3, 91, "Section"],
Cell[CellGroupData[{
Cell[76192, 1601, 580, 11, 37, "Item"],
Cell[76775, 1614, 539, 9, 37, "Item"],
Cell[77317, 1625, 527, 8, 37, "Item"],
Cell[77847, 1635, 410, 7, 37, "Item"],
Cell[78260, 1644, 432, 7, 37, "Item"],
Cell[78695, 1653, 432, 7, 37, "Item"],
Cell[79130, 1662, 477, 8, 37, "Item"],
Cell[79610, 1672, 659, 10, 37, "Item"],
Cell[80272, 1684, 784, 14, 37, "Item"]
}, Open  ]],
Cell[81071, 1701, 2829, 60, 290, "Input"],
Cell[83903, 1763, 2397, 54, 290, "Input"],
Cell[86303, 1819, 1191, 27, 290, "Input"],
Cell[CellGroupData[{
Cell[87519, 1850, 1602, 30, 190, "Input"],
Cell[89124, 1882, 141, 2, 41, "Output"],
Cell[89268, 1886, 140, 2, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89445, 1893, 3236, 74, 215, "Input"],
Cell[92684, 1969, 142, 2, 39, "Output"],
Cell[92829, 1973, 140, 2, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93006, 1980, 1543, 34, 140, "Input"],
Cell[94552, 2016, 145, 2, 41, "Output"],
Cell[94700, 2020, 144, 2, 41, "Output"]
}, Open  ]],
Cell[94859, 2025, 6035, 154, 640, "Input"],
Cell[CellGroupData[{
Cell[100919, 2183, 1694, 36, 115, "Input"],
Cell[102616, 2221, 12145, 215, 440, "Output"]
}, Open  ]],
Cell[114776, 2439, 1285, 26, 240, "Input"],
Cell[116064, 2467, 6452, 169, 440, "Input"],
Cell[CellGroupData[{
Cell[122541, 2640, 996, 22, 115, "Input"],
Cell[123540, 2664, 2204, 52, 158, "Output"]
}, Open  ]],
Cell[125759, 2719, 13002, 312, 1390, "Input"],
Cell[138764, 3033, 749, 14, 90, "Input"],
Cell[CellGroupData[{
Cell[139538, 3051, 302, 5, 65, "Input"],
Cell[139843, 3058, 4343, 99, 415, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

