(governance)=
# Project Governance

The purpose of this document is to formalize the governance process used
by the Human Neocortical Neurosolver (HNN) project and to clarify how
decisions are made and how the various elements of our community
interact.

## Mission

HNN is an open source software project. The goal of HNN is to develop a
hypothesis testing tool for researchers, with the software built upon a
biophysically-principled neocortical circuit model with appropriate
physics that allow bridging from macroscale human magneto- and
electro-encephalography (M/EEG) signals to their cellular and circuit
level generators.

The foundations of the project governance are:

-   Openness and transparency
-   Active contribution
-   Institutional neutrality

The HNN project aims to support a collaborative community of developers,
where any individual may contribute to the project and have their
contributions acknowledged and reflected in the project's GitHub
repository. HNN is developed by researchers with diverse skill sets:
scientific, software, MEG, neuro etc. The governance model is made
keeping in mind that contributions from these diverse sub-communities
will be necessary to advance HNN.

We invite anyone with an interest in the project to join the community,
contribute to the project design, and participate in the decision making
process. In line with this philosophy, we provide a pathway for project
Contributors\* to become project Maintainers\*\*, allowing for a deeper
level of engagement with the development and decision making processes
of the project. We want to encourage a diverse array of backgrounds,
viewpoints, and talents in our team. Towards this end, contributions are
not limited to changes to the codebase, but can involve updates to the
documentation, proposals of biologically relevant features, and
participation in online discussions, among other activities that advance
the mission of the project.

## Roles and Responsibilities

We distinguish between Contributors, Maintainers, and the Steering
Council as outlined in the following sections.

### Contributors*
Contributors are community members who contribute in concrete ways to
the project. Anyone can become a contributor, and contributions can take
many forms, as detailed in HNN's Contributions page in the HNN-core
documentation. Contributors participate in the project by submitting,
reviewing, and discussing GitHub Pull Requests and Issues and by
participating in open discussions on GitHub and via other channels
including but not limited to the weekly project meetings, email, and
hackathon events. Contributors work on behalf of and are responsible to
the larger HNN Community, and we strive to keep the barrier between
Contributors and Users as low as possible.

### Maintainers**
Maintainers are community members who have shown that they are dedicated
to the continued development of the project through ongoing engagement
with the community. Being a Maintainer allows contributors to more
easily contribute to the project by giving them "commit rights" to the
project repositories. Maintainers are expected to review code
contributions, merge approved pull requests, and to be involved in
deciding major changes to the API. Maintainers are invited to join
weekly Develop Council meetings hosted virtually.

Maintainers are determined by the Steering Council based on their level
of engagement and their contributions to the project. Contributors who
have produced contributions that are substantial in quality and quantity
may be eligible for Maintainer status. Maintainers will be elected by
consensus among members of the Steering Council. Under extenuating
circumstances, Maintainer status may be revoked by the Steering Council
by consensus.

Maintainer status is dependent on continued engagement with the project.
If a Maintainer becomes inactive for a period greater than 1 year,
"commit rights" to the project's repository will be revoked. Maintainer
status can be reinstated for any Contributor if they resume engagement
with the project and produce substantial contributions.

### Developer Council

The Developer Council is composed of individuals who take on additional
responsibilities to ensure the smooth operation of the project.
Membership in the Developer Council is by nomination from a current
Developer Council member. The Developer Council will include at least 2
maintainers at all times. A nomination will result in discussion and
then a vote by the Developer Council members. Developer Council
membership votes are subject to a two-third majority.

The Developer Council and its members are expected to participate in
strategic planning to guide the overall direction of the project. While
the Developer Council is the final authority for guiding the code review
process and merging pull requests, not all Develop Council members need
to contribute code to the project on a regular basis. Members may be
nominated to the Developer Council based on the quality and quantity of
their contributions to any and all aspects of the project, including
their expertise and efforts in advancing the project mission as outlined
above.

Responsibilities of the Developer Council include:

-   Attend virtual meetings on a regular basis or as deemed appropriate
-   Make decisions about the overall scope, vision, and direction of the
    project.
-   Make decisions about strategic collaborations with other
    organizations or individuals.
-   Make decisions about specific technical issues, features, bugs, and
    pull requests when appropriate
-   Make decisions about the services that are run by the project and
    manage those services for the benefit of the community
-   Update policy documents, such the Project Governance

If a member becomes inactive in the project for a period of one year,
they will be considered for removal from the Developer Council. Before
removal, the inactive member will be approached to inquire if they plan
to return to active participation. If not, they will be removed upon a
Developer Council vote. If the inactive member plans on returning to
active participation, they can be granted a grace period as determined
by the Developer Council. All former Developer Council Members can be
considered for membership again at any time in the future. Retired
Developer Council Members will be listed on the project website.

## Decision-Making Process

Decisions related to the project are made through consensus among the
Maintainers and the Developer Council, with input from the community and
Contributors. Final authority over key decisions related to the overall
scope, vision, and direction of the project lies solely with the
Developer Council. For contributions to the project repositories, HNN
uses a "consensus-seeking" process for making decisions. Any
contributions must follow the processes outlined in the Contributions
page of the HNN-core documentation.

As outlined in Roles and Responsibilities, the merging of GitHub Pull
Requests is under the purview of Maintainers. For minor changes (i.e.,
typo fixes or the addition / correction of sentences in the
Documentation), a single Maintainer may approve a Pull Request if
they're confident others would agree. For any changes that are not minor
(i.e., code changes, major Documentation changes), approval from at
least two Maintainers is needed before a Pull Request is merged.
Contributors work with the maintainers to resolve comments on a Pull
Request. A pull request can be merged when there are no remaining
objections among the Maintainers. In cases where a resolution cannot be
easily reached, the pull request is tabled for further discussion at the
Strategic Planning meeting and a determination is made by consensus
amongst the Council members and maintainers.

Virtual "Strategic Planning Meetings" are held weekly between the
Steering Council and the Maintainers to facilitate discussion and to
provide guidance on specific decisions related to the project. Any Pull
Requests that do not reach consensus on GitHub are to be raised at the
Strategic Planning meetings so that the Developer Council members can
arrive at a consensus on the direction that should be taken. Strategic
Planning Meetings also provide an opportunity for Maintainers and
Developer Council members to share updates, discuss future directions,
and address logistic matters related to the project. Decisions on any
and all matters raised at the Strategic Planning Meetings follow the
consensus-seeking approach outlined above.

## Governance Model Changes

The Project Governance document will be reviewed at least once yearly by
the Developer Council. Changes will be made to the document by majority
vote of the Developer Council. The document may also be revisited and
updated at any time between yearly reviews as deemed necessary by the
Developer Council. Contributors and Maintainers may recommend changes to
the document by opening a Draft Pull Request at any time. Any suggested
changes will be reviewed and voted upon by the Council.
