# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
from sphinx_gallery.sorting import ExampleTitleSortKey, ExplicitOrder

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
curdir = os.path.dirname(__file__)
sys.path.append(os.path.abspath(os.path.join(curdir, '..', 'hnn_core')))
sys.path.append(os.path.abspath(os.path.join(curdir, '..')))
sys.path.append(os.path.abspath(os.path.join(curdir, 'sphinxext')))

# -- Project information -----------------------------------------------------

project = 'hnn-core'
copyright = '2025, HNN Developers'
author = 'HNN Developers'

# -- Version handling --------------------------------------------------------

# The short X.Y version
version = '0.4.3'
# The full version, including alpha/beta/rc tags
release = '0.4.3'

### HTML theme version control
# If you are making a stable release, then you should add entries to the file
# located in `doc/_static/versions.json`. Once your PR with that change is
# merged, that file will be pushed to the following URL. Unfortunately our
# theme system wants a public URL, NOT a local file for this version control.
json_versions_url = "https://jonescompneurolab.github.io/hnn-core/dev/_static/versions.json"
if (("rc" in version) or ("dev" in version)):
    switcher_version_match = "dev"
else:
    switcher_version_match = version

### Binder version control
# Resolve binder variable `filepath_prefix` to go in `sphinx_gallery_conf`
# below. From the docs:
#   "A prefix to append to the filepath in the Binder links. You should use this
#    if you will store your built documentation in a sub-folder of a repository,
#    instead of in the root."
# We will store dev docs in a `dev` subdirectory and all other docs in a
# directory "v" + version_str. E.g., "v0.3"
if (("rc" in version) or ("dev" in version)):
    filepath_prefix = 'dev'
else:
    filepath_prefix = 'v{}'.format(version)

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'gh_substitutions',  # custom extension, see ./sphinxext/gh_substitutions.py
    'myst_parser',
    'numpydoc',
    'sphinx_gallery.gen_gallery',
    'sphinx.ext.viewcode',
    'sphinx.ext.autosummary',
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx_copybutton',
]

# generate autosummary even if no references
autosummary_generate = True
autodoc_default_options = {'inherited-members': None}
numpydoc_class_members_toctree = False
numpydoc_attributes_as_param_list = True
default_role = 'autolink'  # XXX silently allows bad syntax, someone should fix

# Sphinx-Copybutton configuration
copybutton_prompt_text = r">>> |\.\.\. |\$ "
copybutton_prompt_is_regexp = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a dict:
source_suffix = {
    '.rst': 'restructuredtext',
    '.md': 'markdown',
}

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store', 'gui/index.rst']

# -- Options for HTML output -------------------------------------------------

html_theme = "pydata_sphinx_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation:
# https://pydata-sphinx-theme.readthedocs.io/en/stable/index.html
html_theme_options = {
    "external_links": [
        {
            "url": "https://github.com/jonescompneurolab/hnn-core",
            "name": "GitHub (Code)",
        },
        {
            "url": "https://hnn.brown.edu/",
            "name": "HNN Frontpage",
        },
        {
            "url": "https://jonescompneurolab.github.io/textbook/content/preface.html",
            "name": "HNN Textbook",
        },
        {
            "url": "https://pypi.org/project/hnn-core/",
            "name": "PyPI package",
        },
        {
            "url": "https://anaconda.org/jonescompneurolab/repo",
            "name": "Conda packages",
        },
    ],
    "header_links_before_dropdown": 7,
    "navbar_align": "left",
    "navbar_start": ["navbar-logo"],
    "navbar_center": ["navbar-nav"],
    "navbar_end": ["version-switcher"],
    "pygments_dark_style": "monokai",
    "switcher": {
        "json_url": json_versions_url,
        "version_match": switcher_version_match,
    },
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css". This
# folder also holds versions.json.
html_static_path = ["_static"]
html_logo = "_static/hnn-medium.png"

# The default sidebars (for documents that don't match any pattern) are defined
# by theme itself.  Builtin themes are using these templates by default:
# ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``. Not that the following removes the "primary" sidebar (on
# the left), but not the "secondary" # sidebar (on the right), for the PyData
# theme. From
# https://pydata-sphinx-theme.readthedocs.io/en/latest/user_guide/layout.html#remove-the-primary-sidebar-from-pages
html_sidebars = {
    "**": []
}

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'hnn-coredoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'hnn-core.tex', 'hnn-core Documentation',
     'Mainak Jas', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'hnn-core', 'hnn-core Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'hnn-core', 'hnn-core Documentation',
     author, 'hnn-core', 'One line description of project.',
     'Miscellaneous'),
]

intersphinx_mapping = {
    'python': ('https://docs.python.org/3', None),
    'mne': ('https://mne.tools/dev', None),
    'numpy': ('https://numpy.org/devdocs', None),
    'scipy': ('https://scipy.github.io/devdocs', None),
    'matplotlib': ('https://matplotlib.org', None)
}
intersphinx_timeout = 5

linkcheck_anchors = False

linkcheck_ignore = [
    'https://neuron.yale.edu/neuron',
    'https://doi.org/10.1152/jn.00535.2009',
    'https://doi.org/10.1152/jn.00122.2010',
    'https://doi.org/10.1101/2021.04.16.440210',
    'https://doi.org/10.7554/eLife.51214',
    'https://groups.google.com/g/hnnsolver',
    r'(http|https):\/\/localhost:\d+',
    r'(http|https):\/\/github\.com\/jonescompneurolab\/hnn-core\/(issues|pull)\/\d+',
]

sphinx_gallery_conf = {
    'first_notebook_cell': ("import pyvista as pv\n"
                            "from mne.viz import set_3d_backend\n"
                            "set_3d_backend('notebook')\n"
                            "pv.set_jupyter_backend('client')"
                            ),
    'doc_module': 'hnn_core',
    # path to your examples scripts
    'examples_dirs': '../examples',
    # path where to save gallery generated examples
    'gallery_dirs': 'auto_examples',
    'backreferences_dir': 'generated',
    'reference_url': {
        'hnn_core': None
    },
    'within_subsection_order': ExampleTitleSortKey,
    'subsection_order': ExplicitOrder(['../examples/workflows/',
                                       '../examples/howto/']),
    'binder': {'org': 'jonescompneurolab',
               'repo': 'hnn-core',
               'branch': 'gh-pages',
               'binderhub_url': 'https://mybinder.org',
               'filepath_prefix': filepath_prefix,
               'notebooks_dir': 'notebooks',
               'dependencies': 'Dockerfile'
               }
}
