# Roman Stone Artefact Catalogue (Dolenjska/Bela Krajina) — Dataset README

This repository contains the dataset **Data_EN.xlsx**, documenting Roman stone artefacts, findspots, lithotypes, and related metadata for the Emona–Siscia corridor (Slovenia). It accompanies the Geosciences manuscript by *Edisa Lozić* and provides tabular data suitable for reproducibility, re-use, and meta-analyses.

## Files
- `Data_EN.xlsx` — Main dataset (Excel workbook) with 2 sheet(s): Data_EN, Sheet1.
- `CODEBOOK.csv` — Machine-readable schema summary of all sheets/columns.
- `CODEBOOK.md` — Human-readable codebook with column types, non-null counts, unique values, and example values.

## Quick Start
1. Open `Data_EN.xlsx` and review the sheets listed above.
2. Consult `CODEBOOK.md` for field meanings and expected types.
3. When citing, use the provided **citation string** and include the version/DOI (if deposited on Zenodo).

## Recommended Citation
Lozić, E. Roman Stone Artefact Catalogue for Dolenjska and Bela Krajina; v1.0. Zenodo, 2025. DOI: 10.5281/zenodo.XXXXXXX

## Suggested Data Availability Statement
All data supporting the findings of this study are provided in `Data_EN.xlsx`; a versioned snapshot is archived at Zenodo under DOI: 10.5281/zenodo.XXXXXXX. The live catalogue interface is available at https://arkas.caspio.app/genii-flex/public/catalogue-en (accessed on 5 October 2025).

## License
Recommended: **CC BY 4.0** (Creative Commons Attribution 4.0 International), permitting sharing and adaptation with attribution. Adjust if institutional policy requires a different license.

## Provenance & Method Notes
- Source curation: in-situ and museum observations; integration with LiDAR/GIS analyses within the Emona–Siscia corridor.
- Key fields across sheets include (subset): ID | UEL | Type of object | Site | Lng (x) | Lat (y) | Location | Inv.no. | no.geol. Analysis | material | Litotype | length (cm) | width (cm) | thickness (cm) | high (cm) | diameter | sample | Thin section | Production date | Date (century) | Description | Bibliography | Inscription | Notes. See `CODEBOOK.md` for the full list.
- Coordinate Reference System (if coordinates present): please specify CRS (e.g., EPSG:3912 or EPSG:4326 WGS84) in this README or the manuscript.

## Versioning
Publish on Zenodo as versioned snapshots: v1.0, v1.1, etc. Zenodo provides a **concept DOI** (all versions) and a **version DOI** (each snapshot).

## Contact
**Corresponding author:** Edisa Lozić — edisa.lozic@zrc-sazu.si