# Tutorials

We provide step-by-step guides to get you started. We cover the following use-cases:

### Base tutorials

<!-- --8<-- [start:classic-tutorials] -->

=== card {: href=/tutorials/spacy101 }

    :fontawesome-regular-file-code:
    **Spacy representations**

    ---
    Learn the basics of how documents are represented with spaCy.

=== card {: href=/tutorials/matching-a-terminology }

    :fontawesome-solid-book:
    **Matching a terminology**

    ---
    Extract phrases that belong to a given terminology.

=== card {: href=/tutorials/qualifying-entities }

    :fontawesome-regular-square-check:
    **Qualifying entities**

    ---
    Ensure extracted concepts are not invalidated by linguistic modulation.

=== card {: href=/tutorials/detecting-dates }

    :fontawesome-regular-calendar:
    **Detecting dates**

    ---
    Detect and parse dates in a text.

=== card {: href=/tutorials/multiple-texts }

    :fontawesome-regular-copy:
    **Processing multiple texts**

    ---
    Improve the inference speed of your pipeline

=== card {: href=/tutorials/hpc }

    :fontawesome-solid-microchip:
    **Running on HPC (eg. Slurm)**

    ---
    Use an existing model at scale with an High-Performance Computing (HPC) job scheduler like Slurm.

=== card {: href=/tutorials/reason }

    :fontawesome-regular-hospital:
    **Detecting hospitalisation reason**

    ---
    Identify spans mentioning the reason for hospitalisation or tag entities as the reason.

=== card {: href=/tutorials/endlines }

    ↵ **Detecting false endlines**

    ---
    Classify each line end and add the `excluded` attribute to these tokens.

=== card {: href=/tutorials/aggregating-results }

    :fontawesome-solid-calculator:
    **Aggregating results**

    ---
    Aggregate the results of your pipeline at the document level.

=== card {: href=/advanced-tutorials/fastapi }

    :fontawesome-solid-server:
    **FastAPI**

    ---
    Deploy your pipeline as an API.

=== card {: href=/tutorials/visualization }

    :fontawesome-solid-eye:
    **Visualization**

    ---
    Quickly visualize the results of your pipeline as annotations or tables.

<!-- --8<-- [end:classic-tutorials] -->

### Deep learning tutorials

We also provide tutorials on how to train deep-learning models with EDS-NLP. These tutorials cover the training API, hyperparameter tuning, and more.

<!-- --8<-- [start:deep-learning-tutorials] -->

=== card {: href=/tutorials/make-a-training-script }

    :fontawesome-solid-flask:
    **Writing a training script**

    ---
    Learn how EDS-NLP handles training deep-neural networks, and how to write a training script on your own.

=== card {: href=/tutorials/training-ner }

    :fontawesome-solid-highlighter:
    **Training a NER model**

    ---
    Learn how to quickly train a NER model with `edsnlp.train`.

=== card {: href=/tutorials/training-span-classifier }

    :fontawesome-solid-circle-check:
    **Training a Span Classifier model**

    ---
    Learn how to quickly train a biopsy date classifier model model with `edsnlp.train`.

=== card {: href=/tutorials/tuning }

    :fontawesome-solid-gears:
    **Hyperparameter Tuning**

    ---
    Learn how to tune hyperparameters of a model with `edsnlp.tune`.


<!-- --8<-- [end:deep-learning-tutorials] -->


<!-- --8<-- [end:tutorials] -->
