
########################################
# RMSD and infit: simulation study
########################################


library(CDM)
library(miceadds)
library(TAM)
library(sirt)


comp <- "1001"
pf00 <- "p:/Eigene_Projekte/IRT/RMSD_Infit/"


# simulation number
sim <- "102"

# path
pfo <- file.path( paste0( pf00 , "Simulation" , sim ), "1__Durchfuehrung" ) 
pf14 <- paste0( pf00 , "Simulation" , sim )


dir.create(pfo)
files_move(path1=pfo)
files_move(pf14)




comp_index <- strsplit( systime()[8], split=".", fixed=TRUE)[[1]][1]
comp_index <- paste0( "sim", sim, "_C" , comp , "_", comp_index )


pf11 <- file.path( pfo , "Outputs" )
dir.create(pf11)

pf1 <- file.path( pfo , "Outputs" , comp_index )
dir.create(pf1)


# powers

des_list <- list( 
    N=c(250,500,1000,2000,4000),  # sample size
    I=c(50),
    sel=1:5,
    dif=c( c(.3,.6,.9), -1*c(.3,.6,.9) )
       )

design <- expand.grid(des_list)




# eliminations

design_elim <- function(design, elim)
{
    if (length(elim)>0){ design <- design[ - elim , ] }
    return(design)
}



rownames(design) <- NULL
ND <- nrow(design)


##***********
##*** define item parameters
I0 <- 10
pars <- data.frame(item=1:I0, a=1, b=2*seq(-1,1,len=I0) )
pars <- pars[ rep(1:I0,50), ]



#*** read syntax
pfR <- file.path( pf00 , "R-Code" )
files_move(pfR)
source.all( pfR )


BMax <- 100
bb <- 1

des_order <- 1:ND


des_order <- seq(ND, 1, -1)


write.csv2( design , file.path( pf1 ,"_DESIGN.csv" ) )



#---------------------- start simulation --------------------

for (bb in 1:BMax){

for (dd in des_order){


filename <- strsplit(systime()[7], split=".", fixed=TRUE)[[1]][1]
filename <- paste0( comp_index, "__", filename , "_DES" , dd , "_REPL" , bb )
vars <- colnames(design)

for (vv in vars){
    Revalpr( paste0( vv , " <- design[dd,'", vv, "']") )
}
design_dd <- data.frame(desid=dd, design[dd,] )


#*****************************
#*** simulate data

pars1 <- pars[ 1:I, ]
pars1$b0 <- pars1$b


pars1[ sel, "b" ] <- pars1[ sel, "b" ] + dif
pars1[ I0+1-sel, "b" ] <- pars1[ I0+1-sel, "b" ] - dif


mu <- 0
sigma <- 1

dat <- NULL

try_sim <- TRUE

while( try_sim){

a <- pars1$a
b <- pars1$b
dat <- sirt::sim.raschtype( rnorm(N, mean=mu, sd=sigma), fixed.a=a, b=b )

cm <- colMeans(dat)
try_sim <- ! (  (min(cm)>0)&(max(cm)<1) )

}

# save example datasets
#save.data( dat , paste0("DATA_DES",dd ) , type="Rdata" , path= pf1)
save.data( dat , paste0("DATA_DES",dd ) , type="csv2" , path= pf1)


dfr <- NULL


nodes <- 6*seq(-1,1, len=61)

ISEL <- 1:10

dfr0 <- data.frame( design_dd, item=ISEL, b=pars1$b0[ISEL] )
dfr0$is_dif <- 1*(dfr0$item == sel)

#- estimate model
xsi.fixed <- cbind( 1:I, pars1$b0 )

mod <- TAM::tam.mml(dat, xsi.fixed=xsi.fixed, control=list(nodes=nodes) )


# compute different RMSD variants
res <- wrmsd(mod)

dfr1 <- dfr0
dd <- "dist"

for (dd in c("dist", "unif","b","info")){ 
    dfr1$stat <- stat <- paste0("rmsd_", dd)
    dfr1[,"est"] <- res[[ stat ]][ISEL]
    dfr <- rbind( dfr, dfr1 )    
    dfr1$stat <- stat <- paste0("md_", dd)
    dfr1[,"est"] <- res[[ stat ]][ISEL]
    dfr <- rbind( dfr, dfr1 )
}


fmod <- TAM::msq.itemfit(mod)

dfr1$stat <- "Outfit"
dfr1[,"est"] <- fmod$itemfit$Outfit[ISEL]
dfr <- rbind( dfr, dfr1 )

dfr1$stat <- "Infit"
dfr1[,"est"] <- fmod$itemfit$Infit[ISEL]
dfr <- rbind( dfr, dfr1 )


dfr <- dfr[ order(dfr$item) , ]


save.data( dfr, filename , type="csv2" , path= pf1, suffix = "RESULTS")


}  # end dd
}  # end bb
