
wrmsd_compute <- function(wgt, probs_obs, probs_exp)
{
	wgt <- wgt/sum(wgt)
	I <- nrow(probs_obs)
	wgtM <- sirt::sirt_matrix2( wgt, nrow=I)
	res <- sqrt( rowSums( ( probs_obs - probs_exp )^2 * wgtM ) )
	return(res)
}


md_compute <- function(wgt, probs_obs, probs_exp)
{
  wgt <- wgt/sum(wgt)
  I <- nrow(probs_obs)
  wgtM <- sirt::sirt_matrix2( wgt, nrow=I)
  res <- rowSums( ( probs_obs - probs_exp ) * wgtM ) 
  return(res)
}


wrmsd <- function(mod)
{

	post <- mod$post
	resp <- mod$resp
	pweights <- mod$pweights
	dist <- colSums(post*pweights) / sum(pweights)

	pars <- mod$item_irt
	probs <- mod$rprobs
	I <- ncol(resp)

	wgt <- dist
	

	# model-implied IRF
	probs_exp <- probs[,2,]
	# observed IRF
	probs_obs <- 0*probs_exp
	for (ii in 1:I){
		ind <- 1-is.na(resp[,ii])
		probs_obs[ii,] <- colSums( resp[,ii]*post*pweights, na.rm=TRUE ) / colSums( post*pweights*ind )
	}

	# density-weighted RMSD
	rmsd_dist <- wrmsd_compute(wgt=dist, probs_obs=probs_obs, probs_exp=probs_exp)
	md_dist <- md_compute(wgt=dist, probs_obs=probs_obs, probs_exp=probs_exp)
	# uniformly weighted RMSD
	wgt <- 1*( abs(nodes) <= 4 )
	rmsd_unif <- wrmsd_compute(wgt=wgt, probs_obs=probs_obs, probs_exp=probs_exp)
	md_unif <- md_compute(wgt=wgt, probs_obs=probs_obs, probs_exp=probs_exp)	
	# b-weighted RMSD
	wgtM <- 0*probs_obs
	for (ii in 1:I){
		v1 <- dnorm( nodes, mean=pars$b[ii], sd=1 )
		wgtM[ii,] <- v1/sum(v1)
	}
	rmsd_b <- sqrt( rowSums( ( probs_obs - probs_exp )^2 * wgtM ) )
	md_b <- rowSums( ( probs_obs - probs_exp ) * wgtM )
	
	# item-information weighted RMSD
	wgtM <- 0*probs_obs
	probs1 <- mod$rprobs[,2,]	
	ii <- 1
	for (ii in 1:I){
		v1 <- probs1[ii,]*(1-probs1[ii,])
		wgtM[ii,] <- v1/sum(v1)
	}
	rmsd_info <- sqrt( rowSums( ( probs_obs - probs_exp )^2 * wgtM ) )
	md_info <- rowSums( ( probs_obs - probs_exp ) * wgtM )	

	res <- list( rmsd_dist=rmsd_dist, rmsd_unif=rmsd_unif, rmsd_b=rmsd_b,
					rmsd_info=rmsd_info,
					md_dist=md_dist, md_unif=md_unif, md_b=md_b,
					md_info=md_info)
					
	return(res)					

}