---
title: "Curator guide"
linkTitle: "Curator guide"
weight: 2
editor_options:
  markdown:
    wrap: 72
---

## How Curating Works

_Prior to your curation_:

- Sign up to be a curator on [this
  form](https://airtable.com/appjkZZgtF0iEWFjx/pagqsAma1WmUYxa9j/form).

- After the RoCur admins review your submission, the [RoCur
  schedule](https://airtable.com/appZpj9RYelJ9dbKS/shriGUNeVRW92458K/tblP0NksI30Axy7JJ)
  will be updated accordingly to include your upcoming curation.

-   1 week before your curation, RoCur admins will send you more info on
    curating and ask you to review the [Curating Agreement] as well as
    approve a graphic that will be used to promote your account
    takeover. They will also offer you the option to use
    [Buffer](https://buffer.com/) during your curation. Buffer is a
    social media toolkit that lets you schedule content and plan posts.

- The Sunday before your curation, you will receive an app password,
  which will serve as your temporary credential to log into the [We
  Are R-Ladies Bluesky
  account](https://bsky.app/profile/weare.rladies.org).

_During your curation_:

- Each rotating curation (RoCur) begins on **Monday at [11:00 AM
  UTC](https://www.timebie.com/std/universal.php?q=11)** and ends on
  the following **Saturday at** [**4:00 PM
  UTC**](https://www.timebie.com/std/universal.php?q=16).

- During the curation, the avatar of the We Are R-Ladies Bluesky
  account will be set to a photo of you. The admins will update the
  account profile accordingly.

- If applicable, your personal Bluesky handle will also appear in the
  bio of the We Are R-Ladies Bluesky account. You do not need to have
  a Bluesky account prior to curating.

- Your first post should serve as an introduction to the account
  followers. This could include details such as what you do for work,
  how you use R, etc.

- While we do not require curators to post a specific number of times,
  we ask that you be as active as possible during your curation.

_After your curation_:

- The following Sunday, RoCur admins will remove the your access to
  the We Are R-Ladies Bluesky account, enabling the next curator to
  take over.

## Pre-curation Week Checklist

The goal of this checklist is to ease both the technical and
content-related aspects of curation in advance of your assigned week.
**We strongly encourage you to complete this checklist one week prior to
your curation.** This way, you will have time to ping the #rocur channel
of the R-Ladies Community Slack if any questions arise.

1.  [ ] Post from your personal Bluesky account.

2.  [ ] If you have expressed interest in using Buffer to create and
    schedule your posts, start by logging into the platform and getting
    familiar with its interface. You can also review [this helpful
    guide](https://support.buffer.com/article/855-using-bluesky-with-buffer)
    on connecting Buffer with Bluesky.

3.  [ ] Post an image with alternative text (again, from your personal
    Bluesky account).

    - _See [FAQ](https://guide.rladies.org/rocur/faq/) for more
      details._
    - Check out [this
      article](https://accessibility.huit.harvard.edu/describe-content-images)
      on writing helpful Alt Text by Digital Accessibility at Harvard
      or [this Medium
      post](https://medium.com/nightingale/writing-alt-text-for-data-visualization-2a218ef43f81)
      on writing Alt Text for data visualization.
      
4.  [ ] Read at least one artifact from previous curators. See [Work
    From Previous Curators] *for a list.*

5.  [ ] Create a list of topics you hope to post about during your
    curation.

    - Most curators agree that doing some brainstorming before your
      curation week can be incredibly helpful!

## Curating Agreement

**_By signing on to be a curator of the We Are R-Ladies Bluesky account,
you agree to the following:_**

1.  Abide by the R-Ladies' [Code of Conduct](https://rladies.org/coc/)
    in all activities and interactions on the We Are R-Ladies Bluesky
    account.

2.  Be responsible for all content posted throughout your designated
    week. RoCur admins will take action if your posts contain racist,
    sexist, homophobic, or any other harmful content.

3.  Refrain from using obscene or abusive language.

4.  Use inclusive language when addressing the audience. Consider using
    words like _all_, _everybody_, _y'all_, and _folks_ since not every
    member of R-Ladies identifies as female.

5.  Be the sole poster of the We Are R-Ladies Bluesky account during
    your assigned week.

6.  Do not actively promote or advertise any business or receive
    remuneration from a third party to do so. _See [Promotional Posting]
    for more details._

7.  Do not change the display name, avatar, banner image, or bio of the
    We Are R-Ladies Bluesky account, unless asked directly to do so.

8.  Do not follow, unfollow, or block any users from the account.
    Additionally, do not engage with individuals via direct messages.

    _However, if you experience abuse while contributing, you may block
    the offender. In such cases, alert the RoCur admins by emailing
    [weare\@rladies.org](mailto:weare@rladies.org) or posting in the
    R-Ladies Community Slack, including the offender's handle and a
    description of the incident._

9.  At the end of your curation, your access will be revoked to the We
    Are R-Ladies Bluesky account from any applications you may have
    authorized.

10. Prior to the curation, submit a profile picture and a brief
    biography to be used on the We Are R-Ladies Bluesky account.

RoCur admins reserve the right to warn or revoke the access of anyone
who violates any of the above rules or Bluesky's [Terms of
Service](https://bsky.social/about/support/tos).

## Promotional Posting

**_It is not permitted to promote companies, businesses, or services
through the We Are R-Ladies Bluesky account._**

On this account, promoting a company, business, or service is broadly
defined as any instance where any entity receives financial remuneration
from the Bluesky post. This includes:

- If you, the curator, receives remuneration for posting about a
  specific company, business, or service (e.g., referral links).

- If an organization, company, or individual profits from individuals
  using their services.

- If the post actively solicits account followers to partake in
  services where an entity receives monetary gain.

Examples of promotional posts that are not allowed include:

- _“Buy this book about time series analysis in R!”_
- _“Here's an online course that could be helpful. There's a fee to
  access it.”_

We encourage curators to share free and openly available tools with the
audience and communicate personal experiences about using specific
resources without promoting or soliciting on behalf of any particular
company, business or service. This includes:

- Discussing how you use R at work: _"As a data analyst at [company
  name], I use R to create reports."_

- Posting about an open-source package that you have used and why it
  was helpful: _"A great package for data visualization in R is
  [package name]. If I want to create a plot to show the relationship
  between numeric variables, [function name] is particularly useful!"_

- Sharing free, openly available resources that you have used to learn
  R and explaining what you liked and disliked about it: _"My first
  introduction to linear regression was this blog post: [URL]. I
  appreciated how clear the examples were, but I found the theory
  section a bit difficult to follow at first."_

## Posting Tips

#### Introduce Yourself

Start your curation by introducing yourself to the account followers:

- This could include details such as what you do for work, how you use
  R, your hobbies, etc.

- You could also share a URL to your personal website, GitHub, or
  other relevant profiles.

- If the photo on the We Are R-Ladies Bluesky account differs from
  your personal Bluesky account, you might want to post the latter.

#### General Posting Guidelines

- We do not require you to post a specific number of times; however,
  we ask that you be as active as possible during your curation.

  - We completely understand if you are no longer able to curate
    during your scheduled week. Please notify us by emailing
    [weare\@rladies.org](mailto:weare@rladies.org) as soon as you
    know you are unable to curate. We highly encourage you to
    reschedule your curation to another week!

- The content of your posts is entirely up to you! However, keep it
  relevant to R and/or R-Ladies. Make the account and its posts useful
  for learning.

- Pictures are great, but make sure to [add alternative
  text](https://youtu.be/RE-iJRXUmTM?si=FbYJEYOsXDET8KlJ) to make them
  accessible to people who use screen readers.

  - Posting photos from R-Ladies Meetup events or other R-related
    get-togethers is highly encouraged.

  - Please ensure proper attribution for your photos by obtaining
    permission from the original owner, and tagging them when
    applicable.

  - Tag individuals in the images if applicable.

- Similarly, add alternative text to GIFs.

- Use hashtags! _See [Posting About R] for more details._

- Have fun! 😃

#### Posting About R

##### Potential Topics

- If you belong to an R-Ladies chapter, highlight a project that your
  local chapter is working on.

- Share articles, blog posts, etc. relevant to your work or interests
  in R.

- Tell us something that you just learned in R.

- Inform the audience about your current R project, sharing a brief
  description, a line of code, or a link to your GitHub repo.

##### Include links

- When mentioning a package, add a link to its
  CRAN/BioConductor/GitHub repo:

  - If available, mention the Bluesky account of the maintainer(s)
    unless they are already widely known (i.e., it is not necessary
    to tag Hadley Wickham when mentioning ggplot2).

- The same applies to courses, books, etc.; include the URL whenever
  possible.

##### Use hashtags

- Whenever relevant, use the
  [#rladies](https://bsky.app/search?q=rladies) hashtag.

- Use the [#rstats](https://bsky.app/search?q=rstats) hashtag when
  sharing something that might be useful for the greater R community.
  Avoid overusing it to prevent cluttering the hashtag timeline. We do
  not want others silencing or blocking this account!

- Other R-related hashtags include
  [#dataviz](https://bsky.app/search?q=dataviz),
  [#rspatial](https://bsky.app/search?q=rspatial), and
  [#opendata](https://bsky.app/search?q=opendata).

- You could also hashtag package names, the location of your R-Ladies
  chapter, etc.

#### Interacting With Your Audience

- One goal of the We Are R-Ladies Bluesky account is to maintain a
  strong R-Ladies community on the platform! Therefore, please respond
  to users who interact with the account.

- If someone asks a question, we recommend replying with a quote post
  so others can see the original post.

##### Audience Engagement Ideas

- Post a question about something you are having trouble with in R –
  our community is all about helping and supporting each other!

- Ask for R package or dataset recommendations for your a project you
  are working on.

#### Your Last Post

Consider using the last post of your curation as a way to "sign off."
You could do approach this by:

- Mentioning that your curation week is ending and that this post will
  be your last

- Highlighting one key takeaway

- If applicable, writing acknowledgements

- Encouraging followers to connect with you on your personal Bluesky
  account or other platforms like GitHub or Linkedin

A sample sign-off:

> \_My week curating has come to a close! Thank you for following along
> and discussing [list topics mentioned during curation]. Special thanks
> to my fellow R-Lady [their Bluesky handle], who encouraged me to
> curate! You can stay in touch by following me at [your Bluesky
>
> > handle]."\_

## Work From Previous Curators

We deeply appreciate our past curators for their hard work in building
our former community on Twitter. Many of them have also written blog
posts and given talks reflecting on their curating experience.

### On curating for @WeAreRLadies

-   [Curating R-Ladies \@weare.rladies.org Bluesky account](https://medium.com/@simisani.ndaba013/curating-r-ladies-weare-rladies-org-bluesky-account-655b04f49c21):
    blog post by Simisani Ndaba, Feb 26, 2025

-   [Curating R-Ladies' Twitter Account - A Fun Ride!](https://cosimameyer.com/post/curating-r-ladies-twitter-account-a-fun-ride/):
    blog post by Cosima Meyer, Sep 18, 2022

-   [Curating for \@WeAreRLadies](https://nrennie.rbind.io/blog/2022-01-18-curating-for-wearerladies/):
    blog post by Nicola Rennie, Jan 18, 2022

-   [Be great and curate! Tips and outcomes from an \@WeAreRLadies Twitter curator](https://www.pipinghotdata.com/talks/2021-10-07-be-great-and-curate/): 
    poster presentation by Shannon Pileggi, Oct 7, 2021

-   [Curating for \@WeAreRLadies on Twitter: From creating content to cultivating connections](https://www.pipinghotdata.com/posts/2021-09-23-curating-for-wearerladies-on-twitter/):
    blog post by Shannon Pileggi, Sep 23, 2021

### Looking at data from @WeAreRLadies

- Katherine Simeon's [lightning talk](https://www.youtube.com/watch?v=nzmkYUr0wS0) at
  rstudio::conf(2020) - Jan 30, 2020

- Megan Stodel's blog post series looking at @WeAreRLadies data:

    -   [Hashtag Analyses](https://www.meganstodel.com/posts/hashtag/) - Nov 15, 2020
    -   [Tweet Timing](https://www.meganstodel.com/posts/tweet-timing/) - Nov 2, 2020
    -   [Analyzing Twitter Data](https://www.meganstodel.com/posts/analysing-twitter-data/) - Oct 24, 2020
        
_If you have written any blog posts, given any talks, or analyzed any
data in relation to R-Ladies RoCur, please add your links via pull
request!_
