---
title: "FAQ"
linkTitle: "FAQ"
weight: 3
---

Please read our [Curator Guide](/rocur/guide) for specific information on your role as a curator.

_The following instructions are for navigating through 🦋 Bluesky as RoCur is currently running on there._

## Frequently Asked Questions

### 1. How do I start my first post as @weare.rladies.org?

-   Log on to Bluesky from your web browser, iPhone or Android app with `weare.rladies.org` as the username and the app password you received via email from the RoCur admins as the password. Refer to the screenshot below:

![Bluesky sign in page. Hosting provider is set to Bluesky Social.](login.png)

-   Click the "New Post" button in the bottom left hand corner to get started on your curation.

![The "New Post" button is located at the bottom of the navigation sidebar.](navigation_bar.png)

### 2. Can I add photos, emojis, GIFs and videos?

-   Yes - you can add up to 4 photos, a GIF, or a video.

### 3. How to delete a post?

Mistakes happen! First of all, don't panic 😊 Posts can be removed.

-   Navigate to the post you wish to delete.
-   Click on three-dot menu ("...") in the bottom right of the post.
-   Choose the "Delete post" option.

![Click on the post's three-dot menu to reveal the "Delete post" option.](delete_post.png)

### 4. As a curator, can I like other posts?

Yes! You can definitely like others' posts.

### 5. How to add polls?

You can use [poll.blue](https://bsky.app/profile/poll.blue) to make your own poll: <https://poll.blue/post>.<br> The page should look something like the image below. Make sure you use the `weare.rladies.org` handle when creating the poll.

![poll.blue web app to create a poll on Bluesky.](polls.png)

### 6. How do you pin a post to the @weare.rladies.org profile?

If you want to pin a post during your curation week, you can select the "Pin to your profile" option from the three-dot menu.<br> Please remember to remove this pin before the end of your curation.

![Click on the post's three-dot menu to reveal the "Pin post" option.](pin_post.png)

### 7. How do I add alternative text to images in my post?

When uploading an image in a post, a "+ ALT" button will appear at the top right of the image. Click on this button to add a description to your image as seen in the figure below:<br>

![Click on the "+ ALT" button to add a description.](add_alt_text.png)

Watch [this video](https://www.youtube.com/watch?v=RE-iJRXUmTM) for more information about image accessibility on Bluesky.<br>

### 8. How do I schedule a post on the We Are R-Ladies Bluesky channel?

These instructions assume you've already requested access to Buffer. If you haven't yet and would like access, please contact an admin to set up an account. There are a few ways to schedule posts, but here's one straightforward method:

1.  Log into Buffer.

2.  Click on your profile icon (top right), then ensure that the **R-Ladies** workspace is selected.

3.  In the **Publish** tab, find the **Channels** list and select the **We Are R-Ladies Bluesky** channel.

![](buffer_01.png)

4.  Click the **+ New Post** button in the top-right corner.

![](buffer_02.png)

5.  Use the text field to write your post. You can also add images, links and other media. **If you're using Buffer during your curation week, skip to Step 8.**

6.  **Prior to your curation week**, you won't have posting permissions, but you can click on **Save as Draft** to save your work. You can also click **Set Time** to specify when the post will be published.

![](buffer_03.png)

7.  Just before your curation week, you'll be granted posting access. At that point, go to the **Drafts** tab, click on **Add to Queue** to add the post to the next available time slot in the posting schedule. If you want to edit the content or set a specific time for publication, click the **pencil icon**.

![](buffer_04.png)

8.  **To schedule or publish a post during your curation**, choosing one of the following options. To assess more scheduling options, click the drop-down arrow.

    -   **Add to Queue:** Adds the post to the next available time slot in the posting schedule.

    -   **Share Now:** Publishes the post immediately.

    -   **Share Next:** Schedules the post to be published next, bumping other scheduled posts down.

    -   **Schedule Post:** Allows you to choose a specific date and time for publication.

![](buffer_05.png)

### **9. Are there any limitations to using Buffer?**

As of April 2025:

1.  You can't respond to replies directly from Buffer!
2.  There's no built-in tool for searching and adding GIFs. You'll need to look up GIFs separately and drag and drop them into the post draft.
3.  Unfortunately, there's no feature for adding alt text to GIFs.
4.  When typing "\@" to mention someone, there's no drop-down suggestions for Bluesky handles. You'll need to double-check the handle name on Bluesky to ensure accuracy.

In summary, if your posts are mostly text and static images, Buffer works well. However, for posts including other media, you might prefer drafting in Buffer and then manually copy and pasting into Bluesky's built-in posting feature.

Big thanks to [Irena Papst](https://papsti.github.io/) for sharing concrete examples!

*If you have further inquiries that are not covered here, please send an email to [weare\@rladies.org](mailto:weare@rladies.org)*
