---
title: "RoCur details"
linkTitle: "Details"
weight: 1
---

## About

The [**R-Ladies RoCur (Rotating Curation)**](https://bsky.app/profile/weare.rladies.org) is a social media handle running on [Bluesky](https://bsky.app/) since 2025 that features an awesome R-Lady each week. This account is run by R-Ladies Global.

Previously, the WeAreRLadies Rotating Curation ran on X/Twitter from 2018 to 2022. Although this account has been deleted, an archive of these tweets is available at <https://rladies.org/tweet-archive/wearerladies/>.

## Objectives

1.  To encourage and maintain social media engagement within the R-Ladies community.
2.  To spotlight female and minority genders (including but not limited to cis/trans women; trans men; non-binary, genderqueer, agender individuals) and their great work in R.

## How It Works

Every week, a different R-Lady takes over our social media account to talk about the work they do in R. Featured curators come from a diversity of professions and have a range of experiences in R, from novice to expert.

If you are interested in becoming a curator, see our [Be a Curator!](#be-a-curator) section and [sign up here](https://rladies.org/form/rocur-signup/).

Check out [\@weare.rladies.org](https://bsky.app/profile/weare.rladies.org) every Monday for a new curator!

---

## Be a Curator!

We are always looking for R-users to be a featured curator for our account!

We welcome curators:

- of all experience levels
- of all professional backgrounds
- of all locations
- of any native language (curation may be conducted in any language; English is not required)

Featured curators must meet the following criteria:

- Curators must identify as a [gender minority](https://guide.rladies.org/about/mission/) (including but not limited to cis/trans women; trans men; non-binary, genderqueer, agender individuals).
- Curators do not need to be affiliated with R-Ladies; however, curators do need to register in the [R-Ladies directory](https://rladies.org/directory/) if they haven’t yet.
- Curators must be individuals (i.e., an R-Ladies chapter cannot be a featured curator; however, an organizer from a local chapter may curate and tweet about chapter events).

By signing on to be a curator of \@weare.rladies.org you agree to our [Curating Agreement](https://guide.rladies.org/rocur/guide/#curating-agreement) that is outlined in our guide for RoCur curators.

## Curator Sign Up

Take a look at the [**Current curator schedule**](https://rladies.org/form/rocur-schedule/)

Want to curate for a week? Fill in the [**Curator sign up form**](https://rladies.org/form/rocur-signup/)

Please note:

- You will be asked to provide a first and second choice for week(s) you would like to curate.

- Curatorship begins each **Monday at [11:00 AM UTC](https://www.timebie.com/std/universal.php?q=11)** and ends the following **Saturday at [4:00 PM UTC](https://www.timebie.com/std/universal.php?q=16)**.

- Administrators will make all efforts to honor all scheduling requests but may ask that you be flexible as the administrators need to coordinate multiple schedules.

- To understand what your curation week and the weeks leading up to it will be like, take a look at the [_How Curating Works_](https://guide.rladies.org/rocur/guide/#how-curating-works) section of the guide for curators!

## Curator Nomination

Do you know an R-Lady who you think would be a great curator? We accept nominations for curators via our [nomination form](https://airtable.com/appFIBzsk2AxWlGMt/pagfezjuCxohikOOa/form).

Anyone is welcome to nominate curators - you do not need to be affiliated with R-Ladies to nominate an individual to curate for \@weare.rladies.org. Multiple nominations from a single nominator is also permitted. RoCur administrators will review nominations and invite nominees to curate.

## Repeat Curation

Individuals may sign up for repeat curation if it has been at least two years since their previous curation. Scheduling priority is given to new curators. For repeat curation, please complete the sign up form again so that we may capture any updated information about you.

## Contact Us

This RoCur is managed by R-Ladies Global members. You can email us at [WeAre\@rladies.org](mailto:WeAre@rladies.org) or at the **#rocur** channel on the [R-Ladies Community Slack](https://airtable.com/appJZFYABfCIdPYMR/pagw7FJB5tm2UQ55o/form).
