---
title: "Security"
linkTitle: "Security"
weight: 3
---

As organizers you will be responsible for accounts such as email and social media accounts.
Here are some steps that will help reduce the risk of someone's hacking into your account.

We also recommend reading ["Ten quick tips for staying safe online"](https://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1008563) by Danielle Smalls and Greg Wilson.

## Use a personal password manager!

For your personal use (for R-Ladies things and in general!), we strongly recommend using a personal password manager, be it a free one like [KeePass](https://keepass.info/) (with a back-up you'd set up on Dropbox or Google Drive) or [Bitwarden](https://bitwarden.com/), or a paid service like [1Password](https://1password.com/).

If you feel on the fence, ask other organizers or your friends about their experience with some password managers.

### Common password manager workflow

Password managers make it safe to store all your passwords in encrypted, safe storage.
You only need to remember the password to unlock your password manager, to get access to all your account passwords.

This means this "master password" needs to be safe, meaning:

- Be at least several words long (using phrases from shows/songs you like ight be a good way to go).
- Contain special characters and numbers.
- Be hard to guess, but easy for you to remember.
- Not used in _any other instance_.

### KeePass workflow

[KeePass](https://keepass.info/).

- save all your passwords in a KeePass database.
- have it backed-up on Dropbox or Google Drive.
- only learn two passwords: the one to decrypt the KeePass database, the one to your Google Drive account.

### Bitwarden workflow

Free for single person, or two person 'organisation' (i.e. ability to share certain passwords with a single other person).
Download the Desktop client and/or the extension/plugin for your browser of choice.
Choose a password you can remember for Bitwarden, and store all your passwords in there.
Also has biometrics integration for those using it.

### 1Password workflow

[1Password](https://1password.com/).

You can even share an account with family members.

## If possible use two-factor authentication (2FA)

You can secure accounts such as GitHub accounts, Twitter accounts with two-factor authentication (2FA).
It means that to log in into the account you will need both the password and your phone where you will be given a temporary code either by text message or via an app such as DuoMobile.

Make sure to save the recovery codes of 2FA in your personal password manager, and if relevant to share them with your team.

Note that apps like DuoMobile allow you to sync your account with GoogleDrive which can be very handy when changing phones for instance.

## Share passwords and 2FA recovery codes securely with co-organizers

Your chapter will have a bunch of passwords and 2FA recovery codes to share.
How to do that?

- You might try and apply for [1Password OSS free plan](https://github.com/1Password/1password-teams-open-source).
- You might use e.g. a dedicated KeePass database for the chapter passwords, and share the database via GoogleDrive, whilst you would all save the password to the KeePass database in your personal password manager.
