---
title: "Rules & Guidelines"
weight: 1
---


## R-Ladies Rules

-   **Free**: Public events run by R-Ladies are always offered free of
    charge to participants.
    
-   **R** **Language/Environment specific**: The contextual
    subject/domain scope of R-Ladies' diversity initiative is
    specifically the open source R community.

-   **Leadership, Mentorship, Membership, Presenters/Speakers &
    Prioritization of Underrepresented/Minority Genders**: In line
    with [R-Ladies' Mission Statement](https://rladies.org/about-us/mission/),
    community roles and
    participation is reserved and prioritised, respectively, for the
    genders who are currently underrepresented in the R community. As
    such, Leadership roles within R-Ladies communities, particularly
    Organiser and any Mentor roles, are to be held by people of a
    minority gender. If there exists sufficient choice to have
    Presenters/Speakers at R-Ladies who identify as a minority gender,
    this is the preferred option. However, the choice of
    Presenters/Speakers is up to the relevant local Organisers'
    discretion, depending on availability and potential value/learning
    opportunity of those who volunteer.

-   **Rules for Participation of Represented/Majority Gender**: In line
    with [R-Ladies' Mission Statement](https://rladies.org/about-us/mission/),
    the genders/identities which are
    not underrepresented in the R community are not within the scope
    of this diversity initiative. The known majority gender group, cis
    men, can participate in an R-Ladies' community within an
    appropriately designed framework, as per the relevant local
    Organisers' discretion, e.g., as an invited guest of/sponsored by
    a Member, as a full Member etc. The majority of the speakers at
    any R-Ladies chapter needs to be of a minority gender and there is
    a strong recommendation for maximum one cis-male speaker per
    event. Given this majority gender's dominance in the general R
    community, there is no obligation for R-Ladies to
    focus/provide/allow comparable support or engage with this
    majority identity, particularly at the expense of the target
    minority gender groups - as such, it is feasible to enable, for
    example, Meetup membership requests to require Organizer approval,
    and allowing only those identifying as the target minorities to
    join the R-Ladies.

    -   **Note**: Please do be aware of the relevant Equality
        Legislation in your jurisdiction, e.g the Equality Act 2010 in
        the UK, when designing participation frameworks for the
        majority gender, to ensure your procedures are not infringing
        local laws re. potential discrimination.

-   **R-Ladies Code of Conduct**: All members must follow the [Code of
    Conduct](/about/coc).

-   **Community-Driven administration, independent of External
    influences**: R-Ladies does not have permanent ties or links to
    external sponsors or parties. Appropriate sponsorship and support
    which does not seek to dictate or influence R-Ladies
    Mission-driven activities/decision-making but enhances the
    community's operations and impact is welcomed. Local R-Ladies
    Organisers are encouraged to gain appropriate support which does
    not compromise the community's independence.
    
-   **No commercial agenda**: Chapters are started by individuals, not by companies. 
    Chapters can partner with companies for sponsorship in the form of venue space, food or other supplies. Chapters and events may not be ‘used’ by a corporation/as a commercial vehicle for private aims. 
    This also means that speakers cannot give talks about paid products/services, 
    even if they don't work at the company offering the product/service.

## Chapters

Chapters are set up by R-Leaders (identifying as a minority gender) in
cities around the world. In this guide you will find information about
how to get started. Each R-Ladies chapter is expected to conduct themselves
in accordance with the following stipulations:

-   Use of the [Meetup](https://www.meetup.com/) platform
    to help organise and promote chapter events, with appropriate
    name, e.g. "R-Ladies \[Location\]"

-   Use of a social media accounts to help promote chapter events and
    publicise R-Ladies Global activities and news, with appropriate
    name, e.g. \@RLadies\[Location\]

-   Pro-active participation by chapter leaders in the R-Ladies
    Organizers Slack as the main centralised communication platform
    for R-Ladies community engagement, and collective decision-making.

-   Pro-active sharing of relevant learnings, conferences/events,
    resources, news, achievements, ideas, projects, and proposals via
    the R-Ladies Slack, social media, and
    [github](https://github.com/rladies) by chapter leaders.

Email `chapters@rladies.org` for inquiries about creating a new chapter or
reactivating a chapter that is currently inactive. If you are already a chapter
organizer, you can message on slack \#new\_chapters (or \#organisers) with any questions.

{{% notice tip %}}
Depending on the local context, folks might be used to only thinking about _women_ in tech.
Make sure to explain to participants that we include all gender minorities.
{{% /notice %}}
