---
title: "Social Media Guide for Chapters"
linkTitle: "Social Media"
weight: 1
---

> We love to raise our voices about the R-ladies community!

In this section we outline guidance for all social media channels, and specific guidance for Twitter and Facebook.
The global organization has a Twitter account but no official Facebook presence.

## General guidance for social media

### Should my chapter participate in social media?

Social media accounts are a commitment. However there are many benefits that come from creating an local R-Ladies Chapter account.

- Raising the voices of R-Ladies.
- Promoting R-Ladies activities.
- For chapter organisers and R-Ladies within the group, new opportunities and networks both locally and globally are shared and communicated.
- Finding R-Ladies around the world.
- Discovering R content.

### What social media?

- R-Ladies dominant social media channel is Twitter. We have a global Twitter account ([RLadiesGlobal](https://twitter.com/RLadiesGlobal)), and many R-Ladies chapters have their own Twitter account (e.g., [RLadiesLondon](https://twitter.com/RLadiesLondon)).
- However, Facebook is popular in some parts of the world, in particular Latin America. Example: [R-Ladies Santa Rosa on Facebook](https://www.facebook.com/pg/RLadiesSR).
- If your local community uses another tool, feel free to create a page/whatever an account is called there. It might even be a text message group, if that fits within the local culture and data protection rules (some people might not be at ease sharing their phone number).
  You might then want to contribute guidelines for this subsection based on your experience.

### Where to find R content to amplify

- \#rstats & \#rladies hashtag on Twitter.
- [R weekly newsletter](https://rweekly.org/)
- [Other sources](https://masalmon.eu/2019/01/25/uptodate/)

### How to create a social media account?

- Follow the guidance of the social media platform.
- Use your chapter [email address](/organization/tech/accounts/#e-mail).
- Submit the Twitter/Facebook/Instagram username to [the current chapters data](https://github.com/rladies/rladies.github.io/tree/main/data/chapters) so that it might get listed on the global website.

{{% notice warning %}}
Check out the section about [account security](/organization/tech/security/)
{{% /notice %}}

## Social Media and Accessibility

Using images and GIFs might be useful, but if you do so on e.g. Twitter, please add an [alternative description of the image](https://help.twitter.com/en/using-twitter/picture-descriptions) for folks who use screen readers.

If you use hashtags, use camel case e.g. `#awesomePackage` is better for screen reader users than `#awesomepackage`.

Do not use too many emojis at once as this might influence accessibility too.

If you create an infographic to promote an event, be sure to also post the information as alternative text or publication text or as an URL ("Find all information at `<url>`").

## Social media use guidelines and code of conduct:

- The chapter accounts should be used to promote:

  - The work (e.g. open source projects, blog posts, academic research) of individual R-Ladies.
  - R-Ladies events and announcements for your chapter; or online R-Ladies events.
  - Tutorials or R-related resources that you think are really great even if they’re not written by an R-Lady.

- We encourage posting photos from events as long as you got the ok of participants! (see example text in [Suggested Meetup alignment](/organization/tech/accounts/#meetup))
- We love images, animated gifs and emojis as a form of expression! :smile_cat:
- When using images and gifs make sure to use [alternative text for accessibility](https://help.twitter.com/en/using-twitter/picture-descriptions)!

- Do not use your chapter account as a personal account: no personal tweets or massive self-promotion
  - When writing a tweet or publication, do not use the word “I”, always use “we”
  - It’s okay to promote the #rstats related work/projects of R-Ladies, including yourself, just don’t over-do it and don’t promote work that’s not directly related to R or R-Ladies.
  - No selfies (we encourage group pictures instead).
- Do not make political statements with your chapter account. Please use your personal accounts for political speech.
  - Feminist or women-in-tech related topics are okay, but please stay away from traditional politics, as that can be divisive to the community and R-Ladies is a non-partisan organization.
- Do not promote products or any other commercial offerings.
  - Promoting open source R projects that are backed by a company (e.g., RStudio) is okay.
  - Thanking a meetup host/sponsor for their support is okay.
  - Only promote a book if its online version is freely available.
- Always speak positively about people’s work, e.g., “Tidyverse is awesome!” instead of “Tidyverse is better than base R!”

## Twitter

### Alignment

- Local Twitter handle (optional, but encouraged!) should also use the @RLadiesLocation format, for example: [@RLadiesSF](https://twitter.com/RLadiesSF) and [@RLadiesLondon](https://twitter.com/RLadiesSF). Please note that there is a 15-character limit on Twitter handles, so if your cityname is too long, we recommend using the airport code (or another abbreviation), such as [@RLadiesCDMX](https://twitter.com/RLadiesCDMX). The "name" on the account should be "R-Ladies Location". (e.g. [@RLadiesLondon](https://twitter.com/RLadiesLondon) and "R-Ladies London"). When you're logged in to the account, the [username (aka. handle) can be edited](https://twitter.com/settings/screen_name) and the [profile name can be edited](https://twitter.com/settings/profile).
- Important: Please use your chapter R-Ladies email address (e.g. yourcity@rladies.org) to set up Twitter and other social media accounts rather than a personal email address.
- Don't forget to add the [R-Ladies logo and the purple color](/organization/tech/brand/).
- A picture of your city or a picture from one of your meetups is recommended for the background image, but there's no strict guidelines around that.
- Link to your Meetup group page in the website field.

**Suggested Twitter Alignment**

- Bio of chapters : "R-Ladies \[Location\] is part of a world-wide
  organization to promote gender diversity in the R
  community...\[Any other text\]. \#RLadies \#rstats"
- If you have space left over in your bio add the
  [rladies.org](http://rladies.org/) hyperlink

### Management

- Please tag all your R-Ladies related tweets with the #rladies hashtag. This makes them searchable and more visible.
- On tagging \@RLadiesGlobal: please do that if you are referring to the global organisation. If you want to refer to R-Ladies in general, please use the hashtag. Otherwise you make [notifications of the global account harder to follow](/comm/twitter/).
- Please add further hashtags to \#rladies in the following situations: + If your chapter has a visitor from another chapter, please take a photo and share
  it on Twitter using the hashtag, \#rladiesvisits. + If you are tweeting about R-Ladies in Latin America, please consider adding \#RLadiesLatAm.
- You can find some inspiration here: https://twitter.com/gdequeiroz/lists/rladies-chapters/members
- [General introduction to Twitter for R users](https://www.t4rstats.com/)
- Feel free to retweet posts by others that promote R-Ladies’ work and events as well.
- You should use Twitter's feature of pinned tweets. You can pin one tweet at a time, it appears on your profile page at the top. E.g. pin the tweet about the next event.

## Facebook

Fan Page or a Profile?
Evaluate this based on the different functionalities between boths.
The profile has 5000 friends as a limit, the page doesn't have a limit of fans, the profile publication shows first in friend wall, the page publication aren't shown first, the fans have to configure this manually .

- Check that the name of the profile or page is @rladies [Location]
- In the information put: "R-Ladies [Location] is part of a global organization to promote gender diversity in the R community ... [Any other text]. #RLadies #rstats".
- Include the link to the group in Meetup.
- Add the hyperlink to rladies.org.
- Include local twitter account and @RLadiesGlobal twitter account
- Include local email account

## How to handle negative interactions on social media

If your chapter or personal account is attacked/criticized,

- Reach out to your support network, for instance other organizers in the organizers' Slack.
- You can choose to respond or not. A troll is not worth your energy but you might want to respond for educating others reading the exchange; however, it's important to save your energy.
- Use the features of the platform (Twitter, Facebook) to protect your account and energy (blocking & friends).
- If your chapter wrote something wrong or hurtful, please apologize.

### Specific to Twitter

- Twitter lets you [hide answers to a tweet of yours](https://help.twitter.com/en/using-twitter/mentions-and-replies) (so you can keep your threads clean of negative answers).
- To defend your account, can
  - [block](https://help.twitter.com/en/using-twitter/blocking-and-unblocking-accounts) an account,
  - [mute](https://help.twitter.com/en/using-twitter/twitter-mute) them,
  - report them (**you can ask others to also report a problematic account by writing in the organizers slack**),
  - "soft block" them: block then unblock them, this way they automatically stop following you.
- You might want to keep your chapter account DMs closed.
